/*
 * Decompiled with CFR 0.152.
 */
package flex2.linker;

import flash.swf.Frame;
import flash.swf.tags.FrameLabel;
import flex2.compiler.CompilationUnit;
import flex2.compiler.Source;
import flex2.compiler.common.FramesConfiguration;
import flex2.compiler.swc.SwcLibrary;
import flex2.compiler.swc.SwcScript;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.compiler.util.graph.Visitor;
import flex2.linker.CULinkable;
import flex2.linker.DependencyWalker;
import flex2.linker.Linkable;
import flex2.linker.LinkerConfiguration;
import flex2.linker.LinkerException;
import flex2.linker.SimpleMovie;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlexMovie
extends SimpleMovie {
    private List<FramesConfiguration.FrameInfo> frameInfoList;
    private List<FramesConfiguration.FrameInfo> configFrameInfoList;
    private String mainDef;
    private Set<String> externs;
    private Set<String> includes;
    private Set<String> unresolved;
    private SortedSet<String> resourceBundles;
    private Set<String> metadata;

    public FlexMovie(LinkerConfiguration linkerConfiguration) {
        super(linkerConfiguration);
        this.mainDef = linkerConfiguration.getMainDefinition();
        this.externs = new HashSet<String>(linkerConfiguration.getExterns());
        this.includes = new LinkedHashSet<String>(linkerConfiguration.getIncludes());
        this.unresolved = new HashSet<String>(linkerConfiguration.getUnresolved());
        this.generateLinkReport = linkerConfiguration.generateLinkReport();
        this.generateRBList = linkerConfiguration.generateRBList();
        this.resourceBundles = new TreeSet<String>(linkerConfiguration.getResourceBundles());
        this.frameInfoList = new LinkedList<FramesConfiguration.FrameInfo>();
        this.configFrameInfoList = new LinkedList<FramesConfiguration.FrameInfo>();
        this.configFrameInfoList.addAll(linkerConfiguration.getFrameList());
        this.metadata = new HashSet<String>();
    }

    private void prelink(List<CompilationUnit> units) throws LinkerException {
        HashMap<String, CompilationUnit> def2unit = new HashMap<String, CompilationUnit>();
        for (CompilationUnit unit : units) {
            FlexMovie.mapAll(def2unit, unit.topLevelDefinitions.getStringSet(), unit);
        }
        this.buildFrames(def2unit, this.mainDef, new HashSet<String>());
        this.frameInfoList.addAll(this.configFrameInfoList);
        if (this.frameInfoList.size() > 0) {
            this.topLevelClass = FlexMovie.formatSymbolClassName(this.frameInfoList.get((int)0).frameClasses.get(0));
        }
    }

    private boolean hasFrameClass(String queryClassName) {
        for (FramesConfiguration.FrameInfo frameInfo : this.frameInfoList) {
            for (String className : frameInfo.frameClasses) {
                if (!className.equals(queryClassName)) continue;
                return true;
            }
        }
        return false;
    }

    private void buildFrames(Map<String, CompilationUnit> def2unit, String className, Set<String> progress) throws LinkerException {
        if (this.hasFrameClass(className)) {
            return;
        }
        if (progress.contains(className)) {
            return;
        }
        progress.add(className);
        CompilationUnit unit = def2unit.get(className);
        if (unit == null) {
            throw new LinkerException.UndefinedSymbolException(className);
        }
        if (unit.loaderClass != null) {
            this.buildFrames(def2unit, unit.loaderClass, progress);
        }
        FramesConfiguration.FrameInfo info = new FramesConfiguration.FrameInfo();
        info.label = className.replaceAll("[^A-Za-z0-9]", "_");
        info.frameClasses.add(className);
        info.frameClasses.addAll(unit.resourceBundles);
        info.frameClasses.addAll(unit.extraClasses);
        this.frameInfoList.add(info);
    }

    @Override
    public void generate(List<CompilationUnit> units) throws LinkerException {
        try {
            this.prelink(units);
        }
        catch (LinkerException e) {
            ThreadLocalToolkit.log(e);
            throw e;
        }
        LinkedList<CULinkable> linkables = new LinkedList<CULinkable>();
        String serverConfigDef = null;
        CULinkable mainLinkable = null;
        for (CompilationUnit unit : units) {
            Source source = unit.getSource();
            String sourceName = source.getName();
            if (sourceName.equals("serverConfigData.as")) {
                serverConfigDef = unit.topLevelDefinitions.first().toString();
            }
            CULinkable linkable = new CULinkable(unit);
            if (unit.isRoot()) {
                mainLinkable = linkable;
            }
            if (source.isInternal()) {
                this.externs.addAll(unit.topLevelDefinitions.getStringSet());
            }
            linkables.add(linkable);
        }
        this.frames = new ArrayList();
        if (mainLinkable != null && serverConfigDef != null) {
            mainLinkable.addDep(serverConfigDef);
        }
        try {
            final HashSet librariesProcessed = new HashSet();
            int counter = 0;
            DependencyWalker.LinkState state = new DependencyWalker.LinkState(linkables, this.externs, this.includes, this.unresolved);
            Iterator<FramesConfiguration.FrameInfo> it = this.frameInfoList.iterator();
            while (it.hasNext()) {
                FramesConfiguration.FrameInfo frameInfo = it.next();
                final Frame f = new Frame();
                f.pos = ++counter;
                if (frameInfo.label != null) {
                    f.label = new FrameLabel();
                    f.label.label = frameInfo.label;
                }
                DependencyWalker.traverse(frameInfo.frameClasses, state, !it.hasNext(), !it.hasNext(), new Visitor<Linkable>(){

                    @Override
                    public void visit(Linkable o) {
                        SwcScript script;
                        SwcLibrary library;
                        CULinkable l = (CULinkable)o;
                        FlexMovie.this.exportUnitOnFrame(l.getUnit(), f, FlexMovie.this.lazyInit);
                        Source source = l.getUnit().getSource();
                        if (source.isSwcScriptOwner() && !source.isInternal() && !librariesProcessed.contains(library = (script = (SwcScript)source.getOwner()).getLibrary())) {
                            librariesProcessed.add(library);
                            FlexMovie.this.metadata.addAll(library.getMetadata());
                        }
                    }
                });
                this.frames.add(f);
            }
            if (this.generateLinkReport) {
                this.linkReport = DependencyWalker.dump(state);
            }
            if (this.generateRBList) {
                this.rbList = FlexMovie.dumpRBList(this.resourceBundles);
            }
            if (this.unresolved.size() != 0) {
                boolean fatal = false;
                for (String u : this.unresolved) {
                    if (this.externs.contains(u)) continue;
                    ThreadLocalToolkit.log(new LinkerException.UndefinedSymbolException(u));
                    fatal = true;
                }
                if (fatal) {
                    throw new LinkerException.LinkingFailed();
                }
            }
        }
        catch (LinkerException e) {
            ThreadLocalToolkit.log(e);
            throw e;
        }
    }

    public static String dumpRBList(Set<String> bundles) {
        StringBuilder b = new StringBuilder();
        b.append("bundles = ");
        for (String str : bundles) {
            b.append(str + " ");
        }
        return b.toString();
    }

    private static void mapAll(Map<String, CompilationUnit> map, Set keys, CompilationUnit val) {
        for (String defname : keys) {
            map.put(defname, val);
        }
    }

    public Set<String> getMetadata() {
        return this.metadata;
    }
}

