/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.builder;

import flex2.compiler.CompilationUnit;
import flex2.compiler.mxml.Attribute;
import flex2.compiler.mxml.MXMLNamespaces;
import flex2.compiler.mxml.MxmlConfiguration;
import flex2.compiler.mxml.builder.AbstractBuilder;
import flex2.compiler.mxml.builder.ArrayBuilder;
import flex2.compiler.mxml.builder.ComponentBuilder;
import flex2.compiler.mxml.builder.HTTPServiceBuilder;
import flex2.compiler.mxml.builder.InlineComponentBuilder;
import flex2.compiler.mxml.builder.ModelBuilder;
import flex2.compiler.mxml.builder.PrimitiveBuilder;
import flex2.compiler.mxml.builder.RemoteObjectBuilder;
import flex2.compiler.mxml.builder.VectorBuilder;
import flex2.compiler.mxml.builder.WebServiceBuilder;
import flex2.compiler.mxml.builder.XMLBuilder;
import flex2.compiler.mxml.builder.XMLListBuilder;
import flex2.compiler.mxml.dom.ArrayNode;
import flex2.compiler.mxml.dom.BindingNode;
import flex2.compiler.mxml.dom.CDATANode;
import flex2.compiler.mxml.dom.DeclarationsNode;
import flex2.compiler.mxml.dom.DesignLayerNode;
import flex2.compiler.mxml.dom.HTTPServiceNode;
import flex2.compiler.mxml.dom.InlineComponentNode;
import flex2.compiler.mxml.dom.LayeredNode;
import flex2.compiler.mxml.dom.LibraryNode;
import flex2.compiler.mxml.dom.MetaDataNode;
import flex2.compiler.mxml.dom.ModelNode;
import flex2.compiler.mxml.dom.Node;
import flex2.compiler.mxml.dom.PrimitiveNode;
import flex2.compiler.mxml.dom.PrivateNode;
import flex2.compiler.mxml.dom.RemoteObjectNode;
import flex2.compiler.mxml.dom.ReparentNode;
import flex2.compiler.mxml.dom.StateNode;
import flex2.compiler.mxml.dom.StyleNode;
import flex2.compiler.mxml.dom.VectorNode;
import flex2.compiler.mxml.dom.WebServiceNode;
import flex2.compiler.mxml.dom.XMLListNode;
import flex2.compiler.mxml.dom.XMLNode;
import flex2.compiler.mxml.gen.TextGen;
import flex2.compiler.mxml.lang.BindingHandler;
import flex2.compiler.mxml.lang.StandardDefs;
import flex2.compiler.mxml.lang.TextParser;
import flex2.compiler.mxml.lang.TypeCompatibility;
import flex2.compiler.mxml.lang.ValueNodeHandler;
import flex2.compiler.mxml.reflect.Assignable;
import flex2.compiler.mxml.reflect.Property;
import flex2.compiler.mxml.reflect.Type;
import flex2.compiler.mxml.reflect.TypeTable;
import flex2.compiler.mxml.rep.BindingExpression;
import flex2.compiler.mxml.rep.Model;
import flex2.compiler.mxml.rep.MxmlDocument;
import flex2.compiler.mxml.rep.Primitive;
import flex2.compiler.mxml.rep.Script;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.MxmlCommentUtil;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.QName;
import flex2.compiler.util.QNameSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentBuilder
extends ComponentBuilder
implements MXMLNamespaces {
    protected static final String rootAttrBackgroundColor = "backgroundColor";
    protected static final String rootAttrHeight = "height";
    protected static final String rootAttrStyleName = "styleName";
    protected static final String rootAttrWidth = "width";
    protected static final String specialAttrExclude = "excludeFrom";
    protected static final String specialAttrFrameRate = "frameRate";
    protected static final String specialAttrImplements = "implements";
    protected static final String specialAttrInclude = "includeIn";
    protected static final String specialAttrItemCPolicy = "itemCreationPolicy";
    protected static final String specialAttrItemDPolicy = "itemDestructionPolicy";
    protected static final String specialAttrLib = "lib";
    protected static final String specialAttrPageTitle = "pageTitle";
    protected static final String specialAttrPreloader = "preloader";
    protected static final String specialAttrRsl = "rsl";
    protected static final String specialAttrScriptRecursionLimit = "scriptRecursionLimit";
    protected static final String specialAttrScriptTimeLimit = "scriptTimeLimit";
    protected static final String specialAttrTheme = "theme";
    protected static final String specialAttrUsePreloader = "usePreloader";
    protected static final String specialAttrVersion = "version";
    private static final String DEFAULT_NAMESPACE = "";
    private static QNameSet specialAttributes2006 = new QNameSet(16);
    private static QNameSet specialAttributes2009;
    protected RootAttributeParser rootAttributeParser;
    protected NestedDeclarationNodeHandler nestedDeclarationNodeHandler;
    protected ComponentBuilder.ComponentDeclarationBindingHandler componentDeclarationBindingHandler;
    protected PrimitiveDeclarationBindingHandler primitiveDeclarationBindingHandler;
    private boolean generateLoader = true;
    private boolean inDeclaration = false;

    public DocumentBuilder(CompilationUnit unit, TypeTable typeTable, MxmlConfiguration mxmlConfiguration, MxmlDocument document) {
        super(unit, typeTable, mxmlConfiguration, document, null, null, null, false, null);
        this.childNodeHandler = new DocumentChildNodeHandler(typeTable);
        this.rootAttributeParser = new RootAttributeParser(typeTable);
        this.nestedDeclarationNodeHandler = new NestedDeclarationNodeHandler();
        this.componentDeclarationBindingHandler = new ComponentBuilder.ComponentDeclarationBindingHandler();
        this.primitiveDeclarationBindingHandler = new PrimitiveDeclarationBindingHandler();
    }

    @Override
    public void analyze(Node node) {
        this.checkInvalidRootAttributes(node);
        if (this.mxmlConfiguration.getGenerateAbstractSyntaxTree()) {
            if (node.comment != null) {
                this.document.setComment(MxmlCommentUtil.commentToXmlComment(node.comment));
            }
        } else {
            this.document.setComment(node.comment);
        }
        Type type = this.nodeTypeResolver.resolveType(node, this.document);
        this.constructComponent(type, node.beginLine);
        this.document.setRoot(this.component);
        this.processAttributes(node, type);
        this.processChildren(node, type);
        this.document.resolveTwoWayBindings();
        this.document.postProcessStates();
        this.postProcessDesignLayers();
        if (this.unit.isRoot()) {
            this.rootPostProcess(node);
            for (BindingExpression bexpr : this.document.getBindingExpressions()) {
                this.document.addImport(bexpr.getDestinationTypeName(false), bexpr.getXmlLineNumber());
            }
        }
    }

    @Override
    public void analyze(LayeredNode node) {
        this.analyze((Node)node);
    }

    @Override
    public void analyze(MetaDataNode node) {
        CDATANode cdata = (CDATANode)node.getChildAt(0);
        if (cdata != null && cdata.image != null && node.getText().toString().indexOf("[Frame") != -1) {
            assert (this.unit.isRoot());
            this.generateLoader = false;
        }
    }

    @Override
    public void analyze(StyleNode node) {
        if (node.getStyleSheet() != null) {
            try {
                this.document.getStylesContainer().extractStyles(node.getStyleSheet(), true);
            }
            catch (Exception exception) {
                String message = exception.getLocalizedMessage();
                if (message == null) {
                    message = exception.getClass().getName();
                }
                this.logError(node, message);
            }
        }
    }

    @Override
    public void analyze(WebServiceNode node) {
        WebServiceBuilder builder = new WebServiceBuilder(this.unit, this.typeTable, this.mxmlConfiguration, this.document);
        node.analyze(builder);
    }

    @Override
    public void analyze(HTTPServiceNode node) {
        HTTPServiceBuilder builder = new HTTPServiceBuilder(this.unit, this.typeTable, this.mxmlConfiguration, this.document);
        node.analyze(builder);
    }

    @Override
    public void analyze(RemoteObjectNode node) {
        RemoteObjectBuilder builder = new RemoteObjectBuilder(this.unit, this.typeTable, this.mxmlConfiguration, this.document);
        node.analyze(builder);
    }

    @Override
    public void analyze(BindingNode node) {
        BindingExpression bindingExpression;
        Object value;
        boolean isTwoWayBind = false;
        String source = (String)node.getAttributeValue("source");
        if (source == null) {
            this.log(node, (CompilerMessage)new MissingAttribute("source"));
            return;
        }
        String destination = (String)node.getAttributeValue("destination");
        if (destination == null) {
            this.log(node, (CompilerMessage)new MissingAttribute("destination"));
            return;
        }
        String twoWay = (String)node.getAttributeValue("twoWay");
        if (twoWay != null && (value = this.rootAttributeParser.parseBoolean(twoWay, node.beginLine, "twoWay")) != null) {
            isTwoWayBind = (Boolean)value;
        }
        if ((value = this.textParser.parseValue(source, this.typeTable.stringType, 0, node.beginLine, "source")) instanceof BindingExpression) {
            bindingExpression = (BindingExpression)value;
            if (bindingExpression.isTwoWayPrimary()) {
                this.log(node, (CompilerMessage)new AbstractBuilder.TwoWayBindingNotAllowedInitializer("source", source));
            } else if (isTwoWayBind) {
                this.log(node, (CompilerMessage)new AbstractBuilder.BindingNotAllowedInitializer("source", source));
            }
        } else {
            bindingExpression = new BindingExpression((String)value, node.beginLine, this.document);
        }
        bindingExpression.setDestinationProperty(destination);
        bindingExpression.setDestinationLValue(destination);
        bindingExpression.setFromBindingNode(true);
        value = this.textParser.parseValue(destination, this.typeTable.stringType, 0, node.beginLine, "destination");
        if (value instanceof BindingExpression) {
            bindingExpression = (BindingExpression)value;
            if (bindingExpression.isTwoWayPrimary()) {
                this.log(node, (CompilerMessage)new AbstractBuilder.TwoWayBindingNotAllowedInitializer("destination", destination));
            } else {
                this.log(node, (CompilerMessage)new AbstractBuilder.BindingNotAllowedInitializer("destination", destination));
            }
        }
        if (isTwoWayBind) {
            BindingExpression bindingExpression2 = new BindingExpression(destination, node.beginLine, this.document);
            source = TextGen.stripParens(bindingExpression.getSourceExpression());
            bindingExpression2.setDestinationProperty(source);
            bindingExpression2.setDestinationLValue(source);
            bindingExpression2.setFromBindingNode(true);
        }
    }

    @Override
    protected int checkTypeCompatibility(Node node, Type lvalueType, Type lvalueArrayElementType, String lvalueDescription, boolean rvalueIsSingleton, boolean isDefaultProperty) {
        Type rtype = this.nodeTypeResolver.resolveType(node, this.document);
        String rvalueTypeName = rtype != null ? rtype.getName() : node.getLocalPart();
        int compat = TypeCompatibility.check(lvalueType, lvalueArrayElementType, rtype, rvalueIsSingleton, this.standardDefs);
        compat = this.coerceStatefulNodes(node, lvalueType, compat);
        switch (compat) {
            case 0: 
            case 1: 
            case 2: {
                return compat;
            }
            case 3: {
                if (isDefaultProperty) {
                    this.log(node.beginLine, (CompilerMessage)new AbstractBuilder.TypeNotAssignableToDefaultProperty(lvalueDescription, NameFormatter.toDot(rvalueTypeName), NameFormatter.toDot(lvalueType.getName())));
                } else {
                    this.log(node.beginLine, (CompilerMessage)new AbstractBuilder.TypeNotAssignableToLType(lvalueDescription, NameFormatter.toDot(rvalueTypeName), NameFormatter.toDot(lvalueType.getName())));
                }
                return compat;
            }
            case 4: {
                if (isDefaultProperty) {
                    this.log(node.beginLine, (CompilerMessage)new AbstractBuilder.DefaultPropertyNotMultiple(lvalueDescription, NameFormatter.toDot(lvalueType.getName())));
                } else {
                    this.log(node.beginLine, (CompilerMessage)new AbstractBuilder.TypeNotMultiple(lvalueDescription, NameFormatter.toDot(lvalueType.getName())));
                }
                return compat;
            }
            case 5: {
                if (isDefaultProperty) {
                    this.log(node.beginLine, (CompilerMessage)new SingleRValueNestedDeclaration(node.getLocalPart(), NameFormatter.toDot(lvalueType.getName()), NameFormatter.toDot(lvalueArrayElementType.getName())));
                } else {
                    this.log(node.beginLine, (CompilerMessage)new AbstractBuilder.SingleRValueNotTargetTypeOrTargetElementType(lvalueDescription, NameFormatter.toDot(rvalueTypeName), NameFormatter.toDot(lvalueType.getName()), NameFormatter.toDot(lvalueArrayElementType.getName())));
                }
                return compat;
            }
            case 6: {
                if (isDefaultProperty) {
                    this.log(node.beginLine, (CompilerMessage)new MultiRValueNestedDeclaration(node.getLocalPart(), NameFormatter.toDot(lvalueType.getName()), NameFormatter.toDot(lvalueArrayElementType.getName())));
                } else {
                    this.log(node.beginLine, (CompilerMessage)new AbstractBuilder.MultiRValueNotElementType(lvalueDescription, NameFormatter.toDot(rvalueTypeName), NameFormatter.toDot(lvalueType.getName()), NameFormatter.toDot(lvalueArrayElementType.getName())));
                }
                return compat;
            }
        }
        assert (false);
        return compat;
    }

    @Override
    protected boolean isLegalLanguageNode(Node node) {
        Class<?> nodeClass = node.getClass();
        return super.isLegalLanguageNode(node) || nodeClass == MetaDataNode.class || nodeClass == StyleNode.class || nodeClass == BindingNode.class || this.isServiceNode(node);
    }

    protected boolean isServiceNode(Node node) {
        Class<?> nodeClass = node.getClass();
        return nodeClass == RemoteObjectNode.class || nodeClass == HTTPServiceNode.class || nodeClass == WebServiceNode.class;
    }

    @Override
    protected boolean isAllowedProperty(Property property) {
        return true;
    }

    @Override
    protected boolean isSpecialAttribute(String namespace, String localPart) {
        if (this.document.getVersion() < 4) {
            return specialAttributes2006.contains(namespace, localPart);
        }
        if (namespace.length() == 0) {
            namespace = "http://ns.adobe.com/mxml/2009";
        }
        return specialAttributes2009.contains(namespace, localPart);
    }

    protected Attribute getSpecialAttribute(Node node, String localPart) {
        Attribute attr = null;
        if (this.document.getVersion() < 4) {
            attr = node.getAttribute(DEFAULT_NAMESPACE, localPart);
        } else {
            attr = node.getAttribute(DEFAULT_NAMESPACE, localPart);
            if (attr == null) {
                attr = node.getAttribute(this.document.getLanguageNamespace(), localPart);
            }
        }
        return attr;
    }

    public void postProcessDesignLayers() {
        List<DesignLayerNode> layers = this.document.getLayerDeclarationNodes();
        for (DesignLayerNode node : layers) {
            if (this.document.getLayerModel(node) != null) continue;
            ComponentBuilder builder = new ComponentBuilder(this.unit, this.typeTable, this.mxmlConfiguration, this.document, this.component, null, null, true, null);
            node.analyze(builder);
        }
    }

    @Override
    protected void processSpecialAttributes(Node node) {
        if (this.unit.getSource().isRoot()) {
            this.parseRootAttributes(node);
        }
    }

    @Override
    protected void processVisualChild(Node node) {
        if (this.inDeclaration) {
            ComponentBuilder builder = new ComponentBuilder(this.unit, this.typeTable, this.mxmlConfiguration, this.document, this.component, null, null, true, null);
            node.analyze(builder);
        } else {
            super.processVisualChild(node);
        }
    }

    private static String buildSwfMetadata(Map<String, Object> varmap) {
        if (varmap == null || varmap.size() == 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer(50);
        buf.append("[SWF( ");
        boolean more = false;
        for (String var : varmap.keySet()) {
            Object val = varmap.get(var);
            if (more) {
                buf.append(", ");
            } else {
                more = true;
            }
            buf.append(var);
            buf.append("='");
            buf.append(val);
            buf.append("'");
        }
        buf.append(")]");
        return buf.toString();
    }

    private void parseRootAttributes(Node node) {
        Attribute lib;
        Attribute rsl;
        Attribute theme;
        Attribute preloader;
        Attribute usePreloader;
        String heightString;
        Object value;
        Attribute height;
        String widthString;
        Object value2;
        Attribute title;
        Attribute styleName;
        Object value3;
        Attribute bgcolor;
        Object value4;
        Attribute scriptTimeLimit;
        Object value5;
        Attribute scriptRecursionLimit;
        Object value6;
        TreeMap<String, Object> swfvarmap = new TreeMap<String, Object>();
        Attribute frameRate = this.getSpecialAttribute(node, specialAttrFrameRate);
        if (frameRate != null && (value6 = this.rootAttributeParser.parseUInt((String)frameRate.getValue(), frameRate.getLine(), specialAttrFrameRate)) != null) {
            swfvarmap.put(specialAttrFrameRate, value6.toString());
        }
        if ((scriptRecursionLimit = this.getSpecialAttribute(node, specialAttrScriptRecursionLimit)) != null && (value5 = this.rootAttributeParser.parseUInt((String)scriptRecursionLimit.getValue(), scriptRecursionLimit.getLine(), specialAttrScriptRecursionLimit)) != null) {
            swfvarmap.put(specialAttrScriptRecursionLimit, value5.toString());
        }
        if ((scriptTimeLimit = this.getSpecialAttribute(node, specialAttrScriptTimeLimit)) != null && (value4 = this.rootAttributeParser.parseUInt((String)scriptTimeLimit.getValue(), scriptTimeLimit.getLine(), specialAttrScriptTimeLimit)) != null) {
            swfvarmap.put(specialAttrScriptTimeLimit, value4.toString());
        }
        if ((bgcolor = node.getAttribute(DEFAULT_NAMESPACE, rootAttrBackgroundColor)) != null && (value3 = this.rootAttributeParser.parseColor((String)bgcolor.getValue(), bgcolor.getLine(), rootAttrBackgroundColor)) != null) {
            swfvarmap.put(rootAttrBackgroundColor, value3.toString());
        }
        if ((styleName = node.getAttribute(DEFAULT_NAMESPACE, rootAttrStyleName)) != null) {
            this.document.getCompilationUnit().styleName = (String)styleName.getValue();
        }
        if ((title = this.getSpecialAttribute(node, specialAttrPageTitle)) != null) {
            swfvarmap.put(specialAttrPageTitle, title.getValue());
        }
        Type nodeType = this.nodeTypeResolver.resolveType(node, this.document);
        boolean isApplication = StandardDefs.isApplication(nodeType);
        Attribute width = node.getAttribute(DEFAULT_NAMESPACE, rootAttrWidth);
        if (width != null && isApplication && (value2 = this.rootAttributeParser.parseNumberOrPercentage(widthString = width.getValue().toString(), width.getLine(), rootAttrWidth)) != null) {
            if (this.rootAttributeParser.wasPercentage()) {
                if (widthString.endsWith("%")) {
                    swfvarmap.put("widthPercent", widthString);
                } else {
                    swfvarmap.put("widthPercent", widthString + '%');
                }
                node.removeAttribute(new QName(width.getNamespace(), rootAttrWidth));
            } else {
                if (value2 instanceof Double) {
                    value2 = new Integer(((Double)value2).intValue());
                }
                swfvarmap.put(rootAttrWidth, value2);
            }
        }
        if ((height = node.getAttribute(DEFAULT_NAMESPACE, rootAttrHeight)) != null && isApplication && (value = this.rootAttributeParser.parseNumberOrPercentage(heightString = height.getValue().toString(), height.getLine(), rootAttrHeight)) != null) {
            if (this.rootAttributeParser.wasPercentage()) {
                if (heightString.endsWith("%")) {
                    swfvarmap.put("heightPercent", heightString);
                } else {
                    swfvarmap.put("heightPercent", heightString + '%');
                }
                node.removeAttribute(new QName(height.getNamespace(), rootAttrHeight));
            } else {
                if (value instanceof Double) {
                    value = new Integer(((Double)value).intValue());
                }
                swfvarmap.put(rootAttrHeight, value);
            }
        }
        if ((usePreloader = this.getSpecialAttribute(node, specialAttrUsePreloader)) != null && (value = this.rootAttributeParser.parseBoolean((String)usePreloader.getValue(), usePreloader.getLine(), specialAttrUsePreloader)) != null) {
            this.document.setUsePreloader((Boolean)value);
        }
        if ((preloader = this.getSpecialAttribute(node, specialAttrPreloader)) != null) {
            String preloaderString = (String)preloader.getValue();
            String preloaderClassName = TextParser.parseClassName(preloaderString);
            if (preloaderClassName != null) {
                this.document.setPreloader(preloaderString);
            } else {
                this.log(node, (CompilerMessage)new InvalidPreLoaderClassName(preloaderString));
            }
        }
        if (swfvarmap.size() > 0) {
            String metadata = DocumentBuilder.buildSwfMetadata(swfvarmap);
            Script script = new Script(metadata);
            this.document.addMetadata(script);
        }
        if ((theme = this.getSpecialAttribute(node, specialAttrTheme)) != null) {
            this.log(new ThemeAttributeError());
        }
        if ((rsl = this.getSpecialAttribute(node, specialAttrRsl)) != null) {
            this.log(new RslAttributeError());
        }
        if ((lib = this.getSpecialAttribute(node, specialAttrLib)) != null) {
            this.log(new LibAttributeError());
        }
    }

    private void rootPostProcess(Node node) {
        if (this.generateLoader) {
            this.generateLoaderInfo(node);
        } else {
            this.document.addMetadata(new Script("[Frame(extraClass=\"FlexInit\")]\n"));
        }
    }

    private void generateLoaderInfo(Node node) {
        String baseLoaderClass = this.document.getSuperClass().getLoaderClass();
        if (baseLoaderClass == null) {
            return;
        }
        this.unit.auxGenerateInfo = new HashMap<String, Object>();
        String generateInitClass = "_" + this.document.getClassName() + "_FlexInit";
        generateInitClass = generateInitClass.replaceAll("[^A-Za-z0-9]", "_");
        this.document.addMetadata(new Script("[Frame(extraClass=\"" + generateInitClass + "\")]\n"));
        baseLoaderClass = baseLoaderClass.replace(':', '.');
        String generateLoaderClass = "_" + this.document.getClassName() + "_" + baseLoaderClass;
        generateLoaderClass = generateLoaderClass.replaceAll("[^A-Za-z0-9]", "_");
        this.document.addMetadata(new Script("[Frame(factoryClass=\"" + generateLoaderClass + "\")]\n"));
        HashMap<String, Object> rootAttributeMap = new HashMap<String, Object>();
        Iterator<QName> it = node.getAttributeNames();
        while (it != null && it.hasNext()) {
            QName qname = it.next();
            String localPart = qname.getLocalPart();
            String value = (String)node.getAttributeValue(qname);
            value = value.replaceAll("\"", "\\\"");
            if (TextParser.isScopedName(localPart)) continue;
            rootAttributeMap.put(localPart, node.getAttributeValue(qname));
        }
        String windowClass = this.document.getClassName();
        if (this.document.getPackageName() != null && this.document.getPackageName().length() != 0) {
            windowClass = this.document.getPackageName() + "." + this.document.getClassName();
        }
        this.unit.auxGenerateInfo.put("baseLoaderClass", baseLoaderClass);
        this.unit.auxGenerateInfo.put("generateLoaderClass", generateLoaderClass);
        this.unit.auxGenerateInfo.put("windowClass", windowClass);
        this.unit.auxGenerateInfo.put("preloaderClass", this.document.getPreloader());
        this.unit.auxGenerateInfo.put(specialAttrUsePreloader, new Boolean(this.document.getUsePreloader()));
        this.unit.auxGenerateInfo.put("rootAttributes", rootAttributeMap);
    }

    private void checkInvalidRootAttributes(Node node) {
        Attribute idAttr = this.getLanguageAttribute(node, "id");
        if (idAttr != null) {
            this.log(node, idAttr.getLine(), new IdNotAllowedOnRoot());
        }
        if (this.getLanguageAttribute(node, specialAttrInclude) != null || this.getLanguageAttribute(node, specialAttrExclude) != null) {
            this.log(new StateAttrsNotAllowedOnRoot());
        }
        if (this.getLanguageAttribute(node, specialAttrItemCPolicy) != null || this.getLanguageAttribute(node, specialAttrItemDPolicy) != null) {
            this.log(new ItemPolicyNotAllowedOnRoot());
        }
    }

    static {
        specialAttributes2006.add(DEFAULT_NAMESPACE, specialAttrFrameRate);
        specialAttributes2006.add(DEFAULT_NAMESPACE, specialAttrImplements);
        specialAttributes2006.add(DEFAULT_NAMESPACE, specialAttrLib);
        specialAttributes2006.add(DEFAULT_NAMESPACE, specialAttrPageTitle);
        specialAttributes2006.add(DEFAULT_NAMESPACE, specialAttrPreloader);
        specialAttributes2006.add(DEFAULT_NAMESPACE, specialAttrRsl);
        specialAttributes2006.add(DEFAULT_NAMESPACE, specialAttrScriptRecursionLimit);
        specialAttributes2006.add(DEFAULT_NAMESPACE, specialAttrScriptTimeLimit);
        specialAttributes2006.add(DEFAULT_NAMESPACE, specialAttrTheme);
        specialAttributes2006.add(DEFAULT_NAMESPACE, specialAttrUsePreloader);
        specialAttributes2009 = new QNameSet(16);
        specialAttributes2009.add("http://ns.adobe.com/mxml/2009", specialAttrFrameRate);
        specialAttributes2009.add("http://ns.adobe.com/mxml/2009", specialAttrImplements);
        specialAttributes2009.add("http://ns.adobe.com/mxml/2009", specialAttrLib);
        specialAttributes2009.add("http://ns.adobe.com/mxml/2009", specialAttrPageTitle);
        specialAttributes2009.add("http://ns.adobe.com/mxml/2009", specialAttrPreloader);
        specialAttributes2009.add("http://ns.adobe.com/mxml/2009", specialAttrRsl);
        specialAttributes2009.add("http://ns.adobe.com/mxml/2009", specialAttrScriptRecursionLimit);
        specialAttributes2009.add("http://ns.adobe.com/mxml/2009", specialAttrScriptTimeLimit);
        specialAttributes2009.add("http://ns.adobe.com/mxml/2009", specialAttrTheme);
        specialAttributes2009.add("http://ns.adobe.com/mxml/2009", specialAttrUsePreloader);
        specialAttributes2009.add("http://ns.adobe.com/mxml/2009", specialAttrExclude);
        specialAttributes2009.add("http://ns.adobe.com/mxml/2009", specialAttrInclude);
        specialAttributes2009.add("http://ns.adobe.com/mxml/2009", specialAttrItemCPolicy);
    }

    public static class InvalidPreLoaderClassName
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -1419336460920873288L;
        public String className;

        public InvalidPreLoaderClassName(String className) {
            this.className = className;
        }
    }

    public static class ClearNotAllowed
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -307322186643423229L;
    }

    public static class EmbedNotAllowed
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -6247692654987565435L;
    }

    public static class LibAttributeError
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 6302777794984339496L;
    }

    public static class RslAttributeError
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 606263107981414356L;
    }

    public static class ThemeAttributeError
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 3082224489629723459L;
    }

    public static class MultiRValueNestedDeclaration
    extends NestedDeclaration {
        private static final long serialVersionUID = -2341988816922122622L;
        public String targetType;
        public String targetElementType;

        public MultiRValueNestedDeclaration(String declaration, String targetType, String targetElementType) {
            super(declaration, targetType);
            this.targetElementType = targetElementType;
        }
    }

    public static class SingleRValueNestedDeclaration
    extends NestedDeclaration {
        private static final long serialVersionUID = -2341988816922122621L;
        public String targetElementType;

        public SingleRValueNestedDeclaration(String declaration, String targetType, String targetElementType) {
            super(declaration, targetType);
            this.targetElementType = targetElementType;
        }
    }

    public static class NestedDeclaration
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -2341988816922122620L;
        public String declaration;
        public String targetType;

        public NestedDeclaration(String declaration, String targetType) {
            this.declaration = declaration;
            this.targetType = targetType;
        }
    }

    public static class LanguageNodeInDeclarationError
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 2738031782626560481L;
        public String image;

        public LanguageNodeInDeclarationError(String image) {
            this.image = image;
        }
    }

    public static class MissingAttribute
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -3356986862852847108L;
        public String attribute;

        public MissingAttribute(String attribute) {
            this.attribute = attribute;
        }
    }

    public static class ItemPolicyNotAllowedOnDecls
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -5448889747843880603L;
    }

    public static class ItemPolicyNotAllowedOnRoot
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -5448389747847880603L;
    }

    public static class StateAttrsNotAllowedOnDecls
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -5448289747843880603L;
    }

    public static class StateAttrsNotAllowedOnRoot
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -5448289747847880603L;
    }

    public static class IdNotAllowedOnRoot
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -2319051120793286922L;
    }

    public static class DefaultPropertyError
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 4064574335519417302L;
    }

    protected class RootAttributeParser
    extends AbstractBuilder.TextValueParser {
        protected RootAttributeParser(TypeTable typeTable) {
            super(typeTable);
        }

        public Object parseUInt(String text, int line, String name) {
            return this.parseValue(text, DocumentBuilder.this.typeTable.uintType, 0, line, name);
        }

        public Object parseColor(String text, int line, String name) {
            return this.parseValue(text, DocumentBuilder.this.typeTable.uintType, 4, line, name);
        }

        public Object parseNumberOrPercentage(String text, int line, String name) {
            return this.parseValue(text, DocumentBuilder.this.typeTable.numberType, 8, line, name);
        }

        public Object parseBoolean(String text, int line, String name) {
            return this.parseValue(text, DocumentBuilder.this.typeTable.booleanType, 0, line, name);
        }

        public Object embed(String text, Type type) {
            DocumentBuilder.this.log(this.line, new EmbedNotAllowed());
            return null;
        }

        public Object clear() {
            DocumentBuilder.this.log(this.line, new ClearNotAllowed());
            return null;
        }

        public Object bindingExpression(String converted) {
            DocumentBuilder.this.log(this.line, new AbstractBuilder.BindingNotAllowed());
            return null;
        }
    }

    protected static class PrimitiveDeclarationBindingHandler
    implements BindingHandler {
        protected PrimitiveDeclarationBindingHandler() {
        }

        public BindingExpression invoke(BindingExpression bindingExpression, Model dest) {
            bindingExpression.setDestination(dest);
            ((Primitive)dest).setValue(null);
            return bindingExpression;
        }
    }

    protected class NestedDeclarationNodeHandler
    extends ValueNodeHandler {
        protected NestedDeclarationNodeHandler() {
        }

        protected void componentNode(Assignable property, Node node, MxmlDocument document) {
            ComponentBuilder builder = new ComponentBuilder(DocumentBuilder.this.unit, DocumentBuilder.this.typeTable, DocumentBuilder.this.mxmlConfiguration, document, DocumentBuilder.this.component, null, null, true, DocumentBuilder.this.componentDeclarationBindingHandler);
            node.analyze(builder);
        }

        protected void arrayNode(Assignable property, ArrayNode node) {
            ArrayBuilder builder = new ArrayBuilder(DocumentBuilder.this.unit, DocumentBuilder.this.typeTable, DocumentBuilder.this.mxmlConfiguration, DocumentBuilder.this.document);
            node.analyze(builder);
        }

        protected void vectorNode(Assignable property, VectorNode node) {
            String type = (String)node.getAttribute("type").getValue();
            Type elementType = DocumentBuilder.this.typeTable.getType(NameFormatter.toColon(type));
            VectorBuilder builder = new VectorBuilder(DocumentBuilder.this.unit, DocumentBuilder.this.typeTable, DocumentBuilder.this.mxmlConfiguration, DocumentBuilder.this.document, null, null, elementType, true);
            node.analyze(builder);
        }

        protected void primitiveNode(Assignable property, PrimitiveNode node) {
            PrimitiveBuilder builder = new PrimitiveBuilder(DocumentBuilder.this.unit, DocumentBuilder.this.typeTable, DocumentBuilder.this.mxmlConfiguration, DocumentBuilder.this.document, DocumentBuilder.this.component, true, null, DocumentBuilder.this.primitiveDeclarationBindingHandler);
            node.analyze(builder);
        }

        protected void xmlNode(Assignable property, XMLNode node) {
            XMLBuilder builder = new XMLBuilder(DocumentBuilder.this.unit, DocumentBuilder.this.typeTable, DocumentBuilder.this.mxmlConfiguration, DocumentBuilder.this.document);
            node.analyze(builder);
            DocumentBuilder.this.registerModel(node, (Model)builder.xml, true);
        }

        protected void xmlListNode(Assignable property, XMLListNode node) {
            XMLListBuilder builder = new XMLListBuilder(DocumentBuilder.this.unit, DocumentBuilder.this.typeTable, DocumentBuilder.this.mxmlConfiguration, DocumentBuilder.this.document);
            node.analyze(builder);
            DocumentBuilder.this.registerModel(node, (Model)builder.xmlList, true);
        }

        protected void modelNode(Assignable property, ModelNode node) {
            ModelBuilder builder = new ModelBuilder(DocumentBuilder.this.unit, DocumentBuilder.this.typeTable, DocumentBuilder.this.mxmlConfiguration, DocumentBuilder.this.document, null);
            node.analyze(builder);
        }

        protected void inlineComponentNode(Assignable property, InlineComponentNode node) {
            InlineComponentBuilder builder = new InlineComponentBuilder(DocumentBuilder.this.unit, DocumentBuilder.this.typeTable, DocumentBuilder.this.mxmlConfiguration, DocumentBuilder.this.document, true);
            node.analyze(builder);
        }

        protected void reparentNode(Assignable property, ReparentNode node) {
            ComponentBuilder builder = new ComponentBuilder(DocumentBuilder.this.unit, DocumentBuilder.this.typeTable, DocumentBuilder.this.mxmlConfiguration, DocumentBuilder.this.document, DocumentBuilder.this.component, null, null, true, null);
            node.analyze(builder);
        }

        protected void stateNode(Assignable property, StateNode node) {
            ComponentBuilder builder = new ComponentBuilder(DocumentBuilder.this.unit, DocumentBuilder.this.typeTable, DocumentBuilder.this.mxmlConfiguration, DocumentBuilder.this.document, DocumentBuilder.this.component, null, null, true, null);
            node.analyze(builder);
        }

        protected void cdataNode(Assignable property, CDATANode node) {
            PrimitiveBuilder builder = new PrimitiveBuilder(DocumentBuilder.this.unit, DocumentBuilder.this.typeTable, DocumentBuilder.this.mxmlConfiguration, DocumentBuilder.this.document, DocumentBuilder.this.component, true, null, DocumentBuilder.this.primitiveDeclarationBindingHandler);
            node.analyze(builder);
        }

        protected void unknown(Assignable property, Node node) {
            assert (false) : "Unexpected node class in processNestedDeclaration: " + node.getClass();
        }
    }

    protected class DocumentChildNodeHandler
    extends ComponentBuilder.ComponentChildNodeHandler {
        DocumentChildNodeHandler(TypeTable typeTable) {
            super(typeTable);
        }

        protected void languageNode() {
            if (DocumentBuilder.this.document.getVersion() >= 4 && DocumentBuilder.this.isServiceNode(this.child)) {
                DocumentBuilder.this.log(this.child, (CompilerMessage)new NestedDeclaration(this.child.getLocalPart(), NameFormatter.toDot(((DocumentBuilder)DocumentBuilder.this).standardDefs.INTERFACE_IUICOMPONENT)));
            } else {
                super.languageNode();
            }
        }

        protected void dynamicProperty(String name, String state) {
            this.nestedDeclaration(false);
        }

        protected void defaultPropertyElement(boolean locError) {
            String mimeType = DocumentBuilder.this.document.getCompilationUnit().getSource().getMimeType();
            if (DocumentBuilder.this.document.getIsInlineComponent() || mimeType.equals("text/mxml") && DocumentBuilder.this.document.getVersion() >= 4 || mimeType.equals("text/fxg")) {
                super.defaultPropertyElement(locError);
            } else {
                super.nestedDeclaration(false);
            }
        }

        protected void nestedDeclaration() {
            String mimeType = DocumentBuilder.this.document.getCompilationUnit().getSource().getMimeType();
            if (mimeType.equals("text/mxml") && DocumentBuilder.this.document.getVersion() < 4) {
                super.nestedDeclaration();
            } else {
                Type childType = this.nodeTypeResolver.resolveType(this.child, DocumentBuilder.this.document);
                assert (childType != null) : "nested declaration node type == null, node = " + this.child.image;
                if (DocumentBuilder.this.standardDefs.isContainer(this.parentType) && DocumentBuilder.this.standardDefs.isIUIComponent(childType) && (mimeType.equals("text/mxml") && DocumentBuilder.this.document.getVersion() < 4 || this.parentType.getDefaultProperty() == null)) {
                    DocumentBuilder.this.processVisualChild(this.child);
                } else if (this.child instanceof ReparentNode) {
                    ComponentBuilder builder = new ComponentBuilder(DocumentBuilder.this.unit, this.typeTable, DocumentBuilder.this.mxmlConfiguration, DocumentBuilder.this.document, DocumentBuilder.this.component, null, null, true, null);
                    this.child.analyze(builder);
                } else if (DocumentBuilder.this.standardDefs.isContainer(this.parentType) && (childType.isAssignableTo(((DocumentBuilder)DocumentBuilder.this).standardDefs.CLASS_RADIOBUTTONGROUP) || childType.isAssignableTo(((DocumentBuilder)DocumentBuilder.this).standardDefs.CLASS_SPARK_RADIOBUTTONGROUP))) {
                    ComponentBuilder builder = new ComponentBuilder(DocumentBuilder.this.unit, this.typeTable, DocumentBuilder.this.mxmlConfiguration, DocumentBuilder.this.document, DocumentBuilder.this.component, null, null, true, null);
                    this.child.analyze(builder);
                } else if (DocumentBuilder.this.standardDefs.isSparkGraphic(childType)) {
                    DocumentBuilder.this.log(this.child, (CompilerMessage)new ComponentBuilder.SparkPrimitiveInHalo(this.child.getLocalPart(), this.parent.getLocalPart()));
                } else {
                    DocumentBuilder.this.log(this.child, (CompilerMessage)new NestedDeclaration(this.child.getLocalPart(), NameFormatter.toDot(((DocumentBuilder)DocumentBuilder.this).standardDefs.INTERFACE_IUICOMPONENT)));
                }
            }
        }

        protected void processNestedDeclaration(Type childType) {
            DocumentBuilder.this.nestedDeclarationNodeHandler.invoke(null, this.child, DocumentBuilder.this.document);
        }

        protected boolean validateNestedDeclarationAttrs(Node node) {
            String include = (String)DocumentBuilder.this.getLanguageAttributeValue(node, DocumentBuilder.specialAttrInclude);
            String exclude = (String)DocumentBuilder.this.getLanguageAttributeValue(node, DocumentBuilder.specialAttrExclude);
            String icpolicy = (String)DocumentBuilder.this.getLanguageAttributeValue(node, DocumentBuilder.specialAttrItemCPolicy);
            String idpolicy = (String)DocumentBuilder.this.getLanguageAttributeValue(node, DocumentBuilder.specialAttrItemDPolicy);
            if (include != null || exclude != null) {
                DocumentBuilder.this.log(node, new StateAttrsNotAllowedOnDecls());
                return false;
            }
            if (icpolicy != null || idpolicy != null) {
                DocumentBuilder.this.log(node, new ItemPolicyNotAllowedOnDecls());
                return false;
            }
            return true;
        }

        protected void invoke(Node parent, Type parentType, Node child) {
            if (child.getClass() == DeclarationsNode.class) {
                this.parent = parent;
                this.parentType = parentType;
                DocumentBuilder.this.inDeclaration = true;
                Iterator iter = child.getChildIterator();
                while (iter.hasNext()) {
                    this.child = (Node)iter.next();
                    if (!this.validateNestedDeclarationAttrs(this.child)) continue;
                    if (DocumentBuilder.this.isServiceNode(this.child)) {
                        super.languageNode();
                        continue;
                    }
                    if (DocumentBuilder.this.isLegalLanguageNode(this.child)) {
                        DocumentBuilder.this.log(this.child, new LanguageNodeInDeclarationError(this.child.image));
                        continue;
                    }
                    super.nestedDeclaration(false);
                }
                DocumentBuilder.this.inDeclaration = false;
            } else if (child.getClass() != LibraryNode.class && child.getClass() != PrivateNode.class) {
                super.invoke(parent, parentType, child);
            }
        }
    }

    protected class DocumentAttributeHandler
    extends ComponentBuilder.ComponentAttributeHandler {
        protected DocumentAttributeHandler() {
        }

        protected void dynamicProperty(String name, String state) {
            DocumentBuilder.this.unknownAttributeError(DocumentBuilder.DEFAULT_NAMESPACE, name, this.line);
        }
    }
}

