/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml;

import flash.util.FileUtils;
import flex2.compiler.AbstractSubCompiler;
import flex2.compiler.CompilationUnit;
import flex2.compiler.CompilerBenchmarkHelper;
import flex2.compiler.Source;
import flex2.compiler.SubCompiler;
import flex2.compiler.SymbolTable;
import flex2.compiler.Transcoder;
import flex2.compiler.as3.As3Configuration;
import flex2.compiler.as3.Extension;
import flex2.compiler.mxml.ImplementationCompiler;
import flex2.compiler.mxml.InterfaceCompiler;
import flex2.compiler.mxml.MxmlConfiguration;
import flex2.compiler.mxml.reflect.TypeTable;
import flex2.compiler.util.NameMappings;
import java.io.File;

public class MxmlCompiler
extends AbstractSubCompiler {
    private static final String ATTR_STATE = "MxmlState";
    private static final String COMPILER_NAME = "mxml";
    private static final int STATE_INTERFACE_PARSED = 0;
    private static final int STATE_INTERFACE_GENERATED = 1;
    private static final int STATE_IMPLEMENTATION_PARSED = 2;
    private static final int STATE_IMPLEMENTATION_GENERATED = 3;
    static final String DOCUMENT_INFO = "DocumentInfo";
    public static final String TYPE_TABLE = TypeTable.class.getName();
    static final String LINE_NUMBER_MAP = "LineNumberMap";
    static final String DELEGATE_UNIT = "DelegateUnit";
    static final String CHECK_NODES = "CheckNodes";
    private InterfaceCompiler intfc;
    private ImplementationCompiler implc;

    public MxmlCompiler(MxmlConfiguration mxmlConfiguration, As3Configuration ascConfiguration, NameMappings mappings, Transcoder[] transcoders) {
        this(mxmlConfiguration, ascConfiguration, mappings, transcoders, false);
    }

    public MxmlCompiler(MxmlConfiguration mxmlConfiguration, As3Configuration ascConfiguration, NameMappings mappings, Transcoder[] transcoders, boolean processComments) {
        this.intfc = new InterfaceCompiler(mxmlConfiguration, ascConfiguration, mappings, processComments);
        this.implc = new ImplementationCompiler(mxmlConfiguration, ascConfiguration, mappings, transcoders, processComments);
    }

    public String getName() {
        return COMPILER_NAME;
    }

    public boolean isSupported(String mimeType) {
        return this.implc.isSupported(mimeType);
    }

    public String[] getSupportedMimeTypes() {
        return this.implc.getSupportedMimeTypes();
    }

    public void addInterfaceCompilerExtension(Extension ext) {
        this.intfc.getASCompiler().addCompilerExtension(ext);
    }

    public void addImplementationCompilerExtension(Extension ext) {
        this.implc.getASCompiler().addCompilerExtension(ext);
    }

    public Source preprocess(Source source) {
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.startPhase(0, source.getNameForReporting());
        }
        Source result = null;
        result = source.getCompilationUnit() == null ? this.intfc.preprocess(source) : this.implc.preprocess(source);
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.endPhase(0);
        }
        return result;
    }

    public CompilationUnit parse1(Source source, SymbolTable symbolTable) {
        CompilationUnit unit;
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.startPhase(1, source.getNameForReporting());
        }
        if ((unit = source.getCompilationUnit()) == null) {
            unit = this.intfc.parse1(source, symbolTable);
            if (unit != null) {
                this.setState(unit, 0);
            }
        } else if (this.getState(unit) == 1 && (unit = this.implc.parse1(source, symbolTable)) != null) {
            this.advanceState(unit);
        }
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.endPhase(1);
        }
        return unit;
    }

    public void parse2(CompilationUnit unit, SymbolTable symbolTable) {
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.startPhase(2, unit.getSource().getNameForReporting());
        }
        this.getSubCompiler(unit).parse2(unit, symbolTable);
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.endPhase(2);
        }
    }

    public void analyze1(CompilationUnit unit, SymbolTable symbolTable) {
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.startPhase(3, unit.getSource().getNameForReporting());
        }
        this.getSubCompiler(unit).analyze1(unit, symbolTable);
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.endPhase(3);
        }
    }

    public void analyze2(CompilationUnit unit, SymbolTable symbolTable) {
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.startPhase(4, unit.getSource().getNameForReporting());
        }
        this.getSubCompiler(unit).analyze2(unit, symbolTable);
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.endPhase(4);
        }
    }

    public void analyze3(CompilationUnit unit, SymbolTable symbolTable) {
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.startPhase(5, unit.getSource().getNameForReporting());
        }
        this.getSubCompiler(unit).analyze3(unit, symbolTable);
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.endPhase(5);
        }
    }

    public void analyze4(CompilationUnit unit, SymbolTable symbolTable) {
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.startPhase(6, unit.getSource().getNameForReporting());
        }
        this.getSubCompiler(unit).analyze4(unit, symbolTable);
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.endPhase(6);
        }
    }

    public void generate(CompilationUnit unit, SymbolTable symbolTable) {
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.startPhase(7, unit.getSource().getNameForReporting());
        }
        this.getSubCompiler(unit).generate(unit, symbolTable);
        this.advanceState(unit);
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.endPhase(7);
        }
    }

    public void postprocess(CompilationUnit unit, SymbolTable symbolTable) {
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.startPhase(8, unit.getSource().getNameForReporting());
        }
        this.getSubCompiler(unit).postprocess(unit, symbolTable);
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.endPhase(8);
        }
    }

    private int getState(CompilationUnit unit) {
        assert (unit.getContext().getAttribute(ATTR_STATE) != null) : "unit lacks MxmlState attribute";
        return (Integer)unit.getContext().getAttribute(ATTR_STATE);
    }

    private void setState(CompilationUnit unit, int state) {
        unit.getContext().setAttribute(ATTR_STATE, new Integer(state));
    }

    private void advanceState(CompilationUnit unit) {
        int state = this.getState(unit);
        assert (state < 3) : "advanceState called with state == " + state;
        this.setState(unit, state + 1);
    }

    private SubCompiler getSubCompiler(CompilationUnit unit) {
        return this.getState(unit) < 2 ? this.intfc : this.implc;
    }

    static String getGeneratedName(MxmlConfiguration mxmlConfiguration, String packageName, String className, String suffix) {
        String dir = mxmlConfiguration.getGeneratedDirectory();
        if (packageName != null && packageName.length() > 0) {
            dir = FileUtils.addPathComponents((String)dir, (String)packageName.replace('.', File.separatorChar), (char)File.separatorChar);
        }
        return FileUtils.addPathComponents((String)dir, (String)(className + suffix), (char)File.separatorChar);
    }

    public void initBenchmarks() {
        super.initBenchmarks();
        this.benchmarkEmbeddedHelper = new CompilerBenchmarkHelper(this.getName());
        this.benchmarkEmbeddedHelper.initBenchmarks();
        this.intfc.setHelper(this.benchmarkEmbeddedHelper, true);
        this.implc.setHelper(this.benchmarkEmbeddedHelper, true);
    }
}

