/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.fxg;

import com.adobe.fxg.dom.FXGNode;
import com.adobe.fxg.swf.FXG2SWFTranscoder;
import com.adobe.internal.fxg.dom.CDATANode;
import com.adobe.internal.fxg.dom.GraphicContentNode;
import com.adobe.internal.fxg.dom.GroupNode;
import com.adobe.internal.fxg.dom.MaskableNode;
import com.adobe.internal.fxg.dom.MaskingNode;
import com.adobe.internal.fxg.dom.RichTextNode;
import com.adobe.internal.fxg.dom.TextGraphicNode;
import com.adobe.internal.fxg.dom.TextNode;
import com.adobe.internal.fxg.dom.richtext.BRNode;
import com.adobe.internal.fxg.dom.richtext.DivNode;
import com.adobe.internal.fxg.dom.richtext.ImgNode;
import com.adobe.internal.fxg.dom.richtext.LinkNode;
import com.adobe.internal.fxg.dom.richtext.SpanNode;
import com.adobe.internal.fxg.dom.richtext.TCYNode;
import com.adobe.internal.fxg.dom.richtext.TabNode;
import com.adobe.internal.fxg.dom.richtext.TextLayoutFormatNode;
import com.adobe.internal.fxg.dom.text.ParagraphNode;
import com.adobe.internal.fxg.dom.types.BlendMode;
import com.adobe.internal.fxg.dom.types.MaskType;
import flash.swf.tags.DefineSprite;
import flash.swf.tags.DefineTag;
import flash.swf.tags.PlaceObject;
import flash.util.StringUtils;
import flex2.compiler.fxg.FXGSymbolClass;
import flex2.compiler.fxg.FlexGraphicNode;
import flex2.compiler.mxml.lang.StandardDefs;
import flex2.compiler.mxml.reflect.Property;
import flex2.compiler.mxml.reflect.Type;
import flex2.compiler.mxml.reflect.TypeTable;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlexFXG2SWFTranscoder
extends FXG2SWFTranscoder {
    private FXGSymbolClass graphicClass;
    private String packageName;
    private TypeTable typeTable;
    private Type divType;
    private Type imgType;
    private Type linkType;
    private Type richTextType;
    private Type paragraphType;
    private Type spanType;
    private Type tabType;
    private Type tcyType;
    private Type textLayoutFormatType;

    public FlexFXG2SWFTranscoder(TypeTable typeTable) {
        this.typeTable = typeTable;
        if (typeTable != null) {
            this.divType = typeTable.getType(StandardDefs.CLASS_TEXT_DIV);
            this.linkType = typeTable.getType(StandardDefs.CLASS_TEXT_LINK);
            this.imgType = typeTable.getType(StandardDefs.CLASS_TEXT_IMG);
            this.richTextType = typeTable.getType(StandardDefs.CLASS_TEXT_RICHTEXT);
            this.paragraphType = typeTable.getType(StandardDefs.CLASS_TEXT_PARAGRAPH);
            this.spanType = typeTable.getType(StandardDefs.CLASS_TEXT_SPAN);
            this.tabType = typeTable.getType(StandardDefs.CLASS_TEXT_TAB);
            this.tcyType = typeTable.getType(StandardDefs.CLASS_TEXT_TCY);
            this.textLayoutFormatType = typeTable.getType(StandardDefs.CLASS_TEXT_LAYOUT_FORMAT);
        }
    }

    public FXGSymbolClass transcode(FXGNode node, String packageName, String className) {
        this.packageName = packageName;
        if (node instanceof FlexGraphicNode) {
            FlexGraphicNode graphicNode = (FlexGraphicNode)node;
            this.graphicClass = new FXGSymbolClass();
            this.graphicClass.setPackageName(packageName);
            this.graphicClass.setClassName(className);
            DefineSprite sprite = (DefineSprite)this.transcode((FXGNode)graphicNode);
            this.graphicClass.setSymbol((DefineTag)sprite);
            StringBuilder buf = new StringBuilder(512);
            buf.append("package ").append(packageName).append("\n");
            buf.append("{\n\n");
            buf.append("import spark.core.SpriteVisualElement;\n\n");
            buf.append("public class ").append(className).append(" extends SpriteVisualElement\n");
            buf.append("{\n");
            buf.append("    public function ").append(className).append("()\n");
            buf.append("    {\n");
            buf.append("        super();\n");
            if (!Double.isNaN(graphicNode.viewWidth)) {
                buf.append("        viewWidth = ").append(graphicNode.viewWidth).append(";\n");
            }
            if (!Double.isNaN(graphicNode.viewHeight)) {
                buf.append("        viewHeight = ").append(graphicNode.viewHeight).append(";\n");
            }
            if (graphicNode.getMaskType() == MaskType.ALPHA && graphicNode.mask != null) {
                int maskIndex = graphicNode.mask.getMaskIndex();
                buf.append("        this.cacheAsBitmap = true;\n");
                buf.append("        this.mask = this.getChildAt(").append(maskIndex).append(");\n");
            }
            buf.append("    }\n");
            buf.append("}\n");
            buf.append("}\n");
            this.graphicClass.setGeneratedSource(buf.toString());
            return this.graphicClass;
        }
        return null;
    }

    public FXG2SWFTranscoder newInstance() {
        FlexFXG2SWFTranscoder graphics = new FlexFXG2SWFTranscoder(this.typeTable);
        graphics.packageName = this.packageName;
        graphics.graphicClass = this.graphicClass;
        graphics.definitions = this.definitions;
        return graphics;
    }

    protected PlaceObject mask(MaskableNode node, DefineSprite parentSprite) {
        MaskingNode mask = node.getMask();
        PlaceObject po3 = super.mask(node, parentSprite);
        if (mask != null) {
            MaskType maskType = node.getMaskType();
            if (maskType != MaskType.CLIP) {
                int maskIndex = parentSprite.depthCounter - 1;
                mask.setMaskIndex(maskIndex);
            }
            if (maskType == MaskType.LUMINOSITY) {
                String className = this.createUniqueName(this.graphicClass.getClassName() + "_Mask");
                FXGSymbolClass symbolClass = new FXGSymbolClass();
                symbolClass.setPackageName(this.packageName);
                symbolClass.setClassName(className);
                this.graphicClass.addAdditionalSymbolClass(symbolClass);
                int mode = 0;
                if (node.getLuminosityClip()) {
                    mode += 2;
                }
                if (node.getLuminosityInvert()) {
                    ++mode;
                }
                StringBuilder buf = new StringBuilder(768);
                buf.append("package ").append(this.packageName).append("\n");
                buf.append("{\n\n");
                buf.append("import flash.display.Sprite;\n");
                buf.append("import spark.filters.ShaderFilter;\n");
                buf.append("import mx.graphics.shaderClasses.LuminosityMaskShader;\n\n");
                buf.append("public class ").append(className).append(" extends Sprite\n");
                buf.append("{\n");
                buf.append("    public function ").append(className).append("()\n");
                buf.append("    {\n");
                buf.append("        super();\n");
                buf.append("        this.cacheAsBitmap = true;\n");
                buf.append("        var shader:LuminosityMaskShader = new LuminosityMaskShader();\n");
                buf.append("        shader.mode = ").append(mode).append(";\n");
                buf.append("        var filter:ShaderFilter = new ShaderFilter(shader);\n");
                buf.append("        this.filters = [filter.clone()];\n");
                buf.append("    }\n");
                buf.append("}\n");
                buf.append("}\n");
                symbolClass.setGeneratedSource(buf.toString());
                symbolClass.setSymbol(po3.ref);
            }
        }
        return po3;
    }

    protected PlaceObject graphicContentNode(GraphicContentNode node) {
        boolean hasMaskAndFilters = node.mask != null && node.filters != null;
        PlaceObject po3 = super.graphicContentNode(node);
        if (po3 != null && !(node instanceof TextNode) && this.hasAdvancedGraphics((MaskableNode)node)) {
            SymbolClassType symbolClassType = SymbolClassType.SHAPE;
            if (hasMaskAndFilters || node instanceof GroupNode) {
                symbolClassType = SymbolClassType.SPRITE;
            }
            this.advancedGraphics(node, po3.ref, symbolClassType);
        }
        return po3;
    }

    protected PlaceObject group(GroupNode node) {
        PlaceObject po3 = super.group(node);
        if (po3 != null && this.hasAdvancedGraphics((MaskableNode)node)) {
            this.advancedGraphics((GraphicContentNode)node, po3.ref, SymbolClassType.SPRITE);
        }
        return po3;
    }

    private boolean hasAdvancedGraphics(MaskableNode node) {
        if (node.getMask() != null && (node.getMaskType() == MaskType.ALPHA || node.getMaskType() == MaskType.LUMINOSITY)) {
            return true;
        }
        if (node instanceof GraphicContentNode) {
            GraphicContentNode graphicNode = (GraphicContentNode)node;
            if (graphicNode.blendMode.needsPixelBenderSupport()) {
                return true;
            }
        }
        return false;
    }

    private void advancedGraphics(GraphicContentNode node, DefineTag symbol, SymbolClassType symbolClassType) {
        MaskingNode maskNode = node.getMask();
        String className = this.graphicClass.getClassName();
        if (maskNode != null) {
            className = className + "_Maskee";
        }
        className = this.createUniqueName(className);
        FXGSymbolClass symbolClass = new FXGSymbolClass();
        symbolClass.setPackageName(this.packageName);
        symbolClass.setClassName(className);
        this.graphicClass.addAdditionalSymbolClass(symbolClass);
        StringBuilder buf = new StringBuilder(512);
        buf.append("package ").append(this.packageName).append("\n");
        buf.append("{\n\n");
        String baseClassName = null;
        if (symbolClassType == SymbolClassType.SPRITE) {
            buf.append("import flash.display.Sprite;\n");
            baseClassName = "Sprite";
        } else {
            buf.append("import flash.display.Shape;\n");
            baseClassName = "Shape";
        }
        String blendModeImport = this.generateBlendModeImport(node.blendMode);
        if (blendModeImport != null) {
            buf.append(blendModeImport);
        }
        String blendModeShader = this.generateBlendMode(node.blendMode);
        buf.append("public class ").append(className).append(" extends ").append(baseClassName).append("\n");
        buf.append("{\n");
        buf.append("    public function ").append(className).append("()\n");
        buf.append("    {\n");
        buf.append("        super();\n");
        buf.append("        this.cacheAsBitmap = true;\n");
        if (maskNode != null) {
            int maskIndex = maskNode.getMaskIndex();
            if (symbolClassType == SymbolClassType.SPRITE) {
                buf.append("        this.mask = this.getChildAt(").append(maskIndex).append(");\n");
            } else {
                buf.append("        this.mask = this.parent.getChildAt(").append(maskIndex).append(");\n");
            }
        }
        if (blendModeShader != null) {
            buf.append(blendModeShader);
        }
        buf.append("    }\n");
        buf.append("}\n");
        buf.append("}\n");
        symbolClass.setGeneratedSource(buf.toString());
        symbolClass.setSymbol(symbol);
    }

    private String generateBlendModeImport(BlendMode blendMode) {
        if (blendMode == BlendMode.COLOR) {
            return "import mx.graphics.shaderClasses.ColorShader;\n\n";
        }
        if (blendMode == BlendMode.COLORBURN) {
            return "import mx.graphics.shaderClasses.ColorBurnShader;\n\n";
        }
        if (blendMode == BlendMode.COLORDODGE) {
            return "import mx.graphics.shaderClasses.ColorDodgeShader;\n\n";
        }
        if (blendMode == BlendMode.EXCLUSION) {
            return "import mx.graphics.shaderClasses.ExclusionShader;\n\n";
        }
        if (blendMode == BlendMode.HUE) {
            return "import mx.graphics.shaderClasses.HueShader;\n\n";
        }
        if (blendMode == BlendMode.LUMINOSITY) {
            return "import mx.graphics.shaderClasses.LuminosityShader;\n\n";
        }
        if (blendMode == BlendMode.SATURATION) {
            return "import mx.graphics.shaderClasses.SaturationShader;\n\n";
        }
        if (blendMode == BlendMode.SOFTLIGHT) {
            return "import mx.graphics.shaderClasses.SoftLightShader;\n\n";
        }
        return null;
    }

    private String generateBlendMode(BlendMode blendMode) {
        if (blendMode == BlendMode.COLOR) {
            return "        this.blendShader = new ColorShader();\n";
        }
        if (blendMode == BlendMode.COLORBURN) {
            return "        this.blendShader = new ColorBurnShader();\n";
        }
        if (blendMode == BlendMode.COLORDODGE) {
            return "        this.blendShader = new ColorDodgeShader();\n";
        }
        if (blendMode == BlendMode.EXCLUSION) {
            return "        this.blendShader = new ExclusionShader();\n";
        }
        if (blendMode == BlendMode.HUE) {
            return "        this.blendShader = new HueShader();\n";
        }
        if (blendMode == BlendMode.LUMINOSITY) {
            return "        this.blendShader = new LuminosityShader();\n";
        }
        if (blendMode == BlendMode.SATURATION) {
            return "        this.blendShader = new SaturationShader();\n";
        }
        if (blendMode == BlendMode.SOFTLIGHT) {
            return "        this.blendShader = new SoftLightShader();\n";
        }
        return null;
    }

    protected PlaceObject richtext(RichTextNode node) {
        return this.flexText((GraphicContentNode)node);
    }

    protected PlaceObject text(TextGraphicNode node) {
        return this.flexText((GraphicContentNode)node);
    }

    private PlaceObject flexText(GraphicContentNode node) {
        if (node instanceof TextNode) {
            MaskingNode maskNode;
            TextNode textNode = (TextNode)node;
            String className = this.createUniqueName(this.graphicClass.getClassName() + "_Text");
            FXGSymbolClass spriteSymbolClass = new FXGSymbolClass();
            spriteSymbolClass.setPackageName(this.packageName);
            spriteSymbolClass.setClassName(className);
            this.graphicClass.addAdditionalSymbolClass(spriteSymbolClass);
            DefineSprite textSprite = this.createDefineSprite(className);
            PlaceObject po3 = this.placeObject((DefineTag)textSprite, node.createGraphicContext());
            this.spriteStack.push(textSprite);
            StringBuilder buf = new StringBuilder(4096);
            buf.append("package ").append(this.packageName).append("\n");
            buf.append("{\n\n");
            buf.append("import flash.events.Event;\n");
            buf.append("import flashx.textLayout.elements.*;\n");
            buf.append("import flashx.textLayout.formats.TextLayoutFormat;\n");
            buf.append("import mx.core.IFlexModuleFactory;\n");
            buf.append("import spark.components.RichText;\n");
            buf.append("import spark.core.SpriteVisualElement;\n\n");
            String blendModeImport = this.generateBlendModeImport(node.blendMode);
            if (blendModeImport != null) {
                buf.append(blendModeImport);
            }
            String blendModeShader = this.generateBlendMode(node.blendMode);
            buf.append("public class ").append(className).append(" extends SpriteVisualElement\n");
            buf.append("{\n");
            buf.append("    public function ").append(className).append("()\n");
            buf.append("    {\n");
            buf.append("        super();\n");
            if (this.hasAdvancedGraphics((MaskableNode)node)) {
                buf.append("        this.cacheAsBitmap = true;\n");
            }
            if ((maskNode = node.getMask()) != null && (node.getMaskType() == MaskType.ALPHA || node.getMaskType() == MaskType.LUMINOSITY)) {
                int maskIndex = maskNode.getMaskIndex();
                buf.append("        this.mask = this.parent.getChildAt(").append(maskIndex).append(");\n");
            }
            if (blendModeShader != null) {
                buf.append(blendModeShader);
            }
            buf.append("        createText();\n");
            buf.append("    }\n");
            buf.append("\n");
            buf.append("    private var _richTextComponent:RichText;\n\n");
            buf.append("    private function createText():void\n");
            buf.append("    {\n");
            SourceContext textSource = this.generateRichText(textNode);
            if (textSource.functionBuffer != null) {
                buf.append(textSource.functionBuffer.toString());
            }
            buf.append("    }\n");
            if (textSource.classBuffer != null) {
                buf.append(textSource.classBuffer.toString());
            }
            buf.append(this.generateModuleFactoryOverride("_richTextComponent"));
            buf.append("}\n");
            buf.append("}\n");
            spriteSymbolClass.setGeneratedSource(buf.toString());
            spriteSymbolClass.setSymbol((DefineTag)textSprite);
            this.spriteStack.pop();
            return po3;
        }
        return null;
    }

    private String createUniqueName(String baseName) {
        int r = random.nextInt();
        String suffix = Integer.toString(r);
        if (suffix.charAt(0) == '-') {
            suffix = suffix.replace('-', '_');
        }
        return baseName + suffix;
    }

    private SourceContext generateRichText(TextNode textNode) {
        SourceContext srcContext = new SourceContext(1024, 0);
        StringBuilder buf = srcContext.functionBuffer;
        Variables varContext = new Variables();
        varContext.setVar(this.richTextType, NodeType.RICHTEXT);
        String elementVar = varContext.elementVar;
        this.generateTextVariable(textNode, srcContext, varContext);
        buf.append("        _richTextComponent = ").append(elementVar).append(";\r\n");
        buf.append("        addChild(").append(elementVar).append(");\r\n");
        buf.append("        var addHandler:Function = function(event:Event):void\r\n");
        buf.append("        {\r\n");
        buf.append("            removeEventListener(Event.ADDED_TO_STAGE, addHandler);\r\n\r\n");
        buf.append("            // If we don't have a module factory by now then use the root\r\n");
        buf.append("            if (moduleFactory == null && root is IFlexModuleFactory)\r\n");
        buf.append("                moduleFactory = IFlexModuleFactory(root);\r\n");
        buf.append("        };\r\n");
        buf.append("        addEventListener(Event.ADDED_TO_STAGE, addHandler);\r\n");
        return srcContext;
    }

    private String generateModuleFactoryOverride(String elementVar) {
        StringBuilder buf = new StringBuilder(1024);
        buf.append("\r\n    /**\r\n");
        buf.append("     *  @private\r\n");
        buf.append("     *  Create a module factory override so we do not try to use a RichText's\r\n");
        buf.append("     *  styles until we have a module factory. The module factory will tell us\r\n");
        buf.append("     *  which style manager to use.\r\n");
        buf.append("     */\r\n");
        buf.append("    override public function set moduleFactory(factory:IFlexModuleFactory):void\r\n");
        buf.append("    {\r\n");
        buf.append("        super.moduleFactory = factory;\r\n");
        buf.append("        ").append(elementVar).append(".regenerateStyleCache(true);\r\n");
        buf.append("        ").append(elementVar).append(".styleChanged(null);\r\n");
        buf.append("        ").append(elementVar).append(".stylesInitialized();\r\n");
        buf.append("        ").append(elementVar).append(".validateProperties();\r\n");
        buf.append("        ").append(elementVar).append(".validateSize();\r\n");
        buf.append("        ").append(elementVar).append(".setLayoutBoundsSize(NaN, NaN);\r\n");
        buf.append("        ").append(elementVar).append(".validateDisplayList();\r\n");
        buf.append("        invalidateSize();\r\n");
        buf.append("    }\r\n");
        return buf.toString();
    }

    private void generateTextVariable(TextNode textNode, SourceContext srcContext, Variables varContext) {
        StringBuilder buf = srcContext.functionBuffer;
        Map attributes = textNode.getTextAttributes();
        List children = textNode.getTextChildren();
        String currentVar = varContext.elementVar;
        String contentVar = varContext.contentVar;
        String parentClass = varContext.elementClass;
        String parentChildrenVar = varContext.elementChildrenVar;
        Type type = varContext.type;
        if (!varContext.varDeclared) {
            buf.append("        var ").append(currentVar).append(":").append(parentClass).append(" = new ").append(parentClass).append("();\r\n");
            if (contentVar != null) {
                buf.append("        var ").append(contentVar).append(":Array = [];\r\n");
            }
        } else {
            buf.append("        ").append(currentVar).append(" = new ").append(parentClass).append("();\r\n");
            if (contentVar != null) {
                buf.append("        ").append(contentVar).append(" = [];\r\n");
            }
        }
        this.generateAttributes(textNode, type, attributes, srcContext, currentVar);
        if (!(textNode instanceof RichTextNode)) {
            this.generateProperties(srcContext, textNode, currentVar, varContext);
        }
        if (children != null && children.size() > 0) {
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                String elementVar = null;
                TextNode child = (TextNode)iter.next();
                if (child instanceof RichTextNode) {
                    varContext.setVar(this.richTextType, NodeType.RICHTEXT);
                    elementVar = varContext.elementVar;
                    this.generateTextVariable(child, srcContext, varContext);
                    buf.append("        ").append(contentVar).append(".push(").append(elementVar).append(");\r\n");
                    continue;
                }
                if (child instanceof com.adobe.internal.fxg.dom.richtext.ParagraphNode) {
                    varContext.setVar(this.paragraphType, NodeType.PARAGRAPH);
                    elementVar = varContext.elementVar;
                    this.generateTextVariable(child, srcContext, varContext);
                    buf.append("        ").append(contentVar).append(".push(").append(elementVar).append(");\r\n");
                    continue;
                }
                if (child instanceof SpanNode) {
                    varContext.setVar(this.spanType, NodeType.SPAN);
                    elementVar = varContext.elementVar;
                    this.generateTextVariable(child, srcContext, varContext);
                    buf.append("        ").append(contentVar).append(".push(").append(elementVar).append(");\r\n");
                    continue;
                }
                if (child instanceof DivNode) {
                    varContext.setVar(this.divType, NodeType.DIV);
                    elementVar = varContext.elementVar;
                    this.generateTextVariable(child, srcContext, varContext);
                    buf.append("        ").append(contentVar).append(".push(").append(elementVar).append(");\r\n");
                    continue;
                }
                if (child instanceof CDATANode) {
                    String text = this.formatString(((CDATANode)child).content);
                    buf.append("        ").append(contentVar).append(".push(").append(text).append(");\r\n");
                    continue;
                }
                if (child instanceof BRNode) {
                    buf.append("        ").append(contentVar).append(".push(new BreakElement());\r\n");
                    continue;
                }
                if (child instanceof ImgNode) {
                    varContext.setVar(this.imgType, NodeType.IMG);
                    elementVar = varContext.elementVar;
                    this.generateTextVariable(child, srcContext, varContext);
                    buf.append("        ").append(contentVar).append(".push(").append(elementVar).append(");\r\n");
                    continue;
                }
                if (child instanceof LinkNode) {
                    varContext.setVar(this.linkType, NodeType.LINK);
                    elementVar = varContext.elementVar;
                    this.generateTextVariable(child, srcContext, varContext);
                    buf.append("        ").append(contentVar).append(".push(").append(elementVar).append(");\r\n");
                    continue;
                }
                if (child instanceof TabNode) {
                    varContext.setVar(this.tabType, NodeType.TAB);
                    elementVar = varContext.elementVar;
                    this.generateTextVariable(child, srcContext, varContext);
                    buf.append("        ").append(contentVar).append(".push(").append(elementVar).append(");\r\n");
                    continue;
                }
                if (child instanceof TCYNode) {
                    varContext.setVar(this.tcyType, NodeType.TCY);
                    elementVar = varContext.elementVar;
                    this.generateTextVariable(child, srcContext, varContext);
                    buf.append("        ").append(contentVar).append(".push(").append(elementVar).append(");\r\n");
                    continue;
                }
                if (child instanceof TextGraphicNode) {
                    varContext.setVar(this.richTextType, NodeType.RICHTEXT);
                    elementVar = varContext.elementVar;
                    this.generateTextVariable(child, srcContext, varContext);
                    buf.append("        ").append(contentVar).append(".push(").append(elementVar).append(");\r\n");
                    continue;
                }
                if (child instanceof ParagraphNode) {
                    varContext.setVar(this.paragraphType, NodeType.PARAGRAPH);
                    elementVar = varContext.elementVar;
                    this.generateTextVariable(child, srcContext, varContext);
                    buf.append("        ").append(contentVar).append(".push(").append(elementVar).append(");\r\n");
                    continue;
                }
                if (child instanceof com.adobe.internal.fxg.dom.text.SpanNode) {
                    varContext.setVar(this.spanType, NodeType.SPAN);
                    elementVar = varContext.elementVar;
                    this.generateTextVariable(child, srcContext, varContext);
                    buf.append("        ").append(contentVar).append(".push(").append(elementVar).append(");\r\n");
                    continue;
                }
                if (!(child instanceof com.adobe.internal.fxg.dom.text.BRNode)) continue;
                buf.append("        ").append(contentVar).append(".push(new BreakElement());\r\n");
            }
        }
        if (parentChildrenVar != null && contentVar != null) {
            buf.append("        ").append(currentVar).append(".").append(parentChildrenVar).append(" = ").append(contentVar).append(";\r\n");
        }
        if (textNode instanceof RichTextNode) {
            this.generateProperties(srcContext, textNode, currentVar, varContext);
        }
    }

    private void generateProperties(SourceContext srcContext, TextNode parentNode, String parentVar, Variables varContext) {
        Map properties = parentNode.getTextProperties();
        if (properties != null) {
            StringBuilder buf = srcContext.functionBuffer;
            for (Map.Entry entry : properties.entrySet()) {
                String propertyName = (String)entry.getKey();
                TextNode node = (TextNode)entry.getValue();
                if (!(node instanceof TextLayoutFormatNode)) continue;
                if (parentNode instanceof RichTextNode) {
                    varContext.setVar(this.textLayoutFormatType, NodeType.TEXT_LAYOUT_FORMAT);
                    this.generateTextVariable(node, srcContext, varContext);
                    buf.append("        ").append(parentVar).append(".textFlow.").append(propertyName).append(" = ").append(varContext.elementVar).append(";\r\n");
                    continue;
                }
                varContext.setVar(this.textLayoutFormatType, NodeType.TEXT_LAYOUT_FORMAT);
                this.generateTextVariable(node, srcContext, varContext);
                buf.append("        ").append(parentVar).append(".").append(propertyName).append(" = ").append(varContext.elementVar).append(";\r\n");
            }
        }
    }

    private void generateAttributes(TextNode node, Type type, Map<String, String> attributes, SourceContext srcContext, String variableName) {
        if (attributes != null) {
            StringBuilder buf = srcContext.functionBuffer;
            if (node instanceof ImgNode) {
                String imgSource = attributes.get("source");
                if ((imgSource = this.parseSource(imgSource)) != null) {
                    String resolvedPath;
                    File f = new File(imgSource);
                    if (!f.isAbsolute() && this.resourceResolver != null && (resolvedPath = this.resourceResolver.resolve(imgSource)) != null) {
                        imgSource = resolvedPath;
                    }
                    imgSource = imgSource.replace('\\', '/');
                    if (srcContext.classBuffer == null) {
                        srcContext.classBuffer = new StringBuilder(128);
                    }
                    StringBuilder classBuf = srcContext.classBuffer;
                    String imgVar = this.createUniqueName("img");
                    classBuf.append("\n");
                    classBuf.append("    [Embed(source=\"").append(imgSource).append("\")]\n");
                    classBuf.append("    private static var ").append(imgVar).append(":Class;\n");
                    buf.append("        ").append(variableName).append(".source = ").append(imgVar).append(";\n");
                    attributes.remove("source");
                }
            }
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                String attribName = entry.getKey();
                String attribValue = entry.getValue();
                String thisAttrib = null;
                Property property = type.getProperty(attribName);
                if (property != null) {
                    Type propertyType = property.getType();
                    thisAttrib = propertyType.isAssignableTo(this.typeTable.stringType) || propertyType == this.typeTable.objectType || propertyType == this.typeTable.noType ? attribName + " = \"" + attribValue + "\"" : attribName + " = " + attribValue;
                } else if (type.getStyle(attribName) != null) {
                    thisAttrib = "setStyle(\"" + attribName + "\", \"" + attribValue + "\")";
                }
                if (thisAttrib == null) continue;
                buf.append("        " + variableName + '.' + thisAttrib + ";\r\n");
            }
        }
    }

    private String formatString(String content) {
        if (content != null) {
            return StringUtils.formatString((String)content);
        }
        return content;
    }

    private static class Variable {
        private int count;
        private boolean reusableVar;
        private String elementClass;
        private String elementVar;
        private String contentVar;
        private String elementChildrenVar;

        private Variable(String elementClass, String elementVar, String contentVar, String elementChildrenVar, boolean reusableVar) {
            this.elementClass = elementClass;
            this.elementVar = elementVar;
            this.contentVar = contentVar;
            this.elementChildrenVar = elementChildrenVar;
            this.reusableVar = reusableVar;
        }
    }

    private static class Variables {
        private Variable divVar;
        private Variable formatVar;
        private Variable imgVar;
        private Variable linkVar;
        private Variable paragraphVar;
        private Variable richTextVar;
        private Variable spanVar;
        private Variable tabVar;
        private Variable tcyVar;
        private Variable textLayoutFormatVar;
        private Type type;
        private boolean varDeclared;
        private String elementClass;
        private String elementVar;
        private String contentVar;
        private String elementChildrenVar;

        private Variables() {
        }

        private void setVar(Type type, NodeType nodeType) {
            this.type = type;
            Variable var = this.getVar(nodeType);
            if (var != null) {
                var.count++;
                if (!var.reusableVar) {
                    this.varDeclared = false;
                    this.elementVar = var.elementVar + var.count;
                    this.contentVar = var.contentVar + var.count;
                } else {
                    this.varDeclared = var.count > 1;
                    this.elementVar = var.elementVar;
                    this.contentVar = var.contentVar;
                }
                this.elementClass = var.elementClass;
                this.elementChildrenVar = var.elementChildrenVar;
            }
        }

        private Variable getVar(NodeType nodeType) {
            switch (nodeType) {
                case DIV: {
                    if (this.divVar == null) {
                        this.divVar = new Variable("DivElement", "divElement", "divContent", "mxmlChildren", false);
                    }
                    return this.divVar;
                }
                case FORMAT: {
                    if (this.formatVar == null) {
                        this.formatVar = new Variable("TextLayoutFormat", "formatElement", null, null, false);
                    }
                    return this.formatVar;
                }
                case IMG: {
                    if (this.imgVar == null) {
                        this.imgVar = new Variable("InlineGraphicElement", "imgElement", null, null, true);
                    }
                    return this.imgVar;
                }
                case LINK: {
                    if (this.linkVar == null) {
                        this.linkVar = new Variable("LinkElement", "linkElement", "linkContent", "mxmlChildren", true);
                    }
                    return this.linkVar;
                }
                case PARAGRAPH: {
                    if (this.paragraphVar == null) {
                        this.paragraphVar = new Variable("ParagraphElement", "paragraphElement", "paragraphContent", "mxmlChildren", true);
                    }
                    return this.paragraphVar;
                }
                case RICHTEXT: {
                    if (this.richTextVar == null) {
                        this.richTextVar = new Variable("RichText", "textElement", "textContent", "content", true);
                    }
                    return this.richTextVar;
                }
                case SPAN: {
                    if (this.spanVar == null) {
                        this.spanVar = new Variable("SpanElement", "spanElement", "spanContent", "mxmlChildren", true);
                    }
                    return this.spanVar;
                }
                case TAB: {
                    if (this.tabVar == null) {
                        this.tabVar = new Variable("TabElement", "tabElement", null, null, true);
                    }
                    return this.tabVar;
                }
                case TCY: {
                    if (this.tcyVar == null) {
                        this.tcyVar = new Variable("TCYElement", "tcyElement", "tcyContent", "mxmlChildren", true);
                    }
                    return this.tcyVar;
                }
                case TEXT_LAYOUT_FORMAT: {
                    if (this.textLayoutFormatVar == null) {
                        this.textLayoutFormatVar = new Variable("TextLayoutFormat", "tlfElement", null, null, true);
                    }
                    return this.textLayoutFormatVar;
                }
            }
            return null;
        }
    }

    private static class SourceContext {
        private StringBuilder functionBuffer;
        private StringBuilder classBuffer;

        private SourceContext(int functionSize, int classSize) {
            if (functionSize > 0) {
                this.functionBuffer = new StringBuilder(functionSize);
            }
            if (classSize > 0) {
                this.classBuffer = new StringBuilder(classSize);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum NodeType {
        DIV,
        FORMAT,
        IMG,
        LINK,
        PARAGRAPH,
        RICHTEXT,
        SPAN,
        TAB,
        TCY,
        TEXT_LAYOUT_FORMAT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SymbolClassType {
        SPRITE,
        SHAPE;

    }
}

