/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.fxg;

import com.adobe.fxg.FXGException;
import com.adobe.fxg.FXGParser;
import com.adobe.fxg.FXGParserFactory;
import com.adobe.fxg.FXGVersion;
import com.adobe.fxg.dom.FXGNode;
import com.adobe.fxg.util.FXGLog;
import com.adobe.fxg.util.FXGLogger;
import flash.util.FileUtils;
import flex2.compiler.AbstractDelegatingSubCompiler;
import flex2.compiler.AbstractSubCompiler;
import flex2.compiler.AssetInfo;
import flex2.compiler.CompilationUnit;
import flex2.compiler.CompilerContext;
import flex2.compiler.Logger;
import flex2.compiler.Source;
import flex2.compiler.SubCompiler;
import flex2.compiler.SymbolTable;
import flex2.compiler.as3.As3Compiler;
import flex2.compiler.common.CompilerConfiguration;
import flex2.compiler.common.PathResolver;
import flex2.compiler.fxg.FXGSymbolClass;
import flex2.compiler.fxg.FlexFXG2SWFTranscoder;
import flex2.compiler.fxg.FlexGraphicNode;
import flex2.compiler.fxg.FlexLoggerAdapter;
import flex2.compiler.fxg.FlexParagraphNode;
import flex2.compiler.fxg.FlexResourceResolver;
import flex2.compiler.fxg.FlexRichTextNode;
import flex2.compiler.fxg.FlexSpanNode;
import flex2.compiler.fxg.FlexTextGraphicNode;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.TextFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.mxml.lang.StandardDefs;
import flex2.compiler.mxml.lang.TextParser;
import flex2.compiler.mxml.reflect.TypeTable;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.MultiName;
import flex2.compiler.util.NameMappings;
import flex2.compiler.util.QName;
import flex2.compiler.util.ThreadLocalToolkit;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class FXGCompiler
extends AbstractSubCompiler {
    private static final String COMPILER_NAME = "fxg";
    private static final String COMPILATION_STATE = "FXGCompileState";
    private static final int STATE_SKELETON_PARSED = 0;
    private static final int STATE_SKELETON_GENERATED = 1;
    private static final int STATE_IMPLEMENTATION_PARSED = 2;
    private static final int STATE_IMPLEMENTATION_GENERATED = 3;
    private static final String FXG_DOM_ROOT = "FXG_DOM_ROOT";
    private static final MultiName MULTINAME_SPRITEVISUALELEMENT = new MultiName(StandardDefs.CLASS_SPARK_SPRITEVISUALELEMENT);
    private String[] mimeTypes = new String[]{"text/fxg"};
    private NameMappings nameMappings;
    private String generatedOutputDir;
    private SkeletonCompiler skeletonCompiler;
    private ImplementationCompiler implementationCompiler;
    private Set<String> themeNames;

    public FXGCompiler(CompilerConfiguration configuration, NameMappings nameMappings) {
        this.nameMappings = nameMappings;
        this.generatedOutputDir = configuration.keepGeneratedActionScript() ? configuration.getGeneratedDirectory() : null;
        this.skeletonCompiler = new SkeletonCompiler(configuration);
        this.implementationCompiler = new ImplementationCompiler(configuration);
        this.themeNames = configuration.getThemeNames();
    }

    public String getName() {
        return COMPILER_NAME;
    }

    public boolean isSupported(String mimeType) {
        for (int i = 0; i < this.mimeTypes.length; ++i) {
            if (!this.mimeTypes[i].equals(mimeType)) continue;
            return true;
        }
        return false;
    }

    public String[] getSupportedMimeTypes() {
        return this.mimeTypes;
    }

    public Source preprocess(Source source) {
        String componentName;
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.startPhase(0, source.getNameForReporting());
        }
        if (!TextParser.isValidIdentifier(componentName = source.getShortName())) {
            InvalidComponentName m = new InvalidComponentName(componentName);
            m.setPath(source.getNameForReporting());
            ThreadLocalToolkit.log(m);
        }
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.endPhase(0);
        }
        return source;
    }

    public CompilationUnit parse1(Source source, SymbolTable symbolTable) {
        CompilationUnit unit;
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.startPhase(1, source.getNameForReporting());
        }
        if ((unit = source.getCompilationUnit()) == null) {
            unit = this.skeletonCompiler.parse1(source, symbolTable);
            if (unit != null) {
                this.setCompileState(unit, 0);
            }
        } else if (this.getCompileState(unit) == 1 && (unit = this.implementationCompiler.parse1(source, symbolTable)) != null) {
            this.advanceCompilationState(unit);
        }
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.endPhase(1);
        }
        return unit;
    }

    public void parse2(CompilationUnit unit, SymbolTable symbolTable) {
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.startPhase(2, unit.getSource().getNameForReporting());
        }
        this.getCompilerForCompileState(unit).parse2(unit, symbolTable);
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.endPhase(2);
        }
    }

    public void analyze1(CompilationUnit unit, SymbolTable symbolTable) {
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.startPhase(3, unit.getSource().getNameForReporting());
        }
        this.getCompilerForCompileState(unit).analyze1(unit, symbolTable);
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.endPhase(3);
        }
    }

    public void analyze2(CompilationUnit unit, SymbolTable symbolTable) {
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.startPhase(4, unit.getSource().getNameForReporting());
        }
        this.getCompilerForCompileState(unit).analyze2(unit, symbolTable);
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.endPhase(4);
        }
    }

    public void analyze3(CompilationUnit unit, SymbolTable symbolTable) {
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.startPhase(5, unit.getSource().getNameForReporting());
        }
        this.getCompilerForCompileState(unit).analyze3(unit, symbolTable);
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.endPhase(5);
        }
    }

    public void analyze4(CompilationUnit unit, SymbolTable symbolTable) {
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.startPhase(6, unit.getSource().getNameForReporting());
        }
        this.getCompilerForCompileState(unit).analyze4(unit, symbolTable);
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.endPhase(6);
        }
    }

    public void generate(CompilationUnit unit, SymbolTable symbolTable) {
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.startPhase(7, unit.getSource().getNameForReporting());
        }
        this.getCompilerForCompileState(unit).generate(unit, symbolTable);
        this.advanceCompilationState(unit);
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.endPhase(7);
        }
    }

    public void postprocess(CompilationUnit unit, SymbolTable symbolTable) {
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.startPhase(8, unit.getSource().getNameForReporting());
        }
        this.getCompilerForCompileState(unit).postprocess(unit, symbolTable);
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.endPhase(8);
        }
    }

    private void advanceCompilationState(CompilationUnit unit) {
        int state = this.getCompileState(unit);
        assert (state < 3) : "FXGCompiler advanceState called with state == " + state;
        this.setCompileState(unit, state + 1);
    }

    private int getCompileState(CompilationUnit unit) {
        assert (unit.getContext().getAttribute(COMPILATION_STATE) != null) : "FXGCompiler: CompilationUnit lacks FXGCompileState attribute.";
        return (Integer)unit.getContext().getAttribute(COMPILATION_STATE);
    }

    private void setCompileState(CompilationUnit unit, int state) {
        unit.getContext().setAttribute(COMPILATION_STATE, new Integer(state));
    }

    private SubCompiler getCompilerForCompileState(CompilationUnit unit) {
        return this.getCompileState(unit) < 2 ? this.skeletonCompiler : this.implementationCompiler;
    }

    private static QName getQNameFromSource(Source source) {
        String className = source.getShortName();
        String packageName = source.getRelativePath().replace('/', '.');
        return new QName(packageName, className);
    }

    private String getGeneratedFileName(String packageName, String className, String suffix) {
        String dir = this.generatedOutputDir;
        if (packageName != null && packageName.length() > 0) {
            dir = FileUtils.addPathComponents((String)dir, (String)packageName.replace('.', File.separatorChar), (char)File.separatorChar);
        }
        return FileUtils.addPathComponents((String)dir, (String)(className + suffix), (char)File.separatorChar);
    }

    private void setupLogger() {
        Object fxgLogger;
        Logger logger = ThreadLocalToolkit.getLogger();
        if (logger != null && !((fxgLogger = FXGLog.getLogger()) instanceof FlexLoggerAdapter)) {
            fxgLogger = new FlexLoggerAdapter(0);
            FXGLog.setLogger((FXGLogger)fxgLogger);
        }
    }

    public static class SourceGenerationException
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -395170674941663888L;

        public SourceGenerationException(Throwable rootCause) {
            super(rootCause);
        }
    }

    public static class FXGParseException
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 4714330790773345898L;

        public FXGParseException(Throwable rootCause) {
            super(rootCause);
        }
    }

    public static class InvalidComponentName
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 4116465034363649658L;
        public final String name;

        public InvalidComponentName(String name) {
            this.name = name;
        }
    }

    private final class ImplementationCompiler
    extends AbstractDelegatingSubCompiler {
        private ImplementationCompiler(CompilerConfiguration config) {
            As3Compiler asc = new As3Compiler(config);
            this.delegateSubCompiler = asc;
        }

        public String getName() {
            return FXGCompiler.COMPILER_NAME;
        }

        public boolean isSupported(String mimeType) {
            return FXGCompiler.this.isSupported(mimeType);
        }

        public String[] getSupportedMimeTypes() {
            return FXGCompiler.this.getSupportedMimeTypes();
        }

        public CompilationUnit parse1(Source source, SymbolTable symbolTable) {
            CompilationUnit unit = source.getCompilationUnit();
            try {
                CompilationUnit implementationUnit;
                Source generatedSource = this.generateSource(unit, symbolTable);
                if (generatedSource != null) {
                    generatedSource.addFileIncludes(source);
                }
                if ((implementationUnit = this.delegateSubCompiler.parse1(generatedSource, symbolTable)) != null) {
                    unit.getSource().addFileIncludes(implementationUnit.getSource());
                    unit.getContext().setAttribute("DelegateUnit", implementationUnit);
                    Source.transferMetaData(implementationUnit, unit);
                    Source.transferGeneratedSources(implementationUnit, unit);
                    Source.transferDefinitions(implementationUnit, unit);
                    Source.transferInheritance(implementationUnit, unit);
                } else {
                    unit = null;
                }
            }
            catch (FXGException ex) {
                ThreadLocalToolkit.log((CompilerMessage)new SourceGenerationException(ex), source, ex.getLineNumber(), ex.getColumnNumber());
                unit = null;
            }
            catch (IOException ex) {
                ThreadLocalToolkit.log((CompilerMessage)new SourceGenerationException(ex), source);
                unit = null;
            }
            return unit;
        }

        private Source generateSource(CompilationUnit unit, SymbolTable symbolTable) throws IOException {
            Source originalSource = unit.getSource();
            String className = originalSource.getShortName();
            String packageName = originalSource.getRelativePath().replace('/', '.');
            TypeTable typeTable = new TypeTable(symbolTable, FXGCompiler.this.nameMappings, unit.getStandardDefs(), FXGCompiler.this.themeNames);
            FXGSymbolClass asset = this.transcodeFXG(unit, packageName, className, typeTable);
            Source generatedSource = this.generateMainSource(unit, packageName, className, asset);
            List<FXGSymbolClass> additionalAssets = asset.getAdditionalSymbolClasses();
            if (additionalAssets != null && additionalAssets.size() > 0) {
                HashMap<QName, Source> additionalSources = new HashMap<QName, Source>(additionalAssets.size());
                for (FXGSymbolClass additionalAsset : additionalAssets) {
                    Source additionalSource;
                    if (additionalAsset.getSymbol() == null || (additionalSource = this.generateAdditionalSource(unit, additionalAsset)) == null) continue;
                    QName additionalQName = new QName(additionalAsset.getPackageName(), additionalAsset.getClassName());
                    additionalSources.put(additionalQName, additionalSource);
                }
                unit.addGeneratedSources(additionalSources);
            }
            return generatedSource;
        }

        private Source generateMainSource(CompilationUnit unit, String packageName, String className, FXGSymbolClass asset) throws IOException {
            Source originalSource = unit.getSource();
            String generatedName = FXGCompiler.this.getGeneratedFileName(packageName, className, "-generated.as");
            if (FXGCompiler.this.generatedOutputDir != null) {
                new File(generatedName).getParentFile().mkdirs();
                FileUtil.writeFile(generatedName, asset.getGeneratedSource());
            }
            TextFile generatedFile = new TextFile(asset.getGeneratedSource(), generatedName, originalSource.getParent(), "text/as", originalSource.getLastModified());
            AssetInfo assetInfo = new AssetInfo(asset.getSymbol(), generatedFile, originalSource.getLastModified(), null);
            unit.getAssets().add(asset.getQualifiedClassName(), assetInfo);
            Source generatedSource = new Source(generatedFile, originalSource);
            generatedSource.setAssetInfo(assetInfo);
            return generatedSource;
        }

        private Source generateAdditionalSource(CompilationUnit unit, FXGSymbolClass asset) throws IOException {
            Source originalSource = unit.getSource();
            String packageName = asset.getPackageName();
            String className = asset.getClassName();
            String generatedName = FXGCompiler.this.getGeneratedFileName(packageName, className, ".as");
            if (FXGCompiler.this.generatedOutputDir != null) {
                new File(generatedName).getParentFile().mkdirs();
                FileUtil.writeFile(generatedName, asset.getGeneratedSource());
            }
            TextFile generatedFile = new TextFile(asset.getGeneratedSource(), generatedName, originalSource.getParent(), "text/as", originalSource.getLastModified());
            AssetInfo assetInfo = new AssetInfo(asset.getSymbol(), generatedFile, originalSource.getLastModified(), null);
            unit.getAssets().add(asset.getQualifiedClassName(), assetInfo);
            String relativePath = "";
            if (packageName != null) {
                relativePath = packageName.replace('.', '/');
            }
            Source generatedSource = new Source((VirtualFile)generatedFile, relativePath, className, null, false, false, false);
            generatedSource.setAssetInfo(assetInfo);
            generatedSource.setPathResolver(unit.getSource().getPathResolver());
            return generatedSource;
        }

        private FXGSymbolClass transcodeFXG(CompilationUnit unit, String packageName, String className, TypeTable typeTable) {
            FXGNode rootNode = (FXGNode)unit.getContext().getAttribute(FXGCompiler.FXG_DOM_ROOT);
            FlexFXG2SWFTranscoder transcoder = new FlexFXG2SWFTranscoder(typeTable);
            PathResolver pathResolver = unit.getSource().getPathResolver();
            FlexResourceResolver resolver = new FlexResourceResolver(pathResolver);
            transcoder.setResourceResolver(resolver);
            FXGSymbolClass asset = transcoder.transcode(rootNode, packageName, className);
            return asset;
        }
    }

    private final class SkeletonCompiler
    extends AbstractDelegatingSubCompiler {
        private SkeletonCompiler(CompilerConfiguration config) {
            As3Compiler asc = new As3Compiler(config);
            this.delegateSubCompiler = asc;
        }

        public String getName() {
            return FXGCompiler.COMPILER_NAME;
        }

        public boolean isSupported(String mimeType) {
            return FXGCompiler.this.isSupported(mimeType);
        }

        public String[] getSupportedMimeTypes() {
            return FXGCompiler.this.getSupportedMimeTypes();
        }

        public CompilationUnit parse1(Source source, SymbolTable symbolTable) {
            CompilerContext context = new CompilerContext();
            CompilationUnit unit = source.newCompilationUnit(null, context);
            FXGCompiler.this.setupLogger();
            FXGParser parser = FXGParserFactory.createDefaultParser();
            parser.registerElementNode(1.0, "http://ns.adobe.com/fxg/2008", "Graphic", FlexGraphicNode.class);
            parser.registerElementNode(1.0, "http://ns.adobe.com/fxg/2008", "TextGraphic", FlexTextGraphicNode.class);
            parser.registerElementNode(1.0, "http://ns.adobe.com/fxg/2008", "p", FlexParagraphNode.class);
            parser.registerElementNode(1.0, "http://ns.adobe.com/fxg/2008", "span", FlexSpanNode.class);
            parser.registerElementNode(2.0, "http://ns.adobe.com/fxg/2008", "Graphic", FlexGraphicNode.class);
            parser.registerElementNode(2.0, "http://ns.adobe.com/fxg/2008", "RichText", FlexRichTextNode.class);
            try {
                FXGNode node = parser.parse(source.getInputStream(), source.getNameForReporting());
                context.setAttribute(FXGCompiler.FXG_DOM_ROOT, node);
                QName topLevelQName = FXGCompiler.getQNameFromSource(source);
                unit.topLevelDefinitions.add(topLevelQName);
                unit.inheritance.add(MULTINAME_SPRITEVISUALELEMENT);
            }
            catch (FXGException ex) {
                ThreadLocalToolkit.log((CompilerMessage)new FXGParseException(ex), source, ex.getLineNumber(), ex.getColumnNumber());
                unit = null;
            }
            catch (IOException ex) {
                ThreadLocalToolkit.log((CompilerMessage)new FXGParseException(ex), source);
                unit = null;
            }
            return unit;
        }

        public void parse2(CompilationUnit unit, SymbolTable symbolTable) {
            Source generatedSource = null;
            Source originalSource = unit.getSource();
            FXGNode rootNode = (FXGNode)unit.getContext().getAttribute(FXGCompiler.FXG_DOM_ROOT);
            boolean hasTextGraphic = false;
            double version = 1.0;
            if (rootNode instanceof FlexGraphicNode) {
                FlexGraphicNode graphicNode = (FlexGraphicNode)rootNode;
                FXGVersion v = graphicNode.getVersion();
                version = v != null ? v.asDouble() : 1.0;
                hasTextGraphic = graphicNode.hasText;
            }
            try {
                generatedSource = this.generateSource(originalSource, symbolTable, version, hasTextGraphic);
            }
            catch (IOException ex) {
                ThreadLocalToolkit.log((CompilerMessage)new SourceGenerationException(ex), originalSource);
                return;
            }
            CompilationUnit interfaceUnit = this.delegateSubCompiler.parse1(generatedSource, symbolTable);
            if (interfaceUnit == null) {
                return;
            }
            unit.getSource().addFileIncludes(interfaceUnit.getSource());
            unit.getContext().setAttribute("DelegateUnit", interfaceUnit);
            Source.transferMetaData(interfaceUnit, unit);
            this.delegateSubCompiler.parse2(interfaceUnit, symbolTable);
        }

        public void generate(CompilationUnit unit, SymbolTable symbolTable) {
        }

        private Source generateSource(Source originalSource, SymbolTable symbolTable, double version, boolean hasText) throws IOException {
            String className = originalSource.getShortName();
            String packageName = originalSource.getRelativePath().replace('/', '.');
            String generatedName = FXGCompiler.this.getGeneratedFileName(packageName, className, "-interface.as");
            StringBuilder buf = new StringBuilder(384);
            buf.append("package ").append(packageName).append("\n{\n\n");
            if (hasText) {
                if (version >= 2.0) {
                    buf.append("import flashx.textLayout.elements.*;\n");
                    buf.append("import flashx.textLayout.formats.TextLayoutFormat;\n");
                } else {
                    buf.append("import flashx.textLayout.elements.ParagraphElement;\n");
                    buf.append("import flashx.textLayout.elements.SpanElement;\n");
                }
                buf.append("import spark.components.RichText;\n");
            }
            buf.append("import spark.core.SpriteVisualElement;\n\n");
            buf.append("public class ").append(className).append(" extends SpriteVisualElement\n{\n");
            buf.append("    public function ").append(className).append("()\n");
            buf.append("    {\n");
            buf.append("        super();\n");
            buf.append("    }\n\n");
            if (hasText) {
                buf.append("    private static var _temp0:ParagraphElement;\n");
                buf.append("    private static var _temp1:SpanElement;\n");
                buf.append("    private static var _temp2:RichText;\n");
                if (version >= 2.0) {
                    buf.append("    private static var _temp3:DivElement;\n");
                    buf.append("    private static var _temp4:InlineGraphicElement;\n");
                    buf.append("    private static var _temp5:LinkElement;\n");
                    buf.append("    private static var _temp6:TabElement;\n");
                    buf.append("    private static var _temp7:TCYElement;\n");
                    buf.append("    private static var _temp8:TextLayoutFormat;\n");
                }
            }
            buf.append("}\n");
            buf.append("}\n");
            String generatedCode = buf.toString();
            buf = null;
            TextFile generatedFile = new TextFile(generatedCode, generatedName, originalSource.getParent(), "text/as", originalSource.getLastModified());
            if (FXGCompiler.this.generatedOutputDir != null) {
                new File(generatedName).getParentFile().mkdirs();
                FileUtil.writeFile(generatedName, generatedCode);
            }
            Source generatedSource = new Source(generatedFile, originalSource);
            return generatedSource;
        }
    }
}

