/*
 * Decompiled with CFR 0.152.
 */
package flash.css;

import flash.css.Rule;
import flash.css.StyleDocumentHandler;
import flash.css.StyleParserErrorTranslator;
import flash.fonts.FontManager;
import flash.localization.LocalizationManager;
import flash.util.FileUtils;
import flash.util.Trace;
import flex2.compiler.Logger;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.ThreadLocalToolkit;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.batik.css.parser.Parser;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleParser {
    private int ruleIndex;
    private List<Rule> rules;
    private String cssPath;
    private boolean errorsExist;
    private String mxmlPath;
    private int mxmlLineNumberOffset;
    private Logger messageHandler;
    private FontManager fontManager;
    private Parser parser;
    private boolean checkDeprecation;

    public StyleParser(String cssPath, InputStream inputStream, Logger handler, FontManager fontManager, boolean checkDeprecation) {
        block4: {
            this.ruleIndex = 0;
            this.rules = new ArrayList<Rule>();
            this.errorsExist = false;
            this.cssPath = cssPath;
            this.fontManager = fontManager;
            this.checkDeprecation = checkDeprecation;
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                String charsetName = null;
                try {
                    charsetName = StyleParser.readCSSCharset(bufferedInputStream);
                }
                catch (StyleSheetInvalidCharset e) {
                    LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
                    String message = l10n.getLocalizedTextString((Object)new StyleSheetInvalidCharset(cssPath, e.charsetName));
                    handler.logError(message);
                    return;
                }
                FileUtils.consumeBOM((InputStream)bufferedInputStream, (String)charsetName);
                this.init(new InputStreamReader((InputStream)bufferedInputStream, charsetName), handler);
            }
            catch (IOException ioException) {
                handler.logError(cssPath, -1, ioException.getLocalizedMessage());
                if (!Trace.css && !Trace.error) break block4;
                ioException.printStackTrace();
            }
        }
    }

    public StyleParser(String mxmlPath, int mxmlLineNumber, Reader reader, Logger handler, FontManager fontManager, boolean checkDeprecation) {
        this.ruleIndex = 0;
        this.rules = new ArrayList<Rule>();
        this.errorsExist = false;
        this.mxmlPath = mxmlPath;
        this.mxmlLineNumberOffset = mxmlLineNumber - 1;
        this.fontManager = fontManager;
        this.checkDeprecation = checkDeprecation;
        this.init(reader, handler);
    }

    public StyleParser(String cssPath, Reader reader, Logger handler, FontManager fontManager, boolean checkDeprecation) {
        this.ruleIndex = 0;
        this.rules = new ArrayList<Rule>();
        this.errorsExist = false;
        this.cssPath = cssPath;
        this.fontManager = fontManager;
        this.checkDeprecation = checkDeprecation;
        this.init(reader, handler);
    }

    private void init(Reader reader, final Logger handler) {
        block2: {
            try {
                this.messageHandler = handler;
                ErrorHandler errorHandler = new ErrorHandler(){

                    public void error(CSSParseException exception) throws CSSException {
                        if (StyleParser.this.mxmlPath != null) {
                            handler.logError(StyleParser.this.mxmlPath, exception.getLineNumber(), StyleParserErrorTranslator.getUserFriendlyErrror(exception.getMessage()));
                            StyleParser.this.errorsExist = true;
                        } else {
                            handler.logError(StyleParser.this.cssPath, exception.getLineNumber(), StyleParserErrorTranslator.getUserFriendlyErrror(exception.getMessage()));
                            StyleParser.this.errorsExist = true;
                        }
                    }

                    public void fatalError(CSSParseException exception) throws CSSException {
                        if (StyleParser.this.mxmlPath != null) {
                            handler.logError(StyleParser.this.mxmlPath, exception.getLineNumber(), StyleParserErrorTranslator.getUserFriendlyErrror(exception.getMessage()));
                            StyleParser.this.errorsExist = true;
                        } else {
                            handler.logError(StyleParser.this.cssPath, exception.getLineNumber(), StyleParserErrorTranslator.getUserFriendlyErrror(exception.getMessage()));
                            StyleParser.this.errorsExist = true;
                        }
                    }

                    public void warning(CSSParseException exception) throws CSSException {
                        if (StyleParser.this.mxmlPath != null) {
                            handler.logWarning(StyleParser.this.mxmlPath, exception.getLineNumber(), StyleParserErrorTranslator.getUserFriendlyErrror(exception.getMessage()));
                        } else {
                            handler.logWarning(StyleParser.this.cssPath, exception.getLineNumber(), StyleParserErrorTranslator.getUserFriendlyErrror(exception.getMessage()));
                        }
                    }
                };
                this.parser = new Parser();
                this.parser.setLineNumberOffset(this.mxmlLineNumberOffset);
                this.parser.setDocumentHandler((DocumentHandler)new StyleDocumentHandler(this));
                this.parser.setErrorHandler(errorHandler);
                this.parser.parseStyleSheet(new InputSource(reader));
            }
            catch (Exception exception) {
                String path = this.mxmlPath != null ? this.mxmlPath : this.cssPath;
                handler.logError(path, -1, StyleParserErrorTranslator.getUserFriendlyErrror(exception.getLocalizedMessage()));
                if (!Trace.css && !Trace.error) break block2;
                exception.printStackTrace();
            }
        }
    }

    public boolean errorsExist() {
        return this.errorsExist;
    }

    public int getLineNumber() {
        return this.parser.getLineNumber();
    }

    int getMxmlLineNumber() {
        return this.mxmlLineNumberOffset;
    }

    public String getPath() {
        String path = this.mxmlPath;
        if (path == null) {
            path = this.cssPath;
        }
        return path;
    }

    public void addRule(Rule rule) {
        this.rules.add(rule);
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public Rule parseRule() {
        return this.rules.get(this.ruleIndex++);
    }

    public FontManager getFontManager() {
        return this.fontManager;
    }

    public void warnDeprecation(String deprecated, String replacement, int lineNumber) {
        if (this.checkDeprecation) {
            LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
            String message = l10n.getLocalizedTextString((Object)new DeprecatedWarning(deprecated, replacement, "3.0"));
            if (this.mxmlPath != null) {
                this.messageHandler.logWarning(this.mxmlPath, lineNumber, message);
            } else {
                this.messageHandler.logWarning(this.cssPath, lineNumber, message);
            }
        }
    }

    public void warning(CSSException cssException) {
        if ((Trace.css || Trace.error) && cssException.getException() != null) {
            cssException.getException().printStackTrace();
        }
        if (this.mxmlPath != null) {
            int lineNumber = this.parser.getLineNumber();
            this.messageHandler.logWarning(this.mxmlPath, lineNumber, StyleParserErrorTranslator.getUserFriendlyErrror(cssException.getMessage()));
        } else {
            int lineNumber = this.parser.getLineNumber();
            this.messageHandler.logWarning(this.cssPath, lineNumber, StyleParserErrorTranslator.getUserFriendlyErrror(cssException.getMessage()));
        }
    }

    public void error(CSSException cssException) {
        if ((Trace.css || Trace.error) && cssException.getException() != null) {
            cssException.getException().printStackTrace();
        }
        if (this.mxmlPath != null) {
            int lineNumber = this.parser.getLineNumber();
            this.messageHandler.logError(this.mxmlPath, lineNumber, StyleParserErrorTranslator.getUserFriendlyErrror(cssException.getMessage()));
        } else {
            int lineNumber = this.parser.getLineNumber();
            this.messageHandler.logError(this.cssPath, lineNumber, StyleParserErrorTranslator.getUserFriendlyErrror(cssException.getMessage()));
        }
    }

    public static String readCSSCharset(BufferedInputStream in) throws IOException, StyleSheetInvalidCharset {
        byte[][] leadingBytes = new byte[][]{{-17, -69, -65, 64, 99, 104, 97, 114, 115, 101, 116, 32, 34}, {-17, -69, -65}, {64, 99, 104, 97, 114, 115, 101, 116, 32, 34}, {-2, -1}, {-1, -2}};
        String[] charsetTable = new String[]{"specified", "UTF-8", "specified", "UTF-16BE", "UTF-16LE"};
        String charset = "UTF-8";
        int maxCharsetName = 40;
        int maxBytesToRead = 2 + (12 + maxCharsetName);
        in.mark(maxBytesToRead + 1);
        int found = -1;
        byte[] buffer = new byte[maxBytesToRead];
        int results = in.read(buffer);
        if (results == -1) {
            return charset;
        }
        for (int i = 0; i < leadingBytes.length; ++i) {
            byte[] bytes = leadingBytes[i];
            found = i;
            for (int j = 0; j < bytes.length; ++j) {
                if (bytes[j] == buffer[j]) continue;
                found = -1;
                break;
            }
            if (found != -1) break;
        }
        if (found != -1) {
            if ("specified".equals(charsetTable[found])) {
                int charsetIndex = leadingBytes[found].length;
                int charsetLength = 0;
                int quotePosition = -1;
                for (int i = leadingBytes[found].length; i < buffer.length; ++i) {
                    if (buffer[i] == 34) {
                        quotePosition = i;
                        break;
                    }
                    ++charsetLength;
                }
                if (quotePosition > 0 && quotePosition + 1 < buffer.length && buffer[quotePosition + 1] == 59) {
                    String testCharset = new String(buffer, charsetIndex, charsetLength, "US-ASCII");
                    try {
                        in.reset();
                        InputStreamReader reader = new InputStreamReader((InputStream)in, testCharset);
                        char[] chBuf = new char[14 + charsetLength];
                        reader.read(chBuf);
                        String specifiedCharaset = new String(chBuf);
                        if (specifiedCharaset.indexOf(testCharset) == -1) {
                            in.reset();
                            throw new StyleSheetInvalidCharset("", testCharset);
                        }
                        charset = testCharset;
                    }
                    catch (UnsupportedEncodingException e) {
                        in.reset();
                        throw new StyleSheetInvalidCharset("", testCharset);
                    }
                }
            } else {
                charset = charsetTable[found];
            }
        }
        in.reset();
        return charset;
    }

    public static class StyleSheetInvalidCharset
    extends CompilerMessage.CompilerWarning {
        private static final long serialVersionUID = -4363998590309962624L;
        public final String stylePath;
        public final String charsetName;

        public StyleSheetInvalidCharset(String stylePath, String charsetName) {
            this.stylePath = stylePath;
            this.charsetName = charsetName;
        }
    }

    public static class DeprecatedWarning
    extends CompilerMessage.CompilerWarning {
        private static final long serialVersionUID = 3832979911761729776L;
        public final String var;
        public final String replacement;
        public final String since;

        public DeprecatedWarning(String var, String replacement, String since) {
            this.var = var;
            this.replacement = replacement;
            this.since = since;
        }
    }
}

