/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.builder;

import flex2.compiler.CompilationUnit;
import flex2.compiler.mxml.MxmlConfiguration;
import flex2.compiler.mxml.Token;
import flex2.compiler.mxml.builder.ArrayBuilder;
import flex2.compiler.mxml.builder.ComponentBuilder;
import flex2.compiler.mxml.builder.InlineComponentBuilder;
import flex2.compiler.mxml.builder.ModelBuilder;
import flex2.compiler.mxml.builder.PrimitiveBuilder;
import flex2.compiler.mxml.builder.VectorBuilder;
import flex2.compiler.mxml.builder.XMLBuilder;
import flex2.compiler.mxml.builder.XMLListBuilder;
import flex2.compiler.mxml.dom.AnalyzerAdapter;
import flex2.compiler.mxml.dom.ArrayNode;
import flex2.compiler.mxml.dom.CDATANode;
import flex2.compiler.mxml.dom.InlineComponentNode;
import flex2.compiler.mxml.dom.ModelNode;
import flex2.compiler.mxml.dom.Node;
import flex2.compiler.mxml.dom.PrimitiveNode;
import flex2.compiler.mxml.dom.ReparentNode;
import flex2.compiler.mxml.dom.StateNode;
import flex2.compiler.mxml.dom.VectorNode;
import flex2.compiler.mxml.dom.XMLListNode;
import flex2.compiler.mxml.dom.XMLNode;
import flex2.compiler.mxml.lang.FrameworkDefs;
import flex2.compiler.mxml.lang.NodeTypeResolver;
import flex2.compiler.mxml.lang.TextParser;
import flex2.compiler.mxml.lang.TypeCompatibility;
import flex2.compiler.mxml.lang.ValueNodeHandler;
import flex2.compiler.mxml.reflect.Assignable;
import flex2.compiler.mxml.reflect.DynamicProperty;
import flex2.compiler.mxml.reflect.Effect;
import flex2.compiler.mxml.reflect.Event;
import flex2.compiler.mxml.reflect.Inspectable;
import flex2.compiler.mxml.reflect.Property;
import flex2.compiler.mxml.reflect.Style;
import flex2.compiler.mxml.reflect.Type;
import flex2.compiler.mxml.reflect.TypeTable;
import flex2.compiler.mxml.rep.Array;
import flex2.compiler.mxml.rep.AtClear;
import flex2.compiler.mxml.rep.AtEmbed;
import flex2.compiler.mxml.rep.AtResource;
import flex2.compiler.mxml.rep.BindingExpression;
import flex2.compiler.mxml.rep.Model;
import flex2.compiler.mxml.rep.MxmlDocument;
import flex2.compiler.mxml.rep.Primitive;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.MxmlCommentUtil;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.QName;
import flex2.compiler.util.ThreadLocalToolkit;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBuilder
extends AnalyzerAdapter {
    protected TypeTable typeTable;
    protected MxmlDocument document;
    protected NodeTypeResolver nodeTypeResolver;
    protected TextValueParser textParser;
    protected RValueNodeHandler rvalueNodeHandler;

    AbstractBuilder(CompilationUnit unit, TypeTable typeTable, MxmlConfiguration mxmlConfiguration, MxmlDocument document) {
        super(unit, mxmlConfiguration);
        this.typeTable = typeTable;
        this.document = document;
        this.nodeTypeResolver = new NodeTypeResolver(typeTable);
        this.textParser = new TextValueParser(typeTable);
        this.rvalueNodeHandler = new RValueNodeHandler();
    }

    protected boolean processPropertyText(Property property, String text, int origin, int line, Model model) {
        String name = property.getName();
        this.ensureSingleInitializer(model, name, line, property.getStateName());
        if (!this.checkPropertyUsage(property, text, line)) {
            return false;
        }
        int flags = (origin == TextOrigin.FROM_CHILD_CDATA ? 1 : 0) | (this.getIsColor(property) ? 4 : 0) | (origin != TextOrigin.FROM_ATTRIBUTE && property.collapseWhiteSpace() ? 2 : 0) | (this.getPercentProxy(model.getType(), property, line) != null ? 8 : 0) | (property.richTextContent() ? 256 : 0);
        Object value = this.textParser.parseValue(text, property.getType(), property.getElementType(), flags, line, name);
        if (value != null) {
            this.postProcessBindingExpression(value, model, name);
            if (this.textParser.wasPercentage()) {
                property = this.getPercentProxy(model.getType(), property, line);
            } else if (value instanceof AtClear && !property.isStateSpecific()) {
                this.log(line, (CompilerMessage)new ClearNotAllowed());
                return false;
            }
            model.setProperty(property, value, line);
            return true;
        }
        return false;
    }

    protected boolean processDynamicPropertyText(String name, String text, int origin, int line, Model model, String state) {
        this.ensureSingleInitializer(model, name, line, state);
        int flags = origin == TextOrigin.FROM_CHILD_CDATA ? 1 : 0;
        Object value = this.textParser.parseValue(text, this.typeTable.objectType, this.typeTable.objectType, flags, line, name);
        if (value != null) {
            this.postProcessBindingExpression(value, model, name);
            model.setDynamicProperty(this.typeTable.objectType, name, value, state, line);
            return true;
        }
        return false;
    }

    protected boolean processStateAttributes(Node node, Model model) {
        String includedStates = (String)this.getLanguageAttributeValue(node, "includeIn");
        String excludedStates = (String)this.getLanguageAttributeValue(node, "excludeFrom");
        String itemCreationPolicy = (String)this.getLanguageAttributeValue(node, "itemCreationPolicy");
        String itemDestructionPolicy = (String)this.getLanguageAttributeValue(node, "itemDestructionPolicy");
        if (includedStates != null && TextParser.isBindingExpression(includedStates)) {
            this.log(node, (CompilerMessage)new BindingNotAllowedInitializer("includeIn", includedStates));
        }
        if (excludedStates != null && TextParser.isBindingExpression(excludedStates)) {
            this.log(node, (CompilerMessage)new BindingNotAllowedInitializer("excludeFrom", excludedStates));
        }
        if (includedStates != null || excludedStates != null) {
            Collection<String> includes = TextParser.parseStringList(includedStates);
            Collection<String> excludes = TextParser.parseStringList(excludedStates);
            this.document.registerStateSpecificNode(model, node, includes, excludes);
            if (itemCreationPolicy != null) {
                if (itemCreationPolicy.equals("immediate")) {
                    this.document.registerEarlyInitNode(model);
                } else if (!itemCreationPolicy.equals("deferred")) {
                    this.log(model.getXmlLineNumber(), (CompilerMessage)new InvalidItemCreationPolicy());
                }
            }
            if (itemDestructionPolicy != null) {
                if (itemDestructionPolicy.equals("auto")) {
                    model.setIsTransient(true);
                } else if (!itemDestructionPolicy.equals("never")) {
                    this.log(model.getXmlLineNumber(), (CompilerMessage)new InvalidItemDestructionPolicy());
                }
            }
            return true;
        }
        if (itemCreationPolicy != null) {
            this.log(model.getXmlLineNumber(), (CompilerMessage)new InvalidItemCreationPolicyUsage());
        }
        if (itemDestructionPolicy != null) {
            this.log(model.getXmlLineNumber(), (CompilerMessage)new InvalidItemDestructionPolicyUsage());
        }
        return false;
    }

    protected boolean getIsColor(Property property) {
        String type;
        Inspectable inspectable = property.getInspectable();
        if (inspectable != null && (type = inspectable.getFormat()) != null) {
            return type.equals("Color");
        }
        return false;
    }

    protected Property getPercentProxy(Type type, Property property, int line) {
        String percentProxyName = property.getPercentProxy();
        if (percentProxyName != null) {
            Property percentProxy = type.getProperty(percentProxyName);
            if (percentProxy != null) {
                percentProxy.setStateName(property.getStateName());
                return percentProxy;
            }
            this.log(line, (CompilerMessage)new PercentProxyWarning(percentProxyName, property.getName(), NameFormatter.toDot(type.getName())));
            return null;
        }
        return null;
    }

    private void postProcessBindingExpression(Object value, Model model, String name) {
        if (value instanceof BindingExpression) {
            BindingExpression bindingExpression = (BindingExpression)value;
            bindingExpression.setDestination(model);
            bindingExpression.setDestinationLValue(name);
            bindingExpression.setDestinationProperty(name);
        }
    }

    private void ensureSingleInitializer(Model model, String name, int line, String state) {
        if (model.hasProperty(name) && state == null) {
            Type type = model.getType();
            Property dp = type.getDefaultProperty();
            if (dp != null && dp.getName().equals(name)) {
                this.log(line, (CompilerMessage)new MultiplePropertyInitializerWithDefaultError(name, NameFormatter.toDot(type.getName())));
            } else {
                this.log(line, (CompilerMessage)new MultiplePropertyInitializerError(name));
            }
        }
    }

    protected void processEventText(Event event, String text, int line, Model model) {
        if (text.length() > 0) {
            Type eventType = event.getType();
            if (eventType == null) {
                this.log(line, (CompilerMessage)new EventTypeUnavailable(event.getTypeName()));
                return;
            }
            this.document.addImport(NameFormatter.toDot(eventType.getName()), line);
            if (text.equals("@Clear()") && !event.isStateSpecific()) {
                this.log(line, (CompilerMessage)new ClearNotAllowed());
                return;
            }
            model.setEvent(event, text, line);
        } else {
            this.log(line, (CompilerMessage)new EventHandlerEmpty());
        }
    }

    public boolean processStyleText(Style style, String text, int origin, int line, Model model) {
        String name = style.getName();
        Type type = style.getType();
        if (!style.isStateSpecific() && model.hasStyle(name)) {
            this.log(line, (CompilerMessage)new MultipleStyleInitializerError(name));
        }
        if (!this.checkStyleUsage(style, text, line)) {
            return false;
        }
        int flags = (origin == TextOrigin.FROM_CHILD_CDATA ? 1 : 0) | (this.getIsColor(style) ? 4 : 0);
        Object value = this.textParser.parseValue(text, type, flags, line, name);
        if (value != null) {
            if (value instanceof BindingExpression) {
                BindingExpression bindingExpression = (BindingExpression)value;
                if (bindingExpression.isTwoWayPrimary()) {
                    this.log(line, (CompilerMessage)new TwoWayBindingNotAllowedInitializer(name, text));
                    return false;
                }
                bindingExpression.setDestination(model);
                bindingExpression.setDestinationLValue(name);
                bindingExpression.setDestinationStyle(name);
            } else if (value instanceof AtClear && !style.isStateSpecific()) {
                this.log(line, (CompilerMessage)new AtClearNotAllowed());
                return false;
            }
            model.setStyle(style, value, line);
            return true;
        }
        return false;
    }

    protected boolean getIsColor(Style style) {
        String format = style.getFormat();
        return format != null && format.equals("Color");
    }

    protected boolean processEffectText(Effect effect, String text, int origin, int line, Model model) {
        int flags;
        Object value;
        String name = effect.getName();
        if (!effect.isStateSpecific() && model.hasEffect(name)) {
            this.log(line, (CompilerMessage)new MultipleEffectInitializerError(name));
        }
        if ((value = this.textParser.parseValue(text, this.typeTable.stringType, flags = origin == TextOrigin.FROM_CHILD_CDATA ? 1 : 0, line, name)) != null) {
            if (value instanceof BindingExpression) {
                BindingExpression bindingExpression = (BindingExpression)value;
                if (bindingExpression.isTwoWayPrimary()) {
                    this.log(line, (CompilerMessage)new TwoWayBindingNotAllowedInitializer(name, text));
                    return false;
                }
                bindingExpression.setDestination(model);
                bindingExpression.setDestinationStyle(name);
                bindingExpression.setDestinationLValue(name);
            } else if (FrameworkDefs.isBuiltinEffectName(text)) {
                this.document.addTypeRef(this.standardDefs.getEffectsPackage() + "." + text, line);
            }
            model.setEffect(effect, value, this.typeTable.stringType, line);
            return true;
        }
        return false;
    }

    protected boolean processPropertyNodes(Node parent, Property property, Model model) {
        return this.processPropertyNodes(parent.getChildren(), property, model, parent.beginLine);
    }

    protected boolean processPropertyNodes(Collection nodes, Property property, Model model, int line) {
        CDATANode cdata = this.getTextContent(nodes, true);
        if (cdata != null) {
            return this.processPropertyText(property, cdata.image, TextOrigin.fromChild(cdata.inCDATA), cdata.beginLine, model);
        }
        String name = property.getName();
        this.ensureSingleInitializer(model, name, line, property.getStateName());
        if (!this.checkPropertyUsage(property, "", ((Node)nodes.iterator().next()).beginLine)) {
            return false;
        }
        Object rvalue = this.processRValueNodes(property, nodes, model);
        if (rvalue != null) {
            model.setProperty(property, rvalue, line);
            return true;
        }
        return false;
    }

    protected boolean processDynamicPropertyNodes(Node parent, DynamicProperty property, Model model) {
        Object rvalue;
        List<Token> nodes = parent.getChildren();
        String name = property.getName();
        String state = property.getStateName();
        CDATANode cdata = this.getTextContent(nodes, true);
        if (cdata != null) {
            return this.processDynamicPropertyText(name, cdata.image, TextOrigin.fromChild(cdata.inCDATA), cdata.beginLine, model, state);
        }
        if (state == null && model.hasProperty(name)) {
            this.log(parent, (CompilerMessage)new MultiplePropertyInitializerError(name));
        }
        if ((rvalue = this.processRValueNodes(property, nodes, model)) != null) {
            model.setDynamicProperty(this.typeTable.objectType, name, rvalue, state, parent.beginLine);
            return true;
        }
        return false;
    }

    protected boolean processStyleNodes(Node parent, Style style, Model model) {
        Object rvalue;
        List<Token> nodes = parent.getChildren();
        CDATANode cdata = this.getTextContent(nodes, true);
        if (cdata != null) {
            return this.processStyleText(style, cdata.image, TextOrigin.fromChild(cdata.inCDATA), cdata.beginLine, model);
        }
        String name = style.getName();
        if (!style.isStateSpecific() && model.hasStyle(name)) {
            this.log(parent, (CompilerMessage)new MultipleStyleInitializerError(name));
        }
        if (!this.checkStyleUsage(style, "", ((Node)nodes.iterator().next()).beginLine)) {
            return false;
        }
        Type lvalueType = style.getType();
        if (this.standardDefs.isIDeferredInstance(lvalueType)) {
            lvalueType = this.typeTable.objectType;
        }
        if ((rvalue = this.processRValueNodes(style, nodes, model)) != null) {
            model.setStyle(style, rvalue, parent.beginLine);
            return true;
        }
        return false;
    }

    protected boolean processEffectNodes(Node parent, Effect effect, Model model) {
        Object rvalue;
        List<Token> nodes = parent.getChildren();
        CDATANode cdata = this.getTextContent(nodes, true);
        if (cdata != null) {
            return this.processEffectText(effect, cdata.image, TextOrigin.fromChild(cdata.inCDATA), cdata.beginLine, model);
        }
        String name = effect.getName();
        if (!effect.isStateSpecific() && model.hasEffect(name)) {
            this.log(parent, (CompilerMessage)new MultipleEffectInitializerError(name));
        }
        if ((rvalue = this.processRValueNodes(effect, nodes, model)) != null) {
            model.setEffect(effect, rvalue, effect.getType(), parent.beginLine);
            return true;
        }
        return false;
    }

    protected Object processRValueNodes(Assignable assignable, Collection nodes, Model model) {
        Type elementStoreType;
        Type type = assignable.getLValueType();
        String name = assignable.getName();
        Type elementParseType = elementStoreType = assignable.getElementType();
        if (assignable instanceof Property) {
            Property property = (Property)assignable;
            if (this.standardDefs.isIDeferredInstance(elementStoreType)) {
                elementParseType = property.getInstanceType();
            }
        }
        boolean isDefaultProperty = false;
        Property defaultProperty = model.getType().getDefaultProperty();
        if (defaultProperty != null) {
            isDefaultProperty = defaultProperty.getName().equals(name);
        }
        switch (this.checkTypeCompatibility(nodes, type, elementParseType, name, isDefaultProperty)) {
            case 0: {
                return this.rvalueNodeHandler.process(assignable, (Node)nodes.iterator().next(), model);
            }
            case 1: {
                ArrayBuilder arrayBuilder = new ArrayBuilder(this.unit, this.typeTable, this.mxmlConfiguration, this.document, model, assignable, false);
                arrayBuilder.createSyntheticArrayModel(((Node)nodes.iterator().next()).beginLine);
                arrayBuilder.processChildren(nodes);
                return arrayBuilder.array;
            }
            case 2: {
                VectorBuilder vectorBuilder = new VectorBuilder(this.unit, this.typeTable, this.mxmlConfiguration, this.document, model, assignable, false);
                vectorBuilder.createSyntheticVectorModel(((Node)nodes.iterator().next()).beginLine);
                vectorBuilder.processChildren(nodes);
                return vectorBuilder.vector;
            }
        }
        return null;
    }

    protected final Model instanceFromClass(String className, int line, boolean checkClass) {
        Type classType;
        if (checkClass && (classType = this.typeTable.getType(NameFormatter.toColon(className))) == null) {
            this.log(line, (CompilerMessage)new ClassNotAvailable(className));
        }
        return new Primitive(this.document, this.typeTable.classType, className, line);
    }

    protected final Model factoryFromClass(String className, int line) {
        Type classFactoryType = this.typeTable.getType(this.standardDefs.CLASS_CLASSFACTORY);
        if (classFactoryType == null) {
            this.log(line, (CompilerMessage)new TypeNotAvailable(this.standardDefs.CLASS_CLASSFACTORY));
            return new Model(this.document, this.typeTable.objectType, line);
        }
        Model model = new Model(this.document, classFactoryType, line);
        model.setProperty("generator", new Primitive(this.document, this.typeTable.classType, className, line));
        Type classType = this.typeTable.getType(NameFormatter.toColon(className));
        if (classType != null) {
            Model propObject = null;
            Property outerDocumentProperty = classType.getProperty("outerDocument");
            if (outerDocumentProperty != null) {
                String qualName = this.document.getQName().toString();
                Type selfType = this.typeTable.getType(qualName);
                assert (selfType != null) : "skeleton type for class '" + NameFormatter.toDot(qualName) + "' not available";
                if (selfType.isAssignableTo(outerDocumentProperty.getType())) {
                    propObject = new Model(this.document, this.typeTable.objectType, line);
                    propObject.setProperty(outerDocumentProperty, (Object)new Primitive(this.document, this.typeTable.classType, "this", line), line);
                }
            }
            if (propObject != null) {
                model.setProperty("properties", propObject);
            }
        }
        return model;
    }

    private int checkTypeCompatibility(Collection<Node> nodes, Type lvalueType, Type lvalueArrayElemType, String lvalueDesc, boolean isDefaultProperty) {
        switch (nodes.size()) {
            case 0: {
                assert (false);
                return 3;
            }
            case 1: {
                return this.checkTypeCompatibility(nodes.iterator().next(), lvalueType, lvalueArrayElemType, lvalueDesc, true, isDefaultProperty);
            }
        }
        int compat = 0;
        for (Node node : nodes) {
            int elementCompat = this.checkTypeCompatibility(node, lvalueType, lvalueArrayElemType, lvalueDesc, false, isDefaultProperty);
            if (compat != 0 && compat != 1 && compat != 2) continue;
            compat = elementCompat;
        }
        return compat;
    }

    protected int checkTypeCompatibility(Node node, Type lvalueType, Type lvalueArrayElementType, String lvalueDescription, boolean rvalueIsSingleton, boolean isDefaultProperty) {
        Type rtype = this.nodeTypeResolver.resolveType(node, this.document);
        String rvalueTypeName = rtype != null ? rtype.getName() : node.getLocalPart();
        int compat = TypeCompatibility.check(lvalueType, lvalueArrayElementType, rtype, rvalueIsSingleton, this.standardDefs);
        compat = this.coerceStatefulNodes(node, lvalueType, compat);
        switch (compat) {
            case 0: 
            case 1: 
            case 2: {
                return compat;
            }
            case 3: {
                if (isDefaultProperty) {
                    this.log(node.beginLine, (CompilerMessage)new TypeNotAssignableToDefaultProperty(lvalueDescription, NameFormatter.toDot(rvalueTypeName), NameFormatter.toDot(lvalueType.getName())));
                } else {
                    this.log(node.beginLine, (CompilerMessage)new TypeNotAssignableToLType(lvalueDescription, NameFormatter.toDot(rvalueTypeName), NameFormatter.toDot(lvalueType.getName())));
                }
                return compat;
            }
            case 4: {
                if (isDefaultProperty) {
                    this.log(node.beginLine, (CompilerMessage)new DefaultPropertyNotMultiple(lvalueDescription, NameFormatter.toDot(lvalueType.getName())));
                } else {
                    this.log(node.beginLine, (CompilerMessage)new TypeNotMultiple(lvalueDescription, NameFormatter.toDot(lvalueType.getName())));
                }
                return compat;
            }
            case 5: {
                this.log(node.beginLine, (CompilerMessage)new SingleRValueNotTargetTypeOrTargetElementType(lvalueDescription, NameFormatter.toDot(rvalueTypeName), NameFormatter.toDot(lvalueType.getName()), NameFormatter.toDot(lvalueArrayElementType.getName())));
                return compat;
            }
            case 6: {
                this.log(node.beginLine, (CompilerMessage)new MultiRValueNotElementType(lvalueDescription, NameFormatter.toDot(rvalueTypeName), NameFormatter.toDot(lvalueType.getName()), NameFormatter.toDot(lvalueArrayElementType.getName())));
                return compat;
            }
        }
        assert (false);
        return compat;
    }

    protected int coerceStatefulNodes(Node node, Type lvalueType, int compat) {
        if (node instanceof ReparentNode) {
            return 1;
        }
        if (compat == 0 && (lvalueType.getName().equals("*") || lvalueType.getName().equals("Object")) && (this.getLanguageAttribute(node, "includeIn") != null || this.getLanguageAttribute(node, "excludeFrom") != null)) {
            return 1;
        }
        return compat;
    }

    protected boolean checkPropertyUsage(Property property, String text, int line) {
        Inspectable inspectable;
        if (!this.isAllowedProperty(property)) {
            this.log(line, (CompilerMessage)new InitializerNotAllowed(property.getName()));
            return false;
        }
        if (this.mxmlConfiguration.showDeprecationWarnings()) {
            AbstractBuilder.checkDeprecation(property, this.document.getSourcePath(), line);
        }
        if ((inspectable = property.getInspectable()) != null) {
            this.checkImageType(inspectable.getFormat(), text, line);
            if (!TextParser.isBindingExpression(text) && !this.checkEnumeration(inspectable.getEnumeration(), text, line)) {
                return false;
            }
        }
        if (property.readOnly()) {
            this.log(line, (CompilerMessage)new PropertyReadOnly(property.getName()));
            return false;
        }
        if (property.getType() == null) {
            this.log(line, (CompilerMessage)new PropertyUnreachable(property.getName()));
            return false;
        }
        return true;
    }

    protected boolean isAllowedProperty(Property property) {
        return true;
    }

    protected boolean checkStyleUsage(Style style, String text, int line) {
        this.checkImageType(style.getFormat(), text, line);
        if (!TextParser.isBindingExpression(text) && TextParser.getAtFunctionName(text) == null && !this.checkEnumeration(style.getEnumeration(), text, line)) {
            return false;
        }
        if (style.getType() == null) {
            this.log(line, (CompilerMessage)new StyleUnreachable(style.getName()));
            return false;
        }
        return true;
    }

    protected boolean checkEnumeration(String[] enums, String value, int line) {
        if (enums != null) {
            int count = enums.length;
            for (int j = 0; j < count; ++j) {
                if (!enums[j].equals(value)) continue;
                return true;
            }
            StringBuilder buffer = new StringBuilder();
            int count2 = enums.length;
            for (int j = 0; j < count2; ++j) {
                buffer.append(enums[j]);
                if (j >= count2 - 1) continue;
                buffer.append(", ");
            }
            this.log(line, (CompilerMessage)new InvalidEnumerationValue(value, buffer.toString()));
            return false;
        }
        return true;
    }

    protected boolean checkImageType(String format, String value, int line) {
        if ("File".equals(format) && value.endsWith(".svg")) {
            this.log(line, (CompilerMessage)new RuntimeSVGNotSupported());
            return false;
        }
        return true;
    }

    private static boolean checkLogDeprecationWarning(String path, int line, String name, String since, String message, String replacement) {
        boolean hasReplacement;
        assert (name != null && name.length() > 0);
        boolean hasSince = since != null && since.length() > 0;
        boolean hasMessage = message != null && message.length() > 0;
        boolean bl = hasReplacement = replacement != null && replacement.length() > 0;
        if (hasMessage) {
            ThreadLocalToolkit.log((CompilerMessage)new DeprecatedMessage(message), path, line);
        } else if (hasReplacement) {
            if (hasSince) {
                ThreadLocalToolkit.log((CompilerMessage)new DeprecatedSince(name, since, replacement), path, line);
            } else {
                ThreadLocalToolkit.log((CompilerMessage)new DeprecatedUseReplacement(name, replacement), path, line);
            }
        } else if (hasSince) {
            ThreadLocalToolkit.log((CompilerMessage)new DeprecatedSinceNoReplacement(name, since), path, line);
        } else if (message != null || replacement != null || since != null) {
            ThreadLocalToolkit.log((CompilerMessage)new Deprecated(name), path, line);
        } else {
            return false;
        }
        return true;
    }

    public static boolean checkDeprecation(Property property, String path, int line) {
        flex2.compiler.mxml.reflect.Deprecated deprecated = property.getDeprecated();
        if (deprecated != null) {
            if (!AbstractBuilder.checkLogDeprecationWarning(path, line, property.getName(), deprecated.getSince(), deprecated.getMessage(), deprecated.getReplacement())) {
                ThreadLocalToolkit.log((CompilerMessage)new Deprecated(property.getName()), path, line);
            }
            return false;
        }
        return true;
    }

    protected void checkEventDeprecation(Event event, String path, int line) {
        if (this.mxmlConfiguration.showDeprecationWarnings()) {
            AbstractBuilder.checkLogDeprecationWarning(path, line, event.getName(), event.getDeprecatedSince(), event.getDeprecatedMessage(), event.getDeprecatedReplacement());
        }
    }

    protected void checkEffectDeprecation(Effect effect, String path, int line) {
        if (this.mxmlConfiguration.showDeprecationWarnings()) {
            AbstractBuilder.checkLogDeprecationWarning(path, line, effect.getName(), effect.getDeprecatedSince(), effect.getDeprecatedMessage(), effect.getDeprecatedReplacement());
        }
    }

    protected void checkStyleDeprecation(Style style, String path, int line) {
        if (this.mxmlConfiguration.showDeprecationWarnings()) {
            AbstractBuilder.checkLogDeprecationWarning(path, line, style.getName(), style.getDeprecatedSince(), style.getDeprecatedMessage(), style.getDeprecatedReplacement());
        }
    }

    protected boolean checkNonEmpty(Node node, Type type) {
        if (node.getChildren().isEmpty()) {
            if (!this.allowEmptyDefault(type)) {
                this.log(node.beginLine, (CompilerMessage)new EmptyChildInitializer(NameFormatter.toDot(type.getName())));
            }
            return false;
        }
        return true;
    }

    protected boolean allowEmptyDefault(Type type) {
        return this.typeTable.stringType.isAssignableTo(type);
    }

    protected boolean hasAttributeInitializers(Node node) {
        Iterator<QName> iter = node.getAttributeNames();
        while (iter.hasNext()) {
            QName qname = iter.next();
            if (this.isSpecialAttribute(qname.getNamespace(), qname.getLocalPart())) continue;
            return true;
        }
        return false;
    }

    protected boolean isSpecialAttribute(String namespaceURI, String localPart) {
        return false;
    }

    protected void registerModel(Node node, Model model, boolean topLevel) {
        String id = (String)this.getLanguageAttributeValue(node, "id");
        if (node.comment != null) {
            model.comment = !this.mxmlConfiguration.getGenerateAbstractSyntaxTree() ? node.comment : MxmlCommentUtil.commentToXmlComment(node.comment);
        }
        this.registerModel(id, model, topLevel);
    }

    protected void registerModel(String id, Model model, boolean topLevel) {
        if (id != null) {
            model.setId(id, false);
            this.document.addDeclaration(model, topLevel);
        } else if (topLevel) {
            this.document.addDeclaration(model, true);
        } else if (model.isDeclarationEnsured() && model.getIdIsAutogenerated()) {
            this.document.addDeclaration(model.getId(), model.getType().getName(), model.getXmlLineNumber(), true, true, true, model.getBindabilityEnsured());
        }
    }

    @Override
    protected int getDocumentVersion() {
        return this.document.getVersion();
    }

    @Override
    protected String getLanguageNamespace() {
        return this.document.getLanguageNamespace();
    }

    public static class InvalidItemDestructionPolicy
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -8851319646636091965L;
    }

    public static class InvalidItemDestructionPolicyUsage
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -8851319646636024265L;
    }

    public static class InvalidItemCreationPolicy
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -8851319647736091965L;
    }

    public static class InvalidItemCreationPolicyUsage
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -8851319647736024265L;
    }

    public static class ClearNotAllowed
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -8851319647736024265L;
    }

    public static class EmptyChildInitializer
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -6310661960438135244L;
        public String type;

        public EmptyChildInitializer(String type) {
            this.type = type;
        }
    }

    public static class DeprecatedSinceNoReplacement
    extends CompilerMessage.CompilerWarning {
        private static final long serialVersionUID = -2892937735469385339L;
        public String name;
        public String since;

        public DeprecatedSinceNoReplacement(String name, String since) {
            this.name = name;
            this.since = since;
        }
    }

    public static class DeprecatedSince
    extends CompilerMessage.CompilerWarning {
        private static final long serialVersionUID = 8941405158832020624L;
        public String name;
        public String replacement;
        public String since;

        public DeprecatedSince(String name, String since, String replacement) {
            this.name = name;
            this.since = since;
            this.replacement = replacement;
        }
    }

    public static class DeprecatedUseReplacement
    extends CompilerMessage.CompilerWarning {
        private static final long serialVersionUID = 6268273891441452672L;
        public String name;
        public String replacement;

        public DeprecatedUseReplacement(String name, String replacement) {
            this.name = name;
            this.replacement = replacement;
        }
    }

    public static class DeprecatedMessage
    extends CompilerMessage.CompilerWarning {
        private static final long serialVersionUID = -4559508730948651240L;
        public String deprecationMessage;

        public DeprecatedMessage(String deprecationMessage) {
            this.deprecationMessage = deprecationMessage;
        }
    }

    public static class Deprecated
    extends CompilerMessage.CompilerWarning {
        private static final long serialVersionUID = -7717466044221114090L;
        public String name;

        public Deprecated(String name) {
            this.name = name;
        }
    }

    public static class RuntimeSVGNotSupported
    extends CompilerMessage.CompilerWarning {
        private static final long serialVersionUID = -2904837796107529728L;
    }

    public static class InvalidEnumerationValue
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 6028640604926009874L;
        public String value;
        public String values;

        public InvalidEnumerationValue(String value, String values) {
            this.value = value;
            this.values = values;
        }
    }

    public static class StyleUnreachable
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -907081582545856406L;
        public String name;

        public StyleUnreachable(String name) {
            this.name = name;
        }
    }

    public static class PropertyUnreachable
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -8232851717762250700L;
        public String name;

        public PropertyUnreachable(String name) {
            this.name = name;
        }
    }

    public static class PropertyReadOnly
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -7534712819383293242L;
        public String name;

        public PropertyReadOnly(String name) {
            this.name = name;
        }
    }

    public static class InitializerNotAllowed
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -5647720336849700770L;
        public String name;

        public InitializerNotAllowed(String name) {
            this.name = name;
        }
    }

    public static class MultiRValueNotElementType
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 3496264868863398700L;
        public String lvalue;
        public String type;
        public String targetType;
        public String targetElementType;

        public MultiRValueNotElementType(String lvalue, String type, String targetType, String targetElementType) {
            this.lvalue = lvalue;
            this.type = type;
            this.targetType = targetType;
            this.targetElementType = targetElementType;
        }
    }

    public static class SingleRValueNotTargetTypeOrTargetElementType
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 2707598764290534991L;
        public String lvalue;
        public String type;
        public String targetType;
        public String targetElementType;

        public SingleRValueNotTargetTypeOrTargetElementType(String lvalue, String type, String targetType, String targetElementType) {
            this.lvalue = lvalue;
            this.type = type;
            this.targetType = targetType;
            this.targetElementType = targetElementType;
        }
    }

    public static class TypeNotMultiple
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -226195643462502028L;
        public String lvalue;
        public String targetType;

        public TypeNotMultiple(String lvalue, String targetType) {
            this.lvalue = lvalue;
            this.targetType = targetType;
        }
    }

    public static class DefaultPropertyNotMultiple
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -226195643462502027L;
        public String defaultProperty;
        public String targetType;

        public DefaultPropertyNotMultiple(String defaultProperty, String targetType) {
            this.defaultProperty = defaultProperty;
            this.targetType = targetType;
        }
    }

    public static class TypeNotAssignableToLType
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 3170516169562771496L;
        public String lvalue;
        public String type;
        public String targetType;

        public TypeNotAssignableToLType(String lvalue, String type, String targetType) {
            this.lvalue = lvalue;
            this.type = type;
            this.targetType = targetType;
        }
    }

    public static class TypeNotAssignableToDefaultProperty
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 3170516169562771495L;
        public String defaultProperty;
        public String type;
        public String targetType;

        public TypeNotAssignableToDefaultProperty(String defaultProperty, String type, String targetType) {
            this.defaultProperty = defaultProperty;
            this.type = type;
            this.targetType = targetType;
        }
    }

    public static class TypeNotAvailable
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 6652076396694350439L;
        public String type;

        public TypeNotAvailable(String type) {
            this.type = type;
        }
    }

    public static class ClassNotAvailable
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 2595556373093280868L;
        public String className;

        public ClassNotAvailable(String className) {
            this.className = className;
        }
    }

    public static class MultipleEffectInitializerError
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -1441380732951033404L;
        public String name;

        public MultipleEffectInitializerError(String name) {
            this.name = name;
        }
    }

    public static class MultipleStyleInitializerError
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -5623999245296398120L;
        public String name;

        public MultipleStyleInitializerError(String name) {
            this.name = name;
        }
    }

    public static class EventHandlerEmpty
    extends CompilerMessage.CompilerWarning {
        private static final long serialVersionUID = 7631512992578158817L;
    }

    public static class EventTypeUnavailable
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 1538004770687497485L;
        public String type;

        public EventTypeUnavailable(String type) {
            this.type = type;
        }
    }

    public static class MultiplePropertyInitializerWithDefaultError
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -2193960741080733281L;
        public String name;
        public String type;

        public MultiplePropertyInitializerWithDefaultError(String name, String type) {
            this.name = name;
            this.type = type;
        }
    }

    public static class MultiplePropertyInitializerError
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -3093330194050759789L;
        public String name;

        public MultiplePropertyInitializerError(String name) {
            this.name = name;
        }
    }

    public static class PercentProxyWarning
    extends CompilerMessage.CompilerWarning {
        private static final long serialVersionUID = -5227221682435159906L;
        public String proxyName;
        public String property;
        public String type;

        public PercentProxyWarning(String proxyName, String property, String type) {
            this.proxyName = proxyName;
            this.property = property;
            this.type = type;
        }
    }

    public static class UnrecognizedAtFunction
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -7976108326433297022L;
        public String desc;

        public UnrecognizedAtFunction(String desc) {
            this.desc = desc;
        }
    }

    public static class InvalidTwoWayBinding
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 4795539821885732534L;
        public String text;

        public InvalidTwoWayBinding(String text) {
            this.text = text;
        }
    }

    public static class InvalidTwoWayBindingInitializer
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -6225540773527205704L;
        public String desc;
        public String text;

        public InvalidTwoWayBindingInitializer(String desc, String text) {
            this.desc = desc;
            this.text = text;
        }
    }

    public static class TwoWayBindingNotAllowed
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -3894038340408090247L;
    }

    public static class TwoWayBindingNotAllowedInitializer
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -4509943614908495917L;
        public String desc;
        public String text;

        public TwoWayBindingNotAllowedInitializer(String desc, String text) {
            this.desc = desc;
            this.text = text;
        }
    }

    public static class PercentagesNotAllowed
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 106765063868387999L;
        public String desc;

        public PercentagesNotAllowed(String desc) {
            this.desc = desc;
        }
    }

    public static class TypeNotSerializable
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 352552929285101031L;
        public String desc;
        public String type;

        public TypeNotSerializable(String desc, String type) {
            this.desc = desc;
            this.type = type;
        }
    }

    public static class InvalidPercentage
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -2623489942233054966L;
        public String desc;
        public String text;

        public InvalidPercentage(String desc, String text) {
            this.desc = desc;
            this.text = text;
        }
    }

    public static class InvalidTextForType
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 4515750602580054804L;
        public String desc;
        public String type;
        public String array;
        public String text;

        public InvalidTextForType(String desc, String type, String array, String text) {
            this.desc = desc;
            this.type = type;
            this.array = array;
            this.text = text;
        }
    }

    public static class TypeNotEmbeddable
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 1329678763686966135L;
        public String desc;
        public String type;

        public TypeNotEmbeddable(String desc, String type) {
            this.desc = desc;
            this.type = type;
        }
    }

    public static class UndefinedContextRoot
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 1315340897509577928L;
    }

    public static class TypeNotContextRootable
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 2999387313501186024L;
        public String desc;
        public String type;

        public TypeNotContextRootable(String desc, String type) {
            this.desc = desc;
            this.type = type;
        }
    }

    public static class BindingNotAllowedInitializer
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -6988629472344628260L;
        public String desc;
        public String text;

        public BindingNotAllowedInitializer(String desc, String text) {
            this.desc = desc;
            this.text = text;
        }
    }

    public static class BindingNotAllowed
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 8873043175834895629L;
    }

    public static class AtClearNotAllowed
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 2999387312121186024L;
    }

    protected class RValueNodeHandler
    extends ValueNodeHandler {
        protected Model model;
        protected Object result;

        protected RValueNodeHandler() {
        }

        protected Object process(Assignable property, Node node, Model model) {
            this.model = model;
            this.invoke(property, node, AbstractBuilder.this.document);
            return this.result;
        }

        protected void componentNode(Assignable property, Node node, MxmlDocument document) {
            ComponentBuilder builder = new ComponentBuilder(AbstractBuilder.this.unit, AbstractBuilder.this.typeTable, AbstractBuilder.this.mxmlConfiguration, document, this.model, this.getName(property), this.getStateName(property), false, null);
            node.analyze(builder);
            this.result = builder.component;
        }

        protected void arrayNode(Assignable property, ArrayNode node) {
            ArrayBuilder builder = new ArrayBuilder(AbstractBuilder.this.unit, AbstractBuilder.this.typeTable, AbstractBuilder.this.mxmlConfiguration, AbstractBuilder.this.document, this.model, property, false);
            node.analyze(builder);
            this.result = builder.array;
        }

        protected void vectorNode(Assignable property, VectorNode node) {
            Type elementType = AbstractBuilder.this.typeTable.getType((String)node.getAttribute("type").getValue());
            VectorBuilder builder = new VectorBuilder(AbstractBuilder.this.unit, AbstractBuilder.this.typeTable, AbstractBuilder.this.mxmlConfiguration, AbstractBuilder.this.document, this.model, property, elementType, false);
            node.analyze(builder);
            this.result = builder.vector;
        }

        protected void primitiveNode(Assignable property, PrimitiveNode node) {
            PrimitiveBuilder builder = new PrimitiveBuilder(AbstractBuilder.this.unit, AbstractBuilder.this.typeTable, AbstractBuilder.this.mxmlConfiguration, AbstractBuilder.this.document, this.model, false, property, null);
            node.analyze(builder);
            this.result = builder.value;
        }

        protected void xmlNode(Assignable property, XMLNode node) {
            XMLBuilder builder = new XMLBuilder(AbstractBuilder.this.unit, AbstractBuilder.this.typeTable, AbstractBuilder.this.mxmlConfiguration, AbstractBuilder.this.document, this.model);
            node.analyze(builder);
            builder.xml.setParentIndex(this.getName(property), this.getStateName(property));
            this.result = builder.xml;
        }

        protected void xmlListNode(Assignable property, XMLListNode node) {
            XMLListBuilder builder = new XMLListBuilder(AbstractBuilder.this.unit, AbstractBuilder.this.typeTable, AbstractBuilder.this.mxmlConfiguration, AbstractBuilder.this.document, this.model);
            node.analyze(builder);
            builder.xmlList.setParentIndex(this.getName(property), this.getStateName(property));
            this.result = builder.xmlList;
        }

        protected void modelNode(Assignable property, ModelNode node) {
            ModelBuilder builder = new ModelBuilder(AbstractBuilder.this.unit, AbstractBuilder.this.typeTable, AbstractBuilder.this.mxmlConfiguration, AbstractBuilder.this.document, this.model);
            node.analyze(builder);
            this.result = builder.graph;
        }

        protected void inlineComponentNode(Assignable property, InlineComponentNode node) {
            InlineComponentBuilder builder = new InlineComponentBuilder(AbstractBuilder.this.unit, AbstractBuilder.this.typeTable, AbstractBuilder.this.mxmlConfiguration, AbstractBuilder.this.document, false);
            node.analyze(builder);
            this.result = builder.getRValue();
        }

        protected void reparentNode(Assignable property, ReparentNode node) {
            ComponentBuilder builder = new ComponentBuilder(AbstractBuilder.this.unit, AbstractBuilder.this.typeTable, AbstractBuilder.this.mxmlConfiguration, AbstractBuilder.this.document, this.model, this.getName(property), this.getStateName(property), false, null);
            node.analyze(builder);
            this.result = builder.component;
        }

        protected void cdataNode(Assignable property, CDATANode node) {
            PrimitiveBuilder builder = new PrimitiveBuilder(AbstractBuilder.this.unit, AbstractBuilder.this.typeTable, AbstractBuilder.this.mxmlConfiguration, AbstractBuilder.this.document, this.model, false, property, null);
            node.analyze(builder);
            this.result = builder.value;
        }

        protected void stateNode(Assignable property, StateNode node) {
            ComponentBuilder builder = new ComponentBuilder(AbstractBuilder.this.unit, AbstractBuilder.this.typeTable, AbstractBuilder.this.mxmlConfiguration, AbstractBuilder.this.document, this.model, this.getName(property), this.getStateName(property), false, null);
            node.analyze(builder);
            this.result = builder.component;
        }

        protected void unknown(Assignable property, Node node) {
            assert (false) : "Unexpected node class in processRValueNode: " + node.getClass();
            this.result = null;
        }

        private String getName(Assignable property) {
            return property != null ? property.getName() : null;
        }

        private String getStateName(Assignable property) {
            return property != null ? property.getStateName() : null;
        }
    }

    public static class TextOrigin {
        public static int FROM_ATTRIBUTE = 0;
        public static int FROM_CHILD_TEXT = 1;
        public static int FROM_CHILD_CDATA = 2;

        public static int fromChild(boolean cdata) {
            return cdata ? FROM_CHILD_CDATA : FROM_CHILD_TEXT;
        }
    }

    protected class TextValueParser
    extends TextParser {
        protected String lvalueName;
        protected int line;
        protected String desc;
        protected boolean wasPercentage;

        TextValueParser(TypeTable typeTable) {
            super(typeTable, AbstractBuilder.this.mxmlConfiguration.getCompatibilityVersion());
        }

        public Object parseValue(String text, Type type, int flags, int line, String desc) {
            return this.parseValue(text, type, AbstractBuilder.this.typeTable.objectType, flags, line, desc);
        }

        public Object parseValue(String text, Type type, Type elementType, int flags, int line, String desc) {
            this.line = line;
            this.desc = desc;
            this.wasPercentage = false;
            if (AbstractBuilder.this.document != null && "http://ns.adobe.com/fxg/2008".equals(AbstractBuilder.this.document.getLanguageNamespace())) {
                flags |= 0x10;
                flags |= 0x40;
                flags |= 0x80;
            }
            return super.parse(text, type, elementType, flags);
        }

        protected Object parse(String text, Type type, Type elementType, int flags) {
            assert (false) : "internal parse() called";
            return null;
        }

        protected BindingExpression parseBindingExpression(String text, int line) {
            this.line = line;
            this.desc = null;
            return super.parseBindingExpression(text);
        }

        public boolean wasPercentage() {
            return this.wasPercentage;
        }

        public String contextRoot(String text) {
            String contextRoot = AbstractBuilder.this.mxmlConfiguration.getContextRoot();
            if (contextRoot == null) {
                this.error(8, text, null, null);
                return null;
            }
            return text.replaceAll("@ContextRoot\\(\\)", contextRoot);
        }

        public Object clear() {
            AtClear atClear = new AtClear(AbstractBuilder.this.unit.getSource(), this.line);
            return atClear;
        }

        public Object embed(String text, Type type) {
            boolean strType = type.isAssignableTo(AbstractBuilder.this.typeTable.stringType);
            AtEmbed atEmbed = AtEmbed.create(AbstractBuilder.this.typeTable.getPerCompileData(), AbstractBuilder.this.unit.getSource(), this.line, text, strType);
            if (atEmbed != null) {
                AbstractBuilder.this.document.addAtEmbed(atEmbed);
                if (AbstractBuilder.this.standardDefs.isIFactory(type)) {
                    return AbstractBuilder.this.factoryFromClass(atEmbed.getPropName(), this.line);
                }
                if (AbstractBuilder.this.standardDefs.isIDeferredInstance(type)) {
                    return AbstractBuilder.this.instanceFromClass(atEmbed.getPropName(), this.line, false);
                }
                return atEmbed;
            }
            return null;
        }

        public Object resource(String text, Type type) {
            AtResource atResource = AtResource.create(AbstractBuilder.this.typeTable, AbstractBuilder.this.unit.getSource(), this.line, text, type);
            if (atResource != null) {
                AbstractBuilder.this.document.addAtResource(atResource);
                return atResource;
            }
            return null;
        }

        public Object bindingExpression(String converted) {
            return this.bindingExpression(converted, false);
        }

        public Object bindingExpression(String converted, boolean isTwoWay) {
            BindingExpression be = new BindingExpression(converted, this.line, AbstractBuilder.this.document);
            be.setTwoWayPrimary(isTwoWay);
            return be;
        }

        public Object percentage(String pct) {
            this.wasPercentage = true;
            return Double.valueOf(pct.substring(0, pct.indexOf(37)));
        }

        public Object array(Collection entries, Type elementType) {
            Array array = new Array(AbstractBuilder.this.document, this.line, elementType);
            array.addEntries(entries, this.line);
            return array;
        }

        public Object functionText(String text) {
            return text;
        }

        public Object className(String name, Type lvalueType) {
            AbstractBuilder.this.document.addImport(name, this.line);
            if (AbstractBuilder.this.standardDefs.isIFactory(lvalueType)) {
                return AbstractBuilder.this.factoryFromClass(name, this.line);
            }
            if (AbstractBuilder.this.standardDefs.isIDeferredInstance(lvalueType)) {
                return AbstractBuilder.this.instanceFromClass(name, this.line, true);
            }
            assert (lvalueType.equals(AbstractBuilder.this.typeTable.classType));
            return name;
        }

        public void error(int err, String text, Type type, Type elementType) {
            switch (err) {
                case 6: {
                    AbstractBuilder.this.log(this.line, new TypeNotContextRootable(this.desc, NameFormatter.toDot(type.getName())));
                    break;
                }
                case 8: {
                    AbstractBuilder.this.log(this.line, new UndefinedContextRoot());
                    break;
                }
                case 1: {
                    AbstractBuilder.this.log(this.line, new TypeNotEmbeddable(this.desc, NameFormatter.toDot(type.getName())));
                    break;
                }
                case 2: {
                    AbstractBuilder.this.log(this.line, new InvalidTextForType(this.desc, NameFormatter.toDot(type.getName()), type.equals(AbstractBuilder.this.typeTable.arrayType) ? "[" + NameFormatter.toDot(elementType.getName()) + "]" : "", text));
                    break;
                }
                case 3: {
                    AbstractBuilder.this.log(this.line, new InvalidPercentage(this.desc, text));
                    break;
                }
                case 4: {
                    AbstractBuilder.this.log(this.line, new TypeNotSerializable(this.desc, NameFormatter.toDot(type.getName())));
                    break;
                }
                case 5: {
                    AbstractBuilder.this.log(this.line, new PercentagesNotAllowed(this.desc));
                    break;
                }
                case 7: {
                    AbstractBuilder.this.log(this.line, new UnrecognizedAtFunction(this.desc));
                    break;
                }
                case 9: {
                    if (this.desc != null) {
                        AbstractBuilder.this.log(this.line, new InvalidTwoWayBindingInitializer(this.desc, text));
                    } else {
                        AbstractBuilder.this.log(this.line, new InvalidTwoWayBinding(text));
                    }
                }
                default: {
                    assert (false) : "unhandled text parse error, code = " + err;
                    break;
                }
            }
        }
    }
}

