/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml;

import flash.util.StringUtils;
import flex2.compiler.AbstractSubCompiler;
import flex2.compiler.CompilationUnit;
import flex2.compiler.CompilerBenchmarkHelper;
import flex2.compiler.CompilerContext;
import flex2.compiler.Logger;
import flex2.compiler.Source;
import flex2.compiler.SymbolTable;
import flex2.compiler.as3.As3Compiler;
import flex2.compiler.as3.As3Configuration;
import flex2.compiler.as3.HostComponentExtension;
import flex2.compiler.as3.SyntaxTreeEvaluator;
import flex2.compiler.as3.binding.ClassInfo;
import flex2.compiler.as3.reflect.NodeMagic;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.TextFile;
import flex2.compiler.mxml.AbstractSyntaxTreeLogAdapter;
import flex2.compiler.mxml.Attribute;
import flex2.compiler.mxml.InterfaceGenerator;
import flex2.compiler.mxml.InvalidStateAttributeUsage;
import flex2.compiler.mxml.MXMLNamespaces;
import flex2.compiler.mxml.MxmlCompiler;
import flex2.compiler.mxml.MxmlConfiguration;
import flex2.compiler.mxml.MxmlLogAdapter;
import flex2.compiler.mxml.ParseException;
import flex2.compiler.mxml.Parser;
import flex2.compiler.mxml.SourceCodeBuffer;
import flex2.compiler.mxml.Token;
import flex2.compiler.mxml.analyzer.SyntaxAnalyzer;
import flex2.compiler.mxml.dom.AnalyzerAdapter;
import flex2.compiler.mxml.dom.ArgumentsNode;
import flex2.compiler.mxml.dom.ArrayNode;
import flex2.compiler.mxml.dom.BindingNode;
import flex2.compiler.mxml.dom.BooleanNode;
import flex2.compiler.mxml.dom.CDATANode;
import flex2.compiler.mxml.dom.DeclarationsNode;
import flex2.compiler.mxml.dom.DefinitionNode;
import flex2.compiler.mxml.dom.DesignLayerNode;
import flex2.compiler.mxml.dom.DocumentNode;
import flex2.compiler.mxml.dom.HTTPServiceNode;
import flex2.compiler.mxml.dom.InlineComponentNode;
import flex2.compiler.mxml.dom.IntNode;
import flex2.compiler.mxml.dom.LayeredNode;
import flex2.compiler.mxml.dom.LibraryNode;
import flex2.compiler.mxml.dom.MetaDataNode;
import flex2.compiler.mxml.dom.MethodNode;
import flex2.compiler.mxml.dom.ModelNode;
import flex2.compiler.mxml.dom.MxmlScanner;
import flex2.compiler.mxml.dom.Node;
import flex2.compiler.mxml.dom.NumberNode;
import flex2.compiler.mxml.dom.OperationNode;
import flex2.compiler.mxml.dom.PrivateNode;
import flex2.compiler.mxml.dom.RemoteObjectNode;
import flex2.compiler.mxml.dom.ReparentNode;
import flex2.compiler.mxml.dom.RequestNode;
import flex2.compiler.mxml.dom.ScannerError;
import flex2.compiler.mxml.dom.ScriptNode;
import flex2.compiler.mxml.dom.StateNode;
import flex2.compiler.mxml.dom.StringNode;
import flex2.compiler.mxml.dom.StyleNode;
import flex2.compiler.mxml.dom.SyntaxTreeBuilder;
import flex2.compiler.mxml.dom.UIntNode;
import flex2.compiler.mxml.dom.VectorNode;
import flex2.compiler.mxml.dom.WebServiceNode;
import flex2.compiler.mxml.dom.XMLListNode;
import flex2.compiler.mxml.dom.XMLNode;
import flex2.compiler.mxml.lang.AttributeHandler;
import flex2.compiler.mxml.lang.ChildNodeHandler;
import flex2.compiler.mxml.lang.FrameworkDefs;
import flex2.compiler.mxml.lang.StandardDefs;
import flex2.compiler.mxml.lang.TextParser;
import flex2.compiler.mxml.reflect.Effect;
import flex2.compiler.mxml.reflect.Event;
import flex2.compiler.mxml.reflect.Property;
import flex2.compiler.mxml.reflect.Style;
import flex2.compiler.mxml.reflect.Type;
import flex2.compiler.mxml.reflect.TypeTable;
import flex2.compiler.mxml.rep.BindingExpression;
import flex2.compiler.mxml.rep.DocumentInfo;
import flex2.compiler.mxml.rep.Script;
import flex2.compiler.util.AbstractLogAdapter;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.LineNumberMap;
import flex2.compiler.util.MultiName;
import flex2.compiler.util.MultiNameMap;
import flex2.compiler.util.Name;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.NameMappings;
import flex2.compiler.util.QName;
import flex2.compiler.util.QNameSet;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.compiler.util.VelocityManager;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import macromedia.asc.embedding.CompilerHandler;
import macromedia.asc.embedding.ConfigVar;
import macromedia.asc.semantics.Emitter;
import macromedia.asc.util.ObjectList;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterfaceCompiler
extends AbstractSubCompiler
implements MXMLNamespaces {
    private static final String TemplatePath = InterfaceCompiler.class.getPackage().getName().replace('.', '/') + "/gen/";
    private static final String AttrTypeRequests = "TypeRequests";
    private static final String AttrInlineComponentSyntaxTree = "InlineComponentSyntaxTree";
    private static final String DOCUMENT_NODE = "DocumentNode";
    private static final String EMPTY_STRING = "";
    private boolean processComments = false;
    private As3Configuration ascConfiguration;
    private MxmlConfiguration mxmlConfiguration;
    private NameMappings nameMappings;
    private String[] mimeTypes;
    private As3Compiler asc;

    public InterfaceCompiler(MxmlConfiguration mxmlConfiguration, final As3Configuration ascConfiguration, NameMappings mappings, boolean processComments) {
        this.mxmlConfiguration = mxmlConfiguration;
        this.ascConfiguration = ascConfiguration;
        this.nameMappings = mappings;
        this.processComments = processComments;
        this.mimeTypes = new String[]{"text/mxml"};
        this.asc = new As3Compiler(new As3Configuration(){

            @Override
            public boolean debug() {
                return false;
            }

            @Override
            public boolean strict() {
                return ascConfiguration.strict();
            }

            @Override
            public int dialect() {
                return ascConfiguration.dialect();
            }

            @Override
            public boolean adjustOpDebugLine() {
                return ascConfiguration.adjustOpDebugLine();
            }

            @Override
            public boolean warnings() {
                return false;
            }

            @Override
            public boolean doc() {
                return false;
            }

            @Override
            public boolean getGenerateAbstractSyntaxTree() {
                return ascConfiguration.getGenerateAbstractSyntaxTree();
            }

            @Override
            public String getEncoding() {
                return null;
            }

            @Override
            public boolean metadataExport() {
                return false;
            }

            @Override
            public boolean warn_array_tostring_changes() {
                return false;
            }

            @Override
            public boolean warn_assignment_within_conditional() {
                return false;
            }

            @Override
            public boolean warn_bad_array_cast() {
                return false;
            }

            @Override
            public boolean warn_bad_bool_assignment() {
                return false;
            }

            @Override
            public boolean warn_bad_date_cast() {
                return false;
            }

            @Override
            public boolean warn_bad_es3_type_method() {
                return false;
            }

            @Override
            public boolean warn_bad_es3_type_prop() {
                return false;
            }

            @Override
            public boolean warn_bad_nan_comparison() {
                return false;
            }

            @Override
            public boolean warn_bad_null_assignment() {
                return false;
            }

            @Override
            public boolean warn_bad_null_comparison() {
                return false;
            }

            @Override
            public boolean warn_bad_undefined_comparison() {
                return false;
            }

            @Override
            public boolean warn_boolean_constructor_with_no_args() {
                return false;
            }

            @Override
            public boolean warn_changes_in_resolve() {
                return false;
            }

            @Override
            public boolean warn_class_is_sealed() {
                return false;
            }

            @Override
            public boolean warn_const_not_initialized() {
                return false;
            }

            @Override
            public boolean warn_constructor_returns_value() {
                return false;
            }

            @Override
            public boolean warn_deprecated_event_handler_error() {
                return false;
            }

            @Override
            public boolean warn_deprecated_function_error() {
                return false;
            }

            @Override
            public boolean warn_deprecated_property_error() {
                return false;
            }

            @Override
            public boolean warn_duplicate_argument_names() {
                return false;
            }

            @Override
            public boolean warn_duplicate_variable_def() {
                return false;
            }

            @Override
            public boolean warn_for_var_in_changes() {
                return false;
            }

            @Override
            public boolean warn_import_hides_class() {
                return false;
            }

            @Override
            public boolean warn_instance_of_changes() {
                return false;
            }

            @Override
            public boolean warn_internal_error() {
                return false;
            }

            @Override
            public boolean warn_level_not_supported() {
                return false;
            }

            @Override
            public boolean warn_missing_namespace_decl() {
                return false;
            }

            @Override
            public boolean warn_negative_uint_literal() {
                return false;
            }

            @Override
            public boolean warn_no_constructor() {
                return false;
            }

            @Override
            public boolean warn_no_explicit_super_call_in_constructor() {
                return false;
            }

            @Override
            public boolean warn_no_type_decl() {
                return false;
            }

            @Override
            public boolean warn_number_from_string_changes() {
                return false;
            }

            @Override
            public boolean warn_scoping_change_in_this() {
                return false;
            }

            @Override
            public boolean warn_slow_text_field_addition() {
                return false;
            }

            @Override
            public boolean warn_unlikely_function_value() {
                return false;
            }

            @Override
            public boolean warn_xml_class_has_changed() {
                return false;
            }

            @Override
            public ObjectList<ConfigVar> getDefine() {
                return ascConfiguration.getDefine();
            }
        });
        this.asc.addCompilerExtension(new HostComponentExtension());
    }

    As3Compiler getASCompiler() {
        return this.asc;
    }

    @Override
    public boolean isSupported(String mimeType) {
        for (int i = 0; i < this.mimeTypes.length; ++i) {
            if (!this.mimeTypes[i].equals(mimeType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getSupportedMimeTypes() {
        return this.mimeTypes;
    }

    @Override
    public Source preprocess(Source source) {
        String componentName = source.getShortName();
        if (!TextParser.isValidIdentifier(componentName)) {
            InvalidComponentName m = new InvalidComponentName(componentName);
            m.setPath(source.getNameForReporting());
            ThreadLocalToolkit.log(m);
        }
        return source;
    }

    @Override
    public CompilationUnit parse1(Source source, SymbolTable symbolTable) {
        CompilationUnit unit;
        DocumentNode app;
        CompilerContext context = new CompilerContext();
        Object preparsedSyntaxTree = source.getSourceFragment(AttrInlineComponentSyntaxTree);
        if (preparsedSyntaxTree == null) {
            app = this.parseMXML(source);
            if (app == null) {
                return null;
            }
            unit = source.newCompilationUnit(app, context);
            app.analyze(new SyntaxAnalyzer(unit, this.mxmlConfiguration));
            if (ThreadLocalToolkit.errorCount() > 0) {
                return null;
            }
        } else {
            assert (preparsedSyntaxTree instanceof DocumentNode) : "bogus preparsed root node passed to InterfaceCompiler";
            app = (DocumentNode)preparsedSyntaxTree;
            unit = source.newCompilationUnit(app, context);
        }
        unit.getContext().setAttribute(DOCUMENT_NODE, app);
        DocumentInfo docInfo = this.createDocumentInfo(unit, app, source);
        if (ThreadLocalToolkit.errorCount() > 0) {
            return null;
        }
        unit.getContext().setAttribute("DocumentInfo", docInfo);
        unit.topLevelDefinitions.add(new QName(docInfo.getPackageName(), docInfo.getClassName()));
        this.transferDependencies(docInfo, unit.inheritance, unit.inheritanceHistory);
        return unit;
    }

    @Override
    public void parse2(CompilationUnit unit, SymbolTable symbolTable) {
        Source newSource;
        AbstractLogAdapter adapter;
        DocumentInfo docInfo = (DocumentInfo)unit.getContext().getAttribute("DocumentInfo");
        Source source = unit.getSource();
        ClassInfo baseClassInfo = InterfaceCompiler.getClassInfo(source, symbolTable, docInfo.getQualifiedSuperClassName());
        if (baseClassInfo == null && docInfo.getQualifiedSuperClassName() != null) {
            String qualifiedClassName = NameFormatter.toDot(docInfo.getPackageName(), docInfo.getClassName());
            ThreadLocalToolkit.log((CompilerMessage)new BaseClassNotFound(qualifiedClassName, docInfo.getQualifiedSuperClassName()), source);
            return;
        }
        InterfaceAnalyzer analyzer = new InterfaceAnalyzer(unit, docInfo, baseClassInfo, this.mxmlConfiguration.getGenerateAbstractSyntaxTree());
        DocumentNode app = (DocumentNode)unit.getContext().getAttribute(DOCUMENT_NODE);
        app.analyze(analyzer);
        if (ThreadLocalToolkit.errorCount() > 0) {
            return;
        }
        LineNumberMap map = new LineNumberMap(source.getName());
        Logger original = ThreadLocalToolkit.getLogger();
        if (this.mxmlConfiguration.getGenerateAbstractSyntaxTree()) {
            adapter = new AbstractSyntaxTreeLogAdapter(original);
            ThreadLocalToolkit.setLogger(adapter);
            newSource = this.generateSkeletonAST(docInfo, analyzer.bogusImports, source, symbolTable);
        } else {
            adapter = new MxmlLogAdapter(original, map);
            ((MxmlLogAdapter)adapter).addLineNumberMaps(unit.getSource().getSourceFragmentLineMaps());
            ThreadLocalToolkit.setLogger(adapter);
            newSource = this.generateSkeleton(docInfo, analyzer.bogusImports, map, source);
            if (newSource == null) {
                ThreadLocalToolkit.setLogger(original);
                return;
            }
            map.setNewName(newSource.getName());
        }
        CompilationUnit interfaceUnit = this.compileInterface(newSource, source, docInfo, map, symbolTable);
        if (interfaceUnit == null) {
            ThreadLocalToolkit.setLogger(original);
            return;
        }
        unit.getSource().addFileIncludes(interfaceUnit.getSource());
        unit.getContext().setAttribute("LineNumberMap", map);
        unit.getContext().setAttribute("DelegateUnit", interfaceUnit);
        Source.transferMetaData(interfaceUnit, unit);
        Source.transferInheritance(unit, interfaceUnit);
        this.asc.parse2(interfaceUnit, symbolTable);
        ThreadLocalToolkit.setLogger(original);
    }

    @Override
    public void analyze1(CompilationUnit unit, SymbolTable symbolTable) {
        CompilationUnit interfaceUnit = (CompilationUnit)unit.getContext().getAttribute("DelegateUnit");
        Logger original = this.setLogAdapter(unit);
        this.asc.analyze1(interfaceUnit, symbolTable);
        ThreadLocalToolkit.setLogger(original);
        Source.transferTypeInfo(interfaceUnit, unit);
        Source.transferNamespaces(interfaceUnit, unit);
    }

    @Override
    public void analyze2(CompilationUnit unit, SymbolTable symbolTable) {
        CompilationUnit interfaceUnit = (CompilationUnit)unit.getContext().getAttribute("DelegateUnit");
        Source.transferDependencies(unit, interfaceUnit);
        Logger original = this.setLogAdapter(unit);
        this.asc.analyze2(interfaceUnit, symbolTable);
        ThreadLocalToolkit.setLogger(original);
        Source.transferDependencies(interfaceUnit, unit);
    }

    @Override
    public void analyze3(CompilationUnit unit, SymbolTable symbolTable) {
        CompilationUnit interfaceUnit = (CompilationUnit)unit.getContext().getAttribute("DelegateUnit");
        QNameSet importDefinitionStatements = new QNameSet(interfaceUnit.importDefinitionStatements);
        Source.transferDependencies(unit, interfaceUnit);
        interfaceUnit.importDefinitionStatements.addAll(importDefinitionStatements);
        Logger original = this.setLogAdapter(unit);
        this.asc.analyze3(interfaceUnit, symbolTable);
        ThreadLocalToolkit.setLogger(original);
    }

    @Override
    public void analyze4(CompilationUnit unit, SymbolTable symbolTable) {
        CompilationUnit interfaceUnit = (CompilationUnit)unit.getContext().getAttribute("DelegateUnit");
        Logger original = this.setLogAdapter(unit);
        this.asc.analyze4(interfaceUnit, symbolTable);
        ThreadLocalToolkit.setLogger(original);
        Source.transferDependencies(interfaceUnit, unit);
        Source.transferLoaderClassBase(interfaceUnit, unit);
        Source.transferGeneratedSources(interfaceUnit, unit);
        Source.transferClassTable(interfaceUnit, unit);
        Source.transferStyles(interfaceUnit, unit);
    }

    @Override
    public void generate(CompilationUnit unit, SymbolTable symbolTable) {
    }

    @Override
    public void postprocess(CompilationUnit unit, SymbolTable symbolTable) {
        TypeTable typeTable = (TypeTable)symbolTable.getContext().getAttribute(MxmlCompiler.TYPE_TABLE);
        if (typeTable == null) {
            typeTable = new TypeTable(symbolTable, this.nameMappings, unit.getStandardDefs(), this.mxmlConfiguration.getThemeNames());
            symbolTable.getContext().setAttribute(MxmlCompiler.TYPE_TABLE, typeTable);
        }
        DocumentInfo info = (DocumentInfo)unit.getContext().getAttribute("DocumentInfo");
        HashSet<DocumentNode> checkNodes = (HashSet<DocumentNode>)unit.getContext().getAttribute("CheckNodes");
        HashSet allTypeRequests = (HashSet)unit.getContext().getAttribute(AttrTypeRequests);
        if (checkNodes == null) {
            checkNodes = new HashSet<DocumentNode>();
            checkNodes.add(info.getRootNode());
            allTypeRequests = new HashSet();
            unit.getContext().setAttribute(AttrTypeRequests, allTypeRequests);
        }
        if (!checkNodes.isEmpty()) {
            HashSet newCheckNodes = new HashSet();
            HashSet newTypeRequests = new HashSet();
            DependencyAnalyzer analyzer = new DependencyAnalyzer(unit, typeTable, info, newCheckNodes, newTypeRequests, allTypeRequests);
            Iterator i = checkNodes.iterator();
            while (i.hasNext()) {
                ((Node)i.next()).analyze(analyzer);
            }
            unit.getContext().setAttribute("CheckNodes", newCheckNodes);
            if (!newTypeRequests.isEmpty()) {
                allTypeRequests.addAll(newTypeRequests);
                for (MultiName newTypeRequest : newTypeRequests) {
                    unit.expressions.add(newTypeRequest);
                }
            }
        }
    }

    private void transferDependencies(DocumentInfo docInfo, Set<Name> target, MultiNameMap history) {
        target.add(NameFormatter.toMultiName(docInfo.getQualifiedSuperClassName()));
        for (DocumentInfo.NameInfo nameInfo : docInfo.getInterfaceNames()) {
            target.add(NameFormatter.toMultiName(nameInfo.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DocumentNode parseMXML(Source source) {
        BufferedInputStream in;
        DocumentNode app;
        block22: {
            app = null;
            in = null;
            in = new BufferedInputStream(source.getInputStream());
            MxmlScanner s = new MxmlScanner(in, this.mxmlConfiguration.enableRuntimeDesignLayers(), this.processComments);
            Parser p = new Parser(s);
            SyntaxTreeBuilder v = new SyntaxTreeBuilder();
            p.setVisitor(v);
            app = (DocumentNode)p.parseApplication();
            if (this.checkMxmlNamespace(source, app)) break block22;
            app = null;
        }
        Object var13_16 = null;
        if (in == null) return app;
        try {
            ((InputStream)in).close();
            return app;
        }
        catch (IOException ex2) {}
        return app;
        {
            catch (ParseException ex) {
                Token token = ex.currentToken.next;
                String msg = ex.getMessage();
                int wasExpecting = msg.indexOf(System.getProperty("line.separator") + "Was expecting");
                if (wasExpecting > 0) {
                    msg = msg.substring(0, wasExpecting);
                    Pattern msgPatt = Pattern.compile("Encountered \"(.*)\" at line.*");
                    Matcher m = msgPatt.matcher(msg);
                    if (m.matches()) {
                        String parent = ex.currentToken.image;
                        String child = ex.currentToken.next.image;
                        msg = new InvalidToken(parent, child).getLocalizedMessage();
                    }
                }
                ThreadLocalToolkit.logError(source.getNameForReporting(), token.beginLine, token.beginColumn, msg);
                app = null;
                Object var13_17 = null;
                if (in == null) return app;
                try {
                    ((InputStream)in).close();
                    return app;
                }
                catch (IOException ex2) {}
                return app;
            }
            catch (Exception ex) {
                String msg = ex.getMessage();
                if (msg == null) {
                    StringWriter stwriter = new StringWriter();
                    PrintWriter pw = new PrintWriter(stwriter);
                    ex.printStackTrace(pw);
                    msg = stwriter.toString();
                }
                ThreadLocalToolkit.logError(source.getNameForReporting(), msg);
                app = null;
                Object var13_18 = null;
                if (in == null) return app;
                try {
                    ((InputStream)in).close();
                    return app;
                }
                catch (IOException ex2) {}
                return app;
            }
            catch (ScannerError err) {
                String msg = err.getReason();
                if (msg.equals(MxmlScanner.MarkupNotRecognizedInContent)) {
                    ThreadLocalToolkit.log((CompilerMessage)new InvalidCharacterOrMarkup(), source);
                } else if (msg.equals(MxmlScanner.ReservedPITarget)) {
                    ThreadLocalToolkit.log((CompilerMessage)new WhitespaceBeforePI(), source);
                } else if (msg.equals(MxmlScanner.MarkupNotRecognizedInMisc)) {
                    ThreadLocalToolkit.log((CompilerMessage)new InvalidMarkupAfterRootElement(), source);
                } else {
                    Pattern msgPatt = Pattern.compile("The element type \"(.*)\" must be terminated by the matching end-tag \"(.*)\".");
                    Matcher m = msgPatt.matcher(msg);
                    if (m.matches()) {
                        msg = new MissingEndTag(m.group(1), m.group(2)).getLocalizedMessage();
                    }
                    ThreadLocalToolkit.logError(source.getNameForReporting(), err.getLineNumber(), err.getColumnNumber(), msg);
                }
                app = null;
                Object var13_19 = null;
                if (in == null) return app;
                try {
                    ((InputStream)in).close();
                    return app;
                }
                catch (IOException ex2) {}
                return app;
            }
        }
        catch (Throwable throwable) {
            Object var13_20 = null;
            if (in == null) throw throwable;
            try {
                ((InputStream)in).close();
                throw throwable;
            }
            catch (IOException ex2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private boolean checkMxmlNamespace(Source source, Node node) {
        if (node.getNamespace().equals("http://www.macromedia.com/2003/mxml") || node.getNamespace().equals("http://www.macromedia.com/2005/mxml")) {
            ThreadLocalToolkit.log((CompilerMessage)new WrongMXMLNamespace(node.getNamespace(), "http://ns.adobe.com/mxml/2009"), source);
            return false;
        }
        return true;
    }

    private DocumentInfo createDocumentInfo(CompilationUnit unit, DocumentNode app, Source source) {
        StandardDefs standardDefs = unit.getStandardDefs();
        DocumentInfo info = new DocumentInfo(source.getNameForReporting(), standardDefs);
        info.setRootNode(app, app.beginLine);
        info.setClassName(source.getShortName());
        info.setPackageName(source.getRelativePath().replace('/', '.'));
        String superClassName = info.getLocalClass(app.getNamespace(), app.getLocalPart());
        if (superClassName == null) {
            superClassName = this.nameMappings.resolveClassName(app.getNamespace(), app.getLocalPart());
        }
        if (superClassName == null) {
            ThreadLocalToolkit.log((CompilerMessage)new AnalyzerAdapter.CouldNotResolveToComponent(app.image), source, app.beginLine);
            return null;
        }
        info.setQualifiedSuperClassName(NameFormatter.toDot(superClassName), app.beginLine);
        String interfaceNames = (String)app.getAttributeValue("implements");
        if (interfaceNames != null) {
            StringTokenizer t = new StringTokenizer(interfaceNames, ",");
            while (t.hasMoreTokens()) {
                info.addInterfaceName(t.nextToken().trim(), app.getLineNumber("implements"));
            }
        }
        if (this.mxmlConfiguration.getGenerateAbstractSyntaxTree()) {
            info.addSplitImportNames(StandardDefs.splitImplicitImports);
            if (info.getVersion() >= 4) {
                info.removeSplitImportName(NameFormatter.toDotStar("flash.filters"));
                info.addSplitImportName(NameFormatter.toDotStar("mx.filters"), StandardDefs.splitPackageMxFilters);
            }
            if (this.mxmlConfiguration.getCompilingForAIR()) {
                info.addSplitImportNames(StandardDefs.splitAirOnlyImplicitImports);
            }
            info.addSplitImportNames(standardDefs.getSplitStandardMxmlImports());
        } else {
            info.addImportNames(StandardDefs.implicitImports, app.beginLine);
            if (info.getVersion() >= 4) {
                info.removeImportName(NameFormatter.toDotStar("flash.filters"));
                info.addImportName(NameFormatter.toDotStar("mx.filters"), app.beginLine);
            }
            if (this.mxmlConfiguration.getCompilingForAIR()) {
                info.addImportNames(StandardDefs.airOnlyImplicitImports, app.beginLine);
            }
            info.addImportNames(standardDefs.getStandardMxmlImports(), app.beginLine);
        }
        return info;
    }

    private static ClassInfo getClassInfo(Source source, SymbolTable symbolTable, String className) {
        macromedia.asc.util.Context tempContext = new macromedia.asc.util.Context(symbolTable.perCompileData);
        tempContext.setScriptName(source.getName());
        tempContext.setPath(source.getParent());
        tempContext.setEmitter((Emitter)symbolTable.emitter);
        tempContext.setHandler((CompilerHandler)new As3Compiler.CompilerHandler());
        symbolTable.perCompileData.handler = tempContext.getHandler();
        return symbolTable.getTypeAnalyzer().analyzeClass(tempContext, new MultiName(NameFormatter.toColon(className)));
    }

    private Source generateSkeleton(DocumentInfo info, Set<String> bogusImports, LineNumberMap map, Source source) {
        String path = source.getName();
        StandardDefs standardDefs = info.getStandardDefs();
        String templateName = TemplatePath + standardDefs.getInterfaceDefTemplate();
        Template template = VelocityManager.getTemplate(templateName);
        if (template != null) {
            try {
                VelocityContext velocityContext = VelocityManager.getCodeGenContext();
                SourceCodeBuffer out = new SourceCodeBuffer((int)source.size());
                LinkedHashSet<SourceCode> scriptSet = new LinkedHashSet<SourceCode>();
                for (Script script : info.getScripts()) {
                    if (!script.isEmbedded()) {
                        scriptSet.add(new SourceCode(script.getText(), script.getXmlLineNumber(), out, map));
                        continue;
                    }
                    String n = source.getName().replace('\\', '/') + ":" + script.getXmlLineNumber() + "," + script.getEndXmlLineNumber();
                    TextFile f = new TextFile(script.getText(), n, source.getParent(), "text/as", source.getLastModified());
                    LineNumberMap m = new LineNumberMap(source.getNameForReporting(), n);
                    m.put(script.getXmlLineNumber(), 1, script.getEndXmlLineNumber() - script.getXmlLineNumber());
                    m.put(script.getEndXmlLineNumber(), script.getEndXmlLineNumber() - script.getXmlLineNumber() + 1, 1);
                    source.addSourceFragment(n, f, m);
                    scriptSet.add(new SourceCode("include \"" + n + "\";", script.getXmlLineNumber(), out, map));
                }
                LinkedHashSet<SourceCode> metadataSet = new LinkedHashSet<SourceCode>();
                for (Script script : info.getMetadata()) {
                    metadataSet.add(new SourceCode(script.getText(), script.getXmlLineNumber(), out, map));
                }
                LinkedHashMap<String, SourceCode> varDeclMap = new LinkedHashMap<String, SourceCode>();
                for (DocumentInfo.VarDecl varDecl : info.getVarDecls().values()) {
                    varDeclMap.put(varDecl.name, new SourceCode(varDecl.className, varDecl.line, out, map));
                }
                int superClassLineNumber = 1;
                LinkedHashSet<SourceCode> importNameSet = new LinkedHashSet<SourceCode>();
                for (DocumentInfo.NameInfo nameInfo : info.getImportNames()) {
                    importNameSet.add(new SourceCode(nameInfo.getName(), nameInfo.getLine(), out, map));
                    if (!nameInfo.getName().equals(info.getQualifiedSuperClassName())) continue;
                    superClassLineNumber = nameInfo.getLine();
                }
                for (String string : bogusImports) {
                    importNameSet.add(new SourceCode(string, 1, out, map));
                }
                LinkedHashSet<SourceCode> interfaceNameSet = new LinkedHashSet<SourceCode>();
                for (DocumentInfo.NameInfo interfaceName : info.getInterfaceNames()) {
                    interfaceNameSet.add(new SourceCode(interfaceName.getName(), interfaceName.getLine(), out, map));
                }
                velocityContext.put("imports", importNameSet);
                velocityContext.put("variables", varDeclMap.entrySet());
                velocityContext.put("scripts", scriptSet);
                velocityContext.put("classMetaData", metadataSet);
                velocityContext.put("bindingManagementVariables", FrameworkDefs.bindingManagementVars);
                velocityContext.put("superClassName", (Object)new SourceCode(info.getQualifiedSuperClassName(), superClassLineNumber, out, map));
                velocityContext.put("interfaceNames", interfaceNameSet);
                velocityContext.put("className", (Object)info.getClassName());
                velocityContext.put("packageName", (Object)info.getPackageName());
                template.merge((Context)velocityContext, (Writer)out);
                String string = out.toString().replaceAll("\r\n", "\n");
                String filename = this.writeGenerated(info, string);
                TextFile textFile = new TextFile(string, filename, source.getParent(), "text/as", source.getLastModified());
                return new Source(textFile, source);
            }
            catch (ResourceNotFoundException ex) {
                ThreadLocalToolkit.logError(path, FileUtil.getExceptionMessage((Exception)((Object)ex)));
            }
            catch (ParseErrorException ex) {
                ThreadLocalToolkit.logError(path, FileUtil.getExceptionMessage((Exception)((Object)ex)));
            }
            catch (MethodInvocationException ex) {
                ThreadLocalToolkit.logError(path, FileUtil.getExceptionMessage((Exception)((Object)ex)));
            }
            catch (Exception ex) {
                ThreadLocalToolkit.logError(path, FileUtil.getExceptionMessage(ex));
            }
        }
        return null;
    }

    private Source generateSkeletonAST(DocumentInfo info, Set<String> bogusImports, Source source, SymbolTable symbolTable) {
        String fileName = MxmlCompiler.getGeneratedName(this.mxmlConfiguration, info.getPackageName(), info.getClassName(), "-interface.as");
        TextFile textFile = new TextFile(EMPTY_STRING, fileName, source.getName(), source.getParent(), "text/mxml", source.getLastModified());
        Source result = new Source(textFile, source);
        InterfaceGenerator interfaceGenerator = new InterfaceGenerator(info, bogusImports, symbolTable.perCompileData, result, symbolTable.emitter, this.ascConfiguration.getDefine());
        CompilerContext context = new CompilerContext();
        context.setAscContext(interfaceGenerator.getContext());
        Object syntaxTree = interfaceGenerator.getSyntaxTree();
        result.newCompilationUnit(syntaxTree, context).setSyntaxTree(syntaxTree);
        return result;
    }

    private String writeGenerated(DocumentInfo info, String generated) throws IOException {
        String filename = MxmlCompiler.getGeneratedName(this.mxmlConfiguration, info.getPackageName(), info.getClassName(), "-interface.as");
        if (this.mxmlConfiguration.keepGeneratedActionScript()) {
            new File(filename).getParentFile().mkdirs();
            FileUtil.writeFile(filename, generated);
        }
        return filename;
    }

    private CompilationUnit compileInterface(Source newSource, Source origSource, DocumentInfo info, LineNumberMap map, SymbolTable symbolTable) {
        List<Script> md;
        AbstractLogAdapter adapter;
        Logger original = ThreadLocalToolkit.getLogger();
        if (this.mxmlConfiguration.getGenerateAbstractSyntaxTree()) {
            adapter = new AbstractSyntaxTreeLogAdapter(original);
            ThreadLocalToolkit.setLogger(adapter);
        } else {
            adapter = new MxmlLogAdapter(original, map);
            ((MxmlLogAdapter)adapter).addLineNumberMaps(origSource.getSourceFragmentLineMaps());
            ThreadLocalToolkit.setLogger(adapter);
        }
        CompilationUnit interfaceUnit = this.asc.parse1(newSource, symbolTable);
        SyntaxTreeEvaluator.stripRedeclaredManagementVars(interfaceUnit, info.getQName().toString(), symbolTable);
        if (!this.mxmlConfiguration.getGenerateAbstractSyntaxTree() && interfaceUnit != null && info != null && (md = info.getMetadata()).size() > 0) {
            int[] beginLines = new int[md.size()];
            int[] endLines = new int[md.size()];
            int size = md.size();
            for (int i = 0; i < size; ++i) {
                Script script = md.get(i);
                beginLines[i] = script.getXmlLineNumber();
                endLines[i] = script.getEndXmlLineNumber();
            }
            NodeMagic.metaDataOnly(interfaceUnit, map, beginLines, endLines);
        }
        if (interfaceUnit != null) {
            SyntaxTreeEvaluator.ensureMetaDataHasDefinition(interfaceUnit);
        }
        ThreadLocalToolkit.setLogger(original);
        return interfaceUnit;
    }

    @Override
    public String getName() {
        assert (false);
        return null;
    }

    @Override
    public void setHelper(CompilerBenchmarkHelper helper, boolean isEmb) {
        assert (isEmb);
        this.asc.setHelper(helper, false);
    }

    private Logger setLogAdapter(CompilationUnit unit) {
        Logger original = ThreadLocalToolkit.getLogger();
        if (this.mxmlConfiguration.getGenerateAbstractSyntaxTree()) {
            AbstractSyntaxTreeLogAdapter adapter = new AbstractSyntaxTreeLogAdapter(original);
            ThreadLocalToolkit.setLogger(adapter);
        } else {
            LineNumberMap map = (LineNumberMap)unit.getContext().getAttribute("LineNumberMap");
            MxmlLogAdapter adapter = new MxmlLogAdapter(original, map);
            adapter.addLineNumberMaps(unit.getSource().getSourceFragmentLineMaps());
            ThreadLocalToolkit.setLogger(adapter);
        }
        return original;
    }

    public static class VectorTypeRequired
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 6607637220512352073L;
    }

    public static class StateNameRequired
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 6607637220522352073L;
    }

    public static class InvalidMarkupAfterRootElement
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 6607637220533252073L;
    }

    public static class MissingEndTag
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -6077307706546117384L;
        public final String tag;
        public final String endTag;

        public MissingEndTag(String tag, String endTag) {
            this.tag = tag;
            this.endTag = endTag;
        }
    }

    public static class InvalidToken
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -3327190119811022784L;
        public final String parent;
        public final String child;

        public InvalidToken(String parent, String child) {
            this.parent = parent;
            this.child = child;
        }
    }

    public static class InvalidComponentName
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -4650090768060530717L;
        public String name;

        public InvalidComponentName(String name) {
            this.name = name;
        }
    }

    public static class BaseClassNotFound
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -6143925391370661093L;
        public String className;
        public String baseClassName;

        public BaseClassNotFound(String className, String baseClassName) {
            this.className = className;
            this.baseClassName = baseClassName;
        }
    }

    public static class DefinitionNodeInternalError
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 2050837864240302889L;
    }

    public static class InlineComponentInternalError
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -1304020176499882673L;
    }

    public static class ClassNameSpecifiedMoreThanOnce
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 4442337674062750466L;
    }

    public static class ClassNameInvalidActionScriptIdentifier
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 480247425987577161L;
    }

    public static class IdentifierMatchesClassName
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 3478059314461282575L;
        public String name;

        public IdentifierMatchesClassName(String name) {
            this.name = name;
        }
    }

    public static class IdentifierUsedMoreThanOnce
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -5536047603734582126L;
        public final String id;

        public IdentifierUsedMoreThanOnce(String id) {
            this.id = id;
        }
    }

    public static class InvalidIdentifier
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 6629930451063326985L;
        public final String id;

        public InvalidIdentifier(String id) {
            this.id = id;
        }
    }

    public static class WrongMXMLNamespace
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 5565644959263774573L;
        public final String namespace1;
        public final String namespace2;

        public WrongMXMLNamespace(String namespace1, String namespace2) {
            this.namespace1 = namespace1;
            this.namespace2 = namespace2;
        }
    }

    public static class WhitespaceBeforePI
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -7174283384299207618L;
    }

    public static class InvalidCharacterOrMarkup
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -2984325226553564468L;
    }

    private class SourceCode {
        private String text;
        private int beginLine;
        private int newBeginLine;
        private int lineCount;
        private SourceCodeBuffer out;
        private LineNumberMap map;

        private SourceCode(String text, int beginLine, SourceCodeBuffer out, LineNumberMap map) {
            this.text = text;
            this.beginLine = beginLine;
            this.out = out;
            this.map = map;
            this.newBeginLine = 0;
            this.lineCount = StringUtils.countLines((String)text);
        }

        public String toString() {
            if (this.newBeginLine != 0) {
                throw new IllegalStateException("InterfaceGenerator: toString() was called more than once...");
            }
            this.newBeginLine = this.out.getLineNumber();
            this.map.put(this.beginLine, this.newBeginLine, this.lineCount + 1);
            return this.text;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DependencyAnalyzer
    extends AnalyzerAdapter {
        private final TypeTable typeTable;
        private final DocumentInfo info;
        private final Set<Node> checkNodes;
        private final Set<MultiName> newTypeRequests;
        private final Set<MultiName> allTypeRequests;
        private AttributeDependencyScanner attributeDependencyScanner;
        private ChildNodeDependencyScanner childNodeDependencyScanner;
        private ClassInitializerTextParser classInitializerTextParser;

        private DependencyAnalyzer(CompilationUnit unit, TypeTable typeTable, DocumentInfo info, Set<Node> checkNodes, Set<MultiName> newTypeRequests, Set<MultiName> allTypeRequests) {
            super(unit, null);
            this.typeTable = typeTable;
            this.info = info;
            this.checkNodes = checkNodes;
            this.newTypeRequests = newTypeRequests;
            this.allTypeRequests = allTypeRequests;
            this.attributeDependencyScanner = new AttributeDependencyScanner();
            this.childNodeDependencyScanner = new ChildNodeDependencyScanner(typeTable);
            this.classInitializerTextParser = new ClassInitializerTextParser();
        }

        @Override
        public void analyze(Node node) {
            this.registerDependencies(node);
        }

        @Override
        public void analyze(LayeredNode node) {
            this.analyze((Node)node);
        }

        @Override
        public void analyze(CDATANode node) {
        }

        @Override
        public void analyze(StyleNode node) {
        }

        @Override
        public void analyze(ScriptNode node) {
        }

        @Override
        public void analyze(MetaDataNode node) {
        }

        @Override
        public void analyze(ModelNode node) {
            this.requestType(this.standardDefs.CLASS_OBJECTPROXY, node);
        }

        @Override
        public void analyze(XMLNode node) {
            if (!node.isE4X()) {
                this.requestType(this.standardDefs.CLASS_XMLUTIL, node);
            }
            this.requestType(this.standardDefs.getXmlBackingClassName(node.isE4X()), node);
        }

        @Override
        public void analyze(XMLListNode node) {
            this.requestType("XMLList", node);
        }

        @Override
        public void analyze(BindingNode node) {
        }

        @Override
        public void analyze(StringNode node) {
        }

        @Override
        public void analyze(NumberNode node) {
        }

        @Override
        public void analyze(IntNode node) {
        }

        @Override
        public void analyze(UIntNode node) {
        }

        @Override
        public void analyze(BooleanNode node) {
        }

        @Override
        public void analyze(WebServiceNode node) {
            this.registerDependencies(node);
        }

        @Override
        public void analyze(StateNode node) {
            this.registerDependencies(node);
        }

        @Override
        public void analyze(HTTPServiceNode node) {
            this.registerDependencies(node);
        }

        @Override
        public void analyze(RemoteObjectNode node) {
            this.registerDependencies(node);
        }

        @Override
        public void analyze(OperationNode node) {
            this.registerDependencies(node, this.standardDefs.getConvertedTagName(node));
        }

        @Override
        public void analyze(RequestNode node) {
        }

        @Override
        public void analyze(MethodNode node) {
            this.registerDependencies(node, this.standardDefs.getConvertedTagName(node));
        }

        @Override
        public void analyze(ArgumentsNode node) {
        }

        @Override
        public void analyze(InlineComponentNode node) {
            QName classQName = node.getClassQName();
            if (classQName == null) {
                this.log(node, (CompilerMessage)new InlineComponentInternalError());
            } else {
                this.newTypeRequests.add(NameFormatter.toMultiName(this.standardDefs.CLASS_CLASSFACTORY));
                this.newTypeRequests.add(NameFormatter.toMultiName(classQName));
                this.info.addImportName(NameFormatter.toDot(this.standardDefs.CLASS_CLASSFACTORY), node.beginLine);
                this.info.addImportName(NameFormatter.toDot(classQName), node.beginLine);
            }
        }

        @Override
        public void analyze(LibraryNode node) {
            super.analyze(node);
        }

        @Override
        public void analyze(DefinitionNode node) {
            QName classQName = node.getName();
            if (classQName == null) {
                this.log(node, (CompilerMessage)new DefinitionNodeInternalError());
            }
        }

        @Override
        public void analyze(DeclarationsNode node) {
            super.analyze(node);
        }

        @Override
        public void analyze(ReparentNode node) {
        }

        private void registerDependencies(Node node) {
            this.registerDependencies(node, node.getLocalPart());
        }

        private void registerDependencies(Node node, String localPart) {
            String className = this.info.getLocalClass(node.getNamespace(), localPart);
            if (className == null) {
                className = InterfaceCompiler.this.nameMappings.resolveClassName(node.getNamespace(), localPart);
            }
            if (className == null) {
                ThreadLocalToolkit.log((CompilerMessage)new AnalyzerAdapter.CouldNotResolveToComponent(node.image), this.unit.getSource(), node.beginLine);
                return;
            }
            Type type = this.requestType(className, node);
            if (type != null) {
                Iterator<QName> iter = node.getAttributeNames();
                while (iter.hasNext() && ThreadLocalToolkit.errorCount() == 0) {
                    this.attributeDependencyScanner.invoke(node, type, iter.next());
                }
                this.childNodeDependencyScanner.scanChildNodes(node, type);
            }
        }

        private Type requestType(String className, Node node) {
            this.info.addImportName(NameFormatter.toDot(className), node.beginLine);
            Type type = this.typeTable.getType(className);
            if (type == null) {
                MultiName multiName = NameFormatter.toMultiName(className);
                if (this.allTypeRequests.contains(multiName)) {
                    ThreadLocalToolkit.log((CompilerMessage)new AnalyzerAdapter.CouldNotResolveToComponent(node.image), this.unit.getSource(), node.beginLine);
                } else {
                    this.checkNodes.add(node);
                    this.newTypeRequests.add(multiName);
                }
            }
            return type;
        }

        @Override
        protected int getDocumentVersion() {
            return this.info.getVersion();
        }

        @Override
        protected String getLanguageNamespace() {
            return this.info.getLanguageNamespace();
        }

        protected void requestEventType(Event event) {
            if (event.getType() == null) {
                this.newTypeRequests.add(NameFormatter.toMultiName(event.getTypeName()));
            }
        }

        protected class ClassInitializerTextParser
        extends TextParser {
            ClassInitializerTextParser() {
                super(DependencyAnalyzer.this.typeTable);
            }

            public void parse(String text, Type type) {
                int flags = 0;
                if ("http://ns.adobe.com/fxg/2008".equals(DependencyAnalyzer.this.getLanguageNamespace())) {
                    flags |= 0x10;
                }
                super.parse(text, type, null, flags);
            }

            protected BindingExpression parseBindingExpression(String text, int line) {
                return null;
            }

            public String contextRoot(String text) {
                return null;
            }

            public Object embed(String text, Type type) {
                if (DependencyAnalyzer.this.standardDefs.isIFactory(type)) {
                    DependencyAnalyzer.this.newTypeRequests.add(NameFormatter.toMultiName(((DependencyAnalyzer)DependencyAnalyzer.this).standardDefs.CLASS_CLASSFACTORY));
                }
                return null;
            }

            public Object clear() {
                return null;
            }

            public Object resource(String text, Type type) {
                return null;
            }

            public Object bindingExpression(String converted) {
                return null;
            }

            public Object bindingExpression(String converted, boolean isTwoWay) {
                return null;
            }

            public Object percentage(String pct) {
                return null;
            }

            public Object array(Collection entries, Type arrayElementType) {
                return null;
            }

            public Object functionText(String text) {
                return null;
            }

            public Object className(String name, Type type) {
                if (DependencyAnalyzer.this.standardDefs.isIFactory(type)) {
                    DependencyAnalyzer.this.newTypeRequests.add(NameFormatter.toMultiName(((DependencyAnalyzer)DependencyAnalyzer.this).standardDefs.CLASS_CLASSFACTORY));
                }
                DependencyAnalyzer.this.newTypeRequests.add(NameFormatter.toMultiName(name));
                return null;
            }

            public void error(int err, String text, Type type, Type arrayElementType) {
            }
        }

        protected class ChildNodeDependencyScanner
        extends ChildNodeHandler {
            protected ChildNodeDependencyScanner(TypeTable typeTable) {
                super(typeTable, "http://ns.adobe.com/fxg/2008".equals(DependencyAnalyzer.this.info.getLanguageNamespace()));
            }

            private void scanGrandchildren() {
                Iterator iter = this.child.getChildIterator();
                while (iter.hasNext()) {
                    ((Node)iter.next()).analyze(DependencyAnalyzer.this);
                }
            }

            private void scanChild() {
                this.child.analyze(DependencyAnalyzer.this);
            }

            protected void event(Event event) {
                DependencyAnalyzer.this.requestEventType(event);
                this.scanGrandchildren();
            }

            protected void states(Property property) {
                if (DependencyAnalyzer.this.info.getVersion() >= 4) {
                    DependencyAnalyzer.this.newTypeRequests.add(NameFormatter.toMultiName(((DependencyAnalyzer)DependencyAnalyzer.this).standardDefs.CLASS_SETPROPERTY));
                    DependencyAnalyzer.this.newTypeRequests.add(NameFormatter.toMultiName(((DependencyAnalyzer)DependencyAnalyzer.this).standardDefs.CLASS_SETEVENTHANDLER));
                    DependencyAnalyzer.this.newTypeRequests.add(NameFormatter.toMultiName(((DependencyAnalyzer)DependencyAnalyzer.this).standardDefs.CLASS_SETSTYLE));
                    DependencyAnalyzer.this.newTypeRequests.add(NameFormatter.toMultiName(((DependencyAnalyzer)DependencyAnalyzer.this).standardDefs.CLASS_ADDITEMS));
                    DependencyAnalyzer.this.newTypeRequests.add(NameFormatter.toMultiName(((DependencyAnalyzer)DependencyAnalyzer.this).standardDefs.INTERFACE_IOVERRIDE));
                    this.scanGrandchildren();
                } else {
                    this.property(property);
                }
            }

            protected void property(Property property) {
                CDATANode cdata;
                Type type = property.getType();
                if ((type.equals(type.getTypeTable().classType) || DependencyAnalyzer.this.standardDefs.isInstanceGenerator(type)) && (cdata = DependencyAnalyzer.this.getTextContent(this.child.getChildren(), true)) != null) {
                    DependencyAnalyzer.this.classInitializerTextParser.parse(cdata.image, type);
                }
                this.scanGrandchildren();
            }

            protected void effect(Effect effect) {
                this.scanGrandchildren();
            }

            protected void style(Style style) {
                this.scanGrandchildren();
            }

            protected void dynamicProperty(String name, String state) {
                if (this.parent instanceof DocumentNode) {
                    this.scanChild();
                } else {
                    this.scanGrandchildren();
                }
            }

            protected void defaultPropertyElement(boolean locError) {
                this.scanChild();
            }

            protected void nestedDeclaration() {
                this.scanChild();
            }

            protected void textContent() {
            }

            protected void languageNode() {
                this.scanChild();
            }
        }

        protected class AttributeDependencyScanner
        extends AttributeHandler {
            protected AttributeDependencyScanner() {
            }

            protected boolean isSpecial(String namespace, String localPart) {
                return false;
            }

            protected void special(Type type, String namespace, String localPart) {
            }

            protected void event(Event event) {
                DependencyAnalyzer.this.requestEventType(event);
            }

            protected void states(Property property) {
            }

            protected void property(Property property) {
                Type type = property.getType();
                if (type.equals(type.getTypeTable().classType) || DependencyAnalyzer.this.standardDefs.isInstanceGenerator(type)) {
                    DependencyAnalyzer.this.classInitializerTextParser.parse(this.text, type);
                }
            }

            protected void dynamicProperty(String name) {
            }

            protected void effect(Effect effect) {
            }

            protected void style(Style style) {
            }

            protected void dynamicProperty(String name, String state) {
            }

            protected void qualifiedAttribute(Node node, Type type, String namespace, String localPart) {
            }

            protected void unknownNamespace(String namespace, String localPart) {
            }

            protected void unknown(String namespace, String localPart) {
            }
        }
    }

    private class InterfaceAnalyzer
    extends AnalyzerAdapter {
        private DocumentInfo docInfo;
        private ClassInfo baseClassInfo;
        private int repeaterNum;
        private int innerClassCount;
        private Set<String> innerClassNames;
        private Set<String> bogusImports;
        private Set<DesignLayerNode> declaredLayers;
        private boolean generateAst;

        private InterfaceAnalyzer(CompilationUnit unit, DocumentInfo docInfo, ClassInfo baseClassInfo, boolean generateAst) {
            super(unit, null);
            this.innerClassCount = 0;
            this.innerClassNames = new HashSet<String>();
            this.bogusImports = new HashSet<String>();
            this.declaredLayers = new HashSet<DesignLayerNode>();
            this.docInfo = docInfo;
            this.baseClassInfo = baseClassInfo;
            this.generateAst = generateAst;
        }

        public void analyze(Node node) {
            boolean inRepeater = false;
            String className = InterfaceCompiler.this.nameMappings.resolveClassName(node.getNamespace(), node.getLocalPart());
            if (className != null && this.standardDefs.isRepeater(className)) {
                ++this.repeaterNum;
                inRepeater = true;
            }
            this.registerVariableForId(node, null);
            super.analyze(node);
            if (inRepeater) {
                --this.repeaterNum;
            }
            if (node instanceof DocumentNode) {
                List<DesignLayerNode> layers = ((DocumentNode)node).layerDeclarationNodes;
                Iterator<DesignLayerNode> i = layers.iterator();
                while (i.hasNext()) {
                    this.registerVariableForId(i.next(), null);
                }
            }
        }

        public void analyze(LayeredNode node) {
            this.analyze((Node)node);
            for (DesignLayerNode layerParent = node.getLayerParent(); layerParent != null; layerParent = layerParent.getLayerParent()) {
                if (this.declaredLayers.contains(layerParent)) continue;
                this.registerVariableForId(layerParent, null);
                this.declaredLayers.add(layerParent);
            }
        }

        public void analyze(ScriptNode node) {
            if (node.getSourceFile() == null) {
                CDATANode cdata = (CDATANode)node.getChildAt(0);
                if (cdata != null) {
                    Script script = new Script(cdata.image, cdata.beginLine, cdata.endLine);
                    script.setEmbeddedScript(true);
                    this.docInfo.addScript(script);
                }
            } else {
                String source = (String)node.getAttributeValue("source");
                if (source != null) {
                    Script script = new Script("include \"" + source + "\";", node.beginLine);
                    this.docInfo.addScript(script);
                }
            }
        }

        public void analyze(MetaDataNode node) {
            CDATANode cdata = (CDATANode)node.getChildAt(0);
            if (cdata != null) {
                Script script = new Script(cdata.image, cdata.beginLine, cdata.endLine);
                this.docInfo.addMetadata(script);
            }
        }

        public void analyze(ModelNode node) {
            this.registerVariableForId(node, NameFormatter.toDot(this.standardDefs.CLASS_OBJECTPROXY));
        }

        public void analyze(XMLNode node) {
            if (!node.isE4X()) {
                this.docInfo.addImportName(NameFormatter.toDot(this.standardDefs.CLASS_XMLUTIL), node.beginLine);
            }
            this.registerVariableForId(node, NameFormatter.toDot(this.standardDefs.getXmlBackingClassName(node.isE4X())));
        }

        public void analyze(XMLListNode node) {
            this.registerVariableForId(node, NameFormatter.toDot("XMLList"));
        }

        public void analyze(ArrayNode node) {
            this.registerVariableForId(node, "Array");
            super.analyze(node);
        }

        public void analyze(VectorNode node) {
            if (this.getLanguageAttribute(node, "type") != null) {
                this.registerVariableForId(node, StandardDefs.CLASS_VECTOR);
                super.analyze(node);
            } else {
                this.log(node, node.beginLine, new VectorTypeRequired());
            }
        }

        public void analyze(BindingNode node) {
        }

        public void analyze(PrivateNode node) {
        }

        public void analyze(StringNode node) {
            this.registerVariableForId(node, null);
        }

        public void analyze(NumberNode node) {
            this.registerVariableForId(node, null);
        }

        public void analyze(IntNode node) {
            this.registerVariableForId(node, null);
        }

        public void analyze(UIntNode node) {
            this.registerVariableForId(node, null);
        }

        public void analyze(BooleanNode node) {
            this.registerVariableForId(node, null);
        }

        public void analyze(WebServiceNode node) {
            this.registerVariableForId(node, null);
            super.analyze(node);
        }

        public void analyze(OperationNode node) {
            super.analyze(node);
        }

        public void analyze(HTTPServiceNode node) {
            this.registerVariableForId(node, null);
            super.analyze(node);
        }

        public void analyze(RemoteObjectNode node) {
            this.registerVariableForId(node, null);
            super.analyze(node);
        }

        public void analyze(InlineComponentNode node) {
            this.createInlineComponentUnit(node);
            this.registerVariableForId(node, this.standardDefs.INTERFACE_IFACTORY);
        }

        public void analyze(DeclarationsNode node) {
            super.analyze(node);
        }

        public void analyze(LibraryNode node) {
            super.analyze(node);
        }

        public void analyze(DefinitionNode node) {
            this.createDefinitionUnit(node);
        }

        public void analyze(StateNode node) {
            this.processStateNode(node);
            this.registerVariableForId(node, null);
            super.analyze(node);
        }

        protected void traverse(Node node) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                Node child = (Node)node.getChildAt(i);
                child.analyze(this);
                if (!(child instanceof ScriptNode)) continue;
                node.replaceNode(i, Collections.<Token>emptyList());
                --i;
            }
        }

        private void registerVariableForId(Node node, String className) {
            String id = null;
            int line = 0;
            Attribute attr = this.getLanguageAttribute(node, "id");
            if (attr != null) {
                id = (String)attr.getValue();
                line = attr.getLine();
            }
            this.registerVariable(node, id, line, className);
        }

        private void registerVariable(Node node, String id, int line, String className) {
            if (id != null) {
                if (!TextParser.isValidIdentifier(id)) {
                    this.log(node, line, new InvalidIdentifier(id));
                } else if (this.docInfo.containsVarDecl(id)) {
                    this.log(line, (CompilerMessage)new IdentifierUsedMoreThanOnce(id));
                } else if (this.docInfo.getClassName().equals(id)) {
                    this.log(line, (CompilerMessage)new IdentifierMatchesClassName(id));
                } else {
                    if (className == null) {
                        className = InterfaceCompiler.this.nameMappings.resolveClassName(node.getNamespace(), node.getLocalPart());
                    }
                    if (this.repeaterNum > 0) {
                        className = "Array";
                    }
                    if (className != null) {
                        if (this.baseClassInfo == null || !this.baseClassInfo.definesVariable(id) && !this.baseClassInfo.definesGetter(id, true) && !this.baseClassInfo.definesSetter(id, true)) {
                            if (className.equals(StandardDefs.CLASS_VECTOR)) {
                                this.docInfo.addVectorVarDecl(id, line, (String)node.getAttribute("type").getValue());
                            } else {
                                this.docInfo.addVarDecl(id, NameFormatter.toDot(className), line);
                            }
                        }
                    } else {
                        this.log(line, (CompilerMessage)new AnalyzerAdapter.CouldNotResolveToComponent(node.image));
                    }
                }
            } else {
                if (className == null) {
                    className = InterfaceCompiler.this.nameMappings.resolveClassName(node.getNamespace(), node.getLocalPart());
                }
                if (className != null && className.indexOf(42) == -1) {
                    this.bogusImports.add(NameFormatter.toDot(className));
                }
            }
        }

        private void createInlineComponentUnit(InlineComponentNode node) {
            Node componentRoot = (Node)node.getChildAt(0);
            String className = this.getInnerClassName(node.getAttribute("className"));
            QName classQName = new QName(this.docInfo.getPackageName(), className);
            this.docInfo.addImportName(NameFormatter.toDot(classQName), node.beginLine);
            node.setClassQName(classQName);
            TextFile virtualFile = new TextFile(InterfaceCompiler.EMPTY_STRING, this.unit.getSource().getName() + "$" + className, this.unit.getSource().getName(), this.unit.getSource().getParent(), "text/mxml", this.unit.getSource().getLastModified());
            Source source = new Source(virtualFile, this.unit.getSource(), className, false, false);
            DocumentNode inlineDocumentNode = DocumentNode.inlineDocumentNode(componentRoot.getNamespace(), componentRoot.getLocalPart(), NameFormatter.toDot(this.docInfo.getPackageName(), this.docInfo.getClassName()));
            inlineDocumentNode.beginLine = componentRoot.beginLine;
            inlineDocumentNode.beginColumn = componentRoot.beginColumn;
            inlineDocumentNode.endLine = componentRoot.endLine;
            inlineDocumentNode.endColumn = componentRoot.endColumn;
            inlineDocumentNode.image = componentRoot.image;
            inlineDocumentNode.comment = this.generateAst ? "<description><![CDATA[]]></description><private><![CDATA[]]></private>" : "@private";
            componentRoot.copy(inlineDocumentNode);
            inlineDocumentNode.setLocalClassMappings(this.docInfo.getLocalClassMappings());
            inlineDocumentNode.setLanguageNamespace(this.docInfo.getLanguageNamespace());
            inlineDocumentNode.setVersion(this.docInfo.getVersion());
            this.addExcludeClassNode(inlineDocumentNode, componentRoot);
            source.addSourceFragment(InterfaceCompiler.AttrInlineComponentSyntaxTree, inlineDocumentNode, null);
            this.unit.addGeneratedSource(classQName, source);
        }

        private void addExcludeClassNode(DocumentNode inlineDocumentNode, Node componentRoot) {
            MetaDataNode inlineExcludeNode = new MetaDataNode(componentRoot.getNamespace(), componentRoot.getLocalPart(), 0);
            inlineExcludeNode.image = componentRoot.image;
            CDATANode excludeTextNode = new CDATANode();
            excludeTextNode.image = "[ExcludeClass]";
            inlineExcludeNode.addChild(excludeTextNode);
            inlineDocumentNode.addChild(inlineExcludeNode);
        }

        private void createDefinitionUnit(DefinitionNode node) {
            Node definitionRoot = (Node)node.getChildAt(0);
            String nameAttr = (String)node.getAttributeValue("name");
            String className = this.docInfo.getClassName() + "_definition" + this.innerClassCount++;
            QName classQName = new QName(this.docInfo.getPackageName(), className);
            this.docInfo.addLocalClass(node.getNamespace(), nameAttr, classQName.toString());
            node.setName(classQName);
            TextFile virtualFile = new TextFile(InterfaceCompiler.EMPTY_STRING, this.unit.getSource().getName() + "$" + className, this.unit.getSource().getName(), this.unit.getSource().getParent(), "text/mxml", this.unit.getSource().getLastModified());
            Source source = new Source(virtualFile, this.unit.getSource(), className, false, false);
            DocumentNode definitionDocumentNode = new DocumentNode(definitionRoot.getNamespace(), definitionRoot.getLocalPart());
            definitionDocumentNode.beginLine = definitionRoot.beginLine;
            definitionDocumentNode.beginColumn = definitionRoot.beginColumn;
            definitionDocumentNode.endLine = definitionRoot.endLine;
            definitionDocumentNode.endColumn = definitionRoot.endColumn;
            definitionDocumentNode.image = definitionRoot.image;
            definitionDocumentNode.comment = this.generateAst ? "<description><![CDATA[]]></description><private><![CDATA[]]></private>" : "@private";
            definitionRoot.copy(definitionDocumentNode);
            definitionDocumentNode.setLocalClassMappings(this.docInfo.getLocalClassMappings());
            definitionDocumentNode.setLanguageNamespace(this.docInfo.getLanguageNamespace());
            definitionDocumentNode.setVersion(this.docInfo.getVersion());
            source.addSourceFragment(InterfaceCompiler.AttrInlineComponentSyntaxTree, definitionDocumentNode, null);
            this.unit.addGeneratedSource(classQName, source);
        }

        private String getInnerClassName(Attribute attribute) {
            String result = null;
            if (attribute != null) {
                result = (String)attribute.getValue();
                if (!TextParser.isValidIdentifier(result)) {
                    this.log(attribute.getLine(), (CompilerMessage)new ClassNameInvalidActionScriptIdentifier());
                    result = null;
                } else if (this.innerClassNames.contains(result)) {
                    this.log(attribute.getLine(), (CompilerMessage)new ClassNameSpecifiedMoreThanOnce());
                    result = null;
                } else {
                    this.innerClassNames.add(result);
                }
            }
            if (result == null) {
                result = this.docInfo.getClassName() + "InnerClass" + this.innerClassCount++;
            }
            return result;
        }

        private void processStateNode(Node node) {
            Attribute stateNameAttr = this.getLanguageAttribute(node, "name");
            String exclude = (String)this.getLanguageAttributeValue(node, "excludeFrom");
            String include = (String)this.getLanguageAttributeValue(node, "includeIn");
            String stateName = null;
            int line = 0;
            if (stateNameAttr != null) {
                stateName = (String)stateNameAttr.getValue();
                line = stateNameAttr.getLine();
            }
            if (TextParser.isValidStateIdentifier(stateName) || this.getDocumentVersion() < 4) {
                if (include == null && exclude == null) {
                    this.docInfo.addStateName(stateName, line);
                    String groups = (String)node.getAttributeValue("stateGroups");
                    Collection<String> stateGroups = TextParser.parseStringList(groups);
                    for (String groupName : stateGroups) {
                        if (TextParser.isValidStateIdentifier(groupName)) {
                            this.docInfo.addStateGroup(groupName, stateName, line);
                            continue;
                        }
                        this.log(node, line, new InvalidIdentifier(groupName));
                    }
                } else {
                    this.log(node, line, new InvalidStateAttributeUsage(node.getLocalPart()));
                }
            } else if (stateName == null) {
                this.log(node, line, new StateNameRequired());
            } else {
                this.log(node, line, new InvalidIdentifier(stateName));
            }
        }

        protected int getDocumentVersion() {
            return this.docInfo.getVersion();
        }

        protected String getLanguageNamespace() {
            return this.docInfo.getLanguageNamespace();
        }
    }
}

