/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.as3;

import flex2.compiler.CompilationUnit;
import flex2.compiler.CompilerContext;
import flex2.compiler.abc.AbcClass;
import flex2.compiler.abc.MetaData;
import flex2.compiler.abc.Method;
import flex2.compiler.abc.Variable;
import flex2.compiler.as3.AbstractSyntaxTreeUtil;
import flex2.compiler.as3.Extension;
import flex2.compiler.as3.binding.ClassInfo;
import flex2.compiler.as3.binding.TypeAnalyzer;
import flex2.compiler.as3.reflect.NodeMagic;
import flex2.compiler.as3.reflect.TypeTable;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.QName;
import java.util.List;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.DefinitionNode;
import macromedia.asc.parser.DocCommentNode;
import macromedia.asc.parser.MetaDataEvaluator;
import macromedia.asc.parser.MetaDataNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.NodeFactory;
import macromedia.asc.parser.StatementListNode;
import macromedia.asc.parser.TypeExpressionNode;
import macromedia.asc.util.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HostComponentExtension
implements Extension {
    private static final String SKINHOSTCOMPONENT = "hostComponent".intern();
    private static final String BINDABLE = "Bindable".intern();
    private static final String[] PUBLIC_NAMESPACE = new String[]{""};

    @Override
    public void parse1(CompilationUnit unit, TypeTable typeTable) {
        if (unit.hostComponentMetaData != null) {
            CompilerContext context = unit.getContext();
            Context cx = context.getAscContext();
            TypeAnalyzer typeAnalyzer = typeTable.getSymbolTable().getTypeAnalyzer();
            this.generateHostComponentVariable(cx, unit, typeAnalyzer);
        }
    }

    @Override
    public void parse2(CompilationUnit unit, TypeTable typeTable) {
    }

    @Override
    public void analyze1(CompilationUnit unit, TypeTable typeTable) {
    }

    @Override
    public void analyze2(CompilationUnit unit, TypeTable typeTable) {
    }

    @Override
    public void analyze3(CompilationUnit unit, TypeTable typeTable) {
    }

    @Override
    public void analyze4(CompilationUnit unit, TypeTable typeTable) {
    }

    @Override
    public void generate(CompilationUnit unit, TypeTable typeTable) {
        if (unit.hostComponentMetaData != null) {
            CompilerContext context = unit.getContext();
            Context cx = context.getAscContext();
            this.validateRequiredSkinPartsAndStates(cx, unit, typeTable);
        }
    }

    private void generateHostComponentVariable(Context cx, CompilationUnit unit, TypeAnalyzer typeAnalyzer) {
        DefinitionNode def;
        MetaDataNode node = unit.hostComponentMetaData;
        if (node.count() == 1 && (def = node.def) instanceof ClassDefinitionNode) {
            unit.expressions.add(NameFormatter.toMultiName(node.getValue(0)));
            ClassDefinitionNode classDef = (ClassDefinitionNode)def;
            if (!this.classDeclaresIdentifier(cx, classDef, typeAnalyzer, SKINHOSTCOMPONENT)) {
                NodeFactory nodeFactory = cx.getNodeFactory();
                MetaDataNode bindingMetaData = AbstractSyntaxTreeUtil.generateMetaData(nodeFactory, BINDABLE);
                bindingMetaData.id = BINDABLE;
                StatementListNode statementList = nodeFactory.statementList(classDef.statements, (Node)bindingMetaData);
                int listSize = node.def.metaData.items.size();
                if (listSize > 1) {
                    for (int ix = 0; ix < listSize; ++ix) {
                        DocCommentNode hostComponentComment;
                        String comment;
                        Node temp;
                        Node tempMeta = (Node)node.def.metaData.items.get(ix);
                        if (!(tempMeta instanceof MetaDataNode)) continue;
                        MetaDataNode tempMetaData = (MetaDataNode)tempMeta;
                        if (!"HostComponent".equals(tempMetaData.id) || ix >= listSize - 1 || !((temp = (Node)node.def.metaData.items.get(ix + 1)) instanceof DocCommentNode)) continue;
                        DocCommentNode tempDoc = (DocCommentNode)temp;
                        MetaDataEvaluator evaluator = new MetaDataEvaluator();
                        evaluator.evaluate(cx, tempDoc);
                        if (evaluator.doccomments == null || evaluator.doccomments.size() == 0 || (comment = ((DocCommentNode)evaluator.doccomments.get((int)0)).id) == null || (hostComponentComment = AbstractSyntaxTreeUtil.generateDocComment(nodeFactory, comment.intern())) == null) break;
                        statementList = nodeFactory.statementList(statementList, (Node)hostComponentComment);
                        break;
                    }
                }
                TypeExpressionNode typeExpression = AbstractSyntaxTreeUtil.generateTypeExpression(nodeFactory, node.getValue(0), true);
                Node variableDefinition = AbstractSyntaxTreeUtil.generatePublicVariable(cx, typeExpression, SKINHOSTCOMPONENT);
                classDef.statements = nodeFactory.statementList(statementList, variableDefinition);
            }
        }
    }

    private boolean classDeclaresIdentifier(Context cx, ClassDefinitionNode classDef, TypeAnalyzer typeAnalyzer, String identifier) {
        String className = NodeMagic.getClassName(classDef);
        typeAnalyzer.evaluate(cx, classDef);
        ClassInfo classInfo = typeAnalyzer.getClassInfo(className);
        return classInfo != null && (classInfo.definesVariable(identifier) || classInfo.definesFunction(identifier, true) || classInfo.definesGetter(identifier, true) || classInfo.definesSetter(identifier, true));
    }

    private void validateRequiredSkinParts(AbcClass hostComponentClass, AbcClass skinClass, Context cx, int position, TypeTable typeTable) {
        AbcClass superType;
        String superTypeName;
        QName[] getterNames;
        QName[] variableNames = hostComponentClass.getVariableNames();
        if (variableNames != null) {
            int length = variableNames.length;
            for (int i = 0; i < length; ++i) {
                Variable variable = hostComponentClass.getVariable(new String[]{variableNames[i].getNamespace()}, variableNames[i].getLocalPart(), false);
                List<MetaData> skinPartsMetaDataList = variable.getMetaData("SkinPart");
                if (skinPartsMetaDataList == null) continue;
                this.validateRequiredSkinParts(skinPartsMetaDataList, variableNames[i].getLocalPart(), skinClass, cx, position);
            }
        }
        if ((getterNames = hostComponentClass.getGetterNames()) != null) {
            int length = getterNames.length;
            for (int i = 0; i < length; ++i) {
                Method getter = hostComponentClass.getGetter(new String[]{getterNames[i].getNamespace()}, getterNames[i].getLocalPart(), false);
                List<MetaData> skinPartsMetaDataList = getter.getMetaData("SkinPart");
                if (skinPartsMetaDataList == null) continue;
                this.validateRequiredSkinParts(skinPartsMetaDataList, getterNames[i].getLocalPart(), skinClass, cx, position);
            }
        }
        if ((superTypeName = hostComponentClass.getSuperTypeName()) != null && (superType = typeTable.getClass(superTypeName)) != null) {
            this.validateRequiredSkinParts(superType, skinClass, cx, position, typeTable);
        }
    }

    private void validateRequiredSkinParts(List<MetaData> skinPartsMetaDataList, String skinPartName, AbcClass skinClass, Context cx, int position) {
        for (MetaData skinPartsMetaData : skinPartsMetaDataList) {
            String required = skinPartsMetaData.getValue("required");
            if (!"true".equals(required) || skinClass.getVariable(PUBLIC_NAMESPACE, skinPartName, true) != null || skinClass.getGetter(PUBLIC_NAMESPACE, skinPartName, true) != null) continue;
            cx.localizedError2(cx.input.origin, position, (Object)new MissingSkinPart(skinPartName));
        }
    }

    private void validateRequiredSkinPartsAndStates(Context cx, CompilationUnit unit, TypeTable typeTable) {
        MetaDataNode metaData = unit.hostComponentMetaData;
        String hostComponentClassName = metaData.getValue(0);
        AbcClass hostComponentClass = typeTable.getClass(NameFormatter.toColon(hostComponentClassName));
        if (hostComponentClass == null) {
            cx.localizedError2(cx.input.origin, metaData.pos(), (Object)new HostComponentClassNotFound(hostComponentClassName));
        } else if (unit.hostComponentOwnerClass != null) {
            AbcClass skinClass = typeTable.getClass(unit.hostComponentOwnerClass);
            this.validateRequiredSkinParts(hostComponentClass, skinClass, cx, metaData.pos(), typeTable);
            this.validateRequiredSkinStates(hostComponentClass, skinClass, cx, metaData.pos());
        }
    }

    private void validateRequiredSkinStates(AbcClass hostComponentClass, AbcClass skinClass, Context cx, int position) {
        List<MetaData> skinStatesMetaDataList = hostComponentClass.getMetaData("SkinState", true);
        List<MetaData> statesMetaDataList = skinClass.getMetaData("States", true);
        if (skinStatesMetaDataList != null) {
            for (MetaData skinStatesMetaData : skinStatesMetaDataList) {
                String skinStateName = skinStatesMetaData.getValue(0);
                boolean isFound = false;
                if (statesMetaDataList != null) {
                    block1: for (MetaData statesMetaData : statesMetaDataList) {
                        int count = statesMetaData.count();
                        for (int i = 0; i < count; ++i) {
                            String state = statesMetaData.getValue(i);
                            if (!skinStateName.equals(state)) continue;
                            isFound = true;
                            break block1;
                        }
                    }
                }
                if (isFound) continue;
                cx.localizedError2(cx.input.origin, position, (Object)new MissingSkinState(skinStateName));
            }
        }
    }

    public static class MissingSkinState
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 5290330001936137669L;
        public String skinStateName;

        public MissingSkinState(String skinStateName) {
            this.skinStateName = skinStateName;
        }
    }

    public static class MissingSkinPart
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 5290330001936137667L;
        public String skinPartName;

        public MissingSkinPart(String skinPartName) {
            this.skinPartName = skinPartName;
        }
    }

    public static class HostComponentClassNotFound
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 5290330001936137678L;
        public String className;

        public HostComponentClassNotFound(String className) {
            this.className = className;
        }
    }
}

