/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler;

import flex2.compiler.AssetInfo;
import flex2.compiler.CompilationUnit;
import flex2.compiler.CompilerContext;
import flex2.compiler.FileSpec;
import flex2.compiler.ResourceBundlePath;
import flex2.compiler.ResourceContainer;
import flex2.compiler.SourceList;
import flex2.compiler.SourcePath;
import flex2.compiler.common.PathResolver;
import flex2.compiler.common.SinglePathResolver;
import flex2.compiler.io.InMemoryFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.SwcScript;
import flex2.compiler.util.LineNumberMap;
import flex2.compiler.util.LocalLogger;
import flex2.compiler.util.ThreadLocalToolkit;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Source
implements Comparable<Source> {
    private VirtualFile file;
    private VirtualFile pathRoot;
    private PathResolver resolver;
    private String relativePath;
    private String shortName;
    private Object owner;
    private boolean isInternal;
    private boolean isRoot;
    private boolean isDebuggable;
    private boolean isPreprocessed;
    private CompilationUnit unit;
    private long fileTime;
    private Map<VirtualFile, Long> fileIncludeTimes;
    private Source delegate;
    private LocalLogger logger;
    private Map<String, Object> fragments;
    private Map<String, LineNumberMap> fragmentLineMaps;
    private AssetInfo assetInfo;
    public int lineCount;

    public Source(VirtualFile file, Source original) {
        this(file, original.pathRoot, original.relativePath, original.shortName, original.owner, original.isInternal, original.isRoot, original.isDebuggable);
        this.delegate = original;
    }

    public Source(VirtualFile file, Source original, String shortName, boolean isInternal, boolean isRoot) {
        this(file, original.pathRoot, original.relativePath, shortName, null, isInternal, isRoot, true);
        this.delegate = original;
    }

    public Source(VirtualFile file, String relativePath, String shortName, Object owner, boolean isInternal, boolean isRoot) {
        this(file, null, relativePath, shortName, owner, isInternal, isRoot, true);
    }

    public Source(VirtualFile file, VirtualFile pathRoot, String relativePath, String shortName, Object owner, boolean isInternal, boolean isRoot) {
        this(file, pathRoot, relativePath, shortName, owner, isInternal, isRoot, true);
    }

    public Source(VirtualFile file, String relativePath, String shortName, Object owner, boolean isInternal, boolean isRoot, boolean isDebuggable) {
        this(file, null, relativePath, shortName, owner, isInternal, isRoot, isDebuggable);
    }

    Source(VirtualFile file, VirtualFile pathRoot, String relativePath, String shortName, Object owner, boolean isInternal, boolean isRoot, boolean isDebuggable) {
        this.file = file;
        this.pathRoot = pathRoot;
        this.relativePath = relativePath;
        this.shortName = shortName;
        this.owner = owner;
        this.isInternal = isInternal;
        this.isRoot = isRoot;
        this.isDebuggable = isDebuggable;
        if (file != null) {
            this.fileTime = file.getLastModified();
        }
        this.fileIncludeTimes = new HashMap<VirtualFile, Long>(4);
    }

    public CompilationUnit newCompilationUnit(Object syntaxTree, CompilerContext context) {
        this.unit = new CompilationUnit(this, syntaxTree, context);
        this.unit.setStandardDefs(ThreadLocalToolkit.getStandardDefs());
        return this.unit;
    }

    public CompilationUnit getCompilationUnit() {
        return this.unit;
    }

    void removeCompilationUnit() {
        if (this.isSwcScriptOwner()) {
            this.unit.removeTypeInfo();
        } else {
            this.unit = null;
        }
        this.fileTime = this.file.getLastModified();
        this.logger = null;
        this.isPreprocessed = false;
        this.fileIncludeTimes.clear();
        this.delegate = null;
        this.resolver = null;
        if (this.fragments != null) {
            this.fragments.clear();
            this.fragmentLineMaps.clear();
        }
    }

    public void setAssetInfo(AssetInfo assetInfo) {
        this.assetInfo = assetInfo;
    }

    void setPreprocessed() {
        this.isPreprocessed = true;
    }

    boolean isPreprocessed() {
        return this.isPreprocessed;
    }

    void setLogger(LocalLogger logger) {
        this.logger = logger;
    }

    LocalLogger getLogger() {
        return this.logger;
    }

    void disconnectLogger() {
        if (this.logger != null && this.logger.warningCount() == 0 && this.logger.errorCount() == 0) {
            this.logger = null;
        } else if (this.logger != null) {
            this.logger.disconnect();
        }
    }

    boolean hasError() {
        return this.logger != null && this.logger.errorCount() > 0;
    }

    public Object getOwner() {
        return this.owner;
    }

    void setOwner(Object owner) {
        this.owner = owner;
    }

    public boolean isSourcePathOwner() {
        return this.owner != null && this.owner instanceof SourcePath && !this.isResourceBundlePathOwner();
    }

    public boolean isSourceListOwner() {
        return this.owner != null && this.owner instanceof SourceList;
    }

    public boolean isFileSpecOwner() {
        return this.owner != null && this.owner instanceof FileSpec;
    }

    public boolean isSwcScriptOwner() {
        return this.owner != null && this.owner instanceof SwcScript;
    }

    public boolean isResourceContainerOwner() {
        return this.owner != null && this.owner instanceof ResourceContainer;
    }

    public boolean isResourceBundlePathOwner() {
        return this.owner != null && this.owner instanceof ResourceBundlePath;
    }

    public boolean isInternal() {
        return this.isInternal;
    }

    public boolean isEntryPoint() {
        return this.isFileSpecOwner();
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public boolean isDebuggable() {
        return this.isDebuggable;
    }

    public boolean isCompiled() {
        return this.unit != null && this.unit.isBytecodeAvailable();
    }

    public boolean isUpdated() {
        long lastModified = this.file.getLastModified();
        if (lastModified != this.fileTime) {
            this.fileTime = lastModified;
            return true;
        }
        for (Map.Entry<VirtualFile, Long> entry : this.fileIncludeTimes.entrySet()) {
            if (entry.getKey().getLastModified() == entry.getValue().longValue()) continue;
            return true;
        }
        return false;
    }

    boolean isUpdated(Source source) {
        boolean result = false;
        if (this.assetInfo != null) {
            if (this.assetInfo.getArgs().size() != source.assetInfo.getArgs().size()) {
                result = true;
            } else {
                Iterator<Map.Entry<String, Object>> i = this.assetInfo.getArgs().entrySet().iterator();
                while (i.hasNext() && !result) {
                    Map.Entry<String, Object> entry = i.next();
                    String key = entry.getKey();
                    String value = (String)entry.getValue();
                    if (value.equals("_column") || value.equals("_line") || value.equals(source.assetInfo.getArgs().get(key))) continue;
                    result = true;
                }
            }
        }
        return result;
    }

    public boolean exists() {
        return this.file.getLastModified() > 0L;
    }

    public String getName() {
        return this.file.getName();
    }

    public String getNameForReporting() {
        return this.file.getNameForReporting();
    }

    public String getParent() {
        return this.file.getParent();
    }

    public long size() {
        return this.file.size();
    }

    public InputStream getInputStream() throws IOException {
        return this.file.getInputStream();
    }

    public byte[] toByteArray() throws IOException {
        return this.file.toByteArray();
    }

    public boolean isTextBased() {
        return this.file.isTextBased();
    }

    public String getInputText() {
        return this.file.toString();
    }

    public String getMimeType() {
        return this.file.getMimeType();
    }

    public long getLastModified() {
        return this.fileTime;
    }

    public VirtualFile resolve(String include) {
        return this.getPathResolver().resolve(include);
    }

    public PathResolver getPathResolver() {
        if (this.resolver != null) {
            return this.resolver;
        }
        this.resolver = new PathResolver();
        this.resolver.addSinglePathResolver(new Resolver(this.delegate != null ? this.delegate.getPathResolver() : null, this.file, this.pathRoot));
        this.resolver.addSinglePathResolver(ThreadLocalToolkit.getPathResolver());
        return this.resolver;
    }

    public void setPathResolver(PathResolver r) {
        this.resolver = r;
    }

    public VirtualFile getBackingFile() {
        return this.delegate == null ? this.file : this.delegate.getBackingFile();
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public String getShortName() {
        return this.shortName;
    }

    public VirtualFile getPathRoot() {
        return this.pathRoot;
    }

    public void addFileIncludes(Source s) {
        this.fileIncludeTimes.putAll(s.fileIncludeTimes);
    }

    public boolean addFileInclude(String path) {
        VirtualFile f = this.resolve(path);
        return this.addFileInclude(f);
    }

    public boolean addFileInclude(VirtualFile f) {
        if (f != null) {
            if (!this.fileIncludeTimes.containsKey(f)) {
                this.fileIncludeTimes.put(f, f.getLastModified());
            }
            if (this.delegate != null) {
                this.delegate.addFileInclude(f);
            }
            return true;
        }
        return false;
    }

    public Iterator<VirtualFile> getFileIncludes() {
        return this.fileIncludeTimes.keySet().iterator();
    }

    public Set<VirtualFile> getFileIncludesSet() {
        return new HashSet<VirtualFile>(this.fileIncludeTimes.keySet());
    }

    public Map<VirtualFile, Long> getFileIncludeTimes() {
        return new HashMap<VirtualFile, Long>(this.fileIncludeTimes);
    }

    public boolean isIncludedFile(String name) {
        for (VirtualFile f : this.fileIncludeTimes.keySet()) {
            if (!f.getName().equals(name) && !f.getNameForReporting().equals(name)) continue;
            return true;
        }
        return false;
    }

    public Iterator<VirtualFile> getUpdatedFileIncludes() {
        ArrayList<VirtualFile> updated = null;
        for (VirtualFile f : this.fileIncludeTimes.keySet()) {
            long ts = this.fileIncludeTimes.get(f);
            if (f.getLastModified() == ts) continue;
            if (updated == null) {
                updated = new ArrayList<VirtualFile>(this.fileIncludeTimes.size());
            }
            updated.add(f);
        }
        return updated == null ? null : updated.iterator();
    }

    public int getFileIncludeSize() {
        return this.fileIncludeTimes.size();
    }

    long getFileIncludeTime(VirtualFile f) {
        return this.fileIncludeTimes.get(f);
    }

    long getFileTime() {
        return this.fileTime;
    }

    public void addSourceFragment(String n, Object f, LineNumberMap m) {
        if (this.fragments == null) {
            this.fragments = new HashMap<String, Object>();
            this.fragmentLineMaps = new HashMap<String, LineNumberMap>();
        }
        this.fragments.put(n, f);
        if (m != null) {
            this.fragmentLineMaps.put(n, m);
        }
    }

    public Object getSourceFragment(String n) {
        Object obj;
        Object object = obj = this.fragments == null ? null : this.fragments.get(n);
        if (obj == null && this.delegate != null) {
            return this.delegate.getSourceFragment(n);
        }
        return obj;
    }

    public Collection<LineNumberMap> getSourceFragmentLineMaps() {
        if (this.fragmentLineMaps != null) {
            return this.fragmentLineMaps.values();
        }
        if (this.delegate != null) {
            return this.delegate.getSourceFragmentLineMaps();
        }
        return null;
    }

    void clearSourceFragments() {
        this.fragments = null;
        this.fragmentLineMaps = null;
        if (this.delegate != null) {
            this.delegate.clearSourceFragments();
        }
    }

    public long getRawLastModified() {
        if (this.isSwcScriptOwner()) {
            return ((SwcScript)this.owner).getLibrary().getSwcCreationTime();
        }
        if (this.isFileSpecOwner() || this.isSourceListOwner() || this.isSourcePathOwner()) {
            return this.fileTime;
        }
        return -1L;
    }

    public String getRawLocation() {
        if (this.isSwcScriptOwner()) {
            return ((SwcScript)this.owner).getLibrary().getSwcLocation();
        }
        return this.getName();
    }

    @Override
    public int compareTo(Source source) {
        return this.getName().compareTo(source.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof Source) {
            Source s = (Source)object;
            return s.owner == this.owner && s.getName().equals(this.getName()) && s.getRelativePath().equals(this.getRelativePath());
        }
        return false;
    }

    public void close() {
        this.file.close();
    }

    Source copy() {
        if (this.unit != null && this.unit.isDone()) {
            InMemoryFile f = new InMemoryFile(this.unit.getByteCodes(), this.getName(), "application/x-actionscript-bytecode", this.fileTime);
            Source s = new Source(f, this.pathRoot, this.relativePath, this.shortName, this.owner, this.isInternal, this.isRoot, this.isDebuggable);
            s.fileIncludeTimes.putAll(this.fileIncludeTimes);
            s.setPathResolver(this.getPathResolver());
            s.logger = this.logger;
            CompilationUnit u = s.newCompilationUnit(null, new CompilerContext());
            Source.copyCompilationUnit(this.unit, u, true);
            return s;
        }
        return null;
    }

    static void copyCompilationUnit(CompilationUnit oldUnit, CompilationUnit newUnit, boolean useHistories) {
        newUnit.topLevelDefinitions.addAll(oldUnit.topLevelDefinitions);
        if (useHistories) {
            newUnit.inheritance.addAll(oldUnit.inheritanceHistory.keySet());
            newUnit.types.addAll(oldUnit.typeHistory.keySet());
            newUnit.namespaces.addAll(oldUnit.namespaceHistory.keySet());
            newUnit.expressions.addAll(oldUnit.expressionHistory.keySet());
        } else {
            newUnit.inheritance.addAll(oldUnit.inheritance);
            newUnit.types.addAll(oldUnit.types);
            newUnit.namespaces.addAll(oldUnit.namespaces);
            newUnit.expressions.addAll(oldUnit.expressions);
        }
        newUnit.setSignatureChecksum(oldUnit.getSignatureChecksum());
        if (oldUnit.hasAssets()) {
            newUnit.getAssets().addAll(oldUnit.getAssets());
        }
        newUnit.auxGenerateInfo = oldUnit.auxGenerateInfo;
        if (oldUnit.hasTypeInfo) {
            newUnit.styles = oldUnit.styles;
            newUnit.typeInfo = oldUnit.typeInfo;
            newUnit.hasTypeInfo = true;
            newUnit.classTable.putAll(oldUnit.classTable);
            newUnit.swfMetaData = oldUnit.swfMetaData;
            newUnit.iconFile = oldUnit.iconFile;
            newUnit.loaderClass = oldUnit.loaderClass;
            newUnit.loaderClassBase = oldUnit.loaderClassBase;
            newUnit.extraClasses.addAll(oldUnit.extraClasses);
            newUnit.addAccessibilityClasses(oldUnit);
            newUnit.licensedClassReqs.putAll(oldUnit.licensedClassReqs);
            newUnit.remoteClassAliases.putAll(oldUnit.remoteClassAliases);
            newUnit.effectTriggers.putAll(oldUnit.effectTriggers);
            newUnit.mixins.addAll(oldUnit.mixins);
            newUnit.resourceBundleHistory.addAll(oldUnit.resourceBundleHistory);
        }
    }

    static Source newSource(VirtualFile f, long fileTime, VirtualFile pathRoot, String relativePath, String shortName, Object owner, boolean isInternal, boolean isRoot, boolean isDebuggable, Set<VirtualFile> includes, Map<VirtualFile, Long> includeTimes, LocalLogger logger) {
        Source s = new Source(f, pathRoot, relativePath, shortName, owner, isInternal, isRoot, isDebuggable);
        s.fileTime = fileTime;
        s.fileIncludeTimes.putAll(includeTimes);
        s.logger = logger;
        return s;
    }

    static Source newSource(byte[] abc, String name, long fileTime, VirtualFile pathRoot, String relativePath, String shortName, Object owner, boolean isInternal, boolean isRoot, boolean isDebuggable, Set<VirtualFile> includes, Map<VirtualFile, Long> includeTimes, LocalLogger logger) {
        InMemoryFile f = new InMemoryFile(abc, name, "application/x-actionscript-bytecode", fileTime);
        return Source.newSource(f, fileTime, pathRoot, relativePath, shortName, owner, isInternal, isRoot, isDebuggable, includes, includeTimes, logger);
    }

    static Source populateSource(Source s, long fileTime, VirtualFile pathRoot, String relativePath, String shortName, Object owner, boolean isInternal, boolean isRoot, boolean isDebuggable, Set<VirtualFile> includes, Map<VirtualFile, Long> includeTimes, LocalLogger logger) {
        assert (s != null);
        s.fileTime = fileTime;
        s.pathRoot = pathRoot;
        s.relativePath = relativePath;
        s.shortName = shortName;
        s.owner = owner;
        s.isInternal = isInternal;
        s.isRoot = isRoot;
        s.isDebuggable = isDebuggable;
        s.fileIncludeTimes.putAll(includeTimes);
        s.logger = logger;
        return s;
    }

    public String toString() {
        return this.getName();
    }

    public static void transferDefinitions(CompilationUnit from, CompilationUnit to) {
        to.topLevelDefinitions.addAll(from.topLevelDefinitions);
    }

    public static void transferTypeInfo(CompilationUnit from, CompilationUnit to) {
        to.typeInfo = from.typeInfo;
    }

    public static void clearDependencies(CompilationUnit unit) {
        unit.inheritance.clear();
        unit.types.clear();
        unit.expressions.clear();
        unit.namespaces.clear();
        unit.importPackageStatements.clear();
        unit.importDefinitionStatements.clear();
    }

    public static void transferInheritance(CompilationUnit from, CompilationUnit to) {
        to.inheritance.clear();
        to.inheritance.addAll(from.inheritance);
        to.inheritanceHistory.putAll(from.inheritanceHistory);
    }

    public static void transferDependencies(CompilationUnit from, CompilationUnit to) {
        Source.clearDependencies(to);
        to.inheritance.addAll(from.inheritance);
        to.types.addAll(from.types);
        to.expressions.addAll(from.expressions);
        to.namespaces.addAll(from.namespaces);
        to.importPackageStatements.addAll(from.importPackageStatements);
        to.importDefinitionStatements.addAll(from.importDefinitionStatements);
        to.inheritanceHistory.putAll(from.inheritanceHistory);
        to.typeHistory.putAll(from.typeHistory);
        to.expressionHistory.putAll(from.expressionHistory);
        to.namespaceHistory.putAll(from.namespaceHistory);
    }

    public static void transferNamespaces(CompilationUnit from, CompilationUnit to) {
        to.namespaces.clear();
        to.namespaces.addAll(from.namespaces);
        to.namespaceHistory.putAll(from.namespaceHistory);
    }

    public static void transferExpressions(CompilationUnit from, CompilationUnit to) {
        to.expressions.clear();
        to.expressions.addAll(from.expressions);
        to.expressionHistory.putAll(from.expressionHistory);
    }

    public static void transferAssets(CompilationUnit from, CompilationUnit to) {
        if (from.hasAssets()) {
            to.getAssets().addAll(from.getAssets());
        }
    }

    public static void transferMetaData(CompilationUnit from, CompilationUnit to) {
        to.metadata.addAll(from.metadata);
        to.swfMetaData = from.swfMetaData;
        to.iconFile = from.iconFile;
        to.loaderClass = from.loaderClass;
        to.extraClasses.addAll(from.extraClasses);
        to.addAccessibilityClasses(from);
        to.licensedClassReqs.putAll(from.licensedClassReqs);
        to.remoteClassAliases.putAll(from.remoteClassAliases);
        to.effectTriggers.putAll(from.effectTriggers);
        to.mixins.addAll(from.mixins);
        to.resourceBundles.addAll(from.resourceBundles);
        to.resourceBundleHistory.addAll(from.resourceBundleHistory);
        to.setSignatureChecksum(from.getSignatureChecksum());
    }

    public static void transferGeneratedSources(CompilationUnit from, CompilationUnit to) {
        to.addGeneratedSources(from.getGeneratedSources());
        from.clearGeneratedSources();
    }

    public static void transferClassTable(CompilationUnit from, CompilationUnit to) {
        to.classTable.putAll(from.classTable);
    }

    public static void transferLoaderClassBase(CompilationUnit from, CompilationUnit to) {
        to.loaderClassBase = from.loaderClassBase;
    }

    public static void transferBytecodes(CompilationUnit from, CompilationUnit to) {
        to.bytes.clear();
        to.bytes.set(from.bytes.toByteArray(false), from.bytes.size());
        to.getSource().lineCount = from.getSource().lineCount;
    }

    public static void transferStyles(CompilationUnit from, CompilationUnit to) {
        to.styles = from.styles;
    }

    static class Resolver
    implements SinglePathResolver {
        private PathResolver delegate;
        private VirtualFile file;
        private VirtualFile pathRoot;

        Resolver(PathResolver delegate, VirtualFile file, VirtualFile pathRoot) {
            this.delegate = delegate;
            this.file = file;
            this.pathRoot = pathRoot;
        }

        public VirtualFile resolve(String relative) {
            if (this.delegate != null) {
                return this.delegate.resolve(relative);
            }
            VirtualFile f = null;
            if (relative != null && !relative.startsWith("/")) {
                f = this.file.resolve(relative);
            }
            if (f == null && relative != null && this.pathRoot != null) {
                f = this.pathRoot.resolve(relative.substring(1));
            }
            return f;
        }
    }
}

