/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.swc.catalog;

import flex2.compiler.mxml.lang.StandardDefs;
import flex2.compiler.swc.Digest;
import flex2.compiler.swc.Swc;
import flex2.compiler.swc.SwcArchive;
import flex2.compiler.swc.SwcComponent;
import flex2.compiler.swc.SwcDependencySet;
import flex2.compiler.swc.SwcDirectoryArchive;
import flex2.compiler.swc.SwcException;
import flex2.compiler.swc.SwcFeatures;
import flex2.compiler.swc.SwcFile;
import flex2.compiler.swc.SwcLibrary;
import flex2.compiler.swc.Versions;
import flex2.compiler.swc.catalog.CatalogHandler;
import flex2.compiler.swc.catalog.CatalogReadElement;
import flex2.compiler.swc.catalog.ReadContext;
import flex2.compiler.util.NameFormatter;
import flex2.tools.VersionInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalogReader {
    private InputStream stream;
    protected Swc swc;
    private SwcArchive archive;
    protected Versions versions = new Versions();
    protected SwcFeatures swcFeatures = new SwcFeatures();
    protected Map<String, SwcComponent> components = new HashMap<String, SwcComponent>();
    protected Map<String, SwcLibrary> libraries = new HashMap<String, SwcLibrary>();
    protected Map<String, SwcFile> files = new HashMap<String, SwcFile>();
    protected Map<String, Digest> digests = new HashMap<String, Digest>();
    CatalogReadElement defaultReadElement = new SwcReader();
    protected VersionReader versionReader = new VersionReader();
    protected FeatureReader featureReader = new FeatureReader();
    protected ComponentReader componentReader = new ComponentReader();
    protected LibraryReader libraryReader = new LibraryReader();
    protected ScriptReader scriptReader = new ScriptReader();
    protected FilesReader filesReader = new FilesReader();
    protected DigestReader digestReader = new DigestReader();
    protected MetadataReader metadataReader = new MetadataReader();
    protected UnknownReader unknownReader = new UnknownReader();
    protected Boolean isNewerLibVersion;
    protected boolean isLibraryVersion_1_0;

    public CatalogReader(InputStream stream, Swc swc, SwcArchive archive) {
        this.stream = stream;
        this.swc = swc;
        this.archive = archive;
    }

    public void read() throws IOException, ParserConfigurationException, SAXException {
        if (this.stream == null) {
            throw new SwcException.NullCatalogStream();
        }
        CatalogHandler handler = new CatalogHandler(this);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        SAXParser parser = factory.newSAXParser();
        parser.parse(this.stream, (DefaultHandler)handler);
        handler.clear();
    }

    public Versions getVersions() {
        return this.versions;
    }

    public SwcFeatures getFeatures() {
        return this.swcFeatures;
    }

    public Map<String, Digest> getDigests() {
        return this.digests;
    }

    public Map<String, SwcComponent> getComponents() {
        return this.components;
    }

    public Map<String, SwcLibrary> getLibraries() {
        return this.libraries;
    }

    public Map<String, SwcFile> getFiles() {
        return this.files;
    }

    protected void handleUnknownRecord(String container, String current) {
        String libVersion = this.versions.getLibVersion();
        if (libVersion == null || !this.IsNewerLibVersion(libVersion)) {
            throw new SwcException.UnknownElementInCatalog(current, container);
        }
    }

    public static String readAttribute(String name, Attributes attributes, boolean required) {
        String val = attributes.getValue(name);
        if (val == null && required) {
            throw new SwcException.NoElementValue(name);
        }
        return val;
    }

    public static Long readAttributeLong(String name, Attributes attributes, boolean required) {
        Long val = null;
        String str = CatalogReader.readAttribute(name, attributes, required);
        if (str != null) {
            val = new Long(str);
        }
        return val;
    }

    public static String createDigestHashValue(String hashType, boolean isSigned) {
        StringBuilder sb = new StringBuilder(hashType);
        sb.append(isSigned);
        return sb.toString();
    }

    private boolean IsNewerLibVersion(String libVersion) {
        if (this.isNewerLibVersion == null) {
            this.isNewerLibVersion = new Boolean(VersionInfo.IsNewerLibVersion(libVersion, false));
        }
        return this.isNewerLibVersion;
    }

    class UnknownReader
    extends CatalogReadElement {
        UnknownReader() {
        }

        public CatalogReadElement readElement(ReadContext context) {
            return this;
        }
    }

    class MetadataReader
    extends CatalogReadElement {
        private SwcLibrary currentLibrary;
        private Set<String> metadata = new HashSet<String>();

        MetadataReader() {
        }

        public CatalogReadElement readElement(ReadContext context) {
            String current = context.getCurrentName();
            if ("metadata".equals(current)) {
                String name = CatalogReader.readAttribute("name", context.getCurrentAttributes(), true);
                this.metadata.add(name);
            } else {
                CatalogReader.this.handleUnknownRecord("metadata", current);
            }
            return this;
        }

        public void endElement(ReadContext context) {
            if ("keep-as3-metadata".equals(context.getCurrentName())) {
                assert (this.currentLibrary != null);
                assert (this.metadata != null);
                if (this.metadata != null) {
                    this.currentLibrary.addMetadata(this.metadata);
                    this.metadata = new HashSet<String>();
                }
            }
        }

        public SwcLibrary getCurrentLibrary() {
            return this.currentLibrary;
        }

        public void setCurrentLibrary(SwcLibrary currentLibrary) {
            this.currentLibrary = currentLibrary;
        }
    }

    class DigestReader
    extends CatalogReadElement {
        private SwcLibrary currentLibrary;

        DigestReader() {
        }

        public CatalogReadElement readElement(ReadContext context) {
            String current = context.getCurrentName();
            if ("digest".equals(current)) {
                Attributes attrib = context.getCurrentAttributes();
                String signedAttrib = CatalogReader.readAttribute("signed", attrib, false);
                boolean signed = Boolean.TRUE.toString().equals(signedAttrib);
                Digest digest = new Digest();
                digest.setSigned(signed);
                digest.setType(CatalogReader.readAttribute("type", attrib, true));
                digest.setValue(CatalogReader.readAttribute("value", attrib, true));
                CatalogReader.this.digests.put(CatalogReader.createDigestHashValue(digest.getType(), digest.isSigned()), digest);
                return this;
            }
            CatalogReader.this.handleUnknownRecord("digests", current);
            return this;
        }

        public void endElement(ReadContext context) {
            if ("digests".equals(context.getCurrentName())) {
                if (VersionInfo.LIB_VERSION_1_1.equals(CatalogReader.this.versions.getLibVersion())) {
                    SwcLibrary lib = CatalogReader.this.libraries.get(Swc.LIBRARY_SWF);
                    if (lib != null) {
                        lib.setDigests(CatalogReader.this.digests);
                        CatalogReader.this.digests = new HashMap<String, Digest>();
                    }
                    return;
                }
                assert (this.currentLibrary != null);
                assert (CatalogReader.this.digests != null);
                if (CatalogReader.this.digests != null) {
                    this.currentLibrary.setDigests(CatalogReader.this.digests);
                    CatalogReader.this.digests = new HashMap<String, Digest>();
                }
            }
        }

        public SwcLibrary getCurrentLibrary() {
            return this.currentLibrary;
        }

        public void setCurrentLibrary(SwcLibrary currentLibrary) {
            this.currentLibrary = currentLibrary;
        }
    }

    class FilesReader
    extends CatalogReadElement {
        FilesReader() {
        }

        public CatalogReadElement readElement(ReadContext context) {
            String current = context.getCurrentName();
            if ("file".equals(current)) {
                String path = CatalogReader.readAttribute("path", context.getCurrentAttributes(), true);
                Long mod = CatalogReader.readAttributeLong("mod", context.getCurrentAttributes(), true);
                if (!(CatalogReader.this.archive instanceof SwcDirectoryArchive) || ((SwcDirectoryArchive)CatalogReader.this.archive).exists(path)) {
                    SwcFile file = new SwcFile(path, mod, CatalogReader.this.swc, CatalogReader.this.archive);
                    CatalogReader.this.files.put(path, file);
                }
                return this;
            }
            CatalogReader.this.handleUnknownRecord("files", current);
            return this;
        }
    }

    class ScriptReader
    extends CatalogReadElement {
        public SwcLibrary currentLibrary;
        private String name;
        private long modtime;
        private Long signatureChecksum;
        private Set<String> defs;
        private SwcDependencySet depSet;

        ScriptReader() {
        }

        public CatalogReadElement readElement(ReadContext context) {
            String current = context.getCurrentName();
            if ("script".equals(current)) {
                this.name = CatalogReader.readAttribute("name", context.getCurrentAttributes(), true);
                this.modtime = CatalogReader.readAttributeLong("mod", context.getCurrentAttributes(), true);
                this.signatureChecksum = CatalogReader.readAttributeLong("signatureChecksum", context.getCurrentAttributes(), false);
            } else if ("def".equals(current)) {
                String id = CatalogReader.readAttribute("id", context.getCurrentAttributes(), true);
                this.defs.add(CatalogReader.this.isLibraryVersion_1_0 ? NameFormatter.toColon(id) : id);
            } else if ("dep".equals(current)) {
                String id = CatalogReader.readAttribute("id", context.getCurrentAttributes(), true);
                String type = CatalogReader.readAttribute("type", context.getCurrentAttributes(), false);
                this.depSet.addDependency(type, id);
            } else {
                if ("keep-as3-metadata".equals(current)) {
                    CatalogReader.this.metadataReader.setCurrentLibrary(this.currentLibrary);
                    return CatalogReader.this.metadataReader;
                }
                if ("digests".equals(current)) {
                    CatalogReader.this.digestReader.setCurrentLibrary(this.currentLibrary);
                    return CatalogReader.this.digestReader;
                }
                if (!"ext".equals(current)) {
                    CatalogReader.this.handleUnknownRecord("script", current);
                }
            }
            return this;
        }

        public void endElement(ReadContext context) {
            if ("script".equals(context.getCurrentName())) {
                assert (this.currentLibrary != null);
                assert (this.name != null);
                this.currentLibrary.addScript(this.name, this.defs, this.depSet, this.modtime, this.signatureChecksum);
                this.clear();
            }
        }

        public void clear() {
            CatalogReader.this.scriptReader.name = null;
            CatalogReader.this.scriptReader.modtime = -1L;
            CatalogReader.this.scriptReader.defs = new TreeSet<String>();
            CatalogReader.this.scriptReader.depSet = new SwcDependencySet();
        }
    }

    class LibraryReader
    extends CatalogReadElement {
        LibraryReader() {
        }

        public CatalogReadElement readElement(ReadContext context) {
            String current = context.getCurrentName();
            if ("library".equals(current)) {
                String path = CatalogReader.readAttribute("path", context.getCurrentAttributes(), true);
                SwcLibrary lib = new SwcLibrary(CatalogReader.this.swc, path);
                CatalogReader.this.libraries.put(path, lib);
                CatalogReader.this.scriptReader.clear();
                CatalogReader.this.scriptReader.currentLibrary = lib;
                return CatalogReader.this.scriptReader;
            }
            CatalogReader.this.handleUnknownRecord("libraries", current);
            return this;
        }

        public void endElement(ReadContext context) {
            if ("library".equals(context.getCurrentName()) && VersionInfo.compareVersions(CatalogReader.this.versions.getLibVersion(), VersionInfo.LIB_VERSION_1_2, false) < 0) {
                assert (CatalogReader.this.scriptReader.currentLibrary != null);
                CatalogReader.this.scriptReader.currentLibrary.addMetadata(Arrays.asList(StandardDefs.DefaultAS3Metadata));
            }
        }
    }

    class ComponentReader
    extends CatalogReadElement {
        ComponentReader() {
        }

        public CatalogReadElement readElement(ReadContext context) {
            String current = context.getCurrentName();
            if ("component".equals(current)) {
                SwcComponent comp = new SwcComponent();
                Attributes attrib = context.getCurrentAttributes();
                comp.setClassName(CatalogReader.readAttribute("className", attrib, true));
                comp.setName(CatalogReader.readAttribute("name", attrib, false));
                comp.setUri(CatalogReader.readAttribute("uri", attrib, false));
                comp.setIcon(CatalogReader.readAttribute("icon", attrib, false));
                comp.setDocs(CatalogReader.readAttribute("docs", attrib, false));
                comp.setPreview(CatalogReader.readAttribute("preview", attrib, false));
                comp.setLocation(CatalogReader.this.swc.getLocation());
                CatalogReader.this.components.put(comp.getClassName(), comp);
                return this;
            }
            CatalogReader.this.handleUnknownRecord("components", current);
            return this;
        }
    }

    class FeatureReader
    extends CatalogReadElement {
        FeatureReader() {
        }

        public CatalogReadElement readElement(ReadContext context) {
            String name = context.getCurrentName();
            if ("feature-debug".equals(name)) {
                CatalogReader.this.swcFeatures.setDebug(true);
            } else if ("feature-external-deps".equals(name)) {
                CatalogReader.this.swcFeatures.setExternalDeps(true);
            } else if ("feature-script-deps".equals(name)) {
                CatalogReader.this.swcFeatures.setScriptDeps(true);
            } else if ("feature-components".equals(name)) {
                CatalogReader.this.swcFeatures.setComponents(true);
            } else if ("feature-files".equals(name)) {
                CatalogReader.this.swcFeatures.setFiles(true);
            } else {
                Attributes attrib = context.getCurrentAttributes();
                String req = attrib.getValue("required");
                if (req != null && req.equalsIgnoreCase("true")) {
                    throw new SwcException.UnsupportedFeature(name);
                }
            }
            return this;
        }
    }

    class VersionReader
    extends CatalogReadElement {
        VersionReader() {
        }

        public CatalogReadElement readElement(ReadContext context) {
            String current = context.getCurrentName();
            if ("flex".equals(current)) {
                Attributes attrib = context.getCurrentAttributes();
                CatalogReader.this.versions.setFlexVersion(CatalogReader.readAttribute("version", attrib, true));
                CatalogReader.this.versions.setFlexBuild(CatalogReader.readAttribute("build", attrib, false));
            } else if ("swc".equals(current)) {
                Attributes attrib = context.getCurrentAttributes();
                CatalogReader.this.versions.setLibVersion(CatalogReader.readAttribute("version", attrib, true));
                CatalogReader.this.isLibraryVersion_1_0 = VersionInfo.LIB_VERSION_1_0.equals(CatalogReader.this.versions.getLibVersion());
            }
            return this;
        }
    }

    class SwcReader
    extends CatalogReadElement {
        SwcReader() {
        }

        public CatalogReadElement readElement(ReadContext context) {
            String current = context.getCurrentName();
            if ("versions".equals(current)) {
                return CatalogReader.this.versionReader;
            }
            if ("features".equals(current)) {
                return CatalogReader.this.featureReader;
            }
            if ("components".equals(current)) {
                return CatalogReader.this.componentReader;
            }
            if ("files".equals(current)) {
                return CatalogReader.this.filesReader;
            }
            if ("libraries".equals(current)) {
                return CatalogReader.this.libraryReader;
            }
            if ("swc".equals(current)) {
                return this;
            }
            if ("digests".equals(current)) {
                return CatalogReader.this.digestReader;
            }
            CatalogReader.this.handleUnknownRecord("swc", current);
            return CatalogReader.this.unknownReader;
        }
    }
}

