/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.lang;

import flex2.compiler.mxml.dom.MethodNode;
import flex2.compiler.mxml.dom.Node;
import flex2.compiler.mxml.dom.OperationNode;
import flex2.compiler.mxml.reflect.Type;
import flex2.compiler.util.NameFormatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StandardDefs {
    private static StandardDefs STANDARD_DEFS_MXML_2006;
    public static final String SWC_AIRGLOBAL = "airglobal.swc";
    public static final String SWC_AVMPLUS = "avmplus.swc";
    public static final String SWC_PLAYERGLOBAL = "playerglobal.swc";
    public static final String PACKAGE___AS3___VEC = "__AS3__.vec";
    public static final String PACKAGE_FLASH_ACCESSIBILITY = "flash.accessibility";
    public static final String PACKAGE_FLASH_DATA = "flash.data";
    public static final String PACKAGE_FLASH_DEBUGGER = "flash.debugger";
    public static final String PACKAGE_FLASH_DESKTOP = "flash.desktop";
    public static final String PACKAGE_FLASH_DISPLAY = "flash.display";
    public static final String PACKAGE_FLASH_ERRORS = "flash.errors";
    public static final String PACKAGE_FLASH_EVENTS = "flash.events";
    public static final String PACKAGE_FLASH_EXTERNAL = "flash.external";
    public static final String PACKAGE_FLASH_FILESYSTEM = "flash.filesystem";
    public static final String PACKAGE_FLASH_FILTERS = "flash.filters";
    public static final String PACKAGE_FLASH_GEOM = "flash.geom";
    public static final String PACKAGE_FLASH_HTML = "flash.html";
    public static final String PACKAGE_FLASH_HTML_SCRIPT = "flash.html.script";
    public static final String PACKAGE_FLASH_MEDIA = "flash.media";
    public static final String PACKAGE_FLASH_NET = "flash.net";
    public static final String PACKAGE_FLASH_PRINTING = "flash.printing";
    public static final String PACKAGE_FLASH_PROFILER = "flash.profiler";
    public static final String PACKAGE_FLASH_SYSTEM = "flash.system";
    public static final String PACKAGE_FLASH_TEXT = "flash.text";
    public static final String PACKAGE_FLASH_UI = "flash.ui";
    public static final String PACKAGE_FLASH_UTILS;
    public static final String PACKAGE_FLASH_XML = "flash.xml";
    private static final String PACKAGE_MX_BINDING;
    private static final String PACKAGE_MX_CONTAINERS = "mx.containers";
    private static final String PACKAGE_MX_CONTROLS = "mx.controls";
    private static final String PACKAGE_MX_CORE;
    private static final String PACKAGE_MX_DATA = "mx.data";
    private static final String PACKAGE_MX_DATA_UTILS = "mx.data.utils";
    private static final String PACKAGE_MX_EFFECTS = "mx.effects";
    private static final String PACKAGE_MX_EVENTS = "mx.events";
    public static final String PACKAGE_MX_FILTERS = "mx.filters";
    private static final String PACKAGE_MX_MANAGERS = "mx.managers";
    private static final String PACKAGE_MX_MESSAGING_CONFIG = "mx.messaging.config";
    private static final String PACKAGE_MX_MODULES = "mx.modules";
    private static final String PACKAGE_MX_PRELOADERS = "mx.preloaders";
    private static final String PACKAGE_MX_RESOURCES = "mx.resources";
    private static final String PACKAGE_MX_RPC = "mx.rpc";
    private static final String PACKAGE_MX_RPC_XML = "mx.rpc.xml";
    private static final String PACKAGE_MX_STATES;
    private static final String PACKAGE_MX_STYLES;
    private static final String PACKAGE_MX_UTILS;
    private static final String PACKAGE_SPARK_COMPONENTS = "spark.components";
    private static final String PACKAGE_SPARK_CORE = "spark.core";
    private static final String PACKAGE_SPARK_PRIMITIVES = "spark.primitives";
    private static final String PACKAGE_TEXT_ELEMENTS = "flashx.textLayout.elements";
    private static final String PACKAGE_TEXT_FORMATS = "flashx.textLayout.formats";
    public static final String NAMESPACE_MX_INTERNAL_LOCALNAME;
    public static final String NAMESPACE_MX_INTERNAL_URI = "http://www.adobe.com/2006/flex/mx/internal";
    public final String NAMESPACE_MX_INTERNAL = this.getCorePackage() + ":" + NAMESPACE_MX_INTERNAL_LOCALNAME;
    public final String NAMESPACE_MX_INTERNAL_DOT = this.getCorePackage() + "." + NAMESPACE_MX_INTERNAL_LOCALNAME;
    public final String INTERFACE_IFLEXMODULE_DOT = NameFormatter.toDot(this.getCorePackage(), "IFlexModule");
    public final String INTERFACE_IFLEXMODULEFACTORY_DOT = NameFormatter.toDot(this.getCorePackage(), "IFlexModuleFactory");
    public final String INTERFACE_IBINDINGCLIENT_DOT = NameFormatter.toDot(this.getBindingPackage(), "IBindingClient");
    public final String INTERFACE_ICHILDLIST = NameFormatter.toColon(this.getCorePackage(), "IChildList");
    public final String INTERFACE_ICONTAINER = NameFormatter.toColon(this.getCorePackage(), "IContainer");
    public final String INTERFACE_IDEFERREDINSTANCE = NameFormatter.toColon(this.getCorePackage(), "IDeferredInstance");
    public final String INTERFACE_IDEFERREDINSTANTIATIONUICOMPONENT = NameFormatter.toColon(this.getCorePackage(), "IDeferredInstantiationUIComponent");
    public final String INTERFACE_IEVENTDISPATCHER = NameFormatter.toColon("flash.events", "IEventDispatcher");
    public final String INTERFACE_IGRAPHICELEMENT = NameFormatter.toColon("spark.core", "IGraphicElement");
    public final String INTERFACE_IFACTORY = NameFormatter.toColon(this.getCorePackage(), "IFactory");
    public final String INTERFACE_IFLEXDISPLAYOBJECT = NameFormatter.toColon(this.getCorePackage(), "IFlexDisplayObject");
    public final String INTERFACE_IFOCUSMANAGERCONTAINER = NameFormatter.toColon(this.getManagersPackage(), "IFocusManagerContainer");
    public final String INTERFACE_IID = NameFormatter.toColon(this.getCorePackage(), "IID");
    public final String INTERFACE_IINVALIDATING = NameFormatter.toColon(this.getCorePackage(), "IInvalidating");
    public final String INTERFACE_ILAYOUTMANAGERCLIENT = NameFormatter.toColon(this.getManagersPackage(), "ILayoutManagerClient");
    public final String INTERFACE_IMANAGED = NameFormatter.toColon(this.getDataPackage(), "IManaged");
    public final String INTERFACE_IMODULEINFO = NameFormatter.toColon(this.getModulesPackage(), "IModuleInfo");
    public final String INTERFACE_IMXMLOBJECT = NameFormatter.toColon(this.getCorePackage(), "IMXMLObject");
    public final String INTERFACE_INAVIGATORCONTENT = NameFormatter.toColon(this.getCorePackage(), "INavigatorContent");
    public final String INTERFACE_IOVERRIDE = NameFormatter.toColon(this.getStatesPackage(), "IOverride");
    public final String INTERFACE_IPROPERTYCHANGENOTIFIER = NameFormatter.toColon(this.getCorePackage(), "IPropertyChangeNotifier");
    public final String INTERFACE_IRAWCHILDRENCONTAINER = NameFormatter.toColon(this.getCorePackage(), "IRawChildrenContainer");
    public final String INTERFACE_ISIMPLESTYLECLIENT = NameFormatter.toColon(this.getStylesPackage(), "ISimpleStyleClient");
    public final String INTERFACE_ISTATECLIENT2 = NameFormatter.toColon(this.getCorePackage(), "IStateClient2");
    public final String INTERFACE_ISTYLECLIENT = NameFormatter.toColon(this.getStylesPackage(), "IStyleClient");
    public final String INTERFACE_ISYSTEMMANAGER = NameFormatter.toColon(this.getManagersPackage(), "ISystemManager");
    public final String INTERFACE_ITRANSIENTDEFERREDINSTANCE = NameFormatter.toColon(this.getCorePackage(), "ITransientDeferredInstance");
    public final String INTERFACE_IUICOMPONENT = NameFormatter.toColon(this.getCorePackage(), "IUIComponent");
    public final String INTERFACE_IVISUALELEMENT = NameFormatter.toColon(this.getCorePackage(), "IVisualElement");
    public final String CLASS_CROSSDOMAINRSLITEM_DOT = NameFormatter.toDot(this.getCorePackage(), "CrossDomainRSLItem");
    public final String CLASS_EMBEDDEDFONTREGISTRY_DOT = NameFormatter.toDot(this.getCorePackage(), "EmbeddedFontRegistry");
    public final String CLASS_FLEXVERSION_DOT = NameFormatter.toDot(this.getCorePackage(), "FlexVersion");
    public final String CLASS_EFFECTMANAGER_DOT = NameFormatter.toDot(this.getEffectsPackage(), "EffectManager");
    public final String CLASS_PROPERTYCHANGEEVENT_DOT = NameFormatter.toDot(this.getEventsPackage(), "PropertyChangeEvent").intern();
    public final String CLASS_RESOURCEBUNDLE_DOT = NameFormatter.toDot(this.getResourcesPackage(), "ResourceBundle");
    public final String CLASS_RESOURCEMANAGER_DOT = NameFormatter.toDot(this.getResourcesPackage(), "ResourceManager");
    public final String CLASS_REPEATER_DOT = NameFormatter.toDot(this.getCorePackage(), "Repeater");
    public final String CLASS_STYLEMANAGER_DOT = NameFormatter.toDot(this.getStylesPackage(), "StyleManager");
    public final String CLASS_STYLEMANAGERIMPL_DOT = NameFormatter.toDot(this.getStylesPackage(), "StyleManagerImpl");
    public final String CLASS_SYSTEMMANAGERCHILDMANAGER_DOT = NameFormatter.toDot(this.getManagersPackage(), "systemClasses.ChildManager");
    public final String CLASS_TEXTFIELDFACTORY_DOT = NameFormatter.toDot(this.getCorePackage(), "TextFieldFactory");
    public final String CLASS_SINGLETON_DOT = NameFormatter.toDot(this.getCorePackage(), "Singleton");
    public final String CLASS_ABSTRACTSERVICE = NameFormatter.toColon(this.getRPCPackage(), "AbstractService");
    public final String CLASS_ACCORDION = NameFormatter.toColon(this.getContainerPackage(), "Accordion");
    public final String CLASS_ADDITEMS = NameFormatter.toColon(PACKAGE_MX_STATES, "AddItems");
    public final String CLASS_APPLICATIONDOMAIN = NameFormatter.toColon("flash.system", "ApplicationDomain");
    public final String CLASS_BINDINGMANAGER = NameFormatter.toColon(this.getBindingPackage(), "BindingManager");
    public final String CLASS_CLASSFACTORY = NameFormatter.toColon(this.getCorePackage(), "ClassFactory");
    public final String CLASS_CSSSTYLEDECLARATION = NameFormatter.toColon(this.getStylesPackage(), "CSSStyleDeclaration");
    public final String CLASS_DEFERREDINSTANCEFROMCLASS = NameFormatter.toColon(this.getCorePackage(), "DeferredInstanceFromClass");
    public final String CLASS_DEFERREDINSTANCEFROMFUNCTION = NameFormatter.toColon(this.getCorePackage(), "DeferredInstanceFromFunction");
    public final String CLASS_DOWNLOADPROGRESSBAR = NameFormatter.toColon(this.getPreloadersPackage(), "DownloadProgressBar");
    public final String CLASS_EFFECT = NameFormatter.toColon(this.getEffectsPackage(), "Effect");
    public final String CLASS_EVENT = NameFormatter.toColon("flash.events", "Event");
    public final String CLASS_EVENTDISPATCHER = NameFormatter.toColon("flash.events", "EventDispatcher");
    public final String CLASS_FLEXEVENT = NameFormatter.toColon(this.getEventsPackage(), "FlexEvent");
    public final String CLASS_FLEXSPRITE = NameFormatter.toColon(this.getCorePackage(), "FlexSprite");
    public final String CLASS_SPARK_RADIOBUTTONGROUP = NameFormatter.toColon("spark.components", "RadioButtonGroup");
    public final String CLASS_ITEMSCOMPONENT = NameFormatter.toColon("spark.components", "SkinnableContainer");
    public final String CLASS_LOADERCONFIG = NameFormatter.toColon(this.getMessagingConfigPackage(), "LoaderConfig");
    public final String CLASS_MANAGED = NameFormatter.toColon(this.getDataUtilsPackage(), "Managed");
    public final String CLASS_MODULEEVENT = NameFormatter.toColon(this.getModulesPackage(), "ModuleEvent");
    public final String CLASS_MODULEMANAGER = NameFormatter.toColon(this.getModulesPackage(), "ModuleManager");
    public final String CLASS_NAMESPACEUTIL = NameFormatter.toColon(this.getRPCXMLPackage(), "NamespaceUtil");
    public final String CLASS_OBJECTPROXY = NameFormatter.toColon(this.getUtilsPackage(), "ObjectProxy");
    public final String CLASS_PRELOADER = NameFormatter.toColon(this.getPreloadersPackage(), "Preloader");
    public final String CLASS_PROPERTYCHANGEEVENT = NameFormatter.toColon(this.getEventsPackage(), "PropertyChangeEvent");
    public final String CLASS_RADIOBUTTONGROUP = NameFormatter.toColon(this.getControlsPackage(), "RadioButtonGroup");
    public final String CLASS_REPEATER = NameFormatter.toColon(this.getCorePackage(), "Repeater");
    public final String CLASS_SETEVENTHANDLER = NameFormatter.toColon(this.getStatesPackage(), "SetEventHandler");
    public final String CLASS_SETPROPERTY = NameFormatter.toColon(this.getStatesPackage(), "SetProperty");
    public final String CLASS_SETSTYLE = NameFormatter.toColon(this.getStatesPackage(), "SetStyle");
    public final String CLASS_STATE = NameFormatter.toColon(this.getStatesPackage(), "State");
    public final String CLASS_STYLEEVENT = NameFormatter.toColon(this.getEventsPackage(), "StyleEvent");
    public final String CLASS_STYLEMANAGER = NameFormatter.toColon(this.getStylesPackage(), "StyleManager");
    public final String CLASS_SYSTEMCHILDRENLIST = NameFormatter.toColon(this.getManagersPackage(), "SystemChildrenList");
    public final String CLASS_SYSTEMMANAGER = NameFormatter.toColon(this.getManagersPackage(), "SystemManager");
    public final String CLASS_SYSTEMRAWCHILDRENLIST = NameFormatter.toColon(this.getManagersPackage(), "SystemRawChildrenList");
    public final String CLASS_UICOMPONENT = NameFormatter.toColon(this.getCorePackage(), "UIComponent");
    public final String CLASS_UICOMPONENTDESCRIPTOR = NameFormatter.toColon(this.getCorePackage(), "UIComponentDescriptor");
    public final String CLASS_UIDUTIL = NameFormatter.toColon(this.getUtilsPackage(), "UIDUtil");
    public final String CLASS_VIEWSTACK = NameFormatter.toColon(this.getContainerPackage(), "ViewStack");
    public final String CLASS_XMLUTIL = NameFormatter.toColon(this.getUtilsPackage(), "XMLUtil");
    public static final String CLASS_APPLICATION;
    public static final String CLASS_ARRAY = "Array";
    public static final String CLASS_VECTOR;
    public static final String CLASS_XML = "XML";
    public static final String CLASS_XMLLIST = "XMLList";
    public static final String CLASS_XMLNODE;
    public static final String CLASS_SPARK_APPLICATION;
    public static final String CLASS_SPARK_SPRITEVISUALELEMENT;
    public static final String CLASS_TEXT_DIV;
    public static final String CLASS_TEXT_FORMAT;
    public static final String CLASS_TEXT_IMG;
    public static final String CLASS_TEXT_LINK;
    public static final String CLASS_TEXT_LINK_ACTIVE_FORMAT;
    public static final String CLASS_TEXT_LINK_HOVER_FORMAT;
    public static final String CLASS_TEXT_LINK_NORMAL_FORMAT;
    public static final String CLASS_TEXT_RICHTEXT;
    public static final String CLASS_TEXT_PARAGRAPH;
    public static final String CLASS_TEXT_SPAN;
    public static final String CLASS_TEXT_TAB;
    public static final String CLASS_TEXT_TCY;
    public static final String PROP_CURRENTSTATE = "currentState";
    public static final String PROP_EXCLUDE_STATES = "excludeFrom";
    public static final String PROP_FORMAT = "format";
    public static final String PROP_CLASSFACTORY_GENERATOR = "generator";
    public static final String PROP_ID = "id";
    public static final String PROP_FIXED = "fixed";
    public static final String PROP_TYPE = "type";
    public static final String PROP_INCLUDE_STATES = "includeIn";
    public static final String PROP_ITEM_CREATION_POLICY = "itemCreationPolicy";
    public static final String PROP_ITEM_DESTRUCTION_POLICY = "itemDestructionPolicy";
    public static final String PROP_STATE_NAME = "name";
    public static final String PROP_STATE_GROUPS = "stateGroups";
    public static final String PROP_SOURCE = "source";
    public static final String PROP_CLASSFACTORY_PROPERTIES = "properties";
    public static final String PROP_UICOMPONENT_STATES = "states";
    public static final String PROP_CONTAINER_CHILDREPEATERS;
    public static final String MD_ACCESSIBILITYCLASS = "AccessibilityClass";
    public static final String MD_ARRAYELEMENTTYPE = "ArrayElementType";
    public static final String MD_BINDABLE = "Bindable";
    public static final String MD_CHANGEEVENT = "ChangeEvent";
    public static final String MD_COLLAPSEWHITESPACE = "CollapseWhiteSpace";
    public static final String MD_DEFAULTPROPERTY = "DefaultProperty";
    public static final String MD_DEPRECATED = "Deprecated";
    public static final String MD_EFFECT = "Effect";
    public static final String MD_EMBED = "Embed";
    public static final String MD_EVENT = "Event";
    public static final String MD_FRAME = "Frame";
    public static final String MD_HOSTCOMPONENT = "HostComponent";
    public static final String MD_ICONFILE = "IconFile";
    public static final String MD_INSPECTABLE = "Inspectable";
    public static final String MD_INSTANCETYPE = "InstanceType";
    public static final String MD_MANAGED = "Managed";
    public static final String MD_MIXIN = "Mixin";
    public static final String MD_NONCOMMITTINGCHANGEEVENT = "NonCommittingChangeEvent";
    public static final String MD_PERCENTPROXY = "PercentProxy";
    public static final String MD_REMOTECLASS = "RemoteClass";
    public static final String MD_REQUIRESLICENSE = "RequiresLicense";
    public static final String MD_RESOURCEBUNDLE = "ResourceBundle";
    public static final String MD_RICHTEXTCONTENT = "RichTextContent";
    public static final String MD_STYLE = "Style";
    public static final String MD_SWF = "SWF";
    public static final String MD_TRANSIENT = "Transient";
    public static final String MD_SKINSTATE = "SkinState";
    public static final String MD_EXCLUDE = "Exclude";
    public static final String MD_SKINPART = "SkinPart";
    public static final String MD_ALTERNATIVE = "Alternative";
    public static final String MDPARAM_BINDABLE_EVENT = "event";
    public static final String MDPARAM_TYPE = "type";
    public static final String MDPARAM_DESTINATION = "destination";
    public static final String MDPARAM_MODE = "mode";
    public static final String MDPARAM_STYLE_FORMAT_COLOR = "Color";
    public static final String MDPARAM_INSPECTABLE_FORMAT_COLOR = "Color";
    public static final String MDPARAM_PROPERTY_CHANGE = "propertyChange";
    public static final String MDPARAM_MANAGED_MODE_HIERARCHICAL = "hierarchical";
    public static final String MDPARAM_MANAGED_MODE_ASSOCIATION = "association";
    public static final String MDPARAM_MANAGED_MODE_MANUAL = "manual";
    public static final String[] DefaultAS3Metadata;
    public static final String GRAPHICS_MASK = "mask";
    public static final String GRAPHICS_DEFINITION_NAME = "name";
    public static final String NULL = "null";
    public static final String UNDEFINED = "undefined";
    public static final Set<String> implicitImports;
    public static final String[] splitPackageMxFilters;
    public static final Map<String, String[]> splitImplicitImports;
    public static final Set<String> airOnlyImplicitImports;
    public static final Map<String, String[]> splitAirOnlyImplicitImports;
    private Set<String> standardMxmlImports;
    private Map<String, String[]> splitStandardMxmlImports;
    private String[] watcherImports;
    private static final Set<String> as3ReservedWords;
    private static final Set<String> as3BuiltInTypeNames;
    private static final Set<String> stageProperties;
    private static final Map<Class, String> compatTagMappings;

    private StandardDefs() {
    }

    public static StandardDefs getStandardDefs(String frameworkType) {
        if (STANDARD_DEFS_MXML_2006 == null) {
            STANDARD_DEFS_MXML_2006 = new StandardDefs2006();
        }
        return STANDARD_DEFS_MXML_2006;
    }

    public abstract String getBindingPackage();

    public abstract String getContainerPackage();

    public abstract String getCorePackage();

    public abstract String getControlsPackage();

    public abstract String getDataPackage();

    public abstract String getDataUtilsPackage();

    public abstract String getEffectsPackage();

    public abstract String getEventsPackage();

    public abstract String getManagersPackage();

    public abstract String getMessagingConfigPackage();

    public abstract String getModulesPackage();

    public abstract String getPreloadersPackage();

    public abstract String getResourcesPackage();

    public abstract String getRPCPackage();

    public abstract String getRPCXMLPackage();

    public abstract String getStatesPackage();

    public abstract String getStylesPackage();

    public abstract String getUtilsPackage();

    public abstract String getBindablePropertyTemplate();

    public abstract String getClassDefTemplate();

    public abstract String getClassDefLibTemplate();

    public abstract String getEmbedClassTemplate();

    public abstract String getFontFaceRulesTemplate();

    public abstract String getInterfaceDefTemplate();

    public abstract String getManagedPropertyTemplate();

    public abstract String getSkinClassTemplate();

    public abstract String getStyleDefTemplate();

    public abstract String getStyleLibraryTemplate();

    public abstract String getStyleModuleTemplate();

    public abstract String getWatcherSetupUtilTemplate();

    public final Set<String> getStandardMxmlImports() {
        if (this.standardMxmlImports == null) {
            this.standardMxmlImports = new HashSet<String>();
            this.standardMxmlImports.add(NameFormatter.toDotStar(this.getStylesPackage()));
            this.standardMxmlImports.add(NameFormatter.toDotStar(this.getBindingPackage()));
            this.standardMxmlImports.add(NameFormatter.toDot(this.NAMESPACE_MX_INTERNAL));
            this.standardMxmlImports.add(NameFormatter.toDot(this.INTERFACE_IDEFERREDINSTANCE));
            this.standardMxmlImports.add(NameFormatter.toDot(this.INTERFACE_IFACTORY));
            this.standardMxmlImports.add(NameFormatter.toDot(this.INTERFACE_IPROPERTYCHANGENOTIFIER));
            this.standardMxmlImports.add(NameFormatter.toDot(this.CLASS_CLASSFACTORY));
            this.standardMxmlImports.add(NameFormatter.toDot(this.CLASS_DEFERREDINSTANCEFROMCLASS));
            this.standardMxmlImports.add(NameFormatter.toDot(this.CLASS_DEFERREDINSTANCEFROMFUNCTION));
        }
        return this.standardMxmlImports;
    }

    public final Map<String, String[]> getSplitStandardMxmlImports() {
        if (this.splitStandardMxmlImports == null) {
            this.splitStandardMxmlImports = new HashMap<String, String[]>();
            for (String standardMxmlImport : this.getStandardMxmlImports()) {
                String[] splitStandardMxmlImport = standardMxmlImport.split("\\.");
                for (int i = 0; i < splitStandardMxmlImport.length; ++i) {
                    splitStandardMxmlImport[i] = splitStandardMxmlImport[i].intern();
                }
                this.splitStandardMxmlImports.put(standardMxmlImport, splitStandardMxmlImport);
            }
        }
        return this.splitStandardMxmlImports;
    }

    public String[] getImports() {
        if (this.watcherImports == null) {
            this.watcherImports = new String[]{this.getCorePackage() + ".IFlexModuleFactory", this.getBindingPackage() + ".ArrayElementWatcher", this.getBindingPackage() + ".FunctionReturnWatcher", this.getBindingPackage() + ".IWatcherSetupUtil2", this.getBindingPackage() + ".PropertyWatcher", this.getBindingPackage() + ".RepeaterComponentWatcher", this.getBindingPackage() + ".RepeaterItemWatcher", this.getBindingPackage() + ".StaticPropertyWatcher", this.getBindingPackage() + ".XMLWatcher", this.getBindingPackage() + ".Watcher"};
        }
        return this.watcherImports;
    }

    public static final boolean isReservedWord(String s) {
        return as3ReservedWords.contains(s);
    }

    public static boolean isApplication(Type type) {
        assert (type != null);
        return type.isAssignableTo(CLASS_APPLICATION) || type.isAssignableTo(CLASS_SPARK_APPLICATION);
    }

    public static final boolean isBuiltInTypeName(String s) {
        return as3BuiltInTypeNames.contains(s);
    }

    public static final boolean isStageProperty(String s) {
        return stageProperties.contains(s);
    }

    public final String getConvertedTagName(Node node) {
        String name = compatTagMappings.get(node.getClass());
        return name != null ? name : node.getLocalPart();
    }

    public boolean isContainer(Type type) {
        assert (type != null);
        return type.isAssignableTo(this.INTERFACE_ICONTAINER) || type.isAssignableTo(this.CLASS_REPEATER);
    }

    public boolean isNavigatorContent(Type type) {
        assert (type != null);
        return type.isAssignableTo(this.INTERFACE_INAVIGATORCONTENT) || type.isAssignableTo(this.CLASS_REPEATER);
    }

    public boolean isIUIComponent(Type type) {
        assert (type != null);
        return type.isAssignableTo(this.INTERFACE_IUICOMPONENT);
    }

    public boolean isItemsComponent(Type type) {
        assert (type != null);
        return type.isAssignableTo(this.CLASS_ITEMSCOMPONENT);
    }

    public boolean isHaloNavigator(Type type) {
        assert (type != null);
        return type.isAssignableTo(this.CLASS_ACCORDION) || type.isAssignableTo(this.CLASS_VIEWSTACK);
    }

    public boolean isSparkGraphic(Type type) {
        assert (type != null);
        return type.isAssignableTo(this.INTERFACE_IGRAPHICELEMENT);
    }

    public boolean isSimpleStyleComponent(Type type) {
        assert (type != null);
        return type.isAssignableTo(this.INTERFACE_ISIMPLESTYLECLIENT);
    }

    public boolean isIFactory(Type type) {
        assert (type != null);
        return type.getName().equals(this.INTERFACE_IFACTORY);
    }

    public boolean isIDeferredInstance(Type type) {
        assert (type != null);
        return type.getName().equals(this.INTERFACE_IDEFERREDINSTANCE) || type.getName().equals(this.INTERFACE_ITRANSIENTDEFERREDINSTANCE);
    }

    public boolean isITransientDeferredInstance(Type type) {
        assert (type != null);
        return type.getName().equals(this.INTERFACE_ITRANSIENTDEFERREDINSTANCE);
    }

    public boolean isInstanceGenerator(Type type) {
        assert (type != null);
        return this.isIFactory(type) || this.isIDeferredInstance(type);
    }

    public boolean isRepeater(Type type) {
        assert (type != null);
        return type.isAssignableTo(this.CLASS_REPEATER);
    }

    public boolean isState(String cls) {
        return this.CLASS_STATE.equals(cls);
    }

    public boolean isRepeater(String cls) {
        return this.CLASS_REPEATER.equals(cls);
    }

    public final String getXmlBackingClassName(boolean e4x) {
        return e4x ? CLASS_XML : CLASS_XMLNODE;
    }

    public final boolean isIUIComponentWithIdProperty(Type type) {
        assert (type.getTypeTable().getType(this.INTERFACE_IDEFERREDINSTANTIATIONUICOMPONENT) != null == (type.getTypeTable().getType(this.INTERFACE_IUICOMPONENT) != null)) : "interface " + this.INTERFACE_IDEFERREDINSTANTIATIONUICOMPONENT + " not found in core framework interface set";
        return type.isAssignableTo(this.INTERFACE_IDEFERREDINSTANTIATIONUICOMPONENT);
    }

    static {
        int i;
        PACKAGE_FLASH_UTILS = "flash.utils".intern();
        PACKAGE_MX_BINDING = "mx.binding".intern();
        PACKAGE_MX_CORE = "mx.core".intern();
        PACKAGE_MX_STATES = "mx.states".intern();
        PACKAGE_MX_STYLES = "mx.styles".intern();
        PACKAGE_MX_UTILS = "mx.utils".intern();
        NAMESPACE_MX_INTERNAL_LOCALNAME = "mx_internal".intern();
        CLASS_APPLICATION = NameFormatter.toColon(PACKAGE_MX_CORE, "Application");
        CLASS_VECTOR = NameFormatter.toDot(PACKAGE___AS3___VEC, "Vector");
        CLASS_XMLNODE = NameFormatter.toColon(PACKAGE_FLASH_XML, "XMLNode");
        CLASS_SPARK_APPLICATION = NameFormatter.toColon(PACKAGE_SPARK_COMPONENTS, "Application");
        CLASS_SPARK_SPRITEVISUALELEMENT = NameFormatter.toColon(PACKAGE_SPARK_CORE, "SpriteVisualElement");
        CLASS_TEXT_DIV = NameFormatter.toColon(PACKAGE_TEXT_ELEMENTS, "DivElement");
        CLASS_TEXT_FORMAT = NameFormatter.toColon(PACKAGE_TEXT_FORMATS, "TextLayoutFormat");
        CLASS_TEXT_IMG = NameFormatter.toColon(PACKAGE_TEXT_ELEMENTS, "InlineGraphicElement");
        CLASS_TEXT_LINK = NameFormatter.toColon(PACKAGE_TEXT_ELEMENTS, "LinkElement");
        CLASS_TEXT_LINK_ACTIVE_FORMAT = NameFormatter.toColon(PACKAGE_TEXT_ELEMENTS, "LinkActiveFormat");
        CLASS_TEXT_LINK_HOVER_FORMAT = NameFormatter.toColon(PACKAGE_TEXT_ELEMENTS, "LinkHoverFormat");
        CLASS_TEXT_LINK_NORMAL_FORMAT = NameFormatter.toColon(PACKAGE_TEXT_ELEMENTS, "LinkNormalFormat");
        CLASS_TEXT_RICHTEXT = NameFormatter.toColon(PACKAGE_SPARK_COMPONENTS, "RichText");
        CLASS_TEXT_PARAGRAPH = NameFormatter.toColon(PACKAGE_TEXT_ELEMENTS, "ParagraphElement");
        CLASS_TEXT_SPAN = NameFormatter.toColon(PACKAGE_TEXT_ELEMENTS, "SpanElement");
        CLASS_TEXT_TAB = NameFormatter.toColon(PACKAGE_TEXT_ELEMENTS, "TabElement");
        CLASS_TEXT_TCY = NameFormatter.toColon(PACKAGE_TEXT_ELEMENTS, "TCYElement");
        PROP_CONTAINER_CHILDREPEATERS = "childRepeaters".intern();
        DefaultAS3Metadata = new String[]{MD_BINDABLE, MD_MANAGED, MD_CHANGEEVENT, MD_NONCOMMITTINGCHANGEEVENT, MD_TRANSIENT};
        implicitImports = new HashSet<String>();
        implicitImports.add(NameFormatter.toDotStar(PACKAGE_FLASH_ACCESSIBILITY));
        implicitImports.add(NameFormatter.toDotStar(PACKAGE_FLASH_DEBUGGER));
        implicitImports.add(NameFormatter.toDotStar(PACKAGE_FLASH_DISPLAY));
        implicitImports.add(NameFormatter.toDotStar(PACKAGE_FLASH_ERRORS));
        implicitImports.add(NameFormatter.toDotStar(PACKAGE_FLASH_EVENTS));
        implicitImports.add(NameFormatter.toDotStar(PACKAGE_FLASH_EXTERNAL));
        implicitImports.add(NameFormatter.toDotStar(PACKAGE_FLASH_FILTERS));
        implicitImports.add(NameFormatter.toDotStar(PACKAGE_FLASH_GEOM));
        implicitImports.add(NameFormatter.toDotStar(PACKAGE_FLASH_MEDIA));
        implicitImports.add(NameFormatter.toDotStar(PACKAGE_FLASH_NET));
        implicitImports.add(NameFormatter.toDotStar(PACKAGE_FLASH_PRINTING));
        implicitImports.add(NameFormatter.toDotStar(PACKAGE_FLASH_PROFILER));
        implicitImports.add(NameFormatter.toDotStar(PACKAGE_FLASH_SYSTEM));
        implicitImports.add(NameFormatter.toDotStar(PACKAGE_FLASH_TEXT));
        implicitImports.add(NameFormatter.toDotStar(PACKAGE_FLASH_UI));
        implicitImports.add(NameFormatter.toDotStar(PACKAGE_FLASH_UTILS));
        implicitImports.add(NameFormatter.toDotStar(PACKAGE_FLASH_XML));
        splitPackageMxFilters = NameFormatter.toDotStar(PACKAGE_MX_FILTERS).split("\\.");
        for (int i2 = 0; i2 < splitPackageMxFilters.length; ++i2) {
            StandardDefs.splitPackageMxFilters[i2] = splitPackageMxFilters[i2].intern();
        }
        splitImplicitImports = new HashMap<String, String[]>();
        for (String implicitImport : implicitImports) {
            String[] splitImplicitImport = implicitImport.split("\\.");
            for (i = 0; i < splitImplicitImport.length; ++i) {
                splitImplicitImport[i] = splitImplicitImport[i].intern();
            }
            splitImplicitImports.put(implicitImport, splitImplicitImport);
        }
        airOnlyImplicitImports = new HashSet<String>();
        airOnlyImplicitImports.add(NameFormatter.toDotStar(PACKAGE_FLASH_DATA));
        airOnlyImplicitImports.add(NameFormatter.toDotStar(PACKAGE_FLASH_DESKTOP));
        airOnlyImplicitImports.add(NameFormatter.toDotStar(PACKAGE_FLASH_FILESYSTEM));
        airOnlyImplicitImports.add(NameFormatter.toDotStar(PACKAGE_FLASH_HTML));
        airOnlyImplicitImports.add(NameFormatter.toDotStar(PACKAGE_FLASH_HTML_SCRIPT));
        splitAirOnlyImplicitImports = new HashMap<String, String[]>();
        for (String airOnlyImplicitImport : airOnlyImplicitImports) {
            String[] splitAirOnlyImplicitImport = airOnlyImplicitImport.split("\\.");
            for (i = 0; i < splitAirOnlyImplicitImport.length; ++i) {
                splitAirOnlyImplicitImport[i] = splitAirOnlyImplicitImport[i].intern();
            }
            splitAirOnlyImplicitImports.put(airOnlyImplicitImport, splitAirOnlyImplicitImport);
        }
        as3ReservedWords = new HashSet<String>();
        as3ReservedWords.add("as");
        as3ReservedWords.add("break");
        as3ReservedWords.add("case");
        as3ReservedWords.add("catch");
        as3ReservedWords.add("class");
        as3ReservedWords.add("continue");
        as3ReservedWords.add("default");
        as3ReservedWords.add("do");
        as3ReservedWords.add("else");
        as3ReservedWords.add("extends");
        as3ReservedWords.add("false");
        as3ReservedWords.add("final");
        as3ReservedWords.add("finally");
        as3ReservedWords.add("for");
        as3ReservedWords.add("function");
        as3ReservedWords.add("goto");
        as3ReservedWords.add("if");
        as3ReservedWords.add("implements");
        as3ReservedWords.add("import");
        as3ReservedWords.add("in");
        as3ReservedWords.add("include");
        as3ReservedWords.add("instanceof");
        as3ReservedWords.add("interface");
        as3ReservedWords.add("is");
        as3ReservedWords.add("namespace");
        as3ReservedWords.add("new");
        as3ReservedWords.add(NULL);
        as3ReservedWords.add("package");
        as3ReservedWords.add("private");
        as3ReservedWords.add("protected");
        as3ReservedWords.add("public");
        as3ReservedWords.add("return");
        as3ReservedWords.add("static");
        as3ReservedWords.add("super");
        as3ReservedWords.add("switch");
        as3ReservedWords.add("synchronized");
        as3ReservedWords.add("this");
        as3ReservedWords.add("throw");
        as3ReservedWords.add("transient");
        as3ReservedWords.add("true");
        as3ReservedWords.add("try");
        as3ReservedWords.add("typeof");
        as3ReservedWords.add("use");
        as3ReservedWords.add("var");
        as3ReservedWords.add("void");
        as3ReservedWords.add("volatile");
        as3ReservedWords.add("while");
        as3ReservedWords.add("with");
        as3BuiltInTypeNames = new HashSet<String>();
        as3BuiltInTypeNames.add("String");
        as3BuiltInTypeNames.add("Boolean");
        as3BuiltInTypeNames.add("Number");
        as3BuiltInTypeNames.add("int");
        as3BuiltInTypeNames.add("uint");
        as3BuiltInTypeNames.add("Function");
        as3BuiltInTypeNames.add("Class");
        as3BuiltInTypeNames.add(CLASS_ARRAY);
        as3BuiltInTypeNames.add("Object");
        as3BuiltInTypeNames.add(CLASS_XML);
        as3BuiltInTypeNames.add(CLASS_XMLLIST);
        as3BuiltInTypeNames.add("RegExp");
        as3BuiltInTypeNames.add(CLASS_VECTOR);
        stageProperties = new HashSet<String>();
        stageProperties.add("colorCorrection");
        compatTagMappings = new HashMap<Class, String>();
        compatTagMappings.put(OperationNode.class, "WebServiceOperation");
        compatTagMappings.put(MethodNode.class, "RemoteObjectOperation");
    }

    public static class StandardDefs2006
    extends StandardDefs {
        private static final String BINDABLE_PROPERTY_TEMPLATE = "BindableProperty.vm";
        private static final String CLASSDEF_TEMPLATE = "ClassDef.vm";
        private static final String CLASSDEF_LIB_TEMPLATE = "ClassDefLib.vm";
        private static final String EMBED_CLASS_TEMPLATE = "EmbedClass.vm";
        private static final String FONTFACERULES_TEMPLATE = "FontFaceRules.vm";
        private static final String INTERFACE_DEF_TEMPLATE = "InterfaceDef.vm";
        private static final String MANAGED_PROPERTY_TEMPLATE = "ManagedProperty.vm";
        private static final String SKINCLASS_TEMPLATE = "SkinClass.vm";
        private static final String STYLEDEF_TEMPLATE = "StyleDef.vm";
        private static final String STYLE_LIBRARY_TEMPLATE = "StyleLibrary.vm";
        private static final String STYLE_MODULE_TEMPLATE = "StyleModule.vm";
        private static final String WATCHER_SETUP_UTIL_TEMPLATE = "WatcherSetupUtil.vm";

        private StandardDefs2006() {
        }

        public String getBindingPackage() {
            return PACKAGE_MX_BINDING;
        }

        public String getContainerPackage() {
            return StandardDefs.PACKAGE_MX_CONTAINERS;
        }

        public String getCorePackage() {
            return PACKAGE_MX_CORE;
        }

        public String getControlsPackage() {
            return StandardDefs.PACKAGE_MX_CONTROLS;
        }

        public String getDataPackage() {
            return StandardDefs.PACKAGE_MX_DATA;
        }

        public String getDataUtilsPackage() {
            return StandardDefs.PACKAGE_MX_DATA_UTILS;
        }

        public String getEffectsPackage() {
            return StandardDefs.PACKAGE_MX_EFFECTS;
        }

        public String getEventsPackage() {
            return StandardDefs.PACKAGE_MX_EVENTS;
        }

        public String getManagersPackage() {
            return StandardDefs.PACKAGE_MX_MANAGERS;
        }

        public String getMessagingConfigPackage() {
            return StandardDefs.PACKAGE_MX_MESSAGING_CONFIG;
        }

        public String getModulesPackage() {
            return StandardDefs.PACKAGE_MX_MODULES;
        }

        public String getPreloadersPackage() {
            return StandardDefs.PACKAGE_MX_PRELOADERS;
        }

        public String getResourcesPackage() {
            return StandardDefs.PACKAGE_MX_RESOURCES;
        }

        public String getRPCPackage() {
            return StandardDefs.PACKAGE_MX_RPC;
        }

        public String getRPCXMLPackage() {
            return StandardDefs.PACKAGE_MX_RPC_XML;
        }

        public String getStatesPackage() {
            return PACKAGE_MX_STATES;
        }

        public String getStylesPackage() {
            return PACKAGE_MX_STYLES;
        }

        public String getUtilsPackage() {
            return PACKAGE_MX_UTILS;
        }

        public String getBindablePropertyTemplate() {
            return BINDABLE_PROPERTY_TEMPLATE;
        }

        public String getClassDefTemplate() {
            return CLASSDEF_TEMPLATE;
        }

        public String getClassDefLibTemplate() {
            return CLASSDEF_LIB_TEMPLATE;
        }

        public String getEmbedClassTemplate() {
            return EMBED_CLASS_TEMPLATE;
        }

        public String getFontFaceRulesTemplate() {
            return FONTFACERULES_TEMPLATE;
        }

        public String getInterfaceDefTemplate() {
            return INTERFACE_DEF_TEMPLATE;
        }

        public String getManagedPropertyTemplate() {
            return MANAGED_PROPERTY_TEMPLATE;
        }

        public String getSkinClassTemplate() {
            return SKINCLASS_TEMPLATE;
        }

        public String getStyleDefTemplate() {
            return STYLEDEF_TEMPLATE;
        }

        public String getStyleLibraryTemplate() {
            return STYLE_LIBRARY_TEMPLATE;
        }

        public String getStyleModuleTemplate() {
            return STYLE_MODULE_TEMPLATE;
        }

        public String getWatcherSetupUtilTemplate() {
            return WATCHER_SETUP_UTIL_TEMPLATE;
        }
    }
}

