/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml;

import flex2.compiler.AbstractSubCompiler;
import flex2.compiler.CompilationUnit;
import flex2.compiler.CompilerBenchmarkHelper;
import flex2.compiler.CompilerContext;
import flex2.compiler.Logger;
import flex2.compiler.Source;
import flex2.compiler.SymbolTable;
import flex2.compiler.Transcoder;
import flex2.compiler.as3.As3Compiler;
import flex2.compiler.as3.As3Configuration;
import flex2.compiler.as3.BytecodeEmitter;
import flex2.compiler.as3.EmbedExtension;
import flex2.compiler.as3.HostComponentExtension;
import flex2.compiler.as3.SignatureExtension;
import flex2.compiler.as3.SkinPartExtension;
import flex2.compiler.as3.StyleExtension;
import flex2.compiler.as3.binding.BindableExtension;
import flex2.compiler.as3.binding.DataBindingExtension;
import flex2.compiler.as3.managed.ManagedExtensionError;
import flex2.compiler.common.CompilerConfiguration;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.TextFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.mxml.AbstractSyntaxTreeLogAdapter;
import flex2.compiler.mxml.ImplementationGenerator;
import flex2.compiler.mxml.MxmlCompiler;
import flex2.compiler.mxml.MxmlConfiguration;
import flex2.compiler.mxml.MxmlLogAdapter;
import flex2.compiler.mxml.SourceCodeBuffer;
import flex2.compiler.mxml.builder.DocumentBuilder;
import flex2.compiler.mxml.dom.AnalyzerAdapter;
import flex2.compiler.mxml.dom.DocumentNode;
import flex2.compiler.mxml.dom.Node;
import flex2.compiler.mxml.gen.VelocityUtil;
import flex2.compiler.mxml.lang.StandardDefs;
import flex2.compiler.mxml.reflect.TypeTable;
import flex2.compiler.mxml.rep.DocumentInfo;
import flex2.compiler.mxml.rep.MxmlDocument;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.DualModeLineNumberMap;
import flex2.compiler.util.LineNumberMap;
import flex2.compiler.util.NameMappings;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.compiler.util.VelocityException;
import flex2.compiler.util.VelocityManager;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.asc.util.ContextStatics;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

class ImplementationCompiler
extends AbstractSubCompiler {
    private static final String DOC_KEY = "doc";
    private static final String COMMENTS_KEY = "processcomment";
    private static final String CLASSDEF_TEMPLATE_PATH = "flex2/compiler/mxml/gen/";
    private static final String EMPTY_STRING = "";
    private boolean processComments = false;
    private As3Configuration ascConfiguration;
    private MxmlConfiguration mxmlConfiguration;
    private boolean generateDocComments;
    private NameMappings nameMappings;
    private String[] mimeTypes;
    private As3Compiler asc;

    public ImplementationCompiler(MxmlConfiguration mxmlConfiguration, As3Configuration ascConfiguration, NameMappings mappings, Transcoder[] transcoders, boolean processComments) {
        this.mxmlConfiguration = mxmlConfiguration;
        this.ascConfiguration = ascConfiguration;
        this.nameMappings = mappings;
        this.processComments = processComments;
        this.mimeTypes = new String[]{"text/mxml"};
        this.generateDocComments = ascConfiguration.doc();
        this.asc = new As3Compiler(ascConfiguration);
        if (ascConfiguration instanceof CompilerConfiguration && !((CompilerConfiguration)ascConfiguration).getDisableIncrementalOptimizations()) {
            this.asc.addCompilerExtension(SignatureExtension.getInstance());
        }
        String gendir = mxmlConfiguration.keepGeneratedActionScript() ? mxmlConfiguration.getGeneratedDirectory() : null;
        this.asc.addCompilerExtension(new EmbedExtension(transcoders, gendir, mxmlConfiguration.showDeprecationWarnings()));
        this.asc.addCompilerExtension(new StyleExtension());
        this.asc.addCompilerExtension(new HostComponentExtension());
        this.asc.addCompilerExtension(new SkinPartExtension());
        if (!processComments) {
            this.asc.addCompilerExtension(new BindableExtension(gendir, mxmlConfiguration.getGenerateAbstractSyntaxTree(), false));
        }
        this.asc.addCompilerExtension(new DataBindingExtension(gendir, mxmlConfiguration.showBindingWarnings(), mxmlConfiguration.getGenerateAbstractSyntaxTree(), ascConfiguration.getDefine()));
        this.asc.addCompilerExtension(new ManagedExtensionError());
    }

    As3Compiler getASCompiler() {
        return this.asc;
    }

    public boolean isSupported(String mimeType) {
        for (int i = 0; i < this.mimeTypes.length; ++i) {
            if (!this.mimeTypes[i].equals(mimeType)) continue;
            return true;
        }
        return false;
    }

    public String[] getSupportedMimeTypes() {
        return this.mimeTypes;
    }

    public Source preprocess(Source source) {
        return source;
    }

    public CompilationUnit parse1(Source source, SymbolTable symbolTable) {
        CompilationUnit ascUnit;
        CompilationUnit unit = source.getCompilationUnit();
        TypeTable typeTable = (TypeTable)symbolTable.getContext().getAttribute(MxmlCompiler.TYPE_TABLE);
        if (typeTable == null) {
            typeTable = new TypeTable(symbolTable, this.nameMappings, unit.getStandardDefs());
            symbolTable.getContext().setAttribute(MxmlCompiler.TYPE_TABLE, typeTable);
        }
        if (this.hasUnresolvedNodes(unit)) {
            return null;
        }
        DocumentNode app = (DocumentNode)unit.getSyntaxTree();
        assert (app != null);
        DocumentInfo info = (DocumentInfo)unit.getContext().removeAttribute("DocumentInfo");
        assert (info != null);
        MxmlDocument document = new MxmlDocument(unit, typeTable, info, this.mxmlConfiguration);
        DocumentBuilder builder = new DocumentBuilder(unit, typeTable, this.mxmlConfiguration, document);
        app.analyze(builder);
        if (ThreadLocalToolkit.errorCount() > 0) {
            return null;
        }
        Logger original = ThreadLocalToolkit.getLogger();
        if (this.mxmlConfiguration.getGenerateAbstractSyntaxTree()) {
            AbstractSyntaxTreeLogAdapter adapter = new AbstractSyntaxTreeLogAdapter(original);
            ThreadLocalToolkit.setLogger(adapter);
            Source genSource = this.generateImplementationAST(document, symbolTable.perCompileData, symbolTable.emitter);
            document.getStylesContainer().setMxmlDocument(null);
            document = null;
            unit.setSyntaxTree(null);
            ascUnit = this.asc.parse1(genSource, symbolTable);
            if (ThreadLocalToolkit.errorCount() > 0) {
                return null;
            }
        } else {
            VirtualFile genFile = this.generateImplementation(document);
            DualModeLineNumberMap lineMap = document.getLineNumberMap();
            if (genFile == null || ThreadLocalToolkit.errorCount() != 0) {
                return null;
            }
            Source genSource = new Source(genFile, source);
            genSource.addFileIncludes(source);
            MxmlLogAdapter adapter = new MxmlLogAdapter(original, lineMap);
            ThreadLocalToolkit.setLogger(adapter);
            document.getStylesContainer().setMxmlDocument(null);
            document = null;
            unit.setSyntaxTree(null);
            ascUnit = this.asc.parse1(genSource, symbolTable);
            if (ThreadLocalToolkit.errorCount() > 0) {
                ThreadLocalToolkit.setLogger(original);
                return null;
            }
            unit.getContext().setAttribute("LineNumberMap", lineMap);
            ascUnit.getContext().setAttribute("LineNumberMap", lineMap);
        }
        ThreadLocalToolkit.setLogger(original);
        unit.getContext().setAttribute("DelegateUnit", ascUnit);
        List bindingExpressions = (List)unit.getContext().getAttribute("BindingExpressions");
        ascUnit.getContext().setAttribute("BindingExpressions", bindingExpressions);
        unit.getSource().addFileIncludes(ascUnit.getSource());
        Source.transferMetaData(ascUnit, unit);
        Source.transferGeneratedSources(ascUnit, unit);
        Source.transferDefinitions(ascUnit, unit);
        Source.transferInheritance(ascUnit, unit);
        return unit;
    }

    public void parse2(CompilationUnit unit, SymbolTable symbolTable) {
        CompilationUnit ascUnit = (CompilationUnit)unit.getContext().getAttribute("DelegateUnit");
        Source.transferInheritance(unit, ascUnit);
        Logger original = this.setLogAdapter(unit);
        this.asc.parse2(ascUnit, symbolTable);
        ThreadLocalToolkit.setLogger(original);
        Source.transferAssets(ascUnit, unit);
        Source.transferGeneratedSources(ascUnit, unit);
    }

    public void analyze1(CompilationUnit unit, SymbolTable symbolTable) {
        CompilationUnit ascUnit = (CompilationUnit)unit.getContext().getAttribute("DelegateUnit");
        Logger original = this.setLogAdapter(unit);
        this.asc.analyze1(ascUnit, symbolTable);
        ThreadLocalToolkit.setLogger(original);
        Source.transferTypeInfo(ascUnit, unit);
        Source.transferNamespaces(ascUnit, unit);
    }

    public void analyze2(CompilationUnit unit, SymbolTable symbolTable) {
        CompilationUnit ascUnit = (CompilationUnit)unit.getContext().getAttribute("DelegateUnit");
        Source.transferDependencies(unit, ascUnit);
        Logger original = this.setLogAdapter(unit);
        this.asc.analyze2(ascUnit, symbolTable);
        ThreadLocalToolkit.setLogger(original);
        Source.transferDependencies(ascUnit, unit);
    }

    public void analyze3(CompilationUnit unit, SymbolTable symbolTable) {
        CompilationUnit ascUnit = (CompilationUnit)unit.getContext().getAttribute("DelegateUnit");
        Source.transferDependencies(unit, ascUnit);
        Logger original = this.setLogAdapter(unit);
        this.asc.analyze3(ascUnit, symbolTable);
        ThreadLocalToolkit.setLogger(original);
    }

    public void analyze4(CompilationUnit unit, SymbolTable symbolTable) {
        CompilationUnit ascUnit = (CompilationUnit)unit.getContext().getAttribute("DelegateUnit");
        Logger original = ThreadLocalToolkit.getLogger();
        if (this.mxmlConfiguration.getGenerateAbstractSyntaxTree()) {
            AbstractSyntaxTreeLogAdapter adapter = new AbstractSyntaxTreeLogAdapter(original);
            ThreadLocalToolkit.setLogger(adapter);
        } else {
            LineNumberMap map = (LineNumberMap)unit.getContext().getAttribute("LineNumberMap");
            MxmlLogAdapter adapter = new MxmlLogAdapter(original, map);
            adapter.setRenamedVariableMap((Map)ascUnit.getContext().getAttribute("RenamedVariableMap"));
            ThreadLocalToolkit.setLogger(adapter);
        }
        this.asc.analyze4(ascUnit, symbolTable);
        if (ThreadLocalToolkit.errorCount() > 0) {
            ThreadLocalToolkit.setLogger(original);
            return;
        }
        ThreadLocalToolkit.setLogger(original);
        Source.transferExpressions(ascUnit, unit);
        Source.transferMetaData(ascUnit, unit);
        Source.transferLoaderClassBase(ascUnit, unit);
        Source.transferClassTable(ascUnit, unit);
        Source.transferStyles(ascUnit, unit);
    }

    public void generate(CompilationUnit unit, SymbolTable symbolTable) {
        CompilationUnit ascUnit = (CompilationUnit)unit.getContext().getAttribute("DelegateUnit");
        Logger original = ThreadLocalToolkit.getLogger();
        if (this.mxmlConfiguration.getGenerateAbstractSyntaxTree()) {
            AbstractSyntaxTreeLogAdapter adapter = new AbstractSyntaxTreeLogAdapter(original);
            ThreadLocalToolkit.setLogger(adapter);
        } else {
            LineNumberMap lineNumberMap = (LineNumberMap)unit.getContext().getAttribute("LineNumberMap");
            if (lineNumberMap instanceof DualModeLineNumberMap) {
                ((DualModeLineNumberMap)lineNumberMap).flushTemp();
            }
            MxmlLogAdapter adapter = new MxmlLogAdapter(original, lineNumberMap);
            ThreadLocalToolkit.setLogger(adapter);
        }
        this.asc.generate(ascUnit, symbolTable);
        if (ThreadLocalToolkit.errorCount() > 0) {
            ThreadLocalToolkit.setLogger(original);
            return;
        }
        ThreadLocalToolkit.setLogger(original);
        Source.transferGeneratedSources(ascUnit, unit);
        Source.transferBytecodes(ascUnit, unit);
    }

    public void postprocess(CompilationUnit unit, SymbolTable symbolTable) {
    }

    private boolean hasUnresolvedNodes(CompilationUnit unit) {
        Set checkNodes = (Set)unit.getContext().removeAttribute("CheckNodes");
        if (checkNodes != null && !checkNodes.isEmpty()) {
            for (Node node : checkNodes) {
                ThreadLocalToolkit.log((CompilerMessage)new AnalyzerAdapter.CouldNotResolveToComponent(node.image), unit.getSource());
            }
        }
        return ThreadLocalToolkit.errorCount() > 0;
    }

    private final VirtualFile generateImplementation(MxmlDocument doc) {
        String classDefLibTemplate;
        StandardDefs standardDefs = doc.getStandardDefs();
        String classDefTemplate = CLASSDEF_TEMPLATE_PATH + standardDefs.getClassDefTemplate();
        Template template = VelocityManager.getTemplate(classDefTemplate, classDefLibTemplate = CLASSDEF_TEMPLATE_PATH + standardDefs.getClassDefLibTemplate());
        if (template == null) {
            ThreadLocalToolkit.log(new UnableToLoadTemplate(classDefTemplate));
            return null;
        }
        String genFileName = MxmlCompiler.getGeneratedName(this.mxmlConfiguration, doc.getPackageName(), doc.getClassName(), "-generated.as");
        Source source = doc.getCompilationUnit().getSource();
        SourceCodeBuffer out = new SourceCodeBuffer((int)(source.size() * 4L));
        try {
            DualModeLineNumberMap lineMap = new DualModeLineNumberMap(source.getNameForReporting(), genFileName);
            doc.setLineNumberMap(lineMap);
            VelocityUtil util = new VelocityUtil(CLASSDEF_TEMPLATE_PATH, this.mxmlConfiguration.debug(), out, lineMap);
            VelocityContext vc = VelocityManager.getCodeGenContext(util);
            vc.put(DOC_KEY, (Object)doc);
            vc.put(COMMENTS_KEY, (Object)this.processComments);
            template.merge((Context)vc, (Writer)out);
        }
        catch (Exception e) {
            ThreadLocalToolkit.log(new CodeGenerationException(doc.getSourcePath(), e.getLocalizedMessage()));
            return null;
        }
        if (out.getBuffer() != null) {
            String code = out.toString();
            if (this.mxmlConfiguration.keepGeneratedActionScript()) {
                try {
                    FileUtil.writeFile(genFileName, code);
                }
                catch (IOException e) {
                    ThreadLocalToolkit.log(new VelocityException.UnableToWriteGeneratedFile(genFileName, e.getLocalizedMessage()));
                }
            }
            return new TextFile(code, genFileName, doc.getCompilationUnit().getSource().getParent(), "text/as", doc.getCompilationUnit().getSource().getLastModified());
        }
        return null;
    }

    private Source generateImplementationAST(MxmlDocument mxmlDocument, ContextStatics contextStatics, BytecodeEmitter bytecodeEmitter) {
        String genFileName = MxmlCompiler.getGeneratedName(this.mxmlConfiguration, mxmlDocument.getPackageName(), mxmlDocument.getClassName(), "-generated.as");
        Source source = mxmlDocument.getCompilationUnit().getSource();
        TextFile emptyFile = new TextFile(EMPTY_STRING, genFileName, source.getParent(), "text/as", System.currentTimeMillis());
        Source result = new Source(emptyFile, source);
        ImplementationGenerator implementationGenerator = new ImplementationGenerator(mxmlDocument, this.generateDocComments, contextStatics, result, bytecodeEmitter, this.ascConfiguration.getDefine(), this.processComments);
        CompilerContext context = new CompilerContext();
        context.setAscContext(implementationGenerator.getContext());
        Object syntaxTree = implementationGenerator.getSyntaxTree();
        result.newCompilationUnit(syntaxTree, context).setSyntaxTree(syntaxTree);
        return result;
    }

    public String getName() {
        assert (false);
        return null;
    }

    public void setHelper(CompilerBenchmarkHelper helper, boolean isEmb) {
        assert (isEmb);
        this.asc.setHelper(helper, false);
    }

    private Logger setLogAdapter(CompilationUnit unit) {
        Logger original = ThreadLocalToolkit.getLogger();
        if (this.mxmlConfiguration.getGenerateAbstractSyntaxTree()) {
            AbstractSyntaxTreeLogAdapter adapter = new AbstractSyntaxTreeLogAdapter(original);
            ThreadLocalToolkit.setLogger(adapter);
        } else {
            LineNumberMap map = (LineNumberMap)unit.getContext().getAttribute("LineNumberMap");
            MxmlLogAdapter adapter = new MxmlLogAdapter(original, map);
            ThreadLocalToolkit.setLogger(adapter);
        }
        return original;
    }

    public static class CodeGenerationException
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -5873407973653883428L;
        public final String template;
        public final String message;

        public CodeGenerationException(String template, String message) {
            this.template = template;
            this.message = message;
        }
    }

    public static class UnableToLoadTemplate
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 4986512756206073031L;
        public String template;

        public UnableToLoadTemplate(String template) {
            this.template = template;
            this.noPath();
        }
    }
}

