/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.common;

import flex2.compiler.common.SinglePathResolver;
import flex2.compiler.io.VirtualFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PathResolver
implements SinglePathResolver {
    private List<SinglePathResolver> bases;

    public VirtualFile resolve(String pathStr) {
        return this.resolve((SinglePathResolver)null, pathStr);
    }

    public VirtualFile resolve(SinglePathResolver resolver, String pathStr) {
        if (pathStr == null) {
            return null;
        }
        VirtualFile virt = null;
        if (resolver != null) {
            virt = resolver.resolve(pathStr);
        }
        if (virt == null) {
            virt = this.checkSinglePathResolvers(virt, pathStr);
        }
        return virt;
    }

    public VirtualFile resolve(SinglePathResolver[] resolvers, String pathStr) {
        if (pathStr == null) {
            return null;
        }
        VirtualFile virt = null;
        if (resolvers != null) {
            SinglePathResolver resolver;
            for (int i = 0; i < resolvers.length && (virt = (resolver = resolvers[i]).resolve(pathStr)) == null; ++i) {
            }
        }
        if (virt == null) {
            virt = this.checkSinglePathResolvers(virt, pathStr);
        }
        return virt;
    }

    public void addSinglePathResolver(SinglePathResolver resolver) {
        int index = 0;
        if (this.bases != null) {
            index = this.bases.size();
        }
        this.addSinglePathResolver(index, resolver);
    }

    public void addSinglePathResolver(int index, SinglePathResolver resolver) {
        assert (resolver != null);
        if (this.bases == null) {
            this.bases = new ArrayList<SinglePathResolver>();
        }
        this.bases.add(index, resolver);
    }

    private VirtualFile checkSinglePathResolvers(VirtualFile virt, String pathStr) {
        block1: {
            SinglePathResolver baseResolver;
            if (this.bases == null) break block1;
            Iterator<SinglePathResolver> iterator = this.bases.iterator();
            while (iterator.hasNext() && (virt = (baseResolver = iterator.next()).resolve(pathStr)) == null) {
            }
        }
        return virt;
    }

    public void removeSinglePathResolver(SinglePathResolver resolver) {
        Iterator<SinglePathResolver> iterator = this.bases.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != resolver) continue;
            iterator.remove();
            return;
        }
    }
}

