/*
 * Decompiled with CFR 0.152.
 */
package flash.css;

import flash.util.Trace;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.ThreadLocalToolkit;
import org.apache.batik.css.parser.CSSLexicalUnit;
import org.w3c.css.sac.LexicalUnit;

public class Descriptor {
    private String name;
    private LexicalUnit value;
    private int lineNumber;
    private String path;

    public Descriptor(String name, LexicalUnit lexicalUnit, String path) {
        this.name = name;
        this.value = lexicalUnit;
        this.path = path;
        if (lexicalUnit instanceof CSSLexicalUnit) {
            this.lineNumber = ((CSSLexicalUnit)lexicalUnit).getLineNumber();
        }
    }

    public static String convertColorName(String color) {
        if (color.length() != 0) {
            switch (color.charAt(0)) {
                case 'B': 
                case 'b': {
                    if (color.equalsIgnoreCase("black")) {
                        return "0x000000";
                    }
                    if (!color.equalsIgnoreCase("blue")) break;
                    return "0x0000FF";
                }
                case 'G': 
                case 'g': {
                    if (color.equalsIgnoreCase("green")) {
                        return "0x008000";
                    }
                    if (!color.equalsIgnoreCase("gray")) break;
                    return "0x808080";
                }
                case 'S': 
                case 's': {
                    if (!color.equalsIgnoreCase("silver")) break;
                    return "0xC0C0C0";
                }
                case 'L': 
                case 'l': {
                    if (!color.equalsIgnoreCase("lime")) break;
                    return "0x00FF00";
                }
                case 'O': 
                case 'o': {
                    if (!color.equalsIgnoreCase("olive")) break;
                    return "0x808000";
                }
                case 'W': 
                case 'w': {
                    if (!color.equalsIgnoreCase("white")) break;
                    return "0xFFFFFF";
                }
                case 'Y': 
                case 'y': {
                    if (!color.equalsIgnoreCase("yellow")) break;
                    return "0xFFFF00";
                }
                case 'M': 
                case 'm': {
                    if (color.equalsIgnoreCase("maroon")) {
                        return "0x800000";
                    }
                    if (!color.equalsIgnoreCase("magenta")) break;
                    return "0xFF00FF";
                }
                case 'N': 
                case 'n': {
                    if (!color.equalsIgnoreCase("navy")) break;
                    return "0x000080";
                }
                case 'R': 
                case 'r': {
                    if (!color.equalsIgnoreCase("red")) break;
                    return "0xFF0000";
                }
                case 'P': 
                case 'p': {
                    if (!color.equalsIgnoreCase("purple")) break;
                    return "0x800080";
                }
                case 'T': 
                case 't': {
                    if (!color.equalsIgnoreCase("teal")) break;
                    return "0x008080";
                }
                case 'F': 
                case 'f': {
                    if (!color.equalsIgnoreCase("fuchsia")) break;
                    return "0xFF00FF";
                }
                case 'A': 
                case 'a': {
                    if (!color.equalsIgnoreCase("aqua")) break;
                    return "0x00FFFF";
                }
                case 'C': 
                case 'c': {
                    if (!color.equalsIgnoreCase("cyan")) break;
                    return "0x00FFFF";
                }
                case 'H': 
                case 'h': {
                    if (color.equalsIgnoreCase("haloGreen")) {
                        return "0x80FF4D";
                    }
                    if (color.equalsIgnoreCase("haloBlue")) {
                        return "0x009DFF";
                    }
                    if (color.equalsIgnoreCase("haloOrange")) {
                        return "0xFFB600";
                    }
                    if (!color.equalsIgnoreCase("haloSilver")) break;
                    return "0xAECAD9";
                }
            }
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public LexicalUnit getValue() {
        return this.value;
    }

    public String getIdentAsString() {
        StringBuilder sb = new StringBuilder();
        for (LexicalUnit lexicalUnit = this.value; lexicalUnit != null; lexicalUnit = lexicalUnit.getNextLexicalUnit()) {
            try {
                switch (lexicalUnit.getLexicalUnitType()) {
                    case 35: {
                        sb.append(lexicalUnit.getStringValue());
                        break;
                    }
                    case 0: {
                        sb.append(',');
                        break;
                    }
                    case 13: {
                        sb.append(lexicalUnit.getIntegerValue());
                        break;
                    }
                    default: {
                        sb.append(lexicalUnit.getStringValue());
                        break;
                    }
                }
                continue;
            }
            catch (IllegalStateException ise) {
                UnparsableCSS unparsableCSS = new UnparsableCSS();
                unparsableCSS.path = this.path;
                unparsableCSS.line = this.lineNumber;
                ThreadLocalToolkit.log(unparsableCSS);
            }
        }
        return sb.toString();
    }

    public String getColorAsString() throws CompilerMessage.CompilerError {
        return Descriptor.getColorAsString(this.name, this.value);
    }

    private static String getColorAsString(String name, LexicalUnit lexicalUnit) throws CompilerMessage.CompilerError {
        String color;
        short type = lexicalUnit.getLexicalUnitType();
        switch (type) {
            case 35: {
                color = Descriptor.convertColorName(lexicalUnit.getStringValue());
                if (color != null) break;
                throw new ColorNotSupported(lexicalUnit.getStringValue());
            }
            case 27: {
                StringBuilder stringBuffer = new StringBuilder("0x");
                block8: for (LexicalUnit parameter = lexicalUnit.getParameters(); parameter != null; parameter = parameter.getNextLexicalUnit()) {
                    switch (parameter.getLexicalUnitType()) {
                        case 13: {
                            int digit = parameter.getIntegerValue();
                            stringBuffer.append(Character.forDigit(digit >> 4 & 0xF, 16));
                            stringBuffer.append(Character.forDigit(digit & 0xF, 16));
                            continue block8;
                        }
                        case 23: {
                            int digit = new Float(parameter.getFloatValue()).intValue() * 255 / 100;
                            stringBuffer.append(Character.forDigit(digit >> 4 & 0xF, 16));
                            stringBuffer.append(Character.forDigit(digit & 0xF, 16));
                        }
                    }
                }
                color = stringBuffer.toString();
                break;
            }
            default: {
                if (Trace.css) {
                    Trace.trace((String)("Descriptor.getColorAsString: type = " + type));
                }
                throw new ValueNotSupported(name);
            }
        }
        return color;
    }

    public String getLengthAsString() throws CompilerMessage.CompilerError {
        return Descriptor.getLengthAsString(this.name, this.value);
    }

    private static String getLengthAsString(String name, LexicalUnit lexicalUnit) throws CompilerMessage.CompilerError {
        float length;
        short type = lexicalUnit.getLexicalUnitType();
        switch (type) {
            case 19: {
                length = lexicalUnit.getFloatValue() * 72.0f / 2.54f;
                break;
            }
            case 20: {
                length = lexicalUnit.getFloatValue() * 72.0f / 10.0f / 2.54f;
                break;
            }
            case 18: {
                length = lexicalUnit.getFloatValue() * 72.0f;
                break;
            }
            case 22: {
                length = lexicalUnit.getFloatValue() * 12.0f;
                break;
            }
            case 17: {
                length = lexicalUnit.getFloatValue();
                break;
            }
            case 21: {
                length = lexicalUnit.getFloatValue();
                break;
            }
            case 35: {
                String absoluteSize = lexicalUnit.getStringValue();
                if (absoluteSize.equalsIgnoreCase("xx-small")) {
                    length = 7.0f;
                    break;
                }
                if (absoluteSize.equalsIgnoreCase("x-small")) {
                    length = 8.0f;
                    break;
                }
                if (absoluteSize.equalsIgnoreCase("small")) {
                    length = 10.0f;
                    break;
                }
                if (absoluteSize.equalsIgnoreCase("medium")) {
                    length = 12.0f;
                    break;
                }
                if (absoluteSize.equalsIgnoreCase("large")) {
                    length = 14.0f;
                    break;
                }
                if (absoluteSize.equalsIgnoreCase("x-large")) {
                    length = 17.0f;
                    break;
                }
                if (absoluteSize.equalsIgnoreCase("xx-large")) {
                    length = 21.0f;
                    break;
                }
                throw new ValueNotSupported(name);
            }
            default: {
                if (Trace.css) {
                    Trace.trace((String)("Descriptor.getLengthAsString: type = " + type));
                }
                throw new ValueNotSupported(name);
            }
        }
        return Integer.toString(new Float(length).intValue());
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    private static String getListAsString(String name, LexicalUnit value) throws CompilerMessage.CompilerError {
        return Descriptor.getListAsString(name, value, true);
    }

    private static String getListAsString(String name, LexicalUnit value, boolean quoteIdentifier) throws CompilerMessage.CompilerError {
        StringBuilder stringBuffer = new StringBuilder();
        LexicalUnit current = value;
        while (current != null) {
            stringBuffer.append(Descriptor.getLexicalUnitAsString(name, current, quoteIdentifier));
            LexicalUnit next = current.getNextLexicalUnit();
            if (next != null) {
                if (next.getLexicalUnitType() == 0) {
                    current = next.getNextLexicalUnit();
                    stringBuffer.append(", ");
                    continue;
                }
                if (next.getLexicalUnitType() == 4) {
                    current = next.getNextLexicalUnit();
                    stringBuffer.append(" = ");
                    continue;
                }
                throw new InvalidFormat();
            }
            current = null;
        }
        return stringBuffer.toString();
    }

    public String getPath() {
        return this.path;
    }

    public String getTimeAsString() throws CompilerMessage.CompilerError {
        return Descriptor.getTimeAsString(this.name, this.value);
    }

    private static String getTimeAsString(String name, LexicalUnit lexicalUnit) throws CompilerMessage.CompilerError {
        float time;
        short type = lexicalUnit.getLexicalUnitType();
        switch (type) {
            case 31: {
                time = lexicalUnit.getFloatValue();
                break;
            }
            case 32: {
                time = lexicalUnit.getFloatValue() * 60.0f;
                break;
            }
            default: {
                if (Trace.css) {
                    Trace.trace((String)("Descriptor.getTimeAsString: type = " + type));
                }
                throw new ValueNotSupported(name);
            }
        }
        return Integer.toString(new Float(time).intValue());
    }

    public String getValueAsString() throws CompilerMessage.CompilerError {
        LexicalUnit next = this.value.getNextLexicalUnit();
        String valueString = next != null && next.getLexicalUnitType() == 0 ? "[" + Descriptor.getListAsString(this.name, this.value) + "]" : Descriptor.getLexicalUnitAsString(this.name, this.value);
        return valueString;
    }

    private static String getLexicalUnitAsString(String name, LexicalUnit lexicalUnit) throws CompilerMessage.CompilerError {
        return Descriptor.getLexicalUnitAsString(name, lexicalUnit, true);
    }

    private static String getLexicalUnitAsString(String name, LexicalUnit lexicalUnit, boolean quoteIdentifier) throws CompilerMessage.CompilerError {
        String result;
        short type = lexicalUnit.getLexicalUnitType();
        switch (type) {
            case 31: 
            case 32: {
                result = Descriptor.getTimeAsString(name, lexicalUnit);
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                result = Descriptor.getLengthAsString(name, lexicalUnit);
                break;
            }
            case 27: {
                result = Descriptor.getColorAsString(name, lexicalUnit);
                break;
            }
            case 13: {
                result = Integer.toString(lexicalUnit.getIntegerValue());
                break;
            }
            case 14: {
                result = Float.toString(lexicalUnit.getFloatValue());
                break;
            }
            case 24: 
            case 36: {
                result = "\"" + lexicalUnit.getStringValue().replace('\"', '\'') + "\"";
                break;
            }
            case 35: {
                try {
                    result = Descriptor.getColorAsString(name, lexicalUnit);
                }
                catch (CompilerMessage.CompilerError compilerError) {
                    try {
                        result = Descriptor.getLengthAsString(name, lexicalUnit);
                    }
                    catch (CompilerMessage.CompilerError compilerError2) {
                        String stringValue = lexicalUnit.getStringValue();
                        if (stringValue.equalsIgnoreCase(Boolean.FALSE.toString()) || stringValue.equalsIgnoreCase(Boolean.TRUE.toString())) {
                            result = stringValue;
                            break;
                        }
                        if (quoteIdentifier) {
                            result = "\"" + stringValue.replace('\"', '\'') + "\"";
                            break;
                        }
                        result = stringValue;
                    }
                }
                break;
            }
            case 41: {
                String functionName = lexicalUnit.getFunctionName();
                if (functionName.equals("Embed") || functionName.equals("ClassReference") || functionName.equals("PropertyReference")) {
                    result = functionName + "(" + Descriptor.getListAsString(null, lexicalUnit.getParameters(), false) + ")";
                    break;
                }
                throw new FunctionNotSupported(functionName);
            }
            default: {
                if (Trace.css) {
                    Trace.trace((String)("Descriptor.getLexicalUnitAsString: type = " + type));
                }
                throw new ValueNotSupported(name);
            }
        }
        return result;
    }

    public static class FunctionNotSupported
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -7607804535214540281L;
        public String function;

        public FunctionNotSupported(String function) {
            this.function = function;
        }
    }

    public static class ValueNotSupported
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 657854378435002555L;
        public String value;

        public ValueNotSupported(String value) {
            this.value = value;
        }
    }

    public static class UnparsableCSS
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -8939846058668804295L;
    }

    public static class InvalidFormat
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 8620593353408269587L;
    }

    public static class ColorNotSupported
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -9167022814274170798L;
        public String color;

        public ColorNotSupported(String color) {
            this.color = color;
        }
    }
}

