/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools;

import flash.css.StyleCondition;
import flash.css.StyleDeclaration;
import flash.css.StyleProperty;
import flash.css.StyleSelector;
import flash.swf.tags.DefineFont;
import flash.swf.tags.DefineTag;
import flash.util.FileUtils;
import flash.util.StringJoiner;
import flash.util.Trace;
import flex.messaging.config.ServicesDependencies;
import flex2.compiler.CompilationUnit;
import flex2.compiler.CompilerSwcContext;
import flex2.compiler.FileSpec;
import flex2.compiler.ResourceBundlePath;
import flex2.compiler.ResourceContainer;
import flex2.compiler.Source;
import flex2.compiler.SourceList;
import flex2.compiler.SourcePath;
import flex2.compiler.SymbolTable;
import flex2.compiler.abc.AbcClass;
import flex2.compiler.common.CompilerConfiguration;
import flex2.compiler.common.Configuration;
import flex2.compiler.common.FramesConfiguration;
import flex2.compiler.css.StyleDef;
import flex2.compiler.css.StylesContainer;
import flex2.compiler.extensions.ExtensionManager;
import flex2.compiler.extensions.IPreLinkExtension;
import flex2.compiler.i18n.I18nUtils;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.TextFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.mxml.lang.StandardDefs;
import flex2.compiler.swc.Digest;
import flex2.compiler.swc.Swc;
import flex2.compiler.swc.SwcScript;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.MimeMappings;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.NameMappings;
import flex2.compiler.util.QName;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.compiler.util.VelocityException;
import flex2.linker.CULinkable;
import flex2.linker.DependencyWalker;
import flex2.linker.LinkerException;
import flex2.tools.CompcConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreLink
implements flex2.compiler.PreLink {
    private static final String DEFAULTS_CSS = "defaults.css";
    private static final String DEFAULTS_DASH = "defaults-";
    private static final String DOT_CSS = ".css";
    private SortedSet<String> resourceBundleNames = new TreeSet<String>();
    private SortedSet<String> externalResourceBundleNames = new TreeSet<String>();

    @Override
    public void run(List<Source> sources, List<CompilationUnit> units, FileSpec fileSpec, SourceList sourceList, SourcePath sourcePath, ResourceBundlePath bundlePath, ResourceContainer resources, SymbolTable symbolTable, CompilerSwcContext swcContext, NameMappings nameMappings, Configuration configuration) {
        Set<IPreLinkExtension> extensions = ExtensionManager.getPreLinkExtensions(configuration.getCompilerConfiguration().getExtensionsConfiguration().getExtensionMappings());
        for (IPreLinkExtension extension : extensions) {
            if (ThreadLocalToolkit.errorCount() != 0) continue;
            extension.run(sources, units, fileSpec, sourceList, sourcePath, bundlePath, resources, symbolTable, swcContext, configuration);
        }
        this.processMainUnit(sources, units, resources, symbolTable, nameMappings, configuration);
    }

    @Override
    public void postRun(List<Source> sources, List<CompilationUnit> units, ResourceContainer resources, CompilerSwcContext swcContext, Configuration configuration) {
        LinkedList<Source> extraSources = new LinkedList<Source>();
        LinkedList<String> mixins = new LinkedList<String>();
        LinkedList<DefineTag> fonts = new LinkedList<DefineTag>();
        this.processResourceBundleNames(units, configuration);
        this.processInitClass(units, configuration, extraSources, mixins, fonts, swcContext);
        boolean generatedLoaderClass = this.processLoaderClass(units, configuration, extraSources, mixins, fonts, swcContext);
        if (!generatedLoaderClass) {
            this.processCompiledResourceBundleInfoClass(units, configuration, extraSources, mixins, fonts, swcContext);
        }
        for (Source extraSource : extraSources) {
            sources.add(resources.addResource(extraSource));
        }
    }

    private void locateStyleDefaults(List<CompilationUnit> units, CompilerConfiguration compilerConfiguration) {
        HashSet<VirtualFile> defaultsCssFiles = new HashSet<VirtualFile>();
        String versionDefaultsCssFileName = null;
        if (compilerConfiguration.getCompatibilityVersionString() != null) {
            versionDefaultsCssFileName = DEFAULTS_DASH + compilerConfiguration.getCompatibilityVersionString() + DOT_CSS;
        }
        int length = units.size();
        for (int i = 0; i < length; ++i) {
            CompilationUnit compilationUnit = units.get(i);
            Source source = compilationUnit.getSource();
            if (!source.isSwcScriptOwner()) continue;
            SwcScript swcScript = (SwcScript)source.getOwner();
            Swc swc = swcScript.getLibrary().getSwc();
            VirtualFile defaultsCssFile = null;
            if (versionDefaultsCssFileName != null) {
                defaultsCssFile = swc.getFile(versionDefaultsCssFileName);
            }
            if (defaultsCssFile == null) {
                defaultsCssFile = swc.getFile(DEFAULTS_CSS);
            }
            if (defaultsCssFile == null) continue;
            defaultsCssFiles.add(defaultsCssFile);
        }
        compilerConfiguration.addDefaultsCssFiles(defaultsCssFiles);
    }

    private void processMainUnit(List<Source> sources, List<CompilationUnit> units, ResourceContainer resources, SymbolTable symbolTable, NameMappings nameMappings, Configuration configuration) {
        CompilationUnit u;
        int i;
        int length = units.size();
        for (i = 0; i < length; ++i) {
            QName qName;
            u = units.get(i);
            if (!u.isRoot()) continue;
            PreLink.swfmetadata(u, configuration);
            if (u.loaderClass != null) {
                configuration.setRootClassName(u.loaderClass);
            }
            if ((qName = u.topLevelDefinitions.last()) != null) {
                String def = qName.toString();
                configuration.setMainDefinition(def);
                u.getContext().setAttribute("mainDefinition", def);
                if (u.loaderClass == null) break;
                CompilerConfiguration compilerConfig = configuration.getCompilerConfiguration();
                this.locateStyleDefaults(units, compilerConfig);
                StylesContainer stylesContainer = new StylesContainer(compilerConfig, u, symbolTable.perCompileData);
                stylesContainer.setNameMappings(nameMappings);
                stylesContainer.loadDefaultStyles();
                StylesContainer localStylesContainer = u.getStylesContainer();
                if (u.swfMetaData == null || u.swfMetaData.getValue("backgroundColor") == null) {
                    PreLink.lookupBackgroundColor(stylesContainer, localStylesContainer, u.styleName, NameFormatter.toDot(def), symbolTable, configuration);
                }
                LinkedList<CULinkable> linkables = new LinkedList<CULinkable>();
                Iterator<CompilationUnit> it2 = units.iterator();
                while (it2.hasNext()) {
                    linkables.add(new CULinkable(it2.next()));
                }
                try {
                    int j;
                    DependencyWalker.LinkState state = new DependencyWalker.LinkState(linkables, new HashSet(), configuration.getIncludes(), new HashSet<String>());
                    List<Source> styleSources = stylesContainer.processDependencies(state.getDefNames(), resources);
                    StylesContainer rootStylesContainer = u.getStylesContainer();
                    if (rootStylesContainer != null) {
                        rootStylesContainer.checkForUnusedTypeSelectors(state.getDefNames());
                    }
                    HashSet<String> sourceSet = new HashSet<String>(sources.size());
                    int size = sources.size();
                    for (j = 0; j < size; ++j) {
                        Source s = sources.get(j);
                        sourceSet.add(s.getName());
                    }
                    size = styleSources.size();
                    for (j = 0; j < size; ++j) {
                        Source styleSrc = styleSources.get(j);
                        if (sourceSet.contains(styleSrc.getName())) continue;
                        sources.add(styleSrc);
                    }
                    break;
                }
                catch (LinkerException e) {
                    ThreadLocalToolkit.log(e);
                    break;
                }
            }
            ThreadLocalToolkit.log((CompilerMessage)new NoExternalVisibleDefinition(), u.getSource());
            break;
        }
        length = units.size();
        for (i = 0; i < length; ++i) {
            u = units.get(i);
            if (!u.isDone()) continue;
            u.setStylesContainer(null);
        }
    }

    private static void lookupBackgroundColor(StylesContainer globalStylesContainer, StylesContainer localStylesContainer, String inlineStyleName, String className, SymbolTable symbolTable, Configuration configuration) {
        AbcClass abcClass;
        assert (NameFormatter.toDot(className).equals(className));
        String styleName = inlineStyleName;
        if (styleName == null && localStylesContainer != null) {
            styleName = PreLink.lookupStyleName(localStylesContainer, className);
        }
        if (styleName == null) {
            styleName = PreLink.lookupStyleName(globalStylesContainer, className);
        }
        int backgroundColor = -1;
        if (styleName != null && localStylesContainer != null) {
            backgroundColor = PreLink.lookupClassSelectorBackgroundColor(localStylesContainer, styleName);
        }
        if (styleName != null && backgroundColor == -1) {
            backgroundColor = PreLink.lookupClassSelectorBackgroundColor(globalStylesContainer, styleName);
        }
        if (backgroundColor == -1 && localStylesContainer != null) {
            backgroundColor = PreLink.lookupTypeSelectorBackgroundColor(localStylesContainer, className);
        }
        if (backgroundColor == -1) {
            backgroundColor = PreLink.lookupTypeSelectorBackgroundColor(globalStylesContainer, className);
        }
        if (backgroundColor == -1 && (abcClass = symbolTable.getClass(NameFormatter.toColon(className))) != null) {
            String superTypeName = abcClass.getSuperTypeName();
            if (superTypeName != null) {
                PreLink.lookupBackgroundColor(globalStylesContainer, localStylesContainer, null, NameFormatter.toDot(superTypeName), symbolTable, configuration);
            } else {
                if (localStylesContainer != null) {
                    backgroundColor = PreLink.lookupTypeSelectorBackgroundColor(localStylesContainer, "global");
                }
                if (backgroundColor == -1) {
                    backgroundColor = PreLink.lookupTypeSelectorBackgroundColor(globalStylesContainer, "global");
                }
            }
        }
        if (backgroundColor != -1) {
            configuration.setBackgroundColor(backgroundColor);
        }
    }

    private static int lookupTypeSelectorBackgroundColor(StylesContainer stylesContainer, String className) {
        Map<String, StyleDeclaration> declarations;
        int result = -1;
        StyleDef styleDef = stylesContainer.getStyleDef(className);
        if (styleDef != null && (declarations = styleDef.getDeclarations()) != null) {
            for (StyleDeclaration styleDeclaration : declarations.values()) {
                Object value;
                StyleProperty styleProperty = styleDeclaration.getProperties().get("backgroundColor");
                if (styleProperty == null || !((value = styleProperty.getValue()) instanceof String)) continue;
                String backgroundColor = (String)value;
                try {
                    result = Integer.decode(backgroundColor);
                }
                catch (NumberFormatException numberFormatException) {
                    ThreadLocalToolkit.log((CompilerMessage)new InvalidBackgroundColor(backgroundColor), styleDeclaration.getPath(), styleProperty.getLineNumber());
                }
            }
        }
        return result;
    }

    private static int lookupClassSelectorBackgroundColor(StylesContainer stylesContainer, String styleName) {
        Map<String, StyleDeclaration> declarations;
        int result = -1;
        StyleDef styleDef = stylesContainer.getStyleDef("global");
        if (styleDef != null && (declarations = styleDef.getDeclarations()) != null) {
            for (StyleDeclaration styleDeclaration : declarations.values()) {
                List<StyleCondition> conditions;
                StyleSelector styleSelector = styleDeclaration.getSelector();
                if (styleSelector == null || (conditions = styleSelector.getConditions()) == null) continue;
                for (StyleCondition styleCondition : conditions) {
                    Object value;
                    StyleProperty styleProperty;
                    if (styleCondition.getKind() != "class" || !styleCondition.getValue().equals(styleName) || (styleProperty = styleDeclaration.getProperties().get("backgroundColor")) == null || !((value = styleProperty.getValue()) instanceof String)) continue;
                    String backgroundColor = (String)value;
                    try {
                        result = Integer.decode(backgroundColor);
                    }
                    catch (NumberFormatException numberFormatException) {
                        ThreadLocalToolkit.log((CompilerMessage)new InvalidBackgroundColor(backgroundColor), styleDeclaration.getPath(), styleProperty.getLineNumber());
                    }
                }
            }
        }
        return result;
    }

    private static String lookupStyleName(StylesContainer stylesContainer, String className) {
        String result = null;
        StyleDef styleDef = stylesContainer.getStyleDef(className);
        if (styleDef != null) {
            for (StyleDeclaration styleDeclaration : styleDef.getDeclarations().values()) {
                Object value;
                StyleProperty styleProperty = styleDeclaration.getProperties().get("styleName");
                if (styleProperty == null || !((value = styleProperty.getValue()) instanceof String)) continue;
                result = (String)value;
            }
        }
        return result;
    }

    private static void swfmetadata(CompilationUnit u, Configuration cfg) {
        if (u.swfMetaData != null) {
            String pageTitle;
            String backgroundColor;
            String frameRate;
            String scriptTimeLimit;
            String scriptRecursionLimit;
            String heightPercent;
            String widthPercent;
            String heightString;
            String widthString = u.swfMetaData.getValue("width");
            if (widthString != null) {
                cfg.setWidth(widthString);
            }
            if ((heightString = u.swfMetaData.getValue("height")) != null) {
                cfg.setHeight(heightString);
            }
            if ((widthPercent = u.swfMetaData.getValue("widthPercent")) != null) {
                cfg.setWidthPercent(widthPercent);
            }
            if ((heightPercent = u.swfMetaData.getValue("heightPercent")) != null) {
                cfg.setHeightPercent(heightPercent);
            }
            if ((scriptRecursionLimit = u.swfMetaData.getValue("scriptRecursionLimit")) != null) {
                try {
                    cfg.setScriptRecursionLimit(Integer.parseInt(scriptRecursionLimit));
                }
                catch (NumberFormatException nfe) {
                    ThreadLocalToolkit.log(new CouldNotParseNumber(scriptRecursionLimit, "scriptRecursionLimit"));
                }
            }
            if ((scriptTimeLimit = u.swfMetaData.getValue("scriptTimeLimit")) != null) {
                try {
                    cfg.setScriptTimeLimit(Integer.parseInt(scriptTimeLimit));
                }
                catch (NumberFormatException nfe) {
                    ThreadLocalToolkit.log(new CouldNotParseNumber(scriptTimeLimit, "scriptTimeLimit"));
                }
            }
            if ((frameRate = u.swfMetaData.getValue("frameRate")) != null) {
                try {
                    cfg.setFrameRate(Integer.parseInt(frameRate));
                }
                catch (NumberFormatException nfe) {
                    ThreadLocalToolkit.log(new CouldNotParseNumber(frameRate, "frameRate"));
                }
            }
            if ((backgroundColor = u.swfMetaData.getValue("backgroundColor")) != null) {
                try {
                    cfg.setBackgroundColor(Integer.decode(backgroundColor));
                }
                catch (NumberFormatException numberFormatException) {
                    ThreadLocalToolkit.log((CompilerMessage)new InvalidBackgroundColor(backgroundColor), u.getSource());
                }
            }
            if ((pageTitle = u.swfMetaData.getValue("pageTitle")) != null) {
                cfg.setPageTitle(pageTitle);
            }
        }
    }

    private void processResourceBundleNames(List units, Configuration configuration) {
        Set<String> externs = configuration.getExterns();
        for (CompilationUnit unit : units) {
            if (unit.resourceBundleHistory.size() <= 0) continue;
            this.resourceBundleNames.addAll(unit.resourceBundleHistory);
            if (!externs.contains(unit.topLevelDefinitions.first().toString())) continue;
            this.externalResourceBundleNames.addAll(unit.resourceBundleHistory);
        }
    }

    private String codegenFlexInit(String flexInitClassName, Set<String> accessibilityList, Map<String, String> remoteClassAliases, Map<String, String> effectTriggers, Set<String> inheritingStyles, Configuration configuration) {
        StandardDefs standardDefs = ThreadLocalToolkit.getStandardDefs();
        CompilerConfiguration compilerConfig = configuration.getCompilerConfiguration();
        ServicesDependencies servicesDependencies = compilerConfig.getServicesDependencies();
        StringBuilder sb = new StringBuilder();
        sb.append("package {\n");
        sb.append("import flash.utils.*;\n");
        sb.append("import ").append(standardDefs.INTERFACE_IFLEXMODULEFACTORY_DOT).append(";\n");
        sb.append("import ").append(standardDefs.CLASS_STYLEMANAGERIMPL_DOT).append(";\n");
        sb.append("import ").append(standardDefs.CLASS_SYSTEMMANAGERCHILDMANAGER_DOT).append(";\n");
        sb.append("import ").append(standardDefs.CLASS_TEXTFIELDFACTORY_DOT).append("; TextFieldFactory;\n");
        sb.append(this.codegenAccessibilityImports(accessibilityList));
        sb.append(this.codegenRemoteClassImports(remoteClassAliases));
        sb.append(this.codegenEffectTriggerImports(effectTriggers, standardDefs));
        if (servicesDependencies != null) {
            sb.append(servicesDependencies.getImports());
        }
        sb.append(PreLink.codegenResourceBundleMetadata(this.externalResourceBundleNames));
        sb.append("\n[Mixin]\n");
        sb.append("public class " + flexInitClassName + "\n");
        sb.append("{\n");
        sb.append("   public function " + flexInitClassName + "()\n");
        sb.append("   {\n");
        sb.append("       super();\n");
        sb.append("   }\n");
        sb.append("   public static function init(fbs:IFlexModuleFactory):void\n");
        sb.append("   {\n");
        sb.append("       new ChildManager(fbs);\n");
        sb.append("       new StyleManagerImpl(fbs);\n");
        sb.append(this.codegenEffectTriggerRegistration(effectTriggers));
        sb.append(this.codegenAccessibilityList(accessibilityList));
        sb.append(this.codegenRemoteClassAliases(remoteClassAliases));
        sb.append(this.codegenInheritingStyleRegistration(inheritingStyles));
        if (servicesDependencies != null) {
            sb.append(servicesDependencies.getServerConfigXmlInit());
        }
        sb.append("   }\n");
        if (servicesDependencies != null) {
            sb.append(servicesDependencies.getReferences());
        }
        sb.append("}  // FlexInit\n");
        sb.append("}  // package\n");
        return sb.toString();
    }

    private void processInitClass(List units, Configuration configuration, List<Source> extraSources, LinkedList<String> mixins, LinkedList<DefineTag> fonts, CompilerSwcContext swcContext) {
        HashSet<String> accessibilityList = null;
        TreeMap<String, String> remoteClassAliases = new TreeMap<String, String>(){
            private static final long serialVersionUID = -8015004853369794727L;

            @Override
            public String put(String key, String value) {
                if (this.containsValue(value)) {
                    Object existingKey = null;
                    for (Map.Entry entry : this.entrySet()) {
                        if (value == null || !value.equals(entry.getValue())) continue;
                        existingKey = entry.getKey();
                        break;
                    }
                    ThreadLocalToolkit.log(new ClassesMappedToSameRemoteAlias(key, existingKey, value));
                }
                return super.put(key, value);
            }
        };
        TreeMap<String, String> effectTriggers = new TreeMap<String, String>();
        HashSet<String> inheritingStyles = new HashSet<String>();
        CompilationUnit mainUnit = null;
        Set<String> externs = swcContext.getExterns();
        int size = units.size();
        for (int i = 0; i < size; ++i) {
            Set<String> unitAccessibilityList;
            List<DefineFont> fontList;
            CompilationUnit u = (CompilationUnit)units.get(i);
            if (u.isRoot()) {
                mainUnit = u;
            }
            if (u.hasAssets() && (fontList = u.getAssets().getFonts()) != null && !fontList.isEmpty() && !PreLink.isCompilationUnitExternal(u, externs) && !u.getSource().isInternal()) {
                fonts.addAll(fontList);
            }
            remoteClassAliases.putAll(u.remoteClassAliases);
            effectTriggers.putAll(u.effectTriggers);
            mixins.addAll(u.mixins);
            inheritingStyles.addAll(u.styles.getInheritingStyles());
            if (!configuration.getCompilerConfiguration().accessible() || (unitAccessibilityList = u.getAccessibilityClasses()) == null) continue;
            if (accessibilityList == null) {
                accessibilityList = new HashSet<String>();
            }
            accessibilityList.addAll(unitAccessibilityList);
        }
        String flexInitClass = null;
        if (mainUnit != null) {
            for (String extraClass : mainUnit.extraClasses) {
                if (extraClass.indexOf("FlexInit") == -1) continue;
                flexInitClass = extraClass;
                break;
            }
        }
        if (flexInitClass != null) {
            String code = this.codegenFlexInit(flexInitClass, accessibilityList, (Map<String, String>)remoteClassAliases, effectTriggers, inheritingStyles, configuration);
            String name = flexInitClass + "-generated.as";
            if (configuration.getCompilerConfiguration().keepGeneratedActionScript()) {
                PreLink.saveGenerated(name, code, configuration.getCompilerConfiguration().getGeneratedDirectory());
            }
            Source s = new Source((VirtualFile)new TextFile(code, name, null, MimeMappings.getMimeType(name)), "", flexInitClass, null, false, false, false);
            s.setPathResolver(null);
            extraSources.add(s);
            mixins.addFirst(flexInitClass);
        }
    }

    public static boolean isCompilationUnitExternal(CompilationUnit unit, Set externs) {
        int size;
        int n = size = unit == null ? 0 : unit.topLevelDefinitions.size();
        for (int i = 0; i < size; ++i) {
            if (!externs.contains(((QName)unit.topLevelDefinitions.get(i)).toString())) continue;
            return true;
        }
        return false;
    }

    private boolean processLoaderClass(List units, Configuration configuration, List<Source> sources, List<String> mixins, List<DefineTag> fonts, CompilerSwcContext swcContext) {
        if (!configuration.generateFrameLoader) {
            return false;
        }
        LinkedList<FramesConfiguration.FrameInfo> frames = new LinkedList<FramesConfiguration.FrameInfo>();
        frames.addAll(configuration.getFrameList());
        CompilationUnit mainUnit = null;
        for (CompilationUnit unit : units) {
            if (!unit.isRoot()) continue;
            mainUnit = unit;
            break;
        }
        if (mainUnit == null) {
            return false;
        }
        String generateLoaderClass = null;
        String baseLoaderClass = null;
        String windowClass = null;
        Map rootAttributes = null;
        List<Configuration.RslPathInfo> cdRsls = configuration.getRslPathInfo();
        List<String> rsls = configuration.getRuntimeSharedLibraries();
        String[] locales = configuration.getCompilerConfiguration().getLocales();
        if (mainUnit.loaderClass != null && mainUnit.auxGenerateInfo != null) {
            Map tmpRootAttributes;
            generateLoaderClass = (String)mainUnit.auxGenerateInfo.get("generateLoaderClass");
            baseLoaderClass = (String)mainUnit.auxGenerateInfo.get("baseLoaderClass");
            windowClass = (String)mainUnit.auxGenerateInfo.get("windowClass");
            rootAttributes = tmpRootAttributes = (Map)mainUnit.auxGenerateInfo.get("rootAttributes");
            assert (generateLoaderClass != null);
        } else if (mainUnit.loaderClass == null && mainUnit.loaderClassBase != null) {
            baseLoaderClass = mainUnit.loaderClassBase;
            windowClass = mainUnit.topLevelDefinitions.last().toString();
            mainUnit.loaderClass = generateLoaderClass = (windowClass + "_" + mainUnit.loaderClassBase).replaceAll("[^A-Za-z0-9]", "_");
        } else {
            if (mainUnit.loaderClass == null && (rsls.size() > 0 || cdRsls.size() > 0)) {
                ThreadLocalToolkit.log((CompilerMessage)new MissingFactoryClassInFrameMetadata(), mainUnit.getSource());
                return false;
            }
            return false;
        }
        String generatedLoaderCode = PreLink.codegenModuleFactory(baseLoaderClass.replace(':', '.'), generateLoaderClass.replace(':', '.'), windowClass.replace(':', '.'), rootAttributes, cdRsls, rsls, mixins, fonts, frames, locales, this.resourceBundleNames, this.externalResourceBundleNames, configuration, swcContext, false);
        String generatedLoaderFile = generateLoaderClass + ".as";
        Source s = new Source((VirtualFile)new TextFile(generatedLoaderCode, generatedLoaderFile, null, MimeMappings.getMimeType(generatedLoaderFile)), "", generateLoaderClass, null, false, false, false);
        s.setPathResolver(null);
        sources.add(s);
        if (configuration.getCompilerConfiguration().keepGeneratedActionScript()) {
            PreLink.saveGenerated(generatedLoaderFile, generatedLoaderCode, configuration.getCompilerConfiguration().getGeneratedDirectory());
        }
        return true;
    }

    private String codegenAccessibilityImports(Set<String> accessibilityImplementations) {
        StringBuilder sb = new StringBuilder();
        sb.append("import flash.system.*\n");
        if (accessibilityImplementations != null) {
            Iterator<String> it = accessibilityImplementations.iterator();
            while (it.hasNext()) {
                sb.append("import " + it.next() + ";\n");
            }
        }
        return sb.toString();
    }

    public static void saveGenerated(String name, String code, String dir) {
        String suffix = "-generated.as";
        String as3ext = ".as";
        if (!name.endsWith("-generated.as") && name.endsWith(".as")) {
            name = name.substring(0, name.length() - ".as".length()) + "-generated.as";
        }
        name = FileUtils.addPathComponents((String)dir, (String)name, (char)File.separatorChar);
        try {
            FileUtil.writeFile(name, code);
        }
        catch (IOException e) {
            ThreadLocalToolkit.log(new VelocityException.UnableToWriteGeneratedFile(name, e.getLocalizedMessage()));
        }
    }

    private static String codegenCdRslList(List cdRsls, Configuration configuration, CompilerSwcContext swcContext) {
        if (configuration.getStaticLinkRsl()) {
            return "[]";
        }
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        Iterator iter = cdRsls.iterator();
        while (iter.hasNext()) {
            Configuration.RslPathInfo info = (Configuration.RslPathInfo)iter.next();
            buf.append("{\"rsls\":[");
            Iterator<String> iter2 = info.getRslUrls().iterator();
            while (iter2.hasNext()) {
                buf.append("\"" + iter2.next() + "\"");
                if (!iter2.hasNext()) continue;
                buf.append(",");
            }
            buf.append("],\n");
            buf.append("\"policyFiles\":[");
            iter2 = info.getPolicyFileUrls().iterator();
            while (iter2.hasNext()) {
                buf.append("\"" + iter2.next() + "\"");
                if (!iter2.hasNext()) continue;
                buf.append(",");
            }
            buf.append("]\n");
            PreLink.codegenDigestArrays(swcContext, configuration, info, buf);
            buf.append("}");
            if (!iter.hasNext()) continue;
            buf.append(",\n");
        }
        buf.append("]\n");
        return buf.toString();
    }

    private static void codegenDigestArrays(CompilerSwcContext swcContext, Configuration configuration, Configuration.RslPathInfo info, StringBuilder buf) {
        Swc swc = swcContext.getSwc(info.getSwcVirtualFile().getName());
        if (swc == null) {
            throw new IllegalStateException("codegenCdRslList: swc not resolved, " + info.getSwcPath());
        }
        boolean secureRsls = configuration.getVerifyDigests();
        boolean haveDigest = false;
        boolean haveUnsignedRsl = false;
        StringBuilder digestBuffer = new StringBuilder("\"digests\":[");
        StringBuilder typeBuffer = new StringBuilder("\"types\":[");
        StringBuilder signedBuffer = new StringBuilder("\"isSigned\":[");
        Iterator<Boolean> iter2 = info.getSignedFlags().iterator();
        while (iter2.hasNext()) {
            Boolean isSigned = iter2.next();
            Digest digest = swc.getDigest(Swc.LIBRARY_SWF, "SHA-256", isSigned);
            if (digest != null && digest.hasDigest()) {
                String digestValue = digest.getValue();
                if (!secureRsls && !isSigned.booleanValue()) {
                    digestValue = "";
                }
                digestBuffer.append("\"" + digestValue + "\"");
                if (iter2.hasNext()) {
                    digestBuffer.append(",");
                }
                typeBuffer.append("\"" + digest.getType() + "\"");
                if (iter2.hasNext()) {
                    typeBuffer.append(",");
                }
                signedBuffer.append(isSigned.toString());
                if (iter2.hasNext()) {
                    signedBuffer.append(",");
                }
                haveDigest = true;
                if (isSigned.booleanValue()) continue;
                haveUnsignedRsl = true;
                continue;
            }
            if (haveDigest) continue;
            if (isSigned.booleanValue()) {
                ThreadLocalToolkit.log(new MissingSignedLibraryDigest(swc.getLocation()));
            } else {
                ThreadLocalToolkit.log(new MissingUnsignedLibraryDigest(swc.getLocation()));
            }
            return;
        }
        digestBuffer.append("],\n");
        typeBuffer.append("],\n");
        signedBuffer.append("]\n");
        buf.append(",");
        buf.append((CharSequence)digestBuffer);
        buf.append((CharSequence)typeBuffer);
        buf.append((CharSequence)signedBuffer);
    }

    private static String codegenRslList(List rsls) {
        if (rsls != null && rsls.size() > 0) {
            StringBuilder rb = new StringBuilder();
            rb.append("[");
            Iterator it = rsls.iterator();
            while (it.hasNext()) {
                rb.append("{url: \"" + it.next() + "\", size: -1}");
                if (!it.hasNext()) continue;
                rb.append(", ");
            }
            rb.append("]\n");
            return rb.toString();
        }
        return "[]";
    }

    private static String codegenMixinList(List<String> mixins) {
        assert (mixins != null && mixins.size() > 0);
        StringJoiner.ItemQuoter itemStringer = new StringJoiner.ItemQuoter();
        return "[ " + StringJoiner.join(mixins, (String)", ", (StringJoiner.ItemStringer)itemStringer) + " ]";
    }

    private static String codegenFrameClassList(List<FramesConfiguration.FrameInfo> frames) {
        assert (frames != null && frames.size() > 0);
        StringBuilder mb = new StringBuilder();
        mb.append("{");
        Iterator<FramesConfiguration.FrameInfo> it = frames.iterator();
        while (it.hasNext()) {
            FramesConfiguration.FrameInfo frameInfo = it.next();
            mb.append("\"");
            mb.append(frameInfo.label);
            mb.append("\":\"");
            mb.append(frameInfo.frameClasses.get(0));
            mb.append("\"");
            if (!it.hasNext()) continue;
            mb.append(", ");
        }
        mb.append("}\n");
        return mb.toString();
    }

    private static String codegenFontList(List<DefineTag> fonts) {
        if (fonts == null || fonts.size() == 0) {
            return "";
        }
        class FontInfo {
            boolean plain;
            boolean bold;
            boolean italic;
            boolean bolditalic;

            FontInfo() {
            }
        }
        TreeMap<String, FontInfo> fontMap = new TreeMap<String, FontInfo>();
        for (DefineFont defineFont : fonts) {
            FontInfo fi = (FontInfo)fontMap.get(defineFont.getFontName());
            if (fi == null) {
                fi = new FontInfo();
                fontMap.put(defineFont.getFontName(), fi);
            }
            fi.plain = fi.plain | (!defineFont.isBold() && !defineFont.isItalic());
            fi.bolditalic = fi.bolditalic | (defineFont.isBold() && defineFont.isItalic());
            fi.bold |= defineFont.isBold();
            fi.italic |= defineFont.isItalic();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("      {\n");
        Iterator iterator = fontMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry e = iterator.next();
            String fontName = (String)e.getKey();
            FontInfo fontInfo = (FontInfo)e.getValue();
            sb.append("\"" + fontName + "\" : {" + "regular:" + (fontInfo.plain ? "true" : "false") + ", bold:" + (fontInfo.bold ? "true" : "false") + ", italic:" + (fontInfo.italic ? "true" : "false") + ", boldItalic:" + (fontInfo.bolditalic ? "true" : "false") + "}\n");
            if (!iterator.hasNext()) continue;
            sb.append(",\n");
        }
        sb.append("}\n");
        return sb.toString();
    }

    private String codegenAccessibilityList(Set<String> accessibilityImplementations) {
        if (accessibilityImplementations == null || accessibilityImplementations.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (accessibilityImplementations != null && accessibilityImplementations.size() != 0) {
            sb.append("      // trace(\"Flex accessibility startup: \" + Capabilities.hasAccessibility);\n");
            sb.append("      if (Capabilities.hasAccessibility) {\n");
            Iterator<String> it = accessibilityImplementations.iterator();
            while (it.hasNext()) {
                sb.append("         " + it.next() + ".enableAccessibility();\n");
            }
            sb.append("      }\n");
        }
        if (Trace.accessible) {
            Trace.trace((String)"codegenAccessibilityList");
            if (sb.length() > 0) {
                Trace.trace((String)sb.toString());
            } else {
                Trace.trace((String)"empty");
            }
        }
        return sb.toString();
    }

    private String codegenRemoteClassImports(Map<String, String> remoteClassAliases) {
        StringBuilder sb = new StringBuilder();
        if (remoteClassAliases.size() > 0) {
            sb.append("import flash.net.registerClassAlias;\nimport flash.net.getClassByAlias;\n");
        }
        for (String className : remoteClassAliases.keySet()) {
            sb.append("import " + className + ";\n");
        }
        return sb.toString();
    }

    private String codegenRemoteClassAliases(Map<String, String> remoteClassAliases) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> e : remoteClassAliases.entrySet()) {
            String className = e.getKey();
            String alias = e.getValue();
            sb.append("      try {\n");
            sb.append("      if (flash.net.getClassByAlias(\"" + alias + "\") == null){\n");
            sb.append("          flash.net.registerClassAlias(\"" + alias + "\", " + className + ");}\n");
            sb.append("      } catch (e:Error) {\n");
            sb.append("          flash.net.registerClassAlias(\"" + alias + "\", " + className + "); }\n");
        }
        return sb.toString();
    }

    private String codegenEffectTriggerImports(Map<String, String> effectTriggers, StandardDefs standardDefs) {
        if (effectTriggers.size() > 0) {
            return "import " + standardDefs.CLASS_EFFECTMANAGER_DOT + ";\n" + "import " + standardDefs.NAMESPACE_MX_INTERNAL_DOT + ";\n";
        }
        return "";
    }

    private String codegenEffectTriggerRegistration(Map<String, String> effectTriggers) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> e : effectTriggers.entrySet()) {
            String name = e.getKey();
            String event = e.getValue();
            sb.append("      EffectManager.mx_internal::registerEffectTrigger(\"" + name + "\", \"" + event + "\");\n");
        }
        return sb.toString();
    }

    private String codegenInheritingStyleRegistration(Set<String> inheritingStyles) {
        StringBuilder sb = new StringBuilder();
        sb.append("      var styleNames:Array = [");
        Iterator<String> iterator = inheritingStyles.iterator();
        while (iterator.hasNext()) {
            String styleName = iterator.next();
            sb.append("\"" + styleName + "\"");
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        StandardDefs standardDefs = ThreadLocalToolkit.getStandardDefs();
        sb.append("];\n\n");
        sb.append("      import ").append(standardDefs.getStylesPackage()).append(".StyleManager;\n\n");
        sb.append("      for (var i:int = 0; i < styleNames.length; i++)\n");
        sb.append("      {\n");
        sb.append("         StyleManager.registerInheritingStyle(styleNames[i]);\n");
        sb.append("      }\n");
        return sb.toString();
    }

    private static String codegenCompiledLocales(String[] locales) {
        StringJoiner.ItemQuoter itemStringer = new StringJoiner.ItemQuoter();
        return "[ " + StringJoiner.join((Object[])locales, (String)", ", (StringJoiner.ItemStringer)itemStringer) + " ]";
    }

    private static String codegenCompiledResourceBundleNames(SortedSet<String> bundleNames) {
        StringJoiner.ItemQuoter itemStringer = new StringJoiner.ItemQuoter();
        return "[ " + StringJoiner.join(bundleNames, (String)", ", (StringJoiner.ItemStringer)itemStringer) + " ]";
    }

    private static String codegenCompatibilityCall(Configuration configuration) {
        String compatibilityVersion = configuration.getCompatibilityVersionString();
        String compatibilityCall = compatibilityVersion == null ? "" : "        FlexVersion.compatibilityVersionString = \"" + compatibilityVersion + "\";";
        return compatibilityCall;
    }

    private static String codegenQualifiedTypeSelectors(Configuration configuration) {
        boolean qualified = configuration.getQualifiedTypeSelectors();
        return qualified ? "" : "        StyleManager.mx_internal::qualifiedTypeSelectors = false;";
    }

    static String codegenModuleFactory(String base, String rootClassName, String topLevelWindowClass, Map<String, Object> rootAttributes, List cdRsls, List rsls, List<String> mixins, List<DefineTag> fonts, List<FramesConfiguration.FrameInfo> frames, String[] locales, SortedSet<String> resourceBundleNames, SortedSet<String> externalResourceBundleNames, Configuration configuration, CompilerSwcContext swcContext, boolean isLibraryCompile) {
        String lineSep = System.getProperty("line.separator");
        boolean hasFonts = fonts == null ? false : fonts.size() > 0;
        boolean isRsl = configuration instanceof CompcConfiguration;
        StandardDefs standardDefs = ThreadLocalToolkit.getStandardDefs();
        Object[] codePieces = new String[]{"package", lineSep, "{", lineSep, lineSep, PreLink.codegenImports(base, rootAttributes, fonts, configuration, standardDefs, isLibraryCompile, hasFonts), PreLink.codegenResourceBundleMetadata(null), "public class ", rootClassName, lineSep, "    extends ", base, lineSep, "    implements IFlexModuleFactory, ITextLineCreator", lineSep, "{", lineSep, PreLink.codegenLinkInCrossDomainRSLItem(configuration, lineSep, cdRsls, standardDefs), "    public function ", rootClassName, "()", lineSep, "    {", lineSep, PreLink.codegenCompatibilityCall(configuration), lineSep, PreLink.codegenQualifiedTypeSelectors(configuration), lineSep, "        super();", lineSep, PreLink.codegenAddRslCompleteListener(isLibraryCompile, hasFonts, lineSep), "    }", lineSep, lineSep, !isLibraryCompile ? "    override " : "", "    public function callInContext(fn:Function, thisArg:*, argsArray:*, returns:Boolean=true):*", lineSep, "    {", lineSep, "        if (returns)", lineSep, "           return fn.apply(thisArg, argsArray);", lineSep, "        else", lineSep, "           fn.apply(thisArg, argsArray);", lineSep, "    }", lineSep, lineSep, "    public function createTextLine(textBlock:TextBlock,", lineSep, "                      previousLine:TextLine = null,", lineSep, "                      width:Number = 1000000,", lineSep, "                      lineOffset:Number = 0.0,", lineSep, "                      fitSomething:Boolean = false):TextLine", lineSep, "    {", lineSep, "        return textBlock.createTextLine(previousLine, width, lineOffset, fitSomething);", lineSep, "    }", lineSep, lineSep, "    public function recreateTextLine(textBlock:TextBlock,", lineSep, "                      textLine:TextLine,", lineSep, "                      previousLine:TextLine = null,", lineSep, "                      width:Number = 1000000,", lineSep, "                      lineOffset:Number = 0.0,", lineSep, "                      fitSomething:Boolean = false):TextLine", lineSep, "    {", lineSep, "        var recreateTextLine:Function = textBlock[\"recreateTextLine\"];", lineSep, "        if (recreateTextLine == null)", lineSep, "            return null;", lineSep, "        return recreateTextLine(textLine, previousLine, width, lineOffset, fitSomething);", lineSep, "    }", lineSep, lineSep, PreLink.codegenGetRegisterImplementationStubs(isLibraryCompile, lineSep), !isLibraryCompile ? "    override " : "", "    public function create(... params):Object", lineSep, "    {", lineSep, PreLink.codegenCreateApply(isLibraryCompile, lineSep), PreLink.codegenGetMainClassName(topLevelWindowClass, configuration, lineSep), "        var mainClass:Class = Class(getDefinitionByName(mainClassName));", lineSep, "        if (!mainClass)", lineSep, "            return null;", lineSep, lineSep, "        var instance:Object = new mainClass();", lineSep, "        if (instance is IFlexModule)", lineSep, "            (IFlexModule(instance)).moduleFactory = this;", lineSep, PreLink.codegenRegisterEmbeddedFonts(fonts, lineSep), "        return instance;", lineSep, "    }", lineSep, lineSep, !isLibraryCompile ? "    override" : "", "    public function info():Object", lineSep, "    {", lineSep, "        return {", lineSep, PreLink.codegenInfo(topLevelWindowClass, rootAttributes, cdRsls, rsls, mixins, fonts, frames, locales, resourceBundleNames, configuration, swcContext), "        }", lineSep, "    }", lineSep, lineSep, PreLink.codegenRSLSecurityWrapper(isLibraryCompile, lineSep), lineSep, PreLink.codegenModuleFactorySecurityWrapper(isLibraryCompile, hasFonts, lineSep), lineSep, PreLink.codegenRslCompleteListener(isLibraryCompile, hasFonts, lineSep), "}", lineSep, lineSep, "}", lineSep};
        return StringJoiner.join((Object[])codePieces, null);
    }

    private static String codegenLinkInCrossDomainRSLItem(Configuration configuration, String lineSep, List cdRsls, StandardDefs standardDefs) {
        if (cdRsls == null || cdRsls.isEmpty()) {
            return "";
        }
        Object[] code = new String[]{"    // Cause the CrossDomainRSLItem class to be linked into this application.", lineSep, "    import ", standardDefs.CLASS_CROSSDOMAINRSLITEM_DOT, "; CrossDomainRSLItem;", lineSep, lineSep};
        return StringJoiner.join((Object[])code, null);
    }

    private static String codegenImportEmbeddedFontRegistry(List<DefineTag> fonts, String lineSep, StandardDefs standardDefs) {
        if (fonts == null || fonts.size() == 0) {
            return "";
        }
        Object[] code = new String[]{"import ", standardDefs.CLASS_EMBEDDEDFONTREGISTRY_DOT, ";", lineSep, "import ", standardDefs.CLASS_SINGLETON_DOT, ";", lineSep};
        return StringJoiner.join((Object[])code, null);
    }

    private static String codegenRegisterEmbeddedFonts(List<DefineTag> fonts, String lineSep) {
        if (fonts == null || fonts.size() == 0) {
            return "";
        }
        Object[] code = new String[]{"        if (params.length == 0) {", lineSep, "            Singleton.registerClass(\"mx.core::IEmbeddedFontRegistry\",", lineSep, "                Class(getDefinitionByName(\"mx.core::EmbeddedFontRegistry\")));", lineSep, "            EmbeddedFontRegistry.registerFonts(info()[\"fonts\"], this);", lineSep, "}"};
        return StringJoiner.join((Object[])code, null);
    }

    private static String codegenCreateApply(boolean isLibraryCompile, String lineSep) {
        if (isLibraryCompile) {
            return "";
        }
        Object[] code = new String[]{"        if (params.length > 0 && !(params[0] is String))", lineSep, "            return super.create.apply(this, params);", lineSep, lineSep};
        return StringJoiner.join((Object[])code, null);
    }

    private static String codegenGetMainClassName(String topLevelWindowClass, Configuration configuration, String lineSep) {
        Object[] code = new String[]{topLevelWindowClass == null ? "        var mainClassName:String = String(params[0])" : "        var mainClassName:String = params.length == 0 ? \"", topLevelWindowClass == null ? "" : topLevelWindowClass, topLevelWindowClass == null ? "" : "\" : String(params[0]);", lineSep};
        return StringJoiner.join((Object[])code, null);
    }

    private static String codegenResourceBundleMetadata(SortedSet<String> resourceBundleNames) {
        if (resourceBundleNames == null) {
            return "";
        }
        String lineSep = System.getProperty("line.separator");
        StringBuilder codePieces = new StringBuilder();
        Iterator i = resourceBundleNames.iterator();
        while (i.hasNext()) {
            codePieces.append("[ResourceBundle(\"" + (String)i.next() + "\")]" + lineSep);
        }
        return codePieces.toString();
    }

    private static String codegenImports(String base, Map<String, Object> rootAttributes, List<DefineTag> fonts, Configuration configuration, StandardDefs standardDefs, boolean isLibraryCompile, boolean hasFonts) {
        String lineSep = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder(512);
        sb.append(PreLink.codegenEventImport(isLibraryCompile, hasFonts, lineSep));
        sb.append("import flash.display.LoaderInfo;").append(lineSep);
        sb.append("import flash.text.Font;").append(lineSep);
        sb.append("import flash.text.TextFormat;").append(lineSep);
        sb.append("import flash.text.engine.TextBlock;").append(lineSep);
        sb.append("import flash.text.engine.TextLine;").append(lineSep);
        sb.append("import flash.system.ApplicationDomain;").append(lineSep);
        sb.append("import flash.system.Security").append(lineSep);
        sb.append("import flash.utils.Dictionary;").append(lineSep);
        sb.append("import flash.utils.getDefinitionByName;").append(lineSep);
        sb.append("import flashx.textLayout.compose.ITextLineCreator;").append(lineSep);
        sb.append("import ").append(standardDefs.INTERFACE_IFLEXMODULE_DOT).append(";").append(lineSep);
        sb.append("import ").append(standardDefs.INTERFACE_IFLEXMODULEFACTORY_DOT).append(";").append(lineSep);
        sb.append(PreLink.codegenImportEmbeddedFontRegistry(fonts, lineSep, standardDefs));
        sb.append("import mx.preloaders.DownloadProgressBar;").append(lineSep);
        sb.append("import mx.preloaders.SparkDownloadProgressBar;").append(lineSep);
        if (configuration.getCompatibilityVersionString() != null) {
            sb.append("import ").append(standardDefs.CLASS_FLEXVERSION_DOT).append(";").append(lineSep);
        }
        if (!configuration.getQualifiedTypeSelectors()) {
            sb.append("import ").append(standardDefs.CLASS_STYLEMANAGER_DOT).append(";").append(lineSep);
            sb.append("import ").append(standardDefs.NAMESPACE_MX_INTERNAL_DOT).append(";").append(lineSep);
        }
        sb.append("import ").append(base).append(";").append(lineSep);
        if (rootAttributes != null && rootAttributes.containsKey("preloader")) {
            sb.append("import ").append(rootAttributes.get("preloader")).append(";").append(lineSep);
        }
        sb.append(lineSep);
        return sb.toString();
    }

    private static String codegenEventImport(boolean isLibraryCompile, boolean hasFonts, String lineSep) {
        if (!isLibraryCompile || !hasFonts) {
            return "";
        }
        Object[] eventImport = new String[]{"import flash.events.Event", lineSep};
        return StringJoiner.join((Object[])eventImport, null);
    }

    private static String codegenInfo(String topLevelWindowClass, Map<String, Object> rootAttributes, List cdRsls, List rsls, List<String> mixins, List<DefineTag> fonts, List<FramesConfiguration.FrameInfo> frames, String[] locales, SortedSet<String> resourceBundleNames, Configuration configuration, CompilerSwcContext swcContext) {
        TreeMap<String, Object> t = new TreeMap<String, Object>();
        t.put("currentDomain", "ApplicationDomain.currentDomain");
        if (topLevelWindowClass != null) {
            t.put("mainClassName", "\"" + topLevelWindowClass + "\"");
        }
        if (rootAttributes != null) {
            boolean explicitPreloader = false;
            for (Map.Entry<String, Object> e : rootAttributes.entrySet()) {
                if ("preloader".equals(e.getKey())) {
                    t.put(e.getKey(), e.getValue());
                    explicitPreloader = true;
                    continue;
                }
                if ("usePreloader".equals(e.getKey())) {
                    t.put(e.getKey(), e.getValue());
                    continue;
                }
                if ("implements".equals(e.getKey())) continue;
                if ("backgroundColor".equals(e.getKey())) {
                    t.put(e.getKey(), "\"0x" + Integer.toHexString(configuration.backgroundColor()).toUpperCase() + "\"");
                    continue;
                }
                t.put(e.getKey(), "\"" + e.getValue() + "\"");
            }
            if (!explicitPreloader) {
                int version = configuration.getCompatibilityVersion();
                if (version < 0x4000000) {
                    t.put("preloader", "DownloadProgressBar");
                } else {
                    t.put("preloader", "SparkDownloadProgressBar");
                }
            }
        }
        if (cdRsls != null && cdRsls.size() > 0) {
            t.put("cdRsls", PreLink.codegenCdRslList(cdRsls, configuration, swcContext));
        }
        if (rsls != null && rsls.size() > 0) {
            t.put("rsls", PreLink.codegenRslList(rsls));
        }
        if (mixins != null && mixins.size() > 0) {
            t.put("mixins", PreLink.codegenMixinList(mixins));
        }
        if (fonts != null && fonts.size() > 0) {
            t.put("fonts", PreLink.codegenFontList(fonts));
        }
        if (frames != null && frames.size() > 0) {
            t.put("frames", PreLink.codegenFrameClassList(frames));
        }
        if (locales != null) {
            t.put("compiledLocales", PreLink.codegenCompiledLocales(locales));
        }
        if (resourceBundleNames != null && resourceBundleNames.size() > 0) {
            t.put("compiledResourceBundleNames", PreLink.codegenCompiledResourceBundleNames(resourceBundleNames));
        }
        String lineSep = System.getProperty("line.separator");
        StringJoiner.MapEntryItemWithColon itemStringer = new StringJoiner.MapEntryItemWithColon();
        return "            " + StringJoiner.join(t.entrySet(), (String)("," + lineSep + "            "), (StringJoiner.ItemStringer)itemStringer) + lineSep;
    }

    private static String codegenAddRslCompleteListener(boolean isLibraryCompile, boolean hasFonts, String lineSep) {
        if (!isLibraryCompile || !hasFonts) {
            return "";
        }
        Object[] addCompleteListenerCall = new String[]{"        this.root.loaderInfo.addEventListener(Event.COMPLETE, RSLRootCompleteListener);", lineSep};
        return StringJoiner.join((Object[])addCompleteListenerCall, null);
    }

    private static String codegenRslCompleteListener(boolean isLibraryCompile, boolean hasFonts, String lineSep) {
        if (!isLibraryCompile || !hasFonts) {
            return "";
        }
        Object[] completeListener = new String[]{"    private function RSLRootCompleteListener(event:Event):void", lineSep, "    {", lineSep, "        EmbeddedFontRegistry.registerFonts(info()[\"fonts\"], this)", lineSep, "        this.root.removeEventListener(Event.COMPLETE, RSLRootCompleteListener);", lineSep, "    }", lineSep};
        return StringJoiner.join((Object[])completeListener, null);
    }

    private static String codegenModuleFactorySecurityWrapper(boolean isLibraryCompile, boolean hasFonts, String lineSep) {
        if (isLibraryCompile && !hasFonts) {
            return "";
        }
        Object[] code = new String[]{"    /**", lineSep, "     *  @private", lineSep, "     */", lineSep, "    private var _preloadedRSLs:Dictionary; // key: LoaderInfo, value: RSL URL", lineSep, lineSep, "    /**", lineSep, "     *  The RSLs loaded by this system manager before the application", lineSep, "     *  starts. RSLs loaded by the application are not included in this list.", lineSep, "     */", lineSep, !isLibraryCompile ? "    override " : "", "    public function get preloadedRSLs():Dictionary", lineSep, "    {", lineSep, "        if (_preloadedRSLs == null)", lineSep, "           _preloadedRSLs = new Dictionary(true);", lineSep, "        return _preloadedRSLs;", lineSep, "    }", lineSep, lineSep, "    /**", lineSep, "     *  Calls Security.allowDomain() for the SWF associated with this IFlexModuleFactory", lineSep, "     *  plus all the SWFs assocatiated with RSLs preLoaded by this IFlexModuleFactory.", lineSep, "     *", lineSep, "     */", lineSep, !isLibraryCompile ? "    override " : "", "    public function allowDomain(... domains):void", lineSep, "    {", lineSep, "        Security.allowDomain(domains);", lineSep, lineSep, "        for (var loaderInfo:Object in _preloadedRSLs)", lineSep, "        {", lineSep, "            if (loaderInfo.content && (\"allowDomainInRSL\" in loaderInfo.content))", lineSep, "            {", lineSep, "                loaderInfo.content[\"allowDomainInRSL\"](domains);", lineSep, "            }", lineSep, "        }", lineSep, "    }", lineSep, lineSep, "    /**", lineSep, "     *  Calls Security.allowInsecureDomain() for the SWF associated with this IFlexModuleFactory", lineSep, "     *  plus all the SWFs assocatiated with RSLs preLoaded by this IFlexModuleFactory.", lineSep, "     *", lineSep, "     */", lineSep, !isLibraryCompile ? "    override " : "", "    public function allowInsecureDomain(... domains):void", lineSep, "    {", lineSep, "        Security.allowInsecureDomain(domains);", lineSep, lineSep, "        for (var loaderInfo:Object in _preloadedRSLs)", lineSep, "        {", lineSep, "            if (loaderInfo.content && (\"allowInsecureDomainInRSL\" in loaderInfo.content))", lineSep, "            {", lineSep, "                loaderInfo.content[\"allowInsecureDomainInRSL\"](domains);", lineSep, "            }", lineSep, "        }", lineSep, "    }", lineSep, lineSep};
        return StringJoiner.join((Object[])code, null);
    }

    static String codegenRSLSecurityWrapper(boolean isLibraryCompile, String lineSep) {
        if (!isLibraryCompile) {
            return "";
        }
        Object[] code = new String[]{"   /*", lineSep, "    *  Calls Security.allowDomain() for the SWF associated with this RSL", lineSep, "    *  @param a list of domains to trust. This parameter is passed to Security.allowDomain().", lineSep, "    */", lineSep, "   public function allowDomainInRSL(... domains):void", lineSep, "   {", lineSep, "       Security.allowDomain(domains);", lineSep, "   }", lineSep, lineSep, "   /*", lineSep, "    *  Calls Security.allowInsecureDomain() for the SWF associated with this RSL", lineSep, "    *  @param a list of domains to trust. This parameter is passed to Security.allowInsecureDomain().", lineSep, "    */", lineSep, "   public function allowInsecureDomainInRSL(... domains):void", lineSep, "   {", lineSep, "       Security.allowInsecureDomain(domains);", lineSep, "   }", lineSep};
        return StringJoiner.join((Object[])code, null);
    }

    private static String codegenGetRegisterImplementationStubs(boolean isLibraryCompile, String lineSep) {
        if (!isLibraryCompile) {
            return "";
        }
        Object[] code = new String[]{"    /**", lineSep, "     *  @private", lineSep, "     *  Stub for RSL", lineSep, "     */", lineSep, "    public function getImplementation(interfaceName:String):Object", lineSep, "    {", lineSep, "        return null;", lineSep, "    }", lineSep, lineSep, "    /**", lineSep, "     *  @private", lineSep, "     *  Stub for RSL", lineSep, "     */", lineSep, "    public function registerImplementation(interfaceName:String,", lineSep, "                                           impl:Object):void", lineSep, "    {", lineSep, "    }", lineSep, lineSep};
        return StringJoiner.join((Object[])code, null);
    }

    private void processCompiledResourceBundleInfoClass(List units, Configuration configuration, List<Source> sources, List<String> mixins, List<DefineTag> fonts, CompilerSwcContext swcContext) {
        CompilerConfiguration config = configuration.getCompilerConfiguration();
        int version = config.getCompatibilityVersion();
        if (version < 0x3000000) {
            return;
        }
        String[] locales = config.getLocales();
        if (locales.length == 0) {
            return;
        }
        if (this.resourceBundleNames.size() == 0) {
            return;
        }
        String className = I18nUtils.COMPILED_RESOURCE_BUNDLE_INFO;
        String code = I18nUtils.codegenCompiledResourceBundleInfo(locales, this.resourceBundleNames);
        String generatedFileName = className + "-generated.as";
        if (config.keepGeneratedActionScript()) {
            PreLink.saveGenerated(generatedFileName, code, config.getGeneratedDirectory());
        }
        Source s = new Source((VirtualFile)new TextFile(code, generatedFileName, null, MimeMappings.getMimeType(generatedFileName)), "", className, null, false, false, false);
        s.setPathResolver(null);
        sources.add(s);
        configuration.getIncludes().add(className);
    }

    public static class ClassesMappedToSameRemoteAlias
    extends CompilerMessage.CompilerWarning {
        private static final long serialVersionUID = 4365280637418299961L;
        public String className;
        public String existingClassName;
        public String alias;

        public ClassesMappedToSameRemoteAlias(String className, String existingClassName, String alias) {
            this.className = className;
            this.existingClassName = existingClassName;
            this.alias = alias;
        }
    }

    public static class MissingUnsignedLibraryDigest
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 8092666584208136222L;
        public String libraryPath;

        public MissingUnsignedLibraryDigest(String libraryPath) {
            this.libraryPath = libraryPath;
        }
    }

    public static class MissingSignedLibraryDigest
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -1865860949469218550L;
        public String libraryPath;

        public MissingSignedLibraryDigest(String libraryPath) {
            this.libraryPath = libraryPath;
        }
    }

    public static class CouldNotParseNumber
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 2186380089141871093L;
        public String num;
        public String attribute;

        public CouldNotParseNumber(String num, String attribute) {
            this.num = num;
            this.attribute = attribute;
        }
    }

    public static class InvalidBackgroundColor
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -623864938378435687L;
        public String backgroundColor;

        public InvalidBackgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
        }
    }

    public static class MissingFactoryClassInFrameMetadata
    extends CompilerMessage.CompilerWarning {
        private static final long serialVersionUID = 1064989348731483344L;
    }

    public static class NoExternalVisibleDefinition
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -917715346261180363L;
    }
}

