/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.swc;

import flash.swf.Movie;
import flash.swf.MovieEncoder;
import flash.swf.TagEncoder;
import flash.swf.TagHandler;
import flex2.compiler.CompilationUnit;
import flex2.compiler.Source;
import flex2.compiler.io.InMemoryFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.Digest;
import flex2.compiler.swc.SwcAPI;
import flex2.compiler.swc.SwcArchive;
import flex2.compiler.swc.SwcComponent;
import flex2.compiler.swc.SwcDependencySet;
import flex2.compiler.swc.SwcException;
import flex2.compiler.swc.SwcFeatures;
import flex2.compiler.swc.SwcFile;
import flex2.compiler.swc.SwcLibrary;
import flex2.compiler.swc.SwcMovie;
import flex2.compiler.swc.SwcScript;
import flex2.compiler.swc.Versions;
import flex2.compiler.swc.catalog.CatalogReader;
import flex2.compiler.swc.catalog.CatalogWriter;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.MimeMappings;
import flex2.compiler.util.MultiName;
import flex2.compiler.util.Name;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.QName;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.linker.LinkerConfiguration;
import flex2.linker.LinkerException;
import flex2.tools.PreLink;
import flex2.tools.VersionInfo;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Swc {
    protected static boolean FNORD = false;
    public static String LIBRARY_SWF = "library.swf";
    public static String CATALOG_XML = "catalog.xml";
    protected final SwcArchive archive;
    private long lastModified = -1L;
    protected Map<String, SwcLibrary> libraries = new HashMap<String, SwcLibrary>();
    protected Map<String, VirtualFile> catalogFiles;
    protected Map<String, SwcComponent> components = new TreeMap<String, SwcComponent>();
    protected Versions versions = new Versions();
    protected SwcFeatures swcFeatures = new SwcFeatures();
    private Map<String, String> defs = new HashMap<String, String>();
    private boolean forceLibraryVersion1;

    public Swc(SwcArchive archive) throws Exception {
        this(archive, false);
    }

    Swc(SwcArchive archive, boolean load) throws Exception {
        this.archive = archive;
        if (load) {
            this.read();
        }
    }

    long getLastModified() {
        return this.lastModified;
    }

    void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public String getLocation() {
        return this.archive.getLocation();
    }

    public Iterator<SwcLibrary> getLibraryIterator() {
        return this.libraries.values().iterator();
    }

    public SwcLibrary buildLibrary(String libname, LinkerConfiguration linkerConfiguration, List<CompilationUnit> units) throws IOException, LinkerException {
        SwcMovie m = SwcAPI.link(linkerConfiguration, units);
        return this.buildLibrary(libname, linkerConfiguration, m);
    }

    public SwcLibrary buildLibrary(String libname, LinkerConfiguration linkerConfiguration, SwcMovie movie) throws IOException {
        int version = linkerConfiguration.getCompatibilityVersion();
        this.forceLibraryVersion1 = version < 0x3000000;
        ByteArrayOutputStream swfOut = new ByteArrayOutputStream();
        TagEncoder encoder = new TagEncoder();
        new MovieEncoder((TagHandler)encoder).export((Movie)movie);
        encoder.writeTo((OutputStream)swfOut);
        swfOut.flush();
        byte[] swf = swfOut.toByteArray();
        swfOut.close();
        String libPath = libname + ".swf";
        SwcLibrary lib = new SwcLibrary(this, libPath);
        InMemoryFile swfFile = new InMemoryFile(swf, libPath, MimeMappings.getMimeType(libPath), new Date().getTime());
        this.archive.putFile(swfFile);
        this.libraries.put(libPath, lib);
        if (linkerConfiguration.getComputeDigest()) {
            Digest digest = new Digest();
            digest.setSigned(false);
            digest.setType("SHA-256");
            digest.computeDigest(swf);
            lib.setDigest(digest);
        }
        this.initMetadata(lib, linkerConfiguration);
        Set<String> externs = lib.getExterns();
        externs.addAll(linkerConfiguration.getUnresolved());
        HashSet<SwcLibrary> librariesProcessed = new HashSet<SwcLibrary>();
        for (CompilationUnit unit : movie.getExportedUnits()) {
            SwcScript script;
            SwcLibrary library;
            Source unitSource = unit.getSource();
            SwcDependencySet depset = new SwcDependencySet();
            Swc.addDeps(depset, "i", unit.inheritance);
            Swc.addDeps(depset, "s", unit.types);
            Swc.addDeps(depset, "n", unit.namespaces);
            Swc.addDeps(depset, "e", unit.expressions);
            Swc.addExtraClassesDeps(depset, unit.extraClasses);
            Set<String> scriptDefs = unit.topLevelDefinitions.getStringSet();
            this.checkDefs(scriptDefs, unitSource.getName());
            String sourceName = NameFormatter.nameFromSource(unitSource);
            SwcScript newScript = lib.addScript(sourceName, scriptDefs, depset, unitSource.getLastModified(), unit.getSignatureChecksum());
            newScript.setCompilationUnit(unit);
            this.addIcons(unit, sourceName);
            if (!unitSource.isSwcScriptOwner() || unitSource.isInternal() || PreLink.isCompilationUnitExternal(unit, externs) || librariesProcessed.contains(library = (script = (SwcScript)unitSource.getOwner()).getLibrary())) continue;
            librariesProcessed.add(library);
            lib.addMetadata(script.getLibrary().getMetadata());
        }
        return lib;
    }

    private void initMetadata(SwcLibrary swcLibrary, LinkerConfiguration linkerConfiguration) {
        String[] configMetaData = linkerConfiguration.getMetadataToKeep();
        if (configMetaData == null) {
            return;
        }
        if (configMetaData.length > 0) {
            swcLibrary.addMetadata(Arrays.asList(configMetaData));
        }
    }

    private void addIcons(CompilationUnit unit, String sourceName) throws IOException {
        String icon;
        String string = icon = unit.iconFile == null ? null : unit.iconFile.getValue(0);
        if (icon != null) {
            String iconName;
            VirtualFile iconFile = unit.getSource().resolve(icon);
            if (iconFile == null && unit.getSource().isSwcScriptOwner()) {
                int s = unit.topLevelDefinitions.size();
                for (int i = 0; i < s; ++i) {
                    String swcIcon;
                    String def = ((QName)unit.topLevelDefinitions.get(i)).toString();
                    if (!this.components.containsKey(def) || (swcIcon = this.components.get(def).getIcon()) == null || (iconFile = ((SwcScript)unit.getSource().getOwner()).getLibrary().getSwc().getFile(swcIcon)) == null) continue;
                    InMemoryFile inMemFile = new InMemoryFile(iconFile.getInputStream(), swcIcon, MimeMappings.getMimeType(swcIcon), iconFile.getLastModified());
                    this.archive.putFile(inMemFile);
                    return;
                }
                if (iconFile == null) {
                    return;
                }
            }
            if (iconFile == null) {
                throw new SwcException.MissingIconFile(icon, sourceName);
            }
            String workingSourceName = NameFormatter.toColon(NameFormatter.toDot(sourceName, '/'));
            SwcComponent comp = this.components.get(workingSourceName);
            String rel = unit.getSource().getRelativePath();
            String string2 = iconName = rel == null || rel.length() == 0 ? icon : rel + "/" + icon;
            if (comp != null) {
                comp.setIcon(iconName);
            }
            InMemoryFile inMemFile = new InMemoryFile(iconFile.getInputStream(), iconName, MimeMappings.getMimeType(iconName), iconFile.getLastModified());
            this.archive.putFile(inMemFile);
        }
    }

    protected void checkDefs(Set<String> scriptDefs, String sourceName) {
        for (String str : scriptDefs) {
            String script = this.defs.get(str);
            if (script != null) {
                throw new SwcException.DuplicateDefinition(str, script, sourceName);
            }
            this.defs.put(str, sourceName);
        }
    }

    private static void addDeps(SwcDependencySet depset, String type, Set<Name> nameSet) {
        for (Name name : nameSet) {
            if (name instanceof MultiName) {
                MultiName mname = (MultiName)name;
                assert (mname.getNumQNames() == 1);
                depset.addDependency(type, mname.getQName(0).toString());
                continue;
            }
            assert (name instanceof QName);
            depset.addDependency(type, name.toString());
        }
    }

    private static void addExtraClassesDeps(SwcDependencySet depset, Set extraClasses) {
        for (String extraClass : extraClasses) {
            depset.addDependency("e", extraClass);
        }
    }

    synchronized boolean save() throws Exception {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)byteOut, "UTF-8");
        if (this.components.size() > 0) {
            this.swcFeatures.setComponents(true);
        }
        if (this.archive.getFiles().size() > 0) {
            this.swcFeatures.setFiles(true);
        }
        String currentVersion = this.determineSwcLibraryVersion();
        this.versions.setLibVersion(currentVersion);
        this.versions.setFlexVersion(VersionInfo.getFlexVersion());
        this.versions.setFlexBuild(VersionInfo.getBuild());
        for (SwcLibrary l : this.libraries.values()) {
            if (l.getExterns().size() <= 0) continue;
            this.swcFeatures.setExternalDeps(true);
            break;
        }
        CatalogWriter writer = new CatalogWriter(out, this.versions, this.swcFeatures, this.components.values(), this.libraries.values(), this.archive.getFiles().entrySet());
        writer.write();
        ((Writer)out).close();
        this.archive.putFile(CATALOG_XML, byteOut.toByteArray(), new Date().getTime());
        this.archive.save();
        this.catalogFiles = this.archive.getFiles();
        return ThreadLocalToolkit.errorCount() == 0;
    }

    private String determineSwcLibraryVersion() {
        if (this.forceLibraryVersion1) {
            return VersionInfo.LIB_VERSION_1_0;
        }
        return VersionInfo.LIB_VERSION_1_2;
    }

    public Map<String, VirtualFile> getCatalogFiles() {
        return this.catalogFiles;
    }

    public VirtualFile getFile(String path) {
        return this.catalogFiles.get(path);
    }

    public void addFile(VirtualFile file) {
        this.archive.putFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void read() throws Exception {
        InputStream stream = null;
        try {
            this.archive.load();
            VirtualFile catalogFile = this.archive.getFile(CATALOG_XML);
            if (catalogFile == null) {
                throw new SwcException.CatalogNotFound();
            }
            stream = catalogFile.getInputStream();
            CatalogReader reader = new CatalogReader(new BufferedInputStream(stream), this, this.archive);
            reader.read();
            this.versions = reader.getVersions();
            this.swcFeatures = reader.getFeatures();
            this.components = reader.getComponents();
            this.libraries = reader.getLibraries();
            this.catalogFiles = new HashMap<String, SwcFile>(reader.getFiles());
            if (this.versions.getLibVersion() != null && VersionInfo.IsNewerLibVersion(this.versions.getLibVersion(), true)) {
                OldVersion oldVersion = new OldVersion(this.archive.getLocation(), this.versions.getLibVersion(), VersionInfo.getLibVersion());
                ThreadLocalToolkit.log(oldVersion);
            }
            Object var6_5 = null;
            if (stream == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (stream == null) throw throwable;
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            stream.close();
            return;
        }
        catch (IOException ioe) {}
    }

    public void close() {
        this.archive.close();
    }

    public Iterator<SwcComponent> getComponentIterator() {
        return this.components.values().iterator();
    }

    public SwcComponent getComponent(String className) {
        return this.components.get(className);
    }

    public Versions getVersions() {
        return this.versions;
    }

    public SwcFeatures getFeatures() {
        return this.swcFeatures;
    }

    public Digest getDigest(String libPath, boolean isSigned) {
        return this.getDigest(libPath, "SHA-256", isSigned);
    }

    public Digest getDigest(String libPath, String hashType, boolean isSigned) {
        if (libPath == null) {
            throw new NullPointerException("libPath may not be null");
        }
        if (hashType == null) {
            throw new NullPointerException("hashType may not be null");
        }
        SwcLibrary lib = this.libraries.get(LIBRARY_SWF);
        if (lib != null) {
            return lib.getDigest(hashType, isSigned);
        }
        return null;
    }

    public void setDigest(String libPath, Digest digest) {
        if (libPath == null) {
            throw new NullPointerException("setDigest: libPath may not be null");
        }
        if (digest == null) {
            throw new NullPointerException("setDigest:  digest may not be null");
        }
        SwcLibrary lib = this.libraries.get(LIBRARY_SWF);
        if (lib != null) {
            lib.setDigest(digest);
        }
    }

    public void addComponent(SwcComponent c) {
        this.components.put(c.getClassName(), c);
    }

    SwcArchive getArchive() {
        return this.archive;
    }

    public static class OldVersion
    extends CompilerMessage.CompilerWarning {
        private static final long serialVersionUID = 6737124293703916205L;
        public String swc;
        public String swcVer;
        public String compilerVer;

        public OldVersion(String swc, String swcVer, String compilerVer) {
            this.swc = swc;
            this.swcVer = swcVer;
            this.compilerVer = compilerVer;
        }
    }
}

