/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.rep;

import flash.util.StringUtils;
import flex2.compiler.CompilationUnit;
import flex2.compiler.CompilerContext;
import flex2.compiler.css.Styles;
import flex2.compiler.css.StylesContainer;
import flex2.compiler.mxml.MxmlConfiguration;
import flex2.compiler.mxml.dom.DesignLayerNode;
import flex2.compiler.mxml.dom.Node;
import flex2.compiler.mxml.gen.CodeFragmentList;
import flex2.compiler.mxml.gen.DescriptorGenerator;
import flex2.compiler.mxml.gen.StatesGenerator;
import flex2.compiler.mxml.gen.TextGen;
import flex2.compiler.mxml.lang.FrameworkDefs;
import flex2.compiler.mxml.lang.StandardDefs;
import flex2.compiler.mxml.reflect.Property;
import flex2.compiler.mxml.reflect.Type;
import flex2.compiler.mxml.reflect.TypeTable;
import flex2.compiler.mxml.rep.AtEmbed;
import flex2.compiler.mxml.rep.AtResource;
import flex2.compiler.mxml.rep.BindingExpression;
import flex2.compiler.mxml.rep.DesignLayer;
import flex2.compiler.mxml.rep.DocumentInfo;
import flex2.compiler.mxml.rep.Model;
import flex2.compiler.mxml.rep.MovieClip;
import flex2.compiler.mxml.rep.Script;
import flex2.compiler.mxml.rep.StatesModel;
import flex2.compiler.mxml.rep.VariableDeclaration;
import flex2.compiler.mxml.rep.decl.InitializedPropertyDeclaration;
import flex2.compiler.mxml.rep.decl.PropertyDeclaration;
import flex2.compiler.mxml.rep.decl.UninitializedPropertyDeclaration;
import flex2.compiler.mxml.rep.init.EventInitializer;
import flex2.compiler.mxml.rep.init.Initializer;
import flex2.compiler.mxml.rep.init.NamedInitializer;
import flex2.compiler.mxml.rep.init.ValueInitializer;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.DualModeLineNumberMap;
import flex2.compiler.util.IteratorList;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.QName;
import flex2.compiler.util.ThreadLocalToolkit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.iterators.FilterIterator;
import org.apache.commons.collections.iterators.IteratorChain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MxmlDocument {
    private final CompilationUnit unit;
    private final TypeTable typeTable;
    private final DocumentInfo info;
    private final StandardDefs standardDefs;
    private Model root;
    private final Map<String, PropertyDeclaration> declarations;
    private final List<BindingExpression> bindingExpressions;
    private final List<PropertyDeclaration> layerDeclarations;
    private final Map<String, AtEmbed> atEmbeds;
    private final Map<String, AtResource> atResources;
    private final Set<String> typeRefs;
    private final StylesContainer stylesContainer;
    private String preloader;
    private boolean usePreloader;
    private DualModeLineNumberMap lineNumberMap;
    private Map<String, Integer> anonIdCounts;
    private boolean bindingImportsAdded;
    private Map sharedObjects;
    private StatesModel statesModel;
    private List statefulEventInitializers;
    private String comment;
    private boolean showDeprecationWarnings;
    private Map<DesignLayerNode, DesignLayer> designLayers;

    public MxmlDocument(CompilationUnit unit, TypeTable typeTable, DocumentInfo info, MxmlConfiguration mxmlConfiguration) {
        this.unit = unit;
        this.typeTable = typeTable;
        this.info = info;
        this.standardDefs = unit.getStandardDefs();
        this.root = null;
        this.declarations = new TreeMap<String, PropertyDeclaration>();
        this.layerDeclarations = new ArrayList<PropertyDeclaration>();
        this.bindingExpressions = new ArrayList<BindingExpression>();
        this.atEmbeds = new TreeMap<String, AtEmbed>();
        this.atResources = new TreeMap<String, AtResource>();
        this.typeRefs = new TreeSet<String>();
        this.designLayers = new HashMap<DesignLayerNode, DesignLayer>();
        this.stylesContainer = new StylesContainer(unit, typeTable.getPerCompileData(), mxmlConfiguration);
        this.showDeprecationWarnings = mxmlConfiguration.showDeprecationWarnings();
        this.stylesContainer.setMxmlDocument(this);
        this.stylesContainer.setNameMappings(typeTable.getNameMappings());
        this.sharedObjects = new TreeMap();
        this.statesModel = new StatesModel(this, info, this.standardDefs);
        this.statefulEventInitializers = new ArrayList();
        this.preloader = NameFormatter.toDot(this.standardDefs.CLASS_DOWNLOADPROGRESSBAR);
        this.usePreloader = true;
        this.lineNumberMap = null;
        this.anonIdCounts = new HashMap<String, Integer>();
        this.bindingImportsAdded = false;
        CompilerContext context = unit.getContext();
        context.setAttribute("BindingExpressions", this.bindingExpressions);
    }

    public final DesignLayer getLayerModel(DesignLayerNode node) {
        return this.designLayers.get(node);
    }

    public final void addLayerModel(DesignLayerNode node, DesignLayer model) {
        this.designLayers.put(node, model);
    }

    public final CompilationUnit getCompilationUnit() {
        return this.unit;
    }

    public final String getSourcePath() {
        return this.unit.getSource().getName();
    }

    public final StandardDefs getStandardDefs() {
        return this.standardDefs;
    }

    public final boolean getIsMain() {
        return this.unit.isRoot();
    }

    public final TypeTable getTypeTable() {
        return this.typeTable;
    }

    public final String getClassName() {
        return this.info.getClassName();
    }

    public final String getConvertedClassName() {
        return "_" + StringUtils.substitute((String)this.getClassName(), (String)".", (String)"_");
    }

    public final String getPackageName() {
        return this.info.getPackageName();
    }

    public final QName getQName() {
        return this.info.getQName();
    }

    public final Type getSkeletonClass() {
        return this.typeTable.getType(this.getQName().toString());
    }

    public final Type getSuperClass() {
        return this.getRoot().getType();
    }

    public final String getSuperClassName() {
        return NameFormatter.toDot(this.getSuperClass().getName());
    }

    public final boolean getHasInterfaces() {
        return this.info.getInterfaceNames().size() > 0;
    }

    public final boolean getIsInlineComponent() {
        return this.info.getRootNode().isInlineComponent();
    }

    public void setRoot(Model root) {
        String outerDocClassName;
        this.root = root;
        if (this.getIsContainer()) {
            this.addImport(NameFormatter.toDot(this.standardDefs.CLASS_UICOMPONENTDESCRIPTOR), root.getXmlLineNumber());
        }
        if ((outerDocClassName = this.info.getRootNode().getOuterDocumentClassName()) != null) {
            this.addDeclaration("outerDocument", outerDocClassName, 0, false, true, false);
        }
    }

    public final Model getRoot() {
        assert (this.root != null) : "root component not set";
        return this.root;
    }

    public final void addDeclaration(Model model, boolean topLevel) {
        if (!this.inheritedPropertyUsageError(model.getId(), model.getType(), model.getXmlLineNumber())) {
            if (model instanceof DesignLayer) {
                this.layerDeclarations.add(new InitializedPropertyDeclaration(model, topLevel, model.getXmlLineNumber()));
            }
            this.declarations.put(model.getId(), new InitializedPropertyDeclaration(model, topLevel, model.getXmlLineNumber()));
        }
    }

    public final void addDeclaration(String id, String typeName, int line, boolean inspectable, boolean topLevel, boolean idIsAutogenerated) {
        this.addDeclaration(id, typeName, line, inspectable, topLevel, idIsAutogenerated, null);
    }

    public final void addDeclaration(String id, String typeName, int line, boolean inspectable, boolean topLevel, boolean idIsAutogenerated, String comment) {
        if (!this.inheritedPropertyUsageError(id, this.root.getType().getTypeTable().getType(NameFormatter.toColon(typeName)), line)) {
            this.declarations.put(id, new UninitializedPropertyDeclaration(id, typeName, line, inspectable, topLevel, idIsAutogenerated, comment));
        }
    }

    public final PropertyDeclaration getDeclaration(String id) {
        return this.declarations.get(id);
    }

    public final void addStateSpecificEventInitializer(EventInitializer initializer) {
        if (!initializer.getHandlerText().equals("@Clear()")) {
            this.statefulEventInitializers.add(initializer);
        }
    }

    public final void ensureDeclaration(Model model) {
        if (!this.isDeclared(model)) {
            this.addDeclaration(model, false);
        }
    }

    public final boolean isDeclared(Model model) {
        String id = model.getId();
        return id != null && this.isDeclared(id);
    }

    public final boolean isDeclared(String id) {
        return this.declarations.containsKey(id);
    }

    public boolean showDeprecationWarnings() {
        return this.showDeprecationWarnings;
    }

    public final Iterator<PropertyDeclaration> getDeclarationIterator() {
        final Type superType = this.getSuperClass();
        return new FilterIterator(this.declarations.values().iterator(), new Predicate(){

            public boolean evaluate(Object object) {
                return superType.getProperty(((PropertyDeclaration)object).getName()) == null;
            }
        });
    }

    private final Iterator<PropertyDeclaration> getTopLevelDeclarationIterator() {
        return new FilterIterator(this.declarations.values().iterator(), new Predicate(){

            public boolean evaluate(Object object) {
                return ((PropertyDeclaration)object).getTopLevel();
            }
        });
    }

    public final Iterator<Initializer> getNonStagePropertyInitializerIterator() {
        return new FilterIterator((Iterator)new IteratorChain(this.root.getPropertyInitializerIterator(false), this.getTopLevelInitializerIterator()), new Predicate(){

            public boolean evaluate(Object object) {
                if (object instanceof NamedInitializer) {
                    return !StandardDefs.isStageProperty(((NamedInitializer)object).getName()) && !((NamedInitializer)object).isDesignLayer();
                }
                return true;
            }
        });
    }

    public final Iterator<Initializer> getDesignLayerPropertyInitializerIterator() {
        return new FilterIterator(this.layerDeclarations.iterator(), new Predicate(){

            public boolean evaluate(Object object) {
                return object instanceof InitializedPropertyDeclaration;
            }
        });
    }

    public final Iterator<Initializer> getStagePropertyInitializerIterator() {
        return new FilterIterator((Iterator)new IteratorChain(this.root.getPropertyInitializerIterator(false), this.getTopLevelInitializerIterator()), new Predicate(){

            public boolean evaluate(Object object) {
                if (object instanceof NamedInitializer) {
                    return StandardDefs.isStageProperty(((NamedInitializer)object).getName());
                }
                return false;
            }
        });
    }

    public final boolean getHasStagePropertyInitializers() {
        return this.getStagePropertyInitializerIterator().hasNext();
    }

    public final Iterator<Initializer> getTopLevelInitializerIterator() {
        return new FilterIterator(this.getTopLevelDeclarationIterator(), new Predicate(){

            public boolean evaluate(Object object) {
                return object instanceof InitializedPropertyDeclaration;
            }
        });
    }

    public final Iterator<Initializer> getPropertyInitializerIterator() {
        return new IteratorChain(this.root.getPropertyInitializerIterator(false), this.getTopLevelInitializerIterator());
    }

    public final Iterator<Initializer> getStatefulEventIterator() {
        return this.statefulEventInitializers.iterator();
    }

    public final Iterator getProceduralVisualChildInitializerIterator() {
        if (this.root instanceof MovieClip) {
            return new FilterIterator(((MovieClip)this.root).getChildInitializerIterator(), new Predicate(){

                public boolean evaluate(Object object) {
                    ValueInitializer init = (ValueInitializer)object;
                    Object value = init.getValue();
                    return !(value instanceof Model) || !((Model)value).isDescribed() && !((Model)value).isStateSpecific();
                }
            });
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public final boolean getDescribeVisualChildren() {
        return true;
    }

    public final Iterator<CodeFragmentList> getDefinitionIterator() {
        IteratorList iterList = new IteratorList();
        Model.addDefinitionIterators(iterList, this.getTopLevelInitializerIterator());
        Iterator iter = this.statefulEventInitializers.iterator();
        while (iter.hasNext()) {
            iterList.add(((Initializer)iter.next()).getDefinitionsIterator());
        }
        iterList.add(this.root.getSubDefinitionsIterator());
        if (this.getVersion() >= 4) {
            iterList.add(this.statesModel.getSubDefinitionIterators());
        }
        return iterList.toIterator();
    }

    public final void addBindingExpression(BindingExpression expr) {
        expr.setId(this.bindingExpressions.size());
        this.bindingExpressions.add(expr);
        this.info.addInterfaceName(this.standardDefs.INTERFACE_IBINDINGCLIENT_DOT, -1);
    }

    public final List<BindingExpression> getBindingExpressions() {
        return this.bindingExpressions;
    }

    public final void addAtEmbed(AtEmbed atEmbed) {
        if (!this.atEmbeds.containsKey(atEmbed.getPropName())) {
            this.atEmbeds.put(atEmbed.getPropName(), atEmbed);
        }
    }

    public final Set<AtEmbed> getAtEmbeds() {
        HashSet<AtEmbed> result = new HashSet<AtEmbed>(this.atEmbeds.values());
        if (this.stylesContainer != null) {
            result.addAll(this.stylesContainer.getAtEmbeds());
        }
        return result;
    }

    public final boolean addAtResource(AtResource atResource) {
        this.addImport(this.standardDefs.CLASS_RESOURCEMANAGER_DOT, atResource.getXmlLineNumber());
        this.atResources.put(atResource.getBundle(), atResource);
        return true;
    }

    public final Collection<AtResource> getAtResources() {
        return this.atResources.values();
    }

    public final void addTypeRef(String typeRef, int line) {
        this.addImport(typeRef, line);
        this.typeRefs.add(typeRef);
    }

    public final Collection<String> getTypeRefs() {
        return this.typeRefs;
    }

    public final void addImport(String name, int line) {
        this.info.addImportName(name, line);
    }

    public final Set<DocumentInfo.NameInfo> getImports() {
        this.ensureBindingImports();
        return this.info.getImportNames();
    }

    public final Collection<String[]> getSplitImports() {
        return this.info.getSplitImportNames();
    }

    private final void ensureBindingImports() {
        if (!this.bindingImportsAdded) {
            for (BindingExpression expr : this.bindingExpressions) {
                this.addImport(expr.getDestinationTypeName(false), expr.getXmlLineNumber());
            }
            this.bindingImportsAdded = true;
        }
    }

    public final void addScript(Script script) {
        this.info.addScript(script);
    }

    public final List<Script> getScripts() {
        return this.info.getScripts();
    }

    public String getLocalClass(String namespace, String localPart) {
        return this.info.getLocalClass(namespace, localPart);
    }

    public final void addMetadata(Script metaDataSource) {
        String text = metaDataSource.getText();
        assert (text != null);
        if (!text.startsWith("[")) {
            this.info.getMetadata().add(0, metaDataSource);
        } else {
            this.info.addMetadata(metaDataSource);
        }
    }

    public final List<Script> getMetadata() {
        return this.info.getMetadata();
    }

    public StylesContainer getStylesContainer() {
        return this.stylesContainer;
    }

    public Iterator getInheritingStyleNameIterator() {
        final Styles styles = this.typeTable.getStyles();
        return new FilterIterator(styles.getStyleNames(), new Predicate(){

            public boolean evaluate(Object obj) {
                return styles.isInheritingStyle((String)obj);
            }
        });
    }

    public boolean getIsContainer() {
        return this.standardDefs.isContainer(this.root.getType());
    }

    public boolean getIsIUIComponent() {
        return this.standardDefs.isIUIComponent(this.root.getType());
    }

    public boolean getIsFlexApplication() {
        return this.getIsMain() && (this.getIsContainer() || this.getVersion() >= 4 && this.getIsSimpleStyleComponent());
    }

    public boolean getIsSimpleStyleComponent() {
        return this.standardDefs.isSimpleStyleComponent(this.root.getType());
    }

    public final void setLineNumberMap(DualModeLineNumberMap lineNumberMap) {
        this.lineNumberMap = lineNumberMap;
    }

    public final DualModeLineNumberMap getLineNumberMap() {
        return this.lineNumberMap;
    }

    public final void setPreloader(String preloader) {
        this.preloader = preloader;
    }

    public final String getPreloader() {
        return this.preloader;
    }

    public void setUsePreloader(boolean usePreloader) {
        this.usePreloader = usePreloader;
    }

    public final boolean getUsePreloader() {
        return this.usePreloader;
    }

    public String getLanguageNamespace() {
        return this.info.getLanguageNamespace();
    }

    public int getVersion() {
        return this.info.getVersion();
    }

    public final boolean superHasPublicProperty(String name) {
        return this.getSuperClass().getProperty(name) != null;
    }

    void ensureId(Model model) {
        if (model.getId() == null) {
            Type type = model.getType();
            assert (type != null);
            int i = this.getAnonIndex(model.getType());
            String id = "_" + NameFormatter.toDot(this.info.getClassName()).replace('.', '_') + "_" + NameFormatter.retrieveClassName(type.getName().replace('<', '_').replace('>', '_')) + i;
            model.setId(id, true);
        }
    }

    private int getAnonIndex(Type type) {
        String typeName = NameFormatter.retrieveClassName(type.getName());
        Integer cell = this.anonIdCounts.get(typeName);
        int i = cell == null ? 1 : cell;
        this.anonIdCounts.put(typeName, new Integer(i + 1));
        return i;
    }

    public void resolveTwoWayBindings() {
        this.completeTwoWayBindings();
        HashMap<String, BindingExpression> destinationMap = new HashMap<String, BindingExpression>();
        for (BindingExpression bindingExpression : this.bindingExpressions) {
            String sourceExpression = TextGen.stripParens(bindingExpression.getSourceExpression());
            String destinationPath = bindingExpression.getDestinationPath(false);
            BindingExpression match = (BindingExpression)destinationMap.get(sourceExpression);
            if (match != null && destinationPath.equals(TextGen.stripParens(match.getSourceExpression()))) {
                bindingExpression.setTwoWayCounterpart(match);
                continue;
            }
            destinationMap.put(destinationPath, bindingExpression);
        }
    }

    private void completeTwoWayBindings() {
        Object[] bindingExpressionsArray = this.bindingExpressions.toArray();
        for (int i = 0; i < bindingExpressionsArray.length; ++i) {
            BindingExpression bindingExpression = (BindingExpression)bindingExpressionsArray[i];
            if (!bindingExpression.isConstructTwoWay()) continue;
            String source2 = bindingExpression.getDestinationPath(false);
            BindingExpression bindingExpression2 = new BindingExpression(source2, bindingExpression.getXmlLineNumber(), this);
            String destination2 = TextGen.stripParens(bindingExpression.getSourceExpression());
            bindingExpression2.setDestinationProperty(destination2);
            bindingExpression2.setDestinationLValue(destination2);
            bindingExpression.setConstructTwoWay(false);
        }
    }

    public Map<Integer, String> getAllBindingNamespaces() {
        HashMap<Integer, String> allNs = new HashMap<Integer, String>();
        for (BindingExpression be : this.bindingExpressions) {
            if (be.getNamespaces() == null) continue;
            allNs.putAll(be.getNamespaces());
        }
        return allNs;
    }

    public boolean hasBindingTags() {
        boolean result = false;
        for (BindingExpression bindingExpression : this.getBindingExpressions()) {
            if (bindingExpression.getDestination() != null) continue;
            result = true;
            break;
        }
        return result;
    }

    public String getAllBindingNamespaceDeclarations() {
        return BindingExpression.getNamespaceDeclarations(this.getAllBindingNamespaces());
    }

    public void postProcessStates() {
        this.statesModel.applyMetadata();
        if (this.statesModel.processReparents()) {
            this.statesModel.processStatefulModels();
            this.statesModel.setInitialState();
        }
    }

    public String getInterfaceList() {
        ArrayList<String> names = new ArrayList<String>(this.info.getInterfaceNames().size());
        Iterator<DocumentInfo.NameInfo> i = this.info.getInterfaceNames().iterator();
        while (i.hasNext()) {
            names.add(i.next().getName());
        }
        return TextGen.toCommaList(names.iterator());
    }

    public Set<DocumentInfo.NameInfo> getInterfaceNames() {
        return this.info.getInterfaceNames();
    }

    public String getWatcherSetupUtilClassName() {
        StringBuilder stringBuffer = new StringBuilder("_");
        String packageName = this.getPackageName();
        if (packageName != null && packageName.length() > 0) {
            stringBuffer.append(packageName.replace('.', '_'));
            stringBuffer.append("_");
        }
        stringBuffer.append(this.getClassName());
        stringBuffer.append("WatcherSetupUtil");
        return stringBuffer.toString();
    }

    public CodeFragmentList getDescriptorDeclaration(String name) {
        CodeFragmentList fragList = DescriptorGenerator.getDescriptorInitializerFragments(this.getRoot(), FrameworkDefs.requiredTopLevelDescriptorProperties);
        fragList.add(0, "private var " + name + " : " + NameFormatter.toDot(this.standardDefs.CLASS_UICOMPONENTDESCRIPTOR) + " = ", 0);
        return fragList;
    }

    public CodeFragmentList getStatesDeclaration() {
        StatesGenerator generator = new StatesGenerator(this.standardDefs);
        return this.getVersion() >= 4 ? generator.getStatesInitializerFragments(this.statesModel) : new CodeFragmentList();
    }

    private final boolean inheritedPropertyUsageError(String name, Type type, int line) {
        assert (this.root != null) : "root null in checkInherited";
        Property prop = this.root.getType().getProperty(name);
        if (prop != null) {
            if (!prop.hasPublic()) {
                ThreadLocalToolkit.log((CompilerMessage)new NonPublicInheritedPropertyInit(name), this.getSourcePath(), line);
                return true;
            }
            if (prop.readOnly()) {
                ThreadLocalToolkit.log((CompilerMessage)new ReadOnlyInheritedPropertyInit(name), this.getSourcePath(), line);
                return true;
            }
            if (!type.isAssignableTo(prop.getType())) {
                ThreadLocalToolkit.log((CompilerMessage)new TypeIncompatibleInheritedPropertyInit(name, NameFormatter.toDot(prop.getType().getName()), NameFormatter.toDot(type.getName())), this.getSourcePath(), line);
                return true;
            }
        }
        return false;
    }

    private final boolean unresolvedStateIdentifier(Collection states, int line) {
        for (String state : states) {
            if (this.validateState(state, line)) continue;
            return true;
        }
        return false;
    }

    public boolean validateState(String state, int line) {
        if (!this.statesModel.validateState(state)) {
            ThreadLocalToolkit.log((CompilerMessage)new StateResolutionError(state), this.getSourcePath(), line);
            return false;
        }
        return true;
    }

    public boolean validateStateFilters(Collection include, Collection exclude, int line) {
        if (!include.isEmpty() && !exclude.isEmpty()) {
            ThreadLocalToolkit.log((CompilerMessage)new AmbiguousStateFilterError(), this.getSourcePath(), line);
            return false;
        }
        return !this.unresolvedStateIdentifier(include, line) && !this.unresolvedStateIdentifier(exclude, line);
    }

    public List<DesignLayerNode> getLayerDeclarationNodes() {
        return this.info.getRootNode().layerDeclarationNodes;
    }

    public static List<VariableDeclaration> getBindingManagementVars() {
        return FrameworkDefs.bindingManagementVars;
    }

    public void registerStateSpecificNode(Model model, Node node, Collection<String> includedStates, Collection<String> excludedStates) {
        if (this.validateStateFilters(includedStates, excludedStates, model.getXmlLineNumber())) {
            this.statesModel.registerStateSpecificNode(model, node, includedStates, excludedStates);
        }
    }

    public void registerStateSpecificProperty(Model model, String property, ValueInitializer value, String stateName) {
        this.statesModel.registerStateSpecificProperty(model, property, value, stateName);
    }

    public void registerStateSpecificStyle(Model model, String property, ValueInitializer value, String stateName) {
        this.statesModel.registerStateSpecificStyle(model, property, value, stateName);
    }

    public void registerStateSpecificEventHandler(Model model, String event, EventInitializer value, String stateName) {
        this.statesModel.registerStateSpecificEventHandler(model, event, value, stateName);
    }

    public void registerState(Model model, Node node) {
        this.statesModel.registerState(model, node);
    }

    public StatesModel getStatefulModel() {
        return this.statesModel;
    }

    public void registerEarlyInitNode(Model model) {
        this.statesModel.registerEarlyInitNode(model);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public static class AmbiguousStateFilterError
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 6642005101532059046L;
    }

    public static class StateResolutionError
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -7520940017001772178L;
        public String name;

        public StateResolutionError(String name) {
            this.name = name;
        }
    }

    public static class TypeIncompatibleInheritedPropertyInit
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -6205552750667618804L;
        public String name;
        public String propertyType;
        public String valueType;

        public TypeIncompatibleInheritedPropertyInit(String name, String propertyType, String valueType) {
            this.name = name;
            this.propertyType = propertyType;
            this.valueType = valueType;
        }
    }

    public static class ReadOnlyInheritedPropertyInit
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -2959436790426946620L;
        public String name;

        public ReadOnlyInheritedPropertyInit(String name) {
            this.name = name;
        }
    }

    public static class NonPublicInheritedPropertyInit
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 9044603625972071302L;
        public String name;

        public NonPublicInheritedPropertyInit(String name) {
            this.name = name;
        }
    }
}

