/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.rep;

import flex2.compiler.as3.AbstractSyntaxTreeUtil;
import flex2.compiler.mxml.builder.AbstractBuilder;
import flex2.compiler.mxml.reflect.Property;
import flex2.compiler.mxml.reflect.Style;
import flex2.compiler.mxml.reflect.Type;
import flex2.compiler.mxml.rep.AnonymousObjectGraph;
import flex2.compiler.mxml.rep.Model;
import flex2.compiler.mxml.rep.MxmlDocument;
import flex2.compiler.mxml.rep.XML;
import flex2.compiler.util.NameFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import macromedia.asc.parser.ArgumentListNode;
import macromedia.asc.parser.CallExpressionNode;
import macromedia.asc.parser.GetExpressionNode;
import macromedia.asc.parser.IdentifierNode;
import macromedia.asc.parser.LiteralStringNode;
import macromedia.asc.parser.MemberExpressionNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.NodeFactory;
import macromedia.asc.parser.SelectorNode;
import macromedia.asc.parser.SetExpressionNode;
import macromedia.asc.parser.StatementListNode;
import macromedia.asc.parser.ThisExpressionNode;
import macromedia.asc.parser.VariableDefinitionNode;
import macromedia.asc.util.Context;
import macromedia.asc.util.IntegerPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingExpression
implements Comparable<BindingExpression> {
    private String sourceExpression;
    private Model destination;
    private String destinationProperty;
    private String destinationStyle;
    private boolean arrayAccess = false;
    private String destinationLValue;
    private int id;
    private boolean isDestinationXMLAttribute;
    private boolean isDestinationXMLNode;
    private boolean isDestinationE4X;
    private boolean isDestinationObjectProxy;
    private boolean isFromBindingNode;
    private boolean isConstructTwoWay;
    public int xmlLineNumber;
    private MxmlDocument mxmlDocument;
    private BindingExpression twoWayCounterpart;
    private Map<Integer, String> namespaces;
    private String sourceAsProperty;
    private static final String NODE_VALUE = "nodeValue".intern();
    private static final String SET_STYLE = "setStyle".intern();
    private static final String _SOURCE_FUNCTION_RETURN_VALUE = "_sourceFunctionReturnValue".intern();
    private static final String NAMESPACE = "Namespace".intern();

    public BindingExpression(String bindingExpression, int xmlLineNumber, MxmlDocument mxmlDocument) {
        this.sourceExpression = bindingExpression;
        this.xmlLineNumber = xmlLineNumber;
        assert (mxmlDocument != null);
        this.setMxmlDocument(mxmlDocument);
    }

    @Override
    public int compareTo(BindingExpression bindingExpression) {
        int result = 0;
        if (this.id < bindingExpression.id) {
            result = -1;
        } else if (this.id > bindingExpression.id) {
            result = 1;
        }
        return result;
    }

    private void ensureHighestLevelModelDeclared(Model model) {
        if (!(model instanceof XML || model instanceof AnonymousObjectGraph || model.equals(this.mxmlDocument.getRoot()) || model.getId() == null)) {
            this.mxmlDocument.ensureDeclaration(model);
        }
    }

    public boolean equals(Object object) {
        boolean result = false;
        if (object instanceof BindingExpression) {
            BindingExpression bindingExpression = (BindingExpression)object;
            if (bindingExpression.id == this.id) {
                result = true;
            }
        }
        return result;
    }

    public void setMxmlDocument(MxmlDocument mxmlDocument) {
        this.mxmlDocument = mxmlDocument;
        mxmlDocument.addBindingExpression(this);
    }

    public boolean isDestinationXMLAttribute() {
        return this.isDestinationXMLAttribute;
    }

    public boolean isDestinationXMLNode() {
        return this.isDestinationXMLNode;
    }

    public boolean isDestinationE4X() {
        return this.isDestinationE4X;
    }

    public boolean isDestinationObjectProxy() {
        return this.isDestinationObjectProxy;
    }

    public String getSourceAsProperty() {
        return this.sourceAsProperty;
    }

    public boolean isDestinationNonPublicProperty() {
        Type type;
        Property property;
        boolean result = false;
        if (!(this.destination == null || this.destinationProperty == null || this.destinationStyle != null || this.isArrayAccess() || this.isDestinationXMLAttribute || this.isDestinationXMLNode || (property = (type = this.destination.getType()).getProperty(this.destinationProperty)) == null || property.hasPublic())) {
            result = true;
        }
        return result;
    }

    public boolean isSourcePublicProperty() {
        Property property;
        String potentialProperty = this.sourceExpression.startsWith("(") && this.sourceExpression.endsWith(")") ? this.sourceExpression.substring(1, this.sourceExpression.length() - 1) : this.sourceExpression;
        Type skeletonClass = this.mxmlDocument.getSkeletonClass();
        boolean result = false;
        if (potentialProperty.indexOf(":") == -1 && (property = skeletonClass.getProperty("", potentialProperty)) != null && property.hasPublic()) {
            result = true;
            this.sourceAsProperty = potentialProperty;
            if (this.mxmlDocument.showDeprecationWarnings()) {
                AbstractBuilder.checkDeprecation(property, this.mxmlDocument.getSourcePath(), this.xmlLineNumber);
            }
        }
        return result;
    }

    public MemberExpressionNode generateDestinationAssignment(NodeFactory nodeFactory, String rvalue) {
        Node base = null;
        if (!this.isDestinationXMLAttribute && !this.isDestinationXMLNode) {
            base = this.generateDestinationPathRoot(nodeFactory, false);
        }
        IdentifierNode identifier = null;
        if (this.destinationLValue != null) {
            identifier = nodeFactory.identifier(this.destinationLValue);
        } else if (this.destinationProperty != null) {
            identifier = nodeFactory.identifier(this.destinationProperty);
        } else if (this.destinationStyle != null) {
            identifier = nodeFactory.identifier(this.destinationStyle);
        }
        assert (identifier != null);
        if (this.isDestinationXMLNode && !this.isDestinationE4X) {
            GetExpressionNode getExpression = nodeFactory.getExpression(identifier);
            base = nodeFactory.memberExpression(base, (SelectorNode)getExpression);
            identifier = nodeFactory.identifier(NODE_VALUE, false);
        }
        MemberExpressionNode memberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, rvalue, true);
        ArgumentListNode argumentList = nodeFactory.argumentList(null, (Node)memberExpression);
        SetExpressionNode selector = nodeFactory.setExpression((Node)identifier, argumentList, false);
        if (!(this.destination == null || this.destinationProperty == null && this.destinationStyle == null || this.isArrayAccess() || this.isDestinationXMLAttribute || this.isDestinationXMLNode)) {
            selector.setMode(-18);
        } else if (this.isArrayAccess()) {
            selector.setMode(-29);
        }
        return nodeFactory.memberExpression(base, (SelectorNode)selector);
    }

    public MemberExpressionNode generateDestinationSetStyle(NodeFactory nodeFactory, String rvalue) {
        Node base = null;
        if (!this.isDestinationXMLAttribute && !this.isDestinationXMLNode) {
            base = this.generateDestinationPathRoot(nodeFactory, false);
        }
        IdentifierNode identifier = nodeFactory.identifier(SET_STYLE, false);
        LiteralStringNode literalString = nodeFactory.literalString(this.destinationStyle);
        ArgumentListNode argumentList = nodeFactory.argumentList(null, (Node)literalString);
        MemberExpressionNode memberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, _SOURCE_FUNCTION_RETURN_VALUE, false);
        argumentList = nodeFactory.argumentList(argumentList, (Node)memberExpression);
        CallExpressionNode selector = (CallExpressionNode)nodeFactory.callExpression((Node)identifier, argumentList);
        selector.setRValue(false);
        return nodeFactory.memberExpression(base, (SelectorNode)selector);
    }

    private Stack<Model> generateDestinationStack() {
        Stack<Model> destinationStack = new Stack<Model>();
        for (Model model = this.destination; model != null; model = model.getParent()) {
            destinationStack.push(model);
            if (model.getId() != null && !model.getIsAnonymous()) break;
        }
        return destinationStack;
    }

    public String getDestinationPath(boolean doXML) {
        StringBuilder buffer = new StringBuilder();
        if (this.isDestinationE4X) {
            doXML = true;
        }
        if (!doXML || !this.isDestinationXMLAttribute && !this.isDestinationXMLNode) {
            buffer.append(this.getDestinationPathRoot(false));
        }
        if (!(this.destination == null || this.destinationProperty == null && this.destinationStyle == null || this.isArrayAccess() || doXML && (this.isDestinationXMLAttribute || this.isDestinationXMLNode))) {
            buffer.append(".");
        }
        if (this.isArrayAccess()) {
            buffer.append("[");
        }
        if ((doXML || !this.isDestinationXMLAttribute && !this.isDestinationXMLNode) && this.destinationLValue != null) {
            buffer.append(this.destinationLValue);
        } else if (this.destinationProperty != null) {
            buffer.append(this.destinationProperty);
        } else if (this.destinationStyle != null) {
            buffer.append(this.destinationStyle);
        }
        if (doXML && this.isDestinationXMLNode && !this.isDestinationE4X) {
            buffer.append(".nodeValue");
        } else if (this.isArrayAccess()) {
            buffer.append("]");
        }
        return buffer.toString();
    }

    public String getDestinationPathRoot(boolean doRepeatable) {
        if (this.destination == null) {
            return "";
        }
        StringBuilder destinationRoot = new StringBuilder();
        Stack<Model> destinationStack = this.generateDestinationStack();
        Model model = destinationStack.peek();
        this.ensureHighestLevelModelDeclared(model);
        boolean writeRepeaterIndices = doRepeatable;
        while (!destinationStack.isEmpty()) {
            Model child;
            model = destinationStack.pop();
            if (model.equals(this.mxmlDocument.getRoot())) {
                destinationRoot.append("this");
            } else {
                String parentIndex = model.getParentIndex();
                if (parentIndex != null && destinationRoot.length() > 0) {
                    destinationRoot.append("[");
                    destinationRoot.append(parentIndex);
                    destinationRoot.append("]");
                } else {
                    String id = model.getId();
                    if (id != null) {
                        if (!model.getIsAnonymous()) {
                            this.mxmlDocument.ensureDeclaration(model);
                        }
                        destinationRoot.append(id);
                    }
                }
            }
            if (writeRepeaterIndices && this.isRepeatable()) {
                for (int i = 0; i < model.getRepeaterLevel(); ++i) {
                    destinationRoot.append("[instanceIndices[");
                    destinationRoot.append(i);
                    destinationRoot.append("]]");
                }
                writeRepeaterIndices = false;
            }
            if (destinationStack.isEmpty() || (child = destinationStack.peek()).getParentIndex() != null) continue;
            destinationRoot.append(".");
        }
        return destinationRoot.toString();
    }

    public Node generateDestinationPathRoot(NodeFactory nodeFactory, boolean doRepeatable) {
        ThisExpressionNode result = null;
        if (this.destination != null) {
            Stack<Model> destinationStack = this.generateDestinationStack();
            Model model = destinationStack.peek();
            this.ensureHighestLevelModelDeclared(model);
            boolean writeRepeaterIndices = doRepeatable;
            while (!destinationStack.isEmpty()) {
                Model child;
                model = destinationStack.pop();
                if (model.equals(this.mxmlDocument.getRoot())) {
                    result = nodeFactory.thisExpression(-1);
                } else {
                    String parentIndex = model.getParentIndex();
                    if (parentIndex != null && result != null) {
                        assert (false);
                    } else {
                        String id = model.getId();
                        if (id != null) {
                            if (!model.getIsAnonymous()) {
                                this.mxmlDocument.ensureDeclaration(model);
                            }
                            if (result == null) {
                                result = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, id, true);
                            } else assert (false);
                        }
                    }
                }
                if (writeRepeaterIndices && this.isRepeatable()) {
                    for (int i = 0; i < model.getRepeaterLevel(); ++i) {
                        assert (false);
                    }
                    writeRepeaterIndices = false;
                }
                if (!destinationStack.isEmpty() && (child = destinationStack.peek()).getParentIndex() == null) assert (false);
            }
        }
        return result;
    }

    public String getDestinationTypeName(boolean includeElementType) {
        Type type = null;
        Type elementType = null;
        if (this.destination != null && !(this.destination instanceof AnonymousObjectGraph) && !(this.destination instanceof XML)) {
            Type destinationType;
            if (this.destinationProperty != null) {
                Property property;
                destinationType = this.destination.getType();
                if (!destinationType.getName().equals(this.mxmlDocument.getStandardDefs().CLASS_OBJECTPROXY) && (property = destinationType.getProperty(this.destinationProperty)) != null && (type = property.getType()).equals(this.mxmlDocument.getTypeTable().vectorType)) {
                    elementType = property.getElementType();
                }
            } else if (this.destinationStyle != null) {
                destinationType = this.destination.getType();
                Style style = destinationType.getStyle(this.destinationStyle);
                if (style != null) {
                    type = style.getType();
                }
            } else {
                type = this.destination.getType();
            }
        }
        String result = "*";
        if (type != null) {
            result = NameFormatter.toDot(type.getName());
            if (includeElementType && elementType != null) {
                result = result + ".<" + NameFormatter.toDot(elementType.getName()) + ">";
            }
        }
        return result;
    }

    public int getId() {
        return this.id;
    }

    public String getRepeatableSourceExpression() {
        String repeatableSourceExpression = this.sourceExpression;
        List<Model> repeaterParents = this.destination.getRepeaterParents();
        for (Model repeater : repeaterParents) {
            int i;
            int repeaterLevel = repeater.getRepeaterLevel();
            StringBuilder buffer = new StringBuilder();
            for (i = 0; i < repeaterLevel; ++i) {
                buffer.append("[instanceIndices[");
                buffer.append(i);
                buffer.append("]]");
            }
            buffer.append(".mx_internal::getItemAt(repeaterIndices[");
            buffer.append(i);
            buffer.append("])");
            repeatableSourceExpression = repeatableSourceExpression.replaceAll(repeater.getId() + "\\.currentItem", repeater.getId() + buffer.toString());
            repeatableSourceExpression = repeatableSourceExpression.replaceAll(repeater.getId() + "\\.currentIndex", "repeaterIndices[" + i + "]");
        }
        return repeatableSourceExpression;
    }

    public String getSourceExpression() {
        return this.sourceExpression;
    }

    public void setDestinationProperty(String destinationProperty) {
        this.destinationProperty = destinationProperty;
    }

    public void setDestinationProperty(int destinationProperty) {
        this.destinationProperty = Integer.toString(destinationProperty);
        this.arrayAccess = true;
    }

    public void setDestinationStyle(String destinationStyle) {
        this.destinationStyle = destinationStyle;
    }

    public String getDestinationStyle() {
        return this.destinationStyle;
    }

    public boolean isSimpleChain() {
        return !this.isFromBindingNode() && !this.isStyle() && !this.isDestinationObjectProxy() && this.getNamespaceDeclarations().equals("") && this.twoWayCounterpart == null && this.getDestinationPath(false).indexOf("[") == -1;
    }

    public boolean isStyle() {
        return this.destinationStyle != null;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setDestinationXMLAttribute(boolean isDestinationXMLAttribute) {
        this.isDestinationXMLAttribute = isDestinationXMLAttribute;
    }

    public void setDestinationXMLNode(boolean isDestinationXMLNode) {
        this.isDestinationXMLNode = isDestinationXMLNode;
    }

    public void setDestinationE4X(boolean isDestinationE4X) {
        this.isDestinationE4X = isDestinationE4X;
    }

    public void setDestinationObjectProxy(boolean isDestinationObjectProxy) {
        this.isDestinationObjectProxy = isDestinationObjectProxy;
    }

    public String getDestinationProperty() {
        return this.destinationProperty;
    }

    public boolean isArrayAccess() {
        return this.arrayAccess;
    }

    public String getDestinationLValue() {
        return this.destinationLValue;
    }

    public void setDestinationLValue(String lvalue) {
        this.destinationLValue = lvalue;
    }

    public Model getDestination() {
        return this.destination;
    }

    public void setDestination(Model destination) {
        this.destination = destination;
        if (this.xmlLineNumber == 0) {
            this.xmlLineNumber = destination.getXmlLineNumber();
        }
    }

    public boolean isRepeatable() {
        return this.destination != null && this.destination.getRepeaterLevel() > 0;
    }

    public int getRepeaterLevel(String var) {
        if (var.indexOf("[repeaterIndices") > -1) {
            var = var.substring(0, var.indexOf("["));
        }
        int repeaterLevel = -1;
        if (this.destination != null) {
            Model r;
            List<Model> repeaters = this.destination.getRepeaterParents();
            for (repeaterLevel = repeaters.size() - 1; repeaterLevel >= 0 && !var.equals((r = repeaters.get(repeaterLevel)).getId()); --repeaterLevel) {
            }
        }
        return repeaterLevel;
    }

    public String getRepeaterId(int level) {
        Model repeater = this.destination.getRepeaterParents().get(level);
        return repeater.getId();
    }

    public BindingExpression getTwoWayCounterpart() {
        return this.twoWayCounterpart;
    }

    public void setTwoWayCounterpart(BindingExpression twoWayCounterpart) {
        this.twoWayCounterpart = twoWayCounterpart;
    }

    public int getXmlLineNumber() {
        return this.xmlLineNumber;
    }

    public void addNamespace(String nsUri, int i) {
        if (this.namespaces == null) {
            this.namespaces = new HashMap<Integer, String>();
        }
        this.namespaces.put(IntegerPool.getNumber((int)i), nsUri);
    }

    public Map<Integer, String> getNamespaces() {
        return this.namespaces;
    }

    public static String getAllBindingNamespaceDeclarations(List<BindingExpression> bindingExpressions) {
        HashMap<Integer, String> allNs = new HashMap<Integer, String>();
        for (BindingExpression be : bindingExpressions) {
            allNs.putAll(be.getNamespaces());
        }
        return BindingExpression.getNamespaceDeclarations(allNs);
    }

    public static String getNamespaceDeclarations(Map<Integer, String> namespaceMap) {
        if (namespaceMap != null) {
            StringBuilder b = new StringBuilder();
            for (Integer key : namespaceMap.keySet()) {
                int k = key;
                String uri = namespaceMap.get(key);
                b.append("var ns").append(k).append(":Namespace = new Namespace(\"").append(uri).append("\");\n");
            }
            return b.toString();
        }
        return "";
    }

    public String getNamespaceDeclarations() {
        return BindingExpression.getNamespaceDeclarations(this.namespaces);
    }

    public StatementListNode generateNamespaceDeclarations(Context context, StatementListNode statementList) {
        return BindingExpression.generateNamespaceDeclarations(this.namespaces, context, statementList);
    }

    public static StatementListNode generateNamespaceDeclarations(Map<Integer, String> map, Context context, StatementListNode statementList) {
        StatementListNode result = statementList;
        if (map != null) {
            NodeFactory nodeFactory = context.getNodeFactory();
            for (Integer key : map.keySet()) {
                String uri = map.get(key);
                IdentifierNode identifier = nodeFactory.identifier(NAMESPACE, false);
                LiteralStringNode literalString = nodeFactory.literalString(uri);
                ArgumentListNode argumentList = nodeFactory.argumentList(null, (Node)literalString);
                CallExpressionNode callExpression = (CallExpressionNode)nodeFactory.callExpression((Node)identifier, argumentList);
                callExpression.is_new = true;
                callExpression.setRValue(false);
                MemberExpressionNode initializer = nodeFactory.memberExpression(null, (SelectorNode)callExpression);
                int k = key;
                VariableDefinitionNode variableDefinition = AbstractSyntaxTreeUtil.generateVariable(nodeFactory, ("ns" + k).intern(), NAMESPACE, false, (Node)initializer);
                result = nodeFactory.statementList(result, (Node)variableDefinition);
            }
        }
        return result;
    }

    public boolean isFromBindingNode() {
        return this.isFromBindingNode;
    }

    public void setFromBindingNode(boolean isFromBindingNode) {
        this.isFromBindingNode = isFromBindingNode;
    }

    public boolean isConstructTwoWay() {
        return this.isConstructTwoWay;
    }

    public void setConstructTwoWay(boolean isContructTwoWay) {
        this.isConstructTwoWay = isContructTwoWay;
    }
}

