/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.gen;

import flex2.compiler.mxml.gen.CodeFragmentList;
import flex2.compiler.mxml.gen.TextGen;
import flex2.compiler.mxml.rep.Model;
import flex2.compiler.mxml.rep.MovieClip;
import flex2.compiler.mxml.rep.init.EventInitializer;
import flex2.compiler.mxml.rep.init.Initializer;
import flex2.compiler.mxml.rep.init.NamedInitializer;
import flex2.compiler.mxml.rep.init.VisualChildInitializer;
import flex2.compiler.util.NameFormatter;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.iterators.FilterIterator;

public class DescriptorGenerator {
    private static final String INDENT = "  ".intern();

    public static CodeFragmentList getDescriptorInitializerFragments(Model model, Set includePropNames) {
        CodeFragmentList list = new CodeFragmentList();
        DescriptorGenerator.addDescriptorInitializerFragments(list, model, "", includePropNames, true);
        return list;
    }

    public static void addDescriptorInitializerFragments(CodeFragmentList list, Model model, String indent) {
        DescriptorGenerator.addDescriptorInitializerFragments(list, model, indent, null, false);
    }

    private static void addDescriptorInitializerFragments(CodeFragmentList list, Model model, String indent, Set includePropNames, boolean propsOnly) {
        model.setDescribed(true);
        list.add(indent, "new ", NameFormatter.toDot(model.getStandardDefs().CLASS_UICOMPONENTDESCRIPTOR), "({", 0);
        indent = indent + INDENT;
        list.add(indent, "type: ", NameFormatter.toDot(model.getType().getName()), model.getXmlLineNumber());
        if (model.isDeclared()) {
            list.add(indent, ",", 0);
            list.add(indent, "id: ", TextGen.quoteWord(model.getId()), model.getXmlLineNumber());
        }
        if (!propsOnly) {
            DescriptorGenerator.addDescriptorEvents(list, model, indent);
        }
        if (!propsOnly) {
            DescriptorGenerator.addDescriptorEffectNames(list, model, indent);
        }
        if (!propsOnly) {
            DescriptorGenerator.addDescriptorStylesAndEffects(list, model, indent);
        }
        DescriptorGenerator.addDescriptorProperties(list, model, includePropNames, indent);
        indent = indent.substring(0, indent.length() - INDENT.length());
        list.add(indent, "})", 0);
    }

    private static void addDescriptorProperties(CodeFragmentList list, Model model, final Set includePropNames, String indent) {
        Iterator<Initializer> propIter = includePropNames == null ? model.getPropertyInitializerIterator(false) : new FilterIterator(model.getPropertyInitializerIterator(false), new Predicate(){

            public boolean evaluate(Object obj) {
                return includePropNames.contains(((NamedInitializer)obj).getName());
            }
        });
        Iterator vcIter = model instanceof MovieClip && ((MovieClip)model).hasChildren() ? ((MovieClip)model).children().iterator() : Collections.EMPTY_LIST.iterator();
        Boolean hasDesignLayer = model.layerParent != null && model.getType().isAssignableTo(model.getStandardDefs().INTERFACE_IVISUALELEMENT);
        if (propIter.hasNext() || vcIter.hasNext() || hasDesignLayer.booleanValue()) {
            if (!list.isEmpty()) {
                list.add(indent, ",", 0);
            }
            list.add(indent, "propertiesFactory: function():Object { return {", 0);
            indent = indent + INDENT;
            while (propIter.hasNext()) {
                NamedInitializer init = (NamedInitializer)propIter.next();
                if (init.isStateSpecific()) continue;
                list.add(indent, init.getName(), ": ", init.getValueExpr(), propIter.hasNext() || vcIter.hasNext() || hasDesignLayer != false ? "," : "", init.getLineRef());
            }
            if (hasDesignLayer.booleanValue()) {
                list.add(indent, "designLayer", ": ", model.layerParent.getId(), vcIter.hasNext() ? "," : "", model.getXmlLineNumber());
            }
            if (vcIter.hasNext()) {
                list.add(indent, "childDescriptors: [", 0);
                boolean isFirst = true;
                while (vcIter.hasNext()) {
                    VisualChildInitializer init = (VisualChildInitializer)vcIter.next();
                    MovieClip child = (MovieClip)init.getValue();
                    if (!child.isDescriptorInit()) continue;
                    if (!isFirst) {
                        list.add(indent, ",", 0);
                    }
                    DescriptorGenerator.addDescriptorInitializerFragments(list, child, indent + INDENT);
                    isFirst = false;
                }
                list.add(indent, "]", 0);
            }
            indent = indent.substring(0, indent.length() - INDENT.length());
            list.add(indent, "}}", 0);
        }
    }

    private static void addDescriptorStylesAndEffects(CodeFragmentList list, Model model, String indent) {
        Iterator styleAndEffectIter = model.getStyleAndEffectInitializerIterator();
        if (styleAndEffectIter.hasNext()) {
            if (!list.isEmpty()) {
                list.add(indent, ",", 0);
            }
            list.add(indent, "stylesFactory: function():void {", 0);
            indent = indent + INDENT;
            while (styleAndEffectIter.hasNext()) {
                NamedInitializer init = (NamedInitializer)styleAndEffectIter.next();
                list.add(indent, "this.", init.getName(), " = ", init.getValueExpr() + ";", init.getLineRef());
            }
            indent = indent.substring(0, indent.length() - INDENT.length());
            list.add(indent, "}", 0);
        }
    }

    private static void addDescriptorEffectNames(CodeFragmentList list, Model model, String indent) {
        String effectEventNames = model.getEffectNames();
        if (effectEventNames.length() > 0) {
            if (!list.isEmpty()) {
                list.add(indent, ",", 0);
            }
            list.add(indent, "effects: [ ", effectEventNames, " ]", model.getXmlLineNumber());
        }
    }

    private static void addDescriptorEvents(CodeFragmentList list, Model model, String indent) {
        Iterator<Initializer> eventIter = model.getEventInitializerIterator();
        if (eventIter.hasNext()) {
            if (!list.isEmpty()) {
                list.add(indent, ",", 0);
            }
            list.add(indent, "events: {", 0);
            indent = indent + INDENT;
            while (eventIter.hasNext()) {
                EventInitializer init = (EventInitializer)eventIter.next();
                list.add(indent, init.getName(), ": ", TextGen.quoteWord(init.getValueExpr()), eventIter.hasNext() ? "," : "", init.getLineRef());
            }
            indent = indent.substring(0, indent.length() - INDENT.length());
            list.add(indent, "}", 0);
        }
    }
}

