/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.fxg;

import com.adobe.fxg.dom.FXGNode;
import com.adobe.fxg.swf.FXG2SWFTranscoder;
import com.adobe.internal.fxg.dom.CDATANode;
import com.adobe.internal.fxg.dom.GraphicContentNode;
import com.adobe.internal.fxg.dom.RichTextNode;
import com.adobe.internal.fxg.dom.TextGraphicNode;
import com.adobe.internal.fxg.dom.TextNode;
import com.adobe.internal.fxg.dom.richtext.BRNode;
import com.adobe.internal.fxg.dom.richtext.DivNode;
import com.adobe.internal.fxg.dom.richtext.FormatNode;
import com.adobe.internal.fxg.dom.richtext.ImgNode;
import com.adobe.internal.fxg.dom.richtext.LinkActiveFormatNode;
import com.adobe.internal.fxg.dom.richtext.LinkHoverFormatNode;
import com.adobe.internal.fxg.dom.richtext.LinkNode;
import com.adobe.internal.fxg.dom.richtext.LinkNormalFormatNode;
import com.adobe.internal.fxg.dom.richtext.ParagraphNode;
import com.adobe.internal.fxg.dom.richtext.SpanNode;
import com.adobe.internal.fxg.dom.richtext.TCYNode;
import com.adobe.internal.fxg.dom.richtext.TabNode;
import flash.swf.tags.DefineSprite;
import flash.swf.tags.DefineTag;
import flash.swf.tags.PlaceObject;
import flash.util.StringUtils;
import flex2.compiler.fxg.FXGSymbolClass;
import flex2.compiler.fxg.FlexGraphicNode;
import flex2.compiler.mxml.lang.StandardDefs;
import flex2.compiler.mxml.reflect.Property;
import flex2.compiler.mxml.reflect.Type;
import flex2.compiler.mxml.reflect.TypeTable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlexFXG2SWFTranscoder
extends FXG2SWFTranscoder {
    private FXGSymbolClass graphicClass;
    private String packageName;
    private TypeTable typeTable;
    private Type divType;
    private Type formatType;
    private Type imgType;
    private Type linkType;
    private Type linkActiveType;
    private Type linkNormalType;
    private Type linkHoverType;
    private Type richTextType;
    private Type paragraphType;
    private Type spanType;
    private Type tabType;
    private Type tcyType;

    public FlexFXG2SWFTranscoder(TypeTable typeTable) {
        this.typeTable = typeTable;
        if (typeTable != null) {
            this.divType = typeTable.getType(StandardDefs.CLASS_TEXT_DIV);
            this.formatType = typeTable.getType(StandardDefs.CLASS_TEXT_FORMAT);
            this.linkType = typeTable.getType(StandardDefs.CLASS_TEXT_LINK);
            this.imgType = typeTable.getType(StandardDefs.CLASS_TEXT_IMG);
            this.linkActiveType = typeTable.getType(StandardDefs.CLASS_TEXT_LINK_ACTIVE_FORMAT);
            this.linkHoverType = typeTable.getType(StandardDefs.CLASS_TEXT_LINK_HOVER_FORMAT);
            this.linkNormalType = typeTable.getType(StandardDefs.CLASS_TEXT_LINK_NORMAL_FORMAT);
            this.richTextType = typeTable.getType(StandardDefs.CLASS_TEXT_RICHTEXT);
            this.paragraphType = typeTable.getType(StandardDefs.CLASS_TEXT_PARAGRAPH);
            this.spanType = typeTable.getType(StandardDefs.CLASS_TEXT_SPAN);
            this.tabType = typeTable.getType(StandardDefs.CLASS_TEXT_TAB);
            this.tcyType = typeTable.getType(StandardDefs.CLASS_TEXT_TCY);
        }
    }

    public FXGSymbolClass transcode(FXGNode node, String packageName, String className) {
        this.packageName = packageName;
        if (node instanceof FlexGraphicNode) {
            FlexGraphicNode graphicNode = (FlexGraphicNode)node;
            SourceContext context = new SourceContext(packageName, className);
            this.graphicClass = new FXGSymbolClass();
            this.graphicClass.setPackageName(context.packageName);
            this.graphicClass.setClassName(context.className);
            this.beginClass(context, false);
            DefineSprite sprite = (DefineSprite)this.transcode((FXGNode)graphicNode);
            this.graphicClass.setSymbol((DefineTag)sprite);
            this.generateConstructor(context, graphicNode.viewWidth, graphicNode.viewHeight);
            this.endClass(context);
            this.graphicClass.setGeneratedSource(context.getGeneratedSource());
            return this.graphicClass;
        }
        return null;
    }

    public FXG2SWFTranscoder newInstance() {
        FlexFXG2SWFTranscoder graphics = new FlexFXG2SWFTranscoder(this.typeTable);
        graphics.packageName = this.packageName;
        graphics.graphicClass = this.graphicClass;
        graphics.definitions = this.definitions;
        return graphics;
    }

    protected PlaceObject richtext(RichTextNode node) {
        return this.flexText((GraphicContentNode)node);
    }

    protected PlaceObject text(TextGraphicNode node) {
        return this.flexText((GraphicContentNode)node);
    }

    private PlaceObject flexText(GraphicContentNode node) {
        if (node instanceof TextNode) {
            TextNode textNode = (TextNode)node;
            String className = this.createUniqueClassName(this.graphicClass.getClassName() + "_Text");
            SourceContext context = new SourceContext(this.packageName, className);
            FXGSymbolClass spriteSymbolClass = new FXGSymbolClass();
            spriteSymbolClass.setPackageName(context.packageName);
            spriteSymbolClass.setClassName(context.className);
            this.beginClass(context, true);
            this.graphicClass.addAdditionalSymbolClass(spriteSymbolClass);
            DefineSprite textSprite = this.createDefineSprite(className);
            PlaceObject po3 = this.placeObject((DefineTag)textSprite, node.createGraphicContext());
            this.spriteStack.push(textSprite);
            StringBuilder textSource = this.generateRichText(textNode);
            this.generateTextInitFunction(textSource, context);
            this.generateConstructor(context, Double.NaN, Double.NaN);
            this.endClass(context);
            spriteSymbolClass.setGeneratedSource(context.getGeneratedSource());
            spriteSymbolClass.setSymbol((DefineTag)textSprite);
            this.spriteStack.pop();
            return po3;
        }
        return null;
    }

    private String createUniqueClassName(String baseName) {
        int r = random.nextInt();
        String suffix = Integer.toString(r);
        if (suffix.charAt(0) == '-') {
            suffix = suffix.replace('-', '_');
        }
        return baseName + suffix;
    }

    private void beginClass(SourceContext context, boolean hasTextGraphic) {
        StringBuilder buf = context.buffer;
        buf.append("package ").append(context.packageName).append("\n{\n\n");
        if (hasTextGraphic) {
            buf.append("import flashx.textLayout.elements.*;\n");
            buf.append("import flashx.textLayout.formats.TextLayoutFormat;\n");
            buf.append("import spark.components.RichText;\n");
        }
        buf.append("import spark.core.SpriteVisualElement;\n\n");
        buf.append("public class ").append(context.className).append(" extends SpriteVisualElement\n{\n");
    }

    private void endClass(SourceContext context) {
        StringBuilder buf = context.buffer;
        buf.append("\n}\n");
        buf.append("}\n");
    }

    private void generateConstructor(SourceContext context, double viewWidth, double viewHeight) {
        StringBuilder buf = context.buffer;
        buf.append("\n\tpublic function " + context.className + "()\n\t{\n");
        buf.append("\t\tsuper();\n");
        if (!Double.isNaN(viewWidth)) {
            buf.append("\t\tviewWidth = " + viewWidth + ";\n");
        }
        if (!Double.isNaN(viewHeight)) {
            buf.append("\t\tviewHeight = " + viewHeight + ";\n");
        }
        if (context.generatedFunctions != null) {
            for (String functionName : context.generatedFunctions) {
                buf.append("\t\t" + functionName + "();\n");
            }
        }
        buf.append("\t}\n");
    }

    private void generateTextInitFunction(StringBuilder textSource, SourceContext context) {
        String functionName = "createText" + context.functionCount++;
        StringBuilder buf = context.buffer;
        buf.append("\n\tprivate function " + functionName + "():void\n\t{\n");
        buf.append((CharSequence)textSource);
        buf.append("\n\t}\n");
        context.addGeneratedFunction(functionName);
    }

    private StringBuilder generateRichText(TextNode textNode) {
        StringBuilder sb = new StringBuilder();
        Variables context = new Variables();
        context.setVar(this.richTextType, NodeType.RICHTEXT);
        String elementVar = context.elementVar;
        this.generateTextVariable(sb, textNode, context);
        sb.append("\t\taddChild(").append(elementVar).append(");\r\n");
        sb.append("\t\t").append(elementVar).append(".regenerateStyleCache(true);\r\n");
        sb.append("\t\t").append(elementVar).append(".stylesInitialized();\r\n");
        sb.append("\t\t").append(elementVar).append(".validateProperties();\r\n");
        sb.append("\t\t").append(elementVar).append(".validateSize();\r\n");
        sb.append("\t\t").append(elementVar).append(".setLayoutBoundsSize(NaN, NaN);\r\n");
        sb.append("\t\t").append(elementVar).append(".validateDisplayList();\r\n");
        return sb;
    }

    private void generatePushChild(StringBuilder sb, String contentVar, String childElementVar) {
        sb.append("\t\t").append(contentVar).append(".push(").append(childElementVar).append(");\r\n");
    }

    private void generateAssignment(StringBuilder sb, String elementVar, String propertyVar, String valueVar) {
        sb.append("\t\t").append(elementVar).append(".").append(propertyVar).append(" = ").append(valueVar).append(";\r\n");
    }

    private void generateTextVariable(StringBuilder sb, TextNode textNode, Variables context) {
        Map attributes = textNode.getTextAttributes();
        List children = textNode.getTextChildren();
        String parentVar = context.elementVar;
        String contentVar = context.contentVar;
        String parentClass = context.elementClass;
        String parentChildrenVar = context.elementChildrenVar;
        Type type = context.type;
        if (!context.varDeclared) {
            sb.append("\t\tvar ").append(parentVar).append(":").append(parentClass).append(" = new ").append(parentClass).append("();\r\n");
            if (contentVar != null) {
                sb.append("\t\tvar ").append(contentVar).append(":Array = [];\r\n");
            }
        } else {
            sb.append("\t\t").append(parentVar).append(" = new ").append(parentClass).append("();\r\n");
            if (contentVar != null) {
                sb.append("\t\t").append(contentVar).append(" = [];\r\n");
            }
        }
        this.generateAttributes(type, attributes, sb, parentVar);
        this.generateProperties(sb, parentVar, textNode.getTextProperties(), context);
        if (children != null && children.size() > 0) {
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                String elementVar = null;
                TextNode child = (TextNode)iter.next();
                if (child instanceof RichTextNode) {
                    context.setVar(this.richTextType, NodeType.RICHTEXT);
                    elementVar = context.elementVar;
                    this.generateTextVariable(sb, child, context);
                    this.generatePushChild(sb, contentVar, elementVar);
                    continue;
                }
                if (child instanceof ParagraphNode) {
                    context.setVar(this.paragraphType, NodeType.PARAGRAPH);
                    elementVar = context.elementVar;
                    this.generateTextVariable(sb, child, context);
                    this.generatePushChild(sb, contentVar, elementVar);
                    continue;
                }
                if (child instanceof SpanNode) {
                    context.setVar(this.spanType, NodeType.SPAN);
                    elementVar = context.elementVar;
                    this.generateTextVariable(sb, child, context);
                    this.generatePushChild(sb, contentVar, elementVar);
                    continue;
                }
                if (child instanceof DivNode) {
                    context.setVar(this.divType, NodeType.DIV);
                    elementVar = context.elementVar;
                    this.generateTextVariable(sb, child, context);
                    this.generatePushChild(sb, contentVar, elementVar);
                    continue;
                }
                if (child instanceof CDATANode) {
                    this.generateCDATA((CDATANode)child, sb, contentVar);
                    continue;
                }
                if (child instanceof BRNode) {
                    this.generateBR(sb, contentVar);
                    continue;
                }
                if (child instanceof ImgNode) {
                    context.setVar(this.imgType, NodeType.IMG);
                    elementVar = context.elementVar;
                    this.generateTextVariable(sb, child, context);
                    this.generatePushChild(sb, contentVar, elementVar);
                    continue;
                }
                if (child instanceof LinkNode) {
                    context.setVar(this.linkType, NodeType.LINK);
                    elementVar = context.elementVar;
                    this.generateTextVariable(sb, child, context);
                    this.generatePushChild(sb, contentVar, elementVar);
                    continue;
                }
                if (child instanceof TabNode) {
                    context.setVar(this.tabType, NodeType.TAB);
                    elementVar = context.elementVar;
                    this.generateTextVariable(sb, child, context);
                    this.generatePushChild(sb, contentVar, elementVar);
                    continue;
                }
                if (child instanceof TCYNode) {
                    context.setVar(this.tcyType, NodeType.TCY);
                    elementVar = context.elementVar;
                    this.generateTextVariable(sb, child, context);
                    this.generatePushChild(sb, contentVar, elementVar);
                    continue;
                }
                if (child instanceof TextGraphicNode) {
                    context.setVar(this.richTextType, NodeType.RICHTEXT);
                    elementVar = context.elementVar;
                    this.generateTextVariable(sb, child, context);
                    this.generatePushChild(sb, contentVar, elementVar);
                    continue;
                }
                if (child instanceof com.adobe.internal.fxg.dom.text.ParagraphNode) {
                    context.setVar(this.paragraphType, NodeType.PARAGRAPH);
                    elementVar = context.elementVar;
                    this.generateTextVariable(sb, child, context);
                    this.generatePushChild(sb, contentVar, elementVar);
                    continue;
                }
                if (child instanceof com.adobe.internal.fxg.dom.text.SpanNode) {
                    context.setVar(this.spanType, NodeType.SPAN);
                    elementVar = context.elementVar;
                    this.generateTextVariable(sb, child, context);
                    this.generatePushChild(sb, contentVar, elementVar);
                    continue;
                }
                if (!(child instanceof com.adobe.internal.fxg.dom.text.BRNode)) continue;
                this.generateBR(sb, contentVar);
            }
        }
        if (parentChildrenVar != null && contentVar != null) {
            this.generateAssignment(sb, parentVar, parentChildrenVar, contentVar);
        }
    }

    private void generateBR(StringBuilder sb, String contentVar) {
        sb.append("\t\t").append(contentVar).append(".push(new BreakElement());\r\n");
    }

    private void generateCDATA(CDATANode node, StringBuilder sb, String contentVar) {
        String text = this.formatString(node.content);
        sb.append("\t\t").append(contentVar).append(".push(").append(text).append(");\r\n");
    }

    private void generateProperties(StringBuilder sb, String parentVar, List<TextNode> properties, Variables context) {
        if (properties != null) {
            for (TextNode node : properties) {
                if (node instanceof LinkActiveFormatNode) {
                    context.setVar(this.linkActiveType, NodeType.LINK_ACTIVE_FORMAT);
                    this.generateTextVariable(sb, node, context);
                    this.generateAssignment(sb, parentVar, "linkActiveFormat", context.elementVar);
                    continue;
                }
                if (node instanceof LinkHoverFormatNode) {
                    context.setVar(this.linkHoverType, NodeType.LINK_HOVER_FORMAT);
                    this.generateTextVariable(sb, node, context);
                    this.generateAssignment(sb, parentVar, "linkHoverFormat", context.elementVar);
                    continue;
                }
                if (node instanceof LinkNormalFormatNode) {
                    context.setVar(this.linkNormalType, NodeType.LINK_NORMAL_FORMAT);
                    this.generateTextVariable(sb, node, context);
                    this.generateAssignment(sb, parentVar, "linkNormalFormat", context.elementVar);
                    continue;
                }
                if (!(node instanceof FormatNode)) continue;
                FormatNode formatNode = (FormatNode)node;
                String name = formatNode.name;
                if (!this.isValidVariableName(name)) continue;
                context.setVar(this.formatType, NodeType.FORMAT);
                context.elementVar = name;
                this.generateTextVariable(sb, (TextNode)formatNode, context);
            }
        }
    }

    private boolean isValidVariableName(String name) {
        return name != null && name.length() > 0;
    }

    private void generateAttributes(Type type, Map<String, String> attributes, StringBuilder sb, String variableName) {
        if (attributes != null) {
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                String attribName = entry.getKey();
                String attribValue = entry.getValue();
                String thisAttrib = null;
                Property property = type.getProperty(attribName);
                if (property != null) {
                    Type propertyType = property.getType();
                    thisAttrib = propertyType.isAssignableTo(this.typeTable.stringType) || propertyType == this.typeTable.objectType || propertyType == this.typeTable.noType ? attribName + " = \"" + attribValue + "\"" : attribName + " = " + attribValue;
                } else if (type.getStyle(attribName) != null) {
                    thisAttrib = "setStyle(\"" + attribName + "\", \"" + attribValue + "\")";
                }
                if (thisAttrib == null) continue;
                sb.append("\t\t" + variableName + '.' + thisAttrib + ";\r\n");
            }
        }
    }

    private String formatString(String content) {
        if (content != null) {
            return StringUtils.formatString((String)content);
        }
        return content;
    }

    private static class Variable {
        private int count;
        private boolean reusableVar;
        private String elementClass;
        private String elementVar;
        private String contentVar;
        private String elementChildrenVar;

        private Variable(String elementClass, String elementVar, String contentVar, String elementChildrenVar, boolean reusableVar) {
            this.elementClass = elementClass;
            this.elementVar = elementVar;
            this.contentVar = contentVar;
            this.elementChildrenVar = elementChildrenVar;
            this.reusableVar = reusableVar;
        }
    }

    private static class Variables {
        private Variable divVar;
        private Variable formatVar;
        private Variable imgVar;
        private Variable linkVar;
        private Variable linkActiveFormatVar;
        private Variable linkHoverFormatVar;
        private Variable linkNormalFormatVar;
        private Variable paragraphVar;
        private Variable richTextVar;
        private Variable spanVar;
        private Variable tabVar;
        private Variable tcyVar;
        private Type type;
        private boolean varDeclared;
        private String elementClass;
        private String elementVar;
        private String contentVar;
        private String elementChildrenVar;

        private Variables() {
        }

        private void setVar(Type type, NodeType nodeType) {
            this.type = type;
            Variable var = this.getVar(nodeType);
            if (var != null) {
                var.count++;
                if (!var.reusableVar) {
                    this.varDeclared = false;
                    this.elementVar = var.elementVar + var.count;
                    this.contentVar = var.contentVar + var.count;
                } else {
                    this.varDeclared = var.count > 1;
                    this.elementVar = var.elementVar;
                    this.contentVar = var.contentVar;
                }
                this.elementClass = var.elementClass;
                this.elementChildrenVar = var.elementChildrenVar;
            }
        }

        private Variable getVar(NodeType nodeType) {
            switch (nodeType) {
                case DIV: {
                    if (this.divVar == null) {
                        this.divVar = new Variable("DivElement", "divElement", "divContent", "mxmlChildren", false);
                    }
                    return this.divVar;
                }
                case FORMAT: {
                    if (this.formatVar == null) {
                        this.formatVar = new Variable("TextLayoutFormat", "formatElement", null, null, false);
                    }
                    return this.formatVar;
                }
                case IMG: {
                    if (this.imgVar == null) {
                        this.imgVar = new Variable("InlineGraphicElement", "imgElement", null, null, true);
                    }
                    return this.imgVar;
                }
                case LINK: {
                    if (this.linkVar == null) {
                        this.linkVar = new Variable("LinkElement", "linkElement", "linkContent", "mxmlChildren", true);
                    }
                    return this.linkVar;
                }
                case LINK_ACTIVE_FORMAT: {
                    if (this.linkActiveFormatVar == null) {
                        this.linkActiveFormatVar = new Variable("LinkActiveFormat", "lafElement", null, null, true);
                    }
                    return this.linkActiveFormatVar;
                }
                case LINK_HOVER_FORMAT: {
                    if (this.linkHoverFormatVar == null) {
                        this.linkHoverFormatVar = new Variable("LinkHoverFormat", "lhfElement", null, null, true);
                    }
                    return this.linkHoverFormatVar;
                }
                case LINK_NORMAL_FORMAT: {
                    if (this.linkNormalFormatVar == null) {
                        this.linkNormalFormatVar = new Variable("LinkNormalFormat", "lnfElement", null, null, true);
                    }
                    return this.linkNormalFormatVar;
                }
                case PARAGRAPH: {
                    if (this.paragraphVar == null) {
                        this.paragraphVar = new Variable("ParagraphElement", "paragraphElement", "paragraphContent", "mxmlChildren", true);
                    }
                    return this.paragraphVar;
                }
                case RICHTEXT: {
                    if (this.richTextVar == null) {
                        this.richTextVar = new Variable("RichText", "textElement", "textContent", "content", true);
                    }
                    return this.richTextVar;
                }
                case SPAN: {
                    if (this.spanVar == null) {
                        this.spanVar = new Variable("SpanElement", "spanElement", "spanContent", "mxmlChildren", true);
                    }
                    return this.spanVar;
                }
                case TAB: {
                    if (this.tabVar == null) {
                        this.tabVar = new Variable("TabElement", "tabElement", null, null, true);
                    }
                    return this.tabVar;
                }
                case TCY: {
                    if (this.tcyVar == null) {
                        this.tcyVar = new Variable("TCYElement", "tcyElement", "tcyContent", "mxmlChildren", true);
                    }
                    return this.tcyVar;
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum NodeType {
        DIV,
        FORMAT,
        IMG,
        LINK,
        LINK_ACTIVE_FORMAT,
        LINK_HOVER_FORMAT,
        LINK_NORMAL_FORMAT,
        PARAGRAPH,
        RICHTEXT,
        SPAN,
        TAB,
        TCY;

    }

    private static class SourceContext {
        private StringBuilder buffer;
        private final String className;
        private final String packageName;
        private List<String> generatedFunctions;
        private int functionCount;

        private SourceContext(String packageName, String className) {
            this.packageName = packageName;
            this.className = className;
            this.buffer = new StringBuilder(512);
        }

        public void addGeneratedFunction(String name) {
            if (this.generatedFunctions == null) {
                this.generatedFunctions = new ArrayList<String>(2);
            }
            this.generatedFunctions.add(name);
        }

        private String getGeneratedSource() {
            return this.buffer.toString();
        }
    }
}

