/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.asdoc;

import flex2.compiler.asdoc.AsClass;
import flex2.compiler.asdoc.QualifiedNameInfo;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsDocUtil {
    private boolean verbose = false;
    private boolean errors = false;
    private String validationErrors = "";

    AsDocUtil(boolean verbose) {
        this.verbose = verbose;
    }

    void decomposeFullName(String name, QualifiedNameInfo fullName) {
        this.decomposeFullName(name, fullName, "public");
    }

    QualifiedNameInfo decomposeFullClassName(String fullClassName) {
        int indexColon = fullClassName.indexOf(":");
        int indexDollar = fullClassName.indexOf("$");
        int indexSlash = fullClassName.indexOf("/");
        QualifiedNameInfo result = new QualifiedNameInfo();
        if (indexColon == -1 && indexDollar == -1 && indexSlash == -1) {
            result.getClassNames().add(fullClassName);
            result.getClassNameSpaces().add("public");
            result.setFullClassName(fullClassName);
            return result;
        }
        int restIdx = 0;
        if (indexDollar != -1) {
            restIdx = indexDollar;
        } else if (indexColon != -1) {
            restIdx = indexColon;
        } else if (indexSlash != -1) {
            restIdx = indexSlash;
        }
        if (indexColon < restIdx) {
            restIdx = indexColon;
        }
        if (indexSlash < restIdx) {
            restIdx = indexSlash;
        }
        String restStr = fullClassName.substring(restIdx + 1);
        if (indexDollar != -1) {
            int ci = restStr.indexOf(":");
            if (ci != -1) {
                if (indexColon != -1 && indexColon < indexDollar) {
                    result.setPackageName(fullClassName.substring(0, indexColon));
                } else {
                    result.setPackageName(fullClassName.substring(0, indexDollar));
                }
                indexSlash = restStr.indexOf("/");
                if (indexSlash != -1) {
                    if (ci < indexSlash) {
                        result.setPackageName(restStr.substring(0, ci));
                        this.decomposeFullName(restStr, result);
                    } else if (indexSlash < ci) {
                        result.getClassNames().add(restStr.substring(0, indexSlash));
                        result.getClassNameSpaces().add("public");
                        this.decomposeFullName(restStr, result);
                    }
                } else {
                    String nextNameSpace = restStr.substring(0, ci).replaceAll("\\d+\\$", "");
                    this.decomposeFullName(restStr.substring(ci + 1, restStr.length()), result, nextNameSpace);
                }
            } else {
                if (indexColon != -1) {
                    result.setPackageName(fullClassName.substring(0, indexColon));
                }
                this.decomposeFullName(restStr, result, "");
            }
        } else if (indexColon != -1 && indexSlash != -1) {
            if (indexColon < indexSlash) {
                result.setPackageName(fullClassName.substring(0, indexColon));
                this.decomposeFullName(restStr, result, "public");
            } else if (indexSlash < indexColon) {
                result.getClassNames().add(fullClassName.substring(0, indexSlash));
                result.getClassNameSpaces().add("public");
                this.decomposeFullName(restStr, result);
            }
        } else {
            if (indexColon != -1) {
                result.setPackageName(fullClassName.substring(0, indexColon));
                this.decomposeFullName(restStr, result, "public");
            }
            if (indexSlash != -1) {
                result.getClassNames().add(fullClassName.substring(0, indexSlash));
                result.getClassNameSpaces().add("public");
                this.decomposeFullName(restStr, result);
            }
        }
        result.setFullClassName(fullClassName);
        return result;
    }

    void decomposeFullName(String name, QualifiedNameInfo fullName, String namespace) {
        if (name == null || name.equals("")) {
            return;
        }
        int classIndex = fullName.getClassNames().size();
        int indexColon = name.indexOf(":");
        int indexSlash = name.indexOf("/");
        if (indexColon == -1 && indexSlash == -1) {
            fullName.getClassNames().add(name);
            fullName.getClassNameSpaces().add(namespace);
        } else if (indexColon != -1 && indexSlash != -1) {
            if (indexColon < indexSlash) {
                fullName.getClassNameSpaces().add(name.substring(0, indexColon));
                if (!namespace.equals("public")) {
                    System.err.println("ERROR: in DecomposeName2, namespace: " + namespace + " was passed in, but namespace: " + fullName.getClassNameSpaces().get(classIndex) + " was specified");
                }
                int iNext = name.indexOf("/");
                boolean proceed = true;
                if (iNext == -1) {
                    iNext = name.length();
                    proceed = false;
                }
                fullName.getClassNames().add(name.substring(indexColon + 1, iNext));
                if (proceed) {
                    this.decomposeFullName(name.substring(iNext + 1), fullName);
                }
            } else if (indexSlash < indexColon) {
                fullName.getClassNames().add(name.substring(0, indexSlash));
                fullName.getClassNameSpaces().add(namespace);
                this.decomposeFullName(name.substring(indexSlash + 1), fullName);
            }
        } else if (indexColon != -1) {
            fullName.getClassNameSpaces().add(name.substring(0, indexColon));
            if (!namespace.equals("public")) {
                System.err.println("ERROR: in DecomposeName2, namespace: " + namespace + " was passed in, but namespace: " + fullName.getClassNameSpaces().get(classIndex) + " was specified");
            }
            int iNext = name.indexOf("/");
            boolean proceed = true;
            if (iNext == -1) {
                iNext = name.length();
                proceed = false;
            }
            fullName.getClassNames().add(name.substring(indexColon + 1, iNext));
            if (proceed) {
                this.decomposeFullName(name.substring(iNext + 1), fullName);
            }
        } else if (indexSlash != -1) {
            fullName.getClassNames().add(name.substring(0, indexSlash));
            fullName.getClassNameSpaces().add(namespace);
            this.decomposeFullName(name.substring(indexSlash + 1), fullName);
        }
    }

    String descToShortDesc(String fullDesc) {
        String[] descArr = fullDesc.split("\\.\\s", 2);
        return descArr[0].replaceAll("<.*?>", "") + (descArr.length == 1 ? "" : ".");
    }

    String validateText(String inputText, String elementName, String ownerName) {
        String output = inputText.replaceAll("</br>", "");
        output = output.replaceAll("<br\\s*/?>", "");
        TransformerFactory transfac = TransformerFactory.newInstance();
        Transformer trans = null;
        try {
            String test = "<test>" + output + "</test>";
            trans = transfac.newTransformer();
            StringReader stringReader = new StringReader(test);
            StreamSource source = new StreamSource(stringReader);
            DOMResult result = new DOMResult();
            trans.transform(source, result);
        }
        catch (Exception ex) {
            String msg = "Text for " + elementName + " in " + ownerName + " is not valid.\n";
            msg = ex.getMessage().indexOf("matching end-tag \"</test>\"") == -1 ? msg + ex.getMessage() : msg + "No matching start tag.";
            this.validationErrors = this.validationErrors + msg + "\n\n";
            if (this.verbose) {
                System.out.println(msg);
                System.out.println("offending text --------------------------------------");
                System.out.println(inputText);
                System.out.println("end offending text --------------------------------------");
            }
            output = "";
            this.errors = true;
        }
        return output;
    }

    Element renameElementAndCloneChild(Element source, Document targetDocument, String newName) {
        Element newElement = targetDocument.createElement(newName);
        NamedNodeMap namedNodeMap = source.getAttributes();
        for (int iAttr = 0; iAttr < namedNodeMap.getLength(); ++iAttr) {
            Node node = namedNodeMap.item(iAttr);
            newElement.setAttribute(node.getNodeName(), node.getNodeValue());
        }
        NodeList listofChilds = source.getChildNodes();
        for (int iChild = 0; iChild < listofChilds.getLength(); ++iChild) {
            Node node = listofChilds.item(iChild);
            newElement.appendChild(node.cloneNode(true));
        }
        return newElement;
    }

    Element renameElementAndImportChild(Element source, Document targetDocument, String newName) {
        Element newElement = targetDocument.createElement(newName);
        NamedNodeMap namedNodeMap = source.getAttributes();
        for (int iAttr = 0; iAttr < namedNodeMap.getLength(); ++iAttr) {
            Node node = namedNodeMap.item(iAttr);
            newElement.setAttribute(node.getNodeName(), node.getNodeValue());
        }
        NodeList listofChilds = source.getChildNodes();
        for (int iChild = 0; iChild < listofChilds.getLength(); ++iChild) {
            Node node = listofChilds.item(iChild);
            newElement.appendChild(targetDocument.importNode(node, true));
        }
        return newElement;
    }

    void convertDescToDITA(Element input, HashMap<String, String> oldNewNamesMap) {
        this.convertDescToDITA(input, oldNewNamesMap, false);
    }

    void convertDescToDITA(Element input, HashMap<String, String> oldNewNamesMap, Boolean isTableElement) {
        CDATASection cdataSection;
        String inputString;
        NodeList descendants = input.getChildNodes();
        if (descendants != null && descendants.getLength() != 0 && (inputString = (cdataSection = (CDATASection)descendants.item(0)).getData()) != null && !inputString.equals("")) {
            Result result;
            Document targetDocument = null;
            TransformerFactory transfac = TransformerFactory.newInstance();
            Transformer trans = null;
            try {
                inputString = "<cdatastring>" + inputString + "</cdatastring>";
                trans = transfac.newTransformer();
                StringReader stringReader = new StringReader(inputString);
                StreamSource source = new StreamSource(stringReader);
                result = new DOMResult();
                trans.transform(source, result);
                targetDocument = (Document)result.getNode();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (targetDocument != null) {
                Element child;
                Node childNode;
                int iy;
                NodeList cDataDescendants = targetDocument.getDocumentElement().getChildNodes();
                for (iy = 0; iy < cDataDescendants.getLength(); ++iy) {
                    childNode = cDataDescendants.item(iy);
                    if (childNode.getNodeType() != 1) continue;
                    child = (Element)childNode;
                    this.convert(child, targetDocument.getDocumentElement(), oldNewNamesMap, targetDocument, isTableElement);
                }
                cDataDescendants = targetDocument.getDocumentElement().getChildNodes();
                for (iy = 0; iy < cDataDescendants.getLength(); ++iy) {
                    childNode = cDataDescendants.item(iy);
                    if (childNode.getNodeType() != 1) continue;
                    child = (Element)childNode;
                    this.convertChildren(child, oldNewNamesMap, targetDocument, isTableElement);
                }
                try {
                    StringWriter sw = new StringWriter();
                    result = new StreamResult(sw);
                    DOMSource source = new DOMSource(targetDocument);
                    trans.setOutputProperty("omit-xml-declaration", "yes");
                    trans.transform(source, result);
                    String xmlString = sw.toString();
                    xmlString = xmlString.replaceAll("<cdatastring>", "");
                    xmlString = xmlString.replaceAll("</cdatastring>", "");
                    cdataSection.setData(xmlString);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private void convertChildren(Element child, HashMap<String, String> oldNewNamesMap, Document targetDocument, Boolean isTableElement) {
        Element subChild;
        Node childNode;
        int iy;
        NodeList cDataDescendants = child.getChildNodes();
        for (iy = 0; iy < cDataDescendants.getLength(); ++iy) {
            childNode = cDataDescendants.item(iy);
            if (childNode.getNodeType() != 1) continue;
            subChild = (Element)childNode;
            this.convert(subChild, child, oldNewNamesMap, targetDocument, isTableElement);
        }
        cDataDescendants = child.getChildNodes();
        for (iy = 0; iy < cDataDescendants.getLength(); ++iy) {
            childNode = cDataDescendants.item(iy);
            if (childNode.getNodeType() != 1) continue;
            subChild = (Element)childNode;
            this.convertChildren(subChild, oldNewNamesMap, targetDocument, isTableElement);
        }
    }

    private void convert(Element child, Node parent, HashMap<String, String> oldNewNamesMap, Document targetDocument, Boolean isTableElement) {
        String oldName = child.getNodeName().toLowerCase();
        String newName = oldNewNamesMap.get(oldName);
        if (newName != null) {
            Element newElement = this.renameElementAndCloneChild(child, targetDocument, newName);
            parent.replaceChild(newElement, child);
        } else if (oldName.equals("listing")) {
            Element newElement = this.renameElementAndCloneChild(child, targetDocument, "codeblock");
            if (newElement.hasAttribute("version")) {
                newElement.setAttribute("rev", newElement.getAttribute("version"));
                newElement.removeAttribute("version");
            }
            parent.replaceChild(newElement, child);
        } else if (oldName.equals("span")) {
            Element newElement = this.renameElementAndCloneChild(child, targetDocument, "ph");
            if (newElement.hasAttribute("class")) {
                newElement.setAttribute("outputclass", newElement.getAttribute("class"));
                newElement.removeAttribute("class");
            }
            parent.replaceChild(newElement, child);
        } else if (oldName.equals("code")) {
            Element newElement = this.renameElementAndCloneChild(child, targetDocument, "codeph");
            parent.replaceChild(newElement, child);
        } else if (oldName.equals("table") && !isTableElement.booleanValue()) {
            Element newElement = this.convertTable(child, targetDocument, oldNewNamesMap);
            parent.replaceChild(newElement, child);
        } else if (oldName.equals("a")) {
            Element newElement = this.renameElementAndCloneChild(child, targetDocument, "xref");
            if (newElement.hasAttribute("target")) {
                String targetVal = newElement.getAttribute("target");
                if (targetVal.toLowerCase().equals("mm_external") || targetVal.toLowerCase().equals("newwindow") || targetVal.toLowerCase().equals("_blank")) {
                    newElement.setAttribute("scope", "external");
                } else {
                    newElement.setAttribute("scope", targetVal);
                }
                newElement.removeAttribute("target");
            }
            parent.replaceChild(newElement, child);
        } else if (oldName.equals("img")) {
            Element newElement = this.renameElementAndCloneChild(child, targetDocument, "adobeimage");
            if (newElement.hasAttribute("src")) {
                newElement.setAttribute("href", newElement.getAttribute("src"));
                newElement.removeAttribute("src");
            }
            parent.replaceChild(newElement, child);
        } else if (oldName.equals("flexonly")) {
            NodeList nodes = child.getChildNodes();
            if (nodes != null && nodes.getLength() == 1) {
                Element parentNode = (Element)child.getParentNode();
                parentNode.setAttribute("product", "flex");
            }
        } else if (oldName.equals("ol") && child.hasAttribute("type")) {
            child.setAttribute("outputclass", child.getAttribute("type"));
            child.removeAttribute("type");
        }
    }

    Element convertTable(Element input, Document targetDocument, HashMap<String, String> oldNewNamesMap) {
        int iChild;
        NodeList childNodes = input.getElementsByTagName("colgroup");
        for (int iChild2 = 0; iChild2 < childNodes.getLength(); ++iChild2) {
            Node node = childNodes.item(iChild2);
            input.removeChild(node);
        }
        Element theadNode = null;
        childNodes = input.getChildNodes();
        for (int iChild3 = 0; iChild3 < childNodes.getLength(); ++iChild3) {
            Element node;
            NodeList thList;
            if (childNodes.item(iChild3).getNodeType() != 1 || (thList = (node = (Element)childNodes.item(iChild3)).getElementsByTagName("th")) == null || thList.getLength() == 0) continue;
            theadNode = targetDocument.createElement("thead");
            Element row = targetDocument.createElement("row");
            NodeList subChildNodes = node.getChildNodes();
            for (int iSubChild = 0; iSubChild < subChildNodes.getLength(); ++iSubChild) {
                if (subChildNodes.item(iSubChild).getNodeType() != 1) continue;
                Element subChild = (Element)subChildNodes.item(iSubChild);
                row.appendChild(subChild.cloneNode(true));
            }
            theadNode.appendChild(row);
            input.removeChild(node);
            break;
        }
        Element tGroup = targetDocument.createElement("tgroup");
        if (theadNode != null) {
            tGroup.appendChild(theadNode);
        }
        Element tBody = targetDocument.createElement("tbody");
        tGroup.appendChild(tBody);
        childNodes = input.getChildNodes();
        for (iChild = 0; iChild < childNodes.getLength(); ++iChild) {
            if (childNodes.item(iChild).getNodeType() != 1) continue;
            tBody.appendChild(childNodes.item(iChild));
        }
        childNodes = input.getChildNodes();
        for (iChild = 0; iChild < childNodes.getLength(); ++iChild) {
            if (childNodes.item(iChild).getNodeType() != 1) continue;
            Element node = (Element)childNodes.item(iChild);
            input.removeChild(node);
        }
        input = this.renameElementAndCloneChild(input, targetDocument, "adobetable");
        input.appendChild(tGroup);
        input.removeAttribute("width");
        input.removeAttribute("colgroup");
        input.removeAttribute("cellpadding");
        input.removeAttribute("cellspacing");
        input.removeAttribute("border");
        input.removeAttribute("style");
        this.convertTableChilds(targetDocument, input, input);
        int colCount = 0;
        int currentRowLength = 0;
        childNodes = input.getElementsByTagName("row");
        if (childNodes != null) {
            for (int iChild4 = 0; iChild4 < childNodes.getLength(); ++iChild4) {
                currentRowLength = 0;
                Element rowNode = (Element)childNodes.item(iChild4);
                NodeList rowElements = rowNode.getChildNodes();
                for (int ix = 0; ix < rowElements.getLength(); ++ix) {
                    if (rowElements.item(ix).getNodeType() != 1) continue;
                    ++currentRowLength;
                }
                if (colCount >= currentRowLength) continue;
                colCount = currentRowLength;
            }
        }
        tGroup.setAttribute("cols", String.valueOf(colCount));
        this.convertChildren(input, oldNewNamesMap, targetDocument, false);
        return input;
    }

    private void convertTableChilds(Document targetDocument, Element target, Element root) {
        NodeList children;
        Node parent;
        Element newElement;
        String oldName = target.getNodeName().toLowerCase();
        if (oldName.equals("tr")) {
            newElement = this.renameElementAndCloneChild(target, targetDocument, "row");
            parent = target.getParentNode();
            parent.replaceChild(newElement, target);
            this.convertTableChilds(targetDocument, newElement, target);
        }
        if (oldName.equals("th") || oldName.equals("td")) {
            newElement = this.renameElementAndCloneChild(target, targetDocument, "entry");
            newElement.removeAttribute("colspan");
            newElement.removeAttribute("rowspan");
            newElement.removeAttribute("width");
            if (newElement.hasAttribute("nowrap")) {
                String nowrapVal = newElement.getAttribute("nowrap");
                if (!nowrapVal.equals("false")) {
                    newElement.setAttribute("outputclass", "nowrap");
                }
                newElement.removeAttribute("nowrap");
            }
            parent = target.getParentNode();
            parent.replaceChild(newElement, target);
            this.convertTableChilds(targetDocument, newElement, target);
        }
        if ((children = target.getChildNodes()) != null && children.getLength() != 0) {
            for (int ix = 0; ix < children.getLength(); ++ix) {
                Node childNode = children.item(ix);
                if (childNode.getNodeType() != 1) continue;
                Element child = (Element)childNode;
                this.convertTableChilds(targetDocument, child, target);
            }
        }
    }

    boolean hidePackage(String packageName, String hiddenPackages) {
        if (packageName == null || packageName.equals("")) {
            return false;
        }
        if (hiddenPackages.indexOf(":" + packageName + ":") != -1) {
            return hiddenPackages.indexOf(":" + packageName + ":true:") != -1;
        }
        return false;
    }

    String formatId(String inputId) {
        return inputId.replaceAll("\\/", ":");
    }

    String normalizeString(String str) {
        return str.replaceAll("^[\\s]+|[\\s]+$", "").replaceAll("\\s+", " ");
    }

    String convertToEntity(String input) {
        String output = input.replaceAll("&", "&amp;");
        output = output.replaceAll("<", "&lt;");
        output = output.replaceAll(">", "&gt;");
        return output;
    }

    Element getDetailNode(Element baseNode) {
        Element element = this.getElementByTagName(baseNode, "apiClassifierDetail");
        if (element != null) {
            return element;
        }
        element = this.getElementByTagName(baseNode, "apiOperationDetail");
        if (element != null) {
            return element;
        }
        element = this.getElementByTagName(baseNode, "apiValueDetail");
        if (element != null) {
            return element;
        }
        element = this.getElementByTagName(baseNode, "apiConstructorDetail");
        if (element != null) {
            return element;
        }
        element = this.getElementByTagName(baseNode, "adobeApiEventDetail");
        return element;
    }

    Element getDefNode(Element baseNode) {
        Element subElement;
        Element element = this.getElementByTagName(baseNode, "apiClassifierDetail");
        if (element != null && (subElement = this.getElementByTagName(element, "apiClassifierDef")) != null) {
            return subElement;
        }
        element = this.getElementByTagName(baseNode, "apiOperationDetail");
        if (element != null && (subElement = this.getElementByTagName(element, "apiOperationDef")) != null) {
            return subElement;
        }
        element = this.getElementByTagName(baseNode, "apiValueDetail");
        if (element != null && (subElement = this.getElementByTagName(element, "apiValueDef")) != null) {
            return subElement;
        }
        element = this.getElementByTagName(baseNode, "apiConstructorDetail");
        if (element != null && (subElement = this.getElementByTagName(element, "apiConstructorDef")) != null) {
            return subElement;
        }
        element = this.getElementByTagName(baseNode, "adobeApiEventDetail");
        if (element != null && (subElement = this.getElementByTagName(element, "adobeApiEventDef")) != null) {
            return subElement;
        }
        return null;
    }

    boolean hideNamespace(String namespace, String namespaces) {
        if (namespace == null || namespace.equals("")) {
            return false;
        }
        if (namespaces.indexOf(":" + namespace + ":") != -1) {
            return namespaces.indexOf(":" + namespace + ":true:") != -1;
        }
        if (namespace.equals("public")) {
            return false;
        }
        if (namespace.equals("private")) {
            return true;
        }
        if (namespace.equals("$internal")) {
            return true;
        }
        return namespace.equals("internal");
    }

    void processCustoms(Element node, Document outputDocument) {
        boolean customDataFlag = false;
        Element asCustoms = outputDocument.createElement("asCustoms");
        ArrayList<String> handledTags = new ArrayList<String>();
        handledTags.add("default");
        handledTags.add("description");
        handledTags.add("copy");
        handledTags.add("see");
        handledTags.add("playerversion");
        handledTags.add("inheritDoc");
        for (int ix = 0; ix < node.getChildNodes().getLength(); ++ix) {
            String nodeName;
            Node child = node.getChildNodes().item(ix);
            if (child.getNodeType() != 1 || handledTags.contains(nodeName = child.getNodeName())) continue;
            customDataFlag = true;
            Element nodeNameElement = outputDocument.createElement(nodeName);
            CDATASection cdata = outputDocument.createCDATASection(child.getTextContent());
            nodeNameElement.appendChild(cdata);
            asCustoms.appendChild(nodeNameElement);
            node.removeChild(child);
        }
        if (customDataFlag) {
            Element prolog = this.getElementByTagName(node, "prolog");
            if (prolog != null) {
                prolog.appendChild(asCustoms);
            } else {
                prolog = outputDocument.createElement("prolog");
                prolog.appendChild(asCustoms);
                node.appendChild(prolog);
            }
        }
    }

    void processAncestorClass(AsClass ancestorClass, AsClass thisClass) {
        Set<Map.Entry<String, Integer>> baseEntrySet;
        Iterator<Map.Entry<String, Integer>> baseEntryIterator;
        NodeList baseFieldList;
        if (this.verbose) {
            System.out.println("processAncestorClass - thisClass " + thisClass.getFullName() + " ancestorClass " + ancestorClass.getFullName());
        }
        if (ancestorClass.getFields() != null && (baseFieldList = ancestorClass.getFields().getElementsByTagName("apiValue")) != null && baseFieldList.getLength() != 0) {
            for (int ix = 0; ix < baseFieldList.getLength(); ++ix) {
                boolean found = false;
                Element baseField = (Element)baseFieldList.item(ix);
                for (int excludedCount = 0; excludedCount < thisClass.getExcludedProperties().size(); ++excludedCount) {
                    Element apiValue = this.getElementByTagName(baseField, "apiValue");
                    if (apiValue == null || !thisClass.getExcludedProperties().get(excludedCount).equals(apiValue.getTextContent())) continue;
                    found = true;
                    break;
                }
                Element apiName = this.getElementByTagName(baseField, "apiName");
                if (found || thisClass.getFieldGetSet().get(apiName.getTextContent()) == null || thisClass.getFieldGetSet().get(apiName.getTextContent()) == 0 || thisClass.getPrivateGetSet().get(apiName.getTextContent()) != null && thisClass.getPrivateGetSet().get(apiName.getTextContent()) != 0) continue;
                if (thisClass.getFieldGetSet().get(apiName.getTextContent()) == 1) {
                    if (ancestorClass.getFieldGetSet().get(apiName.getTextContent()) <= 1) continue;
                    thisClass.getFieldGetSet().put(apiName.getTextContent(), thisClass.getFieldGetSet().get(apiName.getTextContent()) + 2);
                    continue;
                }
                if (thisClass.getFieldGetSet().get(apiName.getTextContent()) != 2 || ancestorClass.getFieldGetSet().get(apiName.getTextContent()) == 2) continue;
                thisClass.getFieldGetSet().put(apiName.getTextContent(), thisClass.getFieldGetSet().get(apiName.getTextContent()) + 1);
            }
        }
        if (ancestorClass.getPrivateGetSet() != null && (baseEntryIterator = (baseEntrySet = ancestorClass.getPrivateGetSet().entrySet()).iterator()) != null) {
            block2: while (baseEntryIterator.hasNext()) {
                Map.Entry<String, Integer> entry;
                Map.Entry<String, Integer> baseEntry = baseEntryIterator.next();
                boolean found = false;
                for (int excludedCount = 0; excludedCount < thisClass.getExcludedProperties().size(); ++excludedCount) {
                    if (!thisClass.getExcludedProperties().get(excludedCount).equals(baseEntry.getKey())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                Set<Map.Entry<String, Integer>> entrySet = thisClass.getPrivateGetSet().entrySet();
                Iterator<Map.Entry<String, Integer>> entryIterator = entrySet.iterator();
                if (entryIterator != null) {
                    while (entryIterator.hasNext()) {
                        entry = entryIterator.next();
                        if (!entry.getKey().equals(baseEntry.getKey())) continue;
                        if (entry.getValue() == 3) {
                            found = true;
                            break;
                        }
                        if (entry.getValue() == 2) {
                            if (ancestorClass.getPrivateGetSet().get(entry.getKey()) <= 1) continue;
                            found = true;
                            break;
                        }
                        if (entry.getValue() != 1 || ancestorClass.getPrivateGetSet().get(entry.getKey()) == 2) continue;
                        found = true;
                        break;
                    }
                }
                if (found || (entryIterator = (entrySet = thisClass.getFieldGetSet().entrySet()).iterator()) == null) continue;
                while (entryIterator.hasNext()) {
                    entry = entryIterator.next();
                    if (!entry.getKey().equals(baseEntry.getKey())) continue;
                    if (entry.getValue() == 1) {
                        if (ancestorClass.getPrivateGetSet().get(entry.getKey()) <= 1) continue block2;
                        thisClass.getFieldGetSet().put(entry.getKey(), thisClass.getFieldGetSet().get(entry.getKey()) + 2);
                        continue block2;
                    }
                    if (entry.getValue() != 2 || ancestorClass.getPrivateGetSet().get(entry.getKey()) == 2) continue block2;
                    thisClass.getFieldGetSet().put(entry.getKey(), thisClass.getFieldGetSet().get(entry.getKey()) + 1);
                    continue block2;
                }
            }
        }
    }

    void processCopyDoc(AsClass currentClass, HashMap<String, AsClass> classTable) {
        NodeList apiOperationList;
        Element shortdesc;
        int ix;
        NodeList apiConstructorList;
        if (currentClass.getConstructors() != null && (apiConstructorList = currentClass.getConstructors().getElementsByTagName("apiConstructor")) != null && apiConstructorList.getLength() != 0) {
            for (ix = 0; ix < apiConstructorList.getLength(); ++ix) {
                Element apiConstructor = (Element)apiConstructorList.item(ix);
                shortdesc = this.getElementByTagName(apiConstructor, "shortdesc");
                if (shortdesc == null || shortdesc.getAttribute("conref").equals("")) continue;
                this.processCopyNode(apiConstructor, shortdesc.getAttribute("conref"), currentClass, classTable);
            }
        }
        if (currentClass.getMethods() != null && (apiOperationList = currentClass.getMethods().getElementsByTagName("apiOperation")) != null && apiOperationList.getLength() != 0) {
            for (ix = 0; ix < apiOperationList.getLength(); ++ix) {
                Element apiOperation = (Element)apiOperationList.item(ix);
                shortdesc = this.getElementByTagName(apiOperation, "shortdesc");
                if (shortdesc == null || shortdesc.getAttribute("conref").equals("")) continue;
                this.processCopyNode(apiOperation, shortdesc.getAttribute("conref"), currentClass, classTable);
            }
        }
    }

    void processCopyNode(Element toNode, String fromNode, AsClass toClass, HashMap<String, AsClass> classTable) {
        String anchor;
        int braceIdx;
        String fromClassName = this.normalizeString(fromNode);
        AsClass fromClass = this.getClass(fromClassName, classTable);
        int poundIdx = fromClassName.indexOf("#");
        if (fromClass == null) {
            if (poundIdx != -1) {
                fromClass = this.getClass(fromClassName.substring(0, poundIdx), classTable);
            }
            if (fromClass == null) {
                if (poundIdx != -1) {
                    fromClass = this.getClass(toClass.getDecompName().getPackageName() + "." + fromClassName.substring(0, poundIdx), classTable);
                }
                if (fromClass == null) {
                    return;
                }
            }
        }
        if ((braceIdx = (anchor = fromClassName.substring(poundIdx + 1)).indexOf("(")) != -1) {
            NodeList apiConstructorList;
            Element apiName;
            int ix;
            NodeList apiOperationList;
            anchor = anchor.substring(0, braceIdx);
            if (fromClass.getMethodCount() > 0 && fromClass.getMethods() != null && (apiOperationList = fromClass.getMethods().getElementsByTagName("apiOperation")) != null && apiOperationList.getLength() != 0) {
                for (ix = 0; ix < apiOperationList.getLength(); ++ix) {
                    Element apiOperation = (Element)apiOperationList.item(ix);
                    apiName = this.getElementByTagName(apiOperation, "apiName");
                    if (apiName == null || !anchor.equals(apiName.getTextContent())) continue;
                    toClass.setPendingCopyDoc(this.inheritDocForMethod(toNode, apiOperation));
                }
            }
            if (fromClass.getConstructorCount() > 0 && fromClass.getConstructors() != null && (apiConstructorList = fromClass.getConstructors().getElementsByTagName("apiConstructor")) != null && apiConstructorList.getLength() != 0) {
                for (ix = 0; ix < apiConstructorList.getLength(); ++ix) {
                    Element apiConstructorDef2;
                    Element apiConstructorDetail2;
                    NodeList apiParamList;
                    Element apiConstructorDef;
                    Element apiConstructor = (Element)apiConstructorList.item(ix);
                    apiName = this.getElementByTagName(apiConstructor, "apiName");
                    if (apiName == null || !anchor.equals(apiName.getTextContent())) continue;
                    Element apiConstructorDetail = this.getElementByTagName(apiConstructor, "apiConstructorDetail");
                    if (apiConstructorDetail == null || (apiConstructorDef = this.getElementByTagName(apiConstructorDetail, "apiConstructorDef")) == null || (apiParamList = apiConstructorDef.getElementsByTagName("apiParam")) == null || apiParamList.getLength() == 0 || (apiConstructorDetail2 = this.getElementByTagName(toNode, "apiConstructorDetail")) == null || (apiConstructorDef2 = this.getElementByTagName(apiConstructorDetail2, "apiConstructorDef")) == null) break;
                    NodeList apiParamList2 = apiConstructorDef2.getElementsByTagName("apiParam");
                    if (apiParamList2 != null && apiParamList2.getLength() != 0) {
                        String toSignature;
                        if (apiParamList.getLength() != apiParamList2.getLength()) {
                            this.validationErrors = this.validationErrors + "Number of parameters do not match between " + fromClassName + " and " + toNode.getAttribute("id") + apiParamList.getLength() + " vs " + apiParamList2.getLength() + " \n@copy cannot copy @param description \n\n";
                            this.errors = true;
                            break;
                        }
                        StringBuilder fromNodeSignature = new StringBuilder();
                        StringBuilder toNodeSignature = new StringBuilder();
                        for (int iy = 0; iy < apiParamList.getLength(); ++iy) {
                            Element fromOperationClassifier = this.getElementByTagName((Element)apiParamList.item(iy), "apiOperationClassifier");
                            if (fromOperationClassifier != null) {
                                fromNodeSignature.append(fromOperationClassifier.getTextContent().trim());
                            } else {
                                Element fromApiType = this.getElementByTagName((Element)apiParamList.item(iy), "apiType");
                                fromNodeSignature.append(fromApiType.getAttribute("value").trim());
                            }
                            Element toOperationClassifier = this.getElementByTagName((Element)apiParamList2.item(iy), "apiOperationClassifier");
                            if (toOperationClassifier != null) {
                                toNodeSignature.append(toOperationClassifier.getTextContent().trim());
                            } else {
                                Element toApiType = this.getElementByTagName((Element)apiParamList2.item(iy), "apiType");
                                toNodeSignature.append(toApiType.getAttribute("value").trim());
                            }
                            if (iy == apiParamList.getLength() - 1) continue;
                            fromNodeSignature.append(", ");
                            toNodeSignature.append(", ");
                        }
                        String fromSignature = fromNodeSignature.toString();
                        if (!fromSignature.equals(toSignature = toNodeSignature.toString())) {
                            this.validationErrors = this.validationErrors + "Incompatible methods: \n" + fromClassName + " ( " + fromSignature + ") does not have a matching signature with " + toNode.getAttribute("id") + " ( " + toSignature + " ) \n@copy cannot copy @param description\n\n";
                            this.errors = true;
                            break;
                        }
                        for (int iy = 0; iy < apiParamList.getLength(); ++iy) {
                            Element toDesc = this.getElementByTagName((Element)apiParamList2.item(iy), "apiDesc");
                            Element fromDesc = this.getElementByTagName((Element)apiParamList.item(iy), "apiDesc");
                            if (toDesc != null) {
                                apiParamList2.item(iy).removeChild(toDesc);
                            }
                            if (fromDesc == null) continue;
                            apiParamList2.item(iy).appendChild(fromDesc.cloneNode(true));
                        }
                        break;
                    }
                    this.validationErrors = this.validationErrors + "Number of parameters do not match between " + fromClassName + " and " + toNode.getAttribute("id") + apiParamList.getLength() + " vs zero. \n@copy cannot copy @param description\n\n";
                    this.errors = true;
                    break;
                }
            }
        }
    }

    boolean inheritDocForMethod(Element toNode, Element fromNode) {
        Element shortdesc;
        if (this.verbose) {
            System.out.println("Enter inheritDocForMethod toNode " + toNode.getAttribute("id") + " fromNode " + fromNode.getAttribute("id"));
        }
        if ((shortdesc = this.getElementByTagName(fromNode, "shortdesc")) != null && !shortdesc.getTextContent().equals("")) {
            Element apiOperationDef;
            Element apiOperationDetail;
            Element apiOperationDef2 = null;
            Element apiOperationDetail2 = this.getElementByTagName(toNode, "apiOperationDetail");
            if (apiOperationDetail2 != null) {
                apiOperationDef2 = this.getElementByTagName(apiOperationDetail2, "apiOperationDef");
            }
            if ((apiOperationDetail = this.getElementByTagName(fromNode, "apiOperationDetail")) != null && (apiOperationDef = this.getElementByTagName(apiOperationDetail, "apiOperationDef")) != null) {
                Element toApiReturn;
                Element fromApiReturn;
                NodeList apiParamList = apiOperationDef.getElementsByTagName("apiParam");
                NodeList apiParamList2 = apiOperationDef2.getElementsByTagName("apiParam");
                if (apiParamList != null && apiParamList.getLength() != 0) {
                    if (apiParamList2 != null && apiParamList2.getLength() != 0) {
                        if (apiParamList.getLength() != apiParamList2.getLength()) {
                            this.validationErrors = this.validationErrors + "Number of parameters do not match between " + fromNode.getAttribute("id") + " and " + toNode.getAttribute("id") + apiParamList.getLength() + " vs " + apiParamList2.getLength() + " \n@copy cannot copy @param description\n\n";
                            this.errors = true;
                        } else {
                            String toSignature;
                            StringBuilder fromNodeSignature = new StringBuilder();
                            StringBuilder toNodeSignature = new StringBuilder();
                            for (int ix = 0; ix < apiParamList.getLength(); ++ix) {
                                Element fromOperationClassifier = this.getElementByTagName((Element)apiParamList.item(ix), "apiOperationClassifier");
                                if (fromOperationClassifier != null) {
                                    fromNodeSignature.append(fromOperationClassifier.getTextContent().trim());
                                } else {
                                    Element fromApiType = this.getElementByTagName((Element)apiParamList.item(ix), "apiType");
                                    fromNodeSignature.append(fromApiType.getAttribute("value").trim());
                                }
                                Element toOperationClassifier = this.getElementByTagName((Element)apiParamList2.item(ix), "apiOperationClassifier");
                                if (toOperationClassifier != null) {
                                    toNodeSignature.append(toOperationClassifier.getTextContent().trim());
                                } else {
                                    Element toApiType = this.getElementByTagName((Element)apiParamList2.item(ix), "apiType");
                                    toNodeSignature.append(toApiType.getAttribute("value").trim());
                                }
                                if (ix == apiParamList.getLength() - 1) continue;
                                fromNodeSignature.append(", ");
                                toNodeSignature.append(", ");
                            }
                            String fromSignature = fromNodeSignature.toString();
                            if (!fromSignature.equals(toSignature = toNodeSignature.toString())) {
                                this.validationErrors = this.validationErrors + "Incompatible methods: \n" + fromNode.getAttribute("id") + " ( " + fromSignature + ") does not have a matching signature with " + toNode.getAttribute("id") + " ( " + toSignature + " ) \n@copy cannot copy @param description\n\n";
                                this.errors = true;
                            } else {
                                for (int ix = 0; ix < apiParamList.getLength(); ++ix) {
                                    Element toDesc = this.getElementByTagName((Element)apiParamList2.item(ix), "apiDesc");
                                    Element fromDesc = this.getElementByTagName((Element)apiParamList.item(ix), "apiDesc");
                                    if (toDesc != null) {
                                        apiParamList2.item(ix).removeChild(toDesc);
                                    }
                                    if (fromDesc == null) continue;
                                    apiParamList2.item(ix).appendChild(fromDesc.cloneNode(true));
                                }
                            }
                        }
                    } else {
                        this.validationErrors = this.validationErrors + "Number of parameters do not match between " + fromNode.getAttribute("id") + " and " + toNode.getAttribute("id") + apiParamList.getLength() + " vs zero. \n@copy cannot copy @param description\n\n";
                        this.errors = true;
                    }
                }
                if ((fromApiReturn = this.getElementByTagName(apiOperationDef, "apiReturn")) != null && (toApiReturn = this.getElementByTagName(apiOperationDef2, "apiReturn")) != null) {
                    Element toReturnDesc = this.getElementByTagName(toApiReturn, "apiDesc");
                    Element fromReturnDesc = this.getElementByTagName(fromApiReturn, "apiDesc");
                    if (toReturnDesc != null) {
                        toApiReturn.removeChild(toReturnDesc);
                    }
                    if (fromReturnDesc != null) {
                        toApiReturn.appendChild(fromReturnDesc.cloneNode(true));
                    }
                }
            }
            if (!shortdesc.getAttribute("conref").equals("")) {
                return true;
            }
        }
        return false;
    }

    AsClass getClass(String classStr, HashMap<String, AsClass> classTable) {
        int pountLoc = classStr.indexOf("#");
        if (pountLoc == 0) {
            return null;
        }
        int lastDot = classStr.lastIndexOf(46);
        if (lastDot != -1) {
            classStr = classStr.substring(0, lastDot) + ":" + classStr.substring(lastDot + 1);
        }
        classStr = classStr.replaceAll("event:", "");
        classStr = classStr.replaceAll("style:", "");
        classStr = classStr.replaceAll("effect:", "");
        if (pountLoc != -1) {
            String className = classStr.substring(0, pountLoc);
            lastDot = className.lastIndexOf(46);
            String fullClassName = className;
            if (lastDot != -1) {
                fullClassName = className.substring(0, lastDot) + ":" + className.substring(lastDot + 1);
            }
            if (!classTable.containsKey(className)) {
                if (!classTable.containsKey(fullClassName)) {
                    return null;
                }
                return classTable.get(fullClassName);
            }
            return classTable.get(className);
        }
        return classTable.get(classStr);
    }

    Element createApiMap(TreeSet<String> packageNames, Document outputObject) {
        ArrayList<String> alreadyAdded = new ArrayList<String>();
        Element apiMap = outputObject.createElement("apiMap");
        String addedPackage = null;
        String currentPackage = null;
        Iterator<String> packages = packageNames.iterator();
        if (packages == null) {
            return apiMap;
        }
        while (packages.hasNext()) {
            currentPackage = packages.next();
            boolean found = false;
            for (int ix = 0; ix < alreadyAdded.size(); ++ix) {
                addedPackage = (String)alreadyAdded.get(ix);
                if (currentPackage.indexOf(addedPackage) != 0 || currentPackage.charAt(addedPackage.length()) != '.') continue;
                Element apiItemRef = this.getPackageNode(apiMap, addedPackage);
                Element newApiItemRef = outputObject.createElement("apiItemRef");
                newApiItemRef.setAttribute("href", currentPackage + ".xml");
                apiItemRef.appendChild(newApiItemRef);
                alreadyAdded.add(currentPackage);
                found = true;
                break;
            }
            if (found) continue;
            Element apiItemRef = outputObject.createElement("apiItemRef");
            apiItemRef.setAttribute("href", currentPackage + ".xml");
            apiMap.appendChild(apiItemRef);
            alreadyAdded.add(currentPackage);
        }
        return apiMap;
    }

    private Element getPackageNode(Element apiMap, String packageName) {
        String key = packageName + ".xml";
        Stack<Element> apiItemRefArr = new Stack<Element>();
        NodeList apiItemRefList = apiMap.getElementsByTagName("apiItemRef");
        if (apiItemRefList != null && apiItemRefList.getLength() != 0) {
            for (int ix = 0; ix < apiItemRefList.getLength(); ++ix) {
                Element apiItemRef = (Element)apiItemRefList.item(ix);
                if (apiItemRef.getAttribute("href").equals(key)) {
                    return apiItemRef;
                }
                apiItemRefArr.push(apiItemRef);
            }
        }
        while (apiItemRefArr.size() != 0) {
            Element apiItemRef = (Element)apiItemRefArr.pop();
            NodeList children = apiItemRef.getElementsByTagName("apiItemRef");
            if (children == null || children.getLength() == 0) continue;
            for (int ix = 0; ix < children.getLength(); ++ix) {
                Element child = (Element)children.item(ix);
                if (child.getAttribute("href").equals(key)) {
                    return child;
                }
                apiItemRefArr.push(child);
            }
        }
        return null;
    }

    public boolean isErrors() {
        return this.errors;
    }

    public String getValidationErrors() {
        return this.validationErrors;
    }

    Element getElementByTagName(Element parent, String tagName) {
        NodeList nodeList = parent.getElementsByTagName(tagName);
        if (nodeList != null && nodeList.getLength() != 0) {
            return (Element)nodeList.item(0);
        }
        return null;
    }

    Element getElementImmediateChildByTagName(Element parent, String tagName) {
        NodeList nodeList = parent.getElementsByTagName(tagName);
        if (nodeList != null && nodeList.getLength() != 0) {
            for (int iChild = 0; iChild < nodeList.getLength(); ++iChild) {
                if (!nodeList.item(iChild).getParentNode().equals(parent)) continue;
                return (Element)nodeList.item(iChild);
            }
        }
        return null;
    }
}

