/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.common;

import flex2.compiler.common.ConfigurationPathResolver;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.config.ConfigurationInfo;
import flex2.compiler.config.ConfigurationValue;

public class MxmlConfiguration {
    private ConfigurationPathResolver configResolver;
    public static final int CURRENT_VERSION = 0x3000000;
    public static final int VERSION_3_0 = 0x3000000;
    public static final int VERSION_2_0_1 = 0x2000001;
    public static final int VERSION_2_0 = 0x2000000;
    private int major;
    private int minor;
    private int revision;

    public void setConfigPathResolver(ConfigurationPathResolver resolver) {
        this.configResolver = resolver;
    }

    public int getMajorCompatibilityVersion() {
        return this.major;
    }

    public int getMinorCompatibilityVersion() {
        return this.minor;
    }

    public int getRevisionCompatibilityVersion() {
        return this.revision;
    }

    public String getCompatibilityVersionString() {
        return this.major == 0 && this.minor == 0 && this.revision == 0 ? null : this.major + "." + this.minor + "." + this.revision;
    }

    public int getCompatibilityVersion() {
        int version = (this.major << 24) + (this.minor << 16) + this.revision;
        return version != 0 ? version : 0x3000000;
    }

    public void cfgCompatibilityVersion(ConfigurationValue cv, String version) throws ConfigurationException {
        if (version == null) {
            return;
        }
        String[] results = version.split("\\.");
        if (results.length == 0) {
            throw new ConfigurationException.BadVersion(version, "compatibility-version");
        }
        for (int i = 0; i < results.length; ++i) {
            int versionNum = 0;
            try {
                versionNum = Integer.parseInt(results[i]);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException.BadVersion(version, "compatibility-version");
            }
            if (i == 0) {
                if (versionNum == 2) {
                    this.major = versionNum;
                    continue;
                }
                throw new ConfigurationException.BadVersion(version, "compatibility-version");
            }
            if (versionNum >= 0) {
                if (i == 1) {
                    this.minor = versionNum;
                    continue;
                }
                this.revision = versionNum;
                continue;
            }
            throw new ConfigurationException.BadVersion(version, "compatibility-version");
        }
    }

    public static ConfigurationInfo getCompatibilityVersionInfo() {
        return new ConfigurationInfo(new String[]{"version"});
    }
}

