/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler;

import flash.fonts.FontManager;
import flash.localization.LocalizationManager;
import flash.swf.Movie;
import flash.swf.MovieEncoder;
import flash.swf.TagEncoder;
import flash.swf.TagHandler;
import flash.util.FileUtils;
import flex.messaging.config.ServicesDependencies;
import flex2.compiler.CompilationUnit;
import flex2.compiler.CompilerException;
import flex2.compiler.CompilerSwcContext;
import flex2.compiler.DependencyGraph;
import flex2.compiler.FileSpec;
import flex2.compiler.LicenseException;
import flex2.compiler.Logger;
import flex2.compiler.PersistenceStore;
import flex2.compiler.PreLink;
import flex2.compiler.ResourceBundlePath;
import flex2.compiler.ResourceContainer;
import flex2.compiler.Source;
import flex2.compiler.SourceList;
import flex2.compiler.SourcePath;
import flex2.compiler.SourcePathBase;
import flex2.compiler.SymbolTable;
import flex2.compiler.as3.Compiler;
import flex2.compiler.as3.SignatureExtension;
import flex2.compiler.common.CompilerConfiguration;
import flex2.compiler.common.Configuration;
import flex2.compiler.common.FramesConfiguration;
import flex2.compiler.common.LocalFilePathResolver;
import flex2.compiler.common.PathResolver;
import flex2.compiler.common.SinglePathResolver;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.i18n.I18nUtils;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.InMemoryFile;
import flex2.compiler.io.LocalFile;
import flex2.compiler.io.ResourceFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.util.Algorithms;
import flex2.compiler.util.Benchmark;
import flex2.compiler.util.CompilerControl;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.Console;
import flex2.compiler.util.LocalLogger;
import flex2.compiler.util.ManifestParser;
import flex2.compiler.util.MultiName;
import flex2.compiler.util.MultiNameSet;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.NameMappings;
import flex2.compiler.util.QName;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.compiler.util.URLPathResolver;
import flex2.compiler.util.Vertex;
import flex2.compiler.util.Visitor;
import flex2.linker.ConsoleApplication;
import flex2.tools.oem.ProgressMeter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import macromedia.asc.util.ContextStatics;

public final class API {
    private static final int preprocess = 2;
    private static final int parse1 = 4;
    private static final int parse2 = 8;
    private static final int analyze1 = 16;
    private static final int analyze2 = 32;
    private static final int analyze3 = 64;
    private static final int analyze4 = 128;
    private static final int resolveType = 1024;
    private static final int generate = 8192;
    private static final int resolveImportStatements = 16384;
    private static final int adjustQNames = 32768;
    private static final int extraSources = 65536;
    private static final MultiName[] multiNames;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void useAS3() {
        System.setProperty("AS3", "");
        System.setProperty("AVMPLUS", "");
    }

    public static void useConsoleLogger() {
        API.useConsoleLogger(true, true, true, true);
    }

    public static void useConsoleLogger(boolean isInfoEnabled, boolean isDebugEnabled, boolean isWarningEnabled, boolean isErrorEnabled) {
        ThreadLocalToolkit.setLogger(new Console(isInfoEnabled, isDebugEnabled, isWarningEnabled, isErrorEnabled));
    }

    public static void runBenchmark() {
        Benchmark b;
        try {
            Class<?> benchmarkClass = Class.forName(System.getProperty("flex2.compiler.benchmark"), true, Thread.currentThread().getContextClassLoader());
            b = (Benchmark)benchmarkClass.newInstance();
        }
        catch (Exception e) {
            b = new Benchmark();
        }
        ThreadLocalToolkit.setBenchmark(b);
        ThreadLocalToolkit.resetBenchmark();
    }

    public static void disableBenchmark() {
        ThreadLocalToolkit.setBenchmark(null);
    }

    public static void usePathResolver() {
        API.usePathResolver(null);
    }

    public static void usePathResolver(SinglePathResolver resolver) {
        PathResolver pathResolver = new PathResolver();
        if (resolver != null) {
            pathResolver.addSinglePathResolver(resolver);
        }
        pathResolver.addSinglePathResolver(LocalFilePathResolver.getSingleton());
        pathResolver.addSinglePathResolver(URLPathResolver.getSingleton());
        ThreadLocalToolkit.setPathResolver(pathResolver);
    }

    public static void removePathResolver() {
        ThreadLocalToolkit.setPathResolver(null);
        ThreadLocalToolkit.resetResolvedPaths();
    }

    public static void setupHeadless(Configuration configuration) {
        if (configuration.getCompilerConfiguration().headlessServer()) {
            try {
                Properties systemProps = System.getProperties();
                systemProps.put("java.awt.headless", "true");
                System.setProperties(systemProps);
            }
            catch (SecurityException securityException) {
                ThreadLocalToolkit.log(new UnableToSetHeadless());
            }
        }
    }

    public static NameMappings getNameMappings(Configuration configuration) {
        NameMappings mappings = new NameMappings();
        Map manifests = configuration.getCompilerConfiguration().getNamespacesConfiguration().getManifestMappings();
        if (manifests != null) {
            Iterator i = manifests.keySet().iterator();
            while (i.hasNext()) {
                String ns = (String)i.next();
                VirtualFile path = (VirtualFile)manifests.get(ns);
                ManifestParser.parse(ns, path, mappings);
            }
        }
        return mappings;
    }

    private static void batch1(List sources, List units, DependencyGraph igraph, DependencyGraph dgraph, SymbolTable symbolTable, flex2.compiler.Compiler[] compilers, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, CompilerSwcContext swcContext, Configuration configuration) {
        int start = 0;
        int end = sources.size();
        while (start < end && API.preprocess(sources, compilers, start, end, symbolTable.getSuppressWarningsIncremental()) && !API.tooManyErrors() && !API.forcedToStop() && API.parse1(sources, units, igraph, dgraph, compilers, symbolTable, start, end) && !API.tooManyErrors() && !API.forcedToStop()) {
            CompilerConfiguration config;
            API.resolveInheritance(sources, igraph, dgraph, symbolTable, sourceList, sourcePath, resources, swcContext, start, end);
            API.addGeneratedSources(sources, igraph, dgraph, resources, symbolTable, configuration, start, end);
            start = end;
            if (start < (end = sources.size())) continue;
            if (!API.sortInheritance(sources, units, igraph) || !API.parse2(sources, compilers, symbolTable) || API.tooManyErrors() || API.forcedToStop() || !API.analyze(sources, compilers, symbolTable, 1) || API.tooManyErrors() || API.forcedToStop()) break;
            API.resolveNamespace(sources, igraph, dgraph, symbolTable, sourceList, sourcePath, resources, swcContext, 0, end);
            API.addGeneratedSources(sources, igraph, dgraph, resources, symbolTable, configuration, 0, end);
            start = end;
            if (start < (end = sources.size())) continue;
            if (!API.analyze(sources, compilers, symbolTable, 2) || API.tooManyErrors() || API.forcedToStop()) break;
            API.resolveType(sources, units, igraph, dgraph, symbolTable, sourceList, sourcePath, resources, swcContext);
            CompilerConfiguration compilerConfiguration = config = configuration != null ? configuration.getCompilerConfiguration() : null;
            if (config != null && config.strict()) {
                API.resolveImportStatements(sources, units, sourcePath, swcContext);
            }
            if (config != null && (config.strict() || config.warnings())) {
                API.resolveExpression(sources, units, igraph, dgraph, symbolTable, sourceList, sourcePath, resources, swcContext, configuration);
            }
            if ((start = end) < (end = sources.size())) continue;
            if (!API.analyze(sources, compilers, symbolTable, 3) || API.tooManyErrors() || API.forcedToStop() || !API.analyze(sources, compilers, symbolTable, 4) || API.tooManyErrors() || API.forcedToStop() || !API.generate(sources, units, compilers, symbolTable) || API.tooManyErrors() || API.forcedToStop()) break;
            API.markDone(sources, units);
            if (!API.postprocess(sources, units, compilers, symbolTable) || API.tooManyErrors() || API.forcedToStop()) break;
            API.resolveExpression(sources, units, igraph, dgraph, symbolTable, sourceList, sourcePath, resources, swcContext, configuration);
            API.addGeneratedSources(sources, igraph, dgraph, resources, symbolTable, configuration, 0, end);
            start = end;
            end = sources.size();
        }
        API.adjustQNames(units, igraph, symbolTable);
    }

    private static void batch2(List sources, List units, DependencyGraph igraph, DependencyGraph dgraph, SymbolTable symbolTable, flex2.compiler.Compiler[] compilers, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, CompilerSwcContext swcContext, Configuration configuration) {
        CompilerConfiguration config = configuration != null ? configuration.getCompilerConfiguration() : null;
        ArrayList targets = new ArrayList(sources.size());
        units.clear();
        int size = sources.size();
        for (int i = 0; i < size; ++i) {
            Source s = (Source)sources.get(i);
            if (s != null && s.isCompiled()) {
                units.add(s.getCompilationUnit());
                continue;
            }
            units.add(null);
        }
        while (API.nextSource(sources, units, igraph, dgraph, targets, symbolTable, configuration) > 0) {
            int postprocessCount = 0;
            int size2 = targets.size();
            for (int i = 0; i < size2; ++i) {
                Source s = (Source)targets.get(i);
                if (s == null) continue;
                int w = API.getCompilationUnitWorkflow(s);
                if ((w & 2) == 0) {
                    API.preprocess(sources, compilers, i, i + 1, symbolTable.getSuppressWarningsIncremental());
                } else if ((w & 4) == 0) {
                    API.parse1(sources, units, igraph, dgraph, compilers, symbolTable, i, i + 1);
                    API.resolveInheritance(sources, igraph, dgraph, symbolTable, sourceList, sourcePath, resources, swcContext, i, i + 1);
                    API.addGeneratedSources(sources, igraph, dgraph, resources, symbolTable, configuration, i, i + 1);
                } else if ((w & 8) == 0) {
                    API.parse2(sources, compilers, symbolTable, i, i + 1);
                    API.addGeneratedSources(sources, igraph, dgraph, resources, symbolTable, configuration, i, i + 1);
                } else if ((w & 0x10) == 0) {
                    API.analyze(sources, compilers, symbolTable, i, i + 1, 1);
                    API.resolveNamespace(sources, igraph, dgraph, symbolTable, sourceList, sourcePath, resources, swcContext, i, i + 1);
                    API.addGeneratedSources(sources, igraph, dgraph, resources, symbolTable, configuration, i, i + 1);
                } else if ((w & 0x20) == 0) {
                    API.analyze(sources, compilers, symbolTable, i, i + 1, 2);
                    API.resolveType(sources, units, igraph, dgraph, symbolTable, sourceList, sourcePath, resources, swcContext, i, i + 1);
                    if (config.strict()) {
                        API.resolveImportStatements(sources, units, sourcePath, swcContext, i, i + 1);
                    }
                    API.resolveExpression(sources, units, igraph, dgraph, symbolTable, sourceList, sourcePath, resources, swcContext, configuration, i, i + 1);
                } else if ((w & 0x40) == 0) {
                    API.analyze(sources, compilers, symbolTable, i, i + 1, 3);
                } else if ((w & 0x80) == 0) {
                    API.analyze(sources, compilers, symbolTable, i, i + 1, 4);
                } else if ((w & 0x2000) == 0) {
                    API.generate(sources, units, compilers, symbolTable, i, i + 1);
                    API.addGeneratedSources(sources, igraph, dgraph, resources, symbolTable, configuration, i, i + 1);
                    API.resolveExpression(sources, units, igraph, dgraph, symbolTable, sourceList, sourcePath, resources, swcContext, configuration, i, i + 1);
                    API.markDone(sources, units, i, i + 1);
                }
                if (API.tooManyErrors() || API.forcedToStop()) break;
                if ((w & 0x2000) != 0) {
                    API.postprocess(sources, units, compilers, symbolTable, i, i + 1);
                    API.resolveExpression(sources, units, igraph, dgraph, symbolTable, sourceList, sourcePath, resources, swcContext, configuration, i, i + 1);
                    ++postprocessCount;
                }
                if (API.tooManyErrors() || API.forcedToStop()) break;
            }
            if ((postprocessCount != targets.size() || sources.size() != targets.size()) && !API.tooManyErrors() && !API.forcedToStop()) continue;
            break;
        }
        API.adjustQNames(units, igraph, symbolTable);
    }

    private static int nextSource(List sources, List units, DependencyGraph igraph, DependencyGraph dgraph, List targets, SymbolTable symbolTable, Configuration configuration) {
        int count = 0;
        int isDone = 0;
        boolean strict = configuration.getCompilerConfiguration().strict();
        boolean warnings = configuration.getCompilerConfiguration().warnings();
        int factor = configuration.getCompilerConfiguration().factor();
        targets.clear();
        int size = sources.size();
        for (int i = targets.size(); i < size; ++i) {
            targets.add(null);
        }
        HashSet processed = new HashSet();
        for (int i = sources.size() - 1; i >= 0; --i) {
            boolean okay;
            Source s = (Source)sources.get(i);
            CompilationUnit u = s != null ? s.getCompilationUnit() : null;
            int w = API.getCompilationUnitWorkflow(s);
            if (w == 0 || (w & 2) == 0 || (w & 4) == 0) {
                boolean bl = okay = s.getLogger() == null || s.getLogger().errorCount() == 0;
                if (!okay) continue;
                targets.set(i, s);
                ++count;
                continue;
            }
            if ((w & 8) == 0) {
                boolean bl = okay = (s.getLogger() == null || s.getLogger().errorCount() == 0) && API.check(u, u.inheritance, symbolTable, 8);
                if (!okay) continue;
                targets.set(i, s);
                ++count;
                continue;
            }
            if ((w & 0x10) == 0) {
                boolean bl = okay = s.getLogger() == null || s.getLogger().errorCount() == 0;
                if (!okay) continue;
                targets.set(i, s);
                ++count;
                continue;
            }
            if ((w & 0x20) == 0) {
                okay = (s.getLogger() == null || s.getLogger().errorCount() == 0) && API.checkInheritance(u, u.inheritance, symbolTable, 32, processed) && API.check(u, u.namespaces, symbolTable, 32);
                processed.clear();
                if (!okay) continue;
                targets.set(i, s);
                ++count;
                continue;
            }
            if ((w & 0x40) == 0) {
                okay = (s.getLogger() == null || s.getLogger().errorCount() == 0) && API.checkInheritance(u, u.inheritance, symbolTable, 64, processed) && API.check(u, u.types, symbolTable, 32) && API.check(u, u.namespaces, symbolTable, 64) && (!strict && !warnings || API.check(u, u.expressions, symbolTable, 32));
                processed.clear();
                if (!okay) continue;
                targets.set(i, s);
                ++count;
                continue;
            }
            if ((w & 0x80) == 0) {
                okay = (s.getLogger() == null || s.getLogger().errorCount() == 0) && API.checkInheritance(u, u.inheritance, symbolTable, 128, processed) && API.check(u, u.namespaces, symbolTable, 128) && API.checkDeep(u, u.types, symbolTable, processed) && (!strict && !warnings || API.checkDeep(u, u.expressions, symbolTable, processed));
                processed.clear();
                if (!okay) continue;
                targets.set(i, s);
                ++count;
                continue;
            }
            if ((w & 0x2000) == 0) {
                if (s.getLogger() != null && s.getLogger().errorCount() != 0) continue;
                targets.set(i, s);
                ++count;
                continue;
            }
            isDone = s.getLogger() == null || s.getLogger().errorCount() == 0 ? isDone + 1 : isDone;
        }
        if (count > 0) {
            int w;
            Source s;
            int i;
            boolean[] bits = new boolean[targets.size()];
            double maxBudget = 100.0;
            double budget = 0.0;
            for (i = targets.size() - 1; i >= 0 && budget < maxBudget; --i) {
                s = (Source)targets.get(i);
                if (s == null || (w = API.getCompilationUnitWorkflow(s)) == 0 || (w & 2) == 0 || (w & 4) == 0 || (w & 8) == 0 || (w & 0x10) == 0 || (w & 0x20) == 0 || (w & 0x40) == 0 || (w & 0x80) == 0 || (w & 0x2000) != 0) continue;
                bits[i] = true;
            }
            for (i = targets.size() - 1; i >= 0 && budget < maxBudget; --i) {
                s = (Source)targets.get(i);
                if (s == null || (w = API.getCompilationUnitWorkflow(s)) == 0 || (w & 2) == 0 || (w & 4) == 0 || (w & 8) == 0 || (w & 0x10) == 0 || (w & 0x20) == 0 || (w & 0x40) != 0) continue;
                bits[i] = true;
            }
            for (i = targets.size() - 1; i >= 0 && budget < maxBudget; --i) {
                s = (Source)targets.get(i);
                if (s == null || (w = API.getCompilationUnitWorkflow(s)) == 0 || (w & 2) == 0 || (w & 4) == 0 || (w & 8) == 0 || (w & 0x10) == 0 || (w & 0x20) == 0 || (w & 0x40) == 0 || (w & 0x80) != 0) continue;
                bits[i] = true;
            }
            for (i = targets.size() - 1; i >= 0 && budget < maxBudget; --i) {
                s = (Source)targets.get(i);
                if (s == null || (w = API.getCompilationUnitWorkflow(s)) == 0 || (w & 2) == 0 || (w & 4) == 0 || (w & 8) == 0 || (w & 0x10) != 0) continue;
                bits[i] = true;
            }
            for (i = targets.size() - 1; i >= 0 && budget < maxBudget; --i) {
                s = (Source)targets.get(i);
                if (s == null || (w = API.getCompilationUnitWorkflow(s)) != 0) continue;
                bits[i] = true;
            }
            for (i = targets.size() - 1; i >= 0 && budget < maxBudget; --i) {
                s = (Source)targets.get(i);
                if (s == null || (w = API.getCompilationUnitWorkflow(s)) == 0 || (w & 2) == 0 || (w & 4) == 0 || (w & 8) == 0 || (w & 0x10) == 0 || (w & 0x20) != 0 || !"application/x-actionscript-bytecode".equals(s.getMimeType())) continue;
                bits[i] = true;
            }
            for (i = targets.size() - 1; i >= 0 && budget < maxBudget; --i) {
                s = (Source)targets.get(i);
                if (s == null || (w = API.getCompilationUnitWorkflow(s)) == 0 || (w & 2) == 0 || (w & 4) == 0 || (w & 8) != 0 || !"application/x-actionscript-bytecode".equals(s.getMimeType())) continue;
                bits[i] = true;
            }
            for (i = targets.size() - 1; i >= 0 && budget < maxBudget; --i) {
                s = (Source)targets.get(i);
                if (s == null || (w = API.getCompilationUnitWorkflow(s)) == 0 || (w & 2) == 0 || (w & 4) != 0 || !"application/x-actionscript-bytecode".equals(s.getMimeType())) continue;
                bits[i] = true;
            }
            for (i = targets.size() - 1; i >= 0 && budget < maxBudget; --i) {
                s = (Source)targets.get(i);
                if (s == null || (w = API.getCompilationUnitWorkflow(s)) == 0 || (w & 2) == 0 || (w & 4) == 0 || (w & 8) == 0 || (w & 0x10) == 0 || (w & 0x20) != 0 || "application/x-actionscript-bytecode".equals(s.getMimeType())) continue;
                budget += API.calculateBudget(s, factor);
                bits[i] = true;
            }
            for (i = targets.size() - 1; i >= 0 && budget < maxBudget; --i) {
                s = (Source)targets.get(i);
                if (s == null || (w = API.getCompilationUnitWorkflow(s)) == 0 || (w & 2) == 0 || (w & 4) == 0 || (w & 8) != 0 || "application/x-actionscript-bytecode".equals(s.getMimeType())) continue;
                budget += API.calculateBudget(s, factor);
                bits[i] = true;
            }
            for (i = targets.size() - 1; i >= 0 && budget < maxBudget; --i) {
                s = (Source)targets.get(i);
                if (s == null || (w = API.getCompilationUnitWorkflow(s)) == 0 || (w & 2) == 0 || (w & 4) != 0 || "application/x-actionscript-bytecode".equals(s.getMimeType())) continue;
                budget += API.calculateBudget(s, factor);
                bits[i] = true;
            }
            count = 0;
            int size2 = bits.length;
            for (i = 0; i < size2; ++i) {
                if (!bits[i]) {
                    targets.set(i, null);
                    continue;
                }
                ++count;
            }
        } else if (count == 0 && isDone == sources.size()) {
            targets.clear();
            targets.addAll(sources);
            count = targets.size();
        } else if (count == 0 && isDone != sources.size()) {
            API.detectCycles(sources, igraph);
            if (!$assertionsDisabled && ThreadLocalToolkit.errorCount() <= 0) {
                throw new AssertionError((Object)"There is a problem in one of the compiler algorithms. Please use --conservative=true to compile. Also, please file a bug report.");
            }
        }
        return count;
    }

    private static double calculateBudget(Source s, int factor) {
        String mimeType = s.getMimeType();
        if ("text/mxml".equals(mimeType)) {
            return (double)s.size() * 4.5 / (double)factor;
        }
        if ("text/as".equals(mimeType)) {
            return s.size() / (long)factor;
        }
        return 0.0;
    }

    private static int calculateCheckBitsMask(int id, int workflow) {
        int j = id - 1;
        int k = 0;
        switch (workflow) {
            case 8: {
                k = 0;
                break;
            }
            case 32: {
                k = 1;
                break;
            }
            case 64: {
                k = 2;
                break;
            }
            case 128: {
                k = 3;
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
        return 1 << j * 4 + k;
    }

    private static boolean check(CompilationUnit unit, MultiNameSet types, SymbolTable symbolTable, int workflow) {
        int mask = API.calculateCheckBitsMask(types.getId(), workflow);
        if ((unit.checkBits & mask) > 0) {
            return true;
        }
        Iterator i = types.iterator();
        while (i.hasNext()) {
            Object name = i.next();
            if (name instanceof QName) {
                QName qName = (QName)name;
                Source s = symbolTable.findSourceByQName(qName);
                CompilationUnit u = s != null ? s.getCompilationUnit() : null;
                if (unit == u) continue;
                if (u == null || (u.getWorkflow() & workflow) == 0) {
                    return false;
                }
                if (u == null || u.typeInfo == null) {
                    return false;
                }
                if (s.getLogger() == null || s.getLogger().errorCount() <= 0) continue;
                return false;
            }
            return false;
        }
        unit.checkBits |= mask;
        return true;
    }

    private static boolean checkInheritance(CompilationUnit unit, MultiNameSet types, SymbolTable symbolTable, int workflow, Set processed) {
        processed.add(unit.getSource().getName());
        if (!API.check(unit, types, symbolTable, workflow)) {
            return false;
        }
        Iterator i = types.iterator();
        while (i.hasNext()) {
            Object name = i.next();
            if (name instanceof QName) {
                CompilationUnit u;
                QName qName = (QName)name;
                Source s = symbolTable.findSourceByQName(qName);
                CompilationUnit compilationUnit = u = s != null ? s.getCompilationUnit() : null;
                if (u == null) {
                    return false;
                }
                if (unit == u || processed.contains(s.getName()) || API.checkInheritance(u, u.inheritance, symbolTable, workflow, processed)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private static boolean checkDeep(CompilationUnit unit, MultiNameSet types, SymbolTable symbolTable, Set processed) {
        int mask = API.calculateCheckBitsMask(types.getId(), 64);
        if ((unit.checkBits & mask) > 0) {
            return true;
        }
        processed.add(unit.getSource().getName());
        if (!API.check(unit, types, symbolTable, 64)) {
            return false;
        }
        Iterator i = types.iterator();
        while (i.hasNext()) {
            Object name = i.next();
            if (name instanceof QName) {
                CompilationUnit u;
                QName qName = (QName)name;
                Source s = symbolTable.findSourceByQName(qName);
                CompilationUnit compilationUnit = u = s != null ? s.getCompilationUnit() : null;
                if (u == null) {
                    return false;
                }
                if (unit == u || processed.contains(s.getName())) continue;
                if (!API.checkDeep(u, u.inheritance, symbolTable, processed)) {
                    return false;
                }
                if (!API.checkDeep(u, u.types, symbolTable, processed)) {
                    return false;
                }
                if (API.checkDeep(u, u.expressions, symbolTable, processed)) continue;
                return false;
            }
            return false;
        }
        unit.checkBits |= mask;
        return true;
    }

    private static int getCompilationUnitWorkflow(Source s) {
        if (!s.isPreprocessed()) {
            return 0;
        }
        if (s.getCompilationUnit() == null || (s.getCompilationUnit().getWorkflow() & 4) == 0) {
            return 2;
        }
        return s.getCompilationUnit().getWorkflow();
    }

    private static void batch(List sources, List units, DependencyGraph igraph, DependencyGraph dgraph, SymbolTable symbolTable, flex2.compiler.Compiler[] compilers, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, CompilerSwcContext swcContext, Configuration configuration, boolean useFileSpec) throws CompilerException {
        do {
            units.clear();
            if (useFileSpec || configuration.getCompilerConfiguration().useConservativeAlgorithm()) {
                API.batch1(sources, units, igraph, dgraph, symbolTable, compilers, sourceList, sourcePath, resources, swcContext, configuration);
            } else {
                API.batch2(sources, units, igraph, dgraph, symbolTable, compilers, sourceList, sourcePath, resources, swcContext, configuration);
            }
            symbolTable.perCompileData.reuse();
            if (swcContext.errorLocations().size() > 0) {
                Iterator it = swcContext.errorLocations().iterator();
                while (it.hasNext()) {
                    ThreadLocalToolkit.log(new IncompatibleSWCArchive((String)it.next()));
                }
            }
            if (ThreadLocalToolkit.errorCount() <= 0) continue;
            throw new CompilerException();
        } while (!API.forcedToStop() && API.unitsReset(units) > 0);
    }

    public static List compileSwc(FileSpec fileSpec, Collection classes, SourcePath sourcePath, ResourceContainer resources, ResourceBundlePath bundlePath, CompilerSwcContext swcContext, SymbolTable symbolTable, Configuration configuration, flex2.compiler.Compiler[] compilers, PreLink preLink, Map licenseMap) throws LicenseException, CompilerException {
        return API.compile(fileSpec, null, classes, sourcePath, resources, bundlePath, swcContext, symbolTable, configuration, compilers, preLink, licenseMap, new ArrayList());
    }

    public static List compile(FileSpec fileSpec, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, ResourceBundlePath bundlePath, CompilerSwcContext swcContext, SymbolTable symbolTable, Configuration configuration, flex2.compiler.Compiler[] compilers, PreLink preLink, Map licenseMap) throws LicenseException, CompilerException {
        return API.compile(fileSpec, sourceList, null, sourcePath, resources, bundlePath, swcContext, symbolTable, configuration, compilers, preLink, licenseMap, new ArrayList());
    }

    public static List compile(FileSpec fileSpec, SourceList sourceList, Collection classes, SourcePath sourcePath, ResourceContainer resources, ResourceBundlePath bundlePath, CompilerSwcContext swcContext, Configuration configuration, flex2.compiler.Compiler[] compilers, PreLink preLink, Map licenseMap, List sources) throws LicenseException, CompilerException {
        return API.compile(fileSpec, sourceList, classes, sourcePath, resources, bundlePath, swcContext, SymbolTable.newSymbolTable(configuration), configuration, compilers, preLink, licenseMap, sources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List compile(FileSpec fileSpec, SourceList sourceList, Collection classes, SourcePath sourcePath, ResourceContainer resources, ResourceBundlePath bundlePath, CompilerSwcContext swcContext, SymbolTable symbolTable, Configuration configuration, flex2.compiler.Compiler[] compilers, PreLink preLink, Map licenseMap, List sources) throws LicenseException, CompilerException {
        ArrayList units;
        ProgressMeter meter;
        LocalizationManager l10n;
        block23: {
            ArrayList arrayList;
            block22: {
                ArrayList arrayList2;
                block21: {
                    ArrayList arrayList3;
                    block20: {
                        if (sourcePath != null) {
                            sourcePath.displayWarnings();
                        }
                        l10n = ThreadLocalToolkit.getLocalizationManager();
                        meter = ThreadLocalToolkit.getProgressMeter();
                        if (meter != null) {
                            meter.start();
                        }
                        units = new ArrayList();
                        DependencyGraph igraph = new DependencyGraph();
                        DependencyGraph dgraph = null;
                        boolean useFileSpec = false;
                        if (fileSpec != null) {
                            sources.addAll(fileSpec.retrieveSources());
                            boolean bl = useFileSpec = sources.size() > 0;
                        }
                        if (sourceList != null) {
                            sources.addAll(sourceList.retrieveSources());
                        }
                        if (classes != null) {
                            sources.addAll(classes);
                            useFileSpec = useFileSpec || classes.size() > 0;
                        }
                        API.addVerticesToGraphs(sources, igraph, dgraph);
                        try {
                            API.getCommonBuiltinClasses(sources, igraph, dgraph, symbolTable, sourceList, sourcePath, resources, swcContext);
                            API.batch(sources, units, igraph, dgraph, symbolTable, compilers, sourceList, sourcePath, resources, swcContext, configuration, useFileSpec);
                            API.getMessagingClasses(sources, igraph, dgraph, symbolTable, sourceList, sourcePath, resources, swcContext, configuration);
                            API.getIncludeClasses(sources, igraph, dgraph, symbolTable, sourceList, sourcePath, resources, swcContext, configuration);
                            API.getIncludeResources(sources, igraph, dgraph, bundlePath, symbolTable, swcContext, configuration);
                            if (ThreadLocalToolkit.errorCount() > 0) {
                                throw new CompilerException();
                            }
                            if (API.forcedToStop()) {
                                arrayList3 = units;
                                Object var23_22 = null;
                                break block20;
                            }
                            API.batch(sources, units, igraph, dgraph, symbolTable, compilers, sourceList, sourcePath, resources, swcContext, configuration, useFileSpec);
                            if (API.forcedToStop()) {
                                arrayList2 = units;
                                break block21;
                            }
                            if (preLink != null) {
                                preLink.run(sources, units, fileSpec, sourceList, sourcePath, bundlePath, resources, symbolTable, swcContext, configuration);
                                if (ThreadLocalToolkit.errorCount() > 0) {
                                    throw new CompilerException();
                                }
                                API.batch(sources, units, igraph, dgraph, symbolTable, compilers, sourceList, sourcePath, resources, swcContext, configuration, useFileSpec);
                            }
                            int count = 0;
                            while (++count < 1000) {
                                int numSources = sources.size();
                                API.getExtraSources(sources, igraph, dgraph, sourceList, sourcePath, resources, bundlePath, symbolTable, swcContext, configuration, licenseMap);
                                if (ThreadLocalToolkit.errorCount() > 0) {
                                    throw new CompilerException();
                                }
                                API.batch(sources, units, igraph, dgraph, symbolTable, compilers, sourceList, sourcePath, resources, swcContext, configuration, useFileSpec);
                                if (sources.size() == numSources) break;
                                if (!API.forcedToStop()) continue;
                                arrayList = units;
                                break block22;
                            }
                            API.checkResourceBundles(sources, symbolTable);
                            if (!$assertionsDisabled && count >= 1000) {
                                throw new AssertionError();
                            }
                            break block23;
                        }
                        catch (Throwable throwable) {
                            Object var23_26 = null;
                            if (ThreadLocalToolkit.getBenchmark() != null) {
                                ThreadLocalToolkit.getBenchmark().benchmark(l10n.getLocalizedTextString((Object)new OutputTime(sources.size())));
                            }
                            swcContext.close();
                            symbolTable.cleanClassTable();
                            symbolTable.adjustProgress();
                            if (meter == null) throw throwable;
                            meter.end();
                            throw throwable;
                        }
                    }
                    if (ThreadLocalToolkit.getBenchmark() != null) {
                        ThreadLocalToolkit.getBenchmark().benchmark(l10n.getLocalizedTextString((Object)new OutputTime(sources.size())));
                    }
                    swcContext.close();
                    symbolTable.cleanClassTable();
                    symbolTable.adjustProgress();
                    if (meter == null) return arrayList3;
                    meter.end();
                    return arrayList3;
                }
                Object var23_23 = null;
                if (ThreadLocalToolkit.getBenchmark() != null) {
                    ThreadLocalToolkit.getBenchmark().benchmark(l10n.getLocalizedTextString((Object)new OutputTime(sources.size())));
                }
                swcContext.close();
                symbolTable.cleanClassTable();
                symbolTable.adjustProgress();
                if (meter == null) return arrayList2;
                meter.end();
                return arrayList2;
            }
            Object var23_24 = null;
            if (ThreadLocalToolkit.getBenchmark() != null) {
                ThreadLocalToolkit.getBenchmark().benchmark(l10n.getLocalizedTextString((Object)new OutputTime(sources.size())));
            }
            swcContext.close();
            symbolTable.cleanClassTable();
            symbolTable.adjustProgress();
            if (meter == null) return arrayList;
            meter.end();
            return arrayList;
        }
        Object var23_25 = null;
        if (ThreadLocalToolkit.getBenchmark() != null) {
            ThreadLocalToolkit.getBenchmark().benchmark(l10n.getLocalizedTextString((Object)new OutputTime(sources.size())));
        }
        swcContext.close();
        symbolTable.cleanClassTable();
        symbolTable.adjustProgress();
        if (meter == null) return units;
        meter.end();
        return units;
    }

    private static void getCommonBuiltinClasses(List sources, DependencyGraph igraph, DependencyGraph dgraph, SymbolTable symbolTable, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, CompilerSwcContext swcContext) {
        int size = multiNames.length;
        for (int i = 0; i < size; ++i) {
            QName qName = API.resolveMultiName("builtin", multiNames[i], sources, sourceList, sourcePath, resources, swcContext, symbolTable);
            if (qName == null) continue;
            Source tailSource = symbolTable.findSourceByQName(qName);
            API.addVertexToGraphs(tailSource, tailSource.getCompilationUnit(), igraph, dgraph);
        }
    }

    private static void getMessagingClasses(List sources, DependencyGraph igraph, DependencyGraph dgraph, SymbolTable symbolTable, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, CompilerSwcContext swcContext, Configuration configuration) {
        ServicesDependencies services = configuration.getCompilerConfiguration().getServicesDependencies();
        if (services != null) {
            Iterator i = services.getChannelClasses().iterator();
            while (i.hasNext()) {
                String clientType = (String)i.next();
                if (clientType == null) continue;
                QName qName = API.resolveMultiName("messaging", new MultiName(NameFormatter.toColon(clientType)), sources, sourceList, sourcePath, resources, swcContext, symbolTable);
                if (qName == null) {
                    ThreadLocalToolkit.log((CompilerMessage)new ChannelDefinitionNotFound(clientType), configuration.getCompilerConfiguration().getServices().getNameForReporting());
                    continue;
                }
                Source s = symbolTable.findSourceByQName(qName);
                API.addVertexToGraphs(s, s.getCompilationUnit(), igraph, dgraph);
            }
        }
    }

    private static int unitsReset(List units) {
        int resetCount = 0;
        int n = units.size();
        for (int i = 0; i < n; ++i) {
            CompilationUnit unit = (CompilationUnit)units.get(i);
            Source source = unit.getSource();
            if (!source.isInternal() && !source.isCompiled()) {
                unit.reset();
                ++resetCount;
                continue;
            }
            if (source.isInternal()) continue;
            unit.checkBits = 0;
        }
        return resetCount;
    }

    public static int validateCompilationUnits(FileSpec fileSpec, SourceList sourceList, SourcePath sourcePath, ResourceBundlePath bundlePath, ResourceContainer resources, CompilerSwcContext swcContext, ContextStatics perCompileData, boolean recompile, Configuration configuration) {
        int updateCount;
        String name;
        Iterator k;
        int i;
        CompilationUnit u;
        Source s;
        int i2;
        Source s2;
        int i3;
        final LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
        boolean strict = configuration.getCompilerConfiguration().strict();
        final HashMap<String, Source> updated = new HashMap<String, Source>();
        HashMap<String, Source> updatedWithStableSignature = new HashMap<String, Source>();
        final HashMap<String, Source> affected = new HashMap<String, Source>();
        HashMap<String, Source> deleted = new HashMap<String, Source>();
        final HashMap<String, String> reasons = new HashMap<String, String>();
        final HashMap qnames = new HashMap();
        HashSet<String> includeUpdated = new HashSet<String>();
        HashSet<String> resourceDelegates = new HashSet<String>();
        HashSet<String> namespaces = new HashSet<String>();
        final ArrayList sources = new ArrayList();
        if (fileSpec != null) {
            sources.addAll(fileSpec.sources());
        }
        if (sourceList != null) {
            sources.addAll(sourceList.sources());
        }
        if (sourcePath != null) {
            sources.addAll(sourcePath.sources().values());
        }
        if (bundlePath != null) {
            sources.addAll(bundlePath.sources().values());
        }
        Iterator i4 = resources.sources().iterator();
        while (i4.hasNext()) {
            CompilationUnit u2;
            Source s3 = (Source)i4.next();
            if (s3 == null) continue;
            CompilationUnit compilationUnit = u2 = s3 != null ? s3.getCompilationUnit() : null;
            if (!s3.hasError() && (u2 == null || u2.isDone()) && !s3.isUpdated() && (u2 == null || !u2.getAssets().isUpdated())) continue;
            resourceDelegates.add(s3.getNameForReporting());
            s3.removeCompilationUnit();
        }
        int size = sources.size();
        for (i3 = 0; i3 < size; ++i3) {
            s2 = (Source)sources.get(i3);
            Iterator j = s2.getUpdatedFileIncludes();
            while (j != null && j.hasNext()) {
                VirtualFile f = (VirtualFile)j.next();
                includeUpdated.add(f.getNameForReporting());
            }
        }
        if (recompile || fileSpec != null && fileSpec.isUpdated()) {
            size = sources.size();
            for (i3 = 0; i3 < size; ++i3) {
                s2 = (Source)sources.get(i3);
                affected.put(s2.getName(), s2);
                if (recompile) {
                    reasons.put(s2.getName(), l10n.getLocalizedTextString((Object)new ForceRecompilation()));
                    continue;
                }
                reasons.put(s2.getName(), l10n.getLocalizedTextString((Object)new SourceFileChanged()));
            }
            sources.clear();
        }
        final DependencyGraph graph = new DependencyGraph();
        int size2 = sources.size();
        for (i2 = 0; i2 < size2; ++i2) {
            s = (Source)sources.get(i2);
            if (s == null || (u = s.getCompilationUnit()) == null) continue;
            graph.put(s.getName(), u);
            if (!graph.containsVertex(s.getName())) {
                graph.addVertex(new Vertex(s.getName()));
            }
            Iterator j = u.topLevelDefinitions.iterator();
            while (j.hasNext()) {
                qnames.put(j.next(), s.getName());
            }
        }
        size2 = sources.size();
        for (i2 = 0; i2 < size2; ++i2) {
            s = (Source)sources.get(i2);
            if (s == null || (u = s.getCompilationUnit()) == null) continue;
            String head = s.getName();
            Iterator k2 = u.inheritance.iterator();
            while (k2.hasNext()) {
                QName qname;
                String tail;
                Object obj = k2.next();
                if (!(obj instanceof QName) || (tail = (String)qnames.get(qname = (QName)obj)) == null || head.equals(tail) || graph.dependencyExists(head, tail)) continue;
                graph.addDependency(head, tail);
            }
        }
        size2 = sources.size();
        for (i2 = 0; i2 < size2; ++i2) {
            s = (Source)sources.get(i2);
            if (s == null) continue;
            u = s.getCompilationUnit();
            if (s.hasError() || u != null && !u.isDone() || resourceDelegates.contains(s.getName())) {
                affected.put(s.getName(), s);
                reasons.put(s.getName(), l10n.getLocalizedTextString((Object)new NotFullyCompiled()));
                sources.set(i2, null);
                continue;
            }
            if (!s.exists()) {
                updated.put(s.getName(), s);
                reasons.put(s.getName(), l10n.getLocalizedTextString((Object)new SourceNoLongerExists()));
                deleted.put(s.getName(), s);
                if (u != null) {
                    Iterator j = u.topLevelDefinitions.iterator();
                    while (j.hasNext()) {
                        QName qName = (QName)j.next();
                        namespaces.add(qName.toString());
                    }
                }
                sources.set(i2, null);
                continue;
            }
            if (s.isUpdated()) {
                Long persistedCRC;
                boolean signatureIsStable = false;
                if (u != null && !configuration.getCompilerConfiguration().getDisableIncrementalOptimizations() && !s.getMimeType().equals("text/mxml") && (persistedCRC = u.getSignatureChecksum()) != null) {
                    if (!($assertionsDisabled || s.getMimeType().equals("application/x-actionscript-bytecode") || s.getMimeType().equals("text/as"))) {
                        throw new AssertionError();
                    }
                    Long currentCRC = API.computeSignatureChecksum(configuration, s);
                    boolean bl = signatureIsStable = currentCRC != null && persistedCRC.compareTo(currentCRC) == 0;
                }
                if (signatureIsStable) {
                    updatedWithStableSignature.put(s.getName(), s);
                } else {
                    updated.put(s.getName(), s);
                }
                reasons.put(s.getName(), l10n.getLocalizedTextString((Object)new SourceFileUpdated()));
                sources.set(i2, null);
                continue;
            }
            if (u == null || !u.getAssets().isUpdated()) continue;
            updated.put(s.getName(), s);
            reasons.put(s.getName(), l10n.getLocalizedTextString((Object)new AssetUpdated()));
            sources.set(i2, null);
        }
        Iterator i5 = deleted.values().iterator();
        while (i5.hasNext()) {
            Source s4 = (Source)i5.next();
            if (!s4.isSourcePathOwner()) continue;
            SourcePath sp = (SourcePath)s4.getOwner();
            sp.removeSource(s4);
        }
        size = sources.size();
        for (i = 0; i < size; ++i) {
            SourcePathBase sp;
            s = (Source)sources.get(i);
            if (s == null || !s.isSourcePathOwner() && !s.isResourceBundlePathOwner() || (sp = (SourcePathBase)s.getOwner()).checkPreference(s)) continue;
            affected.put(s.getName(), s);
            reasons.put(s.getName(), l10n.getLocalizedTextString((Object)new NotSourcePathFirstPreference()));
            sources.set(i, null);
        }
        size = sources.size();
        block14: for (i = 0; i < size; ++i) {
            s = (Source)sources.get(i);
            if (s == null || (u = s.getCompilationUnit()) == null) continue;
            MultiNameSet[] dependencies = new MultiNameSet[]{u.inheritance, u.namespaces, u.expressions, u.types};
            boolean valid = true;
            if (deleted.size() > 0) {
                block15: for (int j = 0; j < 4; ++j) {
                    Iterator k3 = dependencies[j].iterator();
                    while (k3.hasNext()) {
                        String location;
                        Object obj = k3.next();
                        if (!(obj instanceof QName) || (location = (String)qnames.get(obj)) == null || !deleted.containsKey(location)) continue;
                        affected.put(s.getName(), s);
                        reasons.put(s.getName(), l10n.getLocalizedTextString((Object)new DependentFileNoLongerExists(location)));
                        sources.set(i, null);
                        valid = false;
                        continue block15;
                    }
                }
            }
            valid = valid && strict;
            k = u.importPackageStatements.iterator();
            while (valid && k.hasNext()) {
                String packageName = (String)k.next();
                if (API.hasPackage(sourcePath, swcContext, packageName)) continue;
                affected.put(s.getName(), s);
                reasons.put(s.getName(), l10n.getLocalizedTextString((Object)new InvalidImportStatement(packageName)));
                sources.set(i, null);
                namespaces.add(packageName);
                valid = false;
                break;
            }
            k = u.importDefinitionStatements.iterator();
            while (valid && k.hasNext()) {
                QName defName = (QName)k.next();
                if (API.hasDefinition(sourcePath, swcContext, defName)) continue;
                affected.put(s.getName(), s);
                reasons.put(s.getName(), l10n.getLocalizedTextString((Object)new InvalidImportStatement(defName.toString())));
                sources.set(i, null);
                namespaces.add(defName.toString());
                valid = false;
                continue block14;
            }
        }
        Algorithms.topologicalSort(graph, new Visitor(){

            public void visit(Object v) {
                String name = (String)((Vertex)v).getWeight();
                CompilationUnit u = (CompilationUnit)graph.get(name);
                if (u != null) {
                    this.checkInheritance(u);
                    this.checkNamespaces(u);
                }
            }

            private void checkInheritance(CompilationUnit u) {
                Iterator j = u.inheritance.iterator();
                while (j.hasNext()) {
                    Object mn = j.next();
                    if (!(mn instanceof QName)) continue;
                    QName qname = (QName)mn;
                    String sourceName = (String)qnames.get(qname);
                    Source s = u.getSource();
                    if (sourceName == null || !updated.containsKey(sourceName) && !affected.containsKey(sourceName)) continue;
                    affected.put(s.getName(), s);
                    reasons.put(s.getName(), l10n.getLocalizedTextString((Object)new SuperclassUpdated(sourceName, qname)));
                    int index = sources.indexOf(s);
                    if (index == -1) continue;
                    sources.set(index, null);
                }
            }

            private void checkNamespaces(CompilationUnit u) {
                Iterator j = u.namespaces.iterator();
                while (j.hasNext()) {
                    Object mn = j.next();
                    if (!(mn instanceof QName)) continue;
                    QName qname = (QName)mn;
                    String sourceName = (String)qnames.get(qname);
                    Source s = u.getSource();
                    if (sourceName == null || !updated.containsKey(sourceName)) continue;
                    affected.put(s.getName(), s);
                    reasons.put(s.getName(), l10n.getLocalizedTextString((Object)new QNameSourceUpdated(sourceName, qname)));
                    int index = sources.indexOf(s);
                    if (index == -1) continue;
                    sources.set(index, null);
                }
            }
        });
        if (strict) {
            size = sources.size();
            for (i = 0; i < size; ++i) {
                s = (Source)sources.get(i);
                if (s == null || (u = s.getCompilationUnit()) == null) continue;
                MultiNameSet[] dependencies = new MultiNameSet[]{u.expressions, u.types};
                block20: for (int j = 0; j < 2; ++j) {
                    k = dependencies[j].iterator();
                    while (k.hasNext()) {
                        String location;
                        Object obj = k.next();
                        if (!(obj instanceof QName) || (location = (String)qnames.get(obj)) == null || !updated.containsKey(location) && !affected.containsKey(location)) continue;
                        affected.put(s.getName(), s);
                        reasons.put(s.getName(), l10n.getLocalizedTextString((Object)new DependentFileModified(location)));
                        sources.set(i, null);
                        continue block20;
                    }
                }
            }
        }
        Iterator i6 = includeUpdated.iterator();
        while (i6.hasNext()) {
            ThreadLocalToolkit.getLogger().includedFileUpdated((String)i6.next());
        }
        int affectedCount = affected.size();
        API.logReasonAndRemoveCompilationUnit(affected, reasons, includeUpdated);
        API.logReasonAndRemoveCompilationUnit(updated, reasons, includeUpdated);
        API.logReasonAndRemoveCompilationUnit(updatedWithStableSignature, reasons, includeUpdated);
        Iterator i7 = resources.sources().iterator();
        while (i7.hasNext()) {
            s = (Source)i7.next();
            if (s == null || !affected.containsKey(name = s.getNameForReporting()) && !updated.containsKey(name)) continue;
            s.removeCompilationUnit();
        }
        affected.clear();
        int size3 = sources.size();
        for (int i8 = 0; i8 < size3; ++i8) {
            CompilationUnit u3;
            Source s5 = (Source)sources.get(i8);
            if (s5 == null || (u3 = s5.getCompilationUnit()) == null) continue;
            Iterator j = u3.inheritanceHistory.keySet().iterator();
            while (j.hasNext()) {
                MultiName multiName = (MultiName)j.next();
                QName qName = (QName)u3.inheritanceHistory.get(multiName);
                try {
                    if (API.validateMultiName(multiName, qName, sourcePath)) continue;
                    affected.put(s5.getName(), s5);
                    reasons.put(s5.getName(), l10n.getLocalizedTextString((Object)new MultiNameMeaningChanged(multiName, qName)));
                    sources.set(i8, null);
                }
                catch (CompilerException ex) {
                    affected.put(s5.getName(), s5);
                    reasons.put(s5.getName(), ex.getMessage());
                    sources.set(i8, null);
                }
            }
        }
        affectedCount += affected.size();
        API.logReasonAndRemoveCompilationUnit(affected, reasons, includeUpdated);
        Iterator i9 = resources.sources().iterator();
        while (i9.hasNext()) {
            Source s6 = (Source)i9.next();
            if (s6 == null || !affected.containsKey(name = s6.getNameForReporting())) continue;
            s6.removeCompilationUnit();
        }
        resources.refresh();
        if (perCompileData != null) {
            i9 = namespaces.iterator();
            while (i9.hasNext()) {
                String ns = (String)i9.next();
                perCompileData.removeNamespace(ns);
            }
        }
        if ((updateCount = updated.size() + updatedWithStableSignature.size()) + affectedCount > 0) {
            ThreadLocalToolkit.log(new FilesChangedAffected(updateCount, affectedCount));
        }
        return updateCount + affectedCount;
    }

    private static void logReasonAndRemoveCompilationUnit(Map map, Map reasons, Set includeUpdated) {
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            Source s = (Source)map.get(name);
            Iterator j = s.getFileIncludes();
            while (j.hasNext()) {
                VirtualFile f = (VirtualFile)j.next();
                if (includeUpdated.contains(f.getNameForReporting())) continue;
                ThreadLocalToolkit.getLogger().includedFileAffected(f.getNameForReporting());
            }
            s.removeCompilationUnit();
            ThreadLocalToolkit.getLogger().needsCompilation(s.getName(), (String)reasons.get(s.getName()));
        }
    }

    private static Long computeSignatureChecksum(Configuration configuration, Source source) {
        if (!$assertionsDisabled && configuration == null) {
            throw new AssertionError();
        }
        Compiler asc = new Compiler(configuration.getCompilerConfiguration());
        asc.addCompilerExtension(SignatureExtension.getInstance());
        CompilationUnit u = null;
        Logger original = ThreadLocalToolkit.getLogger();
        ThreadLocalToolkit.setLogger(new LocalLogger(null));
        Source tmpSource = asc.preprocess(Source.newSource(source.getBackingFile(), source.getFileTime(), source.getPathRoot(), source.getRelativePath(), source.getShortName(), source.getOwner(), source.isInternal(), source.isRoot(), source.isDebuggable(), source.getFileIncludesSet(), source.getFileIncludeTimes(), source.getLogger()));
        String tmp = SignatureExtension.signatureDirectory;
        SignatureExtension.signatureDirectory = null;
        u = asc.parse1(tmpSource, SymbolTable.newSymbolTable(configuration));
        SignatureExtension.signatureDirectory = tmp;
        ThreadLocalToolkit.setLogger(original);
        return u != null ? u.getSignatureChecksum() : null;
    }

    private static boolean validateMultiName(MultiName multiName, QName qName, SourcePath sourcePath) throws CompilerException {
        int length = multiName.namespaceURI.length;
        for (int i = 0; i < length; ++i) {
            CompilationUnit u;
            String ns = multiName.namespaceURI[i];
            String name = multiName.localPart;
            Source s = sourcePath != null ? sourcePath.findSource(ns, name) : null;
            CompilationUnit compilationUnit = u = s != null ? s.getCompilationUnit() : null;
            if (u != null) {
                ns = u.topLevelDefinitions.first().getNamespace();
            }
            if (s == null || qName.getNamespace().equals(ns) && qName.getLocalPart().equals(name)) continue;
            return false;
        }
        return true;
    }

    private static void addVerticesToGraphs(List sources, DependencyGraph igraph, DependencyGraph dgraph) {
        int size = sources.size();
        for (int i = 0; i < size; ++i) {
            Source s = (Source)sources.get(i);
            if (s == null) continue;
            API.addVertexToGraphs(s, s.getCompilationUnit(), igraph, dgraph);
        }
    }

    private static void addVertexToGraphs(Source s, CompilationUnit u, DependencyGraph igraph, DependencyGraph dgraph) {
        String name = s.getName();
        if (u != null || igraph.get(name) == null) {
            igraph.put(name, u);
        }
        if (!igraph.containsVertex(name)) {
            igraph.addVertex(new Vertex(name));
        }
        if (dgraph != null) {
            dgraph.put(name, s);
            if (!dgraph.containsVertex(name)) {
                dgraph.addVertex(new Vertex(name));
            }
        }
    }

    private static boolean preprocess(List sources, flex2.compiler.Compiler[] compilers, int start, int end, boolean suppressWarnings) {
        boolean result = true;
        for (int i = start; i < end; ++i) {
            Source s = (Source)sources.get(i);
            if (s.isPreprocessed()) continue;
            if ((s = API.preprocess(s, compilers, suppressWarnings)) == null) {
                result = false;
            } else {
                sources.set(i, s);
            }
            if (API.tooManyErrors()) {
                ThreadLocalToolkit.log(new TooManyErrors());
                break;
            }
            if (!API.forcedToStop()) continue;
            ThreadLocalToolkit.log(new ForcedToStop());
            break;
        }
        return result;
    }

    public static void displayWarnings(List units) {
        int size;
        int n = size = units == null ? 0 : units.size();
        for (int i = 0; i < size; ++i) {
            Source s;
            CompilationUnit u = (CompilationUnit)units.get(i);
            Source source = s = u != null ? u.getSource() : null;
            if (s == null || s.getLogger() == null || s.getLogger().warningCount() <= 0 || s.getLogger().isConnected()) continue;
            s.getLogger().displayWarnings(ThreadLocalToolkit.getLogger());
        }
    }

    static Source preprocess(Source s, flex2.compiler.Compiler[] compilers, boolean suppressWarnings) {
        if (!s.isCompiled()) {
            flex2.compiler.Compiler c;
            if (s.getLogger() != null && s.getLogger().warningCount() > 0 && !s.getLogger().isConnected() && !suppressWarnings) {
                s.getLogger().displayWarnings(ThreadLocalToolkit.getLogger());
            }
            if ((c = API.getCompiler(s, compilers)) != null) {
                Logger original = ThreadLocalToolkit.getLogger();
                LocalLogger local = new LocalLogger(original, s);
                local.setLocalizationManager(ThreadLocalToolkit.getLocalizationManager());
                s.setLogger(local);
                ThreadLocalToolkit.setLogger(local);
                s = c.preprocess(s);
                ThreadLocalToolkit.setLogger(original);
                if (local.errorCount() > 0) {
                    if (s != null) {
                        s.disconnectLogger();
                    }
                    s = null;
                } else {
                    s.setPreprocessed();
                }
            } else {
                s = null;
            }
        }
        return s;
    }

    private static boolean parse1(List sources, List units, DependencyGraph igraph, DependencyGraph dgraph, flex2.compiler.Compiler[] compilers, SymbolTable symbolTable, int start, int end) {
        boolean result = true;
        for (int i = start; i < end; ++i) {
            Source s = (Source)sources.get(i);
            CompilationUnit u = API.parse1(s, compilers, symbolTable);
            if (u == null) {
                result = false;
                s.disconnectLogger();
            }
            for (int j = units.size(); j < i + 1; ++j) {
                units.add(null);
            }
            units.set(i, u);
            API.addVertexToGraphs(s, u, igraph, dgraph);
            API.calculateProgress(sources, symbolTable);
            if (API.tooManyErrors()) {
                ThreadLocalToolkit.log(new TooManyErrors());
                break;
            }
            if (!API.forcedToStop()) continue;
            ThreadLocalToolkit.log(new ForcedToStop());
            break;
        }
        return result;
    }

    static CompilationUnit parse1(Source s, flex2.compiler.Compiler[] compilers, SymbolTable symbolTable) {
        if (s.isCompiled()) {
            return s.getCompilationUnit();
        }
        CompilationUnit u = null;
        flex2.compiler.Compiler c = API.getCompiler(s, compilers);
        if (c != null) {
            Logger original = ThreadLocalToolkit.getLogger();
            LocalLogger local = s.getLogger();
            ThreadLocalToolkit.setLogger(local);
            u = c.parse1(s, symbolTable);
            ThreadLocalToolkit.setLogger(original);
            if (local.errorCount() == 0) {
                symbolTable.registerQNames(u.topLevelDefinitions, u.getSource());
                u.setState(1);
                u.setWorkflow(2);
                u.setWorkflow(4);
            }
        }
        return u;
    }

    private static boolean parse2(List sources, flex2.compiler.Compiler[] compilers, SymbolTable symbolTable, int start, int end) {
        boolean result = true;
        for (int i = start; i < end; ++i) {
            Source source = (Source)sources.get(i);
            CompilationUnit u = source.getCompilationUnit();
            if ((u.getWorkflow() & 8) != 0) continue;
            if (!API.parse2(u, compilers, symbolTable)) {
                result = false;
                u.getSource().disconnectLogger();
            }
            API.calculateProgress(sources, symbolTable);
            if (API.tooManyErrors()) {
                ThreadLocalToolkit.log(new TooManyErrors());
                break;
            }
            if (!API.forcedToStop()) continue;
            ThreadLocalToolkit.log(new ForcedToStop());
            break;
        }
        return result;
    }

    private static boolean parse2(List sources, flex2.compiler.Compiler[] compilers, SymbolTable symbolTable) {
        return API.parse2(sources, compilers, symbolTable, 0, sources.size());
    }

    private static boolean parse2(CompilationUnit u, flex2.compiler.Compiler[] compilers, SymbolTable symbolTable) {
        Source s = u.getSource();
        if (!s.isCompiled()) {
            flex2.compiler.Compiler c = API.getCompiler(s, compilers);
            if (c != null) {
                Logger original = ThreadLocalToolkit.getLogger();
                LocalLogger local = s.getLogger();
                ThreadLocalToolkit.setLogger(local);
                c.parse2(u, symbolTable);
                u.setWorkflow(8);
                ThreadLocalToolkit.setLogger(original);
                if (local.errorCount() > 0) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private static boolean analyze(List sources, flex2.compiler.Compiler[] compilers, SymbolTable symbolTable, int phase) {
        return API.analyze(sources, compilers, symbolTable, 0, sources.size(), phase);
    }

    private static boolean analyze(List sources, flex2.compiler.Compiler[] compilers, SymbolTable symbolTable, int start, int end, int phase) {
        boolean result = true;
        for (int i = start; i < end; ++i) {
            Source source = (Source)sources.get(i);
            CompilationUnit u = source.getCompilationUnit();
            if (phase == 1 && (u.getWorkflow() & 0x10) != 0 || phase == 2 && (u.getWorkflow() & 0x20) != 0 || phase == 3 && (u.getWorkflow() & 0x40) != 0 || phase == 4 && (u.getWorkflow() & 0x80) != 0) continue;
            if (!API.analyze(u, compilers, symbolTable, phase)) {
                result = false;
                u.getSource().disconnectLogger();
            }
            API.calculateProgress(sources, symbolTable);
            if (!$assertionsDisabled && u.getSource().getCompilationUnit() != u) {
                throw new AssertionError();
            }
            if (API.tooManyErrors()) {
                ThreadLocalToolkit.log(new TooManyErrors());
                break;
            }
            if (!API.forcedToStop()) continue;
            ThreadLocalToolkit.log(new ForcedToStop());
            break;
        }
        return result;
    }

    private static boolean analyze(CompilationUnit u, flex2.compiler.Compiler[] compilers, SymbolTable symbolTable, int phase) {
        Source s = u.getSource();
        if (!s.isCompiled()) {
            flex2.compiler.Compiler c = API.getCompiler(s, compilers);
            if (c != null) {
                Logger original = ThreadLocalToolkit.getLogger();
                LocalLogger local = s.getLogger();
                ThreadLocalToolkit.setLogger(local);
                if (phase == 1) {
                    c.analyze1(u, symbolTable);
                    if (local.errorCount() == 0 && (s.isSourcePathOwner() || s.isSourceListOwner())) {
                        int size = u.topLevelDefinitions.size();
                        if (size > 1) {
                            ThreadLocalToolkit.log((CompilerMessage)new MoreThanOneDefinition(u.topLevelDefinitions), s);
                        } else if (size < 1) {
                            ThreadLocalToolkit.log((CompilerMessage)new MustHaveOneDefinition(), s);
                        } else if (s.isSourcePathOwner()) {
                            String[] classes;
                            SourcePath owner = (SourcePath)s.getOwner();
                            String[] packages = owner.checkPackageNameDirectoryName(s);
                            if (packages != null) {
                                ThreadLocalToolkit.log((CompilerMessage)new WrongPackageName(packages[0], packages[1]), s);
                            }
                            if ((classes = owner.checkClassNameFileName(s)) != null) {
                                ThreadLocalToolkit.log((CompilerMessage)new WrongDefinitionName(classes[0], classes[1]), s);
                            }
                        } else if (s.isSourceListOwner()) {
                            String[] classes;
                            SourceList owner = (SourceList)s.getOwner();
                            String[] packages = owner.checkPackageNameDirectoryName(s);
                            if (packages != null) {
                                ThreadLocalToolkit.log((CompilerMessage)new WrongPackageName(packages[0], packages[1]), s);
                            }
                            if ((classes = owner.checkClassNameFileName(s)) != null) {
                                ThreadLocalToolkit.log((CompilerMessage)new WrongDefinitionName(classes[0], classes[1]), s);
                            }
                        }
                    }
                    u.setWorkflow(16);
                } else if (phase == 2) {
                    c.analyze2(u, symbolTable);
                    u.setWorkflow(32);
                } else if (phase == 3) {
                    c.analyze3(u, symbolTable);
                    u.setWorkflow(64);
                } else {
                    c.analyze4(u, symbolTable);
                    u.setWorkflow(128);
                }
                ThreadLocalToolkit.setLogger(original);
                if (local.errorCount() > 0) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private static void resolveInheritance(List sources, DependencyGraph igraph, DependencyGraph dgraph, SymbolTable symbolTable, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, CompilerSwcContext swcContext, int start, int end) {
        HashSet<QName> qNames = new HashSet<QName>();
        for (int i = start; i < end; ++i) {
            Source source = (Source)sources.get(i);
            CompilationUnit u = source.getCompilationUnit();
            if (u == null || u.inheritance.size() == 0) continue;
            qNames.clear();
            String head = source.getName();
            String name = source.getNameForReporting();
            Iterator k = u.inheritance.iterator();
            while (k.hasNext()) {
                Object unresolved = k.next();
                if (!(unresolved instanceof MultiName)) continue;
                MultiName mName = (MultiName)unresolved;
                QName qName = API.resolveMultiName(name, mName, sources, sourceList, sourcePath, resources, swcContext, symbolTable);
                if (qName != null) {
                    qNames.add(qName);
                    u.inheritanceHistory.put(mName, qName);
                    Source tailSource = symbolTable.findSourceByQName(qName);
                    String tail = tailSource.getName();
                    API.addVertexToGraphs(tailSource, tailSource.getCompilationUnit(), igraph, dgraph);
                    API.addEdgeToGraphs(igraph, dgraph, head, tail);
                }
                k.remove();
            }
            if (qNames.size() <= 0) continue;
            u.inheritance.addAll(qNames);
        }
    }

    private static void resolveNamespace(List sources, DependencyGraph igraph, DependencyGraph dgraph, SymbolTable symbolTable, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, CompilerSwcContext swcContext, int start, int end) {
        HashSet<QName> qNames = new HashSet<QName>();
        for (int i = start; i < end; ++i) {
            Source source = (Source)sources.get(i);
            CompilationUnit u = source.getCompilationUnit();
            if (u.namespaces.size() == 0) continue;
            qNames.clear();
            String head = source.getName();
            String name = u.getSource().getNameForReporting();
            Iterator k = u.namespaces.iterator();
            while (k.hasNext()) {
                Object unresolved = k.next();
                if (!(unresolved instanceof MultiName)) continue;
                MultiName mName = (MultiName)unresolved;
                QName qName = API.resolveMultiName(name, mName, sources, sourceList, sourcePath, resources, swcContext, symbolTable);
                if (qName != null) {
                    qNames.add(qName);
                    u.namespaceHistory.put(mName, qName);
                    Source tailSource = symbolTable.findSourceByQName(qName);
                    String tail = tailSource.getName();
                    API.addVertexToGraphs(tailSource, tailSource.getCompilationUnit(), igraph, dgraph);
                    API.addEdgeToGraphs(null, dgraph, head, tail);
                }
                k.remove();
            }
            if (qNames.size() <= 0) continue;
            u.namespaces.addAll(qNames);
        }
    }

    private static int findDefinition(List sources, SourceList sourceList, SourcePathBase sourcePath, ResourceContainer resources, CompilerSwcContext swcContext, String namespaceURI, String localPart) throws CompilerException {
        Source s;
        Source source = s = sourceList != null ? sourceList.findSource(namespaceURI, localPart) : null;
        if (s == null) {
            Source source2 = s = sourcePath != null ? sourcePath.findSource(namespaceURI, localPart) : null;
        }
        if (s == null) {
            Source source3 = s = resources != null ? resources.findSource(namespaceURI, localPart) : null;
        }
        if (s == null) {
            Source source4 = s = swcContext != null ? swcContext.getSource(namespaceURI, localPart) : null;
        }
        if (s != null) {
            int where = sources.indexOf(s);
            if (where == -1) {
                sources.add(s);
                return sources.size() - 1;
            }
            return where;
        }
        return -1;
    }

    private static int findResourceBundle(List sources, SourceList sourceList, SourcePathBase sourcePath, CompilerSwcContext swcContext, String[] locales, String namespaceURI, String localPart) throws CompilerException {
        VirtualFile o3;
        VirtualFile o2;
        VirtualFile o1;
        Source s1 = sourceList != null ? sourceList.findSource(namespaceURI, localPart) : null;
        VirtualFile virtualFile = o1 = s1 != null ? s1.getBackingFile() : null;
        if (o1 instanceof InMemoryFile) {
            return API.findResourceBundleHelper(sources, s1);
        }
        ResourceFile rf1 = (ResourceFile)o1;
        if (rf1 != null && rf1.complete()) {
            return API.findResourceBundleHelper(sources, s1);
        }
        Source s2 = sourcePath != null ? sourcePath.findSource(namespaceURI, localPart) : null;
        VirtualFile virtualFile2 = o2 = s2 != null ? s2.getBackingFile() : null;
        if (rf1 == null && o2 instanceof InMemoryFile) {
            return API.findResourceBundleHelper(sources, s2);
        }
        if (o2 instanceof InMemoryFile) {
            o2 = null;
        }
        ResourceFile rf2 = (ResourceFile)o2;
        if (rf1 != null) {
            rf1.merge(rf2);
        } else {
            rf1 = rf2;
            s1 = s2;
        }
        if (rf1 != null && rf1.complete()) {
            return API.findResourceBundleHelper(sources, s1);
        }
        Source s3 = swcContext != null ? swcContext.getResourceBundle(locales, namespaceURI, localPart) : null;
        VirtualFile virtualFile3 = o3 = s3 != null ? s3.getBackingFile() : null;
        if (rf1 == null && o3 instanceof InMemoryFile) {
            return API.findResourceBundleHelper(sources, s3);
        }
        if (o3 instanceof InMemoryFile) {
            o3 = null;
        }
        ResourceFile rf3 = (ResourceFile)o3;
        if (rf1 != null) {
            rf1.merge(rf3);
        } else {
            rf1 = rf3;
            s1 = s3;
        }
        return API.findResourceBundleHelper(sources, s1);
    }

    private static int findResourceBundleHelper(List sources, Source s) {
        if (s != null) {
            int where = sources.indexOf(s);
            if (where == -1) {
                sources.add(s);
                return sources.size() - 1;
            }
            return where;
        }
        return -1;
    }

    private static boolean hasPackage(SourcePath sourcePath, CompilerSwcContext swcContext, String packageName) {
        boolean hasPackage;
        boolean bl = hasPackage = sourcePath != null && sourcePath.hasPackage(packageName);
        if (!hasPackage && swcContext != null) {
            hasPackage = swcContext.hasPackage(packageName);
        }
        return hasPackage;
    }

    private static boolean hasDefinition(SourcePath sourcePath, CompilerSwcContext swcContext, QName defName) {
        boolean hasDefinition;
        boolean bl = hasDefinition = sourcePath != null && sourcePath.hasDefinition(defName);
        if (!hasDefinition && swcContext != null) {
            hasDefinition = swcContext.hasDefinition(defName);
        }
        return hasDefinition;
    }

    private static boolean sortInheritance(List sources, List units, final DependencyGraph graph) {
        if (!$assertionsDisabled && sources.size() != units.size()) {
            throw new AssertionError();
        }
        boolean success = true;
        final ArrayList tsort = new ArrayList(units.size());
        Algorithms.topologicalSort(graph, new Visitor(){
            static final /* synthetic */ boolean $assertionsDisabled;

            public void visit(Object v) {
                String name = (String)((Vertex)v).getWeight();
                CompilationUnit u = (CompilationUnit)graph.get(name);
                if (!$assertionsDisabled && u == null) {
                    throw new AssertionError((Object)name);
                }
                tsort.add(u);
            }

            static {
                $assertionsDisabled = !(class$flex2$compiler$API == null ? (class$flex2$compiler$API = API.class$("flex2.compiler.API")) : class$flex2$compiler$API).desiredAssertionStatus();
            }
        });
        if (units.size() > tsort.size()) {
            int size = units.size();
            for (int i = 0; i < size; ++i) {
                CompilationUnit u = (CompilationUnit)units.get(i);
                if (tsort.contains(u)) continue;
                ThreadLocalToolkit.log((CompilerMessage)new CircularInheritance(), u.getSource());
                success = false;
            }
            if (!$assertionsDisabled && success) {
                throw new AssertionError();
            }
        } else {
            sources.clear();
            units.clear();
            int size = tsort.size();
            for (int i = 0; i < size; ++i) {
                CompilationUnit u = (CompilationUnit)tsort.get(i);
                sources.add(u.getSource());
                units.add(u);
            }
        }
        return success;
    }

    private static boolean detectCycles(List sources, DependencyGraph graph) {
        Source s;
        final HashMap<String, Source> tsort = new HashMap<String, Source>(sources.size());
        int size = sources.size();
        for (int i = 0; i < size; ++i) {
            s = (Source)sources.get(i);
            tsort.put(s.getName(), s);
        }
        Algorithms.topologicalSort(graph, new Visitor(){

            public void visit(Object v) {
                String name = (String)((Vertex)v).getWeight();
                tsort.remove(name);
            }
        });
        if (tsort.size() > 0) {
            Iterator i = tsort.keySet().iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                s = (Source)tsort.get(name);
                if (s.hasError()) continue;
                ThreadLocalToolkit.log((CompilerMessage)new CircularInheritance(), name);
            }
            return true;
        }
        return false;
    }

    private static void addGeneratedSources(List sources, DependencyGraph igraph, DependencyGraph dgraph, ResourceContainer resources, SymbolTable symbolTable, Configuration configuration, int start, int end) {
        for (int i = start; i < end; ++i) {
            Map archiveFiles;
            Source source = (Source)sources.get(i);
            CompilationUnit u = source.getCompilationUnit();
            if (u == null) continue;
            Map generatedSources = u.getGeneratedSources();
            if (generatedSources != null) {
                Iterator j = generatedSources.keySet().iterator();
                while (j.hasNext()) {
                    QName qN = (QName)j.next();
                    MultiName mN = new MultiName(qN.getNamespace(), qN.getLocalPart());
                    Source gSource = (Source)generatedSources.get(qN);
                    String gName = gSource.getName();
                    if (!igraph.containsVertex(gName)) {
                        gSource = resources.addResource(gSource);
                        API.addVertexToGraphs(gSource, gSource.getCompilationUnit(), igraph, dgraph);
                        sources.add(gSource);
                        symbolTable.registerMultiName(mN, qN);
                        symbolTable.registerQName(qN, gSource);
                    }
                    u.expressions.add(mN);
                }
                u.clearGeneratedSources();
            }
            if ((archiveFiles = (Map)u.getContext().getAttribute("CSSArchiveFiles")) != null && archiveFiles.size() > 0) {
                configuration.addCSSArchiveFiles(archiveFiles);
                archiveFiles.clear();
            }
            if ((archiveFiles = (Map)u.getContext().getAttribute("L10NArchiveFiles")) == null || archiveFiles.size() <= 0) continue;
            configuration.addL10nArchiveFiles(archiveFiles);
            archiveFiles.clear();
        }
    }

    private static void resolveType(List sources, List units, DependencyGraph igraph, DependencyGraph dgraph, SymbolTable symbolTable, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, CompilerSwcContext swcContext) {
        API.resolveType(sources, units, igraph, dgraph, symbolTable, sourceList, sourcePath, resources, swcContext, 0, units.size());
    }

    private static void resolveType(List sources, List units, DependencyGraph igraph, DependencyGraph dgraph, SymbolTable symbolTable, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, CompilerSwcContext swcContext, int start, int end) {
        String tail;
        Source tailSource;
        QName qName;
        MultiName mName;
        Object unresolved;
        Iterator k;
        String name;
        String head;
        CompilationUnit u;
        Source s;
        int i;
        HashSet<QName> qNames = new HashSet<QName>();
        for (i = start; i < end; ++i) {
            s = (Source)sources.get(i);
            CompilationUnit compilationUnit = u = s != null ? s.getCompilationUnit() : (CompilationUnit)units.get(i);
            if ((u.getWorkflow() & 0x400) != 0 || u.types.size() == 0) continue;
            qNames.clear();
            head = u.getSource().getName();
            name = u.getSource().getNameForReporting();
            k = u.types.iterator();
            while (k.hasNext()) {
                unresolved = k.next();
                if (!(unresolved instanceof MultiName)) continue;
                mName = (MultiName)unresolved;
                qName = API.resolveMultiName(name, mName, sources, sourceList, sourcePath, resources, swcContext, symbolTable);
                if (qName != null) {
                    qNames.add(qName);
                    u.typeHistory.put(mName, qName);
                    tailSource = symbolTable.findSourceByQName(qName);
                    tail = tailSource.getName();
                    API.addVertexToGraphs(tailSource, tailSource.getCompilationUnit(), igraph, dgraph);
                    API.addEdgeToGraphs(null, dgraph, head, tail);
                }
                k.remove();
            }
            if (qNames.size() <= 0) continue;
            u.types.addAll(qNames);
        }
        for (i = start; i < end; ++i) {
            s = (Source)sources.get(i);
            CompilationUnit compilationUnit = u = s != null ? s.getCompilationUnit() : (CompilationUnit)units.get(i);
            if ((u.getWorkflow() & 0x400) != 0) continue;
            u.setWorkflow(1024);
            if (u.namespaces.size() == 0) continue;
            qNames.clear();
            head = u.getSource().getName();
            name = u.getSource().getNameForReporting();
            k = u.namespaces.iterator();
            while (k.hasNext()) {
                unresolved = k.next();
                if (!(unresolved instanceof MultiName)) continue;
                mName = (MultiName)unresolved;
                qName = API.resolveMultiName(name, mName, sources, sourceList, sourcePath, resources, swcContext, symbolTable);
                if (qName != null) {
                    qNames.add(qName);
                    u.namespaceHistory.put(mName, qName);
                    tailSource = symbolTable.findSourceByQName(qName);
                    tail = tailSource.getName();
                    API.addVertexToGraphs(tailSource, tailSource.getCompilationUnit(), igraph, dgraph);
                    API.addEdgeToGraphs(null, dgraph, head, tail);
                }
                k.remove();
            }
            if (qNames.size() <= 0) continue;
            u.namespaces.addAll(qNames);
        }
    }

    private static void resolveImportStatements(List sources, List units, SourcePath sourcePath, CompilerSwcContext swcContext) {
        API.resolveImportStatements(sources, units, sourcePath, swcContext, 0, units.size());
    }

    private static void resolveImportStatements(List sources, List units, SourcePath sourcePath, CompilerSwcContext swcContext, int start, int end) {
        for (int i = start; i < end; ++i) {
            CompilationUnit u;
            Source s = (Source)sources.get(i);
            CompilationUnit compilationUnit = u = s != null ? s.getCompilationUnit() : (CompilationUnit)units.get(i);
            if ((u.getWorkflow() & 0x4000) != 0) continue;
            u.setWorkflow(16384);
            Iterator k = u.importPackageStatements.iterator();
            while (k.hasNext()) {
                String packageName = (String)k.next();
                if (API.hasPackage(sourcePath, swcContext, packageName)) continue;
                k.remove();
            }
            k = u.importDefinitionStatements.iterator();
            while (k.hasNext()) {
                QName defName = (QName)k.next();
                if (API.hasDefinition(sourcePath, swcContext, defName)) continue;
                k.remove();
            }
        }
    }

    private static void resolveExpression(List sources, List units, DependencyGraph igraph, DependencyGraph dgraph, SymbolTable symbolTable, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, CompilerSwcContext swcContext, Configuration configuration) {
        API.resolveExpression(sources, units, igraph, dgraph, symbolTable, sourceList, sourcePath, resources, swcContext, configuration, 0, units.size());
    }

    private static void resolveExpression(List sources, List units, DependencyGraph igraph, DependencyGraph dgraph, SymbolTable symbolTable, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, CompilerSwcContext swcContext, Configuration configuration, int start, int end) {
        HashSet<QName> qNames = new HashSet<QName>();
        for (int i = start; i < end; ++i) {
            CompilationUnit u;
            Source s = (Source)sources.get(i);
            CompilationUnit compilationUnit = u = s != null ? s.getCompilationUnit() : (CompilationUnit)units.get(i);
            if (u.expressions.size() == 0) continue;
            qNames.clear();
            String head = u.getSource().getName();
            String name = u.getSource().getNameForReporting();
            Iterator k = u.expressions.iterator();
            while (k.hasNext()) {
                Object unresolved = k.next();
                if (!(unresolved instanceof MultiName)) continue;
                MultiName mName = (MultiName)unresolved;
                QName qName = API.resolveMultiName(name, mName, sources, sourceList, sourcePath, resources, swcContext, symbolTable);
                if (qName != null) {
                    qNames.add(qName);
                    u.expressionHistory.put(mName, qName);
                    Source tailSource = symbolTable.findSourceByQName(qName);
                    String tail = tailSource.getName();
                    API.addVertexToGraphs(tailSource, tailSource.getCompilationUnit(), igraph, dgraph);
                    API.addEdgeToGraphs(null, dgraph, head, tail);
                } else if (configuration.getCompilerConfiguration().showDependencyWarnings()) {
                    ThreadLocalToolkit.log((CompilerMessage)new UnableToResolveDependency(mName.getLocalPart()), u.getSource());
                }
                k.remove();
            }
            if (qNames.size() <= 0) continue;
            u.expressions.addAll(qNames);
        }
    }

    private static void addEdgeToGraphs(DependencyGraph igraph, DependencyGraph dgraph, String head, String tail) {
        if (igraph != null && !head.equals(tail) && !igraph.dependencyExists(head, tail)) {
            igraph.addDependency(head, tail);
        }
        if (dgraph != null && !head.equals(tail) && !dgraph.dependencyExists(head, tail)) {
            dgraph.addDependency(head, tail);
        }
    }

    private static void adjustQNames(List units, DependencyGraph igraph, SymbolTable symbolTable) {
        int size = units.size();
        for (int i = 0; i < size; ++i) {
            QName qName;
            Object obj;
            CompilationUnit u = (CompilationUnit)units.get(i);
            if (u == null || !u.isDone() || (u.getWorkflow() & 0x8000) != 0) continue;
            Iterator j = u.inheritance.iterator();
            while (j.hasNext()) {
                obj = j.next();
                if (!(obj instanceof QName)) continue;
                qName = (QName)obj;
                API.adjustQName(qName, igraph, symbolTable);
            }
            j = u.namespaces.iterator();
            while (j.hasNext()) {
                obj = j.next();
                if (!(obj instanceof QName)) continue;
                qName = (QName)obj;
                API.adjustQName(qName, igraph, symbolTable);
            }
            j = u.types.iterator();
            while (j.hasNext()) {
                obj = j.next();
                if (!(obj instanceof QName)) continue;
                qName = (QName)obj;
                API.adjustQName(qName, igraph, symbolTable);
            }
            j = u.expressions.iterator();
            while (j.hasNext()) {
                obj = j.next();
                if (!(obj instanceof QName)) continue;
                qName = (QName)obj;
                API.adjustQName(qName, igraph, symbolTable);
            }
            u.setWorkflow(32768);
        }
    }

    private static void adjustQName(QName qName, DependencyGraph igraph, SymbolTable symbolTable) {
        Source s = symbolTable.findSourceByQName(qName);
        CompilationUnit u = (CompilationUnit)igraph.get(s == null ? null : s.getName());
        if (u != null && (u.getSource().isSourcePathOwner() || u.getSource().isSourceListOwner()) && u.topLevelDefinitions.size() == 1) {
            QName def = u.topLevelDefinitions.last();
            if (qName.getLocalPart().equals(def.getLocalPart()) && !qName.getNamespace().equals(def.getNamespace())) {
                qName.setNamespace(def.getNamespace());
            }
        }
    }

    public static QName resolveMultiName(MultiName multiName, List sources, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, CompilerSwcContext swcContext, SymbolTable symbolTable) {
        return API.resolveMultiName(null, multiName, sources, sourceList, sourcePath, resources, swcContext, symbolTable);
    }

    private static QName resolveMultiName(String nameForReporting, MultiName multiName, List sources, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, CompilerSwcContext swcContext, SymbolTable symbolTable) {
        QName qName = symbolTable.isMultiNameResolved(multiName);
        QName qName2 = null;
        Source source = null;
        Source source2 = null;
        boolean hasAmbiguity = false;
        if (qName != null) {
            return qName;
        }
        String[] namespaceURI = multiName.getNamespace();
        String localPart = multiName.getLocalPart();
        int length = namespaceURI.length;
        for (int j = 0; j < length; ++j) {
            Source s = symbolTable.findSourceByQName(namespaceURI[j], localPart);
            int where = -1;
            if (s == null) {
                try {
                    where = API.findDefinition(sources, sourceList, sourcePath, resources, swcContext, namespaceURI[j], localPart);
                }
                catch (CompilerException ex) {
                    ThreadLocalToolkit.logError(ex.getMessage());
                }
                if (where != -1) {
                    s = (Source)sources.get(where);
                }
            }
            if (s == null) continue;
            if (qName == null) {
                qName = new QName(namespaceURI[j], localPart);
                source = s;
                continue;
            }
            if (qName.equals(namespaceURI[j], localPart)) continue;
            hasAmbiguity = true;
            qName2 = new QName(namespaceURI[j], localPart);
            source2 = s;
            break;
        }
        if (hasAmbiguity) {
            AmbiguousMultiname msg = new AmbiguousMultiname(qName, source.getName(), qName2, source2.getName());
            if (nameForReporting != null) {
                ThreadLocalToolkit.log((CompilerMessage)msg, nameForReporting);
            } else {
                ThreadLocalToolkit.log(msg);
            }
            return null;
        }
        if (source != null) {
            symbolTable.registerMultiName(multiName, qName);
            symbolTable.registerQName(qName, source);
        }
        return qName;
    }

    public static QName[] resolveResourceBundleName(String rbName, List sources, SourceList sourceList, SourcePathBase sourcePath, ResourceContainer resources, CompilerSwcContext swcContext, SymbolTable symbolTable, String[] locales) {
        QName[] qNames = symbolTable.isResourceBundleResolved(rbName);
        if (qNames != null) {
            return qNames;
        }
        Source source = symbolTable.findSourceByResourceBundleName(rbName);
        if (source == null) {
            int where = -1;
            QName bundleName = new QName(rbName);
            String namespaceURI = bundleName.getNamespace();
            String localPart = bundleName.getLocalPart();
            try {
                where = API.findResourceBundle(sources, sourceList, sourcePath, swcContext, locales, namespaceURI, localPart);
            }
            catch (CompilerException ex) {
                ThreadLocalToolkit.logError(ex.getMessage());
            }
            if (where != -1) {
                source = (Source)sources.get(where);
                qNames = new QName[locales == null ? 0 : locales.length];
                int length = qNames.length;
                for (int i = 0; i < length; ++i) {
                    qNames[i] = new QName(namespaceURI, locales[i] + "$" + localPart + I18nUtils.CLASS_SUFFIX);
                }
            }
        }
        symbolTable.register(rbName, qNames, source);
        return qNames;
    }

    private static boolean generate(List sources, List units, flex2.compiler.Compiler[] compilers, SymbolTable symbolTable) {
        return API.generate(sources, units, compilers, symbolTable, 0, units.size());
    }

    private static boolean generate(List sources, List units, flex2.compiler.Compiler[] compilers, SymbolTable symbolTable, int start, int end) {
        boolean result = true;
        for (int i = start; i < end; ++i) {
            CompilationUnit u;
            Source s = (Source)sources.get(i);
            CompilationUnit compilationUnit = u = s != null ? s.getCompilationUnit() : (CompilationUnit)units.get(i);
            if ((u.getWorkflow() & 0x2000) != 0) continue;
            u.setWorkflow(8192);
            if (!u.isBytecodeAvailable() && !API.generate(u, compilers, symbolTable)) {
                result = false;
                u.getSource().disconnectLogger();
            }
            API.calculateProgress(sources, symbolTable);
            if (API.tooManyErrors()) {
                ThreadLocalToolkit.log(new TooManyErrors());
                break;
            }
            if (!API.forcedToStop()) continue;
            ThreadLocalToolkit.log(new ForcedToStop());
            break;
        }
        return result;
    }

    private static boolean generate(CompilationUnit u, flex2.compiler.Compiler[] compilers, SymbolTable symbolTable) {
        Source s = u.getSource();
        if (!s.isCompiled()) {
            flex2.compiler.Compiler c = API.getCompiler(s, compilers);
            if (c != null) {
                Logger original = ThreadLocalToolkit.getLogger();
                LocalLogger local = s.getLogger();
                ThreadLocalToolkit.setLogger(local);
                c.generate(u, symbolTable);
                if (u.bytes.size() > 0) {
                    u.setState(2);
                }
                ThreadLocalToolkit.setLogger(original);
                if (local.errorCount() > 0) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private static boolean postprocess(List sources, List units, flex2.compiler.Compiler[] compilers, SymbolTable symbolTable) {
        return API.postprocess(sources, units, compilers, symbolTable, 0, units.size());
    }

    private static boolean postprocess(List sources, List units, flex2.compiler.Compiler[] compilers, SymbolTable symbolTable, int start, int end) {
        boolean result = true;
        for (int i = start; i < end; ++i) {
            CompilationUnit u;
            Source s = (Source)sources.get(i);
            CompilationUnit compilationUnit = u = s != null ? s.getCompilationUnit() : (CompilationUnit)units.get(i);
            if (!API.postprocess(u, compilers, symbolTable)) {
                result = false;
                u.getSource().disconnectLogger();
            }
            if (API.tooManyErrors()) {
                ThreadLocalToolkit.log(new TooManyErrors());
                break;
            }
            if (!API.forcedToStop()) continue;
            ThreadLocalToolkit.log(new ForcedToStop());
            break;
        }
        return result;
    }

    private static boolean postprocess(CompilationUnit u, flex2.compiler.Compiler[] compilers, SymbolTable symbolTable) {
        Source s = u.getSource();
        if (!s.isCompiled()) {
            flex2.compiler.Compiler c = API.getCompiler(s, compilers);
            if (c != null) {
                Logger original = ThreadLocalToolkit.getLogger();
                LocalLogger local = s.getLogger();
                ThreadLocalToolkit.setLogger(local);
                c.postprocess(u, symbolTable);
                ThreadLocalToolkit.setLogger(original);
                if (local.errorCount() > 0) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private static void getIncludeClasses(List sources, DependencyGraph igraph, DependencyGraph dgraph, SymbolTable symbolTable, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, CompilerSwcContext swcContext, Configuration configuration) {
        HashSet includes = new HashSet();
        includes.addAll(configuration.getIncludes());
        Iterator it = configuration.getFrameList().iterator();
        while (it.hasNext()) {
            FramesConfiguration.FrameInfo f = (FramesConfiguration.FrameInfo)it.next();
            includes.addAll(f.frameClasses);
        }
        it = includes.iterator();
        while (it.hasNext()) {
            String className = (String)it.next();
            MultiName mName = new MultiName(className);
            QName qName = API.resolveMultiName("configuration", mName, sources, sourceList, sourcePath, resources, swcContext, symbolTable);
            if (qName != null) {
                Source tailSource = symbolTable.findSourceByQName(qName);
                API.addVertexToGraphs(tailSource, tailSource.getCompilationUnit(), igraph, dgraph);
                continue;
            }
            ThreadLocalToolkit.log(new UnableToResolveClass("include", className));
        }
    }

    private static void getIncludeResources(List sources, DependencyGraph igraph, DependencyGraph dgraph, ResourceBundlePath bundlePath, SymbolTable symbolTable, CompilerSwcContext swcContext, Configuration configuration) {
        Map resourceIncludes = swcContext.getResourceIncludes();
        String[] locales = configuration.getCompilerConfiguration().getLocales();
        Iterator it = resourceIncludes.keySet().iterator();
        while (it.hasNext()) {
            String rbName = NameFormatter.toColon((String)it.next());
            QName[] qNames = API.resolveResourceBundleName(rbName, sources, null, bundlePath, null, swcContext, symbolTable, locales);
            if (qNames == null) continue;
            Source source = symbolTable.findSourceByResourceBundleName(rbName);
            API.addVertexToGraphs(source, source.getCompilationUnit(), igraph, dgraph);
            for (int i = 0; i < qNames.length; ++i) {
                configuration.getIncludes().add(qNames[i].toString());
            }
        }
    }

    private static void getExtraSources(List sources, DependencyGraph igraph, DependencyGraph dgraph, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, ResourceBundlePath bundlePath, SymbolTable symbolTable, CompilerSwcContext swcContext, Configuration configuration, Map licenseMap) {
        API.getExtraSources(sources, igraph, dgraph, sourceList, sourcePath, resources, bundlePath, symbolTable, swcContext, 0, sources.size(), configuration, licenseMap);
    }

    private static void getExtraSources(List sources, DependencyGraph igraph, DependencyGraph dgraph, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, ResourceBundlePath bundlePath, SymbolTable symbolTable, CompilerSwcContext swcContext, int start, int end, Configuration configuration, Map licenseMap) {
        for (int i = start; i < end; ++i) {
            CompilationUnit u;
            Source s = (Source)sources.get(i);
            CompilationUnit compilationUnit = u = s != null ? s.getCompilationUnit() : null;
            if (u == null) continue;
            API.getExtraSources(u, sources, igraph, dgraph, sourceList, sourcePath, resources, bundlePath, symbolTable, swcContext, configuration, licenseMap);
        }
    }

    private static void getExtraSources(CompilationUnit u, List sources, DependencyGraph igraph, DependencyGraph dgraph, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, ResourceBundlePath bundlePath, SymbolTable symbolTable, CompilerSwcContext swcContext, Configuration configuration, Map licenseMap) {
        Iterator it;
        boolean processResourceBundles;
        if ((u.getWorkflow() & 0x10000) != 0) {
            return;
        }
        if (u.loaderClass != null) {
            String className = u.loaderClass;
            MultiName mName = new MultiName(className);
            QName qName = API.resolveMultiName(u.getSource().getNameForReporting(), mName, sources, sourceList, sourcePath, resources, swcContext, symbolTable);
            if (qName != null) {
                Source tailSource = symbolTable.findSourceByQName(qName);
                API.addVertexToGraphs(tailSource, tailSource.getCompilationUnit(), igraph, dgraph);
            } else {
                ThreadLocalToolkit.log(new UnableToResolveClass("factoryClass", className));
            }
        }
        configuration.getResourceBundles().addAll(u.resourceBundleHistory);
        boolean bl = processResourceBundles = configuration.getCompilerConfiguration().useResourceBundleMetadata() && u.resourceBundleHistory.size() > 0;
        if (processResourceBundles) {
            String[] locales = configuration.getCompilerConfiguration().getLocales();
            Iterator it2 = u.resourceBundleHistory.iterator();
            while (it2.hasNext()) {
                String rbName = NameFormatter.toColon((String)it2.next());
                Source source = null;
                QName[] qNames = API.resolveResourceBundleName(rbName, sources, null, bundlePath, null, swcContext, symbolTable, locales);
                if (qNames != null) {
                    source = symbolTable.findSourceByResourceBundleName(rbName);
                    API.addVertexToGraphs(source, source.getCompilationUnit(), igraph, dgraph);
                    continue;
                }
                MultiName mName = new MultiName(rbName);
                QName qName = API.resolveMultiName(u.getSource().getNameForReporting(), mName, sources, null, sourcePath, null, null, symbolTable);
                if (qName != null) {
                    source = symbolTable.findSourceByQName(qName);
                    API.addVertexToGraphs(source, source.getCompilationUnit(), igraph, dgraph);
                    symbolTable.register(rbName, qNames, source);
                    continue;
                }
                mName = new MultiName(rbName + I18nUtils.CLASS_SUFFIX);
                qName = API.resolveMultiName(u.getSource().getNameForReporting(), mName, sources, null, null, null, swcContext, symbolTable);
                if (qName != null) {
                    source = symbolTable.findSourceByQName(qName);
                    API.addVertexToGraphs(source, source.getCompilationUnit(), igraph, dgraph);
                    symbolTable.register(rbName, qNames, source);
                    continue;
                }
                if (locales.length == 1) {
                    ThreadLocalToolkit.log(new UnableToResolveResourceBundleForLocale(rbName, locales[0]));
                    continue;
                }
                if (locales.length <= 1) continue;
                ThreadLocalToolkit.log(new UnableToResolveResourceBundle(rbName));
            }
        }
        if (u.licensedClassReqs != null && u.licensedClassReqs.size() > 0) {
            it = u.licensedClassReqs.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                String id = (String)e.getKey();
                String handler = (String)e.getValue();
                if (!API.hasValidLicense(licenseMap, id)) {
                    MultiName mName = new MultiName(handler);
                    QName qName = API.resolveMultiName(u.getSource().getNameForReporting(), mName, sources, sourceList, sourcePath, resources, swcContext, symbolTable);
                    configuration.getIncludes().add(handler);
                    configuration.getExterns().remove(handler);
                    if (qName != null) {
                        Source tailSource = symbolTable.findSourceByQName(qName);
                        API.addVertexToGraphs(tailSource, tailSource.getCompilationUnit(), igraph, dgraph);
                        continue;
                    }
                    ThreadLocalToolkit.log(new UnableToResolveClass("RequiresLicense handler", handler));
                    continue;
                }
                configuration.getIncludes().remove(handler);
                configuration.getExterns().add(handler);
            }
        }
        if (u.extraClasses != null && u.extraClasses.size() > 0) {
            it = u.extraClasses.iterator();
            while (it.hasNext()) {
                String className = (String)((Object)it.next());
                MultiName mName = new MultiName(className);
                QName qName = API.resolveMultiName(u.getSource().getNameForReporting(), mName, sources, sourceList, sourcePath, resources, swcContext, symbolTable);
                if (qName != null) {
                    Source tailSource = symbolTable.findSourceByQName(qName);
                    API.addVertexToGraphs(tailSource, tailSource.getCompilationUnit(), igraph, dgraph);
                    continue;
                }
                ThreadLocalToolkit.log(new UnableToResolveNeededClass(className));
            }
        }
        u.setWorkflow(65536);
    }

    private static void checkResourceBundles(List sources, SymbolTable symbolTable) throws CompilerException {
        Iterator iterator = sources.iterator();
        while (iterator.hasNext()) {
            Source s = (Source)iterator.next();
            CompilationUnit u = s != null ? s.getCompilationUnit() : null;
            if (u == null || u.resourceBundleHistory.size() <= 0) continue;
            Iterator it = u.resourceBundleHistory.iterator();
            while (it.hasNext()) {
                int size;
                String rbName = (String)it.next();
                Source rbSource = symbolTable.findSourceByResourceBundleName(rbName);
                if (rbSource == null) continue;
                CompilationUnit rbUnit = rbSource.getCompilationUnit();
                int n = size = rbUnit == null ? 0 : rbUnit.topLevelDefinitions.size();
                for (int j = 0; j < size; ++j) {
                    u.resourceBundles.add(rbUnit.topLevelDefinitions.get(j).toString());
                }
            }
        }
        if (ThreadLocalToolkit.errorCount() > 0) {
            throw new CompilerException();
        }
    }

    private static boolean hasValidLicense(Map licenseMap, String id) {
        boolean result = false;
        if (id.equals("mx.fbpro") && licenseMap != null) {
            try {
                Class<?> licenseClass = Class.forName("flex.license.License");
                Constructor<?> ctor = licenseClass.getConstructor(Map.class);
                Object instance = ctor.newInstance(licenseMap);
                Method method = licenseClass.getMethod("isFlexBuilderProValid", null);
                result = (Boolean)method.invoke(instance, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private static void markDone(List sources, List units) {
        API.markDone(sources, units, 0, units.size());
    }

    private static void markDone(List sources, List units, int start, int end) {
        for (int i = start; i < end; ++i) {
            CompilationUnit u;
            Source s = (Source)sources.get(i);
            CompilationUnit compilationUnit = u = s != null ? s.getCompilationUnit() : (CompilationUnit)units.get(i);
            if (!u.getSource().isCompiled()) continue;
            u.setState(4);
        }
    }

    private static flex2.compiler.Compiler getCompiler(Source source, flex2.compiler.Compiler[] compilers) {
        int length;
        int n = length = source == null || compilers == null ? 0 : compilers.length;
        for (int i = 0; i < length; ++i) {
            if (!compilers[i].isSupported(source.getMimeType())) continue;
            return compilers[i];
        }
        return null;
    }

    public static List getVirtualFileList(List files) throws ConfigurationException {
        return new ArrayList(API.fileSetFromPaths(files, false, null, null));
    }

    public static List getVirtualFileList(Collection paths, Set mimeTypes) throws ConfigurationException {
        return new ArrayList(API.fileSetFromPaths(paths, true, mimeTypes, null));
    }

    public static List[] getVirtualFileList(Collection paths, Collection stylesheets, Set mimeTypes, List directories) throws ConfigurationException {
        int len;
        List[] array = new List[]{new ArrayList(), new ArrayList()};
        ArrayList list = new ArrayList(API.fileSetFromPaths(paths, true, mimeTypes, null));
        int n = len = list == null ? 0 : list.size();
        for (int i = 0; i < len; ++i) {
            VirtualFile f = (VirtualFile)list.get(i);
            array[SourceList.calculatePathRoot(f, directories) == null ? 0 : 1].add(f);
        }
        Iterator j = stylesheets.iterator();
        while (j.hasNext()) {
            VirtualFile f = (VirtualFile)j.next();
            array[SourceList.calculatePathRoot(f, directories) == null ? 0 : 1].add(f);
        }
        return array;
    }

    public static List[] getVirtualFileList(Set fileSet, List directories) {
        List[] array = new List[]{new ArrayList(), new ArrayList()};
        Iterator i = fileSet.iterator();
        while (i.hasNext()) {
            VirtualFile f = (VirtualFile)i.next();
            array[SourceList.calculatePathRoot(f, directories) == null ? 0 : 1].add(f);
        }
        return array;
    }

    private static Set fileSetFromPaths(Collection paths, boolean recurse, Set mimeTypes, Set fileSet) throws ConfigurationException {
        boolean topLevel = fileSet == null;
        if (topLevel) {
            fileSet = new HashSet<VirtualFile>(paths.size());
        }
        Iterator iter = paths.iterator();
        while (iter.hasNext()) {
            VirtualFile file;
            Object next = iter.next();
            if (next instanceof VirtualFile) {
                file = (VirtualFile)next;
            } else {
                String path = next instanceof File ? ((File)next).getAbsolutePath() : (String)next;
                file = API.getVirtualFile(path);
            }
            if (file == null) continue;
            if (recurse && file.isDirectory()) {
                File dir = FileUtil.openFile(file.getName());
                if (dir == null) {
                    throw new ConfigurationException.IOError(file.getName());
                }
                API.fileSetFromPaths(Arrays.asList(dir.listFiles()), true, mimeTypes, fileSet);
                continue;
            }
            if (!topLevel && mimeTypes != null && !mimeTypes.contains(file.getMimeType())) continue;
            fileSet.add(file);
        }
        return fileSet;
    }

    public static VirtualFile getVirtualFile(String path) throws ConfigurationException {
        return API.getVirtualFile(path, true);
    }

    public static VirtualFile getVirtualFile(String path, boolean reportError) throws ConfigurationException {
        VirtualFile result;
        File file = FileUtil.openFile(path);
        if (file != null && FileUtils.exists((File)file)) {
            result = new LocalFile(FileUtil.getCanonicalFile(file));
        } else {
            PathResolver resolver = ThreadLocalToolkit.getPathResolver();
            result = resolver.resolve(path);
            if (result == null && reportError) {
                throw new ConfigurationException.IOError(path);
            }
        }
        return result;
    }

    public static void encode(Movie movie, OutputStream out) throws IOException {
        TagEncoder encoder = new TagEncoder();
        new MovieEncoder((TagHandler)encoder).export(movie);
        encoder.writeTo(out);
        if (ThreadLocalToolkit.getBenchmark() != null) {
            LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
            ThreadLocalToolkit.getBenchmark().benchmark(l10n.getLocalizedTextString((Object)new SWFEncoding()));
        }
    }

    public static void encode(ConsoleApplication app, OutputStream out) throws IOException {
        List abcList = app.getABCs();
        int size = abcList.size();
        for (int i = 0; i < size; ++i) {
            out.write((byte[])abcList.get(i));
        }
        if (ThreadLocalToolkit.getBenchmark() != null) {
            LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
            ThreadLocalToolkit.getBenchmark().benchmark(l10n.getLocalizedTextString((Object)new SWFEncoding()));
        }
    }

    public static void persistCompilationUnits(Configuration configuration, FileSpec fileSpec, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, ResourceBundlePath bundlePath, int checksum, String description, RandomAccessFile f) throws IOException {
        API.persistCompilationUnits(configuration, fileSpec, sourceList, sourcePath, resources, bundlePath, null, null, checksum, checksum, checksum, checksum, null, null, description, f);
    }

    public static void persistCompilationUnits(Configuration configuration, FileSpec fileSpec, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, ResourceBundlePath bundlePath, List sources, List units, int[] checksums, Map swcDefSignatureChecksums, Map swcFileChecksums, Map archiveFiles, String description, RandomAccessFile f) throws IOException {
        API.persistCompilationUnits(configuration, fileSpec, sourceList, sourcePath, resources, bundlePath, sources, units, checksums[0], checksums[1], checksums[2], checksums[3], swcDefSignatureChecksums, swcFileChecksums, archiveFiles, description, f);
    }

    public static void persistCompilationUnits(Configuration configuration, FileSpec fileSpec, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, ResourceBundlePath bundlePath, List sources, List units, int checksum, int cmd_checksum, int linker_checksum, int swc_checksum, Map swcDefSignatureChecksums, Map swcFileChecksums, String description, RandomAccessFile f) throws IOException {
        API.persistCompilationUnits(configuration, fileSpec, sourceList, sourcePath, resources, bundlePath, sources, units, checksum, cmd_checksum, linker_checksum, swc_checksum, swcDefSignatureChecksums, swcFileChecksums, null, description, f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void persistCompilationUnits(Configuration configuration, FileSpec fileSpec, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, ResourceBundlePath bundlePath, List sources, List units, int checksum, int cmd_checksum, int linker_checksum, int swc_checksum, Map swcDefSignatureChecksums, Map swcFileChecksums, Map archiveFiles, String description, RandomAccessFile f) throws IOException {
        PersistenceStore store = new PersistenceStore(configuration, f);
        int count = -1;
        try {
            count = store.write(fileSpec, sourceList, sourcePath, resources, bundlePath, sources, units, checksum, cmd_checksum, linker_checksum, swc_checksum, swcDefSignatureChecksums, swcFileChecksums, description, archiveFiles);
            Object var20_19 = null;
        }
        catch (Throwable throwable) {
            Object var20_20 = null;
            if (count != -1 && ThreadLocalToolkit.getBenchmark() != null) {
                LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
                ThreadLocalToolkit.getBenchmark().benchmark(l10n.getLocalizedTextString((Object)new PersistingCompilationUnits(count)));
            }
            throw throwable;
        }
        if (count != -1 && ThreadLocalToolkit.getBenchmark() != null) {
            LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
            ThreadLocalToolkit.getBenchmark().benchmark(l10n.getLocalizedTextString((Object)new PersistingCompilationUnits(count)));
        }
    }

    public static void loadCompilationUnits(Configuration configuration, FileSpec fileSpec, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, ResourceBundlePath bundlePath, List sources, List units, int[] checksums, Map swcDefSignatureChecksums, Map swcFileChecksums, RandomAccessFile f, String cacheName) throws IOException {
        API.loadCompilationUnits(configuration, fileSpec, sourceList, sourcePath, resources, bundlePath, sources, units, checksums, swcDefSignatureChecksums, swcFileChecksums, null, f, cacheName, null);
    }

    public static void loadCompilationUnits(Configuration configuration, FileSpec fileSpec, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, ResourceBundlePath bundlePath, int checksum, RandomAccessFile f, String cacheName) throws IOException {
        API.loadCompilationUnits(configuration, fileSpec, sourceList, sourcePath, resources, bundlePath, null, null, new int[]{checksum, checksum, checksum, checksum}, null, null, null, f, cacheName, null);
    }

    public static void loadCompilationUnits(Configuration configuration, FileSpec fileSpec, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, ResourceBundlePath bundlePath, List sources, List units, int[] checksums, Map swcDefSignatureChecksums, Map swcFileChecksums, RandomAccessFile f, String cacheName, FontManager fontManager) throws IOException {
        API.loadCompilationUnits(configuration, fileSpec, sourceList, sourcePath, resources, bundlePath, null, null, checksums, null, null, null, f, cacheName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadCompilationUnits(Configuration configuration, FileSpec fileSpec, SourceList sourceList, SourcePath sourcePath, ResourceContainer resources, ResourceBundlePath bundlePath, List sources, List units, int[] checksums, Map swcDefSignatureChecksums, Map swcFileChecksums, Map archiveFiles, RandomAccessFile f, String cacheName, FontManager fontManager) throws IOException {
        LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
        PersistenceStore store = new PersistenceStore(configuration, f, fontManager);
        int count = -1;
        try {
            count = store.read(fileSpec, sourceList, sourcePath, resources, bundlePath, sources, units, checksums, swcDefSignatureChecksums, swcFileChecksums, archiveFiles);
            if (count < 0) {
                throw new IOException(l10n.getLocalizedTextString((Object)new FailedToMatchCacheFile(cacheName)));
            }
            Object var19_18 = null;
        }
        catch (Throwable throwable) {
            Object var19_19 = null;
            if (count >= 0 && ThreadLocalToolkit.getBenchmark() != null) {
                ThreadLocalToolkit.getBenchmark().benchmark(l10n.getLocalizedTextString((Object)new LoadingCompilationUnits(count)));
            }
            throw throwable;
        }
        if (count >= 0 && ThreadLocalToolkit.getBenchmark() != null) {
            ThreadLocalToolkit.getBenchmark().benchmark(l10n.getLocalizedTextString((Object)new LoadingCompilationUnits(count)));
        }
    }

    private static boolean tooManyErrors() {
        return ThreadLocalToolkit.errorCount() > 100;
    }

    public static boolean forcedToStop() {
        CompilerControl cc = ThreadLocalToolkit.getCompilerControl();
        return cc != null && cc.getStatus() == 4;
    }

    private static void calculateProgress(List sources, SymbolTable symbolTable) {
        ++symbolTable.tick;
        int total = sources.size() * 12;
        double p = (double)symbolTable.tick / (double)total;
        int percent = (int)(p * 100.0);
        if (percent > 100) {
            percent = 100;
        }
        if (percent > symbolTable.currentPercentage) {
            symbolTable.currentPercentage = percent;
            ProgressMeter meter = ThreadLocalToolkit.getProgressMeter();
            if (meter != null) {
                meter.percentDone(percent);
            }
        }
    }

    private static String workflowToString(int workflow) {
        String result = (workflow & 0x10000) >= 1 ? "extraSources" : ((workflow & 0x8000) >= 1 ? "adjustQNames" : ((workflow & 0x4000) >= 1 ? "resolveImportStatements" : ((workflow & 0x2000) >= 1 ? "generate" : ((workflow & 0x400) >= 1 ? "resolveType" : ((workflow & 0x80) >= 1 ? "analyze4" : ((workflow & 0x40) >= 1 ? "analyze3" : ((workflow & 0x20) >= 1 ? "analyze2" : ((workflow & 0x10) >= 1 ? "analyze1" : ((workflow & 8) >= 1 ? "parse2" : ((workflow & 4) >= 1 ? "parse1" : ((workflow & 2) >= 1 ? "preprocess" : "before preprocessed")))))))))));
        return result;
    }

    static {
        $assertionsDisabled = !API.class.desiredAssertionStatus();
        multiNames = new MultiName[]{new MultiName("Object"), new MultiName("Class"), new MultiName("Function"), new MultiName("Boolean"), new MultiName("Number"), new MultiName("String"), new MultiName("Array"), new MultiName("int"), new MultiName("uint"), new MultiName("Namespace"), new MultiName("RegExp"), new MultiName("XML"), new MultiName("XMLList")};
    }

    public static class ShowBetaExpiration
    extends CompilerMessage.CompilerInfo {
        public final String date;

        public ShowBetaExpiration(String date) {
            this.date = date;
        }
    }

    public static class NotResourceBundleSubclass
    extends CompilerMessage.CompilerError {
        public final String className;
        public final String sourceName;
        public final String resourceBundle;

        public NotResourceBundleSubclass(String className, String sourceName, String resourceBundle) {
            this.className = className;
            this.sourceName = sourceName;
            this.resourceBundle = resourceBundle;
        }
    }

    public static class UnableToResolveResourceBundleForLocale
    extends CompilerMessage.CompilerError {
        public final String bundleName;
        public final String locale;

        public UnableToResolveResourceBundleForLocale(String bundleName, String locale) {
            this.bundleName = bundleName;
            this.locale = locale;
        }
    }

    public static class UnableToResolveResourceBundle
    extends CompilerMessage.CompilerError {
        public final String bundleName;

        public UnableToResolveResourceBundle(String bundleName) {
            this.bundleName = bundleName;
        }
    }

    public static class UnableToResolveNeededClass
    extends CompilerMessage.CompilerError {
        public final String className;

        public UnableToResolveNeededClass(String className) {
            this.className = className;
        }
    }

    public static class UnableToResolveClass
    extends CompilerMessage.CompilerError {
        public final String type;
        public final String className;

        public UnableToResolveClass(String type, String className) {
            this.type = type;
            this.className = className;
        }
    }

    public static class ForcedToStop
    extends CompilerMessage.CompilerInfo {
    }

    public static class TooManyErrors
    extends CompilerMessage.CompilerInfo {
    }

    public static class ChannelDefinitionNotFound
    extends CompilerMessage.CompilerError {
        public final String clientType;

        public ChannelDefinitionNotFound(String clientType) {
            this.clientType = clientType;
        }
    }

    public static class LoadingCompilationUnits
    extends CompilerMessage.CompilerInfo {
        public final int count;

        public LoadingCompilationUnits(int count) {
            this.count = count;
        }
    }

    public static class FailedToMatchCacheFile
    extends CompilerMessage.CompilerInfo {
        public final String cacheName;

        public FailedToMatchCacheFile(String cacheName) {
            this.cacheName = cacheName;
        }
    }

    public static class PersistingCompilationUnits
    extends CompilerMessage.CompilerInfo {
        public final int count;

        public PersistingCompilationUnits(int count) {
            this.count = count;
        }
    }

    public static class SWFEncoding
    extends CompilerMessage.CompilerInfo {
    }

    public static class AmbiguousMultiname
    extends CompilerMessage.CompilerError {
        public final QName qName1;
        public final QName qName2;
        public final String source1;
        public final String source2;

        public AmbiguousMultiname(QName qName1, String source1, QName qName2, String source2) {
            this.qName1 = qName1;
            this.source1 = source1;
            this.qName2 = qName2;
            this.source2 = source2;
        }
    }

    public static class UnableToResolveDependency
    extends CompilerMessage.CompilerWarning {
        public final String localPart;

        public UnableToResolveDependency(String localPart) {
            this.localPart = localPart;
        }
    }

    public static class CircularInheritance
    extends CompilerMessage.CompilerError {
    }

    public static class DefinitionNameFileNameMismatch
    extends CompilerMessage.CompilerError {
        public final String pathName;
        public final String defName;

        public DefinitionNameFileNameMismatch(String defName, String pathName) {
            this.pathName = pathName;
            this.defName = defName;
        }
    }

    public static class WrongDefinitionName
    extends CompilerMessage.CompilerError {
        public final String pathName;
        public final String defName;

        public WrongDefinitionName(String pathName, String defName) {
            this.pathName = pathName;
            this.defName = defName;
        }
    }

    public static class WrongPackageName
    extends CompilerMessage.CompilerError {
        public final String pathPackage;
        public final String defPackage;

        public WrongPackageName(String pathPackage, String defPackage) {
            this.pathPackage = pathPackage;
            this.defPackage = defPackage;
        }
    }

    public static class MustHaveOneDefinition
    extends CompilerMessage.CompilerError {
    }

    public static class MoreThanOneDefinition
    extends CompilerMessage.CompilerError {
        public final List topLevelDefinitions;

        public MoreThanOneDefinition(List topLevelDefinitions) {
            this.topLevelDefinitions = topLevelDefinitions;
        }
    }

    public static class FilesChangedAffected
    extends CompilerMessage.CompilerInfo {
        public final int updateCount;
        public final int count;

        public FilesChangedAffected(int updateCount, int count) {
            this.updateCount = updateCount;
            this.count = count;
        }
    }

    public static class MultiNameMeaningChanged
    extends CompilerMessage.CompilerInfo {
        public final MultiName multiName;
        public final QName qName;

        public MultiNameMeaningChanged(MultiName multiName, QName qName) {
            this.multiName = multiName;
            this.qName = qName;
        }
    }

    public static class QNameSourceUpdated
    extends CompilerMessage.CompilerInfo {
        public final String sourceName;
        public final QName qname;

        public QNameSourceUpdated(String sourceName, QName qname) {
            this.sourceName = sourceName;
            this.qname = qname;
        }
    }

    public static class SuperclassUpdated
    extends CompilerMessage.CompilerInfo {
        public final String sourceName;
        public final QName qname;

        public SuperclassUpdated(String sourceName, QName qname) {
            this.sourceName = sourceName;
            this.qname = qname;
        }
    }

    public static class DependentFileModified
    extends CompilerMessage.CompilerInfo {
        public final String location;

        public DependentFileModified(String location) {
            this.location = location;
        }
    }

    public static class InvalidImportStatement
    extends CompilerMessage.CompilerInfo {
        public final String defName;

        public InvalidImportStatement(String defName) {
            this.defName = defName;
        }
    }

    public static class DependentFileNoLongerExists
    extends CompilerMessage.CompilerInfo {
        public final String location;

        public DependentFileNoLongerExists(String location) {
            this.location = location;
        }
    }

    public static class NotSourcePathFirstPreference
    extends CompilerMessage.CompilerInfo {
    }

    public static class AssetUpdated
    extends CompilerMessage.CompilerInfo {
    }

    public static class SourceFileUpdated
    extends CompilerMessage.CompilerInfo {
    }

    public static class SourceNoLongerExists
    extends CompilerMessage.CompilerInfo {
    }

    public static class NotFullyCompiled
    extends CompilerMessage.CompilerInfo {
    }

    public static class SourceFileChanged
    extends CompilerMessage.CompilerInfo {
    }

    public static class ForceRecompilation
    extends CompilerMessage.CompilerInfo {
    }

    public static class OutputTime
    extends CompilerMessage.CompilerInfo {
        public final int size;

        public OutputTime(int size) {
            this.size = size;
        }
    }

    public static class InfoCompiling
    extends CompilerMessage.CompilerInfo {
    }

    public static class IncompatibleSWCArchive
    extends CompilerMessage.CompilerError {
        public final String swc;

        public IncompatibleSWCArchive(String swc) {
            this.swc = swc;
        }
    }

    public static class UnableToSetHeadless
    extends CompilerMessage.CompilerWarning {
    }

    public static class BetaExpired
    extends CompilerMessage.CompilerError {
    }
}

