/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools;

import flash.fonts.FSType;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.batik.svggen.font.Font;
import org.apache.batik.svggen.font.table.Os2Table;

public class FontLicenseChecker {
    public static void main(String[] args) throws Exception {
        FontLicenseChecker.listFonts(args);
    }

    public static void listFonts(String[] args) {
        File file = new File(args[0]);
        TreeMap fonts = new TreeMap();
        FontLicenseChecker.getLicenseTypes(file, fonts);
        Iterator iterator = fonts.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Integer integ = (Integer)entry.getKey();
            ArrayList list = (ArrayList)entry.getValue();
            FSType type = FSType.getFSType((int)integ);
            String licenseType = type.description + ", fsType = '" + type.fsType + "'";
            System.out.println("");
            System.out.println("---------");
            System.out.println(licenseType);
            System.out.println("Flex will" + (type.usableByFlex ? "" : " not") + " embed any of the " + list.size() + " fonts listed below.");
            System.out.println("");
            Iterator interator2 = list.iterator();
            while (interator2.hasNext()) {
                String fontStr = (String)interator2.next();
                System.out.println(fontStr);
            }
        }
    }

    public static void getLicenseTypes(File file, Map fonts) {
        if (!file.exists()) {
            throw new RuntimeException("Font or dir not found: " + file);
        }
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            if (children != null) {
                for (int i = 0; i < children.length; ++i) {
                    File child = children[i];
                    if (!child.isDirectory() && !child.toString().toLowerCase().endsWith(".ttf")) continue;
                    FontLicenseChecker.getLicenseTypes(child, fonts);
                }
            }
        } else {
            Font font = null;
            String err = null;
            try {
                font = Font.create((String)file.toString());
            }
            catch (Exception e) {
                err = e.toString();
            }
            if (font == null || font.getOS2Table() == null) {
                System.err.println("Error reading " + file + ": " + err);
            } else {
                Os2Table table = font.getOS2Table();
                Integer integ = new Integer(table.getLicenseType());
                ArrayList<String> list = (ArrayList<String>)fonts.get(integ);
                if (list == null) {
                    list = new ArrayList<String>();
                    fonts.put(integ, list);
                }
                list.add(file.toString());
            }
        }
    }
}

