/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools;

import flash.util.FileUtils;
import flex2.compiler.common.Configuration;
import flex2.compiler.common.ConfigurationException;
import flex2.compiler.common.ConfigurationPathResolver;
import flex2.compiler.config.ConfigurationBuffer;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.config.ConfigurationInfo;
import flex2.compiler.config.ConfigurationValue;
import flex2.compiler.config.FileConfigurator;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.tools.Compiler;
import flex2.tools.ToolsConfiguration;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CompcConfiguration
extends ToolsConfiguration {
    private List sources = new LinkedList();
    private List classes = new LinkedList();
    private List namespaces = new LinkedList();
    private Map files = new HashMap();
    private List resourceBundles = new LinkedList();
    private String output;
    private boolean isDirectory;
    private boolean includeLookupOnly = false;
    private String dumpConfigFile = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static Map getAliases() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("o", "output");
        map.put("ic", "include-classes");
        map.put("in", "include-namespaces");
        map.put("is", "include-sources");
        map.put("if", "include-file");
        map.put("ir", "include-resource-bundles");
        map.putAll(Configuration.getAliases());
        return map;
    }

    public void cfgIncludeClasses(ConfigurationValue cv, List args) throws ConfigurationException {
        this.classes.addAll(args);
    }

    public List getClasses() {
        return this.classes;
    }

    public static ConfigurationInfo getIncludeClassesInfo() {
        return new ConfigurationInfo(-1, new String[]{"class"}){

            public String getDescription() {
                return "a list of classes to include in the SWC archive";
            }

            public boolean allowMultiple() {
                return true;
            }
        };
    }

    public void cfgIncludeSources(ConfigurationValue cv, List args) throws ConfigurationException {
        this.sources.addAll(args);
    }

    public List getIncludeSources() {
        return this.sources;
    }

    public static ConfigurationInfo getIncludeSourcesInfo() {
        return new ConfigurationInfo(-1, new String[]{"path-element"}){

            public String getDescription() {
                return "source files to explicitly include in the SWC";
            }

            public boolean allowMultiple() {
                return true;
            }

            public boolean isPath() {
                return true;
            }
        };
    }

    public String getOutput() {
        return this.output;
    }

    public void cfgOutput(ConfigurationValue val, String output) throws ConfigurationException {
        File d;
        this.output = output != null && (output.startsWith(File.separator) || output.startsWith("/") || FileUtils.isAbsolute((File)new File(output))) ? output : (val.getContext() != null ? FileUtils.addPathComponents((String)val.getContext(), (String)output, (char)File.separatorChar) : output);
        if (this.isDirectory && (d = new File(this.output)).exists()) {
            if (!d.isDirectory()) {
                throw new ConfigurationException.NotDirectory(this.output, val.getVar(), val.getSource(), val.getLine());
            }
            File[] fl = d.listFiles();
            if (fl != null && fl.length > 0) {
                throw new ConfigurationException.DirectoryNotEmpty(this.output, val.getVar(), val.getSource(), val.getLine());
            }
        }
    }

    public static ConfigurationInfo getOutputInfo() {
        return new ConfigurationInfo(1, "filename"){

            public String getDescription() {
                return "the filename of the SWC archive to create";
            }

            public String[] getPrerequisites() {
                return new String[]{"directory"};
            }

            public boolean isRequired() {
                return true;
            }
        };
    }

    public String getDumpConfig() {
        return this.dumpConfigFile;
    }

    public void cfgDumpConfig(ConfigurationValue cv, String filename) throws ConfigurationException {
        this.dumpConfigFile = filename;
    }

    public static ConfigurationInfo getDumpConfigInfo() {
        return new ConfigurationInfo(1, "filename"){

            public boolean isAdvanced() {
                return true;
            }

            public String getDescription() {
                return "write a file containing all currently set configuration values in a format suitable for use as a flex config file";
            }

            public boolean isDisplayed() {
                return false;
            }
        };
    }

    public void cfgDirectory(ConfigurationValue val, boolean directory) {
        this.isDirectory = directory;
    }

    public static ConfigurationInfo getDirectoryInfo() {
        return new ConfigurationInfo(){

            public String getDescription() {
                return "output the SWC to a directory instead of a compressed archive";
            }
        };
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public void cfgRoot(ConfigurationValue val, String rootStr) throws ConfigurationException {
        throw new ConfigurationException.ObsoleteVariable("source-path", val.getVar(), val.getSource(), val.getLine());
    }

    public static ConfigurationInfo getRootInfo() {
        return new ConfigurationInfo(){

            public String getDescription() {
                return "obsolete, use source-path instead";
            }

            public boolean isAdvanced() {
                return true;
            }

            public boolean isHidden() {
                return true;
            }
        };
    }

    public List getNamespaces() {
        return this.namespaces;
    }

    public void cfgIncludeNamespaces(ConfigurationValue val, List includeNamespaces) {
        this.namespaces.addAll(includeNamespaces);
    }

    public static ConfigurationInfo getIncludeNamespacesInfo() {
        return new ConfigurationInfo(-1, new String[]{"uri"}){

            public String getDescription() {
                return "a list of URIs associated with components to include in the SWC";
            }

            public boolean allowMultiple() {
                return true;
            }
        };
    }

    public List getIncludeResourceBundles() {
        return this.resourceBundles;
    }

    public void cfgIncludeResourceBundles(ConfigurationValue val, List includeResourceBundles) {
        this.resourceBundles.addAll(includeResourceBundles);
    }

    public static ConfigurationInfo getIncludeResourceBundlesInfo() {
        return new ConfigurationInfo(-1, new String[]{"bundle"}){

            public String getDescription() {
                return "a list of property files and/or classes that extend ResourceBundle to include in the SWC";
            }

            public boolean allowMultiple() {
                return true;
            }
        };
    }

    public Map getFiles() {
        return this.files;
    }

    public void addFiles(Map f) {
        this.files.putAll(f);
    }

    public void cfgIncludeFile(ConfigurationValue cfgval, String name, String path) throws ConfigurationException {
        if (this.files.containsKey(name)) {
            throw new ConfigurationException.RedundantFile(name, cfgval.getVar(), cfgval.getSource(), cfgval.getLine());
        }
        VirtualFile f = ConfigurationPathResolver.getVirtualFile(path, this.configResolver, cfgval);
        this.files.put(name, f);
    }

    public static ConfigurationInfo getIncludeFileInfo() {
        return new ConfigurationInfo(new String[]{"name", "path"}){

            public String getDescription() {
                return "a file to include in the SWC; specify both a new name for the file to write into the SWC catalog as well as the source path.";
            }

            public boolean isPath() {
                return true;
            }

            public boolean allowMultiple() {
                return true;
            }
        };
    }

    public void validate(ConfigurationBuffer cfgbuf) throws ConfigurationException {
        super.validate(cfgbuf);
        if (this.dumpConfigFile != null) {
            ThreadLocalToolkit.log(new Compiler.DumpConfig(this.dumpConfigFile));
            File f = new File(this.dumpConfigFile);
            String text = FileConfigurator.formatBuffer(cfgbuf, "flex-config", ThreadLocalToolkit.getLocalizationManager(), "flex2.configuration");
            try {
                PrintWriter out = new PrintWriter(new BufferedOutputStream(new FileOutputStream(f)));
                out.write(text);
                out.close();
            }
            catch (Exception e) {
                throw new ConfigurationException.IOError(this.dumpConfigFile);
            }
        }
        if (this.getIncludeSources().isEmpty() && this.getClasses().isEmpty() && this.getNamespaces().isEmpty() && (this.getCompilerConfiguration().getIncludeLibraries() == null || this.getCompilerConfiguration().getIncludeLibraries().length == 0) && this.getFiles().isEmpty() && this.getIncludeResourceBundles().isEmpty()) {
            throw new ConfigurationException.NoSwcInputs(null, null, -1);
        }
        if (this.getCompilerConfiguration().keepGeneratedActionScript()) {
            String output = this.getOutput();
            if (!$assertionsDisabled && output == null) {
                throw new AssertionError();
            }
            String canonical = FileUtils.canonicalPath((String)output);
            if (canonical != null) {
                output = canonical;
            }
            String parent = new File(output).getParent();
            String generated = null;
            generated = parent == null ? new File("generated").getAbsolutePath() : FileUtils.addPathComponents((String)parent, (String)"generated", (char)File.separatorChar);
            this.getCompilerConfiguration().setGeneratedDirectory(generated);
            new File(generated).mkdirs();
        }
    }

    public void cfgLoadConfig(ConfigurationValue cv, String filename) throws ConfigurationException {
    }

    public static ConfigurationInfo getLoadConfigInfo() {
        return new ConfigurationInfo(1, "filename"){

            public String getDescription() {
                return "load a file containing configuration options";
            }

            public boolean allowMultiple() {
                return true;
            }
        };
    }

    public void cfgVersion(ConfigurationValue cv, boolean dummy) {
    }

    public void cfgHelp(ConfigurationValue cv, String[] keywords) {
    }

    public static ConfigurationInfo getHelpInfo() {
        return new ConfigurationInfo(-1, "keyword"){

            public boolean isGreedy() {
                return true;
            }

            public boolean isDisplayed() {
                return false;
            }
        };
    }

    public void cfgIncludeLookupOnly(ConfigurationValue val, boolean includeLookupOnly) {
        this.includeLookupOnly = includeLookupOnly;
    }

    public static ConfigurationInfo getIncludeLookupOnlyInfo() {
        return new ConfigurationInfo(){

            public String getDescription() {
                return "if true, manifest entries with lookupOnly=\"true\" are included in the catalog";
            }

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public boolean getIncludeLookupOnly() {
        return this.includeLookupOnly;
    }

    static {
        $assertionsDisabled = !CompcConfiguration.class.desiredAssertionStatus();
    }
}

