/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools;

import flash.util.FileUtils;
import flex2.compiler.API;
import flex2.compiler.common.ConfigurationException;
import flex2.compiler.common.ConfigurationPathResolver;
import flex2.compiler.config.ConfigurationBuffer;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.config.ConfigurationInfo;
import flex2.compiler.config.ConfigurationValue;
import flex2.compiler.config.FileConfigurator;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.tools.Compiler;
import flex2.tools.ToolsConfiguration;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class CommandLineConfiguration
extends ToolsConfiguration {
    private List fileSpecs = new ArrayList();
    private VirtualFile configFile;
    private String dumpConfigFile = null;
    private boolean warnings = true;
    private String output = null;
    private VirtualFile projector;

    public void cfgFileSpecs(ConfigurationValue cv, List args) throws ConfigurationException {
        this.fileSpecs.addAll(args);
    }

    public List getFileSpecs() {
        return this.fileSpecs;
    }

    public static ConfigurationInfo getFileSpecsInfo() {
        return new ConfigurationInfo(-1, new String[]{"path-element"}){

            public String getDescription() {
                return "a list of source files to compile, the last file specified will be used as the target application";
            }

            public boolean allowMultiple() {
                return true;
            }

            public boolean isHidden() {
                return true;
            }
        };
    }

    public String getTargetFile() {
        return this.fileSpecs.size() > 0 ? (String)this.fileSpecs.get(this.fileSpecs.size() - 1) : null;
    }

    public void validate(ConfigurationBuffer cfgbuf) throws ConfigurationException {
        String targetFile;
        super.validate(cfgbuf);
        if (this.dumpConfigFile != null) {
            ThreadLocalToolkit.log(new Compiler.DumpConfig(this.dumpConfigFile));
            File f = new File(this.dumpConfigFile);
            String text = FileConfigurator.formatBuffer(cfgbuf, "flex-config", ThreadLocalToolkit.getLocalizationManager(), "flex2.configuration");
            try {
                PrintWriter out = new PrintWriter(new BufferedOutputStream(new FileOutputStream(f)));
                out.write(text);
                out.close();
            }
            catch (Exception e) {
                throw new ConfigurationException.IOError(this.dumpConfigFile);
            }
        }
        if ((targetFile = this.getTargetFile()) == null) {
            throw new ConfigurationException.MustSpecifyTarget(null, null, -1);
        }
        VirtualFile virt = this.getVirtualFile(targetFile);
        if (virt == null && this.checkTargetFileInFileSystem()) {
            throw new ConfigurationException.IOError(targetFile);
        }
        if (virt != null && this.getCompilerConfiguration().keepGeneratedActionScript()) {
            String dir = FileUtils.addPathComponents((String)virt.getParent(), (String)"generated", (char)File.separatorChar);
            this.getCompilerConfiguration().setGeneratedDirectory(FileUtils.canonicalPath((File)new File(dir)));
            File gd = new File(this.getCompilerConfiguration().getGeneratedDirectory());
            gd.mkdirs();
        }
    }

    protected VirtualFile getVirtualFile(String targetFile) throws ConfigurationException {
        return API.getVirtualFile(targetFile);
    }

    protected boolean checkTargetFileInFileSystem() {
        return true;
    }

    public void cfgLoadConfig(ConfigurationValue cv, String filename) throws ConfigurationException {
        this.configFile = ConfigurationPathResolver.getVirtualFile(filename, this.configResolver, cv);
    }

    public static ConfigurationInfo getLoadConfigInfo() {
        return new ConfigurationInfo(1, "filename"){

            public String getDescription() {
                return "load a file containing configuration options";
            }

            public boolean allowMultiple() {
                return true;
            }
        };
    }

    public VirtualFile getLoadConfig() {
        return this.configFile;
    }

    public void cfgVersion(ConfigurationValue cv, boolean dummy) {
    }

    public static ConfigurationInfo getVersionInfo() {
        return new ConfigurationInfo(){

            public String getDescription() {
                return "display the build version of the program";
            }
        };
    }

    public void cfgHelp(ConfigurationValue cv, String[] keywords) {
    }

    public static ConfigurationInfo getHelpInfo() {
        return new ConfigurationInfo(-1, "keyword"){

            public boolean isGreedy() {
                return true;
            }

            public boolean isDisplayed() {
                return false;
            }
        };
    }

    public String getDumpConfig() {
        return this.dumpConfigFile;
    }

    public void cfgDumpConfig(ConfigurationValue cv, String filename) throws ConfigurationException {
        this.dumpConfigFile = filename;
    }

    public static ConfigurationInfo getDumpConfigInfo() {
        return new ConfigurationInfo(1, "filename"){

            public boolean isAdvanced() {
                return true;
            }

            public String getDescription() {
                return "write a file containing all currently set configuration values in a format suitable for use as a flex config file";
            }

            public boolean isDisplayed() {
                return false;
            }
        };
    }

    public void cfgWarnings(ConfigurationValue cv, boolean b) {
        this.warnings = b;
    }

    public boolean getWarnings() {
        return this.warnings;
    }

    public static ConfigurationInfo getWarningsInfo() {
        return new ConfigurationInfo(){

            public String getDescription() {
                return "toggle the display of warnings";
            }
        };
    }

    public String getOutput() {
        return this.output;
    }

    public void cfgOutput(ConfigurationValue val, String output) throws ConfigurationException {
        this.output = output != null && (output.startsWith(File.separator) || output.startsWith("/") || FileUtils.isAbsolute((File)new File(output))) ? output : (val.getContext() != null ? FileUtils.addPathComponents((String)val.getContext(), (String)output, (char)File.separatorChar) : output);
    }

    public static ConfigurationInfo getOutputInfo() {
        return new ConfigurationInfo(1, "filename"){

            public String getDescription() {
                return "the filename of the SWF movie to create";
            }

            public boolean isRequired() {
                return false;
            }
        };
    }

    private VirtualFile getVirtualFile(String file, ConfigurationValue cfgval) {
        try {
            return ConfigurationPathResolver.getVirtualFile(file, this.configResolver, cfgval);
        }
        catch (ConfigurationException ex) {
            return null;
        }
    }

    public VirtualFile getProjector() {
        return this.projector;
    }

    public void cfgProjector(ConfigurationValue cfgval, String path) {
        this.projector = this.getVirtualFile(path, cfgval);
    }

    public static ConfigurationInfo getProjectorInfo() {
        return new ConfigurationInfo(){

            public boolean isHidden() {
                return true;
            }
        };
    }
}

