/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.util;

import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.ThreadLocalToolkit;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class Benchmark {
    private long start = 0L;
    private long begin = 0L;
    private HashMap times;

    public void start() {
        this.begin = this.start = System.currentTimeMillis();
    }

    public void benchmark(String message) {
        long currentTime = System.currentTimeMillis();
        if (this.start != 0L) {
            ThreadLocalToolkit.log(new BenchmarkText(message, currentTime - this.start));
        }
        this.start = currentTime;
        if (this.begin == 0L) {
            this.begin = currentTime;
        }
    }

    public void totalTime() {
        ThreadLocalToolkit.log(new TotalTime(System.currentTimeMillis() - this.begin));
    }

    public final long stopTime(String id) {
        long currentTime = System.currentTimeMillis();
        Long time = (Long)this.times.get(id);
        if (time == null) {
            throw new IllegalStateException("Call startTime before calling stopTime");
        }
        long previousTime = time;
        long duration = currentTime - previousTime;
        ThreadLocalToolkit.log(new BenchmarkID(id, duration));
        this.startTime(id);
        return duration;
    }

    public final void startTime(String id) {
        if (this.times == null) {
            this.times = new HashMap();
        }
        this.times.put(id, new Long(System.currentTimeMillis()));
    }

    public final long peakMemoryUsage() {
        return this.peakMemoryUsage(true);
    }

    public final long peakMemoryUsage(boolean display) {
        MemoryUsage mem = this.getMemoryUsageInBytes();
        long mbHeapUsed = mem.heap / 0x100000L;
        long mbNonHeapUsed = mem.nonHeap / 0x100000L;
        if (display && mem.heap != 0L && mem.nonHeap != 0L) {
            ThreadLocalToolkit.log(new MemoryUsage(mbHeapUsed, mbNonHeapUsed));
        }
        return mbHeapUsed + mbNonHeapUsed;
    }

    public final long peakMemoryUsageInBytes() {
        return this.peakMemoryUsage(true);
    }

    public final long peakMemoryUsageInBytes(boolean display) {
        MemoryUsage mem = this.getMemoryUsageInBytes();
        if (display && mem.heap != 0L && mem.nonHeap != 0L) {
            ThreadLocalToolkit.log(mem);
        }
        return mem.total;
    }

    private MemoryUsage getMemoryUsageInBytes() {
        long heapUsed = 0L;
        long nonHeapUsed = 0L;
        try {
            Class<?> mfCls = Class.forName("java.lang.management.ManagementFactory");
            Class<?> mpCls = Class.forName("java.lang.management.MemoryPoolMXBean");
            Class<?> memCls = Class.forName("java.lang.management.MemoryUsage");
            Class<?> typeCls = Class.forName("java.lang.management.MemoryType");
            Class[] emptyCls = new Class[]{};
            Object[] emptyObj = new Object[]{};
            Method getMemPoolMeth = mfCls.getMethod("getMemoryPoolMXBeans", emptyCls);
            Method getPeakUsageMeth = mpCls.getMethod("getPeakUsage", emptyCls);
            Method getTypeMeth = mpCls.getMethod("getType", emptyCls);
            Field heapField = typeCls.getField("HEAP");
            Method getUsedMeth = memCls.getMethod("getUsed", emptyCls);
            List list = (List)getMemPoolMeth.invoke(null, emptyObj);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object memPoolObj = iterator.next();
                Object memUsageObj = getPeakUsageMeth.invoke(memPoolObj, emptyObj);
                Object memTypeObj = getTypeMeth.invoke(memPoolObj, emptyObj);
                Long used = (Long)getUsedMeth.invoke(memUsageObj, emptyObj);
                if (heapField.get(typeCls) == memTypeObj) {
                    heapUsed += used.longValue();
                    continue;
                }
                nonHeapUsed += used.longValue();
            }
            this.resetPeakMemoryUsage();
        }
        catch (Exception e) {
            // empty catch block
        }
        return new MemoryUsage(heapUsed, nonHeapUsed);
    }

    private void resetPeakMemoryUsage() {
        try {
            Class<?> mfCls = Class.forName("java.lang.management.ManagementFactory");
            Class<?> mpCls = Class.forName("java.lang.management.MemoryPoolMXBean");
            Class[] emptyCls = new Class[]{};
            Object[] emptyObj = new Object[]{};
            Method getMemPoolMeth = mfCls.getMethod("getMemoryPoolMXBeans", emptyCls);
            Method resetPeakUsageMeth = mpCls.getMethod("resetPeakUsage", emptyCls);
            List list = (List)getMemPoolMeth.invoke(null, emptyObj);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object memPoolObj = iterator.next();
                resetPeakUsageMeth.invoke(memPoolObj, emptyObj);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void captureMemorySnapshot() {
    }

    public static class MemoryUsage
    extends CompilerMessage.CompilerInfo {
        public long heap;
        public long nonHeap;
        public long total;

        public MemoryUsage(long heap, long nonHeap) {
            this.heap = heap;
            this.nonHeap = nonHeap;
            this.total = heap + nonHeap;
        }

        public void add(MemoryUsage mem) {
            this.heap += mem.heap;
            this.nonHeap += mem.nonHeap;
            this.total += mem.total;
        }

        public void subtract(MemoryUsage mem) {
            this.heap -= mem.heap;
            this.nonHeap -= mem.nonHeap;
            this.total -= mem.total;
        }
    }

    public static class TotalTime
    extends CompilerMessage.CompilerInfo {
        public final long time;

        public TotalTime(long time) {
            this.time = time;
        }
    }

    public static class BenchmarkID
    extends CompilerMessage.CompilerInfo {
        public final String id;
        public final long duration;

        public BenchmarkID(String id, long duration) {
            this.id = id;
            this.duration = duration;
        }
    }

    public static class BenchmarkText
    extends CompilerMessage.CompilerInfo {
        public final String message;
        public final long time;

        public BenchmarkText(String message, long time) {
            this.message = message;
            this.time = time;
        }
    }
}

