/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.swc.catalog;

import flex2.compiler.swc.Component;
import flex2.compiler.swc.Features;
import flex2.compiler.swc.Swc;
import flex2.compiler.swc.SwcArchive;
import flex2.compiler.swc.SwcDependencySet;
import flex2.compiler.swc.SwcException;
import flex2.compiler.swc.SwcFile;
import flex2.compiler.swc.SwcLibrary;
import flex2.compiler.swc.Versions;
import flex2.compiler.swc.catalog.CatalogHandler;
import flex2.compiler.swc.catalog.CatalogReadElement;
import flex2.compiler.swc.catalog.ReadContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CatalogReader {
    private InputStream stream;
    protected Swc swc;
    private SwcArchive archive;
    private Versions versions = new Versions();
    private Features features = new Features();
    private Map components = new HashMap();
    private Map libraries = new HashMap();
    private Map files = new HashMap();
    CatalogReadElement defaultReadElement = new SwcReader();
    private VersionReader versionReader = new VersionReader();
    private FeatureReader featureReader = new FeatureReader();
    private ComponentReader componentReader = new ComponentReader();
    private LibraryReader libraryReader = new LibraryReader();
    private ScriptReader scriptReader = new ScriptReader();
    private FilesReader filesReader = new FilesReader();
    static /* synthetic */ Class class$flex2$compiler$swc$catalog$CatalogReader;

    public CatalogReader(InputStream stream, Swc swc, SwcArchive archive) {
        this.stream = stream;
        this.swc = swc;
        this.archive = archive;
    }

    public void read() throws IOException, ParserConfigurationException, SAXException {
        if (this.stream == null) {
            throw new SwcException.NullCatalogStream();
        }
        CatalogHandler handler = new CatalogHandler(this);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        SAXParser parser = factory.newSAXParser();
        parser.parse(this.stream, (DefaultHandler)handler);
        handler.clear();
    }

    public Versions getVersions() {
        return this.versions;
    }

    public Features getFeatures() {
        return this.features;
    }

    public Map getComponents() {
        return this.components;
    }

    public Map getLibraries() {
        return this.libraries;
    }

    public Map getFiles() {
        return this.files;
    }

    public static String readAttribute(String name, Attributes attributes, boolean required) {
        String val = attributes.getValue(name);
        if (val == null && required) {
            throw new SwcException.NoElementValue(name);
        }
        return val;
    }

    public static Long readAttributeLong(String name, Attributes attributes, boolean required) {
        Long val = null;
        String str = CatalogReader.readAttribute(name, attributes, required);
        if (str != null) {
            val = new Long(str);
        }
        return val;
    }

    class FilesReader
    extends CatalogReadElement {
        FilesReader() {
        }

        public CatalogReadElement readElement(ReadContext context) {
            String current = context.getCurrentName();
            if ("file".equals(current)) {
                String path = CatalogReader.readAttribute("path", context.getCurrentAttributes(), true);
                Long mod = CatalogReader.readAttributeLong("mod", context.getCurrentAttributes(), true);
                SwcFile file = new SwcFile(path, mod, CatalogReader.this.swc, CatalogReader.this.archive);
                CatalogReader.this.files.put(path, file);
                return this;
            }
            throw new SwcException.UnknownElementInCatalog("files", current);
        }
    }

    class ScriptReader
    extends CatalogReadElement {
        public SwcLibrary currentLibrary;
        private String name;
        private long modtime;
        private Set defs;
        private SwcDependencySet depSet;
        static final /* synthetic */ boolean $assertionsDisabled;

        ScriptReader() {
        }

        public CatalogReadElement readElement(ReadContext context) {
            String current = context.getCurrentName();
            if ("script".equals(current)) {
                this.name = CatalogReader.readAttribute("name", context.getCurrentAttributes(), true);
                this.modtime = CatalogReader.readAttributeLong("mod", context.getCurrentAttributes(), true);
            } else if ("def".equals(current)) {
                String id = CatalogReader.readAttribute("id", context.getCurrentAttributes(), true);
                this.defs.add(id);
            } else if ("dep".equals(current)) {
                String id = CatalogReader.readAttribute("id", context.getCurrentAttributes(), true);
                String type = CatalogReader.readAttribute("type", context.getCurrentAttributes(), false);
                this.depSet.addDependency(type, id);
            } else if (!"ext".equals(current)) {
                throw new SwcException.UnknownElementInCatalog("script", current);
            }
            return this;
        }

        public void endElement(ReadContext context) {
            if ("script".equals(context.getCurrentName())) {
                if (!$assertionsDisabled && this.currentLibrary == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && this.name == null) {
                    throw new AssertionError();
                }
                this.currentLibrary.addScript(this.name, this.defs, this.depSet, this.modtime);
                this.clear();
            }
        }

        public void clear() {
            ((CatalogReader)CatalogReader.this).scriptReader.name = null;
            ((CatalogReader)CatalogReader.this).scriptReader.modtime = -1L;
            ((CatalogReader)CatalogReader.this).scriptReader.defs = new TreeSet();
            ((CatalogReader)CatalogReader.this).scriptReader.depSet = new SwcDependencySet();
        }

        static {
            $assertionsDisabled = !(class$flex2$compiler$swc$catalog$CatalogReader == null ? (class$flex2$compiler$swc$catalog$CatalogReader = CatalogReader.class$("flex2.compiler.swc.catalog.CatalogReader")) : class$flex2$compiler$swc$catalog$CatalogReader).desiredAssertionStatus();
        }
    }

    class LibraryReader
    extends CatalogReadElement {
        LibraryReader() {
        }

        public CatalogReadElement readElement(ReadContext context) {
            String current = context.getCurrentName();
            if ("library".equals(current)) {
                String path = CatalogReader.readAttribute("path", context.getCurrentAttributes(), true);
                SwcLibrary lib = new SwcLibrary(CatalogReader.this.swc, path);
                CatalogReader.this.libraries.put(path, lib);
                CatalogReader.this.scriptReader.clear();
                ((CatalogReader)CatalogReader.this).scriptReader.currentLibrary = lib;
                return CatalogReader.this.scriptReader;
            }
            throw new SwcException.UnknownElementInCatalog("libraries", current);
        }
    }

    class ComponentReader
    extends CatalogReadElement {
        ComponentReader() {
        }

        public CatalogReadElement readElement(ReadContext context) {
            String current = context.getCurrentName();
            if ("component".equals(current)) {
                Component comp = new Component();
                Attributes attrib = context.getCurrentAttributes();
                comp.setClassName(CatalogReader.readAttribute("className", attrib, true));
                comp.setName(CatalogReader.readAttribute("name", attrib, false));
                comp.setUri(CatalogReader.readAttribute("uri", attrib, false));
                comp.setIcon(CatalogReader.readAttribute("icon", attrib, false));
                comp.setDocs(CatalogReader.readAttribute("docs", attrib, false));
                comp.setPreview(CatalogReader.readAttribute("preview", attrib, false));
                CatalogReader.this.components.put(comp.getClassName(), comp);
                return this;
            }
            throw new SwcException.UnknownElementInCatalog("components", current);
        }
    }

    class FeatureReader
    extends CatalogReadElement {
        FeatureReader() {
        }

        public CatalogReadElement readElement(ReadContext context) {
            String name = context.getCurrentName();
            if ("feature-debug".equals(name)) {
                CatalogReader.this.features.setDebug(true);
            } else if ("feature-external-deps".equals(name)) {
                CatalogReader.this.features.setExternalDeps(true);
            } else if ("feature-script-deps".equals(name)) {
                CatalogReader.this.features.setScriptDeps(true);
            } else if ("feature-components".equals(name)) {
                CatalogReader.this.features.setComponents(true);
            } else if ("feature-files".equals(name)) {
                CatalogReader.this.features.setFiles(true);
            } else {
                Attributes attrib = context.getCurrentAttributes();
                String req = attrib.getValue("required");
                if (req != null && req.equalsIgnoreCase("true")) {
                    throw new SwcException.UnsupportedFeature(name);
                }
            }
            return this;
        }
    }

    class VersionReader
    extends CatalogReadElement {
        VersionReader() {
        }

        public CatalogReadElement readElement(ReadContext context) {
            String current = context.getCurrentName();
            if ("flex".equals(current)) {
                Attributes attrib = context.getCurrentAttributes();
                CatalogReader.this.versions.setFlexVersion(CatalogReader.readAttribute("version", attrib, true));
                CatalogReader.this.versions.setFlexBuild(CatalogReader.readAttribute("build", attrib, false));
            } else if ("swc".equals(current)) {
                Attributes attrib = context.getCurrentAttributes();
                CatalogReader.this.versions.setLibVersion(CatalogReader.readAttribute("version", attrib, true));
            }
            return this;
        }
    }

    class SwcReader
    extends CatalogReadElement {
        SwcReader() {
        }

        public CatalogReadElement readElement(ReadContext context) {
            String current = context.getCurrentName();
            if ("versions".equals(current)) {
                return CatalogReader.this.versionReader;
            }
            if ("features".equals(current)) {
                return CatalogReader.this.featureReader;
            }
            if ("components".equals(current)) {
                return CatalogReader.this.componentReader;
            }
            if ("files".equals(current)) {
                return CatalogReader.this.filesReader;
            }
            if ("libraries".equals(current)) {
                return CatalogReader.this.libraryReader;
            }
            if ("swc".equals(current)) {
                return this;
            }
            throw new SwcException.UnknownElementInCatalog("swc", current);
        }
    }
}

