/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.swc;

import flash.swf.Frame;
import flash.swf.tags.FrameLabel;
import flex2.compiler.CompilationUnit;
import flex2.compiler.swc.Swc;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.compiler.util.Visitor;
import flex2.linker.CULinkable;
import flex2.linker.Configuration;
import flex2.linker.DependencyWalker;
import flex2.linker.FlexMovie;
import flex2.linker.LinkerException;
import flex2.linker.SimpleMovie;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class SwcMovie
extends SimpleMovie {
    private Set externs;
    private Set includes;
    private Set unresolved;
    private SortedSet resourceBundles;

    public SwcMovie(Configuration configuration) {
        super(configuration);
        this.externs = new HashSet(configuration.getExterns());
        this.includes = new HashSet(configuration.getIncludes());
        this.unresolved = new HashSet(configuration.getUnresolved());
        this.generateLinkReport = configuration.generateLinkReport();
        this.generateRBList = configuration.generateRBList();
        this.resourceBundles = new TreeSet(configuration.getResourceBundles());
    }

    public void generate(List units) throws LinkerException {
        LinkedList<CULinkable> linkables = new LinkedList<CULinkable>();
        Iterator it = units.iterator();
        while (it.hasNext()) {
            linkables.add(new CULinkable((CompilationUnit)it.next()));
        }
        this.frames = new ArrayList();
        try {
            DependencyWalker.LinkState state = new DependencyWalker.LinkState(linkables, this.externs, this.includes, this.unresolved);
            final Frame frame = new Frame();
            DependencyWalker.traverse(null, state, true, true, new Visitor(){

                public void visit(Object o) {
                    CULinkable l = (CULinkable)o;
                    SwcMovie.this.exportUnitOnFrame(l.getUnit(), frame, true);
                }
            });
            this.frames.add(frame);
            if (Swc.FNORD) {
                frame.label = new FrameLabel();
                frame.label.label = Integer.toString(SimpleMovie.getCodeHash(frame));
            }
            if (this.generateLinkReport) {
                this.linkReport = DependencyWalker.dump(state);
            }
            if (this.generateRBList) {
                this.rbList = FlexMovie.dumpRBList(this.resourceBundles);
            }
            if (this.unresolved.size() != 0) {
                Iterator it2 = this.unresolved.iterator();
                while (it2.hasNext()) {
                    String u = (String)it2.next();
                    if (this.externs.contains(u)) continue;
                    ThreadLocalToolkit.log(new LinkerException.UndefinedSymbolException(u));
                }
            }
        }
        catch (LinkerException e) {
            ThreadLocalToolkit.log(e);
        }
    }
}

