/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.swc;

import flash.util.FileUtils;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.InMemoryFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.SwcArchive;
import flex2.compiler.swc.SwcException;
import flex2.compiler.swc.zip.ZipEntry;
import flex2.compiler.swc.zip.ZipFile;
import flex2.compiler.swc.zip.ZipOutputStream;
import flex2.compiler.util.MimeMappings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SwcDynamicArchive
implements SwcArchive {
    protected final String path;
    protected Map files = new HashMap();

    public SwcDynamicArchive(String path) {
        this.path = path;
    }

    public String getLocation() {
        return this.path;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load() {
        ZipFile zipFile = null;
        try {
            try {
                zipFile = new ZipFile(this.path);
                Enumeration e = zipFile.getEntries();
                while (e.hasMoreElements()) {
                    ZipEntry ze = (ZipEntry)e.nextElement();
                    InputStream inputStream = zipFile.getInputStream(ze);
                    InMemoryFile f = new InMemoryFile(inputStream, ze.getSize(), this.path + "$" + ze.getName(), MimeMappings.getMimeType(ze.getName()), ze.getTime());
                    this.files.put(ze.getName(), f);
                }
                Object var7_8 = null;
            }
            catch (SwcException e2) {
                throw e2;
            }
            catch (Exception e3) {
                throw new SwcException.FilesNotRead(e3.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            try {
                if (zipFile == null) throw throwable;
                zipFile.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ioe) {}
        if (zipFile == null) return;
        zipFile.close();
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws Exception {
        String tmpPath = this.path + ".tmp";
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(FileUtil.openFile(tmpPath, true))));
            Iterator it = this.files.values().iterator();
            while (it.hasNext()) {
                VirtualFile f = (VirtualFile)it.next();
                ZipEntry entry = new ZipEntry(f.getName());
                entry.setTime(f.getLastModified());
                zos.putNextEntry(entry);
                BufferedInputStream in = new BufferedInputStream(f.getInputStream());
                FileUtil.streamOutput(in, zos);
                zos.closeEntry();
            }
            zos.close();
            zos = null;
            File tmpFile = new File(tmpPath);
            File file = new File(this.path);
            if (!FileUtils.renameFile((File)tmpFile, (File)file)) {
                throw new SwcException.SwcNotRenamed(tmpFile.getAbsolutePath(), file.getAbsolutePath());
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                if (zos != null) {
                    zos.close();
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (zos != null) {
                zos.close();
            }
        }
        catch (IOException ioe) {}
    }

    public void close() {
    }

    public Map getFiles() {
        return this.files;
    }

    public VirtualFile getFile(String path) {
        return (VirtualFile)this.files.get(path);
    }

    public void putFile(VirtualFile file) {
        this.files.put(file.getName(), file);
    }

    public void putFile(String path, byte[] data, long lastModified) {
        InMemoryFile file = new InMemoryFile(data, path, MimeMappings.getMimeType(path), lastModified);
        this.files.put(file.getName(), file);
    }

    public long getLastModified() {
        return 0L;
    }
}

