/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.swc;

import flash.util.FileUtils;
import flash.util.LRUCache;
import flash.util.Trace;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.Swc;
import flex2.compiler.swc.SwcArchive;
import flex2.compiler.swc.SwcDirectoryArchive;
import flex2.compiler.swc.SwcDynamicArchive;
import flex2.compiler.swc.SwcException;
import flex2.compiler.swc.SwcGroup;
import flex2.compiler.swc.SwcLazyReadArchive;
import flex2.compiler.util.ThreadLocalToolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SwcCache {
    public static int CACHE_INITIAL_SIZE = 20;
    public static int CACHE_MAX_SIZE = 50;
    public static final String SWC_EXTENSION = ".swc";
    public static final String GENSWC_EXTENSION = "-generated.swc";
    private SwcLRUCache swcs = new SwcLRUCache();
    private boolean useCache = true;
    private boolean lazyRead = false;

    public SwcGroup getSwcGroup(VirtualFile[] paths) {
        String[] urls = new String[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            urls[i] = paths[i].getName();
        }
        return this.getSwcGroup(urls);
    }

    public synchronized SwcGroup getSwcGroup(String[] paths) {
        HashMap swcs = new HashMap();
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            swcs.putAll(this.getSwcs(path));
        }
        SwcGroup group = new SwcGroup(swcs);
        return group;
    }

    public synchronized SwcGroup getSwcGroup(List groups) {
        HashMap swcs = new HashMap();
        Iterator it = groups.iterator();
        while (it.hasNext()) {
            SwcGroup g = (SwcGroup)it.next();
            if (g == null) continue;
            swcs.putAll(g.getSwcs());
        }
        SwcGroup group = null;
        if (swcs.size() > 0) {
            group = new SwcGroup(swcs);
        }
        return group;
    }

    public synchronized boolean export(Swc swc) throws FileNotFoundException, IOException {
        try {
            if (!swc.save()) {
                return false;
            }
            if (Trace.swc) {
                Trace.trace((String)("Exported SWC " + swc.getLocation() + "(" + swc.getLastModified() + ")"));
            }
            this.swcs.put(swc.getLocation(), swc);
        }
        catch (Exception e) {
            if (Trace.error) {
                e.printStackTrace();
            }
            SwcException.SwcNotExported ex = new SwcException.SwcNotExported(swc.getLocation(), e);
            ThreadLocalToolkit.log(ex);
            throw ex;
        }
        return true;
    }

    private Map getSwcs(String path) {
        HashMap<String, Swc> map = new HashMap<String, Swc>();
        File f = new File(path);
        if (!f.exists()) {
            throw new SwcException.SwcNotFound(path);
        }
        File catalog = new File(FileUtils.addPathComponents((String)path, (String)Swc.CATALOG_XML, (char)File.separatorChar));
        if (!f.isDirectory() || catalog.exists()) {
            Swc swc = this.getSwc(f);
            if (swc != null) {
                map.put(swc.getLocation(), swc);
            }
        } else {
            File[] files = FileUtils.listFiles((File)f);
            for (int i = 0; i < files.length; ++i) {
                Swc swc;
                String lowerCase;
                File file = files[i];
                if (file.isDirectory() || !file.canRead() || (lowerCase = file.getName().toLowerCase()).endsWith(GENSWC_EXTENSION) || !lowerCase.endsWith(SWC_EXTENSION) || (swc = this.getSwc(file)) == null) continue;
                map.put(swc.getLocation(), swc);
            }
        }
        return map;
    }

    private Swc getSwc(File file) {
        Swc swc;
        try {
            String location = FileUtils.canonicalPath((File)file);
            swc = (Swc)this.swcs.get(location);
            long lastModified = file.lastModified();
            if (swc == null || lastModified != swc.getLastModified()) {
                if (Trace.swc) {
                    Trace.trace((String)("Getting new version of " + location + " (" + (swc == null ? "null" : swc.getLocation()) + ", " + (swc == null ? -1L : swc.getLastModified()) + ", " + lastModified + ")"));
                }
                SwcArchive archive = file.isDirectory() ? new SwcDirectoryArchive(location) : (this.lazyRead ? new SwcLazyReadArchive(location) : new SwcDynamicArchive(location));
                swc = new Swc(archive, true);
                swc.setLastModified(lastModified);
                if (ThreadLocalToolkit.errorCount() > 0) {
                    swc = null;
                } else if (this.useCache) {
                    this.swcs.put(location, swc);
                }
            } else if (Trace.swc) {
                Trace.trace((String)("Loading cached version of " + location));
            }
        }
        catch (Exception e) {
            if (Trace.error) {
                e.printStackTrace();
            }
            SwcException.SwcNotLoaded ex = new SwcException.SwcNotLoaded(file.getName(), e);
            ThreadLocalToolkit.log(ex);
            throw ex;
        }
        return swc;
    }

    public void setLazyRead(boolean lazyRead) {
        this.lazyRead = lazyRead;
    }

    static class SwcLRUCache
    extends LRUCache {
        SwcLRUCache() {
            super(CACHE_INITIAL_SIZE, CACHE_MAX_SIZE);
        }

        protected Object fetch(Object key) {
            return null;
        }
    }
}

