/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.swc;

import flash.swf.Movie;
import flash.swf.MovieEncoder;
import flash.swf.TagEncoder;
import flash.swf.TagHandler;
import flex2.compiler.CompilationUnit;
import flex2.compiler.Source;
import flex2.compiler.io.InMemoryFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.API;
import flex2.compiler.swc.Component;
import flex2.compiler.swc.Features;
import flex2.compiler.swc.SwcArchive;
import flex2.compiler.swc.SwcDependencySet;
import flex2.compiler.swc.SwcException;
import flex2.compiler.swc.SwcLibrary;
import flex2.compiler.swc.SwcMovie;
import flex2.compiler.swc.SwcScript;
import flex2.compiler.swc.Versions;
import flex2.compiler.swc.catalog.CatalogReader;
import flex2.compiler.swc.catalog.CatalogWriter;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.MimeMappings;
import flex2.compiler.util.MultiName;
import flex2.compiler.util.MultiNameSet;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.QName;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.linker.Configuration;
import flex2.linker.LinkerException;
import flex2.tools.VersionInfo;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class Swc {
    protected static boolean FNORD;
    public static String LIBRARY_SWF;
    public static String CATALOG_XML;
    private final SwcArchive archive;
    private long lastModified = -1L;
    private Map libraries = new HashMap();
    private Map catalogFiles;
    private Map components = new TreeMap();
    private Versions versions = new Versions();
    private Features features = new Features();
    private Map defs = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    public Swc(SwcArchive archive) throws Exception {
        this(archive, false);
    }

    Swc(SwcArchive archive, boolean load) throws Exception {
        this.archive = archive;
        if (load) {
            this.read();
        }
    }

    long getLastModified() {
        return this.lastModified;
    }

    void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public String getLocation() {
        return this.archive.getLocation();
    }

    public Iterator getLibraryIterator() {
        return this.libraries.values().iterator();
    }

    public SwcLibrary buildLibrary(String libname, Configuration configuration, List units) throws IOException, LinkerException {
        SwcMovie m = API.link(configuration, units);
        return this.buildLibrary(libname, configuration, m);
    }

    public SwcLibrary buildLibrary(String libname, Configuration configuration, SwcMovie movie) throws IOException, LinkerException {
        ByteArrayOutputStream swfOut = new ByteArrayOutputStream();
        TagEncoder encoder = new TagEncoder();
        new MovieEncoder((TagHandler)encoder).export((Movie)movie);
        encoder.writeTo((OutputStream)swfOut);
        swfOut.flush();
        byte[] swf = swfOut.toByteArray();
        swfOut.close();
        String libPath = libname + ".swf";
        SwcLibrary lib = new SwcLibrary(this, libPath);
        InMemoryFile swfFile = new InMemoryFile(swf, libPath, MimeMappings.getMimeType(libPath), new Date().getTime());
        this.archive.putFile(swfFile);
        this.libraries.put(libPath, lib);
        lib.getExterns().addAll(configuration.getUnresolved());
        Iterator iterator = movie.getExportedUnits().iterator();
        while (iterator.hasNext()) {
            CompilationUnit unit = (CompilationUnit)iterator.next();
            Source unitSource = unit.getSource();
            SwcDependencySet depset = new SwcDependencySet();
            Swc.addDeps(depset, "i", unit.inheritance);
            Swc.addDeps(depset, "s", unit.types);
            Swc.addDeps(depset, "n", unit.namespaces);
            Swc.addDeps(depset, "e", unit.expressions);
            Swc.addExtraClassesDeps(depset, unit.extraClasses);
            Set scriptDefs = unit.topLevelDefinitions.getStringSet();
            this.checkDefs(scriptDefs, unitSource.getName());
            String sourceName = NameFormatter.nameFromSource(unitSource);
            lib.addScript(sourceName, scriptDefs, depset, unitSource.getLastModified());
            this.addIcons(unit, sourceName);
        }
        return lib;
    }

    private void addIcons(CompilationUnit unit, String sourceName) throws IOException {
        String icon;
        String string = icon = unit.iconFile == null ? null : unit.iconFile.getValue(0);
        if (icon != null) {
            String iconName;
            VirtualFile iconFile = unit.getSource().resolve(icon);
            if (iconFile == null && unit.getSource().isSwcScriptOwner()) {
                int s = unit.topLevelDefinitions.size();
                for (int i = 0; i < s; ++i) {
                    String swcIcon;
                    String def = unit.topLevelDefinitions.get(i).toString();
                    if (!this.components.containsKey(def) || (swcIcon = ((Component)this.components.get(def)).getIcon()) == null || (iconFile = ((SwcScript)unit.getSource().getOwner()).getLibrary().getSwc().getFile(swcIcon)) == null) continue;
                    InMemoryFile inMemFile = new InMemoryFile(iconFile.getInputStream(), swcIcon, MimeMappings.getMimeType(swcIcon), iconFile.getLastModified());
                    this.archive.putFile(inMemFile);
                    return;
                }
                if (iconFile == null) {
                    return;
                }
            }
            if (iconFile == null) {
                throw new SwcException.MissingIconFile(icon, sourceName);
            }
            String workingSourceName = NameFormatter.toColon(NameFormatter.toDot(sourceName, '/'));
            Component comp = (Component)this.components.get(workingSourceName);
            String rel = unit.getSource().getRelativePath();
            String string2 = iconName = rel == null || rel.equals("") ? icon : rel + "/" + icon;
            if (comp != null) {
                comp.setIcon(iconName);
            }
            InMemoryFile inMemFile = new InMemoryFile(iconFile.getInputStream(), iconName, MimeMappings.getMimeType(iconName), iconFile.getLastModified());
            this.archive.putFile(inMemFile);
        }
    }

    private void checkDefs(Set scriptDefs, String sourceName) {
        Iterator iter2 = scriptDefs.iterator();
        while (iter2.hasNext()) {
            String str = (String)iter2.next();
            String script = (String)this.defs.get(str);
            if (script != null) {
                throw new SwcException.DuplicateDefinition(str, script, sourceName);
            }
            this.defs.put(str, sourceName);
        }
    }

    private static void addDeps(SwcDependencySet depset, String type, MultiNameSet mns) {
        Iterator it = mns.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof MultiName) {
                MultiName mname = (MultiName)o;
                if (!$assertionsDisabled && mname.getNumQNames() != 1) {
                    throw new AssertionError();
                }
                depset.addDependency(type, mname.getQName(0).toString());
                continue;
            }
            if (!$assertionsDisabled && !(o instanceof QName)) {
                throw new AssertionError();
            }
            depset.addDependency(type, o.toString());
        }
    }

    private static void addExtraClassesDeps(SwcDependencySet depset, Set extraClasses) {
        Iterator it = extraClasses.iterator();
        while (it.hasNext()) {
            String extraClass = (String)it.next();
            depset.addDependency("e", extraClass);
        }
    }

    synchronized boolean save() throws Exception {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)byteOut, "UTF-8");
        if (this.components.size() > 0) {
            this.features.setComponents(true);
        }
        if (this.archive.getFiles().size() > 0) {
            this.features.setFiles(true);
        }
        this.versions.setLibVersion(VersionInfo.getLibVersion());
        this.versions.setFlexVersion(VersionInfo.getFlexVersion());
        this.versions.setFlexBuild(VersionInfo.getBuild());
        Iterator it = this.libraries.values().iterator();
        while (it.hasNext()) {
            SwcLibrary l = (SwcLibrary)it.next();
            if (l.getExterns().size() <= 0) continue;
            this.features.setExternalDeps(true);
            break;
        }
        CatalogWriter writer = new CatalogWriter(out, this.versions, this.features, this.components.values(), this.libraries.values(), this.archive.getFiles().values());
        writer.write();
        ((Writer)out).close();
        this.archive.putFile(CATALOG_XML, byteOut.toByteArray(), new Date().getTime());
        this.archive.save();
        return ThreadLocalToolkit.errorCount() == 0;
    }

    public Map getCatalogFiles() {
        return this.catalogFiles;
    }

    public VirtualFile getFile(String path) {
        return (VirtualFile)this.catalogFiles.get(path);
    }

    public void addFile(VirtualFile file) {
        this.archive.putFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void read() throws Exception {
        InputStream stream = null;
        try {
            this.archive.load();
            VirtualFile catalogFile = this.archive.getFile(CATALOG_XML);
            if (catalogFile == null) {
                throw new SwcException.CatalogNotFound();
            }
            stream = catalogFile.getInputStream();
            CatalogReader reader = new CatalogReader(new BufferedInputStream(stream), this, this.archive);
            reader.read();
            this.versions = reader.getVersions();
            this.features = reader.getFeatures();
            this.components = reader.getComponents();
            this.libraries = reader.getLibraries();
            this.catalogFiles = reader.getFiles();
            if (VersionInfo.IsNewerLibVersion(this.versions.getLibVersion())) {
                OldVersion oldVersion = new OldVersion(this.archive.getLocation(), this.versions.getLibVersion(), VersionInfo.getLibVersion());
                ThreadLocalToolkit.log(oldVersion);
            }
            Object var6_5 = null;
            if (stream == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (stream == null) throw throwable;
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            stream.close();
            return;
        }
        catch (IOException ioe) {}
    }

    public void close() {
        this.archive.close();
    }

    public Iterator getComponentIterator() {
        return this.components.values().iterator();
    }

    public Versions getVersions() {
        return this.versions;
    }

    public Features getFeatures() {
        return this.features;
    }

    public void addComponent(Component c) {
        this.components.put(c.getClassName(), c);
    }

    protected SwcArchive getArchive() {
        return this.archive;
    }

    static {
        $assertionsDisabled = !Swc.class.desiredAssertionStatus();
        FNORD = false;
        LIBRARY_SWF = "library.swf";
        CATALOG_XML = "catalog.xml";
    }

    public static class OldVersion
    extends CompilerMessage.CompilerWarning {
        public String swc;
        public String swcVer;
        public String compilerVer;

        public OldVersion(String swc, String swcVer, String compilerVer) {
            this.swc = swc;
            this.swcVer = swcVer;
            this.compilerVer = compilerVer;
        }
    }
}

