/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.rep;

import flash.util.StringUtils;
import flex2.compiler.Source;
import flex2.compiler.as3.MetaDataParser;
import flex2.compiler.as3.reflect.MetaData;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.mxml.reflect.TypeTable;
import flex2.compiler.mxml.rep.LineNumberMapped;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.ThreadLocalToolkit;
import java.util.HashMap;
import java.util.Map;

public class AtEmbed
implements LineNumberMapped {
    private String propName;
    private int lineNumber;
    private Map attributes;
    private boolean strType;

    public AtEmbed(String propName, int lineNumber, Map attrs, boolean strType) {
        this.propName = propName;
        this.lineNumber = lineNumber;
        this.attributes = new HashMap(attrs);
        this.strType = strType;
    }

    public String getPropName() {
        return this.propName;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public int getXmlLineNumber() {
        return this.lineNumber;
    }

    public String getType() {
        return this.strType ? "String" : "Class";
    }

    public void setXmlLineNumber(int xmlLineNumber) {
        this.lineNumber = xmlLineNumber;
    }

    public static AtEmbed create(String baseName, int beginLine, Map attrs, boolean strType) {
        String embedName = AtEmbed.createMangledName(baseName, ((Object)attrs).hashCode());
        return new AtEmbed(embedName, beginLine, attrs, strType);
    }

    public static AtEmbed create(TypeTable typeTable, Source sourceFile, int beginLine, String value, boolean strType) {
        MetaData metaData = MetaDataParser.parse(typeTable.getPerCompileData(), sourceFile, beginLine, value.substring(1));
        if (metaData == null) {
            return null;
        }
        if (metaData.count() == 0) {
            ThreadLocalToolkit.log((CompilerMessage)new NoEmbedParams(), sourceFile.getNameForReporting(), beginLine);
            return null;
        }
        String source = metaData.getValue("source");
        if (source == null && metaData.getKey(0) == null && metaData.count() == 1) {
            source = metaData.getValue(0);
        }
        Map values = AtEmbed.getMetaDataMap(metaData);
        String embedName = AtEmbed.createMangledName(sourceFile, source, strType, values, "_embed_mxml_");
        return new AtEmbed(embedName, beginLine, values, strType);
    }

    private static Map getMetaDataMap(flex2.compiler.abc.MetaData metaData) {
        int len = metaData.count();
        HashMap<String, String> values = new HashMap<String, String>();
        for (int i = 0; i < len; ++i) {
            String key = metaData.getKey(i);
            String value = metaData.getValue(i);
            if (key == null) {
                values.put("source", value);
                continue;
            }
            values.put(key, value);
        }
        return values;
    }

    public static String createMangledName(Source source, String path, boolean strType, Map attrs, String prefix) {
        String symbol;
        StringBuffer buf = new StringBuffer(128);
        if (prefix != null) {
            buf.append(prefix);
        }
        int hash = ((Object)attrs).hashCode();
        String mimeType = (String)attrs.get("mimeType");
        VirtualFile f = null;
        if (path != null) {
            buf.append(path);
            f = source.resolve(path);
            if (f != null) {
                hash ^= ((Object)f).hashCode();
            }
        } else if (mimeType != null) {
            buf.append(mimeType);
        }
        if ((symbol = (String)attrs.get("symbol")) != null) {
            buf.append('_');
            buf.append(symbol);
        }
        if (strType) {
            buf.append("_s");
        }
        return AtEmbed.createMangledName(buf.toString(), hash);
    }

    public static String createMangledName(String name, int hash) {
        return StringUtils.replaceAll((String)(name + '_' + Math.abs(hash)), (String)"[^A-Za-z0-9]", (String)"_");
    }

    public static class NoEmbedParams
    extends CompilerMessage.CompilerError {
    }
}

