/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.builder;

import flex2.compiler.CompilationUnit;
import flex2.compiler.mxml.Configuration;
import flex2.compiler.mxml.builder.Builder;
import flex2.compiler.mxml.dom.CDATANode;
import flex2.compiler.mxml.dom.Node;
import flex2.compiler.mxml.dom.ScriptNode;
import flex2.compiler.mxml.lang.AttributeHandler;
import flex2.compiler.mxml.lang.BindingHandler;
import flex2.compiler.mxml.lang.ChildNodeHandler;
import flex2.compiler.mxml.lang.StandardDefs;
import flex2.compiler.mxml.reflect.Effect;
import flex2.compiler.mxml.reflect.Event;
import flex2.compiler.mxml.reflect.Property;
import flex2.compiler.mxml.reflect.Style;
import flex2.compiler.mxml.reflect.Type;
import flex2.compiler.mxml.reflect.TypeTable;
import flex2.compiler.mxml.rep.BindingExpression;
import flex2.compiler.mxml.rep.Model;
import flex2.compiler.mxml.rep.MovieClip;
import flex2.compiler.mxml.rep.MxmlDocument;
import flex2.compiler.mxml.rep.Primitive;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.QName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class ComponentBuilder
extends Builder {
    protected Model parent;
    protected boolean topLevelChild;
    protected BindingHandler bindingHandler;
    protected ComponentAttributeHandler attributeHandler;
    protected ComponentChildNodeHandler childNodeHandler;
    Model component;
    static final /* synthetic */ boolean $assertionsDisabled;

    ComponentBuilder(CompilationUnit unit, TypeTable typeTable, Configuration configuration, MxmlDocument document, Model parent, boolean topLevelChild, BindingHandler bindingHandler) {
        super(unit, typeTable, configuration, document);
        this.parent = parent;
        this.topLevelChild = topLevelChild;
        this.bindingHandler = bindingHandler;
        this.attributeHandler = new ComponentAttributeHandler();
        this.childNodeHandler = new ComponentChildNodeHandler(typeTable);
    }

    public void analyze(Node node) {
        if (!$assertionsDisabled && this.component != null) {
            throw new AssertionError((Object)"ComponentBuilder.analyze(Node) called twice");
        }
        Type type = this.nodeTypeResolver.resolveType(node);
        this.constructComponent(type, node.beginLine);
        this.processAttributes(node, type);
        this.processChildren(node, type);
        this.registerModel(node, this.component, this.topLevelChild);
    }

    public void analyze(ScriptNode node) {
    }

    protected void constructComponent(Type type, int line) {
        Model model = this.component = StandardDefs.isIUIComponent(type) ? new MovieClip(this.document, type, this.parent, line) : new Model(this.document, type, this.parent, line);
        if (type.equals(this.typeTable.objectType)) {
            this.component.setInspectable(true);
        }
    }

    protected void processAttributes(Node node, Type type) {
        this.processSpecialAttributes(node);
        Iterator iter = node.getAttributeNames();
        while (iter.hasNext()) {
            this.attributeHandler.invoke(node, type, (QName)iter.next());
        }
    }

    protected void unknownAttributeError(String name, int line) {
        this.log(line, (CompilerMessage)new UnknownAttribute(name, NameFormatter.toDot(this.component.getType().getName())));
    }

    protected void processChildren(Node node, Type type) {
        this.childNodeHandler.scanChildNodes(node, type);
        if (!this.childNodeHandler.getDefaultPropertyNodes().isEmpty()) {
            this.processPropertyNodes(this.childNodeHandler.getDefaultPropertyNodes(), type.getDefaultProperty(), this.component, node.beginLine);
        }
    }

    protected boolean isLegalLanguageNode(Node node) {
        Class<?> nodeClass = node.getClass();
        return nodeClass == ScriptNode.class;
    }

    protected void processVisualChild(Node node) {
        ComponentBuilder builder = new ComponentBuilder(this.unit, this.typeTable, this.configuration, this.document, this.component, false, null);
        node.analyze(builder);
        ((MovieClip)this.component).addChild((MovieClip)builder.component);
    }

    protected void processTextInitializer(CDATANode cdata) {
        if (!this.component.isEmpty()) {
            this.log(cdata.beginLine, (CompilerMessage)new MixedInitializers());
        } else {
            int line;
            int flags;
            String text = cdata.image;
            Type type = this.component.getType();
            Object value = this.textParser.parseValue(text, type, this.typeTable.objectType, flags = cdata.inCDATA ? 1 : 0, line = cdata.beginLine, NameFormatter.toDot(type.getName()));
            if (value != null) {
                if (value instanceof BindingExpression) {
                    if (this.bindingHandler != null) {
                        this.bindingHandler.invoke((BindingExpression)value, this.component);
                    } else {
                        this.log(line, (CompilerMessage)new Builder.BindingNotAllowed());
                    }
                } else {
                    Model preppedComponent = this.component;
                    this.component = value instanceof Model ? (Model)value : new Primitive(this.document, preppedComponent.getType(), value, line);
                    this.component.setId(preppedComponent.getId());
                }
            }
        }
    }

    protected boolean isAllowedProperty(Property property) {
        return !property.getName().equals("states") || !property.getType().equals(this.typeTable.arrayType) || !this.component.getType().isAssignableTo(StandardDefs.CLASS_UICOMPONENT);
    }

    protected boolean isSpecialAttribute(String namespaceURI, String localPart) {
        return namespaceURI.length() == 0 && "id".equals(localPart);
    }

    protected void processSpecialAttributes(Node node) {
    }

    static {
        $assertionsDisabled = !ComponentBuilder.class.desiredAssertionStatus();
    }

    public static class MixedInitializers
    extends CompilerMessage.CompilerError {
    }

    public static class IllegalLanguageNode
    extends CompilerMessage.CompilerError {
        public String image;

        public IllegalLanguageNode(String image) {
            this.image = image;
        }
    }

    public static class InitializersNotAllowed
    extends CompilerMessage.CompilerError {
    }

    public static class MixedContent
    extends CompilerMessage.CompilerError {
    }

    public static class NestedDeclaration
    extends CompilerMessage.CompilerError {
    }

    public static class NestedFlexDeclaration
    extends CompilerMessage.CompilerError {
        public String interfaceName;

        public NestedFlexDeclaration(String interfaceName) {
            this.interfaceName = interfaceName;
        }
    }

    public static class NonContiguous
    extends CompilerMessage.CompilerError {
    }

    public static class UnknownAttribute
    extends CompilerMessage.CompilerError {
        public String name;
        public String type;

        public UnknownAttribute(String name, String type) {
            this.name = name;
            this.type = type;
        }
    }

    public static class UnknownNamespace
    extends CompilerMessage.CompilerError {
        public String namespace;
        public String text;

        public UnknownNamespace(String namespace, String text) {
            this.namespace = namespace;
            this.text = text;
        }
    }

    protected class ComponentChildNodeHandler
    extends ChildNodeHandler {
        protected Collection defaultPropertyNodes;
        static final /* synthetic */ boolean $assertionsDisabled;

        public ComponentChildNodeHandler(TypeTable typeTable) {
            super(typeTable);
        }

        public Collection getDefaultPropertyNodes() {
            return this.defaultPropertyNodes != null ? this.defaultPropertyNodes : Collections.EMPTY_LIST;
        }

        protected void addDefaultPropertyNode(Node node) {
            (this.defaultPropertyNodes != null ? this.defaultPropertyNodes : (this.defaultPropertyNodes = new ArrayList<Node>(1))).add(node);
        }

        protected void event(Event event) {
            CDATANode cdata = ComponentBuilder.this.getTextContent(this.child.getChildren(), false);
            if (cdata != null) {
                ComponentBuilder.this.processEventText(event, cdata.image, cdata.beginLine, ComponentBuilder.this.component);
            }
        }

        protected void property(Property property) {
            Type type = property.getType();
            if (ComponentBuilder.this.checkNonEmpty(this.child, type)) {
                ComponentBuilder.this.processPropertyNodes(this.child, property, ComponentBuilder.this.component);
            } else if (ComponentBuilder.this.allowEmptyDefault(type)) {
                ComponentBuilder.this.processPropertyText(property, "", Builder.TextOrigin.FROM_CHILD_CDATA, this.child.beginLine, ComponentBuilder.this.component);
            }
        }

        protected void effect(Effect effect) {
            if (ComponentBuilder.this.checkNonEmpty(this.child, this.typeTable.classType)) {
                ComponentBuilder.this.processEffectNodes(this.child, effect, ComponentBuilder.this.component);
            }
        }

        protected void style(Style style) {
            Type type = style.getType();
            if (ComponentBuilder.this.checkNonEmpty(this.child, type)) {
                ComponentBuilder.this.processStyleNodes(this.child, style, ComponentBuilder.this.component);
            } else if (ComponentBuilder.this.allowEmptyDefault(type)) {
                ComponentBuilder.this.processStyleText(style, "", Builder.TextOrigin.FROM_CHILD_CDATA, this.child.beginLine, ComponentBuilder.this.component);
            }
        }

        protected void dynamicProperty(String name) {
            Type type = this.typeTable.objectType;
            if (ComponentBuilder.this.checkNonEmpty(this.child, type)) {
                ComponentBuilder.this.processDynamicPropertyNodes(this.child, name, ComponentBuilder.this.component);
            } else if (ComponentBuilder.this.allowEmptyDefault(type)) {
                ComponentBuilder.this.processDynamicPropertyText(name, "", Builder.TextOrigin.FROM_CHILD_CDATA, this.child.beginLine, ComponentBuilder.this.component);
            }
        }

        protected void defaultPropertyElement(boolean locError) {
            if (locError) {
                ComponentBuilder.this.log(this.child, new NonContiguous());
            }
            this.addDefaultPropertyNode(this.child);
        }

        protected void nestedDeclaration() {
            Type childType = this.nodeTypeResolver.resolveType(this.child);
            if (!$assertionsDisabled && childType == null) {
                throw new AssertionError((Object)("nested declaration node type == null, node = " + this.child.image));
            }
            if (StandardDefs.isContainer(this.parentType) && StandardDefs.isIUIComponent(childType)) {
                ComponentBuilder.this.processVisualChild(this.child);
            } else if (StandardDefs.isContainer(this.parentType) && childType.isAssignableTo("mx.controls:RadioButtonGroup")) {
                ComponentBuilder builder = new ComponentBuilder(ComponentBuilder.this.unit, this.typeTable, ComponentBuilder.this.configuration, ComponentBuilder.this.document, ComponentBuilder.this.component, true, null);
                this.child.analyze(builder);
            } else {
                this.processNestedDeclaration();
            }
        }

        protected void processNestedDeclaration() {
            if (StandardDefs.isContainer(this.parentType)) {
                ComponentBuilder.this.log(this.child, (CompilerMessage)new NestedFlexDeclaration(NameFormatter.toDot(StandardDefs.INTERFACE_IUICOMPONENT)));
            } else {
                ComponentBuilder.this.log(this.child, (CompilerMessage)new NestedDeclaration());
            }
        }

        protected void textContent() {
            if (this.parent.getChildCount() > 1) {
                ComponentBuilder.this.log(this.child, (CompilerMessage)new MixedContent());
            } else if (ComponentBuilder.this.hasAttributeInitializers(this.parent)) {
                ComponentBuilder.this.log(this.child, (CompilerMessage)new InitializersNotAllowed());
            } else {
                ComponentBuilder.this.processTextInitializer((CDATANode)this.child);
            }
        }

        protected void languageNode() {
            if (ComponentBuilder.this.isLegalLanguageNode(this.child)) {
                this.child.analyze(ComponentBuilder.this);
            } else {
                ComponentBuilder.this.log(this.child, (CompilerMessage)new IllegalLanguageNode(this.child.image));
            }
        }

        static {
            $assertionsDisabled = !(class$flex2$compiler$mxml$builder$ComponentBuilder == null ? (class$flex2$compiler$mxml$builder$ComponentBuilder = ComponentBuilder.class$("flex2.compiler.mxml.builder.ComponentBuilder")) : class$flex2$compiler$mxml$builder$ComponentBuilder).desiredAssertionStatus();
        }
    }

    protected class ComponentAttributeHandler
    extends AttributeHandler {
        protected ComponentAttributeHandler() {
        }

        protected boolean isSpecial(String namespace, String localPart) {
            return ComponentBuilder.this.isSpecialAttribute(namespace, localPart);
        }

        protected void special(String namespace, String localPart) {
        }

        protected void event(Event event) {
            ComponentBuilder.this.processEventText(event, this.text, this.line, ComponentBuilder.this.component);
        }

        protected void property(Property property) {
            ComponentBuilder.this.processPropertyText(property, this.text, Builder.TextOrigin.FROM_ATTRIBUTE, this.line, ComponentBuilder.this.component);
        }

        protected void effect(Effect effect) {
            ComponentBuilder.this.processEffectText(effect, this.text, Builder.TextOrigin.FROM_ATTRIBUTE, this.line, ComponentBuilder.this.component);
        }

        protected void style(Style style) {
            ComponentBuilder.this.processStyleText(style, this.text, Builder.TextOrigin.FROM_ATTRIBUTE, this.line, ComponentBuilder.this.component);
        }

        protected void dynamicProperty(String name) {
            ComponentBuilder.this.processDynamicPropertyText(name, this.text, Builder.TextOrigin.FROM_ATTRIBUTE, this.line, ComponentBuilder.this.component);
        }

        protected void unknownNamespace(String namespace) {
            ComponentBuilder.this.log(this.line, new UnknownNamespace(namespace, this.text));
        }

        protected void unknown(String name) {
            ComponentBuilder.this.unknownAttributeError(name, this.line);
        }
    }
}

