/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.builder;

import flex2.compiler.CompilationUnit;
import flex2.compiler.mxml.Configuration;
import flex2.compiler.mxml.builder.ArrayBuilder;
import flex2.compiler.mxml.builder.ComponentBuilder;
import flex2.compiler.mxml.builder.InlineComponentBuilder;
import flex2.compiler.mxml.builder.ModelBuilder;
import flex2.compiler.mxml.builder.PrimitiveBuilder;
import flex2.compiler.mxml.builder.XMLBuilder;
import flex2.compiler.mxml.builder.XMLListBuilder;
import flex2.compiler.mxml.dom.AnalyzerAdapter;
import flex2.compiler.mxml.dom.ArrayNode;
import flex2.compiler.mxml.dom.CDATANode;
import flex2.compiler.mxml.dom.InlineComponentNode;
import flex2.compiler.mxml.dom.ModelNode;
import flex2.compiler.mxml.dom.Node;
import flex2.compiler.mxml.dom.PrimitiveNode;
import flex2.compiler.mxml.dom.XMLListNode;
import flex2.compiler.mxml.dom.XMLNode;
import flex2.compiler.mxml.lang.FrameworkDefs;
import flex2.compiler.mxml.lang.NodeTypeResolver;
import flex2.compiler.mxml.lang.StandardDefs;
import flex2.compiler.mxml.lang.TextParser;
import flex2.compiler.mxml.lang.TypeCompatibility;
import flex2.compiler.mxml.lang.ValueNodeHandler;
import flex2.compiler.mxml.reflect.Deprecated;
import flex2.compiler.mxml.reflect.Effect;
import flex2.compiler.mxml.reflect.Event;
import flex2.compiler.mxml.reflect.Inspectable;
import flex2.compiler.mxml.reflect.Property;
import flex2.compiler.mxml.reflect.Style;
import flex2.compiler.mxml.reflect.Type;
import flex2.compiler.mxml.reflect.TypeTable;
import flex2.compiler.mxml.rep.Array;
import flex2.compiler.mxml.rep.AtEmbed;
import flex2.compiler.mxml.rep.AtResource;
import flex2.compiler.mxml.rep.BindingExpression;
import flex2.compiler.mxml.rep.Model;
import flex2.compiler.mxml.rep.MxmlDocument;
import flex2.compiler.mxml.rep.Primitive;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.QName;
import java.util.Collection;
import java.util.Iterator;

abstract class Builder
extends AnalyzerAdapter {
    protected TypeTable typeTable;
    protected MxmlDocument document;
    protected NodeTypeResolver nodeTypeResolver;
    protected TextValueParser textParser;
    protected RValueNodeHandler rvalueNodeHandler;
    static final /* synthetic */ boolean $assertionsDisabled;

    Builder(CompilationUnit unit, TypeTable typeTable, Configuration configuration, MxmlDocument document) {
        super(unit, configuration);
        this.typeTable = typeTable;
        this.document = document;
        this.nodeTypeResolver = new NodeTypeResolver(typeTable);
        this.textParser = new TextValueParser(typeTable);
        this.rvalueNodeHandler = new RValueNodeHandler();
    }

    protected boolean processPropertyText(Property property, String text, int origin, int line, Model model) {
        String name = property.getName();
        this.ensureSingleInitializer(model, name, line);
        if (!this.checkPropertyUsage(property, text, line)) {
            return false;
        }
        int flags = (origin == TextOrigin.FROM_CHILD_CDATA ? 1 : 0) | (this.getIsColor(property) ? 4 : 0) | (origin != TextOrigin.FROM_ATTRIBUTE && property.collapseWhiteSpace() ? 2 : 0) | (this.getPercentProxy(model.getType(), property, line) != null ? 8 : 0);
        Object value = this.textParser.parseValue(text, property.getType(), this.getArrayElementType(property), flags, line, name);
        if (value != null) {
            this.postProcessBindingExpression(value, model, name);
            if (this.textParser.wasPercentage()) {
                property = this.getPercentProxy(model.getType(), property, line);
            }
            model.setProperty(property, value, line);
            return true;
        }
        return false;
    }

    protected boolean processDynamicPropertyText(String name, String text, int origin, int line, Model model) {
        this.ensureSingleInitializer(model, name, line);
        int flags = origin == TextOrigin.FROM_CHILD_CDATA ? 1 : 0;
        Object value = this.textParser.parseValue(text, this.typeTable.objectType, this.typeTable.objectType, flags, line, name);
        if (value != null) {
            this.postProcessBindingExpression(value, model, name);
            model.setDynamicProperty(this.typeTable.objectType, name, value, line);
            return true;
        }
        return false;
    }

    protected boolean getIsColor(Property property) {
        String type;
        Inspectable inspectable = property.getInspectable();
        if (inspectable != null && (type = inspectable.getFormat()) != null) {
            return type.equals("Color");
        }
        return false;
    }

    protected Property getPercentProxy(Type type, Property property, int line) {
        String percentProxyName = property.getPercentProxy();
        if (percentProxyName != null) {
            Property percentProxy = type.getProperty(percentProxyName);
            if (percentProxy != null) {
                return percentProxy;
            }
            this.log(line, (CompilerMessage)new PercentProxyWarning(percentProxyName, property.getName(), NameFormatter.toDot(type.getName())));
            return null;
        }
        return null;
    }

    private void postProcessBindingExpression(Object value, Model model, String name) {
        if (value instanceof BindingExpression) {
            BindingExpression bindingExpression = (BindingExpression)value;
            bindingExpression.setDestination(model);
            bindingExpression.setDestinationLValue(name);
            bindingExpression.setDestinationProperty(name);
        }
    }

    private void ensureSingleInitializer(Model model, String name, int line) {
        if (model.hasProperty(name)) {
            Type type = model.getType();
            Property dp = type.getDefaultProperty();
            if (dp != null && dp.getName().equals(name)) {
                this.log(line, (CompilerMessage)new MultiplePropertyInitializerWithDefaultError(name, NameFormatter.toDot(type.getName())));
            } else {
                this.log(line, (CompilerMessage)new MultiplePropertyInitializerError(name));
            }
        }
    }

    protected void processEventText(Event event, String text, int line, Model model) {
        if (text.length() > 0) {
            Type eventType = event.getType();
            if (eventType == null) {
                this.log(line, (CompilerMessage)new EventTypeUnavailable(event.getTypeName()));
                return;
            }
            this.document.addImport(NameFormatter.toDot(eventType.getName()), line);
            model.setEvent(event, text, line);
        } else {
            this.log(line, (CompilerMessage)new EventHandlerEmpty());
        }
    }

    public boolean processStyleText(Style style, String text, int origin, int line, Model model) {
        int flags;
        Object value;
        String name = style.getName();
        Type type = style.getType();
        if (model.hasStyle(name)) {
            this.log(line, (CompilerMessage)new MultipleStyleInitializerError(name));
        }
        if ((value = this.textParser.parseValue(text, type, flags = (origin == TextOrigin.FROM_CHILD_CDATA ? 1 : 0) | (this.getIsColor(style) ? 4 : 0), line, name)) != null) {
            if (value instanceof BindingExpression) {
                BindingExpression bindingExpression = (BindingExpression)value;
                bindingExpression.setDestination(model);
                bindingExpression.setDestinationLValue(name);
                bindingExpression.setDestinationStyle(name);
            }
            model.setStyle(name, value, line);
            return true;
        }
        return false;
    }

    protected boolean getIsColor(Style style) {
        String format = style.getFormat();
        return format != null && format.equals("Color");
    }

    protected boolean processEffectText(Effect effect, String text, int origin, int line, Model model) {
        int flags;
        Object value;
        String name = effect.getName();
        if (model.hasEffect(name)) {
            this.log(line, (CompilerMessage)new MultipleEffectInitializerError(name));
        }
        if ((value = this.textParser.parseValue(text, this.typeTable.stringType, flags = origin == TextOrigin.FROM_CHILD_CDATA ? 1 : 0, line, name)) != null) {
            if (value instanceof BindingExpression) {
                BindingExpression bindingExpression = (BindingExpression)value;
                bindingExpression.setDestination(model);
                bindingExpression.setDestinationStyle(name);
                bindingExpression.setDestinationLValue(name);
            } else if (FrameworkDefs.isBuiltinEffectName(text)) {
                this.document.addTypeRef("mx.effects." + text, line);
            }
            model.setEffect(name, value, this.typeTable.stringType, line);
            return true;
        }
        return false;
    }

    protected boolean processPropertyNodes(Node parent, Property property, Model model) {
        return this.processPropertyNodes(parent.getChildren(), property, model, parent.beginLine);
    }

    protected boolean processPropertyNodes(Collection nodes, Property property, Model model, int line) {
        Type arrayElementStoreType;
        Type arrayElementParseType;
        Object rvalue;
        CDATANode cdata = this.getTextContent(nodes, true);
        if (cdata != null) {
            return this.processPropertyText(property, cdata.image, TextOrigin.fromChild(cdata.inCDATA), cdata.beginLine, model);
        }
        String name = property.getName();
        this.ensureSingleInitializer(model, name, line);
        if (!this.checkPropertyUsage(property, "", ((Node)nodes.iterator().next()).beginLine)) {
            return false;
        }
        Type lvalueType = property.getType();
        if (StandardDefs.isIDeferredInstance(lvalueType)) {
            lvalueType = this.getInstanceType(property);
        }
        if ((rvalue = this.processRValueNodes(nodes, lvalueType, name, model, arrayElementParseType = StandardDefs.isIDeferredInstance(arrayElementStoreType = this.getArrayElementType(property)) ? this.getInstanceType(property) : arrayElementStoreType, arrayElementStoreType)) != null) {
            model.setProperty(property, rvalue, line);
            return true;
        }
        return false;
    }

    private Type getArrayElementType(Property property) {
        Type arrayElementStoreType;
        String arrayElementStoreTypeName = property.getArrayElementType();
        if (arrayElementStoreTypeName == null) {
            arrayElementStoreType = this.typeTable.objectType;
        } else {
            arrayElementStoreType = this.typeTable.getType(arrayElementStoreTypeName);
            if (arrayElementStoreType == null) {
                this.log(new NullArrayElementStoreType("ArrayElementType", arrayElementStoreTypeName));
                arrayElementStoreType = this.typeTable.objectType;
            }
        }
        return arrayElementStoreType;
    }

    private Type getInstanceType(Property property) {
        Type instanceType;
        String instanceTypeName = property.getInstanceType();
        if (instanceTypeName == null) {
            instanceType = this.typeTable.objectType;
        } else {
            instanceType = this.typeTable.getType(instanceTypeName);
            if (instanceType == null) {
                this.log(new NullInstanceType("InstanceType", instanceTypeName));
                instanceType = this.typeTable.objectType;
            }
        }
        return instanceType;
    }

    protected boolean processDynamicPropertyNodes(Node parent, String name, Model model) {
        Object rvalue;
        Collection nodes = parent.getChildren();
        CDATANode cdata = this.getTextContent(nodes, true);
        if (cdata != null) {
            return this.processDynamicPropertyText(name, cdata.image, TextOrigin.fromChild(cdata.inCDATA), cdata.beginLine, model);
        }
        if (model.hasProperty(name)) {
            this.log(parent, (CompilerMessage)new MultiplePropertyInitializerError(name));
        }
        if ((rvalue = this.processRValueNodes(nodes, this.typeTable.objectType, name, model)) != null) {
            model.setDynamicProperty(this.typeTable.objectType, name, rvalue, parent.beginLine);
            return true;
        }
        return false;
    }

    protected boolean processStyleNodes(Node parent, Style style, Model model) {
        Object rvalue;
        Collection nodes = parent.getChildren();
        CDATANode cdata = this.getTextContent(nodes, true);
        if (cdata != null) {
            return this.processStyleText(style, cdata.image, TextOrigin.fromChild(cdata.inCDATA), cdata.beginLine, model);
        }
        String name = style.getName();
        if (model.hasStyle(name)) {
            this.log(parent, (CompilerMessage)new MultipleStyleInitializerError(name));
        }
        if (!this.checkStyleUsage(style, "", ((Node)nodes.iterator().next()).beginLine)) {
            return false;
        }
        Type lvalueType = style.getType();
        if (StandardDefs.isIDeferredInstance(lvalueType)) {
            lvalueType = this.typeTable.objectType;
        }
        if ((rvalue = this.processRValueNodes(nodes, lvalueType, name, model)) != null) {
            model.setStyle(name, rvalue, parent.beginLine);
            return true;
        }
        return false;
    }

    protected boolean processEffectNodes(Node parent, Effect effect, Model model) {
        Type effectBaseType;
        Object rvalue;
        Collection nodes = parent.getChildren();
        CDATANode cdata = this.getTextContent(nodes, true);
        if (cdata != null) {
            return this.processEffectText(effect, cdata.image, TextOrigin.fromChild(cdata.inCDATA), cdata.beginLine, model);
        }
        String name = effect.getName();
        if (model.hasEffect(name)) {
            this.log(parent, (CompilerMessage)new MultipleEffectInitializerError(name));
        }
        if ((rvalue = this.processRValueNodes(nodes, effectBaseType = this.typeTable.getType(StandardDefs.CLASS_EFFECT), name, model)) != null) {
            model.setEffect(name, rvalue, effectBaseType, parent.beginLine);
            return true;
        }
        return false;
    }

    protected Object processRValueNodes(Collection nodes, Type type, String name, Model model) {
        return this.processRValueNodes(nodes, type, name, model, this.typeTable.objectType, this.typeTable.objectType);
    }

    protected Object processRValueNodes(Collection nodes, Type type, String name, Model model, Type arrayElementParseType, Type arrayElementStoreType) {
        switch (this.checkTypeCompatibility(nodes, type, arrayElementParseType, name)) {
            case 0: {
                return this.rvalueNodeHandler.process((Node)nodes.iterator().next(), name, model, arrayElementStoreType);
            }
            case 1: {
                ArrayBuilder arrayBuilder = new ArrayBuilder(this.unit, this.typeTable, this.configuration, this.document, model, name, false, arrayElementStoreType);
                arrayBuilder.createSyntheticArrayModel(((Node)nodes.iterator().next()).beginLine);
                arrayBuilder.processChildren(nodes);
                return arrayBuilder.array;
            }
        }
        return null;
    }

    protected final Model instanceFromClass(String className, int line, boolean checkClass) {
        Type classType;
        if (checkClass && (classType = this.typeTable.getType(NameFormatter.toColon(className))) == null) {
            this.log(line, (CompilerMessage)new ClassNotAvailable(className));
        }
        return new Primitive(this.document, this.typeTable.classType, className, line);
    }

    protected final Model factoryFromClass(String className, int line) {
        Type classFactoryType = this.typeTable.getType(StandardDefs.CLASS_CLASSFACTORY);
        if (classFactoryType == null) {
            this.log(line, (CompilerMessage)new TypeNotAvailable(StandardDefs.CLASS_CLASSFACTORY));
            return new Model(this.document, this.typeTable.objectType, line);
        }
        Model model = new Model(this.document, classFactoryType, line);
        model.setProperty("generator", new Primitive(this.document, this.typeTable.classType, className, line));
        Type classType = this.typeTable.getType(NameFormatter.toColon(className));
        if (classType != null) {
            Model propObject = null;
            Property outerDocumentProperty = classType.getProperty("outerDocument");
            if (outerDocumentProperty != null) {
                String qualName = this.document.getQName().toString();
                Type selfType = this.typeTable.getType(qualName);
                if (!$assertionsDisabled && selfType == null) {
                    throw new AssertionError((Object)("skeleton type for class '" + NameFormatter.toDot(qualName) + "' not available"));
                }
                if (selfType.isAssignableTo(outerDocumentProperty.getType())) {
                    propObject = new Model(this.document, this.typeTable.objectType, line);
                    propObject.setProperty(outerDocumentProperty, (Object)new Primitive(this.document, this.typeTable.classType, "this", line), line);
                }
            }
            if (propObject != null) {
                model.setProperty("properties", propObject);
            }
        }
        return model;
    }

    protected int checkTypeCompatibility(Collection nodes, Type lvalueType, Type lvalueArrayElemType, String lvalueDesc) {
        switch (nodes.size()) {
            case 0: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return 2;
            }
            case 1: {
                return this.checkTypeCompatibility((Node)nodes.iterator().next(), lvalueType, lvalueArrayElemType, lvalueDesc, true);
            }
        }
        int compat = 0;
        Iterator iter = nodes.iterator();
        while (iter.hasNext() && ((compat = this.checkTypeCompatibility((Node)iter.next(), lvalueType, lvalueArrayElemType, lvalueDesc, false)) == 0 || compat == 1)) {
        }
        return compat;
    }

    protected int checkTypeCompatibility(Node node, Type lvalueType, Type lvalueArrayElemType, String lvalueDesc, boolean rvalueIsSingleton) {
        Type rtype = this.nodeTypeResolver.resolveType(node);
        if (!$assertionsDisabled && rtype == null) {
            throw new AssertionError();
        }
        int compat = TypeCompatibility.check(lvalueType, lvalueArrayElemType, rtype, rvalueIsSingleton);
        switch (compat) {
            case 0: 
            case 1: {
                return compat;
            }
            case 2: {
                this.log(node.beginLine, (CompilerMessage)new TypeNotAssignableToLType(lvalueDesc, NameFormatter.toDot(rtype.getName()), NameFormatter.toDot(lvalueType.getName())));
                return compat;
            }
            case 3: {
                this.log(node.beginLine, (CompilerMessage)new TypeNotMultiple(lvalueDesc, NameFormatter.toDot(lvalueType.getName())));
                return compat;
            }
            case 4: {
                this.log(node.beginLine, (CompilerMessage)new SingleRValueNotArrayOrArrayElem(lvalueDesc, NameFormatter.toDot(rtype.getName()), NameFormatter.toDot(lvalueType.getName()), NameFormatter.toDot(lvalueArrayElemType.getName())));
                return compat;
            }
            case 5: {
                this.log(node.beginLine, (CompilerMessage)new MultiRValueNotArrayElem(lvalueDesc, NameFormatter.toDot(rtype.getName()), NameFormatter.toDot(lvalueArrayElemType.getName())));
                return compat;
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return compat;
    }

    protected boolean checkPropertyUsage(Property property, String text, int line) {
        if (!this.isAllowedProperty(property)) {
            this.log(line, (CompilerMessage)new InitializerNotAllowed(property.getName()));
            return false;
        }
        this.checkDeprecation(property, line);
        Inspectable inspectable = property.getInspectable();
        if (inspectable != null) {
            this.checkImageType(inspectable.getFormat(), text, line);
            if (!TextParser.isBindingExpression(text) && !this.checkEnumeration(inspectable.getEnumeration(), text, line)) {
                return false;
            }
        }
        if (property.readOnly()) {
            this.log(line, (CompilerMessage)new PropertyReadOnly(property.getName()));
            return false;
        }
        if (property.getType() == null) {
            this.log(line, (CompilerMessage)new PropertyUnreachable(property.getName()));
            return false;
        }
        return true;
    }

    protected boolean isAllowedProperty(Property property) {
        return true;
    }

    protected boolean checkStyleUsage(Style style, String text, int line) {
        this.checkImageType(style.getFormat(), text, line);
        if (!this.checkEnumeration(style.getEnumeration(), text, line)) {
            return false;
        }
        if (style.getType() == null) {
            this.log(line, (CompilerMessage)new StyleUnreachable(style.getName()));
            return false;
        }
        return true;
    }

    protected boolean checkEnumeration(String[] enums, String value, int line) {
        if (enums != null) {
            int count = enums.length;
            for (int j = 0; j < count; ++j) {
                if (!enums[j].equals(value)) continue;
                return true;
            }
            StringBuffer buffer = new StringBuffer();
            int count2 = enums.length;
            for (int j = 0; j < count2; ++j) {
                buffer.append(enums[j]);
                if (j >= count2 - 1) continue;
                buffer.append(", ");
            }
            this.log(line, (CompilerMessage)new InvalidEnumerationValue(value, buffer.toString()));
            return false;
        }
        return true;
    }

    protected boolean checkImageType(String format, String value, int line) {
        if ("File".equals(format) && value.endsWith(".svg")) {
            this.log(line, (CompilerMessage)new RuntimeSVGNotSupported());
            return false;
        }
        return true;
    }

    protected boolean checkDeprecation(Property property, int line) {
        Deprecated deprecated = property.getDeprecated();
        if (deprecated != null && this.configuration.showDeprecationWarnings()) {
            String replacement = deprecated.getReplacement() != null ? deprecated.getReplacement() : deprecated.getMessage();
            this.log(line, (CompilerMessage)new PropertyDeprecated(property.getName(), replacement));
            return false;
        }
        return true;
    }

    protected boolean checkNonEmpty(Node node, Type type) {
        if (node.getChildren().isEmpty()) {
            if (!this.allowEmptyDefault(type)) {
                this.log(node.beginLine, (CompilerMessage)new EmptyChildInitializer(NameFormatter.toDot(type.getName())));
            }
            return false;
        }
        return true;
    }

    protected boolean allowEmptyDefault(Type type) {
        return this.typeTable.stringType.isAssignableTo(type);
    }

    protected boolean hasAttributeInitializers(Node node) {
        Iterator iter = node.getAttributeNames();
        while (iter.hasNext()) {
            QName qname = (QName)iter.next();
            if (this.isSpecialAttribute(qname.getNamespace(), qname.getLocalPart())) continue;
            return true;
        }
        return false;
    }

    protected boolean isSpecialAttribute(String namespaceURI, String localPart) {
        return false;
    }

    protected void registerModel(Node node, Model model, boolean topLevel) {
        this.registerModel((String)node.getAttribute("id"), model, topLevel);
    }

    protected void registerModel(String id, Model model, boolean topLevel) {
        if (id != null) {
            model.setId(id);
            this.document.addDeclaration(model, topLevel);
        } else if (topLevel) {
            this.document.addDeclaration(model, true);
        }
    }

    static {
        $assertionsDisabled = !Builder.class.desiredAssertionStatus();
    }

    public static class EmptyChildInitializer
    extends CompilerMessage.CompilerError {
        public String type;

        public EmptyChildInitializer(String type) {
            this.type = type;
        }
    }

    public static class PropertyDeprecated
    extends CompilerMessage.CompilerWarning {
        public String name;
        public String replacement;

        public PropertyDeprecated(String name, String replacement) {
            this.name = name;
            this.replacement = replacement;
        }
    }

    public static class RuntimeSVGNotSupported
    extends CompilerMessage.CompilerWarning {
    }

    public static class InvalidEnumerationValue
    extends CompilerMessage.CompilerError {
        public String value;
        public String values;

        public InvalidEnumerationValue(String value, String values) {
            this.value = value;
            this.values = values;
        }
    }

    public static class StyleUnreachable
    extends CompilerMessage.CompilerError {
        public String name;

        public StyleUnreachable(String name) {
            this.name = name;
        }
    }

    public static class PropertyUnreachable
    extends CompilerMessage.CompilerError {
        public String name;

        public PropertyUnreachable(String name) {
            this.name = name;
        }
    }

    public static class PropertyReadOnly
    extends CompilerMessage.CompilerError {
        public String name;

        public PropertyReadOnly(String name) {
            this.name = name;
        }
    }

    public static class InitializerNotAllowed
    extends CompilerMessage.CompilerError {
        public String name;

        public InitializerNotAllowed(String name) {
            this.name = name;
        }
    }

    public static class MultiRValueNotArrayElem
    extends CompilerMessage.CompilerError {
        public String lvalue;
        public String type;
        public String targetElememtType;

        public MultiRValueNotArrayElem(String lvalue, String type, String targetElememtType) {
            this.lvalue = lvalue;
            this.type = type;
            this.targetElememtType = targetElememtType;
        }
    }

    public static class SingleRValueNotArrayOrArrayElem
    extends CompilerMessage.CompilerError {
        public String lvalue;
        public String type;
        public String targetType;
        public String targetElememtType;

        public SingleRValueNotArrayOrArrayElem(String lvalue, String type, String targetType, String targetElememtType) {
            this.lvalue = lvalue;
            this.type = type;
            this.targetType = targetType;
            this.targetElememtType = targetElememtType;
        }
    }

    public static class TypeNotMultiple
    extends CompilerMessage.CompilerError {
        public String lvalue;
        public String targetType;

        public TypeNotMultiple(String lvalue, String targetType) {
            this.lvalue = lvalue;
            this.targetType = targetType;
        }
    }

    public static class TypeNotAssignableToLType
    extends CompilerMessage.CompilerError {
        public String lvalue;
        public String type;
        public String targetType;

        public TypeNotAssignableToLType(String lvalue, String type, String targetType) {
            this.lvalue = lvalue;
            this.type = type;
            this.targetType = targetType;
        }
    }

    public static class TypeNotAvailable
    extends CompilerMessage.CompilerError {
        public String type;

        public TypeNotAvailable(String type) {
            this.type = type;
        }
    }

    public static class ClassNotAvailable
    extends CompilerMessage.CompilerError {
        public String className;

        public ClassNotAvailable(String className) {
            this.className = className;
        }
    }

    public static class NullInstanceType
    extends CompilerMessage.CompilerWarning {
        public String instanceType;
        public String instanceTypeName;

        public NullInstanceType(String instanceType, String instanceTypeName) {
            this.instanceType = instanceType;
            this.instanceTypeName = instanceTypeName;
        }
    }

    public static class NullArrayElementStoreType
    extends CompilerMessage.CompilerWarning {
        public String arrayElementType;
        public String arrayElementStoreTypeName;

        public NullArrayElementStoreType(String arrayElementType, String arrayElementStoreTypeName) {
            this.arrayElementType = arrayElementType;
            this.arrayElementStoreTypeName = arrayElementStoreTypeName;
        }
    }

    public static class MultipleEffectInitializerError
    extends CompilerMessage.CompilerError {
        public String name;

        public MultipleEffectInitializerError(String name) {
            this.name = name;
        }
    }

    public static class MultipleStyleInitializerError
    extends CompilerMessage.CompilerError {
        public String name;

        public MultipleStyleInitializerError(String name) {
            this.name = name;
        }
    }

    public static class EventHandlerEmpty
    extends CompilerMessage.CompilerWarning {
    }

    public static class EventTypeUnavailable
    extends CompilerMessage.CompilerError {
        public String type;

        public EventTypeUnavailable(String type) {
            this.type = type;
        }
    }

    public static class MultiplePropertyInitializerWithDefaultError
    extends CompilerMessage.CompilerError {
        public String name;
        public String type;

        public MultiplePropertyInitializerWithDefaultError(String name, String type) {
            this.name = name;
            this.type = type;
        }
    }

    public static class MultiplePropertyInitializerError
    extends CompilerMessage.CompilerError {
        public String name;

        public MultiplePropertyInitializerError(String name) {
            this.name = name;
        }
    }

    public static class PercentProxyWarning
    extends CompilerMessage.CompilerWarning {
        public String proxyName;
        public String property;
        public String type;

        public PercentProxyWarning(String proxyName, String property, String type) {
            this.proxyName = proxyName;
            this.property = property;
            this.type = type;
        }
    }

    public static class UnrecognizedAtFunction
    extends CompilerMessage.CompilerError {
        public String desc;

        public UnrecognizedAtFunction(String desc) {
            this.desc = desc;
        }
    }

    public static class PercentagesNotAllowed
    extends CompilerMessage.CompilerError {
        public String desc;

        public PercentagesNotAllowed(String desc) {
            this.desc = desc;
        }
    }

    public static class TypeNotSerializable
    extends CompilerMessage.CompilerError {
        public String desc;
        public String type;

        public TypeNotSerializable(String desc, String type) {
            this.desc = desc;
            this.type = type;
        }
    }

    public static class InvalidPercentage
    extends CompilerMessage.CompilerError {
        public String desc;
        public String text;

        public InvalidPercentage(String desc, String text) {
            this.desc = desc;
            this.text = text;
        }
    }

    public static class InvalidTextForType
    extends CompilerMessage.CompilerError {
        public String desc;
        public String type;
        public String array;
        public String text;

        public InvalidTextForType(String desc, String type, String array, String text) {
            this.desc = desc;
            this.type = type;
            this.array = array;
            this.text = text;
        }
    }

    public static class TypeNotEmbeddable
    extends CompilerMessage.CompilerError {
        public String desc;
        public String type;

        public TypeNotEmbeddable(String desc, String type) {
            this.desc = desc;
            this.type = type;
        }
    }

    public static class UndefinedContextRoot
    extends CompilerMessage.CompilerError {
    }

    public static class TypeNotContextRootable
    extends CompilerMessage.CompilerError {
        public String desc;
        public String type;

        public TypeNotContextRootable(String desc, String type) {
            this.desc = desc;
            this.type = type;
        }
    }

    public static class BindingNotAllowed
    extends CompilerMessage.CompilerError {
    }

    protected class RValueNodeHandler
    extends ValueNodeHandler {
        protected String lvalueName;
        protected Model model;
        protected Type arrayElementType;
        protected Object result;
        static final /* synthetic */ boolean $assertionsDisabled;

        protected RValueNodeHandler() {
        }

        protected Object process(Node node, String lvalueName, Model model, Type arrayElementType) {
            this.lvalueName = lvalueName;
            this.model = model;
            this.arrayElementType = arrayElementType;
            this.invoke(node);
            return this.result;
        }

        protected void componentNode(Node node) {
            ComponentBuilder builder = new ComponentBuilder(Builder.this.unit, Builder.this.typeTable, Builder.this.configuration, Builder.this.document, this.model, false, null);
            node.analyze(builder);
            builder.component.setParentIndex(this.lvalueName);
            this.result = builder.component;
        }

        protected void arrayNode(ArrayNode node) {
            ArrayBuilder builder = new ArrayBuilder(Builder.this.unit, Builder.this.typeTable, Builder.this.configuration, Builder.this.document, this.model, this.lvalueName, false, this.arrayElementType);
            node.analyze(builder);
            this.result = builder.array;
        }

        protected void primitiveNode(PrimitiveNode node) {
            PrimitiveBuilder builder = new PrimitiveBuilder(Builder.this.unit, Builder.this.typeTable, Builder.this.configuration, Builder.this.document, false, null);
            node.analyze(builder);
            this.result = builder.value;
        }

        protected void xmlNode(XMLNode node) {
            XMLBuilder builder = new XMLBuilder(Builder.this.unit, Builder.this.typeTable, Builder.this.configuration, Builder.this.document, this.model);
            node.analyze(builder);
            builder.xml.setParentIndex(this.lvalueName);
            this.result = builder.xml;
        }

        protected void xmlListNode(XMLListNode node) {
            XMLListBuilder builder = new XMLListBuilder(Builder.this.unit, Builder.this.typeTable, Builder.this.configuration, Builder.this.document, this.model);
            node.analyze(builder);
            builder.xmlList.setParentIndex(this.lvalueName);
            this.result = builder.xmlList;
        }

        protected void modelNode(ModelNode node) {
            ModelBuilder builder = new ModelBuilder(Builder.this.unit, Builder.this.typeTable, Builder.this.configuration, Builder.this.document);
            node.analyze(builder);
            this.result = builder.graph;
        }

        protected void inlineComponentNode(InlineComponentNode node) {
            InlineComponentBuilder builder = new InlineComponentBuilder(Builder.this.unit, Builder.this.typeTable, Builder.this.configuration, Builder.this.document, false);
            node.analyze(builder);
            this.result = builder.getRValue();
        }

        protected void unknown(Node node) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)("Unexpected node class in processRValueNode: " + node.getClass()));
            }
            this.result = null;
        }

        static {
            $assertionsDisabled = !(class$flex2$compiler$mxml$builder$Builder == null ? (class$flex2$compiler$mxml$builder$Builder = Builder.class$("flex2.compiler.mxml.builder.Builder")) : class$flex2$compiler$mxml$builder$Builder).desiredAssertionStatus();
        }
    }

    public static class TextOrigin {
        public static int FROM_ATTRIBUTE = 0;
        public static int FROM_CHILD_TEXT = 1;
        public static int FROM_CHILD_CDATA = 2;

        public static int fromChild(boolean cdata) {
            return cdata ? FROM_CHILD_CDATA : FROM_CHILD_TEXT;
        }
    }

    protected class TextValueParser
    extends TextParser {
        protected String lvalueName;
        protected int line;
        protected String desc;
        protected boolean wasPercentage;
        static final /* synthetic */ boolean $assertionsDisabled;

        TextValueParser(TypeTable typeTable) {
            super(typeTable);
        }

        public Object parseValue(String text, Type type, int flags, int line, String desc) {
            return this.parseValue(text, type, Builder.this.typeTable.objectType, flags, line, desc);
        }

        public Object parseValue(String text, Type type, Type arrayElementType, int flags, int line, String desc) {
            this.line = line;
            this.desc = desc;
            this.wasPercentage = false;
            return super.parse(text, type, arrayElementType, flags);
        }

        protected Object parse(String text, Type type, Type arrayElementType, int flags) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"internal parse() called");
            }
            return null;
        }

        public boolean wasPercentage() {
            return this.wasPercentage;
        }

        public String contextRoot(String text) {
            String contextRoot = Builder.this.configuration.getContextRoot();
            if (contextRoot == null) {
                this.error(8, text, null, null);
                return null;
            }
            return text.replaceAll("@ContextRoot\\(\\)", contextRoot);
        }

        public Object embed(String text, Type type) {
            boolean strType = type.isAssignableTo(Builder.this.typeTable.stringType);
            AtEmbed atEmbed = AtEmbed.create(Builder.this.typeTable, Builder.this.unit.getSource(), this.line, text, strType);
            if (atEmbed != null) {
                Builder.this.document.addAtEmbed(atEmbed);
                if (StandardDefs.isIFactory(type)) {
                    return Builder.this.factoryFromClass(atEmbed.getPropName(), this.line);
                }
                if (StandardDefs.isIDeferredInstance(type)) {
                    return Builder.this.instanceFromClass(atEmbed.getPropName(), this.line, false);
                }
                return atEmbed;
            }
            return null;
        }

        public Object resource(String text, Type type) {
            AtResource atResource = AtResource.create(Builder.this.typeTable, Builder.this.unit.getSource(), this.line, text, type);
            if (atResource != null) {
                Builder.this.document.addAtResource(atResource.getPropertyName(), atResource, atResource.getXmlLineNumber());
                return atResource;
            }
            return null;
        }

        public Object bindingExpression(String converted) {
            return new BindingExpression(converted, this.line, Builder.this.document);
        }

        public Object percentage(String pct) {
            this.wasPercentage = true;
            return Double.valueOf(pct.substring(0, pct.indexOf(37)));
        }

        public Object array(Collection entries, Type arrayElementType) {
            Array array = new Array(Builder.this.document, arrayElementType, this.line);
            array.addEntries(entries, this.line);
            return array;
        }

        public Object functionText(String text) {
            return text;
        }

        public Object className(String name, Type lvalueType) {
            Builder.this.document.addImport(name, this.line);
            if (StandardDefs.isIFactory(lvalueType)) {
                return Builder.this.factoryFromClass(name, this.line);
            }
            if (StandardDefs.isIDeferredInstance(lvalueType)) {
                return Builder.this.instanceFromClass(name, this.line, true);
            }
            if (!$assertionsDisabled && !lvalueType.equals(Builder.this.typeTable.classType)) {
                throw new AssertionError();
            }
            return name;
        }

        public void error(int err, String text, Type type, Type arrayElementType) {
            switch (err) {
                case 6: {
                    Builder.this.log(this.line, new TypeNotContextRootable(this.desc, NameFormatter.toDot(type.getName())));
                    break;
                }
                case 8: {
                    Builder.this.log(this.line, new UndefinedContextRoot());
                    break;
                }
                case 1: {
                    Builder.this.log(this.line, new TypeNotEmbeddable(this.desc, NameFormatter.toDot(type.getName())));
                    break;
                }
                case 2: {
                    Builder.this.log(this.line, new InvalidTextForType(this.desc, NameFormatter.toDot(type.getName()), type.equals(Builder.this.typeTable.arrayType) ? "[" + NameFormatter.toDot(arrayElementType.getName()) + "]" : "", text));
                    break;
                }
                case 3: {
                    Builder.this.log(this.line, new InvalidPercentage(this.desc, text));
                    break;
                }
                case 4: {
                    Builder.this.log(this.line, new TypeNotSerializable(this.desc, NameFormatter.toDot(type.getName())));
                    break;
                }
                case 5: {
                    Builder.this.log(this.line, new PercentagesNotAllowed(this.desc));
                    break;
                }
                case 7: {
                    Builder.this.log(this.line, new UnrecognizedAtFunction(this.desc));
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)("unhandled text parse error, code = " + err));
                    }
                    break;
                }
            }
        }

        static {
            $assertionsDisabled = !(class$flex2$compiler$mxml$builder$Builder == null ? (class$flex2$compiler$mxml$builder$Builder = Builder.class$("flex2.compiler.mxml.builder.Builder")) : class$flex2$compiler$mxml$builder$Builder).desiredAssertionStatus();
        }
    }
}

