/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml;

import flex2.compiler.CompilationUnit;
import flex2.compiler.Compiler;
import flex2.compiler.Logger;
import flex2.compiler.Source;
import flex2.compiler.SymbolTable;
import flex2.compiler.Transcoder;
import flex2.compiler.as3.EmbedExtension;
import flex2.compiler.as3.StyleExtension;
import flex2.compiler.as3.binding.BindableExtension;
import flex2.compiler.as3.binding.DataBindingExtension;
import flex2.compiler.as3.managed.ManagedExtensionError;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.TextFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.mxml.Configuration;
import flex2.compiler.mxml.LogAdapter;
import flex2.compiler.mxml.SourceCodeBuffer;
import flex2.compiler.mxml.builder.ApplicationBuilder;
import flex2.compiler.mxml.dom.AnalyzerAdapter;
import flex2.compiler.mxml.dom.ApplicationNode;
import flex2.compiler.mxml.dom.Node;
import flex2.compiler.mxml.gen.VelocityUtil;
import flex2.compiler.mxml.reflect.TypeTable;
import flex2.compiler.mxml.rep.DocumentInfo;
import flex2.compiler.mxml.rep.MxmlDocument;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.DualModeLineNumberMap;
import flex2.compiler.util.LineNumberMap;
import flex2.compiler.util.NameMappings;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.compiler.util.VelocityException;
import flex2.compiler.util.VelocityManager;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

class ImplementationCompiler
implements Compiler {
    private static final String DOC_KEY = "doc";
    private static final String CLASSDEF_TEMPLATE_PATH = "flex2/compiler/mxml/gen/";
    private static final String CLASSDEF_TEMPLATE = "flex2/compiler/mxml/gen/ClassDef.vm";
    private static final String CLASSDEF_LIB = "flex2/compiler/mxml/gen/ClassDefLib.vm";
    private Configuration mxmlConfiguration;
    private NameMappings nameMappings;
    private String[] mimeTypes;
    private flex2.compiler.as3.Compiler asc;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ImplementationCompiler(Configuration mxmlConfiguration, flex2.compiler.as3.Configuration ascConfiguration, NameMappings mappings, Transcoder[] transcoders) {
        this.mxmlConfiguration = mxmlConfiguration;
        this.nameMappings = mappings;
        this.mimeTypes = new String[]{"text/mxml"};
        this.asc = new flex2.compiler.as3.Compiler(ascConfiguration);
        String gendir = mxmlConfiguration.keepGeneratedActionScript() ? mxmlConfiguration.getGeneratedDirectory() : null;
        this.asc.addCompilerExtension(new EmbedExtension(transcoders, gendir));
        this.asc.addCompilerExtension(new StyleExtension());
        this.asc.addCompilerExtension(new BindableExtension(gendir));
        this.asc.addCompilerExtension(new DataBindingExtension(gendir, mxmlConfiguration.showBindingWarnings()));
        this.asc.addCompilerExtension(new ManagedExtensionError());
    }

    flex2.compiler.as3.Compiler getASCompiler() {
        return this.asc;
    }

    public boolean isSupported(String mimeType) {
        return this.mimeTypes[0].equals(mimeType);
    }

    public String[] getSupportedMimeTypes() {
        return this.mimeTypes;
    }

    public Source preprocess(Source source) {
        return source;
    }

    public CompilationUnit parse1(Source source, SymbolTable symbolTable) {
        CompilationUnit unit;
        TypeTable typeTable = (TypeTable)symbolTable.getContext().getAttribute(flex2.compiler.mxml.Compiler.TYPE_TABLE);
        if (typeTable == null) {
            typeTable = new TypeTable(symbolTable, this.nameMappings);
            symbolTable.getContext().setAttribute(flex2.compiler.mxml.Compiler.TYPE_TABLE, typeTable);
        }
        if (this.hasUnresolvedNodes(unit = source.getCompilationUnit())) {
            return null;
        }
        ApplicationNode app = (ApplicationNode)unit.getSyntaxTree();
        if (!$assertionsDisabled && app == null) {
            throw new AssertionError();
        }
        DocumentInfo info = (DocumentInfo)unit.getContext().removeAttribute("DocumentInfo");
        if (!$assertionsDisabled && info == null) {
            throw new AssertionError();
        }
        MxmlDocument document = new MxmlDocument(unit, typeTable, info, this.mxmlConfiguration);
        ApplicationBuilder builder = new ApplicationBuilder(unit, typeTable, this.mxmlConfiguration, document);
        app.analyze(builder);
        VirtualFile genFile = this.generateImplementation(document);
        DualModeLineNumberMap lineMap = document.getLineNumberMap();
        document.getStylesContainer().setMxmlDocument(null);
        document = null;
        unit.setSyntaxTree(null);
        if (genFile == null || ThreadLocalToolkit.errorCount() != 0) {
            return null;
        }
        Source genSource = new Source(genFile, unit.getSource());
        genSource.addFileIncludes(unit.getSource());
        Logger original = ThreadLocalToolkit.getLogger();
        LogAdapter adapter = new LogAdapter(original, lineMap);
        ThreadLocalToolkit.setLogger(adapter);
        CompilationUnit ascUnit = this.asc.parse1(genSource, symbolTable);
        if (ThreadLocalToolkit.errorCount() > 0) {
            ThreadLocalToolkit.setLogger(original);
            return null;
        }
        ThreadLocalToolkit.setLogger(original);
        unit.getContext().setAttribute("DelegateUnit", ascUnit);
        unit.getContext().setAttribute("LineNumberMap", lineMap);
        ascUnit.getContext().setAttribute("LineNumberMap", lineMap);
        List bindingExpressions = (List)unit.getContext().getAttribute("BindingExpressions");
        ascUnit.getContext().setAttribute("BindingExpressions", bindingExpressions);
        unit.getSource().addFileIncludes(ascUnit.getSource());
        Source.transferMetaData(ascUnit, unit);
        Source.transferAssets(ascUnit, unit);
        Source.transferGeneratedSources(ascUnit, unit);
        Source.transferDefinitions(ascUnit, unit);
        Source.transferInheritance(ascUnit, unit);
        return unit;
    }

    public void parse2(CompilationUnit unit, SymbolTable symbolTable) {
        CompilationUnit ascUnit = (CompilationUnit)unit.getContext().getAttribute("DelegateUnit");
        Source.transferInheritance(unit, ascUnit);
        Logger original = ThreadLocalToolkit.getLogger();
        LineNumberMap map = (LineNumberMap)unit.getContext().getAttribute("LineNumberMap");
        LogAdapter adapter = new LogAdapter(original, map);
        ThreadLocalToolkit.setLogger(adapter);
        this.asc.parse2(ascUnit, symbolTable);
        ThreadLocalToolkit.setLogger(original);
    }

    public void analyze1(CompilationUnit unit, SymbolTable symbolTable) {
        CompilationUnit ascUnit = (CompilationUnit)unit.getContext().getAttribute("DelegateUnit");
        Logger original = ThreadLocalToolkit.getLogger();
        LineNumberMap map = (LineNumberMap)unit.getContext().getAttribute("LineNumberMap");
        LogAdapter adapter = new LogAdapter(original, map);
        ThreadLocalToolkit.setLogger(adapter);
        this.asc.analyze1(ascUnit, symbolTable);
        ThreadLocalToolkit.setLogger(original);
        Source.transferTypeInfo(ascUnit, unit);
        Source.transferNamespaces(ascUnit, unit);
    }

    public void analyze2(CompilationUnit unit, SymbolTable symbolTable) {
        CompilationUnit ascUnit = (CompilationUnit)unit.getContext().getAttribute("DelegateUnit");
        Source.transferDependencies(unit, ascUnit);
        Logger original = ThreadLocalToolkit.getLogger();
        LineNumberMap map = (LineNumberMap)unit.getContext().getAttribute("LineNumberMap");
        LogAdapter adapter = new LogAdapter(original, map);
        ThreadLocalToolkit.setLogger(adapter);
        this.asc.analyze2(ascUnit, symbolTable);
        ThreadLocalToolkit.setLogger(original);
        Source.transferDependencies(ascUnit, unit);
    }

    public void analyze3(CompilationUnit unit, SymbolTable symbolTable) {
        CompilationUnit ascUnit = (CompilationUnit)unit.getContext().getAttribute("DelegateUnit");
        Source.transferDependencies(unit, ascUnit);
        Logger original = ThreadLocalToolkit.getLogger();
        LineNumberMap map = (LineNumberMap)unit.getContext().getAttribute("LineNumberMap");
        LogAdapter adapter = new LogAdapter(original, map);
        ThreadLocalToolkit.setLogger(adapter);
        this.asc.analyze3(ascUnit, symbolTable);
        ThreadLocalToolkit.setLogger(original);
    }

    public void analyze4(CompilationUnit unit, SymbolTable symbolTable) {
        CompilationUnit ascUnit = (CompilationUnit)unit.getContext().getAttribute("DelegateUnit");
        Logger original = ThreadLocalToolkit.getLogger();
        LineNumberMap map = (LineNumberMap)unit.getContext().getAttribute("LineNumberMap");
        LogAdapter adapter = new LogAdapter(original, map);
        adapter.setRenamedVariableMap((Map)ascUnit.getContext().getAttribute("RenamedVariableMap"));
        ThreadLocalToolkit.setLogger(adapter);
        this.asc.analyze4(ascUnit, symbolTable);
        if (ThreadLocalToolkit.errorCount() > 0) {
            ThreadLocalToolkit.setLogger(original);
            return;
        }
        ThreadLocalToolkit.setLogger(original);
        Source.transferExpressions(ascUnit, unit);
        Source.transferMetaData(ascUnit, unit);
        Source.transferLoaderClassBase(ascUnit, unit);
        Source.transferClassTable(ascUnit, unit);
        Source.transferStyles(ascUnit, unit);
        unit.getContext().setAttribute("DataBindingExtension", ascUnit.getContext().getAttribute("DataBindingExtension"));
    }

    public void generate(CompilationUnit unit, SymbolTable symbolTable) {
        CompilationUnit ascUnit = (CompilationUnit)unit.getContext().getAttribute("DelegateUnit");
        Logger original = ThreadLocalToolkit.getLogger();
        DualModeLineNumberMap map = (DualModeLineNumberMap)unit.getContext().getAttribute("LineNumberMap");
        map.flushTemp();
        LogAdapter adapter = new LogAdapter(original, map);
        ThreadLocalToolkit.setLogger(adapter);
        this.asc.generate(ascUnit, symbolTable);
        if (ThreadLocalToolkit.errorCount() > 0) {
            ThreadLocalToolkit.setLogger(original);
            return;
        }
        ThreadLocalToolkit.setLogger(original);
        Source.transferGeneratedSources(ascUnit, unit);
        Source.transferBytecodes(ascUnit, unit);
    }

    public void postprocess(CompilationUnit unit, SymbolTable symbolTable) {
    }

    private boolean hasUnresolvedNodes(CompilationUnit unit) {
        Set checkNodes = (Set)unit.getContext().removeAttribute("CheckNodes");
        if (checkNodes != null && !checkNodes.isEmpty()) {
            Iterator iter = checkNodes.iterator();
            while (iter.hasNext()) {
                Node node = (Node)iter.next();
                ThreadLocalToolkit.log((CompilerMessage)new AnalyzerAdapter.CouldNotResolveToComponent(node.image), unit.getSource());
            }
        }
        return ThreadLocalToolkit.errorCount() > 0;
    }

    private final VirtualFile generateImplementation(MxmlDocument doc) {
        Template template = VelocityManager.getTemplate(CLASSDEF_TEMPLATE, CLASSDEF_LIB);
        if (template == null) {
            ThreadLocalToolkit.log(new UnableToLoadTemplate(CLASSDEF_TEMPLATE));
            return null;
        }
        String genFileName = flex2.compiler.mxml.Compiler.getGeneratedName(this.mxmlConfiguration, doc.getPackageName(), doc.getClassName(), "-generated.as");
        Source source = doc.getCompilationUnit().getSource();
        SourceCodeBuffer out = new SourceCodeBuffer((int)(source.size() * 4L));
        try {
            DualModeLineNumberMap lineMap = new DualModeLineNumberMap(source.getNameForReporting(), genFileName);
            doc.setLineNumberMap(lineMap);
            VelocityUtil util = new VelocityUtil(CLASSDEF_TEMPLATE_PATH, this.mxmlConfiguration.debug(), out, lineMap);
            VelocityContext vc = VelocityManager.getCodeGenContext(util);
            vc.put(DOC_KEY, (Object)doc);
            template.merge((Context)vc, (Writer)out);
        }
        catch (Exception e) {
            ThreadLocalToolkit.log(new CodeGenerationException(doc.getSourcePath(), e.getLocalizedMessage()));
            return null;
        }
        if (out.getBuffer() != null) {
            String code = out.toString();
            if (this.mxmlConfiguration.keepGeneratedActionScript()) {
                try {
                    FileUtil.writeFile(genFileName, code);
                }
                catch (IOException e) {
                    ThreadLocalToolkit.log(new VelocityException.UnableToWriteGeneratedFile(genFileName, e.getLocalizedMessage()));
                }
            }
            return new TextFile(code, genFileName, doc.getCompilationUnit().getSource().getParent(), "text/as", doc.getCompilationUnit().getSource().getLastModified());
        }
        return null;
    }

    static {
        $assertionsDisabled = !ImplementationCompiler.class.desiredAssertionStatus();
    }

    public static class CodeGenerationException
    extends CompilerMessage.CompilerError {
        public final String template;
        public final String message;

        public CodeGenerationException(String template, String message) {
            this.template = template;
            this.message = message;
        }
    }

    public static class UnableToLoadTemplate
    extends CompilerMessage.CompilerError {
        public String template;

        public UnableToLoadTemplate(String template) {
            this.template = template;
            this.noPath();
        }
    }
}

