/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml;

import flex2.compiler.mxml.Token;
import flex2.compiler.util.LinkedQNameMap;
import flex2.compiler.util.QName;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Element
extends Token {
    private String uri;
    private String localPart;
    private LinkedQNameMap attributes;
    private Map prefixMappings;
    private List children;

    public Element(String uri, String localPart, int size) {
        this.uri = uri;
        this.localPart = localPart;
        if (size > 0) {
            this.attributes = new LinkedQNameMap(size);
        }
        this.prefixMappings = null;
    }

    public void addPrefixMapping(String uri, String prefix) {
        if (this.prefixMappings == null) {
            this.prefixMappings = new HashMap(8);
        }
        this.prefixMappings.put(uri, prefix);
    }

    public void addAttribute(String uri, String localName, Object value, int line) {
        if (this.attributes == null) {
            this.attributes = new LinkedQNameMap();
        }
        this.attributes.put(uri, localName, new Value(value, line));
    }

    public Object getAttribute(String localName) {
        return this.getAttribute("", localName);
    }

    public Object getAttribute(String uri, String localName) {
        if (this.attributes == null) {
            return null;
        }
        Value v = (Value)this.attributes.get(uri, localName);
        if (v != null) {
            return v.value;
        }
        return null;
    }

    public Object getAttribute(QName qname) {
        if (this.attributes == null) {
            return null;
        }
        Value v = (Value)this.attributes.get(qname);
        if (v != null) {
            return v.value;
        }
        return null;
    }

    public int getLineNumber(String localName) {
        return this.getLineNumber("", localName);
    }

    public int getLineNumber(String uri, String localName) {
        if (this.attributes == null) {
            return this.beginLine;
        }
        Value v = (Value)this.attributes.get(uri, localName);
        if (v != null) {
            return v.line;
        }
        return this.beginLine;
    }

    public int getLineNumber(QName qname) {
        if (this.attributes == null) {
            return this.beginLine;
        }
        Value v = (Value)this.attributes.get(qname);
        if (v != null) {
            return v.line;
        }
        return this.beginLine;
    }

    public Iterator getAttributeNames() {
        return this.attributes == null ? Collections.EMPTY_SET.iterator() : this.attributes.keySet().iterator();
    }

    public int getAttributeCount() {
        return this.attributes == null ? 0 : this.attributes.size();
    }

    public String getNamespace() {
        return this.uri;
    }

    public String getLocalPart() {
        return this.localPart;
    }

    public String getPrefix() {
        return this.prefixMappings == null ? null : (String)this.prefixMappings.get(this.uri);
    }

    public void addChildren(List children) {
        if (this.children == null) {
            this.children = children;
        } else {
            this.children.addAll(children);
        }
    }

    public void addChild(Token child) {
        if (child != null) {
            if (this.children == null) {
                this.children = new ArrayList();
            }
            this.children.add(child);
        }
    }

    public void copy(Element element) {
        element.uri = this.uri;
        element.localPart = this.localPart;
        element.prefixMappings = this.prefixMappings;
        element.attributes = this.attributes;
        element.children = this.children;
    }

    public Token getChildAt(int index) {
        return this.children == null ? null : this.children.get(index);
    }

    public int getChildCount() {
        return this.children == null ? 0 : this.children.size();
    }

    public Collection getChildren() {
        return this.children == null ? Collections.EMPTY_LIST : Collections.unmodifiableCollection(this.children);
    }

    public final Iterator getChildIterator() {
        return this.getChildren().iterator();
    }

    public void removeAttribute(QName qname) {
        this.attributes.remove(qname);
    }

    public String getPrefix(String uri) {
        return this.prefixMappings == null ? null : (String)this.prefixMappings.get(uri);
    }

    public void toStartElement(StringWriter w) {
        Iterator k;
        String p = null;
        w.write(60);
        p = this.getPrefix(this.uri);
        if (p != null && p.length() > 0) {
            w.write(p);
            w.write(58);
        }
        w.write(this.localPart);
        Iterator i = this.getAttributeNames();
        while (i.hasNext()) {
            QName qName = (QName)i.next();
            w.write(32);
            p = this.getPrefix(qName.getNamespace());
            if (p != null && p.length() > 0) {
                w.write(p);
                w.write(58);
            }
            w.write(qName.getLocalPart());
            w.write("=\"");
            w.write(this.getAttribute(qName).toString());
            w.write("\"");
        }
        Iterator iterator = k = this.prefixMappings == null ? null : this.prefixMappings.keySet().iterator();
        while (k != null && k.hasNext()) {
            String ns = (String)k.next();
            String px = this.getPrefix(ns);
            if (px == null) continue;
            w.write(" xmlns");
            if (px.length() > 0) {
                w.write(58);
                w.write(px);
            }
            w.write("=\"");
            w.write(ns);
            w.write("\"");
        }
        w.write(62);
    }

    public void toEndElement(StringWriter w) {
        String p = null;
        w.write("</");
        p = this.getPrefix(this.uri);
        if (p != null && p.length() > 0) {
            w.write(p);
            w.write(58);
        }
        w.write(this.localPart);
        w.write(62);
    }

    private class Value {
        private Object value;
        private int line;

        private Value(Object value, int line) {
            this.value = value;
            this.line = line;
        }
    }
}

