/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.media;

import flash.css.LocalSource;
import flash.css.URLSource;
import flash.fonts.FontManager;
import flash.swf.builder.tags.FontBuilder;
import flash.swf.tags.DefineFont;
import flash.util.Trace;
import flex2.compiler.ILocalizableMessage;
import flex2.compiler.Transcoder;
import flex2.compiler.TranscoderException;
import flex2.compiler.common.Configuration;
import flex2.compiler.common.FontsConfiguration;
import flex2.compiler.common.PathResolver;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.media.AbstractTranscoder;
import flex2.compiler.swc.SwcFile;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.ThreadLocalToolkit;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class FontTranscoder
extends AbstractTranscoder {
    private FontsConfiguration fontsConfig;
    public static final String UNICODERANGE = "unicodeRange";
    public static final String SYSTEMFONT = "systemFont";
    public static final String SOURCELIST = "sourceList";
    public static final String FLASHTYPE = "flashType";

    public FontTranscoder(Configuration config) {
        super(new String[]{"application/x-font-truetype", "application/x-font"}, DefineFont.class, true);
        this.fontsConfig = config.getCompilerConfiguration().getFontsConfiguration();
    }

    public boolean isSupportedAttribute(String attr) {
        return "fontName".equals(attr) || "fontStyle".equals(attr) || "fontWeight".equals(attr) || "fontFamily".equals(attr) || UNICODERANGE.equals(attr) || FLASHTYPE.equals(attr) || SYSTEMFONT.equals(attr) || SOURCELIST.equals(attr);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Transcoder.TranscodingResults doTranscode(PathResolver context, Map args, String className, boolean generateSource) throws TranscoderException {
        void var7_7;
        boolean flashType;
        String flashTypeStr;
        LinkedList<Object> locations;
        Transcoder.TranscodingResults results = new Transcoder.TranscodingResults();
        String systemFont = null;
        if (args.containsKey("source")) {
            if (args.containsKey(SYSTEMFONT) || args.containsKey(SOURCELIST)) {
                throw new BadParameters();
            }
            results.assetSource = this.resolveSource(context, args);
            results.modified = results.assetSource.getLastModified();
            locations = new LinkedList();
            locations.add(this.getURL(results.assetSource));
        } else if (args.containsKey(SYSTEMFONT)) {
            if (args.containsKey("source") || args.containsKey(SOURCELIST)) {
                throw new BadParameters();
            }
            systemFont = (String)args.get(SYSTEMFONT);
            locations = new LinkedList<Object>();
            locations.add(systemFont);
        } else {
            if (!args.containsKey(SOURCELIST)) throw new BadParameters();
            locations = this.resolveSourceList(context, args);
        }
        FontManager fontManager = this.fontsConfig.getTopLevelManager();
        int fontStyle = FontTranscoder.getFontStyle(args);
        boolean hasLayout = true;
        String family = (String)args.get("fontFamily");
        String alias = (String)args.get("fontName");
        if (alias == null) {
            alias = systemFont;
        }
        if (alias == null) {
            alias = family;
        }
        if (alias == null) {
            throw new BadParameters();
        }
        if (systemFont != null && systemFont.equals(alias)) {
            EmbeddedFontShadowsSystemFont embeddedFontShadowsSystemFont = new EmbeddedFontShadowsSystemFont(alias);
            String path = (String)args.get("_file");
            String pathSep = (String)args.get("_pathsep");
            if ("true".equals(pathSep)) {
                path = path.replace('/', '\\');
            }
            embeddedFontShadowsSystemFont.path = path;
            if (args.containsKey("_line")) {
                int line;
                embeddedFontShadowsSystemFont.line = line = Integer.parseInt((String)args.get("_line"));
            }
            ThreadLocalToolkit.log(embeddedFontShadowsSystemFont);
        }
        if ((flashTypeStr = (String)args.get(FLASHTYPE)) != null) {
            if (flashTypeStr.equalsIgnoreCase("true")) {
                flashType = true;
            } else {
                if (!flashTypeStr.equalsIgnoreCase("false")) throw new BadFlashType();
                flashType = false;
            }
        } else {
            flashType = this.fontsConfig.getFlashType();
        }
        FontBuilder builder = this.getBuilder(alias, (List)var7_7, fontStyle, hasLayout, flashType, args);
        try {
            char[][] ranges = this.getUnicodeRanges(fontManager, (String)args.get(UNICODERANGE));
            if (ranges != null) {
                for (int i = 0; i < ranges.length; ++i) {
                    char[] range = ranges[i];
                    if (range == null || range.length != 2) continue;
                    int count = range[1] - range[0] + 1;
                    builder.addCharset((int)range[0], count);
                }
            } else {
                builder.addAllChars();
            }
            results.defineTag = builder.build();
            if (!generateSource) return results;
            this.generateSource(results, className, args);
            return results;
        }
        catch (TranscoderException te) {
            throw te;
        }
        catch (Exception e) {
            if (!Trace.error) throw new AbstractTranscoder.ExceptionWhileTranscoding(e);
            e.printStackTrace();
            throw new AbstractTranscoder.ExceptionWhileTranscoding(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private URL getURL(VirtualFile virtualFile) throws TranscoderException {
        void var2_7;
        URL result;
        if (virtualFile instanceof SwcFile) {
            try {
                String name = virtualFile.getName();
                String path = name.substring(name.indexOf("$") + 1);
                File file = File.createTempFile(path, null);
                FileUtil.writeBinaryFile(file, virtualFile.getInputStream());
                result = file.toURL();
            }
            catch (IOException ioException) {
                throw new UnableToExtract(virtualFile.getName());
            }
        }
        try {
            result = new URL(virtualFile.getURL());
        }
        catch (MalformedURLException e) {
            throw new AbstractTranscoder.UnableToReadSource(virtualFile.getName());
        }
        return var2_7;
    }

    private FontBuilder getBuilder(String alias, List locations, int fontStyle, boolean hasLayout, boolean useFlashType, Map args) throws TranscoderException {
        FontManager fontManager = this.fontsConfig.getTopLevelManager();
        int defineFontTag = 75;
        FontBuilder builder = null;
        Iterator it = locations.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            try {
                builder = o instanceof URL ? new FontBuilder(defineFontTag, fontManager, alias, (URL)o, fontStyle, hasLayout, useFlashType) : new FontBuilder(defineFontTag, fontManager, alias, (String)o, fontStyle, hasLayout, useFlashType);
            }
            catch (Exception e) {
                if (Trace.error) {
                    e.printStackTrace();
                }
                AbstractTranscoder.ExceptionWhileTranscoding exceptionWhileTranscoding = new AbstractTranscoder.ExceptionWhileTranscoding(e);
                String path = (String)args.get("_file");
                String pathSep = (String)args.get("_pathsep");
                if ("true".equals(pathSep)) {
                    path = path.replace('/', '\\');
                }
                exceptionWhileTranscoding.path = path;
                if (args.containsKey("_line")) {
                    int line;
                    exceptionWhileTranscoding.line = line = Integer.parseInt((String)args.get("_line"));
                }
                ThreadLocalToolkit.log(exceptionWhileTranscoding);
            }
            if (builder == null) continue;
            return builder;
        }
        throw new UnableToBuildFont(alias);
    }

    public static int getFontStyle(Map args) {
        String weight;
        int s = 0;
        String style = (String)args.get("fontStyle");
        if (style == null) {
            style = "normal";
        }
        if ((weight = (String)args.get("fontWeight")) == null) {
            weight = "normal";
        }
        if (FontTranscoder.isBold(weight)) {
            ++s;
        }
        if (FontTranscoder.isItalic(style)) {
            s += 2;
        }
        return s;
    }

    public static boolean isBold(String value) {
        boolean bold = false;
        if (value != null) {
            String b = value.trim().toLowerCase();
            if (b.startsWith("bold")) {
                bold = true;
            } else {
                try {
                    int w = Integer.parseInt(b);
                    if (w >= 700) {
                        bold = true;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return bold;
    }

    public static boolean isItalic(String value) {
        String ital;
        boolean italic = false;
        if (value != null && ((ital = value.trim().toLowerCase()).equals("italic") || ital.equals("oblique"))) {
            italic = true;
        }
        return italic;
    }

    public char[][] getUnicodeRanges(FontManager fontManager, String r) throws TranscoderException {
        char[][] ranges = null;
        if (r != null) {
            String value = new String(r);
            String langRange = fontManager.getLanguageRange(value);
            if (langRange != null) {
                value = langRange;
            }
            value = value.replace(';', ' ').replace('\n', ' ').replace('\r', ' ').replace('\f', ' ');
            StringTokenizer st = new StringTokenizer(value, ",");
            int count = st.countTokens();
            ranges = new char[count][2];
            FontTranscoder.parseRanges(st, ranges);
        }
        return ranges;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void parseRanges(StringTokenizer st, char[][] ranges) throws TranscoderException {
        int i = 0;
        while (st.hasMoreElements()) {
            String element = ((String)st.nextElement()).trim().toUpperCase();
            if (element.startsWith("U+")) {
                void var6_6;
                void var5_5;
                String high;
                String low;
                String range = element.substring(2).trim();
                if (range.indexOf(63) > 0) {
                    low = range.replace('?', '0');
                    high = range.replace('?', 'F');
                } else if (range.indexOf(45) > 0) {
                    low = range.substring(0, range.indexOf(45));
                    String temp = range.substring(range.indexOf(45) + 1).trim();
                    if (!temp.startsWith("U+")) throw new InvalidUnicodeRangeException(temp);
                    high = temp.substring(2).trim();
                } else {
                    if (range.length() > 4) throw new InvalidUnicodeRangeException(range);
                    low = range;
                    high = range;
                }
                ranges[i][0] = (char)Integer.parseInt((String)var5_5, 16);
                ranges[i][1] = (char)Integer.parseInt((String)var6_6, 16);
                ++i;
                continue;
            }
            if (element.length() == 0) continue;
            throw new InvalidUnicodeRangeException(element);
        }
    }

    private List resolveSourceList(PathResolver context, Map args) throws TranscoderException {
        LinkedList<Object> result = new LinkedList<Object>();
        Iterator iterator = ((List)args.get(SOURCELIST)).iterator();
        while (iterator.hasNext()) {
            Object source = iterator.next();
            if (source instanceof URLSource) {
                URLSource urlSource = (URLSource)source;
                VirtualFile virtualFile = this.resolve(context, urlSource.getValue());
                result.add(this.getURL(virtualFile));
                continue;
            }
            LocalSource localSource = (LocalSource)source;
            result.add(localSource.getValue());
        }
        return result;
    }

    public static final class EmbeddedFontShadowsSystemFont
    extends CompilerMessage.CompilerWarning
    implements ILocalizableMessage {
        public final String alias;

        public EmbeddedFontShadowsSystemFont(String alias) {
            this.alias = alias;
        }
    }

    public static final class UnableToExtract
    extends TranscoderException {
        public String fileName;

        public UnableToExtract(String fileName) {
            this.fileName = fileName;
        }
    }

    public static final class UnableToBuildFont
    extends TranscoderException {
        public String fontName;

        public UnableToBuildFont(String fontName) {
            this.fontName = fontName;
        }
    }

    public static final class BadFlashType
    extends TranscoderException {
    }

    public static final class BadParameters
    extends TranscoderException {
    }

    public static final class InvalidUnicodeRangeException
    extends TranscoderException {
        public String range;

        public InvalidUnicodeRangeException(String range) {
            this.range = range;
        }
    }
}

