/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.i18n;

import flash.util.FileUtils;
import flash.util.Trace;
import flex2.compiler.CompilationUnit;
import flex2.compiler.Context;
import flex2.compiler.Source;
import flex2.compiler.SymbolTable;
import flex2.compiler.as3.Configuration;
import flex2.compiler.as3.Extension;
import flex2.compiler.common.CompilerConfiguration;
import flex2.compiler.i18n.I18nUtils;
import flex2.compiler.i18n.PropertyTranslationFormat;
import flex2.compiler.i18n.TranslationException;
import flex2.compiler.i18n.TranslationFormat;
import flex2.compiler.io.TextFile;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.ThreadLocalToolkit;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Compiler
implements flex2.compiler.Compiler {
    private flex2.compiler.as3.Compiler asc;
    private TranslationFormat format = new PropertyTranslationFormat();
    public String generatedDir;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Compiler(final CompilerConfiguration compilerConfig) {
        this.asc = new flex2.compiler.as3.Compiler(new Configuration(){

            public boolean debug() {
                return false;
            }

            public boolean strict() {
                return true;
            }

            public int dialect() {
                return compilerConfig.dialect();
            }

            public boolean adjustOpDebugLine() {
                return compilerConfig.adjustOpDebugLine();
            }

            public boolean warnings() {
                return false;
            }

            public boolean doc() {
                return false;
            }

            public String getEncoding() {
                return null;
            }

            public boolean metadataExport() {
                return false;
            }

            public boolean warn_array_tostring_changes() {
                return false;
            }

            public boolean warn_assignment_within_conditional() {
                return false;
            }

            public boolean warn_bad_array_cast() {
                return false;
            }

            public boolean warn_bad_bool_assignment() {
                return false;
            }

            public boolean warn_bad_date_cast() {
                return false;
            }

            public boolean warn_bad_es3_type_method() {
                return false;
            }

            public boolean warn_bad_es3_type_prop() {
                return false;
            }

            public boolean warn_bad_nan_comparison() {
                return false;
            }

            public boolean warn_bad_null_assignment() {
                return false;
            }

            public boolean warn_bad_null_comparison() {
                return false;
            }

            public boolean warn_bad_undefined_comparison() {
                return false;
            }

            public boolean warn_boolean_constructor_with_no_args() {
                return false;
            }

            public boolean warn_changes_in_resolve() {
                return false;
            }

            public boolean warn_class_is_sealed() {
                return false;
            }

            public boolean warn_const_not_initialized() {
                return false;
            }

            public boolean warn_constructor_returns_value() {
                return false;
            }

            public boolean warn_deprecated_event_handler_error() {
                return false;
            }

            public boolean warn_deprecated_function_error() {
                return false;
            }

            public boolean warn_deprecated_property_error() {
                return false;
            }

            public boolean warn_duplicate_argument_names() {
                return false;
            }

            public boolean warn_duplicate_variable_def() {
                return false;
            }

            public boolean warn_for_var_in_changes() {
                return false;
            }

            public boolean warn_import_hides_class() {
                return false;
            }

            public boolean warn_instance_of_changes() {
                return false;
            }

            public boolean warn_internal_error() {
                return false;
            }

            public boolean warn_level_not_supported() {
                return false;
            }

            public boolean warn_missing_namespace_decl() {
                return false;
            }

            public boolean warn_negative_uint_literal() {
                return false;
            }

            public boolean warn_no_constructor() {
                return false;
            }

            public boolean warn_no_explicit_super_call_in_constructor() {
                return false;
            }

            public boolean warn_no_type_decl() {
                return false;
            }

            public boolean warn_number_from_string_changes() {
                return false;
            }

            public boolean warn_scoping_change_in_this() {
                return false;
            }

            public boolean warn_slow_text_field_addition() {
                return false;
            }

            public boolean warn_unlikely_function_value() {
                return false;
            }

            public boolean warn_xml_class_has_changed() {
                return false;
            }
        });
        this.generatedDir = compilerConfig.keepGeneratedActionScript() ? compilerConfig.getGeneratedDirectory() : null;
        this.format = I18nUtils.getTranslationFormat(compilerConfig);
    }

    public void addCompilerExtension(Extension ext) {
        this.asc.addCompilerExtension(ext);
    }

    public boolean isSupported(String mimeType) {
        return this.format.isSupported(mimeType);
    }

    public String[] getSupportedMimeTypes() {
        return this.format.getSupportedMimeTypes();
    }

    public Source preprocess(Source source) {
        return source;
    }

    public CompilationUnit parse1(Source source, SymbolTable symbolTable) {
        Set translationSet;
        try {
            translationSet = this.format.getTranslationSet(source.getInputStream());
        }
        catch (IOException ioe) {
            ThreadLocalToolkit.logError(ioe.getMessage());
            return null;
        }
        catch (TranslationException te) {
            ThreadLocalToolkit.logError(te.getMessage());
            return null;
        }
        Source transSource = this.transform(source, translationSet);
        CompilationUnit ascUnit = this.asc.parse1(transSource, symbolTable);
        if (ThreadLocalToolkit.errorCount() > 0) {
            return null;
        }
        Context context = new Context();
        context.setAttribute("ascUnit", ascUnit);
        CompilationUnit unit = source.newCompilationUnit(null, context);
        Source.transferMetaData(ascUnit, unit);
        Source.transferDefinitions(ascUnit, unit);
        Source.transferInheritance(ascUnit, unit);
        return unit;
    }

    public void parse2(CompilationUnit unit, SymbolTable symbolTable) {
        CompilationUnit ascUnit = (CompilationUnit)unit.getContext().getAttribute("ascUnit");
        Source.transferInheritance(unit, ascUnit);
        this.asc.parse2(ascUnit, symbolTable);
    }

    private Source transform(Source source, Set translationSet) {
        String name = source.getName();
        String relativePath = source.getRelativePath();
        String lineSep = System.getProperty("line.separator");
        int index = relativePath.length() == 0 ? name.lastIndexOf(File.separatorChar) : name.lastIndexOf(relativePath.replace('/', File.separatorChar));
        if (!$assertionsDisabled && index <= 0) {
            throw new AssertionError();
        }
        String packageName = relativePath.replace('/', '.');
        String className = NameFormatter.classNameFromSource(source);
        StringBuffer b = new StringBuffer();
        b.append("package " + packageName + lineSep + "{" + lineSep + "    import mx.resources.ResourceBundle;" + lineSep + lineSep + "    [ExcludeClass]" + lineSep + lineSep + "    public class " + className + " extends ResourceBundle" + lineSep + "    {" + lineSep + "        public function " + className + "()" + lineSep + "        {" + lineSep + "\t\t     super();" + lineSep + "        }" + lineSep + lineSep + "        override protected function getContent():Object" + lineSep + "        {" + lineSep + "            var properties:Object = {};" + lineSep + lineSep);
        Iterator i = translationSet.iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            b.append("            properties[\"" + key + "\"] = \"" + value + "\";" + lineSep);
        }
        b.append(lineSep + "            return properties;" + lineSep + "        }" + lineSep + "    }" + lineSep + "}" + lineSep);
        if (this.generatedDir != null) {
            try {
                FileUtils.writeClassToFile((String)this.generatedDir, (String)packageName, (String)(className + ".as"), (String)b.toString());
            }
            catch (IOException ioe) {
                if (Trace.error) {
                    ioe.printStackTrace();
                }
                ThreadLocalToolkit.logError(ioe.toString());
            }
        }
        return new Source(new TextFile(b.toString(), className, source.getParent(), "text/as", source.getLastModified()), source);
    }

    public void analyze1(CompilationUnit unit, SymbolTable symbolTable) {
        CompilationUnit ascUnit = (CompilationUnit)unit.getContext().getAttribute("ascUnit");
        this.asc.analyze1(ascUnit, symbolTable);
        Source.transferTypeInfo(ascUnit, unit);
        Source.transferNamespaces(ascUnit, unit);
    }

    public void analyze2(CompilationUnit unit, SymbolTable symbolTable) {
        CompilationUnit ascUnit = (CompilationUnit)unit.getContext().getAttribute("ascUnit");
        Source.transferDependencies(unit, ascUnit);
        this.asc.analyze2(ascUnit, symbolTable);
        Source.transferDependencies(ascUnit, unit);
    }

    public void analyze3(CompilationUnit unit, SymbolTable symbolTable) {
        CompilationUnit ascUnit = (CompilationUnit)unit.getContext().getAttribute("ascUnit");
        Source.transferDependencies(unit, ascUnit);
        this.asc.analyze3(ascUnit, symbolTable);
    }

    public void analyze4(CompilationUnit unit, SymbolTable symbolTable) {
        CompilationUnit ascUnit = (CompilationUnit)unit.getContext().getAttribute("ascUnit");
        this.asc.analyze4(ascUnit, symbolTable);
        Source.transferExpressions(ascUnit, unit);
    }

    public void generate(CompilationUnit unit, SymbolTable symbolTable) {
        CompilationUnit ascUnit = (CompilationUnit)unit.getContext().getAttribute("ascUnit");
        this.asc.generate(ascUnit, symbolTable);
        unit.bytes.clear();
        unit.bytes.addAll(ascUnit.bytes);
    }

    public void postprocess(CompilationUnit unit, SymbolTable symbolTable) {
    }

    static {
        $assertionsDisabled = !Compiler.class.desiredAssertionStatus();
    }
}

