/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.css;

import flash.css.Descriptor;
import flash.css.Rule;
import flash.css.StyleDeclaration;
import flex2.compiler.Source;
import flex2.compiler.as3.MetaDataParser;
import flex2.compiler.as3.reflect.MetaData;
import flex2.compiler.common.PathResolver;
import flex2.compiler.common.SinglePathResolver;
import flex2.compiler.css.Import;
import flex2.compiler.css.StyleProperty;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.mxml.lang.FrameworkDefs;
import flex2.compiler.mxml.reflect.Type;
import flex2.compiler.mxml.rep.AtEmbed;
import flex2.compiler.mxml.rep.MxmlDocument;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.MimeMappings;
import flex2.compiler.util.ThreadLocalToolkit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StyleDef {
    private String name;
    private boolean isTypeSelector;
    private Map atEmbeds = new HashMap();
    private Set imports = new HashSet();
    private Map styles = new HashMap();
    private List effectStyles = new ArrayList();
    private Map sheetFiles = new HashMap();
    private MxmlDocument mxmlDocument;
    private Source source;
    private Object perCompileData;
    public static final String CLASS_REFERENCE = "ClassReference(";
    public static final String EMBED = "Embed(";

    StyleDef(String name, boolean isTypeSelector, MxmlDocument mxmlDocument, Source source, Object perCompileData) {
        this.name = name;
        this.isTypeSelector = isTypeSelector;
        this.mxmlDocument = mxmlDocument;
        this.source = source;
        this.perCompileData = perCompileData;
    }

    StyleDef(String name, boolean isTypeSelector, Source source, Object perCompileData) {
        this.name = name;
        this.isTypeSelector = isTypeSelector;
        this.source = source;
        this.perCompileData = perCompileData;
    }

    void addRule(Rule rule) {
        StyleDeclaration declaration = rule.getStyle();
        Iterator propertyIterator = declaration.iterator();
        while (propertyIterator.hasNext()) {
            String descriptorName = (String)propertyIterator.next();
            Descriptor descriptor = declaration.getPropertyValue(descriptorName);
            String propertyName = StyleDef.dehyphenize(descriptor.getName());
            try {
                if (propertyName.equals("fontFamily")) {
                    this.processFontFamily(descriptor);
                    continue;
                }
                this.processStyle(descriptor, propertyName);
            }
            catch (CompilerMessage.CompilerError compilerError) {
                compilerError.setPath(descriptor.getPath());
                compilerError.setLine(descriptor.getLineNumber());
                ThreadLocalToolkit.log(compilerError);
            }
        }
    }

    public boolean isTypeSelector() {
        return this.isTypeSelector;
    }

    public static String dehyphenize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int start = 0;
        int end = string.indexOf(45);
        while (end >= 0) {
            stringBuffer.append(string.substring(start, end));
            stringBuffer.append(Character.toUpperCase(string.charAt(end + 1)));
            start = end + 2;
            end = string.indexOf(45, start);
        }
        stringBuffer.append(string.substring(start));
        return stringBuffer.toString();
    }

    private boolean addAtEmbed(AtEmbed atEmbed) {
        if (this.mxmlDocument != null) {
            this.mxmlDocument.addAtEmbed(atEmbed);
        } else if (!this.atEmbeds.containsKey(atEmbed.getPropName())) {
            this.atEmbeds.put(atEmbed.getPropName(), atEmbed);
        }
        return true;
    }

    public Collection getAtEmbeds() {
        return this.atEmbeds.values();
    }

    public List getEffectStyles() {
        return this.effectStyles;
    }

    public Set getImports() {
        return this.imports;
    }

    public String getName() {
        return this.name;
    }

    public Collection getStyles() {
        return this.styles.values();
    }

    public String getTypeName() {
        return StyleDef.dehyphenize(this.name);
    }

    private String processEmbed(String styleSheetPath, String value, int line) {
        VirtualFile resolved;
        int octothorpe;
        MetaData metaData = MetaDataParser.parse(this.perCompileData, this.source, 0, value);
        if (metaData == null) {
            return null;
        }
        String sourceValue = metaData.getValue(0);
        String mimeType = null;
        String symbolName = null;
        if (metaData.count() == 2) {
            String symbolOrMimeType = metaData.getValue(1);
            if (MimeMappings.getExtension(symbolOrMimeType) != null) {
                mimeType = symbolOrMimeType;
            } else {
                symbolName = symbolOrMimeType;
            }
        }
        if ((octothorpe = sourceValue.indexOf(35)) != -1 && symbolName == null) {
            symbolName = sourceValue.substring(octothorpe + 1);
            sourceValue = sourceValue.substring(0, octothorpe);
        }
        if ((resolved = this.resolveSource(styleSheetPath, sourceValue)) == null) {
            InvalidEmbed invalidEmbed = new InvalidEmbed(value);
            invalidEmbed.path = styleSheetPath;
            invalidEmbed.line = line;
            ThreadLocalToolkit.log(invalidEmbed);
            return null;
        }
        String resolvedSource = resolved.getName().replace('\\', '/');
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("_resolvedSource", resolvedSource);
        ThreadLocalToolkit.addResolvedPath(resolvedSource, resolved);
        values.put("source", resolvedSource);
        if (mimeType != null) {
            values.put("mimeType", mimeType);
        }
        if (symbolName != null) {
            values.put("symbol", symbolName);
        }
        Iterator it = metaData.getValueMap().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            String key = (String)e.getKey();
            if (values.containsKey(key)) continue;
            String val = ((String)e.getValue()).replace('\\', '/');
            values.put(key, val);
        }
        String propName = AtEmbed.createMangledName(this.source, sourceValue, false, values, "_embed_css_");
        if (styleSheetPath.indexOf(92) > -1) {
            values.put("_file", styleSheetPath.replace('\\', '/'));
            values.put("_pathsep", "true");
        } else {
            values.put("_file", styleSheetPath);
        }
        values.put("_line", Integer.toString(line));
        this.addAtEmbed(new AtEmbed(propName, 0, values, false));
        return propName;
    }

    private String processClassReference(String styleSheetPath, String value, int line) {
        String result = null;
        String parameter = value.substring(CLASS_REFERENCE.length(), value.length() - 1).trim();
        if (parameter.charAt(0) == '\"' && parameter.indexOf(34, 1) == parameter.length() - 1) {
            result = parameter.substring(1, parameter.length() - 1);
            this.imports.add(new Import(result, line));
        } else if (parameter.equals("null")) {
            result = parameter;
        } else {
            InvalidClassReference invalidClassReference = new InvalidClassReference();
            invalidClassReference.path = styleSheetPath;
            invalidClassReference.line = line;
            ThreadLocalToolkit.log(invalidClassReference);
        }
        return result;
    }

    private void processFontFamily(Descriptor descriptor) {
        String fontFamily = descriptor.getIdentAsString();
        StyleProperty stylesProperty = new StyleProperty("fontFamily", "\"" + fontFamily + "\"", descriptor.getLineNumber());
        this.styles.put(stylesProperty.getName(), stylesProperty);
    }

    private void processStyle(Descriptor descriptor, String propertyName) throws CompilerMessage.CompilerError {
        String value;
        if (propertyName.endsWith("Effect")) {
            this.effectStyles.add(propertyName);
        }
        if ((value = this.processStyle(descriptor)) != null) {
            StyleProperty styleProperty = new StyleProperty(propertyName, value, descriptor.getLineNumber());
            this.styles.put(styleProperty.getName(), styleProperty);
        }
    }

    private String processStyle(Descriptor descriptor) throws CompilerMessage.CompilerError {
        String value = descriptor.getValueAsString();
        if (value.startsWith(EMBED)) {
            value = this.processEmbed(descriptor.getPath(), value, descriptor.getLineNumber());
        } else if (value.startsWith(CLASS_REFERENCE)) {
            value = this.processClassReference(descriptor.getPath(), value, descriptor.getLineNumber());
        }
        if (!(this.mxmlDocument == null || descriptor.getValue().getLexicalUnitType() != 35 || value == null || value.length() <= 2 || value.charAt(0) != '\'' && value.charAt(0) != '\"' || value.charAt(value.length() - 1) != '\'' && value.charAt(value.length() - 1) != '\"')) {
            String potentialProperty = value.substring(1, value.length() - 1);
            Type type = this.mxmlDocument.getRoot().getType();
            if (type != null && type.getProperty(potentialProperty) != null) {
                value = potentialProperty;
            }
            if (FrameworkDefs.isBuiltinEffectName(potentialProperty)) {
                this.mxmlDocument.addTypeRef("mx.effects." + potentialProperty, descriptor.getLineNumber());
            }
        }
        return value;
    }

    private VirtualFile resolveSource(String styleSheetPath, String sourcePath) {
        PathResolver context = new PathResolver();
        if (sourcePath != null && sourcePath.charAt(0) == '/') {
            Object owner;
            VirtualFile pathRoot = this.source.getPathRoot();
            if (pathRoot != null) {
                context.addSinglePathResolver(pathRoot);
            }
            if ((owner = this.source.getOwner()) instanceof SinglePathResolver) {
                context.addSinglePathResolver((SinglePathResolver)owner);
            }
        } else {
            VirtualFile sheetFile = this.getSheetFile(styleSheetPath);
            if (sheetFile != null) {
                context.addSinglePathResolver(sheetFile);
            }
        }
        context.addSinglePathResolver(ThreadLocalToolkit.getPathResolver());
        return context.resolve(sourcePath);
    }

    private VirtualFile getSheetFile(String sheetPath) {
        if (this.sheetFiles.containsKey(sheetPath)) {
            return (VirtualFile)this.sheetFiles.get(sheetPath);
        }
        VirtualFile sheetFile = ThreadLocalToolkit.getPathResolver().resolve(sheetPath);
        this.sheetFiles.put(sheetPath, sheetFile);
        return sheetFile;
    }

    public static class InvalidClassReference
    extends CompilerMessage.CompilerError {
    }

    public static class InvalidEmbed
    extends CompilerMessage.CompilerError {
        public String source;

        public InvalidEmbed(String source) {
            this.source = source;
        }
    }
}

