/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.common;

import flex2.compiler.config.ConfigurationInfo;
import flex2.compiler.config.ConfigurationValue;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class MetadataConfiguration {
    private boolean info;
    private Map localizedTitles = new HashMap();
    private Map localizedDescriptions = new HashMap();
    private Set contributors = new TreeSet();
    private Set publishers = new TreeSet();
    private Set creators = new TreeSet();
    public String date = null;
    public TreeSet langs = new TreeSet();

    public boolean isSet() {
        return this.localizedTitles.size() > 0 || this.localizedDescriptions.size() > 0 || this.publishers.size() > 0 || this.creators.size() > 0 || this.contributors.size() > 0 || this.langs.size() > 0 || this.date != null;
    }

    private static String f(String in) {
        return (in = in.trim()).indexOf(60) == -1 && in.indexOf(62) == -1 ? in : "<![CDATA[" + in + "]]>";
    }

    public String toString() {
        Map.Entry e;
        Iterator<Object> it;
        if (!this.isSet()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<rdf:RDF xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'>");
        sb.append("<rdf:Description rdf:about='' xmlns:dc='http://purl.org/dc/elements/1.1'>");
        sb.append("<dc:format>application/x-shockwave-flash</dc:format>");
        if (this.localizedTitles.size() > 0) {
            if (this.localizedTitles.size() == 1 && this.localizedTitles.get("x-default") != null) {
                sb.append("<dc:title>" + MetadataConfiguration.f((String)this.localizedTitles.get("x-default")) + "</dc:title>");
            } else {
                sb.append("<dc:title><rdf:Alt>");
                it = this.localizedTitles.entrySet().iterator();
                while (it.hasNext()) {
                    e = (Map.Entry)it.next();
                    sb.append("<rdf:li xml:lang='" + e.getKey() + "'>" + MetadataConfiguration.f((String)e.getValue()) + "</rdf:li>");
                }
                sb.append("</rdf:Alt></dc:title>");
            }
        }
        if (this.localizedDescriptions.size() > 0) {
            if (this.localizedDescriptions.size() == 1 && this.localizedDescriptions.get("x-default") != null) {
                sb.append("<dc:description>" + MetadataConfiguration.f((String)this.localizedDescriptions.get("x-default")) + "</dc:description>");
            } else {
                sb.append("<dc:description><rdf:Alt>");
                it = this.localizedDescriptions.entrySet().iterator();
                while (it.hasNext()) {
                    e = (Map.Entry)it.next();
                    sb.append("<rdf:li xml:lang='" + (String)e.getKey() + "'>" + MetadataConfiguration.f((String)e.getValue()) + "</rdf:li>");
                }
                sb.append("</rdf:Alt></dc:description>");
            }
        }
        it = this.publishers.iterator();
        while (it.hasNext()) {
            sb.append("<dc:publisher>" + MetadataConfiguration.f((String)it.next()) + "</dc:publisher>");
        }
        it = this.creators.iterator();
        while (it.hasNext()) {
            sb.append("<dc:creator>" + MetadataConfiguration.f((String)it.next()) + "</dc:creator>");
        }
        it = this.contributors.iterator();
        while (it.hasNext()) {
            sb.append("<dc:contributor>" + MetadataConfiguration.f((String)it.next()) + "</dc:contributor>");
        }
        it = this.langs.iterator();
        while (it.hasNext()) {
            sb.append("<dc:language>" + MetadataConfiguration.f((String)it.next()) + "</dc:language>");
        }
        if (this.date == null) {
            this.date = DateFormat.getDateInstance().format(new Date());
        }
        sb.append("<dc:date>" + MetadataConfiguration.f(this.date) + "</dc:date>");
        sb.append("</rdf:Description></rdf:RDF>");
        return sb.toString();
    }

    public void cfgTitle(ConfigurationValue cv, String title) {
        this.localizedTitles.put("x-default", title);
    }

    public static ConfigurationInfo getTitleInfo() {
        return new ConfigurationInfo(1, "text"){

            public String getDescription() {
                return "The default title to store in the SWF metadata";
            }

            public boolean isAdvanced() {
                return false;
            }
        };
    }

    public void cfgLocalizedTitle(ConfigurationValue cv, String title, String lang) {
        this.localizedTitles.put(lang, title);
    }

    public static ConfigurationInfo getLocalizedTitleInfo() {
        return new ConfigurationInfo(2, new String[]{"title", "lang"}){

            public String getDescription() {
                return "A localized RDF/XMP title to store in the SWF metadata";
            }

            public boolean isAdvanced() {
                return false;
            }

            public boolean allowMultiple() {
                return true;
            }
        };
    }

    public void cfgDescription(ConfigurationValue cv, String text) {
        this.localizedDescriptions.put("x-default", text);
    }

    public static ConfigurationInfo getDescriptionInfo() {
        return new ConfigurationInfo(1, "text"){

            public String getDescription() {
                return "The default description to store in the SWF metadata";
            }

            public boolean isAdvanced() {
                return false;
            }
        };
    }

    public void cfgLocalizedDescription(ConfigurationValue cv, String text, String lang) {
        this.localizedDescriptions.put(lang, text);
    }

    public static ConfigurationInfo getLocalizedDescriptionInfo() {
        return new ConfigurationInfo(2, new String[]{"text", "lang"}){

            public String getDescription() {
                return "A localized RDF/XMP description to store in the SWF metadata";
            }

            public boolean isAdvanced() {
                return false;
            }

            public boolean allowMultiple() {
                return true;
            }
        };
    }

    public void cfgContributor(ConfigurationValue cv, String name) {
        this.contributors.add(name);
    }

    public static ConfigurationInfo getContributorInfo() {
        return new ConfigurationInfo(1, "name"){

            public String getDescription() {
                return "A contributor's name to store in the SWF metadata";
            }

            public boolean isAdvanced() {
                return false;
            }

            public boolean allowMultiple() {
                return true;
            }
        };
    }

    public void cfgPublisher(ConfigurationValue cv, String name) {
        this.publishers.add(name);
    }

    public static ConfigurationInfo getPublisherInfo() {
        return new ConfigurationInfo(1, "name"){

            public String getDescription() {
                return "A publisher's name to store in the SWF metadata";
            }

            public boolean isAdvanced() {
                return false;
            }

            public boolean allowMultiple() {
                return true;
            }
        };
    }

    public void cfgCreator(ConfigurationValue cv, String name) {
        this.creators.add(name);
    }

    public static ConfigurationInfo getCreatorInfo() {
        return new ConfigurationInfo(1, "name"){

            public String getDescription() {
                return "A creator's name to store in the SWF metadata";
            }

            public boolean isAdvanced() {
                return false;
            }

            public boolean allowMultiple() {
                return true;
            }
        };
    }

    public void cfgDate(ConfigurationValue cv, String text) {
        this.date = text;
    }

    public static ConfigurationInfo getDateInfo() {
        return new ConfigurationInfo(1, "text"){

            public String getDescription() {
                return "The creation date to store in the SWF metadata";
            }

            public boolean isAdvanced() {
                return false;
            }
        };
    }

    public void cfgLanguage(ConfigurationValue cv, String code) {
        this.langs.add(code);
    }

    public static ConfigurationInfo getLanguageInfo() {
        return new ConfigurationInfo(1, "code"){

            public String getDescription() {
                return "The language to store in the SWF metadata (i.e. EN, FR)";
            }

            public boolean isAdvanced() {
                return false;
            }

            public boolean allowMultiple() {
                return true;
            }
        };
    }
}

