/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.common;

import flash.util.StringUtils;
import flex.messaging.config.ServicesDependencies;
import flex2.compiler.common.ConfigurationException;
import flex2.compiler.common.ConfigurationPathResolver;
import flex2.compiler.common.FontsConfiguration;
import flex2.compiler.common.NamespacesConfiguration;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.config.ConfigurationInfo;
import flex2.compiler.config.ConfigurationValue;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.mxml.Configuration;
import flex2.compiler.mxml.lang.StandardDefs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class CompilerConfiguration
implements flex2.compiler.as3.Configuration,
Configuration {
    public static final String LOCALE_TOKEN = "{locale}";
    public static final String STRICT = "compiler.strict";
    public static final String AS3 = "compiler.as3";
    public static final String ES = "compiler.es";
    private ConfigurationPathResolver configResolver;
    private boolean verboseStacktraces;
    private String[] as3metadata = StandardDefs.DefaultAS3Metadata;
    private boolean keepAllTypeSelectors;
    private boolean generateDebugTags;
    private boolean accessible;
    private boolean headlessServer;
    private boolean keepGeneratedActionScript = true;
    private String generatedDir = null;
    private boolean showDeprecationWarnings = false;
    private boolean showUnusedTypeSelectorWarnings = true;
    private boolean showDependencyWarnings = false;
    private boolean showBindingWarnings = true;
    private String contextRoot;
    private VirtualFile servicesConfigFile;
    protected ServicesDependencies servicesDependencies;
    private VirtualFile[] themeFiles;
    private List themeCssFiles = new LinkedList();
    private VirtualFile defaultsCSSUrl;
    private VirtualFile[] sourcePath;
    private VirtualFile[] libraryPath;
    private Set externs = new HashSet();
    private VirtualFile[] externalLibraryPath;
    private boolean strict;
    private boolean ascWarnings;
    private String locale;
    private VirtualFile[] includeLibraries;
    private boolean doc;
    private String translationFormat;
    private NamespacesConfiguration namespaces = new NamespacesConfiguration();
    private boolean metadataExport;
    private FontsConfiguration fontsConfig = new FontsConfiguration();
    private boolean incremental = false;
    private boolean optimize = false;
    private boolean warn_assignment_within_conditional = true;
    private boolean warn_bad_array_cast = true;
    private boolean warn_bad_bool_assignment = true;
    private boolean warn_bad_date_cast = true;
    private boolean warn_bad_es3_type_method = true;
    private boolean warn_bad_es3_type_prop = true;
    private boolean warn_bad_nan_comparison = true;
    private boolean warn_bad_null_assignment = true;
    private boolean warn_bad_null_comparison = true;
    private boolean warn_bad_undefined_comparison = true;
    private boolean warn_changes_in_resolve = false;
    private boolean warn_const_not_initialized = true;
    private boolean warn_duplicate_argument_names = true;
    private boolean warn_duplicate_variable_def = true;
    private boolean warn_import_hides_class = true;
    private boolean warn_instance_of_changes = true;
    private boolean warn_internal_error = true;
    private boolean warn_level_not_supported = false;
    private boolean warn_negative_uint_literal = true;
    private boolean warn_number_from_string_changes = false;
    private boolean warn_slow_text_field_addition = true;
    private boolean warn_unlikely_function_value = true;
    private boolean warn_no_type_decl = true;
    private boolean warn_constructor_returns_value = false;
    private boolean warn_boolean_constructor_with_no_args = false;
    private boolean warn_array_tostring_changes = false;
    private boolean warn_deprecated_property_error = false;
    private boolean warn_deprecated_function_error = false;
    private boolean warn_class_is_sealed = false;
    private boolean warn_scoping_change_in_this = false;
    private boolean warn_missing_namespace_decl = true;
    private boolean warn_for_var_in_changes = false;
    private boolean warn_deprecated_event_handler_error = false;
    private boolean warn_no_constructor = true;
    private boolean warn_no_explicit_super_call_in_constructor = false;
    private boolean warn_xml_class_has_changed = false;
    private boolean allowSourcePathOverlap = false;
    private boolean suppressWarningsInIncremental = false;
    private String actionscriptFileEncoding = null;
    private boolean useConservativeAlgorithm = false;
    private int factor = 1000;
    private boolean useResourceBundleMetadata = false;
    public static final int AS3Dialect = 10;
    public static final int ESDialect = 9;
    private int dialect = 10;
    private boolean adjustOpDebugLine = true;

    public CompilerConfiguration() {
        this.fontsConfig.setCompilerConfiguration(this);
    }

    public void setConfigPathResolver(ConfigurationPathResolver resolver) {
        this.configResolver = resolver;
        this.fontsConfig.setConfigPathResolver(this.configResolver);
        this.namespaces.setConfigPathResolver(this.configResolver);
    }

    public void cfgProfile(ConfigurationValue cv, boolean profile) {
        this.cfgVerboseStacktraces(cv, profile);
    }

    public static ConfigurationInfo getProfileInfo() {
        return new ConfigurationInfo(){

            public String getDescription() {
                return "generate a movie that is suitable for performance profiling";
            }

            public boolean isHidden() {
                return true;
            }
        };
    }

    public void cfgVerboseStacktraces(ConfigurationValue cv, boolean verboseStacktraces) {
        this.verboseStacktraces = this.generateDebugTags ? true : verboseStacktraces;
    }

    public static ConfigurationInfo getVerboseStacktracesInfo() {
        return new ConfigurationInfo(){

            public String[] getPrerequisites() {
                return new String[]{"debug"};
            }

            public String getDescription() {
                return "save callstack information to the SWF for debugging";
            }

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public void cfgKeepAs3Metadata(ConfigurationValue cv, String[] md) {
        if (this.as3metadata == null) {
            this.as3metadata = md;
        } else if (md != null) {
            HashSet<String> s = new HashSet<String>(Arrays.asList(this.as3metadata));
            s.addAll(Arrays.asList(md));
            this.as3metadata = new String[s.size()];
            int k = 0;
            Iterator i = s.iterator();
            while (i.hasNext()) {
                this.as3metadata[k] = (String)i.next();
                ++k;
            }
        }
    }

    public String[] getKeepAs3Metadata() {
        return this.as3metadata;
    }

    public static ConfigurationInfo getKeepAs3MetadataInfo() {
        return new ConfigurationInfo(-1, new String[]{"name"}){

            public String getDescription() {
                return "keep the specified AS3 metadata in the SWF.";
            }

            public boolean isAdvanced() {
                return true;
            }

            public boolean allowMultiple() {
                return true;
            }
        };
    }

    public boolean keepAllTypeSelectors() {
        return this.keepAllTypeSelectors;
    }

    public void cfgKeepAllTypeSelectors(ConfigurationValue cv, boolean keepAllTypeSelectors) {
        this.keepAllTypeSelectors = keepAllTypeSelectors;
    }

    public void setKeepAllTypeSelectors(boolean keepAllTypeSelectors) {
        this.keepAllTypeSelectors = keepAllTypeSelectors;
    }

    public static ConfigurationInfo getKeepAllTypeSelectorsInfo() {
        return new ConfigurationInfo(){

            public String getDescription() {
                return "disables the pruning of unused type selectors";
            }

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public void setKeepDebugOpcodes(boolean keepDebugOpcodes) {
        this.verboseStacktraces = keepDebugOpcodes;
    }

    public boolean debug() {
        return this.verboseStacktraces;
    }

    public void cfgDebug(ConfigurationValue cv, boolean generateDebugTags) {
        this.generateDebugTags = generateDebugTags;
    }

    public void setGenerateDebugTags(boolean generateDebugTags) {
        this.generateDebugTags = generateDebugTags;
    }

    public boolean generateDebugTags() {
        return this.generateDebugTags;
    }

    public boolean accessible() {
        return this.accessible;
    }

    public void cfgAccessible(ConfigurationValue cv, boolean accessible) {
        this.accessible = accessible;
    }

    public static ConfigurationInfo getAccessibleInfo() {
        return new ConfigurationInfo(){

            public String getDescription() {
                return "generate an accessible SWF";
            }
        };
    }

    public void setAccessible(boolean accessible) {
        this.accessible = accessible;
    }

    public boolean headlessServer() {
        return this.headlessServer;
    }

    public void cfgHeadlessServer(ConfigurationValue cv, boolean headlessServer) {
        this.headlessServer = headlessServer;
    }

    public static ConfigurationInfo getHeadlessServerInfo() {
        return new ConfigurationInfo(){

            public String getDescription() {
                return "a flag to set when Flex is running on a server without a display";
            }

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public String getGeneratedDirectory() {
        return this.generatedDir;
    }

    public void setGeneratedDirectory(String gd) {
        this.generatedDir = gd;
    }

    public boolean keepGeneratedActionScript() {
        return this.keepGeneratedActionScript;
    }

    public void setKeepGeneratedActionScript(boolean keepGeneratedActionScript) {
        this.keepGeneratedActionScript = keepGeneratedActionScript;
    }

    public void cfgKeepGeneratedActionscript(ConfigurationValue cv, boolean keep) {
        this.keepGeneratedActionScript = keep;
    }

    public static ConfigurationInfo getKeepGeneratedActionscriptInfo() {
        return new ConfigurationInfo(){

            public boolean isAdvanced() {
                return true;
            }

            public String getDescription() {
                return "save temporary source files generated during MXML compilation";
            }
        };
    }

    public boolean showDeprecationWarnings() {
        return this.showDeprecationWarnings;
    }

    public void setShowDeprecationWarnings(boolean showDeprecationWarnings) {
        this.showDeprecationWarnings = showDeprecationWarnings;
    }

    public void cfgShowDeprecationWarnings(ConfigurationValue cv, boolean show) {
        this.showDeprecationWarnings = show;
    }

    public static ConfigurationInfo getShowDeprecationWarningsInfo() {
        return new ConfigurationInfo(){

            public String getDescription() {
                return "toggle whether the use of deprecated APIs generates a warning";
            }
        };
    }

    public boolean showUnusedTypeSelectorWarnings() {
        return this.showUnusedTypeSelectorWarnings;
    }

    public void setShowUnusedTypeSelectorWarnings(boolean showUnusedTypeSelectorWarnings) {
        this.showUnusedTypeSelectorWarnings = showUnusedTypeSelectorWarnings;
    }

    public void cfgShowUnusedTypeSelectorWarnings(ConfigurationValue cv, boolean show) {
        this.showUnusedTypeSelectorWarnings = show;
    }

    public static ConfigurationInfo getShowUnusedTypeSelectorWarningsInfo() {
        return new ConfigurationInfo(){

            public String getDescription() {
                return "toggle whether warnings generated from unused type selectors are displayed.";
            }
        };
    }

    public void cfgShowDependencyWarnings(ConfigurationValue cv, boolean show) {
        this.showDependencyWarnings = show;
    }

    public static ConfigurationInfo getShowDependencyWarningsInfo() {
        return new ConfigurationInfo(){

            public boolean isAdvanced() {
                return true;
            }

            public boolean isHidden() {
                return true;
            }

            public String getDescription() {
                return "show warnings when dependencies cannot be determined at compile time";
            }
        };
    }

    public boolean showDependencyWarnings() {
        return this.showDependencyWarnings;
    }

    public boolean showBindingWarnings() {
        return this.showBindingWarnings;
    }

    public void cfgShowBindingWarnings(ConfigurationValue cv, boolean show) {
        this.showBindingWarnings = show;
    }

    public static ConfigurationInfo getShowBindingWarningsInfo() {
        return new ConfigurationInfo(){

            public String getDescription() {
                return "toggle whether warnings generated from data binding code are displayed";
            }
        };
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public void setContextRoot(String contextRoot) {
        this.contextRoot = contextRoot;
    }

    public void cfgContextRoot(ConfigurationValue cv, String contextRoot) {
        this.contextRoot = contextRoot;
    }

    public static ConfigurationInfo getContextRootInfo() {
        return new ConfigurationInfo(1, "context-path"){

            public String getDescription() {
                return "path to replace {context.root} tokens for service channel endpoints";
            }
        };
    }

    public ServicesDependencies getServicesDependencies() {
        if (this.servicesDependencies == null && this.servicesConfigFile != null) {
            String servicesPath = this.servicesConfigFile.getName();
            this.servicesDependencies = new ServicesDependencies(servicesPath, null, this.getContextRoot());
        }
        return this.servicesDependencies;
    }

    public void setServicesDependencies(ServicesDependencies deps) {
        this.servicesDependencies = deps;
    }

    public VirtualFile getServices() {
        return this.servicesConfigFile;
    }

    public void cfgServices(ConfigurationValue cv, String servicesPath) throws ConfigurationException {
        try {
            this.servicesConfigFile = ConfigurationPathResolver.getVirtualFile(servicesPath, this.configResolver, cv);
        }
        catch (Throwable t) {
            throw new ConfigurationException.CannotOpen(servicesPath, cv.getVar(), cv.getSource(), cv.getLine());
        }
    }

    public static ConfigurationInfo getServicesInfo() {
        return new ConfigurationInfo(1, "filename"){

            public String getDescription() {
                return "path to Flex Data Services configuration file";
            }
        };
    }

    public void cfgTheme(ConfigurationValue cv, List paths) throws ConfigurationException {
        VirtualFile[] vfa = new VirtualFile[paths.size()];
        int i = 0;
        Iterator it = paths.iterator();
        while (it.hasNext()) {
            String path = (String)it.next();
            VirtualFile theme = ConfigurationPathResolver.getVirtualFile(path, this.configResolver, cv);
            if (theme == null) {
                throw new ConfigurationException.ConfigurationIOError(path, cv.getVar(), cv.getSource(), cv.getLine());
            }
            vfa[i++] = theme;
        }
        this.themeFiles = this.mergeVirtualFileArrays(this.themeFiles, vfa);
    }

    public static ConfigurationInfo getThemeInfo() {
        return new ConfigurationInfo(-1, new String[]{"filename"}){

            public String getDescription() {
                return "list of CSS or SWC files to apply as a theme";
            }

            public boolean allowMultiple() {
                return true;
            }
        };
    }

    public VirtualFile[] getThemeFiles() {
        return this.themeFiles;
    }

    public List getThemeCssFiles() {
        return this.themeCssFiles;
    }

    public void addThemeCssFiles(List files) {
        this.themeCssFiles.addAll(files);
    }

    public VirtualFile getDefaultsCssUrl() {
        return this.defaultsCSSUrl;
    }

    public void cfgDefaultsCssUrl(ConfigurationValue cv, String defaultsCSSUrlPath) throws ConfigurationException {
        this.defaultsCSSUrl = ConfigurationPathResolver.getVirtualFile(defaultsCSSUrlPath, this.configResolver, cv);
    }

    public static ConfigurationInfo getDefaultsCssUrlInfo() {
        return new ConfigurationInfo(){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public VirtualFile[] getSourcePath() {
        return this.sourcePath;
    }

    public void setSourcePath(String[] sourcePath) throws ConfigurationException {
        this.cfgSourcePath(null, sourcePath);
    }

    public void cfgSourcePath(ConfigurationValue cfgval, String[] pathlist) throws ConfigurationException {
        ArrayList acList = this.getLocaleFileList(pathlist, cfgval, true);
        if (this.sourcePath != null && this.sourcePath.length != 0) {
            acList.addAll(Arrays.asList(this.sourcePath));
        }
        this.sourcePath = new VirtualFile[acList.size()];
        for (int i = 0; i < this.sourcePath.length; ++i) {
            VirtualFile virtualFile = (VirtualFile)acList.get(i);
            if (!virtualFile.isDirectory()) {
                if (cfgval == null) {
                    throw new ConfigurationException.NotDirectory(virtualFile.getName(), null, null, -1);
                }
                throw new ConfigurationException.NotDirectory(virtualFile.getName(), cfgval.getVar(), cfgval.getSource(), cfgval.getLine());
            }
            this.sourcePath[i] = virtualFile;
        }
    }

    private ArrayList getLocaleFileList(String[] pathlist, ConfigurationValue cfgval, boolean multiple) throws ConfigurationException {
        ArrayList<VirtualFile> acList = new ArrayList<VirtualFile>();
        for (int i = 0; i < pathlist.length; ++i) {
            int j = pathlist[i].indexOf(LOCALE_TOKEN);
            if (j != -1) {
                String loc = this.locale();
                boolean added = false;
                if (loc != null) {
                    added = this.addLocaleFile(loc, pathlist[i], cfgval, acList);
                    if (added && !multiple) continue;
                    int k = loc.lastIndexOf(95);
                    while (k > 0) {
                        loc = loc.substring(0, k);
                        boolean bl = added = added || this.addLocaleFile(loc, pathlist[i], cfgval, acList);
                        if (added && !multiple) continue;
                        k = loc.lastIndexOf(95);
                    }
                }
                if (loc == null || !this.locale().equals("en_US")) {
                    boolean bl = added = added || this.addLocaleFile("en_US", pathlist[i], cfgval, acList);
                }
                if (added) continue;
                if (cfgval == null) {
                    throw new ConfigurationException.CannotOpen(pathlist[i], null, null, -1);
                }
                throw new ConfigurationException.CannotOpen(pathlist[i], cfgval.getVar(), cfgval.getSource(), cfgval.getLine());
            }
            VirtualFile f = this.getVirtualFile(pathlist[i], cfgval);
            acList.add(f);
        }
        return acList;
    }

    private boolean addLocaleFile(String loc, String path, ConfigurationValue cfgval, ArrayList acList) {
        String newPath = StringUtils.substitute((String)path, (String)LOCALE_TOKEN, (String)loc);
        VirtualFile vf = null;
        try {
            vf = this.getVirtualFile(newPath, cfgval);
        }
        catch (ConfigurationException e) {
            // empty catch block
        }
        if (vf != null) {
            acList.add(vf);
            return true;
        }
        return false;
    }

    public static ConfigurationInfo getSourcePathInfo() {
        return new ConfigurationInfo(-1, new String[]{"path-element"}){

            public String getDescription() {
                return "list of path elements that form the roots of source hierarchies";
            }

            public boolean allowMultiple() {
                return true;
            }

            public String[] getSoftPrerequisites() {
                return new String[]{"locale"};
            }

            public boolean isPath() {
                return true;
            }
        };
    }

    private VirtualFile[] mergeVirtualFileArrays(VirtualFile[] a, VirtualFile[] b) {
        int alength = a == null ? 0 : a.length;
        int blength = b == null ? 0 : b.length;
        VirtualFile[] vfa = new VirtualFile[alength + blength];
        int count = 0;
        for (int ai = 0; ai < alength; ++ai) {
            vfa[count++] = a[ai];
        }
        for (int bi = 0; bi < blength; ++bi) {
            vfa[count++] = b[bi];
        }
        return vfa;
    }

    public VirtualFile[] getLibraryPath() {
        return this.libraryPath;
    }

    public void setLibraryPath(String[] libraryPath) throws ConfigurationException {
        this.cfgLibraryPath(null, libraryPath);
    }

    public void cfgLibraryPath(ConfigurationValue cfgval, String[] pathlist) throws ConfigurationException {
        ArrayList acList = this.getLocaleFileList(pathlist, cfgval, false);
        if (this.libraryPath != null && this.libraryPath.length != 0) {
            acList.addAll(Arrays.asList(this.libraryPath));
        }
        this.libraryPath = new VirtualFile[acList.size()];
        acList.toArray(this.libraryPath);
    }

    public static ConfigurationInfo getLibraryPathInfo() {
        return new ConfigurationInfo(-1, new String[]{"path-element"}){

            public String getDescription() {
                return "list of SWC files or directories that contain SWC files";
            }

            public boolean allowMultiple() {
                return true;
            }

            public String[] getSoftPrerequisites() {
                return new String[]{"locale"};
            }

            public boolean isPath() {
                return true;
            }
        };
    }

    Set getExterns() {
        return this.externs;
    }

    public void addExtern(String extern) {
        this.externs.add(extern);
    }

    public void cfgExternalLibraryPath(ConfigurationValue cfgval, String[] pathlist) throws ConfigurationException {
        this.externalLibraryPath = this.mergeVirtualFileArrays(this.externalLibraryPath, this.toVirtualFileArray(pathlist, cfgval));
    }

    public static ConfigurationInfo getExternalLibraryPathInfo() {
        return new ConfigurationInfo(-1, new String[]{"path-element"}){

            public String getDescription() {
                return "list of SWC files or directories to compile against but to omit from linking";
            }

            public boolean allowMultiple() {
                return true;
            }

            public boolean isPath() {
                return true;
            }
        };
    }

    public VirtualFile[] getExternalLibraryPath() {
        return this.externalLibraryPath;
    }

    public boolean strict() {
        return this.strict;
    }

    public void cfgStrict(ConfigurationValue cv, boolean strict) {
        this.strict = strict;
    }

    public static ConfigurationInfo getStrictInfo() {
        return new ConfigurationInfo(){

            public String getDescription() {
                return "runs the AS3 compiler in strict error checking mode";
            }
        };
    }

    public boolean warnings() {
        return this.ascWarnings;
    }

    public void cfgShowActionscriptWarnings(ConfigurationValue cv, boolean ascWarnings) {
        this.ascWarnings = ascWarnings;
    }

    public static ConfigurationInfo getShowActionscriptWarningsInfo() {
        return new ConfigurationInfo(){

            public String getDescription() {
                return "runs the AS3 compiler in a mode that detects legal but potentially incorrect code";
            }
        };
    }

    public String locale() {
        return this.locale;
    }

    public void cfgLocale(ConfigurationValue cv, String locale) {
        this.locale = locale;
    }

    public static ConfigurationInfo getLocaleInfo() {
        return new ConfigurationInfo(){

            public String getDescription() {
                return "specifies the locale for internationalization";
            }
        };
    }

    public VirtualFile[] getIncludeLibraries() {
        return this.includeLibraries;
    }

    public void setIncludeLibraries(VirtualFile[] includeLibraries) {
        this.includeLibraries = includeLibraries;
    }

    public void cfgIncludeLibraries(ConfigurationValue cv, List paths) throws ConfigurationException {
        VirtualFile[] vfa = new VirtualFile[paths.size()];
        int i = 0;
        Iterator it = paths.iterator();
        while (it.hasNext()) {
            String path = (String)it.next();
            VirtualFile include = ConfigurationPathResolver.getVirtualFile(path, this.configResolver, cv);
            vfa[i++] = include;
        }
        this.includeLibraries = this.mergeVirtualFileArrays(this.includeLibraries, vfa);
    }

    public static ConfigurationInfo getIncludeLibrariesInfo() {
        return new ConfigurationInfo(-1, new String[]{"library"}){

            public String getDescription() {
                return "a list of libraries (SWCs) to completely include in the SWF";
            }

            public boolean allowMultiple() {
                return true;
            }

            public boolean isPath() {
                return true;
            }
        };
    }

    public boolean doc() {
        return this.doc;
    }

    public void cfgDoc(ConfigurationValue cv, boolean doc) {
        this.doc = doc;
    }

    public static ConfigurationInfo getDocInfo() {
        return new ConfigurationInfo(){

            public boolean isAdvanced() {
                return true;
            }

            public boolean isHidden() {
                return true;
            }
        };
    }

    public String getTranslationFormat() {
        return this.translationFormat;
    }

    public void cfgTranslationFormat(ConfigurationValue cv, String t) {
        this.translationFormat = t;
    }

    public static ConfigurationInfo getTranslationFormatInfo() {
        return new ConfigurationInfo(){

            public boolean isHidden() {
                return true;
            }
        };
    }

    private VirtualFile[] toVirtualFileArray(String[] files, ConfigurationValue cfgval) throws ConfigurationException {
        VirtualFile[] vfiles = new VirtualFile[files != null ? files.length : 0];
        int length = vfiles.length;
        for (int i = 0; i < length; ++i) {
            vfiles[i] = this.getVirtualFile(files[i], cfgval);
        }
        return vfiles;
    }

    private VirtualFile getVirtualFile(String file, ConfigurationValue cfgval) throws ConfigurationException {
        return ConfigurationPathResolver.getVirtualFile(file, this.configResolver, cfgval);
    }

    public NamespacesConfiguration getNamespacesConfiguration() {
        return this.namespaces;
    }

    public boolean metadataExport() {
        return this.metadataExport;
    }

    public void setMetadataExport(boolean metadataExport) {
        this.metadataExport = metadataExport;
    }

    public void setFontsConfiguration(FontsConfiguration fc) {
        this.fontsConfig = fc;
        this.fontsConfig.setCompilerConfiguration(this);
    }

    public FontsConfiguration getFontsConfiguration() {
        return this.fontsConfig;
    }

    public void cfgIncremental(ConfigurationValue cv, boolean b) {
        this.incremental = b;
    }

    public boolean getIncremental() {
        return this.incremental;
    }

    public boolean incremental() {
        return this.incremental;
    }

    public static ConfigurationInfo getIncrementalInfo() {
        return new ConfigurationInfo(){

            public String getDescription() {
                return "enables incremental compilation";
            }
        };
    }

    public void cfgOptimize(ConfigurationValue cv, boolean b) {
        this.optimize = b;
    }

    public boolean getOptimize() {
        return this.optimize;
    }

    public boolean optimize() {
        return this.optimize;
    }

    public static ConfigurationInfo getOptimizeInfo() {
        return new ConfigurationInfo(){

            public String getDescription() {
                return "Enable post-link SWF optimization";
            }
        };
    }

    public void cfgWarnAssignmentWithinConditional(ConfigurationValue cv, boolean b) {
        this.warn_assignment_within_conditional = b;
    }

    public boolean warn_assignment_within_conditional() {
        return this.warn_assignment_within_conditional;
    }

    public static ConfigurationInfo getWarnAssignmentWithinConditionalInfo() {
        return new ConfigurationInfo(){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public void cfgWarnBadArrayCast(ConfigurationValue cv, boolean b) {
        this.warn_bad_array_cast = b;
    }

    public boolean warn_bad_array_cast() {
        return this.warn_bad_array_cast;
    }

    public static ConfigurationInfo getWarnBadArrayCastInfo() {
        return new ConfigurationInfo(){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public void cfgWarnBadBoolAssignment(ConfigurationValue cv, boolean b) {
        this.warn_bad_bool_assignment = b;
    }

    public boolean warn_bad_bool_assignment() {
        return this.warn_bad_bool_assignment;
    }

    public static ConfigurationInfo getWarnBadBoolAssignmentInfo() {
        return new ConfigurationInfo(){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public void cfgWarnBadDateCast(ConfigurationValue cv, boolean b) {
        this.warn_bad_date_cast = b;
    }

    public boolean warn_bad_date_cast() {
        return this.warn_bad_date_cast;
    }

    public static ConfigurationInfo getWarnBadDateCastInfo() {
        return new ConfigurationInfo(){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public void cfgWarnBadEs3TypeMethod(ConfigurationValue cv, boolean b) {
        this.warn_bad_es3_type_method = b;
    }

    public boolean warn_bad_es3_type_method() {
        return this.warn_bad_es3_type_method;
    }

    public static ConfigurationInfo getWarnBadEs3TypeMethodInfo() {
        return new ConfigurationInfo(){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public void cfgWarnBadEs3TypeProp(ConfigurationValue cv, boolean b) {
        this.warn_bad_es3_type_prop = b;
    }

    public boolean warn_bad_es3_type_prop() {
        return this.warn_bad_es3_type_prop;
    }

    public static ConfigurationInfo getWarnBadEs3TypePropInfo() {
        return new ConfigurationInfo(){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public void cfgWarnBadNanComparison(ConfigurationValue cv, boolean b) {
        this.warn_bad_nan_comparison = b;
    }

    public boolean warn_bad_nan_comparison() {
        return this.warn_bad_nan_comparison;
    }

    public static ConfigurationInfo getWarnBadNanComparisonInfo() {
        return new ConfigurationInfo(){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public void cfgWarnBadNullAssignment(ConfigurationValue cv, boolean b) {
        this.warn_bad_null_assignment = b;
    }

    public boolean warn_bad_null_assignment() {
        return this.warn_bad_null_assignment;
    }

    public static ConfigurationInfo getWarnBadNullAssignmentInfo() {
        return new ConfigurationInfo(){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public void cfgWarnBadNullComparison(ConfigurationValue cv, boolean b) {
        this.warn_bad_null_comparison = b;
    }

    public boolean warn_bad_null_comparison() {
        return this.warn_bad_null_comparison;
    }

    public static ConfigurationInfo getWarnBadNullComparisonInfo() {
        return new ConfigurationInfo(){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public void cfgWarnBadUndefinedComparison(ConfigurationValue cv, boolean b) {
        this.warn_bad_undefined_comparison = b;
    }

    public boolean warn_bad_undefined_comparison() {
        return this.warn_bad_undefined_comparison;
    }

    public static ConfigurationInfo getWarnBadUndefinedComparisonInfo() {
        return new ConfigurationInfo(){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public void cfgWarnChangesInResolve(ConfigurationValue cv, boolean b) {
        this.warn_changes_in_resolve = b;
    }

    public boolean warn_changes_in_resolve() {
        return this.warn_changes_in_resolve;
    }

    public static ConfigurationInfo getWarnChangesInResolveInfo() {
        return new ConfigurationInfo(){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public void cfgWarnConstNotInitialized(ConfigurationValue cv, boolean b) {
        this.warn_const_not_initialized = b;
    }

    public boolean warn_const_not_initialized() {
        return this.warn_const_not_initialized;
    }

    public static ConfigurationInfo getWarnConstNotInitializedInfo() {
        return new ConfigurationInfo(){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public void cfgWarnDuplicateArgumentNames(ConfigurationValue cv, boolean b) {
        this.warn_duplicate_argument_names = b;
    }

    public boolean warn_duplicate_argument_names() {
        return this.warn_duplicate_argument_names;
    }

    public static ConfigurationInfo getWarnDuplicateArgumentNamesInfo() {
        return new ConfigurationInfo(){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public void cfgWarnDuplicateVariableDef(ConfigurationValue cv, boolean b) {
        this.warn_duplicate_variable_def = b;
    }

    public boolean warn_duplicate_variable_def() {
        return this.warn_duplicate_variable_def;
    }

    public static ConfigurationInfo getWarnDuplicateVariableDefInfo() {
        return new ConfigurationInfo(){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public void cfgWarnImportHidesClass(ConfigurationValue cv, boolean b) {
        this.warn_import_hides_class = b;
    }

    public boolean warn_import_hides_class() {
        return this.warn_import_hides_class;
    }

    public static ConfigurationInfo getWarnImportHidesClassInfo() {
        return new ConfigurationInfo(){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public void cfgWarnInstanceOfChanges(ConfigurationValue cv, boolean b) {
        this.warn_instance_of_changes = b;
    }

    public boolean warn_instance_of_changes() {
        return this.warn_instance_of_changes;
    }

    public static ConfigurationInfo getWarnInstanceOfChangesInfo() {
        return new ConfigurationInfo(){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public void cfgWarnInternalError(ConfigurationValue cv, boolean b) {
        this.warn_internal_error = b;
    }

    public boolean warn_internal_error() {
        return this.warn_internal_error;
    }

    public static ConfigurationInfo getWarnInternalErrorInfo() {
        return new ConfigurationInfo(){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public void cfgWarnLevelNotSupported(ConfigurationValue cv, boolean b) {
        this.warn_level_not_supported = b;
    }

    public boolean warn_level_not_supported() {
        return this.warn_level_not_supported;
    }

    public static ConfigurationInfo getWarnLevelNotSupportedInfo() {
        return new ConfigurationInfo(){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public void cfgWarnNegativeUintLiteral(ConfigurationValue cv, boolean b) {
        this.warn_negative_uint_literal = b;
    }

    public boolean warn_negative_uint_literal() {
        return this.warn_negative_uint_literal;
    }

    public static ConfigurationInfo getWarnNegativeUintLiteralInfo() {
        return new ConfigurationInfo(){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public void cfgWarnNumberFromStringChanges(ConfigurationValue cv, boolean b) {
        this.warn_number_from_string_changes = b;
    }

    public boolean warn_number_from_string_changes() {
        return this.warn_number_from_string_changes;
    }

    public static ConfigurationInfo getWarnNumberFromStringChangesInfo() {
        return new ConfigurationInfo(){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public void cfgWarnSlowTextFieldAddition(ConfigurationValue cv, boolean b) {
        this.warn_slow_text_field_addition = b;
    }

    public boolean warn_slow_text_field_addition() {
        return this.warn_slow_text_field_addition;
    }

    public static ConfigurationInfo getWarnSlowTextFieldAdditionInfo() {
        return new ConfigurationInfo(){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public void cfgWarnUnlikelyFunctionValue(ConfigurationValue cv, boolean b) {
        this.warn_unlikely_function_value = b;
    }

    public boolean warn_unlikely_function_value() {
        return this.warn_unlikely_function_value;
    }

    public static ConfigurationInfo getWarnUnlikelyFunctionValueInfo() {
        return new ConfigurationInfo(){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public void cfgWarnNoTypeDecl(ConfigurationValue cv, boolean b) {
        this.warn_no_type_decl = b;
    }

    public boolean warn_no_type_decl() {
        return this.warn_no_type_decl;
    }

    public static ConfigurationInfo getWarnNoTypeDeclInfo() {
        return new ConfigurationInfo(){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public void cfgWarnConstructorReturnsValue(ConfigurationValue cv, boolean b) {
        this.warn_constructor_returns_value = b;
    }

    public boolean warn_constructor_returns_value() {
        return this.warn_constructor_returns_value;
    }

    public static ConfigurationInfo getWarnConstructorReturnsValueInfo() {
        return new ConfigurationInfo(){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public void cfgWarnBooleanConstructorWithNoArgs(ConfigurationValue cv, boolean b) {
        this.warn_boolean_constructor_with_no_args = b;
    }

    public boolean warn_boolean_constructor_with_no_args() {
        return this.warn_boolean_constructor_with_no_args;
    }

    public static ConfigurationInfo getWarnBooleanConstructorWithNoArgsInfo() {
        return new ConfigurationInfo(){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public void cfgWarnArrayTostringChanges(ConfigurationValue cv, boolean b) {
        this.warn_array_tostring_changes = b;
    }

    public boolean warn_array_tostring_changes() {
        return this.warn_array_tostring_changes;
    }

    public static ConfigurationInfo getWarnArrayTostringChangesInfo() {
        return new ConfigurationInfo(){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public void cfgWarnDeprecatedPropertyError(ConfigurationValue cv, boolean b) {
        this.warn_deprecated_property_error = b;
    }

    public boolean warn_deprecated_property_error() {
        return this.warn_deprecated_property_error;
    }

    public static ConfigurationInfo getWarnDeprecatedPropertyErrorInfo() {
        return new ConfigurationInfo(){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public void cfgWarnDeprecatedFunctionError(ConfigurationValue cv, boolean b) {
        this.warn_deprecated_function_error = b;
    }

    public boolean warn_deprecated_function_error() {
        return this.warn_deprecated_function_error;
    }

    public static ConfigurationInfo getWarnDeprecatedFunctionErrorInfo() {
        return new ConfigurationInfo(){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public void cfgWarnClassIsSealed(ConfigurationValue cv, boolean b) {
        this.warn_class_is_sealed = b;
    }

    public boolean warn_class_is_sealed() {
        return this.warn_class_is_sealed;
    }

    public static ConfigurationInfo getWarnClassIsSealedInfo() {
        return new ConfigurationInfo(){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public void cfgWarnScopingChangeInThis(ConfigurationValue cv, boolean b) {
        this.warn_scoping_change_in_this = b;
    }

    public boolean warn_scoping_change_in_this() {
        return this.warn_scoping_change_in_this;
    }

    public static ConfigurationInfo getWarnScopingChangeInThisInfo() {
        return new ConfigurationInfo(){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public void cfgWarnMissingNamespaceDecl(ConfigurationValue cv, boolean b) {
        this.warn_missing_namespace_decl = b;
    }

    public boolean warn_missing_namespace_decl() {
        return this.warn_missing_namespace_decl;
    }

    public static ConfigurationInfo getWarnMissingNamespaceDeclInfo() {
        return new ConfigurationInfo(){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public void cfgWarnForVarInChanges(ConfigurationValue cv, boolean b) {
        this.warn_for_var_in_changes = b;
    }

    public boolean warn_for_var_in_changes() {
        return this.warn_for_var_in_changes;
    }

    public static ConfigurationInfo getWarnForVarInChangesInfo() {
        return new ConfigurationInfo(){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public void cfgWarnDeprecatedEventHandlerError(ConfigurationValue cv, boolean b) {
        this.warn_deprecated_event_handler_error = b;
    }

    public boolean warn_deprecated_event_handler_error() {
        return this.warn_deprecated_event_handler_error;
    }

    public static ConfigurationInfo getWarnDeprecatedEventHandlerErrorInfo() {
        return new ConfigurationInfo(){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public void cfgWarnNoConstructor(ConfigurationValue cv, boolean b) {
        this.warn_no_constructor = b;
    }

    public boolean warn_no_constructor() {
        return this.warn_no_constructor;
    }

    public static ConfigurationInfo getWarnNoConstructorInfo() {
        return new ConfigurationInfo(){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public void cfgWarnNoExplicitSuperCallInConstructor(ConfigurationValue cv, boolean b) {
        this.warn_no_explicit_super_call_in_constructor = b;
    }

    public boolean warn_no_explicit_super_call_in_constructor() {
        return this.warn_no_explicit_super_call_in_constructor;
    }

    public static ConfigurationInfo getWarnNoExplicitSuperCallInConstructorInfo() {
        return new ConfigurationInfo(){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public void cfgWarnXmlClassHasChanged(ConfigurationValue cv, boolean b) {
        this.warn_xml_class_has_changed = b;
    }

    public boolean warn_xml_class_has_changed() {
        return this.warn_xml_class_has_changed;
    }

    public static ConfigurationInfo getWarnXmlClassHasChangedInfo() {
        return new ConfigurationInfo(){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public void cfgAllowSourcePathOverlap(ConfigurationValue cv, boolean b) {
        this.allowSourcePathOverlap = b;
    }

    public boolean allowSourcePathOverlap() {
        return this.allowSourcePathOverlap;
    }

    public static ConfigurationInfo getAllowSourcePathOverlapInfo() {
        return new ConfigurationInfo(){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public void setSuppressWarningsInIncremental(boolean b) {
        this.suppressWarningsInIncremental = b;
    }

    public boolean suppressWarningsInIncremental() {
        return this.suppressWarningsInIncremental;
    }

    public void cfgActionscriptFileEncoding(ConfigurationValue cv, String encoding) {
        this.actionscriptFileEncoding = encoding;
    }

    public String getActionscriptFileEncoding() {
        return this.actionscriptFileEncoding;
    }

    public String getEncoding() {
        return this.getActionscriptFileEncoding();
    }

    public static ConfigurationInfo getActionscriptFileEncodingInfo() {
        return new ConfigurationInfo(){

            public String getDescription() {
                return "specifies actionscript file encoding. If there is no BOM in the AS3 source files, the compiler will use this file encoding.";
            }
        };
    }

    public void cfgConservative(ConfigurationValue cv, boolean c) {
        this.useConservativeAlgorithm = c;
    }

    public boolean useConservativeAlgorithm() {
        return this.useConservativeAlgorithm;
    }

    public static ConfigurationInfo getConservativeInfo() {
        return new ConfigurationInfo(){

            public boolean isHidden() {
                return true;
            }

            public boolean isAdvanced() {
                return true;
            }

            public String getDescription() {
                return "uses the conservative algorithm to compile. not recommended for large applications. default is false.";
            }
        };
    }

    public void cfgMemoryUsageFactor(ConfigurationValue cv, int f) {
        this.factor = f;
    }

    public int factor() {
        return this.factor;
    }

    public static ConfigurationInfo getMemoryUsageFactorInfo() {
        return new ConfigurationInfo(){

            public boolean isHidden() {
                return true;
            }

            public boolean isAdvanced() {
                return true;
            }

            public String getDescription() {
                return "specifies the compiler's memory usage factor, default is 1000.";
            }
        };
    }

    public void cfgUseResourceBundleMetadata(ConfigurationValue cv, boolean b) {
        this.useResourceBundleMetadata = b;
    }

    public boolean useResourceBundleMetadata() {
        return this.useResourceBundleMetadata;
    }

    public static ConfigurationInfo getuseResourceBundleMetadataInfo() {
        return new ConfigurationInfo(){

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public int dialect() {
        return this.dialect;
    }

    public void cfgAs3(ConfigurationValue cv, boolean b) {
        this.dialect = b ? 10 : 9;
    }

    public static ConfigurationInfo getAs3Info() {
        return new ConfigurationInfo(){

            public String getDescription() {
                return "uses ActionScript 3 compatibility mode.";
            }

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public void cfgEs(ConfigurationValue cv, boolean b) {
        this.dialect = b ? 9 : 10;
    }

    public static ConfigurationInfo getEsInfo() {
        return new ConfigurationInfo(){

            public String getDescription() {
                return "uses EcmaScript compatibility mode.";
            }

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public void cfgAdjustOpdebugline(ConfigurationValue cv, boolean b) {
        this.adjustOpDebugLine = b;
    }

    public boolean adjustOpDebugLine() {
        return this.adjustOpDebugLine;
    }

    public static ConfigurationInfo getAdjustOpdebuglineInfo() {
        return new ConfigurationInfo(){

            public boolean isAdvanced() {
                return true;
            }

            public boolean isHidden() {
                return true;
            }

            public String getDescription() {
                return "do not adjust line numbers for MXML components.";
            }
        };
    }
}

