/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.asdoc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class PumpStreamHandler {
    private Thread outputThread;
    private Thread errorThread;
    private StreamPumper inputPump;
    private OutputStream out;
    private OutputStream err;
    private InputStream input;

    public PumpStreamHandler(OutputStream out, OutputStream err, InputStream input) {
        this.out = out;
        this.err = err;
        this.input = input;
    }

    public PumpStreamHandler(OutputStream out, OutputStream err) {
        this(out, err, null);
    }

    public PumpStreamHandler(OutputStream outAndErr) {
        this(outAndErr, outAndErr);
    }

    public PumpStreamHandler() {
        this(System.out, System.err);
    }

    public void setProcessOutputStream(InputStream is) {
        this.createProcessOutputPump(is, this.out);
    }

    public void setProcessErrorStream(InputStream is) {
        if (this.err != null) {
            this.createProcessErrorPump(is, this.err);
        }
    }

    public void setProcessInputStream(OutputStream os) {
        if (this.input != null) {
            this.inputPump = this.createInputPump(this.input, os, true);
        } else {
            try {
                os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void start() {
        this.outputThread.start();
        this.errorThread.start();
        if (this.inputPump != null) {
            Thread inputThread = new Thread(this.inputPump);
            inputThread.setDaemon(true);
            inputThread.start();
        }
    }

    public void stop() {
        try {
            this.outputThread.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            this.errorThread.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (this.inputPump != null) {
            this.inputPump.stop();
        }
        try {
            this.err.flush();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected OutputStream getErr() {
        return this.err;
    }

    protected OutputStream getOut() {
        return this.out;
    }

    protected void createProcessOutputPump(InputStream is, OutputStream os) {
        this.outputThread = this.createPump(is, os);
    }

    protected void createProcessErrorPump(InputStream is, OutputStream os) {
        this.errorThread = this.createPump(is, os);
    }

    protected Thread createPump(InputStream is, OutputStream os) {
        return this.createPump(is, os, false);
    }

    protected Thread createPump(InputStream is, OutputStream os, boolean closeWhenExhausted) {
        Thread result = new Thread(new StreamPumper(is, os, closeWhenExhausted));
        result.setDaemon(true);
        return result;
    }

    StreamPumper createInputPump(InputStream is, OutputStream os, boolean closeWhenExhausted) {
        StreamPumper pumper = new StreamPumper(is, os, closeWhenExhausted);
        pumper.setAutoflush(true);
        return pumper;
    }

    public class StreamPumper
    implements Runnable {
        private static final int SIZE = 128;
        private InputStream is;
        private OutputStream os;
        private boolean finished;
        private boolean closeWhenExhausted;
        private boolean autoflush = false;

        public StreamPumper(InputStream is, OutputStream os, boolean closeWhenExhausted) {
            this.is = is;
            this.os = os;
            this.closeWhenExhausted = closeWhenExhausted;
        }

        public StreamPumper(InputStream is, OutputStream os) {
            this(is, os, false);
        }

        void setAutoflush(boolean autoflush) {
            this.autoflush = autoflush;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block21: {
                int length;
                StreamPumper streamPumper = this;
                synchronized (streamPumper) {
                    this.finished = false;
                }
                byte[] buf = new byte[128];
                while ((length = this.is.read(buf)) > 0 && !this.finished) {
                    this.os.write(buf, 0, length);
                    if (!this.autoflush) continue;
                    this.os.flush();
                }
                Object var5_4 = null;
                if (!this.closeWhenExhausted) break block21;
                try {
                    this.os.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            StreamPumper streamPumper = this;
            synchronized (streamPumper) {
                this.finished = true;
                this.notifyAll();
            }
            {
                catch (Exception exception) {
                    Object var5_5 = null;
                    if (this.closeWhenExhausted) {
                        try {
                            this.os.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    StreamPumper streamPumper2 = this;
                    synchronized (streamPumper2) {
                        this.finished = true;
                        this.notifyAll();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (this.closeWhenExhausted) {
                    try {
                        this.os.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                StreamPumper streamPumper3 = this;
                synchronized (streamPumper3) {
                    this.finished = true;
                    this.notifyAll();
                }
                throw throwable;
            }
        }

        public synchronized boolean isFinished() {
            return this.finished;
        }

        public synchronized void waitFor() throws InterruptedException {
            while (!this.isFinished()) {
                this.wait();
            }
        }

        synchronized void stop() {
            this.finished = true;
            this.notifyAll();
        }
    }
}

