/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.as3.reflect;

import flex2.compiler.SymbolTable;
import flex2.compiler.abc.Attributes;
import flex2.compiler.as3.reflect.Class;
import flex2.compiler.as3.reflect.MetaData;
import flex2.compiler.as3.reflect.Method;
import flex2.compiler.as3.reflect.Variable;
import flex2.compiler.util.QNameList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.DefinitionNode;
import macromedia.asc.parser.FunctionDefinitionNode;
import macromedia.asc.parser.MetaDataNode;
import macromedia.asc.parser.ParameterListNode;
import macromedia.asc.parser.ParameterNode;
import macromedia.asc.parser.VariableBindingNode;
import macromedia.asc.parser.VariableDefinitionNode;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.QName;
import macromedia.asc.semantics.ReferenceValue;
import macromedia.asc.semantics.TypeValue;
import macromedia.asc.util.ObjectList;

public class TypeTable {
    private SymbolTable symbolTable;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TypeTable(SymbolTable symbolTable) {
        this.symbolTable = symbolTable;
    }

    public flex2.compiler.abc.Class getClass(String className) {
        return this.symbolTable.getClass(className);
    }

    public SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public static String convertName(ReferenceValue typeref) {
        ObjectValue ns = (ObjectValue)typeref.namespaces.first();
        if (ns != null && ns.name.length() > 0) {
            StringBuffer value = new StringBuffer(ns.name.length() + 1 + typeref.name.length());
            value.append(ns.name).append(':').append(typeref.name);
            return value.toString();
        }
        return typeref.name;
    }

    public static String convertName(String name) {
        return name.intern();
    }

    public final Map createClasses(ObjectList clsdefs, QNameList toplevelDefinitions) {
        HashMap classes = new HashMap();
        int size = clsdefs.size();
        for (int i = 0; i < size; ++i) {
            ClassDefinitionNode clsdef = (ClassDefinitionNode)clsdefs.get(i);
            QName qName = clsdef.cframe.builder.classname;
            if (!toplevelDefinitions.contains(qName.ns.name, qName.name)) continue;
            this.createClass(clsdef, classes);
        }
        return classes;
    }

    final void createClass(ClassDefinitionNode clsdef, Map classes) {
        Class cls = new Class(clsdef, this);
        classes.put(cls.getName(), cls);
    }

    static void createMethod(FunctionDefinitionNode f, Map methods, Class declaringClass) {
        Method method = new Method(f, declaringClass);
        String namespace = TypeTable.getNamespace(method.getAttributes());
        if (methods.put(new flex2.compiler.util.QName(namespace, method.getName()), method) != null) {
            // empty if block
        }
    }

    static void createVariable(VariableDefinitionNode var, Map variables, Class declaringClass) {
        List meta = TypeTable.createMetaData((DefinitionNode)var);
        int len = var.list.items.size();
        for (int k = 0; k < len; ++k) {
            VariableBindingNode binding = (VariableBindingNode)var.list.items.get(k);
            Variable variable = new Variable(var.attrs, binding, meta, declaringClass);
            String namespace = TypeTable.getNamespace(variable.getAttributes());
            variables.put(new flex2.compiler.util.QName(namespace, variable.getName()), variable);
        }
    }

    static void createParameters(ParameterListNode params, String[] names, String[] typeNames, boolean[] hasDefault) {
        int size = params.size();
        for (int i = 0; i < size; ++i) {
            ParameterNode item = (ParameterNode)params.items.get(i);
            names[i] = item.ref != null ? item.ref.name : "";
            boolean bl = hasDefault[i] = item.init != null;
            if (params.types != null && i < params.types.size()) {
                TypeValue paramType = (TypeValue)params.types.get(i);
                typeNames[i] = TypeTable.convertName(paramType.name.toString());
                continue;
            }
            ParameterNode param = (ParameterNode)params.items.get(i);
            if (param != null && param.typeref != null) {
                typeNames[i] = TypeTable.convertName(param.typeref);
                continue;
            }
            if (param != null) {
                typeNames[i] = "*";
                continue;
            }
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Expected ParameterNode...");
            }
        }
    }

    static List createMetaData(DefinitionNode def) {
        int size;
        ArrayList<MetaData> list = null;
        int n = size = def.metaData != null ? def.metaData.items.size() : 0;
        for (int i = 0; i < size; ++i) {
            MetaDataNode n2 = (MetaDataNode)def.metaData.items.get(i);
            if (list == null) {
                list = new ArrayList<MetaData>();
            }
            list.add(new MetaData(n2));
        }
        return list;
    }

    private static String getNamespace(Attributes attributes) {
        Iterator iterator;
        String result = "";
        if (attributes != null && (iterator = attributes.getNamespaces()) != null && iterator.hasNext()) {
            result = (String)iterator.next();
        }
        return result;
    }

    static {
        $assertionsDisabled = !TypeTable.class.desiredAssertionStatus();
    }
}

