/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.as3.reflect;

import flex2.compiler.CompilationUnit;
import flex2.compiler.as3.reflect.Variable;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.LineNumberMap;
import flex2.compiler.util.QName;
import flex2.compiler.util.ThreadLocalToolkit;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.DefinitionNode;
import macromedia.asc.parser.DocCommentNode;
import macromedia.asc.parser.FunctionDefinitionNode;
import macromedia.asc.parser.GetExpressionNode;
import macromedia.asc.parser.IdentifierNode;
import macromedia.asc.parser.ImportDirectiveNode;
import macromedia.asc.parser.ListNode;
import macromedia.asc.parser.LiteralStringNode;
import macromedia.asc.parser.MemberExpressionNode;
import macromedia.asc.parser.MetaDataNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.NodeFactory;
import macromedia.asc.parser.PackageIdentifiersNode;
import macromedia.asc.parser.PackageNameNode;
import macromedia.asc.parser.ParameterListNode;
import macromedia.asc.parser.ParameterNode;
import macromedia.asc.parser.ProgramNode;
import macromedia.asc.parser.QualifiedIdentifierNode;
import macromedia.asc.parser.StatementListNode;
import macromedia.asc.parser.VariableBindingNode;
import macromedia.asc.parser.VariableDefinitionNode;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.util.Context;
import macromedia.asc.util.Multinames;
import macromedia.asc.util.Namespaces;

public class NodeMagic {
    public static final String CONST = "const";
    public static final String DYNAMIC = "dynamic";
    public static final String FINAL = "final";
    public static final String INTERNAL = "internal";
    public static final String INTRINSIC = "intrinsic";
    public static final String NATIVE = "native";
    public static final String OVERRIDE = "override";
    public static final String PRIVATE = "private";
    public static final String PROTECTED = "protected";
    public static final String PROTOTYPE = "prototype";
    public static final String PUBLIC = "public";
    public static final String STATIC = "static";
    public static final String VIRTUAL = "virtual";
    static final /* synthetic */ boolean $assertionsDisabled;

    public static String getVariableName(VariableDefinitionNode node) {
        return Variable.variableName(NodeMagic.getVariableBinding(node));
    }

    public static VariableBindingNode getVariableBinding(VariableDefinitionNode node) {
        return (VariableBindingNode)node.list.items.get(0);
    }

    public static void setVariableBindingName(VariableBindingNode node, String name) {
        node.variable.identifier.name = name.intern();
    }

    public static String getVariableTypeName(VariableDefinitionNode node) {
        VariableBindingNode variableBinding = (VariableBindingNode)node.list.items.get(0);
        MemberExpressionNode memberExpression = (MemberExpressionNode)variableBinding.variable.type;
        return NodeMagic.getTypeName(memberExpression);
    }

    private static String typeNameFromSelector(GetExpressionNode getExpression) {
        String result = null;
        IdentifierNode identifier = (IdentifierNode)getExpression.expr;
        if (identifier instanceof QualifiedIdentifierNode) {
            QualifiedIdentifierNode qualifiedIdentifier = (QualifiedIdentifierNode)identifier;
            if (qualifiedIdentifier.qualifier != null && qualifiedIdentifier.qualifier instanceof LiteralStringNode) {
                LiteralStringNode literalString = (LiteralStringNode)qualifiedIdentifier.qualifier;
                if (literalString.value != null && literalString.value.length() > 0) {
                    result = literalString.value + "." + qualifiedIdentifier.name;
                } else if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"Empty LiteralStringNode");
                }
            } else if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Empty QualifiedIdentifierNode");
            }
        }
        if (result == null) {
            result = identifier.name;
        }
        return result;
    }

    private static void addIdentifier(List list, IdentifierNode identifier) {
        if (identifier.name.equals(OVERRIDE)) {
            list.add(0, OVERRIDE);
        } else {
            list.add(identifier.name);
        }
    }

    public static void addImport(Context context, ClassDefinitionNode node, String packageName) {
        NodeFactory nodeFactory = new NodeFactory(context);
        PackageIdentifiersNode packageIdentifiers = null;
        StringTokenizer stringTokenizer = new StringTokenizer(packageName, ".");
        while (stringTokenizer.hasMoreTokens()) {
            String token = stringTokenizer.nextToken();
            IdentifierNode identifier = nodeFactory.identifier(token);
            packageIdentifiers = nodeFactory.packageIdentifiers(packageIdentifiers, identifier, true);
        }
        PackageNameNode packageNameNode = nodeFactory.packageName(packageIdentifiers);
        ImportDirectiveNode importDirective = nodeFactory.importDirective(null, packageNameNode, null, context);
        importDirective.pkgdef = node.pkgdef;
        if (node.statements == null) {
            node.statements = new StatementListNode(null);
        }
        node.statements.items.add(0, (Object)importDirective);
    }

    public static List getMetaData(DefinitionNode definition) {
        LinkedList list = new LinkedList();
        if (definition.metaData != null && definition.metaData.items != null) {
            list.addAll(definition.metaData.items);
        }
        return list;
    }

    public static List getAttributes(DefinitionNode definition) {
        ArrayList result = new ArrayList();
        if (definition.attrs != null) {
            Iterator attrsIterator = definition.attrs.items.iterator();
            while (attrsIterator.hasNext()) {
                Object attrsNode = attrsIterator.next();
                if (attrsNode instanceof ListNode) {
                    Iterator listIterator = ((ListNode)attrsNode).items.iterator();
                    while (listIterator.hasNext()) {
                        Object listNode = listIterator.next();
                        if (!(listNode instanceof MemberExpressionNode)) continue;
                        MemberExpressionNode memberExpression = (MemberExpressionNode)listNode;
                        if (!(memberExpression.selector instanceof GetExpressionNode)) continue;
                        GetExpressionNode getExpression = (GetExpressionNode)memberExpression.selector;
                        if (!(getExpression.expr instanceof IdentifierNode)) continue;
                        NodeMagic.addIdentifier(result, (IdentifierNode)getExpression.expr);
                    }
                    continue;
                }
                if (!(attrsNode instanceof IdentifierNode)) continue;
                NodeMagic.addIdentifier(result, (IdentifierNode)attrsNode);
            }
        }
        return result;
    }

    public static Set getImports(Multinames multiNames) {
        HashSet<String> result = new HashSet<String>();
        Iterator iterator = multiNames.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String className = (String)entry.getKey();
            Namespaces namespaces = (Namespaces)entry.getValue();
            if (namespaces.isEmpty()) {
                result.add(className);
                continue;
            }
            Iterator namespaceIterator = namespaces.iterator();
            while (namespaceIterator.hasNext()) {
                ObjectValue objectValue = (ObjectValue)namespaceIterator.next();
                String packageName = objectValue.toString();
                if (packageName.length() > 0) {
                    result.add(packageName + "." + className);
                    continue;
                }
                result.add(className);
            }
        }
        return result;
    }

    public static QName getQName(QualifiedIdentifierNode qualifiedIdentifier) {
        String namespaceURI = null;
        if (qualifiedIdentifier.qualifier instanceof MemberExpressionNode) {
            MemberExpressionNode memberExpression = (MemberExpressionNode)qualifiedIdentifier.qualifier;
            if (memberExpression.selector instanceof GetExpressionNode) {
                GetExpressionNode getExpression = (GetExpressionNode)memberExpression.selector;
                if (getExpression.expr instanceof IdentifierNode) {
                    namespaceURI = ((IdentifierNode)getExpression.expr).name;
                }
            }
        }
        return new QName(namespaceURI, qualifiedIdentifier.name);
    }

    public static String getUserNamespace(DefinitionNode definition) {
        String result = "";
        Iterator iterator = NodeMagic.getAttributes(definition).iterator();
        while (iterator.hasNext()) {
            String attribute = (String)iterator.next();
            if (attribute.equals(CONST) || attribute.equals(DYNAMIC) || attribute.equals(FINAL) || attribute.equals(INTERNAL) || attribute.equals(INTRINSIC) || attribute.equals(NATIVE) || attribute.equals(OVERRIDE) || attribute.equals(PRIVATE) || attribute.equals(PROTECTED) || attribute.equals(PROTOTYPE) || attribute.equals(PUBLIC) || attribute.equals(STATIC) || attribute.equals(VIRTUAL)) continue;
            result = attribute;
            break;
        }
        return result;
    }

    public static boolean functionIsGetter(FunctionDefinitionNode node) {
        return node.name.kind == -78;
    }

    public static boolean functionIsSetter(FunctionDefinitionNode node) {
        return node.name.kind == -97;
    }

    public static String getFunctionTypeName(FunctionDefinitionNode node) {
        return NodeMagic.getTypeName((MemberExpressionNode)node.fexpr.signature.result);
    }

    public static int getFunctionParamCount(FunctionDefinitionNode function) {
        ParameterListNode params = function.fexpr.signature.parameter;
        return params != null ? params.items.size() : 0;
    }

    public static String getFunctionParamTypeName(FunctionDefinitionNode function, int pnum) {
        ParameterListNode params = function.fexpr.signature.parameter;
        if (params == null || pnum >= params.size()) {
            return "*";
        }
        ParameterNode param = (ParameterNode)params.items.get(pnum);
        if (!$assertionsDisabled && param == null) {
            throw new AssertionError((Object)("functionDefinitionNode.params contains null entry at " + pnum));
        }
        return NodeMagic.getTypeName((MemberExpressionNode)param.type);
    }

    public static String getFunctionName(FunctionDefinitionNode functionDefinition) {
        String result = null;
        if (functionDefinition.name != null && functionDefinition.name.identifier != null && functionDefinition.name.identifier.name != null) {
            result = functionDefinition.name.identifier.name;
        }
        return result;
    }

    public static void prefixFunctionName(FunctionDefinitionNode node, String prefix) {
        if (node.name != null && node.name.identifier != null && node.name.identifier.name != null) {
            node.name.identifier.name = (prefix + node.name.identifier.name).intern();
        }
        if (node.fexpr != null && node.fexpr.internal_name != null) {
            node.fexpr.internal_name = prefix + node.fexpr.internal_name;
        }
    }

    public static String getPackageName(ClassDefinitionNode node) {
        if (node.pkgdef != null && node.pkgdef.name != null && node.pkgdef.name.id != null) {
            return node.pkgdef.name.id.toIdentifierString();
        }
        return "";
    }

    public static String getUnqualifiedClassName(ClassDefinitionNode classDefinitionNode) {
        return classDefinitionNode.name.name;
    }

    public static String getClassName(ClassDefinitionNode classDefinition) {
        if (classDefinition.cframe != null) {
            return classDefinition.cframe.name.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(NodeMagic.getPackageName(classDefinition));
        if (stringBuffer.length() > 0) {
            stringBuffer.append(":");
        }
        stringBuffer.append(NodeMagic.getUnqualifiedClassName(classDefinition));
        return stringBuffer.toString();
    }

    public static boolean isClassDefinition(MetaDataNode n) {
        return n.def instanceof ClassDefinitionNode;
    }

    public static String retrieveClassName(MetaDataNode n) {
        String className = null;
        if (NodeMagic.isClassDefinition(n)) {
            ClassDefinitionNode node = (ClassDefinitionNode)n.def;
            if (node.cframe != null) {
                className = node.cframe.name.toString().replace(':', '.');
            } else {
                StringBuffer fullyQualifiedClassName = new StringBuffer();
                fullyQualifiedClassName.append(NodeMagic.getPackageName(node));
                if (fullyQualifiedClassName.length() > 0) {
                    fullyQualifiedClassName.append('.');
                }
                fullyQualifiedClassName.append(node.name.name);
                className = fullyQualifiedClassName.toString();
            }
        }
        return className;
    }

    public static String normalizeClassName(String className) {
        int dot;
        if (className == null) {
            return null;
        }
        if (className.indexOf(58) == -1 && (dot = className.lastIndexOf(46)) != -1) {
            className = className.substring(0, dot) + ':' + className.substring(dot + 1);
        }
        return className;
    }

    public static void metaDataOnly(CompilationUnit unit, LineNumberMap map, int[] beginLines, int[] endLines) {
        int length;
        ProgramNode node = (ProgramNode)unit.getSyntaxTree();
        Context cx = node.cx;
        StatementListNode stmts = node.statements;
        int n = length = stmts.items == null ? 0 : stmts.items.size();
        block0: for (int i = 0; i < length; ++i) {
            int count;
            Node n2 = (Node)stmts.items.get(i);
            if (!(n2 instanceof DocCommentNode) && n2 instanceof MetaDataNode) continue;
            int line = map.get(cx.input.getLnNum(n2.pos()));
            int n3 = count = line == 0 ? 0 : beginLines.length;
            for (int j = 0; j < count; ++j) {
                if (line < beginLines[j] || line > endLines[j]) continue;
                OnlyMetadataIsAllowed m = new OnlyMetadataIsAllowed();
                m.setPath(cx.input.origin);
                m.setLine(cx.input.getLnNum(n2.pos()));
                ThreadLocalToolkit.log(m);
                continue block0;
            }
        }
    }

    public static IdentifierNode getIdentifier(MemberExpressionNode memberExpression) {
        IdentifierNode result = null;
        if (memberExpression.selector instanceof GetExpressionNode) {
            GetExpressionNode getExpression = (GetExpressionNode)memberExpression.selector;
            if (getExpression.expr instanceof IdentifierNode) {
                result = (IdentifierNode)getExpression.expr;
            }
        }
        return result;
    }

    private static String getTypeName(MemberExpressionNode memberExpression) {
        String result = "*";
        if (memberExpression != null && memberExpression.selector instanceof GetExpressionNode) {
            result = NodeMagic.typeNameFromSelector((GetExpressionNode)memberExpression.selector);
        }
        return result;
    }

    public static String lookupType(VariableBindingNode variableBinding) {
        String result = null;
        if (variableBinding.variable != null && variableBinding.variable.type != null && variableBinding.variable.type instanceof MemberExpressionNode) {
            GetExpressionNode getExpression;
            MemberExpressionNode memberExpression = (MemberExpressionNode)variableBinding.variable.type;
            if (memberExpression.selector != null && memberExpression.selector instanceof GetExpressionNode && (getExpression = (GetExpressionNode)memberExpression.selector).getIdentifier() != null) {
                result = getExpression.getIdentifier().name;
            }
        }
        return result;
    }

    static {
        $assertionsDisabled = !NodeMagic.class.desiredAssertionStatus();
    }

    public static class OnlyMetadataIsAllowed
    extends CompilerMessage.CompilerError {
    }
}

