/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.as3.reflect;

import flex2.compiler.as3.reflect.Attributes;
import flex2.compiler.as3.reflect.Class;
import flex2.compiler.as3.reflect.MetaData;
import flex2.compiler.as3.reflect.TypeTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import macromedia.asc.parser.DefinitionNode;
import macromedia.asc.parser.FunctionDefinitionNode;
import macromedia.asc.parser.MemberExpressionNode;
import macromedia.asc.parser.ParameterListNode;
import macromedia.asc.semantics.ReferenceValue;

public final class Method
implements flex2.compiler.abc.Method {
    private Attributes attributes;
    private String name;
    private String returnTypeName;
    private String[] parameterNames;
    private String[] parameterTypeNames;
    private boolean[] parameterHasDefault;
    private List metadata;
    private Class declaringClass;

    Method(FunctionDefinitionNode function, Class declaringClass) {
        ParameterListNode params;
        int size;
        this.name = Method.functionName(function);
        this.returnTypeName = Method.functionTypeName(function);
        if (function.attrs != null) {
            this.attributes = new Attributes(function.attrs);
        }
        int n = size = (params = function.fexpr.signature.parameter) != null ? params.items.size() : 0;
        if (size != 0) {
            this.parameterNames = new String[size];
            this.parameterTypeNames = new String[size];
            this.parameterHasDefault = new boolean[size];
            TypeTable.createParameters(params, this.parameterNames, this.parameterTypeNames, this.parameterHasDefault);
        }
        this.metadata = TypeTable.createMetaData((DefinitionNode)function);
        this.declaringClass = declaringClass;
    }

    public flex2.compiler.abc.Attributes getAttributes() {
        return this.attributes;
    }

    public String getName() {
        return this.name;
    }

    public String getReturnTypeName() {
        return this.returnTypeName;
    }

    public String[] getParameterNames() {
        return this.parameterNames;
    }

    public String[] getParameterTypeNames() {
        return this.parameterTypeNames;
    }

    public boolean[] getParameterHasDefault() {
        return this.parameterHasDefault;
    }

    public List getMetaData() {
        return this.metadata != null ? this.metadata : Collections.EMPTY_LIST;
    }

    public List getMetaData(String id) {
        if (this.metadata == null) {
            return null;
        }
        ArrayList list = null;
        int length = this.metadata.size();
        for (int i = 0; i < length; ++i) {
            if (!id.equals(((MetaData)this.metadata.get(i)).getID())) continue;
            if (list == null) {
                list = new ArrayList();
            }
            list.add(this.metadata.get(i));
        }
        return list;
    }

    public flex2.compiler.abc.Class getDeclaringClass() {
        return this.declaringClass;
    }

    public static String functionName(FunctionDefinitionNode function) {
        return function.fexpr.identifier.name;
    }

    public static String functionTypeName(FunctionDefinitionNode function) {
        if (function.fexpr.signature.type != null) {
            return TypeTable.convertName(function.fexpr.signature.type.name.toString());
        }
        if (function.fexpr.signature.result != null) {
            ReferenceValue typeref = ((MemberExpressionNode)function.fexpr.signature.result).ref;
            if (typeref != null) {
                return TypeTable.convertName(typeref);
            }
            return "*";
        }
        return "*";
    }
}

