/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.as3.binding;

import flex2.compiler.as3.binding.InterfaceInfo;
import flex2.compiler.util.MultiName;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

abstract class Info {
    private Set imports;
    private Map qualifiedImports;
    private List interfaceNames;
    private List interfaceMultiNames;
    private List interfaceInfoList;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Info() {
        this.addImport("");
    }

    void addImport(String importName) {
        if (!$assertionsDisabled && importName == null) {
            throw new AssertionError();
        }
        if (this.imports == null) {
            this.imports = new TreeSet();
        }
        this.imports.add(importName);
    }

    public void addInterfaceMultiName(String namespace, String interfaceName) {
        if (!($assertionsDisabled || namespace != null && interfaceName != null)) {
            throw new AssertionError();
        }
        if (this.interfaceMultiNames == null) {
            this.interfaceMultiNames = new ArrayList();
        }
        this.interfaceMultiNames.add(new MultiName(namespace, interfaceName));
    }

    void addInterfaceName(String interfaceName) {
        if (!$assertionsDisabled && interfaceName == null) {
            throw new AssertionError();
        }
        if (this.interfaceNames == null) {
            this.interfaceNames = new ArrayList();
        }
        this.interfaceNames.add(interfaceName);
    }

    public void addInterfaceInfo(InterfaceInfo interfaceInfo) {
        if (!$assertionsDisabled && interfaceInfo == null) {
            throw new AssertionError();
        }
        if (this.interfaceInfoList == null) {
            this.interfaceInfoList = new ArrayList();
        }
        this.interfaceInfoList.add(interfaceInfo);
    }

    void addQualifiedImport(String localPart, String namespace) {
        if (!($assertionsDisabled || localPart != null && localPart.length() > 0 && namespace != null)) {
            throw new AssertionError();
        }
        if (this.qualifiedImports == null) {
            this.qualifiedImports = new TreeMap();
        }
        this.qualifiedImports.put(localPart, namespace);
    }

    List getInterfaceMultiNames() {
        if (this.interfaceMultiNames == null) {
            this.interfaceMultiNames = new ArrayList();
            if (this.interfaceNames != null) {
                Iterator iterator = this.interfaceNames.iterator();
                while (iterator.hasNext()) {
                    String interfaceName = (String)iterator.next();
                    MultiName interfaceMultiName = this.getMultiName(interfaceName);
                    this.interfaceMultiNames.add(interfaceMultiName);
                }
            }
        }
        return this.interfaceMultiNames;
    }

    public MultiName getMultiName(String name) {
        MultiName result;
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError((Object)"Info.getMultiName called on null");
        }
        int lastIndex = name.lastIndexOf(":");
        if (lastIndex < 0) {
            lastIndex = name.lastIndexOf(".");
        }
        if (lastIndex > 0) {
            result = new MultiName(new String[]{name.substring(0, lastIndex)}, name.substring(lastIndex + 1));
        } else if (this.qualifiedImports != null && this.qualifiedImports.containsKey(name)) {
            result = new MultiName(new String[]{(String)this.qualifiedImports.get(name)}, name);
        } else if (this.imports != null) {
            String[] namespaces = new String[this.imports.size()];
            this.imports.toArray(namespaces);
            result = new MultiName(namespaces, name);
        } else {
            result = new MultiName(name);
        }
        return result;
    }

    boolean implementsInterface(String namespace, String interfaceName) {
        boolean result = false;
        if (this.interfaceInfoList != null) {
            if (!$assertionsDisabled && this.interfaceInfoList.size() != this.interfaceMultiNames.size()) {
                throw new AssertionError();
            }
            Iterator iterator = this.interfaceInfoList.iterator();
            while (iterator.hasNext()) {
                InterfaceInfo interfaceInfo = (InterfaceInfo)iterator.next();
                if (interfaceInfo.getInterfaceName().equals(namespace + ":" + interfaceName)) {
                    result = true;
                    continue;
                }
                if (interfaceInfo.extendsInterface(namespace, interfaceName)) {
                    result = true;
                    continue;
                }
                if (!interfaceInfo.implementsInterface(namespace, interfaceName)) continue;
                result = true;
            }
        }
        return result;
    }

    static {
        $assertionsDisabled = !Info.class.desiredAssertionStatus();
    }
}

