/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.as3.binding;

import flex2.compiler.CompilationUnit;
import flex2.compiler.Context;
import flex2.compiler.Source;
import flex2.compiler.as3.Extension;
import flex2.compiler.as3.binding.DataBindingDependencyEvaluator;
import flex2.compiler.as3.binding.DataBindingFirstPassEvaluator;
import flex2.compiler.as3.binding.DataBindingInfo;
import flex2.compiler.as3.reflect.TypeTable;
import flex2.compiler.common.PathResolver;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.TextFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.mxml.SourceCodeBuffer;
import flex2.compiler.mxml.gen.VelocityUtil;
import flex2.compiler.util.QName;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.compiler.util.VelocityException;
import flex2.compiler.util.VelocityManager;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.Node;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;

public final class DataBindingExtension
implements Extension {
    private static final String TEMPLATE_PATH = "flex2/compiler/as3/binding/";
    private static final String WATCHER_SETUP_UTIL_TEMPLATE = "flex2/compiler/as3/binding/WatcherSetupUtil.vm";
    private static final String DATA_BINDING_INFO_KEY = "dataBindingInfo";
    private String generatedOutputDirectory;
    private boolean showBindingWarnings;

    public DataBindingExtension(String generatedOutputDirectory, boolean showBindingWarnings) {
        this.generatedOutputDirectory = generatedOutputDirectory;
        this.showBindingWarnings = showBindingWarnings;
    }

    public void parse1(CompilationUnit compilationUnit, TypeTable typeTable) {
    }

    public void parse2(CompilationUnit compilationUnit, TypeTable typeTable) {
    }

    public void analyze1(CompilationUnit compilationUnit, TypeTable typeTable) {
    }

    public void analyze2(CompilationUnit compilationUnit, TypeTable typeTable) {
    }

    public void analyze3(CompilationUnit compilationUnit, TypeTable typeTable) {
    }

    public void analyze4(CompilationUnit compilationUnit, TypeTable typeTable) {
        Context context = compilationUnit.getContext();
        macromedia.asc.util.Context cx = (macromedia.asc.util.Context)context.getAttribute("cx");
        Node node = (Node)compilationUnit.getSyntaxTree();
        DataBindingDependencyEvaluator dataBindingDependencyEvaluator = new DataBindingDependencyEvaluator(typeTable);
        node.evaluate(cx, (Evaluator)dataBindingDependencyEvaluator);
        if (dataBindingDependencyEvaluator.getUnresolvedDependencies().size() > 0) {
            context.setAttribute("DataBindingExtension", dataBindingDependencyEvaluator.getUnresolvedDependencies());
        }
    }

    public void generate(CompilationUnit compilationUnit, TypeTable typeTable) {
        Context context = compilationUnit.getContext();
        macromedia.asc.util.Context cx = (macromedia.asc.util.Context)context.getAttribute("cx");
        Node node = (Node)compilationUnit.getSyntaxTree();
        DataBindingFirstPassEvaluator dataBindingFirstPassEvaluator = new DataBindingFirstPassEvaluator(compilationUnit, typeTable, this.showBindingWarnings);
        node.evaluate(cx, (Evaluator)dataBindingFirstPassEvaluator);
        List dataBindingInfoList = dataBindingFirstPassEvaluator.getDataBindingInfoList();
        if (dataBindingInfoList.size() > 0) {
            Map generatedSources = this.generateWatcherSetupUtilClasses(compilationUnit, dataBindingInfoList);
            compilationUnit.addGeneratedSources(generatedSources);
        }
    }

    private Source createSource(String fileName, long lastModified, PathResolver resolver, SourceCodeBuffer sourceCodeBuffer) {
        Source result = null;
        if (sourceCodeBuffer.getBuffer() != null) {
            String sourceCode = sourceCodeBuffer.toString();
            if (this.generatedOutputDirectory != null) {
                try {
                    FileUtil.writeFile(this.generatedOutputDirectory + File.separatorChar + fileName, sourceCode);
                }
                catch (IOException e) {
                    ThreadLocalToolkit.log(new VelocityException.UnableToWriteGeneratedFile(fileName, e.getMessage()));
                }
            }
            TextFile generatedFile = new TextFile(sourceCode, fileName, null, "text/as", System.currentTimeMillis());
            result = new Source((VirtualFile)generatedFile, "", null, false, false, false);
            result.setPathResolver(resolver);
        }
        return result;
    }

    private Source generateWatcherSetupUtil(CompilationUnit compilationUnit, DataBindingInfo dataBindingInfo) {
        Template template;
        try {
            template = VelocityManager.getTemplate(WATCHER_SETUP_UTIL_TEMPLATE);
        }
        catch (Exception exception) {
            ThreadLocalToolkit.log(new VelocityException.TemplateNotFound(WATCHER_SETUP_UTIL_TEMPLATE));
            return null;
        }
        String className = dataBindingInfo.getWatcherSetupUtilClassName();
        String generatedName = className.replace('.', File.separatorChar) + ".as";
        SourceCodeBuffer out = new SourceCodeBuffer();
        try {
            VelocityUtil util = new VelocityUtil(TEMPLATE_PATH, false, out, null);
            VelocityContext velocityContext = VelocityManager.getCodeGenContext(util);
            velocityContext.put(DATA_BINDING_INFO_KEY, (Object)dataBindingInfo);
            template.merge((org.apache.velocity.context.Context)velocityContext, (Writer)out);
        }
        catch (Exception e) {
            ThreadLocalToolkit.log(new VelocityException.GenerateException(compilationUnit.getSource().getRelativePath(), e.getLocalizedMessage()));
            return null;
        }
        return this.createSource(generatedName, compilationUnit.getSource().getLastModified(), compilationUnit.getSource().getPathResolver(), out);
    }

    public Map generateWatcherSetupUtilClasses(CompilationUnit compilationUnit, List dataBindingInfoList) {
        HashMap<QName, Source> extraSources = new HashMap<QName, Source>();
        Iterator iterator = dataBindingInfoList.iterator();
        while (iterator.hasNext()) {
            DataBindingInfo dataBindingInfo = (DataBindingInfo)iterator.next();
            QName classQName = new QName(dataBindingInfo.getWatcherSetupUtilClassName());
            extraSources.put(classQName, this.generateWatcherSetupUtil(compilationUnit, dataBindingInfo));
        }
        return extraSources;
    }
}

