/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.as3.binding;

import flex2.compiler.as3.binding.BindableInfo;
import flex2.compiler.as3.genext.GenerativeFirstPassEvaluator;
import flex2.compiler.as3.reflect.NodeMagic;
import flex2.compiler.as3.reflect.TypeTable;
import flex2.compiler.mxml.lang.StandardDefs;
import flex2.compiler.mxml.lang.TextParser;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.QName;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.DefinitionNode;
import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.FunctionDefinitionNode;
import macromedia.asc.parser.MetaDataNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.ProgramNode;
import macromedia.asc.parser.VariableBindingNode;
import macromedia.asc.parser.VariableDefinitionNode;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.Context;

public class BindableFirstPassEvaluator
extends GenerativeFirstPassEvaluator {
    private static final int BINDABLE_NONE = 0;
    private static final int BINDABLE_USER = 1;
    private static final int BINDABLE_CODEGEN_PROP = 2;
    private static final int BINDABLE_CODEGEN_CLASS = 3;
    private final Set metaData;
    private Set bindableClasses;
    private Set managedClasses;
    private Set evaluatedClasses;
    private Map classMap;
    private ClassDefinitionNode currentClassNode = null;
    private BindableInfo bindableInfo;
    private Map visitedProps;
    private boolean inFunction = false;

    public BindableFirstPassEvaluator(TypeTable typeTable, Set metaData) {
        super(typeTable);
        this.metaData = metaData;
        this.classMap = new LinkedHashMap();
        this.evaluatedClasses = new HashSet();
    }

    public Value evaluate(Context context, ProgramNode programNode) {
        MetaDataNode metaDataNode;
        Iterator iter = this.metaData.iterator();
        while (iter.hasNext()) {
            metaDataNode = (MetaDataNode)iter.next();
            if (!"Managed".equals(metaDataNode.id) || !(metaDataNode.def instanceof ClassDefinitionNode)) continue;
            this.registerManagedClass(metaDataNode.def);
        }
        iter = this.metaData.iterator();
        while (iter.hasNext()) {
            metaDataNode = (MetaDataNode)iter.next();
            if (!"Bindable".equals(metaDataNode.id) || !(metaDataNode.def instanceof ClassDefinitionNode)) continue;
            if (this.isManagedClass(metaDataNode.def)) {
                context.localizedWarning2(metaDataNode.pos(), (Object)new ClassBindableUnnecessaryOnManagedClass());
                continue;
            }
            if (BindableFirstPassEvaluator.getEventName(metaDataNode, context) != null) continue;
            this.registerBindableClass((ClassDefinitionNode)metaDataNode.def);
        }
        return super.evaluate(context, programNode);
    }

    public Value evaluate(Context context, MetaDataNode metaDataNode) {
        if ("Bindable".equals(metaDataNode.id) && !(metaDataNode.def instanceof ClassDefinitionNode)) {
            if (metaDataNode.def instanceof FunctionDefinitionNode) {
                FunctionDefinitionNode node = (FunctionDefinitionNode)metaDataNode.def;
                if (BindableFirstPassEvaluator.getEventName(metaDataNode, context) == null) {
                    if (this.inManagedClass()) {
                        context.localizedWarning2(node.pos(), (Object)new PropertyBindableUnnecessaryOnManagedClass());
                    } else if (this.inBindableClass()) {
                        context.localizedWarning2(node.pos(), (Object)new PropertyBindableUnnecessaryOnBindableClass());
                    } else {
                        boolean isGetter = NodeMagic.functionIsGetter(node);
                        if (isGetter || NodeMagic.functionIsSetter(node)) {
                            if (this.checkBindableGetterSetter(context, node, false, false)) {
                                this.registerBindableGetterSetter(context, node, true, isGetter);
                            }
                        } else {
                            context.localizedWarning2(node.pos(), (Object)new BindableFunctionRequiresEventName());
                        }
                    }
                } else if (NodeMagic.functionIsGetter(node) || NodeMagic.functionIsSetter(node)) {
                    String name = NodeMagic.getFunctionName(node);
                    if (this.getVisitedGetterSetterBindType(name) == 3) {
                        QName qname = new QName(NodeMagic.getUserNamespace((DefinitionNode)node), name);
                        this.unregisterBindableAccessor(qname);
                    }
                    this.registerVisitedGetterSetter(name, 1);
                }
            } else if (metaDataNode.def instanceof VariableDefinitionNode) {
                VariableDefinitionNode node = (VariableDefinitionNode)metaDataNode.def;
                if (this.inFunction) {
                    context.localizedError2(node.pos(), (Object)new BindableNotAllowedInsideFunctionDefinition());
                } else if (BindableFirstPassEvaluator.getEventName(metaDataNode, context) == null) {
                    if (this.inManagedClass()) {
                        context.localizedWarning2(node.pos(), (Object)new PropertyBindableUnnecessaryOnManagedClass());
                    } else if (this.inBindableClass()) {
                        context.localizedWarning2(node.pos(), (Object)new PropertyBindableUnnecessaryOnBindableClass());
                    } else if (this.checkBindableVariable(context, node, false, false)) {
                        this.registerBindableVariable(context, node, true);
                    }
                }
            } else {
                context.localizedError2(metaDataNode.pos(), (Object)new BindableNotAllowedHere());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value evaluate(Context context, ClassDefinitionNode node) {
        if (!this.evaluatedClasses.contains(node)) {
            this.evaluatedClasses.add(node);
            try {
                this.setCurrentClass(context, node);
                if (node.statements != null) {
                    if (node.instanceinits != null) {
                        Iterator iterator = node.instanceinits.iterator();
                        while (iterator.hasNext()) {
                            Node instanceinit = (Node)iterator.next();
                            instanceinit.evaluate(context, (Evaluator)this);
                        }
                    }
                    node.statements.evaluate(context, (Evaluator)this);
                }
                if (this.bindableInfo != null) {
                    String className = NodeMagic.getClassName(node);
                    this.bindableInfo.setClassName(className);
                    this.classMap.put(className, this.bindableInfo);
                    NodeMagic.addImport(context, node, NameFormatter.toDot(StandardDefs.CLASS_EVENT));
                    NodeMagic.addImport(context, node, NameFormatter.toDot(StandardDefs.CLASS_EVENTDISPATCHER));
                    NodeMagic.addImport(context, node, NameFormatter.toDot(StandardDefs.INTERFACE_IEVENTDISPATCHER));
                    NodeMagic.addImport(context, node, NameFormatter.toDot(StandardDefs.CLASS_PROPERTYCHANGEEVENT));
                    NodeMagic.addImport(context, node, NameFormatter.toDot(StandardDefs.CLASS_BINDINGMANAGER));
                    NodeMagic.addImport(context, node, NameFormatter.toDot(StandardDefs.INTERFACE_IPROPERTYCHANGENOTIFIER));
                    NodeMagic.addImport(context, node, NameFormatter.toDot(StandardDefs.CLASS_OBJECTPROXY));
                    NodeMagic.addImport(context, node, NameFormatter.toDot(StandardDefs.CLASS_UIDUTIL));
                }
            }
            finally {
                this.setCurrentClass(context, null);
            }
        }
        return null;
    }

    public Value evaluate(Context context, FunctionDefinitionNode node) {
        boolean isGetter;
        String name = NodeMagic.getFunctionName(node);
        if (this.inBindableClass() && ((isGetter = NodeMagic.functionIsGetter(node)) || NodeMagic.functionIsSetter(node)) && this.getVisitedGetterSetterBindType(name) != 1) {
            this.registerBindableGetterSetter(context, node, false, isGetter);
        }
        this.inFunction = true;
        super.evaluate(context, node);
        this.inFunction = false;
        return null;
    }

    public Value evaluate(Context context, VariableDefinitionNode node) {
        QName qname = new QName(NodeMagic.getUserNamespace((DefinitionNode)node), NodeMagic.getVariableName(node));
        if (this.inBindableClass() && !this.inFunction && !this.isBindableAccessor(qname) && this.checkBindableVariable(context, node, true, true)) {
            this.registerBindableVariable(context, node, false);
        }
        return null;
    }

    private boolean checkBindableVariable(Context context, VariableDefinitionNode def, boolean quiet, boolean publicOnly) {
        Object item;
        if (!this.inClass()) {
            if (!quiet) {
                context.localizedError2(def.pos(), (Object)new BindableNotAllowedOnGlobalOrPackageVariables());
            }
            return false;
        }
        if (def.list != null && def.list.items != null && def.list.items.size() > 0 && (item = def.list.items.get(0)) instanceof VariableBindingNode) {
            VariableBindingNode variableBinding = (VariableBindingNode)item;
            if (variableBinding.kind == -64) {
                if (!quiet) {
                    context.localizedError2(def.pos(), (Object)new BindableNotAllowedOnConstMemberVariables());
                }
                return false;
            }
        }
        if (def.attrs != null && def.attrs.hasAttribute("static")) {
            if (!quiet) {
                context.localizedError2(def.pos(), (Object)new BindableNotAllowedOnStaticMemberVariables());
            }
            return false;
        }
        if (publicOnly && (def.attrs == null || !def.attrs.hasAttribute("public"))) {
            if (!quiet) {
                context.localizedError2(def.pos(), (Object)new BindableNotAllowedHereOnNonPublicMemberVariables());
            }
            return false;
        }
        return true;
    }

    private boolean checkBindableGetterSetter(Context context, FunctionDefinitionNode def, boolean quiet, boolean publicOnly) {
        if (!this.inClass()) {
            if (!quiet) {
                context.localizedError2(def.pos(), (Object)new BindableNotAllowedOnGlobalOrPackageFunctions());
            }
            return false;
        }
        if (def.attrs != null && def.attrs.hasAttribute("static")) {
            if (!quiet) {
                context.localizedError2(def.pos(), (Object)new BindableNotAllowedOnStaticFunctions());
            }
            return false;
        }
        if (publicOnly && (def.attrs == null || !def.attrs.hasAttribute("public"))) {
            if (!quiet) {
                context.localizedError2(def.pos(), (Object)new BindableNotAllowedHereOnNonPublicFunctions());
            }
            return false;
        }
        return true;
    }

    private void setCurrentClass(Context context, ClassDefinitionNode node) {
        this.currentClassNode = node;
        this.visitedProps = null;
        this.bindableInfo = this.isBindableClass((DefinitionNode)this.currentClassNode) ? new BindableInfo(context, this.typeTable.getSymbolTable()) : null;
    }

    private boolean inClass() {
        return this.currentClassNode != null;
    }

    private boolean inManagedClass() {
        return this.inClass() && this.isManagedClass((DefinitionNode)this.currentClassNode);
    }

    private boolean inBindableClass() {
        return this.inClass() && this.isBindableClass((DefinitionNode)this.currentClassNode);
    }

    private void registerBindableClass(ClassDefinitionNode def) {
        (this.bindableClasses != null ? this.bindableClasses : (this.bindableClasses = new HashSet<ClassDefinitionNode>())).add(def);
    }

    private boolean isBindableClass(DefinitionNode def) {
        return this.bindableClasses != null && this.bindableClasses.contains(def);
    }

    private void registerBindableVariable(Context context, VariableDefinitionNode node, boolean propLevel) {
        if (this.bindableInfo == null) {
            this.bindableInfo = new BindableInfo(context, this.typeTable.getSymbolTable());
        }
        this.bindableInfo.addAccessorVariable(node, propLevel);
    }

    private void registerBindableGetterSetter(Context context, FunctionDefinitionNode node, boolean propLevel, boolean isGetter) {
        if (this.bindableInfo == null) {
            this.bindableInfo = new BindableInfo(context, this.typeTable.getSymbolTable());
        }
        this.bindableInfo.addAccessorFunction(node, propLevel, isGetter);
        this.registerVisitedGetterSetter(NodeMagic.getFunctionName(node), propLevel ? 2 : 3);
    }

    private void unregisterBindableAccessor(QName qname) {
        if (this.bindableInfo != null) {
            this.bindableInfo.removeAccessor(qname);
        }
    }

    private boolean isBindableAccessor(QName qname) {
        return this.bindableInfo != null && this.bindableInfo.hasAccessor(qname);
    }

    private void registerManagedClass(DefinitionNode def) {
        (this.managedClasses != null ? this.managedClasses : (this.managedClasses = new HashSet<DefinitionNode>())).add(def);
    }

    private boolean isManagedClass(DefinitionNode def) {
        return this.managedClasses != null && this.managedClasses.contains(def);
    }

    private void registerVisitedGetterSetter(String name, int bindType) {
        (this.visitedProps != null ? this.visitedProps : (this.visitedProps = new HashMap<String, Integer>())).put(name, new Integer(bindType));
    }

    private int getVisitedGetterSetterBindType(String name) {
        return this.visitedProps == null || !this.visitedProps.containsKey(name) ? 0 : (Integer)this.visitedProps.get(name);
    }

    public Map getClassMap() {
        return this.classMap != null ? this.classMap : Collections.EMPTY_MAP;
    }

    public boolean makeSecondPass() {
        return this.classMap != null && this.classMap.size() > 0;
    }

    private static String getEventName(MetaDataNode node, Context context) {
        String eventName = node.getValue("event");
        if (eventName == null && node.count() == 1) {
            eventName = node.getValue(0);
        }
        if (eventName != null && !TextParser.isValidIdentifier(eventName)) {
            context.localizedError2(node.pos(), (Object)new EventNameNotValid());
        }
        return eventName;
    }

    public static class EventNameNotValid
    extends CompilerMessage.CompilerError {
    }

    public class BindableNotAllowedHereOnNonPublicFunctions
    extends CompilerMessage.CompilerError {
    }

    public class BindableNotAllowedOnStaticFunctions
    extends CompilerMessage.CompilerError {
    }

    public class BindableNotAllowedOnGlobalOrPackageFunctions
    extends CompilerMessage.CompilerError {
    }

    public class BindableNotAllowedHereOnNonPublicMemberVariables
    extends CompilerMessage.CompilerError {
    }

    public class BindableNotAllowedOnStaticMemberVariables
    extends CompilerMessage.CompilerError {
    }

    public class BindableNotAllowedOnConstMemberVariables
    extends CompilerMessage.CompilerError {
    }

    public class BindableNotAllowedOnGlobalOrPackageVariables
    extends CompilerMessage.CompilerError {
    }

    public class BindableNotAllowedHere
    extends CompilerMessage.CompilerError {
    }

    public class BindableNotAllowedInsideFunctionDefinition
    extends CompilerMessage.CompilerError {
    }

    public class BindableFunctionRequiresEventName
    extends CompilerMessage.CompilerWarning {
    }

    public class PropertyBindableUnnecessaryOnBindableClass
    extends CompilerMessage.CompilerWarning {
    }

    public class PropertyBindableUnnecessaryOnManagedClass
    extends CompilerMessage.CompilerWarning {
    }

    public class ClassBindableUnnecessaryOnManagedClass
    extends CompilerMessage.CompilerWarning {
    }
}

